
-- Copyright (c) 2003, 2008-2012, Oracle and/or its affiliates. All rights reserved.
--
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; version 2 of the License.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

-- DO NOT EDIT THIS FILE. It is generated automatically.

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

set names 'utf8';

set sql_log_bin = 0;

use mysql;
delete from help_topic;
delete from help_category;
delete from help_keyword;
delete from help_relation;

lock tables help_topic write, help_category write, help_keyword write, help_relation write;
insert into help_category (help_category_id,name,parent_category_id,url) values (1,'Geographic',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (2,'Polygon Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (3,'WKT',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (4,'Numeric Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (5,'Plugins',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (6,'MBR',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (7,'Control Flow Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (8,'Transactions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (9,'Help Metadata',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (10,'Account Management',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (11,'Point Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (12,'Encryption Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (13,'LineString Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (14,'Miscellaneous Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (15,'Logical Operators',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (16,'Functions and Modifiers for Use with GROUP BY',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (17,'Information Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (18,'Comparison Operators',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (19,'Bit Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (20,'Table Maintenance',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (21,'User-Defined Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (22,'Data Types',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (23,'Compound Statements',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (24,'Geometry Constructors',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (25,'GeometryCollection Properties',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (26,'Administration',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (27,'Data Manipulation',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (28,'Utility',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (29,'Language Structure',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (30,'Geometry Relations',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (31,'Date and Time Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (32,'WKB',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (33,'Procedures',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (34,'Geographic Features',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (35,'Contents',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (36,'Geometry Properties',34,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (37,'String Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (38,'Functions',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (39,'Data Definition',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (40,'Sequences',35,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (41,'JSON Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (42,'Window Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (43,'Spider Functions',38,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (44,'Dynamic Column Functions',38,'');

insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (1,9,'HELP_DATE','This help information was generated from the MariaDB Knowledge Base\non 22 July 2019.','','');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (2,2,'AREA','A synonym for ST_AREA.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/polygon-properties-area/','','https://mariadb.com/kb/en/library/polygon-properties-area/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (3,2,'CENTROID','A synonym for ST_CENTROID.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/centroid/','','https://mariadb.com/kb/en/library/centroid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (4,2,'ExteriorRing','A synonym for ST_ExteriorRing.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/polygon-properties-exteriorring/','','https://mariadb.com/kb/en/library/polygon-properties-exteriorring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (5,2,'InteriorRingN','A synonym for ST_InteriorRingN.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/polygon-properties-interiorringn/','','https://mariadb.com/kb/en/library/polygon-properties-interiorringn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (6,2,'NumInteriorRings','A synonym for ST_NumInteriorRings.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/polygon-properties-numinteriorrings/','','https://mariadb.com/kb/en/library/polygon-properties-numinteriorrings/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (7,2,'ST_AREA','Syntax\n------ \nST_Area(poly)\nArea(poly)\n \nDescription\n----------- \nReturns as a double-precision number the area of the Polygon\nvalue poly, as measured in its spatial reference system.\n \nST_Area() and Area() are synonyms.\n \nExamples\n-------- \nSET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1\n1))\';\n \nSELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n| 4 |\n+---------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_area/','','https://mariadb.com/kb/en/library/st_area/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (8,2,'ST_CENTROID','Syntax\n------ \nST_Centroid(mpoly)\nCentroid(mpoly)\n \nDescription\n----------- \nReturns a point reflecting the mathematical centroid\n(geometric center) for the MultiPolygon mpoly. The resulting\npoint will not necessarily be on the MultiPolygon. \n \nST_Centroid() and Centroid() are synonyms.\n \nExamples\n-------- \nSET @poly = ST_GeomFromText(\'POLYGON((0 0,20 0,20 20,0 20,0\n0))\');\nSELECT ST_AsText(ST_Centroid(@poly)) AS center;\n \n+--------------+\n| center |\n+--------------+\n| POINT(10 10) |\n+--------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_centroid/','','https://mariadb.com/kb/en/library/st_centroid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (9,2,'ST_ExteriorRing','Syntax\n------ \nST_ExteriorRing(poly)\nExteriorRing(poly)\n \nDescription\n----------- \nReturns the exterior ring of the Polygon value poly as a\nLineString.\n \nST_ExteriorRing() and ExteriorRing() are synonyms.\n \nExamples\n-------- \nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2\n1,1 1))\';\n \nSELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0) |\n+-------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_exteriorring/','','https://mariadb.com/kb/en/library/st_exteriorring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (10,2,'ST_InteriorRingN','Syntax\n------ \nST_InteriorRingN(poly,N)\nInteriorRingN(poly,N)\n \nDescription\n----------- \nReturns the N-th interior ring for the Polygon value poly as\na LineString. Rings are numbered beginning with 1.\n \nST_InteriorRingN() and InteriorRingN() are synonyms.\n \nExamples\n-------- \nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2\n1,1 1))\';\n \nSELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1) |\n+----------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_interiorringn/','','https://mariadb.com/kb/en/library/st_interiorringn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (11,2,'ST_NumInteriorRings','Syntax\n------ \nST_NumInteriorRings(poly)\nNumInteriorRings(poly)\n \nDescription\n----------- \nReturns an integer containing the number of interior rings\nin the Polygon value poly.\n \nNote that according the the OpenGIS standard, a POLYGON\nshould have exactly one ExteriorRing and all other rings\nshould lie within that ExteriorRing and thus be the\nInteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several\n\'ExteriorRings\'. In the case of there being multiple,\nnon-overlapping exterior rings ST_NumInteriorRings() will\nreturn 1.\n \nST_NumInteriorRings() and NumInteriorRings() are synonyms.\n \nExamples\n-------- \nSET @poly = \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2\n1,1 1))\';\n \nSELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n| 1 |\n+---------------------------------------+\n \nNon-overlapping \'polygon\':\n \nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10\n0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n \n+------------------+\n| NumInteriorRings |\n+------------------+\n| 1 |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_numinteriorrings/','','https://mariadb.com/kb/en/library/st_numinteriorrings/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (12,3,'WKT Definition','Description\n----------- \nThe Well-Known Text (WKT) representation of Geometry is\ndesigned to exchange geometry data in ASCII form. Examples\nof the basic geometry types include:\n \nGeometry Types | \n \nPOINT | \n \nLINESTRING | \n \nPOLYGON | \n \nMULTIPOINT | \n \nMULTILINESTRING | \n \nMULTIPOLYGON | \n \nGEOMETRYCOLLECTION | \n \nGEOMETRY | \n \n\n\nURL: https://mariadb.com/kb/en/library/wkt-definition/','','https://mariadb.com/kb/en/library/wkt-definition/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (13,3,'AsText','A synonym for ST_AsText().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-astext/','','https://mariadb.com/kb/en/library/wkt-astext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (14,3,'AsWKT','A synonym for ST_AsText().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-aswkt/','','https://mariadb.com/kb/en/library/wkt-aswkt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (15,3,'GeomCollFromText','A synonym for ST_GeomCollFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-geomcollfromtext/','','https://mariadb.com/kb/en/library/wkt-geomcollfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (16,3,'GeometryCollectionFromText','A synonym for ST_GeomCollFromText.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/geometrycollectionfromtext/','','https://mariadb.com/kb/en/library/geometrycollectionfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (17,3,'GeometryFromText','A synonym for ST_GeomFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/geometryfromtext/','','https://mariadb.com/kb/en/library/geometryfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (18,3,'GeomFromText','A synonym for ST_GeomFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-geomfromtext/','','https://mariadb.com/kb/en/library/wkt-geomfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (19,3,'LineFromText','A synonym for ST_LineFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-linefromtext/','','https://mariadb.com/kb/en/library/wkt-linefromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (20,3,'LineStringFromText','A synonym for ST_LineFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/linestringfromtext/','','https://mariadb.com/kb/en/library/linestringfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (21,3,'MLineFromText','Syntax\n------ \nMLineFromText(wkt[,srid])\nMultiLineStringFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a MULTILINESTRING value using its WKT\nrepresentation and SRID.\n \nMLineFromText() and MultiLineStringFromText() are synonyms.\n \nExamples\n-------- \nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\n \nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10\n0),(16 0,16 23,16 48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2),\nPoint(3, 5)), LineString(Point(2, 5), Point(5, 8), Point(21,\n7))))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mlinefromtext/','','https://mariadb.com/kb/en/library/mlinefromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (22,3,'MPointFromText','Syntax\n------ \nMPointFromText(wkt[,srid])\nMultiPointFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a MULTIPOINT value using its WKT representation\nand SRID.\n \nMPointFromText() and MultiPointFromText() are synonyms.\n \nExamples\n-------- \nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\n \nINSERT INTO gis_multi_point VALUES\n (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20\n20)\')),\n (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4,\n10)))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mpointfromtext/','','https://mariadb.com/kb/en/library/mpointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (23,3,'MPolyFromText','Syntax\n------ \nMPolyFromText(wkt[,srid])\nMultiPolygonFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a MULTIPOLYGON value using its WKT representation\nand SRID.\n \nMPolyFromText() and MultiPolygonFromText() are synonyms.\n \nExamples\n-------- \nCREATE TABLE gis_multi_polygon (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\n \nINSERT INTO gis_multi_polygon VALUES\n (MultiPolygonFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84\n42,28 26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67\n13,59 13,59 18)))\')),\n (MPolyFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84 42,28\n26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67 13,59\n13,59 18)))\')),\n (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(LineString(Point(0,\n3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mpolyfromtext/','','https://mariadb.com/kb/en/library/mpolyfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (24,3,'MultiLineStringFromText','A synonym for MLineFromText.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/multilinestringfromtext/','','https://mariadb.com/kb/en/library/multilinestringfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (25,3,'MultiPointFromText','A synonym for MPointFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/multipointfromtext/','','https://mariadb.com/kb/en/library/multipointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (26,3,'MultiPolygonFromText','A synonym for MPolyFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/multipolygonfromtext/','','https://mariadb.com/kb/en/library/multipolygonfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (27,3,'PointFromText','A synonym for ST_PointFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-pointfromtext/','','https://mariadb.com/kb/en/library/wkt-pointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (28,3,'PolyFromText','A synonym for ST_PolyFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/wkt-polyfromtext/','','https://mariadb.com/kb/en/library/wkt-polyfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (29,3,'PolygonFromText','A synonym for ST_PolyFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/polygonfromtext/','','https://mariadb.com/kb/en/library/polygonfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (30,3,'ST_AsText','Syntax\n------ \nST_AsText(g)\nAsText(g)\nST_AsWKT(g)\nAsWKT(g)\n \nDescription\n----------- \nConverts a value in internal geometry format to its WKT\nrepresentation and returns the string result.\n \nST_AsText(), AsText(), ST_AsWKT() and AsWKT() are all\nsynonyms.\n \nExamples\n-------- \nSET @g = \'LineString(1 1,4 4,6 6)\';\n \nSELECT ST_AsText(ST_GeomFromText(@g));\n+--------------------------------+\n| ST_AsText(ST_GeomFromText(@g)) |\n+--------------------------------+\n| LINESTRING(1 1,4 4,6 6) |\n+--------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_astext/','','https://mariadb.com/kb/en/library/st_astext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (31,3,'ST_ASWKT','A synonym for ST_ASTEXT().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_aswkt/','','https://mariadb.com/kb/en/library/st_aswkt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (32,3,'ST_GeomCollFromText','Syntax\n------ \nST_GeomCollFromText(wkt[,srid])\nST_GeometryCollectionFromText(wkt[,srid])\nGeomCollFromText(wkt[,srid])\nGeometryCollectionFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a GEOMETRYCOLLECTION value using its WKT \nrepresentation and SRID.\n \nST_GeomCollFromText(), ST_GeometryCollectionFromText(),\nGeomCollFromText() and GeometryCollectionFromText() are all\nsynonyms.\n \nExample\n \nCREATE TABLE gis_geometrycollection (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\n \nINSERT INTO gis_geometrycollection VALUES\n (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0),\nLINESTRING(0 0,10 10))\')),\n (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n (GeomFromText(\'GeometryCollection()\')),\n (GeomFromText(\'GeometryCollection EMPTY\'));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_geomcollfromtext/','','https://mariadb.com/kb/en/library/st_geomcollfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (33,3,'ST_GeometryCollectionFromText','A synonym for ST_GeomCollFromText.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/st_geometrycollectionfromtext/','','https://mariadb.com/kb/en/library/st_geometrycollectionfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (34,3,'ST_GeometryFromText','A synonym for ST_GeomFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_geometryfromtext/','','https://mariadb.com/kb/en/library/st_geometryfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (35,3,'ST_GeomFromText','Syntax\n------ \nST_GeomFromText(wkt[,srid])\nST_GeometryFromText(wkt[,srid])\nGeomFromText(wkt[,srid])\nGeometryFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a geometry value of any type using its WKT\nrepresentation and SRID.\n \nGeomFromText(), GeometryFromText(), ST_GeomFromText() and\nST_GeometryFromText() are all synonyms.\n \nExample\n \nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7\n2,1 1))\');\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_geomfromtext/','','https://mariadb.com/kb/en/library/st_geomfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (36,3,'ST_LineFromText','Syntax\n------ \nST_LineFromText(wkt[,srid])\nST_LineStringFromText(wkt[,srid])\nLineFromText(wkt[,srid])\nLineStringFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a LINESTRING value using its WKT representation\nand SRID.\n \nST_LineFromText(), ST_LineStringFromText(),\nST_LineFromText() and ST_LineStringFromText() are all\nsynonyms.\n \nExamples\n-------- \nCREATE TABLE gis_line (g LINESTRING);\nSHOW FIELDS FROM gis_line;\n \nINSERT INTO gis_line VALUES\n (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10\n10)\')),\n (LineStringFromWKB(AsWKB(LineString(Point(10, 10),\nPoint(40, 10)))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_linefromtext/','','https://mariadb.com/kb/en/library/st_linefromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (37,3,'ST_LineStringFromText','A synonym for ST_LineFromText.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/st_linestringfromtext/','','https://mariadb.com/kb/en/library/st_linestringfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (38,3,'ST_PointFromText','Syntax\n------ \nST_PointFromText(wkt[,srid])\nPointFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a POINT value using its WKT representation and\nSRID.\n \nST_PointFromText() and PointFromText() are synonyms.\n \nExamples\n-------- \nCREATE TABLE gis_point (g POINT);\nSHOW FIELDS FROM gis_point;\n \nINSERT INTO gis_point VALUES\n (PointFromText(\'POINT(10 10)\')),\n (PointFromText(\'POINT(20 10)\')),\n (PointFromText(\'POINT(20 20)\')),\n (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_pointfromtext/','','https://mariadb.com/kb/en/library/st_pointfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (39,3,'ST_PolyFromText','Syntax\n------ \nST_PolyFromText(wkt[,srid])\nST_PolygonFromText(wkt[,srid])\nPolyFromText(wkt[,srid])\nPolygonFromText(wkt[,srid])\n \nDescription\n----------- \nConstructs a POLYGON value using its WKT representation and\nSRID.\n \nST_PolyFromText(), ST_PolygonFromText(), PolyFromText() and\nST_PolygonFromText() are all synonyms.\n \nExamples\n-------- \nCREATE TABLE gis_polygon (g POLYGON);\nINSERT INTO gis_polygon VALUES\n (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10\n10))\')),\n (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10\n10,20 10,20 20,10 20,10 10))\'));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_polyfromtext/','','https://mariadb.com/kb/en/library/st_polyfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (40,3,'ST_PolygonFromText','A synonym for ST_PolyFromText.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_polygonfromtext/','','https://mariadb.com/kb/en/library/st_polygonfromtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (41,4,'Addition Operator (+)','Syntax\n------ \n+\n \nDescription\n----------- \nAddition.\n \nIf both operands are integers, the result is calculated with\nBIGINT precision. If either integer is unsigned, the result\nis also an unsigned integer.\n \nFor real or string operands, the operand with the highest\nprecision determines the result precision.\n \nExamples\n-------- \nSELECT 3+5;\n \n+-----+\n| 3+5 |\n+-----+\n| 8 |\n+-----+\n \n\n\nURL: https://mariadb.com/kb/en/library/addition-operator/','','https://mariadb.com/kb/en/library/addition-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (42,4,'Subtraction Operator (-)','Syntax\n------ \n-\n \nDescription\n----------- \nSubtraction. The operator is also used as the unary minus\nfor changing sign.\n \nIf both operands are integers, the result is calculated with\nBIGINT precision. If either integer is unsigned, the result\nis also an unsigned integer, unless the\nNO_UNSIGNED_SUBTRACTION SQL_MODE is enabled, in which case\nthe result is always signed.\n \nFor real or string operands, the operand with the highest\nprecision determines the result precision.\n \nExamples\n-------- \nSELECT 96-9;\n \n+------+\n| 96-9 |\n+------+\n| 87 |\n+------+\n \nSELECT 15-17;\n \n+-------+\n| 15-17 |\n+-------+\n| -2 |\n+-------+\n \nSELECT 3.66 + 1.333;\n \n+--------------+\n| 3.66 + 1.333 |\n+--------------+\n| 4.993 |\n+--------------+\n \nUnary minus:\n \n SELECT - (3+5);\n+---------+\n| - (3+5) |\n+---------+\n| -8 |\n+---------+\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/subtraction-operator-/','','https://mariadb.com/kb/en/library/subtraction-operator-/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (43,4,'Division Operator (/)','Syntax\n------ \n/\n \nDescription\n----------- \nDivision operator. Dividing by zero will return NULL. By\ndefault, returns four digits after the decimal. This is\ndetermined by the server system variable\ndiv_precision_increment which by default is four. It can be\nset from 0 to 30.\n \nDividing by zero returns NULL. If the\nERROR_ON_DIVISION_BY_ZERO SQL_MODE is used (the default\nsince MariaDB 10.2.4), a division by zero also produces a\nwarning.\n \nExamples\n-------- \nSELECT 4/5;\n \n+--------+\n| 4/5 |\n+--------+\n| 0.8000 |\n+--------+\n \nSELECT 300/(2-2);\n+-----------+\n| 300/(2-2) |\n+-----------+\n| NULL |\n+-----------+\n \nSELECT 300/7;\n \n+---------+\n| 300/7 |\n+---------+\n| 42.8571 |\n+---------+\n \nChanging div_precision_increment for the session from the\ndefault of four to six:\n \nSET div_precision_increment = 6;\n \nSELECT 300/7;\n \n+-----------+\n| 300/7 |\n+-----------+\n| 42.857143 |\n+-----------+\n \nSELECT 300/7;\n \n+-----------+\n| 300/7 |\n+-----------+\n| 42.857143 |\n+-----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/division-operator/','','https://mariadb.com/kb/en/library/division-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (44,4,'Multiplication Operator (*)','Syntax\n------ \n*\n \nDescription\n----------- \nMultiplication operator.\n \nExamples\n-------- \nSELECT 7*6;\n \n+-----+\n| 7*6 |\n+-----+\n| 42 |\n+-----+\n \nSELECT 1234567890*9876543210;\n \n+-----------------------+\n| 1234567890*9876543210 |\n+-----------------------+\n| -6253480962446024716 |\n+-----------------------+\n \nSELECT 18014398509481984*18014398509481984.0;\n \n+---------------------------------------+\n| 18014398509481984*18014398509481984.0 |\n+---------------------------------------+\n| 324518553658426726783156020576256.0 |\n+---------------------------------------+\n \nSELECT 18014398509481984*18014398509481984;\n \n+-------------------------------------+\n| 18014398509481984*18014398509481984 |\n+-------------------------------------+\n| 0 |\n+-------------------------------------+\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/multiplication-operator/','','https://mariadb.com/kb/en/library/multiplication-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (45,4,'Modulo Operator (%)','Syntax\n------ \nN % M\n \nDescription\n----------- \nModulo operator. Returns the remainder of N divided by M.\nSee also MOD.\n \nExamples\n-------- \nSELECT 1042 % 50;\n \n+-----------+\n| 1042 % 50 |\n+-----------+\n| 42 |\n+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/modulo-operator/','','https://mariadb.com/kb/en/library/modulo-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (46,4,'DIV','Syntax\n------ \nDIV\n \nDescription\n----------- \nInteger division. Similar to FLOOR(), but is safe with\nBIGINT values.\nIncorrect results may occur for non-integer operands that\nexceed BIGINT range.\n \nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, a\ndivision by zero produces an error. Otherwise, it returns\nNULL.\n \nThe remainder of a division can be obtained using the MOD\noperator.\n \nExamples\n-------- \nSELECT 300 DIV 7;\n \n+-----------+\n| 300 DIV 7 |\n+-----------+\n| 42 |\n+-----------+\n \nSELECT 300 DIV 0;\n \n+-----------+\n| 300 DIV 0 |\n+-----------+\n| NULL |\n+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/div/','','https://mariadb.com/kb/en/library/div/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (47,4,'ABS','Syntax\n------ \nABS(X)\n \nDescription\n----------- \nReturns the absolute (non-negative) value of X. If X is not\na number, it is converted to a numeric type.\n \nExamples\n-------- \nSELECT ABS(42);\n+---------+\n| ABS(42) |\n+---------+\n| 42 |\n+---------+\n \nSELECT ABS(-42);\n+----------+\n| ABS(-42) |\n+----------+\n| 42 |\n+----------+\n \nSELECT ABS(DATE \'1994-01-01\');\n+------------------------+\n| ABS(DATE \'1994-01-01\') |\n+------------------------+\n| 19940101 |\n+------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/abs/','','https://mariadb.com/kb/en/library/abs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (48,4,'ACOS','Syntax\n------ \nACOS(X)\n \nDescription\n----------- \nReturns the arc cosine of X, that is, the value whose cosine\nis X.\nReturns NULL if X is not in the range -1 to 1.\n \nExamples\n-------- \nSELECT ACOS(1);\n+---------+\n| ACOS(1) |\n+---------+\n| 0 |\n+---------+\n \nSELECT ACOS(1.0001);\n+--------------+\n| ACOS(1.0001) |\n+--------------+\n| NULL |\n+--------------+\n \nSELECT ACOS(0);\n+-----------------+\n| ACOS(0) |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n \nSELECT ACOS(0.234);\n+------------------+\n| ACOS(0.234) |\n+------------------+\n| 1.33460644244679 |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/acos/','','https://mariadb.com/kb/en/library/acos/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (49,4,'ASIN','Syntax\n------ \nASIN(X)\n \nDescription\n----------- \nReturns the arc sine of X, that is, the value whose sine is\nX. Returns\nNULL if X is not in the range -1 to 1.\n \nExamples\n-------- \nSELECT ASIN(0.2);\n+--------------------+\n| ASIN(0.2) |\n+--------------------+\n| 0.2013579207903308 |\n+--------------------+\n \nSELECT ASIN(\'foo\');\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n| 0 |\n+-------------+\n \nSHOW WARNINGS;\n \n+---------+------+-----------------------------------------+\n| Level | Code | Message |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\'\n|\n+---------+------+-----------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/asin/','','https://mariadb.com/kb/en/library/asin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (50,4,'ATAN','Syntax\n------ \nATAN(X)\n \nDescription\n----------- \nReturns the arc tangent of X, that is, the value whose\ntangent is X.\n \nExamples\n-------- \nSELECT ATAN(2);\n+--------------------+\n| ATAN(2) |\n+--------------------+\n| 1.1071487177940904 |\n+--------------------+\n \nSELECT ATAN(-2);\n+---------------------+\n| ATAN(-2) |\n+---------------------+\n| -1.1071487177940904 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/atan/','','https://mariadb.com/kb/en/library/atan/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (51,4,'ATAN2','Syntax\n------ \nATAN(Y,X), ATAN2(Y,X)\n \nDescription\n----------- \nReturns the arc tangent of the two variables X and Y. It is\nsimilar to\ncalculating the arc tangent of Y / X, except that the signs\nof both\narguments are used to determine the quadrant of the result.\n \nExamples\n-------- \nSELECT ATAN(-2,2);\n+---------------------+\n| ATAN(-2,2) |\n+---------------------+\n| -0.7853981633974483 |\n+---------------------+\n \nSELECT ATAN2(PI(),0);\n+--------------------+\n| ATAN2(PI(),0) |\n+--------------------+\n| 1.5707963267948966 |\n+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/atan2/','','https://mariadb.com/kb/en/library/atan2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (52,4,'CEIL','Syntax\n------ \nCEIL(X)\n \nDescription\n----------- \nCEIL() is a synonym for CEILING().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/ceil/','','https://mariadb.com/kb/en/library/ceil/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (53,4,'CEILING','Syntax\n------ \nCEILING(X)\n \nDescription\n----------- \nReturns the smallest integer value not less than X.\n \nExamples\n-------- \nSELECT CEILING(1.23);\n+---------------+\n| CEILING(1.23) |\n+---------------+\n| 2 |\n+---------------+\n \nSELECT CEILING(-1.23);\n+----------------+\n| CEILING(-1.23) |\n+----------------+\n| -1 |\n+----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/ceiling/','','https://mariadb.com/kb/en/library/ceiling/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (54,4,'CONV','Syntax\n------ \nCONV(N,from_base,to_base)\n \nDescription\n----------- \nConverts numbers between different number bases. Returns a\nstring\nrepresentation of the number N, converted from base\nfrom_base\nto base to_base.\n \nReturns NULL if any argument is NULL, or if the second or\nthird argument are not in the allowed range.\n \nThe argument N is interpreted as an integer, but may be\nspecified as an\ninteger or a string. The minimum base is 2 and the maximum\nbase is 36. If\nto_base is a negative number, N is regarded as a signed\nnumber.\nOtherwise, N is treated as unsigned. CONV() works with\n64-bit\nprecision.\n \nSome shortcuts for this function are also available: BIN(),\nOCT(), HEX(), UNHEX(). Also, MariaDB allows binary literal\nvalues and hexadecimal literal values.\n \nExamples\n-------- \nSELECT CONV(\'a\',16,2);\n+----------------+\n| CONV(\'a\',16,2) |\n+----------------+\n| 1010 |\n+----------------+\n \nSELECT CONV(\'6E\',18,8);\n+-----------------+\n| CONV(\'6E\',18,8) |\n+-----------------+\n| 172 |\n+-----------------+\n \nSELECT CONV(-17,10,-18);\n+------------------+\n| CONV(-17,10,-18) |\n+------------------+\n| -H |\n+------------------+\n \nSELECT CONV(12+\'10\'+\'10\'+0xa,10,10);\n+------------------------------+\n| CONV(12+\'10\'+\'10\'+0xa,10,10) |\n+------------------------------+\n| 42 |\n+------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/conv/','','https://mariadb.com/kb/en/library/conv/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (55,4,'COS','Syntax\n------ \nCOS(X)\n \nDescription\n----------- \nReturns the cosine of X, where X is given in radians.\n \nExamples\n-------- \nSELECT COS(PI());\n+-----------+\n| COS(PI()) |\n+-----------+\n| -1 |\n+-----------\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/cos/','','https://mariadb.com/kb/en/library/cos/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (56,4,'COT','Syntax\n------ \nCOT(X)\n \nDescription\n----------- \nReturns the cotangent of X.\n \nExamples\n-------- \nSELECT COT(42);\n+--------------------+\n| COT(42) |\n+--------------------+\n| 0.4364167060752729 |\n+--------------------+\n \nSELECT COT(12);\n+---------------------+\n| COT(12) |\n+---------------------+\n| -1.5726734063976893 |\n+---------------------+\n \nSELECT COT(0);\nERROR 1690 (22003): DOUBLE value is out of range in\n\'cot(0)\'\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/cot/','','https://mariadb.com/kb/en/library/cot/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (57,4,'CRC32','Syntax\n------ \nCRC32(expr)\n \nDescription\n----------- \nComputes a cyclic redundancy check value and returns a\n32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The\nargument is\nexpected to be a string and (if possible) is treated as one\nif it is\nnot.\n \nExamples\n-------- \nSELECT CRC32(\'MariaDB\');\n+------------------+\n| CRC32(\'MariaDB\') |\n+------------------+\n| 4227209140 |\n+------------------+\n \nSELECT CRC32(\'mariadb\');\n+------------------+\n| CRC32(\'mariadb\') |\n+------------------+\n| 2594253378 |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/crc32/','','https://mariadb.com/kb/en/library/crc32/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (58,4,'DEGREES','Syntax\n------ \nDEGREES(X)\n \nDescription\n----------- \nReturns the argument X, converted from radians to degrees.\n \nThis is the converse of the RADIANS() function.\n \nExamples\n-------- \nSELECT DEGREES(PI());\n+---------------+\n| DEGREES(PI()) |\n+---------------+\n| 180 |\n+---------------+\n \nSELECT DEGREES(PI() / 2);\n+-------------------+\n| DEGREES(PI() / 2) |\n+-------------------+\n| 90 |\n+-------------------+\n \nSELECT DEGREES(45);\n+-----------------+\n| DEGREES(45) |\n+-----------------+\n| 2578.3100780887 |\n+-----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/degrees/','','https://mariadb.com/kb/en/library/degrees/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (59,4,'EXP','Syntax\n------ \nEXP(X)\n \nDescription\n----------- \nReturns the value of e (the base of natural logarithms)\nraised to the\npower of X. The inverse of this function is LOG() (using a\nsingle\nargument only) or LN().\n \nIf X is NULL, this function returns NULL.\n \nExamples\n-------- \nSELECT EXP(2);\n+------------------+\n| EXP(2) |\n+------------------+\n| 7.38905609893065 |\n+------------------+\n \nSELECT EXP(-2);\n+--------------------+\n| EXP(-2) |\n+--------------------+\n| 0.1353352832366127 |\n+--------------------+\n \nSELECT EXP(0);\n+--------+\n| EXP(0) |\n+--------+\n| 1 |\n+--------+\n \nSELECT EXP(NULL);\n+-----------+\n| EXP(NULL) |\n+-----------+\n| NULL |\n+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/exp/','','https://mariadb.com/kb/en/library/exp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (60,4,'FLOOR','Syntax\n------ \nFLOOR(X)\n \nDescription\n----------- \nReturns the largest integer value not greater than X.\n \nExamples\n-------- \nSELECT FLOOR(1.23);\n+-------------+\n| FLOOR(1.23) |\n+-------------+\n| 1 |\n+-------------+\n \nSELECT FLOOR(-1.23);\n+--------------+\n| FLOOR(-1.23) |\n+--------------+\n| -2 |\n+--------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/floor/','','https://mariadb.com/kb/en/library/floor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (61,4,'LN','Syntax\n------ \nLN(X)\n \nDescription\n----------- \nReturns the natural logarithm of X; that is, the base-e\nlogarithm of X.\nIf X is less than or equal to 0, or NULL, then NULL is\nreturned.\n \nThe inverse of this function is EXP().\n \nExamples\n-------- \nSELECT LN(2);\n+-------------------+\n| LN(2) |\n+-------------------+\n| 0.693147180559945 |\n+-------------------+\n \nSELECT LN(-2);\n+--------+\n| LN(-2) |\n+--------+\n| NULL |\n+--------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/ln/','','https://mariadb.com/kb/en/library/ln/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (62,4,'LOG','Syntax\n------ \nLOG(X), LOG(B,X)\n \nDescription\n----------- \nIf called with one parameter, this function returns the\nnatural\nlogarithm of X. If X is less than or equal to 0, then NULL\nis\nreturned.\n \nIf called with two parameters, it returns the logarithm of X\nto the base B. If B is \n\nURL: https://mariadb.com/kb/en/library/log/','','https://mariadb.com/kb/en/library/log/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (63,4,'LOG10','Syntax\n------ \nLOG10(X)\n \nDescription\n----------- \nReturns the base-10 logarithm of X.\n \nExamples\n-------- \nSELECT LOG10(2);\n+-------------------+\n| LOG10(2) |\n+-------------------+\n| 0.301029995663981 |\n+-------------------+\n \nSELECT LOG10(100);\n+------------+\n| LOG10(100) |\n+------------+\n| 2 |\n+------------+\n \nSELECT LOG10(-100);\n+-------------+\n| LOG10(-100) |\n+-------------+\n| NULL |\n+-------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/log10/','','https://mariadb.com/kb/en/library/log10/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (64,4,'LOG2','Syntax\n------ \nLOG2(X)\n \nDescription\n----------- \nReturns the base-2 logarithm of X.\n \nExamples\n-------- \nSELECT LOG2(4398046511104);\n+---------------------+\n| LOG2(4398046511104) |\n+---------------------+\n| 42 |\n+---------------------+\n \nSELECT LOG2(65536);\n+-------------+\n| LOG2(65536) |\n+-------------+\n| 16 |\n+-------------+\n \nSELECT LOG2(-100);\n+------------+\n| LOG2(-100) |\n+------------+\n| NULL |\n+------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/log2/','','https://mariadb.com/kb/en/library/log2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (65,4,'MOD','Syntax\n------ \nMOD(N,M), N % M, N MOD M\n \nDescription\n----------- \nModulo operation. Returns the remainder of N divided by M.\nSee also Modulo Operator.\n \nIf the ERROR_ON_DIVISION_BY_ZERO SQL_MODE is used, any\nnumber modulus zero produces an error. Otherwise, it returns\nNULL.\n \nThe integer part of a division can be obtained using DIV.\n \nExamples\n-------- \nSELECT 1042 % 50;\n \n+-----------+\n| 1042 % 50 |\n+-----------+\n| 42 |\n+-----------+\n \nSELECT MOD(234, 10);\n+--------------+\n| MOD(234, 10) |\n+--------------+\n| 4 |\n+--------------+\n \nSELECT 253 % 7;\n \n+---------+\n| 253 % 7 |\n+---------+\n| 1 |\n+---------+\n \nSELECT MOD(29,9);\n+-----------+\n| MOD(29,9) |\n+-----------+\n| 2 |\n+-----------+\n \nSELECT 29 MOD 9;\n \n+----------+\n| 29 MOD 9 |\n+----------+\n| 2 |\n+----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mod/','','https://mariadb.com/kb/en/library/mod/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (66,4,'OCT','Syntax\n------ \nOCT(N)\n \nDescription\n----------- \nReturns a string representation of the octal value of N,\nwhere N is a longlong (BIGINT) number. This is equivalent to\nCONV(N,10,8). Returns NULL if N is NULL.\n \nExamples\n-------- \nSELECT OCT(34);\n+---------+\n| OCT(34) |\n+---------+\n| 42 |\n+---------+\n \nSELECT OCT(12);\n+---------+\n| OCT(12) |\n+---------+\n| 14 |\n+---------+\n \n\n\nURL: https://mariadb.com/kb/en/library/oct/','','https://mariadb.com/kb/en/library/oct/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (67,4,'PI','Syntax\n------ \nPI()\n \nDescription\n----------- \nReturns the value of π (pi). The default number of decimal\nplaces\ndisplayed is six, but MariaDB uses the full double-precision\nvalue\ninternally.\n \nExamples\n-------- \nSELECT PI();\n+----------+\n| PI() |\n+----------+\n| 3.141593 |\n+----------+\n \nSELECT PI()+0.0000000000000000000000;\n \n+-------------------------------+\n| PI()+0.0000000000000000000000 |\n+-------------------------------+\n| 3.1415926535897931159980 |\n+-------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/pi/','','https://mariadb.com/kb/en/library/pi/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (68,4,'POW','Syntax\n------ \nPOW(X,Y)\n \nDescription\n----------- \nReturns the value of X raised to the power of Y.\n \nPOWER() is a synonym.\n \nExamples\n-------- \nSELECT POW(2,3);\n+----------+\n| POW(2,3) |\n+----------+\n| 8 |\n+----------+\n \nSELECT POW(2,-2);\n+-----------+\n| POW(2,-2) |\n+-----------+\n| 0.25 |\n+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/pow/','','https://mariadb.com/kb/en/library/pow/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (69,4,'POWER','Syntax\n------ \nPOWER(X,Y)\n \nDescription\n----------- \nThis is a synonym for POW(), which returns the value of X\nraised to the power of Y.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/power/','','https://mariadb.com/kb/en/library/power/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (70,4,'RADIANS','Syntax\n------ \nRADIANS(X)\n \nDescription\n----------- \nReturns the argument X, converted from degrees to radians.\nNote that\nπ radians equals 180 degrees. \n \nThis is the converse of the DEGREES() function.\n \nExamples\n-------- \nSELECT RADIANS(45);\n+-------------------+\n| RADIANS(45) |\n+-------------------+\n| 0.785398163397448 |\n+-------------------+\n \nSELECT RADIANS(90);\n+-----------------+\n| RADIANS(90) |\n+-----------------+\n| 1.5707963267949 |\n+-----------------+\n \nSELECT RADIANS(PI());\n+--------------------+\n| RADIANS(PI()) |\n+--------------------+\n| 0.0548311355616075 |\n+--------------------+\n \nSELECT RADIANS(180);\n+------------------+\n| RADIANS(180) |\n+------------------+\n| 3.14159265358979 |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/radians/','','https://mariadb.com/kb/en/library/radians/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (71,4,'RAND','Syntax\n------ \nRAND(), RAND(N)\n \nDescription\n----------- \nReturns a random DOUBLE precision floating point value v in\nthe range 0 \n\nURL: https://mariadb.com/kb/en/library/rand/','','https://mariadb.com/kb/en/library/rand/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (72,4,'ROUND','Syntax\n------ \nROUND(X), ROUND(X,D)\n \nDescription\n----------- \nRounds the argument X to D decimal places. The rounding\nalgorithm\ndepends on the data type of X. D defaults to 0 if not\nspecified.\nD can be negative to cause D digits left of the decimal\npoint of the\nvalue X to become zero.\n \nExamples\n-------- \nSELECT ROUND(-1.23);\n+--------------+\n| ROUND(-1.23) |\n+--------------+\n| -1 |\n+--------------+\n \nSELECT ROUND(-1.58);\n+--------------+\n| ROUND(-1.58) |\n+--------------+\n| -2 |\n+--------------+\n \nSELECT ROUND(1.58); \n+-------------+\n| ROUND(1.58) |\n+-------------+\n| 2 |\n+-------------+\n \nSELECT ROUND(1.298, 1);\n+-----------------+\n| ROUND(1.298, 1) |\n+-----------------+\n| 1.3 |\n+-----------------+\n \nSELECT ROUND(1.298, 0);\n+-----------------+\n| ROUND(1.298, 0) |\n+-----------------+\n| 1 |\n+-----------------+\n \nSELECT ROUND(23.298, -1);\n+-------------------+\n| ROUND(23.298, -1) |\n+-------------------+\n| 20 |\n+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/round/','','https://mariadb.com/kb/en/library/round/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (73,4,'SIGN','Syntax\n------ \nSIGN(X)\n \nDescription\n----------- \nReturns the sign of the argument as -1, 0, or 1, depending\non whether\nX is negative, zero, or positive.\n \nExamples\n-------- \nSELECT SIGN(-32);\n+-----------+\n| SIGN(-32) |\n+-----------+\n| -1 |\n+-----------+\n \nSELECT SIGN(0);\n+---------+\n| SIGN(0) |\n+---------+\n| 0 |\n+---------+\n \nSELECT SIGN(234);\n+-----------+\n| SIGN(234) |\n+-----------+\n| 1 |\n+-----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/sign/','','https://mariadb.com/kb/en/library/sign/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (74,4,'SIN','Syntax\n------ \nSIN(X)\n \nDescription\n----------- \nReturns the sine of X, where X is given in radians.\n \nExamples\n-------- \nSELECT SIN(1.5707963267948966);\n+-------------------------+\n| SIN(1.5707963267948966) |\n+-------------------------+\n| 1 |\n+-------------------------+\n \nSELECT SIN(PI());\n+----------------------+\n| SIN(PI()) |\n+----------------------+\n| 1.22460635382238e-16 |\n+----------------------+\n \nSELECT ROUND(SIN(PI()));\n+------------------+\n| ROUND(SIN(PI())) |\n+------------------+\n| 0 |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/sin/','','https://mariadb.com/kb/en/library/sin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (75,4,'SQRT','Syntax\n------ \nSQRT(X)\n \nDescription\n----------- \nReturns the square root of X. If X is negative, NULL is\nreturned.\n \nExamples\n-------- \nSELECT SQRT(4);\n+---------+\n| SQRT(4) |\n+---------+\n| 2 |\n+---------+\n \nSELECT SQRT(20);\n+------------------+\n| SQRT(20) |\n+------------------+\n| 4.47213595499958 |\n+------------------+\n \nSELECT SQRT(-16);\n+-----------+\n| SQRT(-16) |\n+-----------+\n| NULL |\n+-----------+\n \nSELECT SQRT(1764);\n+------------+\n| SQRT(1764) |\n+------------+\n| 42 |\n+------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/sqrt/','','https://mariadb.com/kb/en/library/sqrt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (76,4,'TAN','Syntax\n------ \nTAN(X)\n \nDescription\n----------- \nReturns the tangent of X, where X is given in radians.\n \nExamples\n-------- \nSELECT TAN(0.7853981633974483);\n+-------------------------+\n| TAN(0.7853981633974483) |\n+-------------------------+\n| 0.9999999999999999 |\n+-------------------------+\n \nSELECT TAN(PI());\n+-----------------------+\n| TAN(PI()) |\n+-----------------------+\n| -1.22460635382238e-16 |\n+-----------------------+\n \nSELECT TAN(PI()+1);\n+-----------------+\n| TAN(PI()+1) |\n+-----------------+\n| 1.5574077246549 |\n+-----------------+\n \nSELECT TAN(RADIANS(PI()));\n+--------------------+\n| TAN(RADIANS(PI())) |\n+--------------------+\n| 0.0548861508080033 |\n+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/tan/','','https://mariadb.com/kb/en/library/tan/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (77,4,'TRUNCATE','This page documents the TRUNCATE function. See TRUNCATE\nTABLE for the DDL statement.\n \nSyntax\n------ \nTRUNCATE(X,D)\n \nDescription\n----------- \nReturns the number X, truncated to D decimal places. If D is\n0, the\nresult has no decimal point or fractional part. D can be\nnegative to\ncause D digits left of the decimal point of the value X to\nbecome\nzero.\n \nExamples\n-------- \nSELECT TRUNCATE(1.223,1);\n+-------------------+\n| TRUNCATE(1.223,1) |\n+-------------------+\n| 1.2 |\n+-------------------+\n \nSELECT TRUNCATE(1.999,1);\n+-------------------+\n| TRUNCATE(1.999,1) |\n+-------------------+\n| 1.9 |\n+-------------------+\n \nSELECT TRUNCATE(1.999,0); \n+-------------------+\n| TRUNCATE(1.999,0) |\n+-------------------+\n| 1 |\n+-------------------+\n \nSELECT TRUNCATE(-1.999,1);\n+--------------------+\n| TRUNCATE(-1.999,1) |\n+--------------------+\n| -1.9 |\n+--------------------+\n \nSELECT TRUNCATE(122,-2);\n+------------------+\n| TRUNCATE(122,-2) |\n+------------------+\n| 100 |\n+------------------+\n \nSELECT TRUNCATE(10.28*100,0);\n+-----------------------+\n| TRUNCATE(10.28*100,0) |\n+-----------------------+\n| 1028 |\n+-----------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/truncate/','','https://mariadb.com/kb/en/library/truncate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (78,5,'Plugin Overview','Plugins are server components that enhance MariaDB in some\nway. These can be anything from new storage engines, plugins\nfor enhancing full-text parsing, or even small enhancements,\nsuch as a plugin to get a timestamp as an integer.\n \nQuerying Plugin Information\n \nThere are a number of ways to see which plugins are\ncurrently active.\n \nA server almost always has a large number of active plugins,\nbecause the server contains a large number of built-in\nplugins, which are active by default and cannot be\nuninstalled.\n \nQuerying Plugin Information with SHOW PLUGINS\n \nThe SHOW PLUGINS statement can be used to query information\nabout all active plugins.\n \nFor example:\n \nSHOW PLUGINS;\n \n+----------------------------+----------+--------------------+---------+---------+\n| Name | Status | Type | Library | License |\n+----------------------------+----------+--------------------+---------+---------+\n...\n| mysql_native_password | ACTIVE | AUTHENTICATION | NULL |\nGPL |\n| mysql_old_password | ACTIVE | AUTHENTICATION | NULL | GPL\n|\n| MRG_MyISAM | ACTIVE | STORAGE ENGINE | NULL | GPL |\n...\n+----------------------------+----------+--------------------+---------+---------+\n \nIf a plugin\'s Library column has the NULL value, then the\nplugin is built-in, and it cannot be uninstalled.\n \nQuerying Plugin Information with information_schema.PLUGINS\n \nThe information_schema.PLUGINS table can be queried to get\nmore detailed information about plugins.\n \nFor example:\n \nSELECT * FROM information_schema.PLUGINS\\G\n...\n*************************** 6. row\n***************************\n PLUGIN_NAME: CSV\n PLUGIN_VERSION: 1.0\n PLUGIN_STATUS: ACTIVE\n PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n PLUGIN_AUTHOR: Brian Aker, MySQL AB\n PLUGIN_DESCRIPTION: CSV storage engine\n PLUGIN_LICENSE: GPL\n LOAD_OPTION: FORCE\n PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n*************************** 7. row\n***************************\n PLUGIN_NAME: MEMORY\n PLUGIN_VERSION: 1.0\n PLUGIN_STATUS: ACTIVE\n PLUGIN_TYPE: STORAGE ENGINE\n PLUGIN_TYPE_VERSION: 100003.0\n PLUGIN_LIBRARY: NULL\nPLUGIN_LIBRARY_VERSION: NULL\n PLUGIN_AUTHOR: MySQL AB\n PLUGIN_DESCRIPTION: Hash based, stored in memory, useful\nfor temporary tables\n PLUGIN_LICENSE: GPL\n LOAD_OPTION: FORCE\n PLUGIN_MATURITY: Stable\n PLUGIN_AUTH_VERSION: 1.0\n...\n \nIf a plugin\'s PLUGIN_LIBRARY column has the NULL value,\nthen the plugin is built-in, and it cannot be uninstalled.\n \nQuerying Plugin Information with mysql.plugin\n \nThe mysql.plugin table can be queried to get information\nabout installed plugins.\n \nThis table only contains information about plugins that have\nbeen installed via the following methods:\nThe INSTALL SONAME statement.\nThe INSTALL PLUGIN statement.\nThe mysql_plugin utility.\n \nThis table does not contain information about:\nBuilt-in plugins.\nPlugins loaded with the --plugin-load-add option.\nPlugins loaded with the --plugin-load option.\n \nThis table only contains enough information to reload the\nplugin when the server is restarted, which means it only\ncontains the plugin name and the plugin library.\n \nFor example:\n \nSELECT * FROM mysql.plugin;\n \n+------+------------+\n| name | dl |\n+------+------------+\n| PBXT | libpbxt.so |\n+------+------------+\n \nInstalling a Plugin\n \nThere are three primary ways to install a plugin:\nA plugin can be installed dynamically with an SQL statement.\nA plugin can be installed with a mysqld option, but it\nrequires a server restart.\nA plugin can be installed with the mysql_plugin utility,\nwhile the server is completely offline.\n \nWhen you are installing a plugin, you also have to ensure\nthat:\nThe server\'s plugin directory is properly configured, and\nthe plugin\'s library is in the plugin directory.\nThe server\'s minimum plugin maturity is properly\nconfigured, and the plugin is mature enough to be installed.\n \nInstalling a Plugin Dynamically\n \nA plugin can be installed dynamically by executing either\nthe INSTALL SONAME or the INSTALL PLUGIN statement.\n \nIf a plugin is installed with one of these statements, then\na record will be added to the mysql.plugins table for the\nplugin. This means that the plugin will automatically be\nloaded every time the server restarts, unless specifically\nuninstalled or deactivated.\n \nInstalling a Plugin with INSTALL SONAME\n \nYou can install a plugin dynamically by executing the\nINSTALL SONAME statement. INSTALL SONAME installs all\nplugins from the given plugin library. This could be\nrequired for some plugin libraries.\n \nFor example, to install all plugins in the server_audit\nplugin library (which is currently only the server_audit\naudit plugin), you could execute the following:\n \nINSTALL SONAME \'server_audit\';\n \nInstalling a Plugin with INSTALL PLUGIN\n \nYou can install a plugin dynamically by executing the\nINSTALL PLUGIN statement. INSTALL PLUGIN installs a single\nplugin from the given plugin library.\n \nFor example, to install the server_audit audit plugin from\nthe server_audit plugin library, you could execute the\nfollowing:\n \nINSTALL PLUGIN server_audit SONAME \'server_audit\';\n \nInstalling a Plugin with Plugin Load Options\n \nA plugin can be installed with a mysqld option by providing\neither the --plugin-load-add or the --plugin-load option.\n \nIf a plugin is installed with one of these options, then a\nrecord will not be added to the mysql.plugins table for the\nplugin. This means that if the server is restarted without\nthe same option set, then the plugin will not automatically\nbe loaded.\n \nInstalling a Plugin with --plugin-load-add\n \nYou can install a plugin with the --plugin-load-add option\nby specifying the option as a command-line argument to\nmysqld or by specifying the option in a relevant server\noption group in an option file.\n \nThe --plugin-load-add option uses the following format:\nPlugins can be specified in the format name=library, where\nname is the plugin name and library is the plugin library.\nThis format installs a single plugin from the given plugin\nlibrary.\nPlugins can also be specified in the format library, where\nlibrary is the plugin library. This format installs all\nplugins from the given plugin library.\nMultiple plugins can be specified by separating them with\nsemicolons.\n \nFor example, to install all plugins in the server_audit\nplugin library (which is currently only the server_audit\naudit plugin) and also the ed25519 authentication plugin\nfrom the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n \n$ mysqld --user=mysql --plugin-load-add=\'server_audit\'\n--plugin-load-add=\'ed25519=auth_ed25519\'\n \nYou could also set the option to the same values in an\noption file:\n \n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load_add = ed25519=auth_ed25519\n \nSpecial care must be taken when specifying both the\n--plugin-load option and the --plugin-load-add option\ntogether. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not\naware. The --plugin-load-add option does not reset the\nplugin load list, so it is much safer to use. See Specifying\nMultiple Plugin Load Options for more information.\n \nInstalling a Plugin with --plugin-load\n \nYou can install a plugin with the --plugin-load option by\nspecifying the option as a command-line argument to mysqld\nor by specifying the option in a relevant server option\ngroup in an option file.\n \nThe --plugin-load option uses the following format:\nPlugins can be specified in the format name=library, where\nname is the plugin name and library is the plugin library.\nThis format installs a single plugin from the given plugin\nlibrary.\nPlugins can also be specified in the format library, where\nlibrary is the plugin library. This format installs all\nplugins from the given plugin library.\nMultiple plugins can be specified by separating them with\nsemicolons.\n \nFor example, to install all plugins in the server_audit\nplugin library (which is currently only the server_audit\naudit plugin) and also the ed25519 authentication plugin\nfrom the auth_ed25519 plugin library, you could set the\noption to the following values on the command-line:\n \n$ mysqld --user=mysql\n--plugin-load=\'server_audit;ed25519=auth_ed25519\'\n \nYou could also set the option to the same values in an\noption file:\n \n[mariadb]\n...\nplugin_load = server_audit;ed25519=auth_ed25519\n \nSpecial care must be taken when specifying the --plugin-load\noption multiple times, or when specifying both the\n--plugin-load option and the --plugin-load-add option\ntogether. The --plugin-load option resets the plugin load\nlist, and this can cause unexpected problems if you are not\naware. The --plugin-load-add option does not reset the\nplugin load list, so it is much safer to use. See Specifying\nMultiple Plugin Load Options for more information.\n \nSpecifying Multiple Plugin Load Options\n \nSpecial care must be taken when specifying the --plugin-load\noption multiple times, or when specifying both the\n--plugin-load option and the --plugin-load-add option. The\n--plugin-load option resets the plugin load list, and this\ncan cause unexpected problems if you are not aware. The\n--plugin-load-add option does not reset the plugin load\nlist, so it is much safer to use.\n \nThis can have the following consequences:\nIf the --plugin-load option is specified multiple times,\nthen only the last instance will have any effect. For\nexample, in the following case, the first instance of the\noption is reset:\n \n[mariadb]\n...\nplugin_load = server_audit\nplugin_load = ed25519=auth_ed25519\nIf the --plugin-load option is specified after the\n--plugin-load-add option, then it will also reset the\nchanges made by that option. For example, in the following\ncase, the --plugin-load-add option does not do anything,\nbecause the subsequent --plugin-load option resets the\nplugin load list:\n \n[mariadb]\n...\nplugin_load_add = server_audit\nplugin_load = ed25519=auth_ed25519\nIn contrast, if the --plugin-load option is specified before\nthe --plugin-load-add option, then it will work fine,\nbecause the --plugin-load-add option does not reset the\nplugin load list. For example, in the following case, both\nplugins are properly loaded:\n \n[mariadb]\n...\nplugin_load = server_audit\nplugin_load_add = ed25519=auth_ed25519\n \nInstalling a Plugin with mysql_plugin\n \nA plugin can be installed with the mysql_plugin utility if\nthe server is completely offline. \n \nThe syntax is:\n \nmysql_plugin [options] \n ENABLE|DISABLE\n \nFor example, to install the server_audit audit plugin, you\ncould execute the following:\n \nmysql_plugin server_audit ENABLE\n \nIf a plugin is installed with this utility, then a record\nwill be added to the mysql.plugins table for the plugin.\nThis means that the plugin will automatically be loaded\nevery time the server restarts, unless specifically\nuninstalled or deactivated.\n \nConfiguring the Plugin Directory\n \nWhen a plugin is being installed, the server looks for the\nplugin\'s library in the server\'s plugin directory. This\ndirectory is configured by the plugin_dir system variable.\nThis can be specified as a command-line argument to mysqld\nor it can be specified in a relevant server option group in\nan option file. For example:\n \n[mariadb]\n...\nplugin_dir = /usr/lib64/mysql/plugin\n \nConfiguring the Minimum Plugin Maturity\n \nWhen a plugin is being installed, the server compares the\nplugin\'s maturity level against the server\'s minimum\nallowed plugin maturity. This can help prevent users from\nusing unstable plugins on production servers. This minimum\nplugin maturity is configured by the plugin_maturity system\nvariable. This can be specified as a command-line argument\nto mysqld or it can be specified in a relevant server option\ngroup in an option file. For example:\n \n[mariadb]\n...\nplugin_maturity = stable\n \nConfiguring Plugin Activation at Server Startup\n \nA plugin will be loaded by default when the server starts\nif:\nThe plugin was installed with the INSTALL SONAME statement.\nThe plugin was installed with the INSTALL PLUGIN statement.\nThe plugin was installed with the mysql_plugin utility.\nThe server is configured to load the plugin with the\n--plugin-load-add option.\nThe server is configured to load the plugin with the\n--plugin-load option.\n \nThis behavior can be changed with special options that take\nthe form --plugin-name. For example, for the server_audit\naudit plugin, the special option is called --server-audit.\n \nThe possible values for these special options are:\n \nOption Value | Description | \n \nOFF | Disables the plugin without removing it from the\nmysql.plugins table. | \n \nON | Enables the plugin. If the plugin cannot be\ninitialized, then the server will still continue starting\nup, but the plugin will be disabled. | \n \nFORCE | Enables the plugin. If the plugin cannot be\ninitialized, then the server will fail to start with an\nerror. | \n \nFORCE_PLUS_PERMANENT | Enables the plugin. If the plugin\ncannot be initialized, then the server will fail to start\nwith an error. In addition, the plugin cannot be uninstalled\nwith UNINSTALL SONAME or UNINSTALL PLUGIN while the server\nis running. | \n \nA plugin\'s status can be found by looking at the\nPLUGIN_STATUS column of the information_schema.PLUGINS\ntable.\n \nUninstalling Plugins\n \nPlugins that are found in the mysql.plugin table, that is\nthose that were installed with INSTALL SONAME, INSTALL\nPLUGIN or mysql_plugin can be uninstalled in one of two\nways:\nThe UNINSTALL SONAME or the UNINSTALL PLUGIN statement while\nthe server is running\nWith mysql_plugin while the server is offline.\n \nPlugins that were enabled as a --plugin-load option do not\nneed to be uninstalled. If --plugin-load is omitted the next\ntime the server starts, or the plugin is not listed as one\nof the --plugin-load entries, the plugin will not be loaded.\n \nUNINSTALL PLUGIN uninstalls a single installed plugin, while\nUNINSTALL SONAME uninstalls all plugins belonging to a given\nlibrary.\n \n\n\nURL: https://mariadb.com/kb/en/library/plugin-overview/','','https://mariadb.com/kb/en/library/plugin-overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (79,5,'INSTALL PLUGIN','Syntax\n------ \nINSTALL PLUGIN [IF NOT EXISTS] plugin_name SONAME\n\'plugin_library\'\n \nDescription\n----------- \nThis statement installs an individual plugin from the\nspecified library. To install the whole library (which could\nbe required), use INSTALL SONAME.\n \nplugin_name is the name of the plugin as defined in the\nplugin declaration structure contained in the library file.\nPlugin names are\nnot case sensitive. For maximal compatibility, plugin names\nshould be limited\nto ASCII letters, digits, and underscore, because they are\nused in C source\nfiles, shell command lines, M4 and Bourne shell scripts, and\nSQL environments.\n \nplugin_library is the name of the shared library that\ncontains the plugin code. Before MariaDB 5.5.21, the name\nshould include the file name extension (for\nexample, libmyplugin.so or libmyplugin.dll). Starting from\nMariaDB 5.5.21, the file name extension can be omitted\n(which makes the statement look the same on all\narchitectures).\n \nThe shared library must be located in the plugin directory\n(that is,\nthe directory named by the plugin_dir system variable). The\nlibrary must be in the plugin directory itself, not in a\nsubdirectory. By\ndefault, plugin_dir is plugin directory under the directory\nnamed by\nthe pkglibdir configuration variable, but it can be changed\nby setting\nthe value of plugin_dir at server startup. For example, set\nits value in a my.cnf file:\n \n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is\ntaken to be relative to the MySQL base directory (the value\nof the basedir\nsystem variable).\n \nINSTALL PLUGIN adds a line to the mysql.plugin table that\ndescribes the plugin. This table contains the plugin name\nand library file\nname.\n \nINSTALL PLUGIN causes the server to read\noption (my.cnf) files just as during server startup. This\nenables the plugin to\npick up any relevant options from those files. It is\npossible to add plugin\noptions to an option file even before loading a plugin (if\nthe loose prefix is\nused). It is also possible to uninstall a plugin, edit\nmy.cnf, and install the\nplugin again. Restarting the plugin this way enables it to\nthe new option\nvalues without a server restart.\n \nBefore MySQL 5.1.33, a plugin was started with each option\nset to its\ndefault value.\n \nINSTALL PLUGIN also loads and initializes the plugin code to\nmake the plugin available for use. A plugin is initialized\nby executing its\ninitialization function, which handles any setup that the\nplugin must perform\nbefore it can be used.\n \nTo use INSTALL PLUGIN, you must have the\nINSERT privilege for the mysql.plugin table.\n \nAt server startup, the server loads and initializes any\nplugin that is\nlisted in the mysql.plugin table. This means that a plugin\nis installed\nwith INSTALL PLUGIN only once, not every time the server\nstarts. Plugin loading at startup does not occur if the\nserver is started with\nthe --skip-grant-tables option.\n \nWhen the server shuts down, it executes the deinitialization\nfunction\nfor each plugin that is loaded so that the plugin has a\nchance to\nperform any final cleanup.\n \nIf you need to load plugins for a single server startup when\nthe\n--skip-grant-tables option is given (which tells the server\nnot to read system tables), use the \n--plugin-load mysqld option.\n \nIF NOT EXISTS\n \nWhen the IF NOT EXISTS clause is used, MariaDB will return a\nnote instead of an error if the specified plugin already\nexists. See SHOW WARNINGS.\n \nExamples\n-------- \nINSTALL PLUGIN sphinx SONAME \'ha_sphinx.so\';\n \nStarting from MariaDB 5.5.21, the extension can be omitted:\n \nINSTALL PLUGIN innodb SONAME \'ha_xtradb\';\n \nFrom MariaDB 10.4.0:\n \nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\n \nQuery OK, 0 rows affected (0.104 sec)\n \nINSTALL PLUGIN IF NOT EXISTS example SONAME \'ha_example\';\n \nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n \nSHOW WARNINGS;\n \n+-------+------+------------------------------------+\n| Level | Code | Message |\n+-------+------+------------------------------------+\n| Note | 1968 | Plugin \'example\' already installed |\n+-------+------+------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/install-plugin/','','https://mariadb.com/kb/en/library/install-plugin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (80,5,'UNINSTALL PLUGIN','Syntax\n------ \nUNINSTALL PLUGIN [IF EXISTS] plugin_name\n \nDescription\n----------- \nThis statement removes a single installed plugin. To\nuninstall the whole library which contains the plugin, use\nUNINSTALL SONAME. You cannot uninstall a plugin if any table\nthat uses it is open.\n \nplugin_name must be the name of some plugin that is listed\nin the mysql.plugin table. The server executes the plugin\'s\ndeinitialization\nfunction and removes the row for the plugin from the\nmysql.plugin\ntable, so that subsequent server restarts will not load and\ninitialize\nthe plugin. UNINSTALL PLUGIN does not remove the plugin\'s\nshared library file.\n \nTo use UNINSTALL PLUGIN, you must have the\nDELETE privilege for the mysql.plugin table.\n \nIF EXISTS\n \nIf the IF EXISTS clause is used, MariaDB will return a note\ninstead of an error if the plugin does not exist. See SHOW\nWARNINGS.\n \nExamples\n-------- \nUNINSTALL PLUGIN example;\n \nFrom MariaDB 10.4.0:\n \nUNINSTALL PLUGIN IF EXISTS example;\n \nQuery OK, 0 rows affected (0.099 sec)\n \nUNINSTALL PLUGIN IF EXISTS example;\n \nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n \nSHOW WARNINGS;\n \n+-------+------+-------------------------------+\n| Level | Code | Message |\n+-------+------+-------------------------------+\n| Note | 1305 | PLUGIN example does not exist |\n+-------+------+-------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/uninstall-plugin/','','https://mariadb.com/kb/en/library/uninstall-plugin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (81,5,'INSTALL SONAME','INSTALL SONAME has been supported since MariaDB 5.5.21.\n \nSyntax\n------ \nINSTALL SONAME \'plugin_library\'\n \nDescription\n----------- \nThis statement is a variant of INSTALL PLUGIN. It installs\nall plugins from a given plugin_library. See INSTALL PLUGIN\nfor details.\n \nplugin_library is the name of the shared library that\ncontains the plugin code. The file name extension (for\nexample, libmyplugin.so or libmyplugin.dll) can be omitted\n(which makes the statement look the same on all\narchitectures).\n \nThe shared library must be located in the plugin directory\n(that is,\nthe directory named by the plugin_dir system variable). The\nlibrary must be in the plugin directory itself, not in a\nsubdirectory. By\ndefault, plugin_dir is plugin directory under the directory\nnamed by\nthe pkglibdir configuration variable, but it can be changed\nby setting\nthe value of plugin_dir at server startup. For example, set\nits value in a my.cnf file:\n \n[mysqld]\nplugin_dir=/path/to/plugin/directory\nIf the value of plugin_dir is a relative path name, it is\ntaken to be relative to the MySQL base directory (the value\nof the basedir\nsystem variable).\n \nINSTALL SONAME adds one or more lines to the mysql.plugin\ntable that\ndescribes the plugin. This table contains the plugin name\nand library file\nname.\n \nINSTALL SONAME causes the server to read\noption (my.cnf) files just as during server startup. This\nenables the plugin to\npick up any relevant options from those files. It is\npossible to add plugin\noptions to an option file even before loading a plugin (if\nthe loose prefix is\nused). It is also possible to uninstall a plugin, edit\nmy.cnf, and install the\nplugin again. Restarting the plugin this way enables it to\nthe new option\nvalues without a server restart.\n \nINSTALL SONAME also loads and initializes the plugin code to\nmake the plugin available for use. A plugin is initialized\nby executing its\ninitialization function, which handles any setup that the\nplugin must perform\nbefore it can be used.\n \nTo use INSTALL SONAME, you must have the\nINSERT privilege for the mysql.plugin table.\n \nAt server startup, the server loads and initializes any\nplugin that is\nlisted in the mysql.plugin table. This means that a plugin\nis installed\nwith INSTALL SONAME only once, not every time the server\nstarts. Plugin loading at startup does not occur if the\nserver is started with\nthe --skip-grant-tables option.\n \nWhen the server shuts down, it executes the deinitialization\nfunction\nfor each plugin that is loaded so that the plugin has a\nchance to\nperform any final cleanup.\n \nIf you need to load plugins for a single server startup when\nthe\n--skip-grant-tables option is given (which tells the server\nnot to read system tables), use the \n--plugin-load mysqld option.\n \nIf you need to install only one plugin from a library, use\nthe INSTALL PLUGIN statement.\n \nExamples\n-------- \nTo load the XtraDB storage engine and all of its\ninformation_schema tables with one statement, use\n \nINSTALL SONAME \'ha_xtradb\';\n \nThis statement can be used instead of INSTALL PLUGIN even\nwhen the library contains only one plugin:\n \nINSTALL SONAME \'ha_sequence\';\n \n\n\nURL: https://mariadb.com/kb/en/library/install-soname/','','https://mariadb.com/kb/en/library/install-soname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (82,5,'UNINSTALL SONAME','UNINSTALL SONAMEhas been supported since MariaDB 5.5.21.\n \nSyntax\n------ \nUNINSTALL SONAME [IF EXISTS] \'plugin_library\'\n \nDescription\n----------- \nThis statement is a variant of UNINSTALL PLUGIN statement,\nthat removes all plugins belonging to a specified\nplugin_library. See UNINSTALL PLUGIN for details.\n \nplugin_library is the name of the shared library that\ncontains the plugin code. The file name extension (for\nexample, libmyplugin.so or libmyplugin.dll) can be omitted\n(which makes the statement look the same on all\narchitectures).\n \nTo use UNINSTALL SONAME, you must have the\nDELETE privilege for the mysql.plugin table.\n \nIF EXISTS\n \nIf the IF EXISTS clause is used, MariaDB will return a note\ninstead of an error if the plugin library does not exist.\nSee SHOW WARNINGS.\n \nExamples\n-------- \nTo uninstall the XtraDB plugin and all of its\ninformation_schema tables with one statement, use\n \nUNINSTALL SONAME \'ha_xtradb\';\n \nFrom MariaDB 10.4.0:\n \nUNINSTALL SONAME IF EXISTS \'ha_example\';\n \nQuery OK, 0 rows affected (0.099 sec)\n \nUNINSTALL SONAME IF EXISTS \'ha_example\';\n \nQuery OK, 0 rows affected, 1 warning (0.000 sec)\n \nSHOW WARNINGS;\n \n+-------+------+-------------------------------------+\n| Level | Code | Message |\n+-------+------+-------------------------------------+\n| Note | 1305 | SONAME ha_example.so does not exist |\n+-------+------+-------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/uninstall-soname/','','https://mariadb.com/kb/en/library/uninstall-soname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (83,6,'MBR Definition','Description\n----------- \nThe MBR (Minimum Bounding Rectangle), or Envelope is the\nbounding\ngeometry, formed by the minimum and maximum (X,Y)\ncoordinates:\n \nExamples\n-------- \n((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbr-definition/','','https://mariadb.com/kb/en/library/mbr-definition/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (84,6,'MBRContains','Syntax\n------ \nMBRContains(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangle of\ng1 contains the Minimum Bounding Rectangle of g2. This tests\nthe\nopposite relationship as MBRWithin().\n \nExamples\n-------- \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\n \nSET @g2 = GeomFromText(\'Point(1 1)\');\n \nSELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n+----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n| 1 | 0 |\n+----------------------+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbrcontains/','','https://mariadb.com/kb/en/library/mbrcontains/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (85,6,'MBRDisjoint','Syntax\n------ \nMBRDisjoint(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangles of the two geometries g1 and g2 are disjoint. Two\ngeometries are disjoint if they do not intersect, that is\ntouch or overlap.\n \nExamples\n-------- \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECTmbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrdisjoint(@g1,@g2);\n+----------------------+\n| mbrdisjoint(@g1,@g2) |\n+----------------------+\n| 0 |\n+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbrdisjoint/','','https://mariadb.com/kb/en/library/mbrdisjoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (86,6,'MBREqual','Syntax\n------ \nMBREqual(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangles of\nthe two geometries g1 and g2 are the same.\n \nExamples\n-------- \nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 2)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 2, 1 0, 0\n0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n| 1 |\n+-------------------+\n \nSET @g1=GEOMFROMTEXT(\'LINESTRING(0 0, 1 3)\');\nSET @g2=GEOMFROMTEXT(\'POLYGON((0 0, 0 2, 1 4, 1 0, 0\n0))\');\nSELECT MbrEqual(@g1,@g2);\n+-------------------+\n| MbrEqual(@g1,@g2) |\n+-------------------+\n| 0 |\n+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbrequal/','','https://mariadb.com/kb/en/library/mbrequal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (87,6,'MBRIntersects','Syntax\n------ \nMBRIntersects(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangles of the two geometries g1 and g2 intersect.\n \nExamples\n-------- \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n| 1 |\n+------------------------+\n \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrintersects(@g1,@g2);\n+------------------------+\n| mbrintersects(@g1,@g2) |\n+------------------------+\n| 0 |\n+------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbrintersects/','','https://mariadb.com/kb/en/library/mbrintersects/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (88,6,'MBROverlaps','Syntax\n------ \nMBROverlaps(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangles of\nthe two geometries g1 and g2 overlap. The term spatially\noverlaps is\nused if two geometries intersect and their intersection\nresults in a\ngeometry of the same dimension but not equal to either of\nthe given\ngeometries.\n \nExamples\n-------- \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n| 0 |\n+----------------------+\n \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n| 0 |\n+----------------------+\n \nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbroverlaps(@g1,@g2);\n+----------------------+\n| mbroverlaps(@g1,@g2) |\n+----------------------+\n| 1 |\n+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbroverlaps/','','https://mariadb.com/kb/en/library/mbroverlaps/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (89,6,'MBRTouches','Syntax\n------ \nMBRTouches(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangles of\nthe two geometries g1 and g2 touch. Two geometries spatially\ntouch if\nthe interiors of the geometries do not intersect, but the\nboundary of\none of the geometries intersects either the boundary or the\ninterior\nof the other.\n \nExamples\n-------- \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((4 4,4 7,7 7,7 4,4 4))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n| 0 |\n+---------------------+\n \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n| 1 |\n+---------------------+\n \nSET @g1 = GeomFromText(\'Polygon((0 0,0 4,4 4,4 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((3 3,3 6,6 6,6 3,3 3))\');\nSELECT mbrtouches(@g1,@g2);\n+---------------------+\n| mbrtouches(@g1,@g2) |\n+---------------------+\n| 0 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbrtouches/','','https://mariadb.com/kb/en/library/mbrtouches/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (90,6,'MBRWithin','Syntax\n------ \nMBRWithin(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether the Minimum Bounding\nRectangle of\ng1 is within the Minimum Bounding Rectangle of g2. This\ntests the\nopposite relationship as MBRContains().\n \nExamples\n-------- \nSET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nSET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nSELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n| 1 | 0 |\n+--------------------+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mbrwithin/','','https://mariadb.com/kb/en/library/mbrwithin/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (91,7,'CASE OPERATOR','Syntax\n------ \nCASE value WHEN [compare_value] THEN result [WHEN\n[compare_value] THEN\nresult ...] [ELSE result] END\n \nCASE WHEN [condition] THEN result [WHEN [condition] THEN\nresult ...]\n[ELSE result] END\n \nDescription\n----------- \nThe first version returns the result where\nvalue=compare_value. The\nsecond version returns the result for the first condition\nthat is\ntrue. If there was no matching result value, the result\nafter ELSE is\nreturned, or NULL if there is no ELSE part.\n \nThere is also a CASE statement, which differs from the CASE\noperator described here.\n \nExamples\n-------- \nSELECT CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE\n\'more\' END;\n \n+------------------------------------------------------------+\n| CASE 1 WHEN 1 THEN \'one\' WHEN 2 THEN \'two\' ELSE\n\'more\' END |\n+------------------------------------------------------------+\n| one |\n+------------------------------------------------------------+\n \nSELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n \n+--------------------------------------------+\n| CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END |\n+--------------------------------------------+\n| true |\n+--------------------------------------------+\n \nSELECT CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2\nEND;\n \n+-----------------------------------------------------+\n| CASE BINARY \'B\' WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END\n|\n+-----------------------------------------------------+\n| NULL |\n+-----------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/case-operator/','','https://mariadb.com/kb/en/library/case-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (92,7,'IF Function','Syntax\n------ \nIF(expr1,expr2,expr3)\n \nDescription\n----------- \nIf expr1 is TRUE (expr1  0 and expr1  NULL) then IF()\nreturns expr2; otherwise it returns expr3. IF() returns a\nnumeric\nor string value, depending on the context in which it is\nused.\n \nNote: There is also an IF statement which differs from the\nIF() function described here.\n \nExamples\n-------- \nSELECT IF(1>2,2,3);\n+-------------+\n| IF(1>2,2,3) |\n+-------------+\n| 3 |\n+-------------+\n \nSELECT IF(1\n\nURL: https://mariadb.com/kb/en/library/if-function/','','https://mariadb.com/kb/en/library/if-function/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (93,7,'IFNULL','Syntax\n------ \nIFNULL(expr1,expr2)\n \nDescription\n----------- \nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it\nreturns\nexpr2. IFNULL() returns a numeric or string value, depending\non the\ncontext in which it is used.\n \nExamples\n-------- \nSELECT IFNULL(1,0); \n+-------------+\n| IFNULL(1,0) |\n+-------------+\n| 1 |\n+-------------+\n \nSELECT IFNULL(NULL,10);\n+-----------------+\n| IFNULL(NULL,10) |\n+-----------------+\n| 10 |\n+-----------------+\n \nSELECT IFNULL(1/0,10);\n+----------------+\n| IFNULL(1/0,10) |\n+----------------+\n| 10.0000 |\n+----------------+\n \nSELECT IFNULL(1/0,\'yes\');\n+-------------------+\n| IFNULL(1/0,\'yes\') |\n+-------------------+\n| yes |\n+-------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/ifnull/','','https://mariadb.com/kb/en/library/ifnull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (94,7,'NULLIF','Syntax\n------ \nNULLIF(expr1,expr2)\n \nDescription\n----------- \nReturns NULL if expr1 = expr2 is true, otherwise returns\nexpr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1\nEND.\n \nExamples\n-------- \nSELECT NULLIF(1,1);\n+-------------+\n| NULLIF(1,1) |\n+-------------+\n| NULL |\n+-------------+\n \nSELECT NULLIF(1,2);\n+-------------+\n| NULLIF(1,2) |\n+-------------+\n| 1 |\n+-------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/nullif/','','https://mariadb.com/kb/en/library/nullif/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (95,8,'CHANGE MASTER TO','Syntax\n------ \nCHANGE MASTER [\'connection_name\'] TO master_def [,\nmaster_def] ...\n \nmaster_def:\n MASTER_BIND = \'interface_name\'\n | MASTER_HOST = \'host_name\'[\n | MASTER_USER = \'user_name\'\n | MASTER_PASSWORD = \'password\'\n | MASTER_PORT = port_num\n | MASTER_CONNECT_RETRY = interval\n | MASTER_HEARTBEAT_PERIOD = interval\n | MASTER_LOG_FILE = \'master_log_name\'\n | MASTER_LOG_POS = master_log_pos\n | RELAY_LOG_FILE = \'relay_log_name\'\n | RELAY_LOG_POS = relay_log_pos\n | MASTER_DELAY = interval\n | MASTER_SSL = {0|1}\n | MASTER_SSL_CA = \'ca_file_name\'\n | MASTER_SSL_CAPATH = \'ca_directory_name\'\n | MASTER_SSL_CERT = \'cert_file_name\'\n | MASTER_SSL_CRL = \'crl_file_name\'\n | MASTER_SSL_CRLPATH = \'crl_directory_name\'\n | MASTER_SSL_KEY = \'key_file_name\'\n | MASTER_SSL_CIPHER = \'cipher_list\'\n | MASTER_SSL_VERIFY_SERVER_CERT = {0|1}\n | MASTER_USE_GTID = {current_pos|slave_pos|no}\n | IGNORE_SERVER_IDS = (server_id_list)\n | DO_DOMAIN_IDS = ([N,..])\n | IGNORE_DOMAIN_IDS = ([N,..])\n \nDescription\n----------- \nThe CHANGE MASTER statement sets the options that a\nreplication slave uses to connect to and replicate from a\nreplication master. \n \nMariaDB until 10.0.7\n \nIn MariaDB 10.0.7 and before, the relay_log_purge system\nvariable was silently set to 0 when CHANGE MASTER was\nexecuted.\n \nMulti-Source Replication\n \nMulti-source replication was added in MariaDB 10.0.1.\n \nIf you are using multi-source replication, then you need to\nspecify a connection name when you execute CHANGE MASTER.\nThere are two ways to do this:\nSetting the default_master_connection system variable prior\nto executing CHANGE MASTER.\nSetting the connection_name parameter when executing CHANGE\nMASTER.\n \ndefault_master_connection\n \nSET default_master_connection = \'gandalf\';\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n MASTER_PASSWORD=\'new3cret\';\n \nSTART SLAVE;\n \nconnection_name\n \nSTOP SLAVE \'gandalf\';\n \nCHANGE MASTER \'gandalf\' TO \n MASTER_PASSWORD=\'new3cret\';\n \nSTART SLAVE \'gandalf\';\n \nOptions\n \nConnection Options\n \nMASTER_USER\n \nThe MASTER_USER option for CHANGE MASTER defines the user\naccount that the replication slave will use to connect to\nthe replication master.\n \nThis user account will need the REPLICATION SLAVE privilege\non the master.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_USER=\'repl\',\n MASTER_PASSWORD=\'new3cret\';\n \nSTART SLAVE;\n \nMASTER_PASSWORD\n \nThe MASTER_USER option for CHANGE MASTER defines the\npassword that the replication slave will use to connect to\nthe replication master as the user account defined by the\nMASTER_USER option.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n MASTER_PASSWORD=\'new3cret\';\n \nSTART SLAVE;\n \nMASTER_HOST\n \nThe MASTER_HOST option for CHANGE MASTER defines the\nhostname or IP address of the replication master.\n \nIf you set the value of the MASTER_HOST option to the empty\nstring, then that is not the same as not setting the\noption\'s value at all. In MariaDB 5.5 and later, if you set\nthe value of the MASTER_HOST option to the empty string,\nthen the CHANGE MASTER command will fail with an error. In\nMariaDB 5.3 and before, if you set the value of the\nMASTER_HOST option to the empty string, then the CHANGE\nMASTER command would succeed, but the subsequent START SLAVE\ncommand would fail.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_HOST=\'dbserver1.example.com\',\n MASTER_USER=\'repl\',\n MASTER_PASSWORD=\'new3cret\',\n MASTER_USE_GTID=slave_pos;\n \nSTART SLAVE;\n \nIf you set the value of the MASTER_HOST option in a CHANGE\nMASTER command, then the slave assumes that the master is\ndifferent from before, even if you set the value of this\noption to the same value it had previously. In this\nscenario, the slave will consider the old values for the\nmaster\'s binary\nlog file name and position to be invalid for the new master.\nAs a side effect, if you do not explicitly set the values of\nthe MASTER_LOG_FILE and MASTER_LOG_POS options in the\nstatement, then the statement will be implicitly appended\nwith MASTER_LOG_FILE=\'\' and MASTER_LOG_POS=4. However, if\nyou enable GTID mode for replication by setting the\nMASTER_USE_GTID option to some value other than no in the\nstatement, then these values will effectively be ignored\nanyway.\n \nReplication slaves cannot connect to replication masters\nusing Unix socket files or Windows named pipes. The\nreplication slave must connect to the replication master\nusing TCP/IP.\n \nMASTER_PORT\n \nThe MASTER_PORT option for CHANGE MASTER defines the TCP/IP\nport of the replication master.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_HOST=\'dbserver1.example.com\',\n MASTER_PORT=3307,\n MASTER_USER=\'repl\',\n MASTER_PASSWORD=\'new3cret\',\n MASTER_USE_GTID=slave_pos;\n \nSTART SLAVE;\n \nIf you set the value of the MASTER_PORT option in a CHANGE\nMASTER command, then the slave assumes that the master is\ndifferent from before, even if you set the value of this\noption to the same value it had previously. In this\nscenario, the slave will consider the old values for the\nmaster\'s binary\nlog file name and position to be invalid for the new master.\nAs a side effect, if you do not explicitly set the values of\nthe MASTER_LOG_FILE and MASTER_LOG_POS options in the\nstatement, then the statement will be implicitly appended\nwith MASTER_LOG_FILE=\'\' and MASTER_LOG_POS=4. However, if\nyou enable GTID mode for replication by setting the\nMASTER_USE_GTID option to some value other than no in the\nstatement, then these values will effectively be ignored\nanyway.\n \nReplication slaves cannot connect to replication masters\nusing Unix socket files or Windows named pipes. The\nreplication slave must connect to the replication master\nusing TCP/IP.\n \nMASTER_CONNECT_RETRY\n \nThe MASTER_CONNECT_RETRY option for CHANGE MASTER defines\nhow many seconds that the slave will wait between connection\nretries. The default is 60.\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n MASTER_CONNECT_RETRY=20;\n \nSTART SLAVE;\n \nThe number of connection attempts is limited by the\nmaster_retry_count option. It can be set either on the\ncommand-line or in a server option group in an option file\nprior to starting up the server. For example:\n \n[mariadb]\n...\nmaster_retry_count=4294967295\n \nMASTER_BIND\n \nThe MASTER_BIND option for CHANGE MASTER is only supported\nby MySQL 5.6.2 and later and by MySQL NDB Cluster 7.3.1 and\nlater. This option is not yet supported by MariaDB. See\nMDEV-19248 for more information.\n \nThe MASTER_BIND option for CHANGE MASTER can be used on\nreplication slaves that have multiple network interfaces to\nchoose which network interface the slave will use to connect\nto the master.\n \nMASTER_HEARTBEAT_PERIOD\n \nThe MASTER_HEARTBEAT_PERIOD option for CHANGE MASTER can be\nused to set the interval in seconds between replication\nheartbeats. Whenever the master\'s binary log is updated\nwith an event, the waiting period for the next heartbeat is\nreset.\n \nThis option\'s interval argument has the following\ncharacteristics:\nIt is a decimal value with a range of 0 to 4294967 seconds.\nIt has a resolution of hundredths of a second.\nIts smallest valid non-zero value is 0.001.\nIts default value is the value of the slave_net_timeout\nsystem variable divided by 2.\nIf it\'s set to 0, then heartbeats are disabled.\n \nHeartbeats are sent by the master only if there are no\nunsent events in the binary log file for a period longer\nthan the interval.\n \nIf the RESET SLAVE statement is executed, then the heartbeat\ninterval is reset to the default.\n \nIf the slave_net_timeout system variable is set to a value\nthat is lower than the current heartbeat interval, then a\nwarning will be issued.\n \nTLS Options\n \nThe TLS options are used for providing information about\nTLS. The options can be set even on slaves that are compiled\nwithout TLS support. The TLS options are saved to either the\ndefault master.info file or the file that is configured by\nthe master_info_file option, but these TLS options are\nignored unless the slave supports TLS.\n \nSee Replication with Secure Connections for more\ninformation.\n \nMASTER_SSL\n \nThe MASTER_SSL option for CHANGE MASTER tells the slave\nwhether to force TLS for the connection. The valid values\nare 0 or 1.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL=1;\n \nSTART SLAVE;\n \nMASTER_SSL_CA\n \nThe MASTER_SSL_CA option for CHANGE MASTER defines a path to\na PEM file that should contain one or more X509 certificates\nfor trusted Certificate Authorities (CAs) to use for TLS.\nThis option requires that you use the absolute path, not a\nrelative path. This option implies the MASTER_SSL option.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1;\n \nSTART SLAVE;\n \nSee Secure Connections Overview: Certificate Authorities\n(CAs) for more information.\n \nMASTER_SSL_CAPATH\n \nThe MASTER_SSL_CAPATH option for CHANGE MASTER defines a\npath to a directory that contains one or more PEM files that\nshould each contain one X509 certificate for a trusted\nCertificate Authority (CA) to use for TLS. This option\nrequires that you use the absolute path, not a relative\npath. The directory specified by this option needs to be run\nthrough the openssl rehash command. This option implies the\nMASTER_SSL option.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CAPATH=\'/etc/my.cnf.d/certificates/ca/\',\n MASTER_SSL_VERIFY_SERVER_CERT=1;\n \nSTART SLAVE;\n \nSee Secure Connections Overview: Certificate Authorities\n(CAs) for more information.\n \nMASTER_SSL_CERT\n \nThe MASTER_SSL_CERT option for CHANGE MASTER defines a path\nto the X509 certificate file to use for TLS. This option\nrequires that you use the absolute path, not a relative\npath. This option implies the MASTER_SSL option.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1;\n \nSTART SLAVE;\n \nMASTER_SSL_CRL\n \nThe MASTER_SSL_CRL option for CHANGE MASTER defines a path\nto a PEM file that should contain one or more revoked X509\ncertificates to use for TLS. This option requires that you\nuse the absolute path, not a relative path.\n \nThis option is only supported if the server was built with\nOpenSSL. If the server was built with yaSSL, then this\noption is not supported. See TLS and Cryptography Libraries\nUsed by MariaDB for more information about which libraries\nare used on which platforms.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1,\n MASTER_SSL_CRL=\'/etc/my.cnf.d/certificates/crl.pem\';\n \nSTART SLAVE;\n \nSee Secure Connections Overview: Certificate Revocation\nLists (CRLs) for more information.\n \nMASTER_SSL_CRLPATH\n \nThe MASTER_SSL_CRLPATH option for CHANGE MASTER defines a\npath to a directory that contains one or more PEM files that\nshould each contain one revoked X509 certificate to use for\nTLS. This option requires that you use the absolute path,\nnot a relative path. The directory specified by this\nvariable needs to be run through the openssl rehash command.\n \nThis option is only supported if the server was built with\nOpenSSL. If the server was built with yaSSL, then this\noption is not supported. See TLS and Cryptography Libraries\nUsed by MariaDB for more information about which libraries\nare used on which platforms.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1,\n MASTER_SSL_CRLPATH=\'/etc/my.cnf.d/certificates/crl/\';\n \nSTART SLAVE;\n \nSee Secure Connections Overview: Certificate Revocation\nLists (CRLs) for more information.\n \nMASTER_SSL_KEY\n \nThe MASTER_SSL_KEY option for CHANGE MASTER defines a path\nto a private key file to use for TLS. This option requires\nthat you use the absolute path, not a relative path. This\noption implies the MASTER_SSL option.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1;\n \nSTART SLAVE;\n \nMASTER_SSL_CIPHER\n \nThe MASTER_SSL_CIPHER option for CHANGE MASTER defines the\nlist of permitted ciphers or cipher suites to use for TLS.\nBesides cipher names, if MariaDB was compiled with OpenSSL,\nthis option could be set to \"SSLv3\" or \"TLSv1.2\" to\nallow all SSLv3 or all TLSv1.2 ciphers. Note that the\nTLSv1.3 ciphers cannot be excluded when using OpenSSL, even\nby using this option. See Using TLSv1.3 for details. This\noption implies the MASTER_SSL option.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1,\n MASTER_SSL_CIPHER=\'TLSv1.2\';\n \nSTART SLAVE;\n \nMASTER_SSL_VERIFY_SERVER_CERT\n \nThe MASTER_SSL_VERIFY_SERVER_CERT option for CHANGE MASTER\nenables server certificate verification. This option is\ndisabled by default.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_SSL_CERT=\'/etc/my.cnf.d/certificates/server-cert.pem\',\n MASTER_SSL_KEY=\'/etc/my.cnf.d/certificates/server-key.pem\',\n MASTER_SSL_CA=\'/etc/my.cnf.d/certificates/ca.pem\',\n MASTER_SSL_VERIFY_SERVER_CERT=1;\n \nSTART SLAVE;\n \nSee Secure Connections Overview: Server Certificate\nVerification for more information.\n \nBinary Log Options\n \nThese options are related to the binary log position on the\nmaster.\n \nMASTER_LOG_FILE\n \nThe MASTER_LOG_FILE option for CHANGE MASTER can be used\nalong with MASTER_LOG_POS to specify the coordinates at\nwhich the slave\'s I/O thread should begin reading from the\nmaster\'s binary logs the next time the thread starts.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_LOG_FILE=\'master2-bin.001\',\n MASTER_LOG_POS=4;\n \nSTART SLAVE;\n \nThe MASTER_LOG_FILE and MASTER_LOG_POS options cannot be\nspecified if the RELAY_LOG_FILE and RELAY_LOG_POS options\nwere also specified.\n \nThe MASTER_LOG_FILE and MASTER_LOG_POS options are\neffectively ignored if you enable GTID mode for replication\nby setting the MASTER_USE_GTID option to some value other\nthan no in the statement.\n \nMASTER_LOG_POS\n \nThe MASTER_LOG_POS option for CHANGE MASTER can be used\nalong with MASTER_LOG_FILE to specify the coordinates at\nwhich the slave\'s I/O thread should begin reading from the\nmaster\'s binary logs the next time the thread starts.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_LOG_FILE=\'master2-bin.001\',\n MASTER_LOG_POS=4;\n \nSTART SLAVE;\n \nThe MASTER_LOG_FILE and MASTER_LOG_POS options cannot be\nspecified if the RELAY_LOG_FILE and RELAY_LOG_POS options\nwere also specified.\n \nThe MASTER_LOG_FILE and MASTER_LOG_POS options are\neffectively ignored if you enable GTID mode for replication\nby setting the MASTER_USE_GTID option to some value other\nthan no in the statement.\n \nRelay Log Options\n \nThese options are related to the relay log position on the\nslave.\n \nRELAY_LOG_FILE\n \nThe RELAY_LOG_FILE option for CHANGE MASTER can be used\nalong with the RELAY_LOG_POS option to specify the\ncoordinates at which the slave\'s SQL thread should begin\nreading from the relay log the next time the thread starts.\n \nThe CHANGE MASTER statement usually deletes all relay log\nfiles. However, if the RELAY_LOG_FILE and/or RELAY_LOG_POS\noptions are specified, then existing relay log files are\nkept.\n \nWhen you want to change the relay log position, you only\nneed to stop the slave\'s SQL thread. The slave\'s I/O\nthread can continue running. The STOP SLAVE and START SLAVE\nstatements support the SQL_THREAD option for this scenario.\nFor example:\n \nSTOP SLAVE SQL_THREAD;\n \nCHANGE MASTER TO\n RELAY_LOG_FILE=\'slave-relay-bin.006\',\n RELAY_LOG_POS=4025;\n \nSTART SLAVE SQL_THREAD;\n \nWhen the value of this option is changed, the metadata about\nthe slave\'s SQL thread\'s position in the relay logs will\nalso be changed in the relay-log.info file or the file that\nis configured by the relay_log_info_file system variable.\n \nThe RELAY_LOG_FILE and RELAY_LOG_POS options cannot be\nspecified if the MASTER_LOG_FILE and MASTER_LOG_POS options\nwere also specified.\n \nRELAY_LOG_POS\n \nThe RELAY_LOG_POS option for CHANGE MASTER can be used along\nwith the RELAY_LOG_FILE option to specify the coordinates at\nwhich the slave\'s SQL thread should begin reading from the\nrelay log the next time the thread starts.\n \nThe CHANGE MASTER statement usually deletes all relay log\nfiles. However, if the RELAY_LOG_FILE and/or RELAY_LOG_POS\noptions are specified, then existing relay log files are\nkept.\n \nWhen you want to change the relay log position, you only\nneed to stop the slave\'s SQL thread. The slave\'s I/O\nthread can continue running. The STOP SLAVE and START SLAVE\nstatements support the SQL_THREAD option for this scenario.\nFor example:\n \nSTOP SLAVE SQL_THREAD;\n \nCHANGE MASTER TO\n RELAY_LOG_FILE=\'slave-relay-bin.006\',\n RELAY_LOG_POS=4025;\n \nSTART SLAVE SQL_THREAD;\n \nWhen the value of this option is changed, the metadata about\nthe slave\'s SQL thread\'s position in the relay logs will\nalso be changed in the relay-log.info file or the file that\nis configured by the relay_log_info_file system variable.\n \nThe RELAY_LOG_FILE and RELAY_LOG_POS options cannot be\nspecified if the MASTER_LOG_FILE and MASTER_LOG_POS options\nwere also specified.\n \nGTID Options\n \nMASTER_USE_GTID\n \nThe MASTER_USE_GTID option for CHANGE MASTER was first added\nin MariaDB 10.0.2 to enable replication with Global\nTransaction IDs (GTIDs).\n \nThe MASTER_USE_GTID option for CHANGE MASTER can be used to\nconfigure the slave to use the global transaction ID (GTID)\nwhen connecting to a master. The possible values are:\ncurrent_pos - Replicate in GTID mode and use\ngtid_current_pos as the position to start downloading\ntransactions from the master.\nslave_pos - Replicate in GTID mode and use gtid_slave_pos as\nthe position to start downloading transactions from the\nmaster.\nno - Don\'t replicate in GTID mode.\n \nFor example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO\n MASTER_USE_GTID = current_pos;\n \nSTART SLAVE;\n \nOr:\n \nSTOP SLAVE;\n \nSET GLOBAL gtid_slave_pos=\'0-1-153\';\n \nCHANGE MASTER TO\n MASTER_USE_GTID = slave','','https://mariadb.com/kb/en/library/change-master-to/');
update help_topic set description = CONCAT(description, '_pos;\n \nSTART SLAVE;\n \nReplication Filter Options\n \nIGNORE_SERVER_IDS\n \nThe IGNORE_SERVER_IDS option for CHANGE MASTER can be used\nto configure a replication slave to ignore binary log events\nthat originated from certain servers. Filtered binary log\nevents will not get logged to the slave’s relay log, and\nthey will not be applied by the slave.\n \nThe option\'s value can be specified by providing a\ncomma-separated list of server_id values. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n IGNORE_SERVER_IDS = (3,5);\nSTART SLAVE;\n \nIf you would like to clear a previously set list, then you\ncan set the value to an empty list. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n IGNORE_SERVER_IDS = ();\nSTART SLAVE;\n \nDO_DOMAIN_IDS\n \nThe DO_DOMAIN_IDS option for CHANGE MASTER was first added\nin MariaDB 10.1.2.\n \nThe DO_DOMAIN_IDS option for CHANGE MASTER can be used to\nconfigure a replication slave to only apply binary log\nevents if the transaction\'s GTID is in a specific\ngtid_domain_id value. Filtered binary log events will not\nget logged to the slave’s relay log, and they will not be\napplied by the slave.\n \nThe option\'s value can be specified by providing a\ncomma-separated list of gtid_domain_id values. Duplicate\nvalues are automatically ignored. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n DO_DOMAIN_IDS = (1,2);\nSTART SLAVE;\n \nIf you would like to clear a previously set list, then you\ncan set the value to an empty list. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n DO_DOMAIN_IDS = ();\nSTART SLAVE;\n \nThe DO_DOMAIN_IDS option and the IGNORE_DOMAIN_IDS option\ncannot both be set to non-empty values at the same time. If\nyou want to set the DO_DOMAIN_IDS option, and the\nIGNORE_DOMAIN_IDS option was previously set, then you need\nto clear the value of the IGNORE_DOMAIN_IDS option. For\nexample:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n IGNORE_DOMAIN_IDS = (), \n DO_DOMAIN_IDS = (1,2);\nSTART SLAVE;\n \nThe DO_DOMAIN_IDS option can only be specified if the slave\nis replicating in GTID mode. Therefore, the MASTER_USE_GTID\noption must also be set to some value other than no in order\nto use this option.\n \nIGNORE_DOMAIN_IDS\n \nThe IGNORE_DOMAIN_IDS option for CHANGE MASTER was first\nadded in MariaDB 10.1.2.\n \nThe IGNORE_DOMAIN_IDS option for CHANGE MASTER can be used\nto configure a replication slave to ignore binary log events\nif the transaction\'s GTID is in a specific gtid_domain_id\nvalue. Filtered binary log events will not get logged to the\nslave’s relay log, and they will not be applied by the\nslave.\n \nThe option\'s value can be specified by providing a\ncomma-separated list of gtid_domain_id values. Duplicate\nvalues are automatically ignored. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n IGNORE_DOMAIN_IDS = (1,2);\nSTART SLAVE;\n \nIf you would like to clear a previously set list, then you\ncan set the value to an empty list. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n IGNORE_DOMAIN_IDS = ();\nSTART SLAVE;\n \nThe DO_DOMAIN_IDS option and the IGNORE_DOMAIN_IDS option\ncannot both be set to non-empty values at the same time. If\nyou want to set the IGNORE_DOMAIN_IDS option, and the\nDO_DOMAIN_IDS option was previously set, then you need to\nclear the value of the DO_DOMAIN_IDS option. For example:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n DO_DOMAIN_IDS = (), \n IGNORE_DOMAIN_IDS = (1,2);\nSTART SLAVE;\n \nThe IGNORE_DOMAIN_IDS option can only be specified if the\nslave is replicating in GTID mode. Therefore, the\nMASTER_USE_GTID option must also be set to some value other\nthan no in order to use this option.\n \nDelayed Replication Options\n \nMASTER_DELAY\n \nThe MASTER_DELAY option for CHANGE MASTER was first added in\nMariaDB 10.2.3 to enable delayed replication.\n \nThe MASTER_DELAY option for CHANGE MASTER can be used to\nenable delayed replication. This option specifies the time\nin seconds (at least) that a replication slave should lag\nbehind the master. Before executing an event, the slave will\nfirst wait, if necessary, until the given time has passed\nsince the event was created on the master. The result is\nthat the slave will reflect the state of the master some\ntime back in the past. The default is zero, no delay.\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n MASTER_DELAY=3600;\n \nSTART SLAVE;\n \nChanging Option Values\n \nIf you don\'t specify a given option when executing the\nCHANGE MASTER statement, then the option keeps its old value\nin most cases. Most of the time, there is no need to specify\nthe options that do not need to change. For example, if the\npassword for the user account that the slave uses to connect\nto its master has changed, but no other options need to\nchange, then you can just change the MASTER_PASSWORD option\nby executing the following commands:\n \nSTOP SLAVE;\n \nCHANGE MASTER TO \n MASTER_PASSWORD=\'new3cret\';\n \nSTART SLAVE;\n \nThere are some cases where options are implicitly reset,\nsuch as when the MASTER_HOST and MASTER_PORT options are\nchanged.\n \nOption Persistence\n \nThe values of the MASTER_LOG_FILE and MASTER_LOG_POS options\n(i.e. the binary log position on the master) and most other\noptions are written to either the default master.info file\nor the file that is configured by the master_info_file\noption. The slave\'s I/O thread keeps this binary log\nposition updated as it downloads events only when\nMASTER_USE_GTID option\n is set to NO. Otherwise the file is not updated on a per\nevent basis.\n \nThe master_info_file option can be set either on the\ncommand-line or in a server option group in an option file\nprior to starting up the server. For example:\n \n[mariadb]\n...\nmaster_info_file=/mariadb/myserver1-master.info\n \nThe values of the RELAY_LOG_FILE and RELAY_LOG_POS options\n(i.e. the relay log position) are written to either the\ndefault relay-log.info file or the file that is configured\nby the relay_log_info_file system variable. The slave\'s SQL\nthread keeps this relay log position updated as it applies\nevents.\n \nThe relay_log_info_file system variable can be set either on\nthe command-line or in a server option group in an option\nfile prior to starting up the server. For example:\n \n[mariadb]\n...\nrelay_log_info_file=/mariadb/myserver1-relay-log.info\n \nGTID Persistence\n \nIf the slave is replicating binary log events that contain\nGTIDs, then the slave\'s SQL thread will write every GTID\nthat it applies to the mysql.gtid_slave_pos table. This GTID\ncan be inspected and modified through the gtid_slave_pos\nsystem variable.\n \nIf the slave has the log_slave_updates system variable\nenabled and if the slave has the binary log enabled, then\nevery write by the slave\'s SQL thread will also go into the\nslave\'s binary log. This means that GTIDs of replicated\ntransactions would be reflected in the value of the\ngtid_binlog_pos system variable.\n \nCreating a Slave from a Backup\n \nThe CHANGE MASTER statement is useful for setting up a slave\nwhen you have a backup of the master and you also have the\nbinary log position or GTID position corresponding to the\nbackup.\n \nAfter restoring the backup on the slave, you could execute\nsomething like this to use the binary log position:\n \nCHANGE MASTER TO\n MASTER_LOG_FILE=\'master2-bin.001\',\n MASTER_LOG_POS=4;\n \nSTART SLAVE;\n \nOr you could execute something like this to use the GTID\nposition:\n \nSET GLOBAL gtid_slave_pos=\'0-1-153\';\n \nCHANGE MASTER TO\n MASTER_USE_GTID=slave_pos;\n \nSTART SLAVE;\n \nSee Setting up a Replication Slave with Mariabackup for more\ninformation on how to do this with Mariabackup.\n \nExample\n \nThe following example changes the master and master\'s\nbinary log coordinates.\nThis is used when you want to set up the slave to replicate\nthe master:\n \nCHANGE MASTER TO\n MASTER_HOST=\'master2.mycompany.com\',\n MASTER_USER=\'replication\',\n MASTER_PASSWORD=\'bigs3cret\',\n MASTER_PORT=3306,\n MASTER_LOG_FILE=\'master2-bin.001\',\n MASTER_LOG_POS=4,\n MASTER_CONNECT_RETRY=10;\n \nSTART SLAVE;\n \n\n\nURL: https://mariadb.com/kb/en/library/change-master-to/') WHERE help_topic_id = 95;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (96,8,'COMMIT','The COMMIT statement ends a transaction, saving any changes\nto the data so that they become visible to subsequent\ntransactions. Also, unlocks metadata changed by current\ntransaction. If autocommit is set to 1, an implicit commit\nis performed after each statement. Otherwise, all\ntransactions which don\'t end with an explicit COMMIT are\nimplicitly rollbacked and the changes are lost. The ROLLBACK\nstatement can be used to do this explicitly.\n \nThe required syntax for the COMMIT statement is as follows:\n \nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\n \nCOMMIT is the more important transaction terminator, as well\nas the more interesting one. The basic form of the COMMIT\nstatement is simply the keyword COMMIT (the keyword WORK is\nsimply noise and can be omitted without changing the\neffect).\n \nThe optional AND CHAIN clause is a convenience for\ninitiating a new transaction as soon as the old transaction\nterminates. If AND CHAIN is specified, then there is\neffectively nothing between the old and new transactions,\nalthough they remain separate. The characteristics of the\nnew transaction will be the same as the characteristics of\nthe old one — that is, the new transaction will have the\nsame access mode, isolation level and diagnostics area size\n(we\'ll discuss all of these shortly) as the transaction\njust terminated. \n \nRELEASE tells the server to disconnect the client\nimmediately after the current transaction.\n \nThere are NO RELEASE and AND NO CHAIN options. By default,\ncommits do not RELEASE or CHAIN, but it\'s possible to\nchange this default behavior with the completion_type server\nsystem variable. In this case, the AND NO CHAIN and NO\nRELEASE options override the server default.\n \n\n\nURL: https://mariadb.com/kb/en/library/commit/','','https://mariadb.com/kb/en/library/commit/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (97,8,'DEALLOCATE / DROP PREPARE','Syntax\n------ \n{DEALLOCATE | DROP} PREPARE stmt_name\n \nDescription\n----------- \nTo deallocate a prepared statement produced with PREPARE,\nuse a\nDEALLOCATE PREPARE statement that refers to the prepared\nstatement\nname.\n \nA prepared statement is implicitly deallocated when a new\nPREPARE command is issued. In that case, there is no need to\nuse DEALLOCATE.\n \nAttempting to execute a prepared statement after\ndeallocating it\nresults in an error, as if it was not prepared at all:\n \nERROR 1243 (HY000): Unknown prepared statement handler\n(stmt_name) given to EXECUTE\n \nIf the specified statement has not been PREPAREd, an error\nsimilar to the following will be produced:\n \nERROR 1243 (HY000): Unknown prepared statement handler\n(stmt_name) given to DEALLOCATE PREPARE\n \nExample\n \nSee example in PREPARE.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/deallocate-drop-prepared-statement/','','https://mariadb.com/kb/en/library/deallocate-drop-prepared-statement/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (98,8,'EXECUTE Statement','Syntax\n------ \nEXECUTE stmt_name\n [USING expression[, expression] ...]\n \nEXECUTE with expression as parameters was introduced in\nMariaDB 10.2.3. Before that one could only use variables\n(@var_name) as parameters.\n \nDescription\n----------- \nAfter preparing a statement with PREPARE, you execute it\nwith an\nEXECUTE statement that refers to the prepared statement\nname. If the\nprepared statement contains any parameter markers, you must\nsupply a\nUSING clause that lists user variables containing the values\nto be\nbound to the parameters. Parameter values can be supplied\nonly by user\nvariables, and the USING clause must name exactly as many\nvariables as\nthe number of parameter markers in the statement.\n \nYou can execute a given prepared statement multiple times,\npassing\ndifferent variables to it or setting the variables to\ndifferent values\nbefore each execution.\n \nIf the specified statement has not been PREPAREd, an error\nsimilar to the following is produced:\n \nERROR 1243 (HY000): Unknown prepared statement handler\n(stmt_name) given to EXECUTE\n \nExample\n \nSee example in PREPARE.\n \n\n\nURL: https://mariadb.com/kb/en/library/execute-statement/','','https://mariadb.com/kb/en/library/execute-statement/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (99,8,'EXECUTE IMMEDIATE','EXECUTE IMMEDIATE was introduced in MariaDB 10.2.3.\n \nSyntax\n------ \nEXECUTE IMMEDIATE statement\n \nDescription\n----------- \nEXECUTE IMMEDIATE executes a dynamic SQL statement created\non the fly, which can reduce performance overhead.\n \nFor example:\n \nEXECUTE IMMEDIATE \'SELECT 1\' \n \nwhich is shorthand for:\n \nprepare stmt from \"select 1\";\n \nexecute stmt;\n \ndeallocate prepare stmt;\n \nEXECUTE IMMEDIATE supports complex expressions as prepare\nsource and parameters:\n \nEXECUTE IMMEDIATE CONCAT(\'SELECT COUNT(*) FROM \', \'t1\',\n\' WHERE a=?\') USING 5+5;\n \nLimitations: subselects and stored function calls are not\nsupported as a prepare source.\n \nThe following examples return an error:\n \nCREATE OR REPLACE FUNCTION f1() RETURNS VARCHAR(64) RETURN\n\'SELECT * FROM t1\';\nEXECUTE IMMEDIATE f1();\nERROR 1970 (42000): EXECUTE IMMEDIATE does not support\nsubqueries or stored functions\n \nEXECUTE IMMEDIATE (SELECT \'SELECT * FROM t1\');\nERROR 1064 (42000): You have an error in your SQL syntax;\ncheck the manual that \n corresponds to your MariaDB server version for the right\nsyntax to use near \n \'SELECT \'SELECT * FROM t1\')\' at line 1\n \nCREATE OR REPLACE FUNCTION f1() RETURNS INT RETURN 10;\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING f1();\nERROR 1970 (42000): EXECUTE..USING does not support\nsubqueries or stored functions\n \nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\n(SELECT 10);\nERROR 1064 (42000): You have an error in your SQL syntax;\ncheck the manual that \n corresponds to your MariaDB server version for the right\nsyntax to use near \n \'SELECT 10)\' at line 1\n \nOne can use a user or an SP variable as a workaround:\n \nCREATE OR REPLACE FUNCTION f1() RETURNS VARCHAR(64) RETURN\n\'SELECT * FROM t1\';\nSET @stmt=f1();\nEXECUTE IMMEDIATE @stmt;\n \nSET @stmt=(SELECT \'SELECT 1\');\nEXECUTE IMMEDIATE @stmt;\n \nCREATE OR REPLACE FUNCTION f1() RETURNS INT RETURN 10;\nSET @param=f1();\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\n@param;\n \nSET @param=(SELECT 10);\nEXECUTE IMMEDIATE \'SELECT * FROM t1 WHERE a=?\' USING\n@param;\n \nEXECUTE IMMEDIATE supports user variables and SP variables\nas OUT parameters\n \nDELIMITER $$\nCREATE OR REPLACE PROCEDURE p1(OUT a INT)\nBEGIN\n SET a:= 10;\nEND;\n$$\nDELIMITER ;\nSET @a=2;\nEXECUTE IMMEDIATE \'CALL p1(?)\' USING @a;\nSELECT @a;\n+------+\n| @a |\n+------+\n| 10 |\n+------+\n \nSimilar to PREPARE, EXECUTE IMMEDIATE is allowed in stored\nprocedures but is not allowed in stored functions.\n \nThis example uses EXECUTE IMMEDIATE inside a stored\nprocedure:\n \nDELIMITER $$\nCREATE OR REPLACE PROCEDURE p1()\nBEGIN\n EXECUTE IMMEDIATE \'SELECT 1\';\nEND;\n$$\nDELIMITER ;\nCALL p1;\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n \nThis script returns an error:\n \nDELIMITER $$\nCREATE FUNCTION f1() RETURNS INT\nBEGIN\n EXECUTE IMMEDIATE \'DO 1\';\n RETURN 1;\nEND;\n$$\nERROR 1336 (0A000): Dynamic SQL is not allowed in stored\nfunction or trigger\n \nEXECUTE IMMEDIATE can use DEFAULT and IGNORE indicators as\nbind parameters:\n \nCREATE OR REPLACE TABLE t1 (a INT DEFAULT 10);\nEXECUTE IMMEDIATE \'INSERT INTO t1 VALUES (?)\' USING\nDEFAULT;\nSELECT * FROM t1;\n+------+\n| a |\n+------+\n| 10 |\n+------+\n \nEXECUTE IMMEDIATE increments the Com_execute_immediate\nstatus variable, as well as the Com_stmt_prepare,\nCom_stmt_execute and Com_stmt_close status variables.\n \nNote, EXECUTE IMMEDIATE does not increment the\nCom_execute_sql status variable. Com_execute_sql is used\nonly for PREPARE..EXECUTE.\n \nThis session screenshot demonstrates how EXECUTE IMMEDIATE\naffects status variables:\n \nSELECT * FROM INFORMATION_SCHEMA.SESSION_STATUS WHERE\nVARIABLE_NAME RLIKE \n (\'COM_(EXECUTE|STMT_PREPARE|STMT_EXECUTE|STMT_CLOSE)\');\n \n+-----------------------+----------------+\n| VARIABLE_NAME | VARIABLE_VALUE |\n+-----------------------+----------------+\n| COM_EXECUTE_IMMEDIATE | 0 |\n| COM_EXECUTE_SQL | 0 |\n| COM_STMT_CLOSE | 0 |\n| COM_STMT_EXECUTE | 0 |\n| COM_STMT_PREPARE | 0 |\n+-----------------------+----------------+\n \nEXECUTE IMMEDIATE \'SELECT 1\';\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n \nSELECT * FROM INFORMATION_SCHEMA.SESSION_STATUS WHERE\nVARIABLE_NAME RLIKE \n (\'COM_(EXECUTE|STMT_PREPARE|STMT_EXECUTE|STMT_CLOSE)\');\n+-----------------------+----------------+\n| VARIABLE_NAME | VARIABLE_VALUE |\n+-----------------------+----------------+\n| COM_EXECUTE_IMMEDIATE | 1 |\n| COM_EXECUTE_SQL | 0 |\n| COM_STMT_CLOSE | 1 |\n| COM_STMT_EXECUTE | 1 |\n| COM_STMT_PREPARE | 1 |\n+-----------------------+----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/execute-immediate/','','https://mariadb.com/kb/en/library/execute-immediate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (100,8,'LOCK TABLES','Syntax\n------ \nLOCK TABLE[S]\n tbl_name [[AS] alias] lock_type\n [, tbl_name [[AS] alias] lock_type] ...\n [WAIT n|NOWAIT]\n \nlock_type:\n READ [LOCAL]\n | [LOW_PRIORITY] WRITE\n | WRITE CONCURRENT\n \nUNLOCK TABLES\n \nDescription\n----------- \nThe lock_type can be one of:\n \nOption | Description | \n \nREAD | Read lock, no writes allowed | \n \nREAD LOCAL | Read lock, but allow concurrent inserts | \n \nWRITE | Exclusive write lock. No other connections can read\nor write to this table | \n \nLOW_PRIORITY WRITE | Exclusive write lock, but allow new\nread locks on the table until we get the write lock. | \n \nWRITE CONCURRENT | Exclusive write lock, but allow READ\nLOCAL locks to the table. | \n \nMariaDB enables client sessions to acquire table locks\nexplicitly for the\npurpose of cooperating with other sessions for access to\ntables, or to\nprevent other sessions from modifying tables during periods\nwhen a\nsession requires exclusive access to them. A session can\nacquire or\nrelease locks only for itself. One session cannot acquire\nlocks for\nanother session or release locks held by another session.\n \nLocks may be used to emulate transactions or to get more\nspeed when\nupdating tables.\n \nLOCK TABLES explicitly acquires table locks for the current\nclient session.\nTable locks can be acquired for base tables or views. To use\nLOCK TABLES,\nyou must have the LOCK TABLES privilege, and the SELECT\nprivilege for\neach object to be locked. See GRANT\n \nFor view locking, LOCK TABLES adds all base tables used in\nthe view to the\nset of tables to be locked and locks them automatically. If\nyou lock a table\nexplicitly with LOCK TABLES, any tables used in triggers are\nalso locked\nimplicitly, as described in Triggers and Implicit Locks.\n \nUNLOCK TABLES explicitly releases any table locks held by\nthe\ncurrent session.\n \nWAIT/NOWAIT\n \nSet the lock wait timeout. See WAIT and NOWAIT.\n \nLimitations\n \nLOCK TABLES doesn\'t work when using Galera cluster. You may\nexperience crashes or locks when used with Galera.\n \nLOCK TABLES works on XtraDB/InnoDB tables only if the\ninnodb_table_locks system variable is set to 1 (the default)\nand autocommit is set to 0 (1 is default). Please note that\nno error message will be returned on LOCK TABLES with\ninnodb_table_locks = 0.\n \nLOCK TABLES implicitly commits the active transaction, if\nany. Also, starting a transaction always releases all table\nlocks acquired with LOCK TABLES. This means that there is no\nway to have table locks and an active transaction at the\nsame time. The only exceptions are the transactions in\nautocommit mode. To preserve the data integrity between\ntransactional and non-transactional tables, the GET_LOCK()\nfunction can be used.\n \nWhile a connection holds an explicit read lock on a table,\nit cannot modify it. If you try, the following error will be\nproduced:\n \nERROR 1099 (HY000): Table \'tab_name\' was locked with a\nREAD lock and can\'t be updated\n \nWhile a connection holds an explicit lock on a table, it\ncannot access a non-locked table. If you try, the following\nerror will be produced:\n \nERROR 1100 (HY000): Table \'tab_name\' was not locked with\nLOCK TABLES\n \nWhile a connection holds an explicit lock on a table, it\ncannot issue the following: INSERT DELAYED, CREATE TABLE,\nCREATE TABLE ... LIKE, and DDL statements involving stored\nprograms and views (except for triggers). If you try, the\nfollowing error will be produced:\n \nERROR 1192 (HY000): Can\'t execute the given command because\nyou have active locked tables or an active transaction\n \nLOCK TABLES can not be used in stored routines - if you try,\nthe following error will be produced on creation:\n \nERROR 1314 (0A000): LOCK is not allowed in stored procedures\n \n\n\nURL: https://mariadb.com/kb/en/library/lock-tables/','','https://mariadb.com/kb/en/library/lock-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (101,8,'ROLLBACK','The ROLLBACK statement rolls back (ends) a transaction,\ndestroying any changes to SQL-data so that they never become\nvisible to subsequent transactions. The required syntax for\nthe ROLLBACK statement is as follows. \n \nROLLBACK [ WORK ] [ AND [ NO ] CHAIN ] \n[ TO [ SAVEPOINT ] { | } ]\n \nThe ROLLBACK statement will either end a transaction,\ndestroying all data changes that happened during any of the\ntransaction, or it will just destroy any data changes that\nhappened since you established a savepoint. The basic form\nof the ROLLBACK statement is just the keyword ROLLBACK (the\nkeyword WORK is simply noise and can be omitted without\nchanging the effect). \n \nThe optional AND CHAIN clause is a convenience for\ninitiating a new transaction as soon as the old transaction\nterminates. If AND CHAIN is specified, then there is\neffectively nothing between the old and new transactions,\nalthough they remain separate. The characteristics of the\nnew transaction will be the same as the characteristics of\nthe old one — that is, the new transaction will have the\nsame access mode, isolation level and diagnostics area size\n(we\'ll discuss all of these shortly) as the transaction\njust terminated. The AND NO CHAIN option just tells your\nDBMS to end the transaction — that is, these four SQL\nstatements are equivalent: \n \nROLLBACK;\n \nROLLBACK WORK;\n \nROLLBACK AND NO CHAIN;\n \nROLLBACK WORK AND NO CHAIN;\n \nAll of them end a transaction without saving any transaction\ncharacteristics. The only other options, the equivalent\nstatements: \n \nROLLBACK AND CHAIN;\n \nROLLBACK WORK AND CHAIN;\n \nboth tell your DBMS to end a transaction, but to save that\ntransaction\'s characteristics for the next transaction. \n \nROLLBACK is much simpler than COMMIT: it may involve no more\nthan a few deletions (of Cursors, locks, prepared SQL\nstatements and log-file entries). It\'s usually assumed that\nROLLBACK can\'t fail, although such a thing is conceivable\n(for example, an encompassing transaction might reject an\nattempt to ROLLBACK because it\'s lining up for a COMMIT). \n \nROLLBACK cancels all effects of a transaction. It does not\ncancel effects on objects outside the DBMS\'s control (for\nexample the values in host program variables or the settings\nmade by some SQL/CLI function calls). But in general, it is\na convenient statement for those situations when you say\n\"oops, this isn\'t working\" or when you simply don\'t care\nwhether your temporary work becomes permanent or not.\n \nHere is a moot question. If all you\'ve been doing is\nSELECTs, so that there have been no data changes, should you\nend the transaction with ROLLBACK or COMMIT? It shouldn\'t\nreally matter because both ROLLBACK and COMMIT do the same\ntransaction-terminating job. However, the popular conception\nis that ROLLBACK implies failure, so after a successful\nseries of SELECT statements the convention is to end the\ntransaction with COMMIT rather than ROLLBACK.\n \nMariaDB (and most other DBMSs) supports rollback of SQL-data\nchange statements, but not of SQL-Schema statements. This\nmeans that if you use any of CREATE, ALTER, DROP, GRANT,\nREVOKE, you are implicitly committing at execution time.\n \nINSERT INTO Table_2 VALUES(5); \nDROP TABLE Table_3 CASCADE;\n \nROLLBACK;\n \nThe result will be that both the INSERT and the DROP will go\nthrough as separate transactions so the ROLLBACK will have\nno effect. \n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/rollback/','','https://mariadb.com/kb/en/library/rollback/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (102,8,'SAVEPOINT','Syntax\n------ \nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n \nDescription\n----------- \nInnoDB supports the SQL statements SAVEPOINT,\nROLLBACK TO SAVEPOINT, RELEASE SAVEPOINT\nand the optional WORK keyword for\nROLLBACK.\n \nEach savepoint must have a legal MariaDB identifier. A\nsavepoint is a named sub-transaction.\n \nNormally ROLLBACK undoes the changes performed by the whole\ntransaction. When used with the TO clause, it undoes the\nchanges performed after the specified savepoint, and erases\nall subsequent savepoints. However, all locks that have been\nacquired after the save point will survive. RELEASE\nSAVEPOINT does not rollback or commit any changes, but\nremoves the specified savepoint.\n \nWhen the execution of a trigger or a stored function begins,\nit is not possible to use statements which reference a\nsavepoint which was defined from out of that stored program.\n \nWhen a COMMIT (including implicit commits) or a ROLLBACK\nstatement (with no TO clause) is performed, they act on the\nwhole transaction, and all savepoints are removed.\n \nErrors\n \nIf COMMIT or ROLLBACK is issued and no transaction was\nstarted, no error is reported.\n \nIf SAVEPOINT is issued and no transaction was started, no\nerror is reported but no savepoint is created. When ROLLBACK\nTO SAVEPOINT or RELEASE SAVEPOINT is called for a savepoint\nthat does not exist, an error like this is issued:\n \nERROR 1305 (42000): SAVEPOINT svp_name does not exist\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/savepoint/','','https://mariadb.com/kb/en/library/savepoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (103,8,'Metadata Locking','Metadata locking has been supported since MariaDB 5.5. This\nmeans that when a transaction (including XA transactions)\nuses a table, it locks its metadata until the end of\ntransaction. Non-transactional tables are also locked, as\nwell as views and objects which are related to locked\ntables/views (stored functions, triggers, etc). When a\nconnection tries to use a DDL statement (like an ALTER\nTABLE) which modifies a table that is locked, that\nconnection is queued, and has to wait until it\'s unlocked.\nUsing savepoints and performing a partial rollback does not\nrelease metadata locks.\n \nLOCK TABLES ... WRITE are also queued. Some wrong statements\nwhich produce an error may not need to wait for the lock to\nbe freed.\n \nMetadata lock\'s timeout is determined by the value of the\nlock_wait_timeout server system variable (in seconds).\nHowever, note that its default value is 31536000 (1 year).\nIf this timeout exceeds, the following error is returned:\n \nERROR 1205 (HY000): Lock wait timeout exceeded;\n try restarting transaction\n \nIf the metadata_lock_info plugin is installed, the\nInformation Schema metadata_lock_info table stores\ninformation about existing metadata locks.\n \nExample\n \nLet\'s use the following MEMORY (non-transactional) table:\n \nCREATE TABLE t (a INT) ENGINE = MEMORY;\n \nConnection 1 starts a transaction, and INSERTs a row into t:\n \nSTART TRANSACTION;\n \nINSERT INTO t SET a=1;\n \nt\'s metadata is now locked by connection 1. Connection 2\ntries to alter t, but has to wait:\n \nALTER TABLE t ADD COLUMN b INT;\n \nConnection 2\'s prompt is blocked now.\n \nNow connection 1 ends the transaction:\n \nCOMMIT;\n \n...and connection 2 finally gets the output of its command:\n \nQuery OK, 1 row affected (35.23 sec)\nRecords: 1 Duplicates: 0 Warnings: 0\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/metadata-locking/','','https://mariadb.com/kb/en/library/metadata-locking/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (104,8,'PREPARE Statement','Syntax\n------ \nPREPARE stmt_name FROM preparable_stmt\n \nDescription\n----------- \nThe PREPARE statement prepares a statement and assigns it a\nname,\nstmt_name, by which to refer to the statement later.\nStatement names\nare not case sensitive. preparable_stmt is either a string\nliteral or a user variable (not a local variable, an SQL\nexpression or a subquery) that contains the text of the\nstatement. The text must \nrepresent a single SQL statement, not multiple statements.\nWithin the\nstatement, \"?\" characters can be used as parameter markers\nto indicate\nwhere data values are to be bound to the query later when\nyou execute\nit. The \"?\" characters should not be enclosed within\nquotes, even if\nyou intend to bind them to string values. Parameter markers\ncan be used\nonly where data values should appear, not for SQL keywords,\nidentifiers, and so forth.\n \nThe scope of a prepared statement is the session within\nwhich it is\ncreated. Other sessions cannot see it.\n \nIf a prepared statement with the given name already exists,\nit is\ndeallocated implicitly before the new statement is prepared.\nThis means\nthat if the new statement contains an error and cannot be\nprepared, an\nerror is returned and no statement with the given name\nexists.\n \nPrepared statements can be PREPAREd and EXECUTEd in a stored\nprocedure, but not in a stored function or trigger. Also,\neven if the statement is PREPAREd in a procedure, it will\nnot be deallocated when the procedure execution ends.\n \nA prepared statement can access user-defined variables, but\nnot local variables or procedure\'s parameters.\n \nIf the prepared statement contains a syntax error, PREPARE\nwill fail. As a side effect, stored procedures can use it to\ncheck if a statement is valid. For example:\n \nCREATE PROCEDURE `test_stmt`(IN sql_text TEXT)\nBEGIN\n DECLARE EXIT HANDLER FOR SQLEXCEPTION\n BEGIN\n SELECT CONCAT(sql_text, \' is not valid\');\n END;\n SET @SQL := sql_text;\n PREPARE stmt FROM @SQL;\n DEALLOCATE PREPARE stmt;\nEND;\n \nThe FOUND_ROWS() and ROW_COUNT() functions, if called\nimmediatly after EXECUTE, return the number of rows read or\naffected by the prepared statements; however, if they are\ncalled after DEALLOCATE PREPARE, they provide information\nabout this statement. If the prepared statement produces\nerrors or warnings, GET DIAGNOSTICS return information about\nthem. DEALLOCATE PREPARE shouldn\'t clear the diagnostics\narea, unless it produces an error.\n \nA prepared statement is executed with EXECUTE and released \nwith DEALLOCATE PREPARE.\n \nThe max_prepared_stmt_count server system variable\ndetermines the number of allowed prepared statements that\ncan be prepared on the server. If it is set to 0, prepared\nstatements are not allowed. If the limit is reached, an\nerror similar to the following will be produced:\n \nERROR 1461 (42000): Can\'t create more than\nmax_prepared_stmt_count statements \n (current value: 0)\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, PREPARE stmt FROM \'SELECT\n:1, :2\' is used, instead of ?.\n \nPermitted Statements\n \nNot all statements can be prepared. Only the following SQL\ncommands are permitted:\nALTER TABLE\nANALYZE TABLE\nBINLOG\nCACHE INDEX\nCALL\nCHANGE MASTER\nCHECKSUM {TABLE | TABLES}\nCOMMIT\n{CREATE | DROP} DATABASE\n{CREATE | DROP} INDEX\n{CREATE | RENAME | DROP} TABLE\n{CREATE | RENAME | DROP} USER\n{CREATE | DROP} VIEW\nDELETE\nDESCRIBE\nDO\nEXPLAIN\nFLUSH {TABLE | TABLES | TABLES WITH READ LOCK | HOSTS |\nPRIVILEGES | LOGS | STATUS | \n MASTER | SLAVE | DES_KEY_FILE | USER_RESOURCES | QUERY\nCACHE | TABLE_STATISTICS | \n INDEX_STATISTICS | USER_STATISTICS | CLIENT_STATISTICS}\nGRANT\nINSERT\nINSTALL {PLUGIN | SONAME}\nHANDLER READ\nKILL\nLOAD INDEX INTO CACHE\nOPTIMIZE TABLE\nREPAIR TABLE\nREPLACE\nRESET {MASTER | SLAVE | QUERY CACHE}\nREVOKE\nROLLBACK\nSELECT\nSET\nSET GLOBAL SQL_SLAVE_SKIP_COUNTER\nSET ROLE\nSET SQL_LOG_BIN\nSET TRANSACTION ISOLATION LEVEL\nSHOW EXPLAIN\nSHOW {DATABASES | TABLES | OPEN TABLES | TABLE STATUS |\nCOLUMNS | INDEX | TRIGGERS | \n EVENTS | GRANTS | CHARACTER SET | COLLATION | ENGINES |\nPLUGINS [SONAME] | PRIVILEGES | \n PROCESSLIST | PROFILE | PROFILES | VARIABLES | STATUS |\nWARNINGS | ERRORS | \n TABLE_STATISTICS | INDEX_STATISTICS | USER_STATISTICS |\nCLIENT_STATISTICS | AUTHORS | \n CONTRIBUTORS}\nSHOW CREATE {DATABASE | TABLE | VIEW | PROCEDURE | FUNCTION\n| TRIGGER | EVENT}\nSHOW {FUNCTION | PROCEDURE} CODE\nSHOW BINLOG EVENTS\nSHOW SLAVE HOSTS\nSHOW {MASTER | BINARY} LOGS\nSHOW {MASTER | SLAVE | TABLES | INNODB | FUNCTION |\nPROCEDURE} STATUS\nSLAVE {START | STOP}\nTRUNCATE TABLE\nSHUTDOWN\nUNINSTALL {PLUGIN | SONAME}\nUPDATE\n \nSynonyms are not listed here, but can be used. For example,\nDESC can be used instead of DESCRIBE.\n \nCompound statements can be prepared too.\n \nNote that if a statement can be run in a stored routine, it\nwill work even if it is called by a prepared statement. For\nexample, SIGNAL can\'t be directly prepared. However, it is\nallowed in stored routines. If the x() procedure contains\nSIGNAL, you can still prepare and execute the \'CALL x();\'\nprepared statement.\n \nPREPARE now supports most kinds of expressions as well, for\nexample:\n \nPREPARE stmt FROM CONCAT(\'SELECT * FROM \', table_name);\n \nWhen PREPARE is used with a statement which is not\nsupported, the following error is produced:\n \nERROR 1295 (HY000): This command is not supported in the\nprepared statement protocol yet\n \nExample\n \ncreate table t1 (a int,b char(10));\ninsert into t1 values (1,\"one\"),(2,\n\"two\"),(3,\"three\");\nprepare test from \"select * from t1 where a=?\";\nset @param=2;\nexecute test using @param;\n+------+------+\n| a | b |\n+------+------+\n| 2 | two |\n+------+------+\nset @param=3;\nexecute test using @param;\n+------+-------+\n| a | b |\n+------+-------+\n| 3 | three |\n+------+-------+\ndeallocate prepare test;\n \nSince identifiers are not permitted as prepared statements\nparameters, sometimes it is necessary to dynamically compose\nan SQL statement. This technique is called dynamic SQL). The\nfollowing example shows how to use dynamic SQL:\n \nCREATE PROCEDURE test.stmt_test(IN tab_name VARCHAR(64))\nBEGIN\n SET @sql = CONCAT(\'SELECT COUNT(*) FROM \', tab_name);\n PREPARE stmt FROM @sql;\n EXECUTE stmt;\n DEALLOCATE PREPARE stmt;\nEND;\n \nCALL test.stmt_test(\'mysql.user\');\n+----------+\n| COUNT(*) |\n+----------+\n| 4 |\n+----------+\n \nUse of variables in prepared statements:\n \nPREPARE stmt FROM \'SELECT @x;\';\n \nSET @x = 1;\n \nEXECUTE stmt;\n+------+\n| @x |\n+------+\n| 1 |\n+------+\n \nSET @x = 0;\n \nEXECUTE stmt;\n+------+\n| @x |\n+------+\n| 0 |\n+------+\n \nDEALLOCATE PREPARE stmt;\n \n\n\nURL: https://mariadb.com/kb/en/library/prepare-statement/','','https://mariadb.com/kb/en/library/prepare-statement/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (105,8,'PURGE BINARY LOGS','Syntax\n------ \nPURGE { BINARY | MASTER } LOGS\n { TO \'log_name\' | BEFORE datetime_expr }\n \nDescription\n----------- \nThe PURGE BINARY LOGS statement deletes all the binary log\nfiles listed in the log index file prior to the specified\nlog file name or\ndate. BINARY and MASTER are synonyms.\nDeleted log files also are removed from the list recorded in\nthe index file, so\nthat the given log file becomes the first in the list.\n \nThe datetime expression is in the format \'YYYY-MM-DD\nhh:mm:ss\'. \n \nIf a slave is active but has yet to read from a binary log\nfile you attempt to delete, the statement will fail with an\nerror. However, if the slave is not connected and has yet to\nread from a log file you delete, the file will be deleted,\nbut the slave will be unable to continue replicating once it\nconnects again.\n \nThis statement has no effect if the server was not started\nwith the\n--log-bin option to enable binary logging.\n \nTo list the binary log files on the server, use SHOW BINARY\nLOGS. To see which files they are reading, use SHOW SLAVE\nSTATUS. You can only delete the files that are older than\nthe oldest file that is used by the slaves.\n \nTo delete all binary log files, use RESET MASTER.\nTo move to a new log file (for example if you want to remove\nthe current log file), use FLUSH LOGS before you execute\nPURGE LOGS.\n \nIf the expire_logs_days server system variable is not set to\n0, the server automatically deletes binary log files after\nthe given number of days.\n \nExamples\n-------- \nPURGE BINARY LOGS TO \'mariadb-bin.000063\';\n \nPURGE BINARY LOGS BEFORE \'2013-04-21\';\n \nPURGE BINARY LOGS BEFORE \'2013-04-22 09:55:22\';\n \n\n\nURL: https://mariadb.com/kb/en/library/purge-binary-logs/','','https://mariadb.com/kb/en/library/purge-binary-logs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (106,8,'RESET MASTER','RESET MASTER [TO #]\n \nDeletes all binary log files listed in the index file,\nresets the\nbinary log index file to be empty, and creates a new binary\nlog file with a suffix of .000001.\n \nIf TO # is given, then the first new binary log file will\nstart from number #.\n \nThis statement is for use only when the master is started\nfor the first time, and should never be used if any slaves\nare actively replicating from the binary log.\n \n\n\nURL: https://mariadb.com/kb/en/library/reset-master/','','https://mariadb.com/kb/en/library/reset-master/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (107,8,'RESET SLAVE','RESET SLAVE [\"connection_name\"] [ALL] \n \nRESET SLAVE makes the slave forget its replication position\nin the\nmaster\'s binary log. This statement is meant to be used for\na clean\nstart. It deletes the master.info and relay-log.info files,\nall the\nrelay log files, and starts a new relay log file. To use\nRESET SLAVE,\nthe slave replication threads must be stopped (use STOP\nSLAVE if\nnecessary).\n \nNote: All relay log files are deleted, even if they have not\nbeen\ncompletely executed by the slave SQL thread. (This is a\ncondition\nlikely to exist on a replication slave if you have issued a\nSTOP SLAVE\nstatement or if the slave is highly loaded.)\n \nConnection information stored in the master.info file is\nimmediately\nreset using any values specified in the corresponding\nstartup options.\nThis information includes values such as master host, master\nport,\nmaster user, and master password. If the slave SQL thread\nwas in the\nmiddle of replicating temporary tables when it was stopped,\nand RESET\nSLAVE is issued, these replicated temporary tables are\ndeleted on the\nslave.\n \nThe ALL also resets the PORT, HOST, USER and PASSWORD\nparameters for the slave. If you are using a connection\nname, it will permanently delete it and it will not show up\nanymore in SHOW ALL SLAVES STATUS.\n \nconnection_name\n \nThe connection_name option was added as part of multi-source\nreplication added in MariaDB 10.0\n \nIf there is only one nameless master, or the default master\n(as specified by the default_master_connection system\nvariable) is intended, connection_name can be omitted. If\nprovided, the RESET SLAVE statement will apply to the\nspecified master. connection_name is case-insensitive.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/reset-slave-connection_name/','','https://mariadb.com/kb/en/library/reset-slave-connection_name/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (108,8,'SET TRANSACTION','Syntax\n------ \nSET [GLOBAL | SESSION] TRANSACTION\n transaction_property [, transaction_property] ...\n \ntransaction_property:\n ISOLATION LEVEL level\n | READ WRITE\n | READ ONLY\n \nlevel:\n REPEATABLE READ\n | READ COMMITTED\n | READ UNCOMMITTED\n | SERIALIZABLE\n \nDescription\n----------- \nThis statement sets the transaction isolation level or the\ntransaction access mode globally, for the current session,\nor for the next transaction:\nWith the GLOBAL keyword, the statement sets the default\n transaction level globally for all subsequent sessions.\nExisting sessions are\n unaffected.\nWith the SESSION keyword, the statement sets the default\n transaction level for all subsequent transactions performed\nwithin the\n current session.\nWithout any SESSION or GLOBAL keyword,\n the statement sets the isolation level for the next (not\nstarted) transaction\n performed within the current session.\n \nA change to the global default isolation level requires the \nSUPER privilege. Any session is free to change its\nsession isolation level (even in the middle of a\ntransaction), or the isolation\nlevel for its next transaction.\n \nIsolation Level\n \nTo set the global default isolation level at server startup,\nuse the\n--transaction-isolation=level option on the command line or\nin an option file. Values of level for this option use\ndashes\nrather than spaces, so the allowable values are\nREAD-UNCOMMITTED,\nREAD-COMMITTED, REPEATABLE-READ, or\nSERIALIZABLE. For example, to set the default isolation\nlevel to REPEATABLE READ, use these lines in the [mysqld]\nsection of an option file:\n \n[mysqld]\ntransaction-isolation = REPEATABLE-READ\nTo determine the global and session transaction isolation\nlevels at\nruntime, check the value of the tx_isolation system\nvariable:\n \nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n \nInnoDB supports each of the translation isolation levels\ndescribed here\nusing different locking strategies. The default level is \nREPEATABLE READ. For additional information about InnoDB\nrecord-level locks and how it uses them to execute various\ntypes of statements,\nsee XtraDB/InnoDB Lock Modes,\nand\nhttp://dev.mysql.com/doc/refman/en/innodb-locks-set.html.\n \nIsolation Levels\n \nThe following sections describe how MariaDB supports the\ndifferent transaction levels.\n \nREAD UNCOMMITTED\n \nSELECT statements are performed in a non-locking fashion,\nbut a possible earlier version of a row might be used. Thus,\nusing this\nisolation level, such reads are not consistent. This is also\ncalled a \"dirty\nread.\" Otherwise, this isolation level works like \nREAD COMMITTED.\n \nREAD COMMITTED\n \nA somewhat Oracle-like isolation level with respect to\nconsistent\n(non-locking) reads: Each consistent read, even within the\nsame\ntransaction, sets and reads its own fresh snapshot. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n \nFor locking reads (SELECT with FOR UPDATE\nor LOCK IN SHARE MODE), InnoDB locks only index records, not\nthe gaps before them, and thus allows the free insertion of\nnew records next to\nlocked records. For UPDATE and DELETE\nstatements, locking depends on whether the statement uses a\nunique index with a\nunique search condition (such as WHERE id = 100), or a\nrange-type search condition (such as WHERE id > 100). For a\nunique index with a unique search condition, InnoDB locks\nonly the index record\nfound, not the gap before it. For range-type searches,\nInnoDB locks the index\nrange scanned, using gap locks or next-key (gap plus\nindex-record) locks to\nblock insertions by other sessions into the gaps covered by\nthe range. This is\nnecessary because \"phantom rows\" must be blocked for MySQL\nreplication and\nrecovery to work.\n \nNote: Since MariaDB 5.1, if the READ COMMITTED isolation\nlevel is used or the innodb_locks_unsafe_for_binlog system\nvariable is enabled,\nthere is no InnoDB gap locking except for foreign-key\nconstraint checking and\nduplicate-key checking. Also, record locks for non-matching\nrows are released\nafter MariaDB has evaluated the WHERE condition. As of\nMariaDB/MySQL\n5.1, if you use READ COMMITTED or enable\ninnodb_locks_unsafe_for_binlog, you must use row-based\nbinary logging.\n \nREPEATABLE READ\n \nThis is the default isolation level for InnoDB. For\nconsistent reads,\nthere is an important difference from the READ COMMITTED\nisolation level: All consistent reads within the same\ntransaction read the\nsnapshot established by the first read. This convention\nmeans that if you issue\nseveral plain (non-locking) SELECT statements within the\nsame transaction, these SELECT statements are consistent\nalso with respect to each other. See\nhttp://dev.mysql.com/doc/refman/en/innodb-consistent-read.html.\n \nFor locking reads (SELECT with FOR UPDATE or LOCK IN SHARE\nMODE),\nUPDATE, and DELETE statements, locking depends on whether\nthe\nstatement uses a unique index with a unique search\ncondition, or a\nrange-type search condition. For a unique index with a\nunique search\ncondition, InnoDB locks only the index record found, not the\ngap\nbefore it. For other search conditions, InnoDB locks the\nindex range\nscanned, using gap locks or next-key (gap plus index-record)\nlocks to\nblock insertions by other sessions into the gaps covered by\nthe range.\n \nThis is the minimum isolation level for non-distributed XA\ntransactions.\n \nSERIALIZABLE\n \nThis level is like REPEATABLE READ, but InnoDB implicitly\nconverts all\nplain SELECT statements to SELECT ... LOCK IN SHARE MODE if\nautocommit\nis disabled. If autocommit is enabled, the SELECT is its own\ntransaction. It therefore is known to be read only and can\nbe\nserialized if performed as a consistent (non-locking) read\nand need\nnot block for other transactions. (This means that to force\na plain\nSELECT to block if other transactions have modified the\nselected rows,\nyou should disable autocommit.)\n \nDistributed XA transactions should always use this isolation\nlevel.\n \nAccess Mode\n \nThese clauses appeared in MariaDB 10.0.\n \nThe access mode specifies whether the transaction is allowed\nto write data or not. By default, transactions are in READ\nWRITE mode (see the tx_read_only system variable). READ ONLY\nmode allows the storage engine to apply optimizations that\ncannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can\nperform DDL statements on temporary tables.\n \nIt is not permitted to specify both READ WRITE and READ ONLY\nin the same statement.\n \nREAD WRITE and READ ONLY can also be specified in the START\nTRANSACTION statement, in which case the specified mode is\nonly valid for one transaction.\n \nExamples\n-------- \nSET GLOBAL TRANSACTION ISOLATION LEVEL SERIALIZABLE;\n \nAttempting to set the isolation level within an existing\ntransaction without specifying GLOBAL or SESSION.\n \nSTART TRANSACTION;\n \nSET TRANSACTION ISOLATION LEVEL SERIALIZABLE;\nERROR 1568 (25001): Transaction characteristics can\'t be\nchanged while a transaction is in progress\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/set-transaction/','','https://mariadb.com/kb/en/library/set-transaction/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (109,8,'START SLAVE','Syntax\n------ \nSTART SLAVE [\"connection_name\"] [thread_type [,\nthread_type] ... ]\nSTART SLAVE [\"connection_name\"] [SQL_THREAD] UNTIL \n MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\nSTART SLAVE [\"connection_name\"] [SQL_THREAD] UNTIL\n RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\nSTART SLAVE [\"connection_name\"] [SQL_THREAD] UNTIL\n MASTER_GTID_POS = \nSTART ALL SLAVES [thread_type [, thread_type]]\nthread_type: IO_THREAD | SQL_THREAD\n \nDescription\n----------- \nSTART SLAVE with no thread_type options starts both of the\nslave\nthreads (see replication). The I/O thread reads events from\nthe master server and stores\nthem in the relay log. The SQL thread reads events from the\nrelay log\nand executes them. START SLAVE requires the SUPER privilege.\n \nIf START SLAVE succeeds in starting the slave threads, it\nreturns\nwithout any error. However, even in that case, it might be\nthat the\nslave threads start and then later stop (for example,\nbecause they do\nnot manage to connect to the master or read its binary log,\nor some\nother problem). START SLAVE does not warn you about this.\nYou must\ncheck the slave\'s error log for error messages generated by\nthe slave\nthreads, or check that they are running satisfactorily with\nSHOW SLAVE\nSTATUS.\n \nSTART SLAVE UNTIL\n \nSTART SLAVE UNTIL refers to the SQL_THREAD slave position at\nwhich the SQL_THREAD replication will halt. If SQL_THREAD\nisn\'t specified both threads are started.\n \nSince version 10.0.2, START SLAVE UNTIL master_gtid_pos=xxx\nhas also been supported. See Global Transaction ID/START\nSLAVE UNTIL master_gtid_pos=xxx for more details.\n \nconnection_name\n \nThe connection_name option was added as part of multi-source\nreplication added in MariaDB 10.0\n \nIf there is only one nameless master, or the default master\n(as specified by the default_master_connection system\nvariable) is intended, connection_name can be omitted. If\nprovided, the START SLAVE statement will apply to the\nspecified master. connection_name is case-insensitive.\n \nSTART ALL SLAVES\n \nSTART ALL SLAVES starts all configured slaves (slaves with\nmaster_host not empty) that were not started before. It will\ngive a note for all started connections. You can check the\nnotes with SHOW WARNINGS.\n \n\n\nURL: https://mariadb.com/kb/en/library/start-slave/','','https://mariadb.com/kb/en/library/start-slave/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (110,8,'START TRANSACTION','Syntax\n------ \nSTART TRANSACTION [transaction_property [,\ntransaction_property] ...] | BEGIN [WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n \ntransaction_property:\n WITH CONSISTENT SNAPSHOT\n | READ WRITE\n | READ ONLY\n \nDescription\n----------- \nThe START TRANSACTION or BEGIN statement\nbegins a new transaction. COMMIT commits the current\ntransaction, making its changes permanent. ROLLBACK rolls\nback the current transaction, canceling its changes. The SET\nautocommit statement disables or enables the default\nautocommit mode for the current session.\n \nSTART TRANSACTION and SET autocommit = 1 implicitly commit\nthe current transaction, if any.\n \nThe optional WORK keyword is supported for\nCOMMIT and ROLLBACK, as are the\nCHAIN and RELEASE clauses.\nCHAIN and RELEASE can be used for\nadditional control over transaction completion. The value of\nthe\ncompletion_type system variable determines the default\ncompletion behavior.\n \nThe AND CHAIN clause causes a new transaction to begin as\nsoon as the current one ends, and the new transaction has\nthe same isolation\nlevel as the just-terminated transaction. The RELEASE clause\ncauses the server to disconnect the current client session\nafter terminating\nthe current transaction. Including the NO keyword suppresses\nCHAIN or RELEASE completion, which can be\nuseful if the completion_type system variable is set to\ncause chaining or release completion by default.\n \nAccess Mode\n \nThese clauses appeared in MariaDB 10.0.\n \nThe access mode specifies whether the transaction is allowed\nto write data or not. By default, transactions are in READ\nWRITE mode (see the tx_read_only system variable). READ ONLY\nmode allows the storage engine to apply optimizations that\ncannot be used for transactions which write data. The only\nexception to this rule is that read only transactions can\nperform DDL statements on temporary tables.\n \nIt is not permitted to specify both READ WRITE and READ ONLY\nin the same statement.\n \nREAD WRITE and READ ONLY can also be specified in the SET\nTRANSACTION statement, in which case the specified mode is\nvalid for all sessions, or for all subsequent transaction\nused by the current session.\n \nautocommit\n \nBy default, MariaDB runs with autocommit mode enabled. This\nmeans that as soon as you execute a statement that updates\n(modifies) a table, MariaDB stores the update on disk to\nmake it permanent. To disable autocommit mode, use the\nfollowing statement:\n \nSET autocommit=0;\n \nAfter disabling autocommit mode by setting the autocommit\nvariable to zero, changes to transaction-safe tables (such\nas those for InnoDB or\nNDBCLUSTER) are not made permanent immediately. You must use\nCOMMIT to store your changes to disk or ROLLBACK to ignore\nthe changes.\n \nTo disable autocommit mode for a single series of\nstatements, use the START TRANSACTION statement.\n \nDDL Statements\n \nDDL statements (CREATE, ALTER, DROP) and administrative\nstatements (FLUSH, RESET, OPTIMIZE, ANALYZE, CHECK, REPAIR,\nCACHE INDEX), and LOAD DATA INFILE, cause an implicit COMMIT\nand start a new transaction. An exception to this rule are\nthe DDL that operate on temporary tables: you can CREATE,\nALTER and DROP them without causing any COMMIT, but those\nactions cannot be rolled back. This means that if you call\nROLLBACK, the temporary tables you created in the\ntransaction will remain, while the rest of the transaction\nwill be rolled back.\n \nTransactions cannot be used in Stored Functions or Triggers.\nIn Stored Procedures and Events BEGIN is not allowed, so you\nshould use START TRANSACTION instead.\n \nA transaction acquires a metadata lock on every table it\naccesses to prevent other connections from altering their\nstructure. The lock is released at the end of the\ntransaction. This happens even with non-transactional\nstorage engines (like MEMORY or CONNECT), so it makes sense\nto use transactions with non-transactional tables.\n \nin_transaction\n \nThe in_transaction system variable appeared in MariaDB 5.3.\n \nIt is a session-only, read-only variable that returns 1\ninside a transaction, and 0 if not in a transaction.\n \nWITH CONSISTENT SNAPSHOT\n \nThe WITH CONSISTENT SNAPSHOT option starts a consistent read\nfor storage engines such as XtraDB and InnoDB that can do\nso, the same as if a START TRANSACTION followed by a SELECT\nfrom any InnoDB table was issued. \n \nMariaDB 5.3 introduced enhancements to this feature. See\nEnhancements for START TRANSACTION WITH CONSISTENT SNAPSHOT.\n \nExamples\n-------- \nSTART TRANSACTION;\n \nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\n \nUPDATE table2 SET summary=@A WHERE type=1;\n \nCOMMIT;\n \n\n\nURL: https://mariadb.com/kb/en/library/start-transaction/','','https://mariadb.com/kb/en/library/start-transaction/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (111,8,'STOP SLAVE','Syntax\n------ \nSTOP SLAVE [\"connection_name\"] [thread_type [,\nthread_type] ... ]\n \nSTOP ALL SLAVES [thread_type [, thread_type]]\n \nthread_type: IO_THREAD | SQL_THREAD\n \nDescription\n----------- \nStops the slave threads. STOP SLAVE requires the SUPER\nprivilege.\n \nLike START SLAVE, this statement may be used with the\nIO_THREAD and\nSQL_THREAD options to name the thread or threads to be\nstopped. In almost all cases, one never need to use the\nthread_type options.\n \nSTOP SLAVE waits until any current replication event group\naffecting\none or more non-transactional tables has finished executing\n(if there\nis any such replication group), or until the user issues a\nKILL QUERY or KILL CONNECTION statement.\n \nNote that STOP SLAVE doesn\'t delete the connection\npermanently. Next time you execute START SLAVE or the\nMariaDB server restarts, the slave connection is restored\nwith it\'s original arguments. If you want to delete a\nconnection, you should execute RESET SLAVE.\n \nSTOP ALL SLAVES\n \nSTOP ALL SLAVES stops all your running slaves. It will give\nyou a note for every stopped connection. You can check the\nnotes with SHOW WARNINGS.\n \nconnection_name\n \nThe connection_name option was added as part of multi-source\nreplication added in MariaDB 10.0\n \nIf there is only one nameless master, or the default master\n(as specified by the default_master_connection system\nvariable) is intended, connection_name can be omitted. If\nprovided, the STOP SLAVE statement will apply to the\nspecified master. connection_name is case-insensitive.\n \n\n\nURL: https://mariadb.com/kb/en/library/stop-slave/','','https://mariadb.com/kb/en/library/stop-slave/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (112,8,'Transaction Timeouts','MariaDB has always had the wait_timeout and\ninteractive_timeout settings, which close connections after\na certain period of inactivity.\n \nHowever, these are by default set to a long wait period. In\nsituations where transactions may be started, but not\ncommitted or rolled back, more granular control and a\nshorter timeout may be desirable so as to avoid locks being\nheld for too long.\n \nMariaDB 10.3 introduced three new variables to handle this\nsituation.\nidle_transaction_timeout (all transactions)\nidle_write_transaction_timeout (write transactions - called\nidle_readwrite_transaction_timeout until MariaDB 10.3.2)\nidle_readonly_transaction_timeout (read transactions)\n \nThese accept a time in seconds to time out, by closing the\nconnection, transactions that are idle for longer than this\nperiod. By default all are set to zero, or no timeout.\n \nidle_transaction_timeout affects all transactions,\nidle_write_transaction_timeout affects write transactions\nonly and idle_readonly_transaction_timeout affects read\ntransactions only. The latter two variables work\nindependently. However, if either is set along with\nidle_transaction_timeout, the settings for\nidle_write_transaction_timeout or\nidle_readonly_transaction_timeout will take precedence.\n \nExamples\n-------- \nSET SESSION idle_transaction_timeout=2;\n \nBEGIN;\n \nSELECT * FROM t;\n \nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\n \nERROR 2006 (HY000): MySQL server has gone away\n \nSET SESSION idle_write_transaction_timeout=2;\n \nBEGIN;\n \nSELECT * FROM t;\n \nEmpty set (0.000 sec)\n## wait 3 seconds\nSELECT * FROM t;\n \nEmpty set (0.000 sec)\nINSERT INTO t VALUES(1);\n## wait 3 seconds\nSELECT * FROM t;\n \nERROR 2006 (HY000): MySQL server has gone away\n \nSET SESSION idle_transaction_timeout=2, SESSION\nidle_readonly_transaction_timeout=10;\n \nBEGIN;\n \nSELECT * FROM t;\n \nEmpty set (0.000 sec)\n ## wait 3 seconds\nSELECT * FROM t;\n \nEmpty set (0.000 sec)\n## wait 11 seconds\nSELECT * FROM t;\n \nERROR 2006 (HY000): MySQL server has gone away\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/transaction-timeouts/','','https://mariadb.com/kb/en/library/transaction-timeouts/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (113,8,'UNLOCK TABLES','Syntax\n------ \nUNLOCK TABLES\n \nDescription\n----------- \nUNLOCK TABLES explicitly releases any table locks held by\nthe\ncurrent session. See LOCK TABLES for more information.\n \nIn addition to releasing table locks acquired by the LOCK\nTABLES statement, the UNLOCK TABLES statement also releases\nthe global read lock acquired by the FLUSH TABLES WITH READ\nLOCK statement. The FLUSH TABLES WITH READ LOCK statement is\nvery useful for performing backups. See FLUSH for more\ninformation about FLUSH TABLES WITH READ LOCK.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/transactions-unlock-tables/','','https://mariadb.com/kb/en/library/transactions-unlock-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (114,8,'WAIT and NOWAIT','MariaDB 10.3.0 introduced extended syntax so that it is\npossible to set innodb_lock_wait_timeout and\nlock_wait_timeout for the following statements:\n \nSyntax\n------ \nALTER TABLE tbl_name [WAIT n|NOWAIT] ...\nCREATE ... INDEX ON tbl_name (index_col_name, ...) [WAIT\nn|NOWAIT] ...\nDROP INDEX ... [WAIT n|NOWAIT]\nDROP TABLE tbl_name [WAIT n|NOWAIT] ...\nLOCK TABLE ... [WAIT n|NOWAIT]\nOPTIMIZE TABLE tbl_name [WAIT n|NOWAIT]\nRENAME TABLE tbl_name [WAIT n|NOWAIT] ...\nSELECT ... FOR UPDATE [WAIT n|NOWAIT]\nSELECT ... LOCK IN SHARE MODE [WAIT n|NOWAIT]\nTRUNCATE TABLE tbl_name [WAIT n|NOWAIT]\n \nDescription\n----------- \nThe lock wait timeout can be explicitly set in the statement\nby using either WAIT n (to set the wait in seconds) or\nNOWAIT, in which case the statement will immediately fail if\nthe lock cannot be obtained. WAIT 0 is equivalent to NOWAIT.\n \n\n\nURL: https://mariadb.com/kb/en/library/wait-and-nowait/','','https://mariadb.com/kb/en/library/wait-and-nowait/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (115,8,'XA Transactions','Overview\n \nThe MariaDB XA implementation is based on the X/Open CAE\ndocument Distributed Transaction Processing: The XA\nSpecification. This document is published by The Open Group\nand available at\nhttp://www.opengroup.org/public/pubs/catalog/c193.htm.\n \nXA transactions are designed to allow distributed\ntransactions, where a transaction manager (the application)\ncontrols a transaction which involves multiple resources.\nSuch resources are usually DBMSs, but could be resources of\nany type. The whole set of required transactional operations\nis called a global transaction. Each subset of operations\nwhich involve a single resource is called a local\ntransaction. XA used a 2-phases commit (2PC). With the first\ncommit, the transaction manager tells each resource to\nprepare an effective commit, and waits for a confirm\nmessage. The changes are not still made effective at this\npoint. If any of the resources encountered an error, the\ntransaction manager will rollback the global transaction. If\nall resources communicate that the first commit is\nsuccessful, the transaction manager can require a second\ncommit, which makes the changes effective.\n \nIn MariaDB, XA transactions can only be used with storage\nengines that support them. At least InnoDB, TokuDB, SPIDER\nand MyRocks support them. For InnoDB, XA transactions can be\ndisabled by setting the innodb_support_xa server system\nvariable to 0. \n \nLike regular transactions, XA transactions create metadata\nlocks on accessed tables.\n \nXA transactions require REPEATABLE READ as a minimum\nisolation level. However, distributed transactions should\nalways use SERIALIZABLE.\n \nTrying to start more than one XA transaction at the same\ntime produces a 1400 error (SQLSTATE \'XAE09\'). The same\nerror is produced when attempting to start an XA transaction\nwhile a regular transaction is in effect. Trying to start a\nregular transaction while an XA transaction is in effect\nproduces a 1399 error (SQLSTATE \'XAE07\').\n \nThe statements that cause an implicit COMMIT for regular\ntransactions produce a 1400 error (SQLSTATE \'XAE09\') if a\nXA transaction is in effect.\n \nInternal XA vs External XA\n \nXA transactions are an overloaded term in MariaDB. If a\nstorage engine is XA-capable, it can mean one or both of\nthese:\nIt supports MariaDB\'s internal two-phase commit API. This\nis transparent to the user. Sometimes this is called\n\"internal XA\", since MariaDB\'s internal transaction\ncoordinator log can handle coordinating these transactions.\n \nIt supports XA transactions, with the XA START, XA PREPARE,\nXA COMMIT, etc. statements. Sometimes this is called\n\"external XA\", since it requires the use of an external\ntransaction coordinator to use this feature properly.\n \nTransaction Coordinator Log\n \nIf you have two or more XA-capable storage engines enabled,\nthen a transaction coordinator log must be available.\n \nThere are currently two implementations of the transaction\ncoordinator log:\nBinary log-based transaction coordinator log\nMemory-mapped file-based transaction coordinator log\n \nIf the binary log is enabled on a server, then the server\nwill use the binary log-based transaction coordinator log.\nOtherwise, it will use the memory-mapped file-based\ntransaction coordinator log.\n \nSee Transaction Coordinator Log for more information.\n \nSyntax\n------ \nXA {START|BEGIN} xid [JOIN|RESUME]\n \nXA END xid [SUSPEND [FOR MIGRATE]]\n \nXA PREPARE xid\n \nXA COMMIT xid [ONE PHASE]\n \nXA ROLLBACK xid\n \nXA RECOVER [FORMAT=[\'RAW\'|\'SQL\']]\n \nxid: gtrid [, bqual [, formatID ]]\n \nThe interface to XA transactions is a set of SQL statements\nstarting with XA. Each statement changes a transaction\'s\nstate, determining which actions it can perform. A\ntransaction which does not exist is in the NON-EXISTING\nstate.\n \nXA START (or BEGIN) starts a transaction and defines its xid\n(a transaction identifier). The JOIN or RESUME keywords have\nno effect. The new transaction will be in ACTIVE state.\n \nThe xid can have 3 components, though only the first one is\nmandatory. gtrid is a quoted string representing a global\ntransaction identifier. bqual is a quoted string\nrepresenting a local transaction identifier. formatID is an\nunsigned integer indicating the format used for the first\ntwo components; if not specified, defaults to 1. MariaDB\ndoes not interpret in any way these components, and only\nuses them to identify a transaction. xids of transactions in\neffect must be unique.\n \nXA END declares that the specified ACTIVE transaction is\nfinished and it changes its state to IDLE. SUSPEND [FOR\nMIGRATE] has no effect.\n \nXA PREPARE prepares an IDLE transaction for commit, changing\nits state to PREPARED. This is the first commit.\n \nXA COMMIT definitely commits and terminates a transaction\nwhich has already been PREPARED. If the ONE PHASE clause is\nspecified, this statements performs a 1-phase commit on an\nIDLE transaction.\n \nXA ROLLBACK rolls back and terminates an IDLE or PREPARED\ntransaction.\n \nXA RECOVER shows information about all PREPARED\ntransactions.\n \nWhen trying to execute an operation which is not allowed for\nthe transaction\'s current state, an error is produced:\n \nXA COMMIT \'test\' ONE PHASE;\n \nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be\nexecuted when global transaction is in the ACTIVE state\n \nXA COMMIT \'test2\';\n \nERROR 1399 (XAE07): XAER_RMFAIL: The command cannot be\nexecuted when global transaction is in the NON-EXISTING\nstate\n \nXA RECOVER\n \nThe XA RECOVER statement shows information about all\ntransactions which are in the PREPARED state. It does not\nmatter which connection created the transaction: if it has\nbeen PREPARED, it appears. But this does not mean that a\nconnection can commit or rollback a transaction which was\nstarted by another connection. Note that transactions using\na 1-phase commit are never in the PREPARED state, so they\ncannot be shown by XA RECOVER.\n \nXA RECOVER produces four columns:\n \nXA RECOVER;\n \n+----------+--------------+--------------+------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+------+\n| 1 | 4 | 0 | test |\n+----------+--------------+--------------+------+\n \nYou can use XA RECOVER FORMAT=\'SQL\' to get the data in a\nhuman readable\nform that can be directly copy-pasted into XA COMMIT or XA\nROLLBACK. This is particularly useful for binary xid\ngenerated by some transaction coordinators.\n \nformatID is the formatID part of xid.\n \ndata are the gtrid and bqual parts of xid, concatenated.\n \ngtrid_length and bqual_length are the lengths of gtrid and\nbqual, respectevely.\n \nExamples\n-------- \n2-phases commit:\n \nXA START \'test\';\n \nINSERT INTO t VALUES (1,2);\n \nXA END \'test\';\n \nXA PREPARE \'test\';\n \nXA COMMIT \'test\';\n \n1-phase commit:\n \nXA START \'test\';\n \nINSERT INTO t VALUES (1,2);\n \nXA END \'test\';\n \nXA COMMIT \'test\' ONE PHASE;\n \nHuman-readable:\n \nxa start \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n \ninsert t1 values (40);\n \nxa end \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n \nxa prepare \'12\\r34\\t67\\v78\', \'abc\\ndef\', 3;\n \nxa recover format=\'RAW\';\n \n+----------+--------------+--------------+--------------------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+--------------------+\n34 67v78abc 11 | 7 | 12\ndef |\n+----------+--------------+--------------+--------------------+\n \nxa recover format=\'SQL\';\n \n+----------+--------------+--------------+-----------------------------------------------+\n| formatID | gtrid_length | bqual_length | data |\n+----------+--------------+--------------+-----------------------------------------------+\n| 3 | 11 | 7 |\nX\'31320d3334093637763738\',X\'6162630a646566\',3 |\n+----------+--------------+--------------+-----------------------------------------------+\n \nxa rollback\nX\'31320d3334093637763738\',X\'6162630a646566\',3;\n \nKnown Issues\n \nMariaDB Galera Cluster\n \nMariaDB Galera Cluster does not support XA transactions. See\nMDEV-10532 for more information on that. The request to\nimplement that feature is being tracked at MDEV-17099.\n \nHowever, MariaDB Galera Cluster builds include a built-in\nplugin called wsrep. Prior to MariaDB 10.4.3, this plugin\nwas internally considered an XA-capable storage engine.\nConsequently, these MariaDB Galera Cluster builds have\nmultiple XA-capable storage engines by default, even if the\nonly \"real\" storage engine that supports external XA\ntransactions enabled on these builds by default is InnoDB.\nTherefore, when using one these builds MariaDB would be\nforced to use a transaction coordinator log by default,\nwhich could have performance implications.\n \nSee Transaction Coordinator Log Overview: MariaDB Galera\nCluster for more information.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/xa-transactions/','','https://mariadb.com/kb/en/library/xa-transactions/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (116,10,'Account Locking','Account locking was introduced in MariaDB 10.4.2.\n \nDescription\n----------- \nAccount locking permits privileged administrators to\nlock/unlock user accounts. No new client connections will be\npermitted if an account is locked (existing connections are\nnot affected).\n \nUser accounts can be locked at creation, with the CREATE\nUSER statement, or modified after creation with the ALTER\nUSER statement. For example:\n \nCREATE USER \'lorin\'@\'localhost\' ACCOUNT LOCK;\n \nor\n \nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n \nThe server will return an ER_ACCOUNT_HAS_BEEN_LOCKED error\nwhen locked users attempt to connect:\n \nmysql -ulorin\n ERROR 4151 (HY000): Access denied, this account is locked\n \nThe ALTER USER statement is also used to unlock a user:\n \nALTER USER \'lorin\'@\'localhost\' ACCOUNT UNLOCK;\n \nThe SHOW CREATE USER statement will show whether the account\nis locked:\n \nSHOW CREATE USER \'marijn\'@\'localhost\';\n \n+-----------------------------------------------+\n| CREATE USER for marijn@localhost |\n+-----------------------------------------------+\n| CREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK |\n+-----------------------------------------------+\n \nas well as querying the mysql.global_priv table:\n \nSELECT CONCAT(user, \'@\', host, \' => \',\nJSON_DETAILED(priv)) FROM mysql.global_priv \n WHERE user=\'marijn\';\n+--------------------------------------------------------------------------------------+\n| CONCAT(user, \'@\', host, \' => \', JSON_DETAILED(priv)) |\n+--------------------------------------------------------------------------------------+\n| marijn@localhost => {\n \"access\": 0,\n \"plugin\": \"mysql_native_password\",\n \"authentication_string\": \"\",\n \"account_locked\": true,\n \"password_last_changed\": 1558017158\n} |\n+--------------------------------------------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/account-locking/','','https://mariadb.com/kb/en/library/account-locking/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (117,10,'Authentication from MariaDB 10.4','MariaDB 10.4 introduces a number of changes to the\nauthentication process, intended to make things easier and\nmore intuitive.\n \nOverview\n \nThere are four main changes relating to authentication:\nIt is possible to use more than one authentication plugin\nfor each user account. For example, this can be useful to\nslowly migrate users to the more secure ed25519\nauthentication plugin over time, while allowing the old\nmysql_native_password authentication plugin as an\nalternative for the transitional period.\nThe root@localhost user account created by mysql_install_db\nis created with the ability to use two authentication\nplugins.\nFirst, it is configured to try to use the unix_socket\nauthentication plugin. This allows the the root@localhost\nuser to login without a password via the local Unix socket\nfile defined by the socket system variable, as long as the\nlogin is attempted from a process owned by the operating\nsystem root user account.\nSecond, if authentication fails with the unix_socket\nauthentication plugin, then it is configured to try to use\nthe mysql_native_password authentication plugin. However, an\ninvalid password is initially set, so in order to\nauthenticate this way, a password must be set with SET\nPASSWORD.\nHowever, just using the unix_socket authentication plugin\nmay be fine for many users, and it is very secure. You may\nwant to try going without password authentication to see how\nwell it works for you. Remember, the best way to keep your\npassword safe is not to have one!\n \nAll user accounts, passwords, and global privileges are now\nstored in the mysql.global_priv table. The mysql.user table\nstill exists and has exactly the same set of columns as\nbefore, but it’s now a view that references the\nmysql.global_priv table. Tools that analyze the mysql.user\ntable should continue to workas before.\nMariaDB 10.4 supports User Password Expiry, which is not\nactive by default.\n \nDescription\n----------- \nAs a result of the above changes, the open-for-everyone\nall-powerful root account is finally gone. And installation\nscripts will no longer demand that you “PLEASE REMEMBER TO\nSET A PASSWORD FOR THE MariaDB root USER !”, because the\nroot account is securely created automatically.\n \nTwo all-powerful accounts are created by default — root\nand the OS user that owns the data directory, typically\nmysql. They are created as:\n \nCREATE USER root@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\nCREATE USER mysql@localhost IDENTIFIED VIA unix_socket OR\nmysql_native_password USING \'invalid\'\n \nUsing unix_socket means that if you are the system root\nuser, you can login as root@locahost without a password.\nThis technique was pioneered by Otto Kekäläinen in Debian\nMariaDB packages and has been successfully used in Debian\nsince as early as MariaDB 10.0. \n \nIt is based on a simple fact that asking the system root for\na password adds no extra security — root has full access\nto all the data files and all process memory anyway. But not\nasking for a password means, there is no root password to\nforget (no need for the numerous tutorials on “how to\nreset MariaDB root password”). And if you want to script\nsome tedious database work, there is no need to store the\nroot password in plain text for the scipt to use (no need\nfor debian-sys-maint user).\n \nStill, some users may wish to log in as MariaDB root without\nusing sudo. Hence the old authentication method —\nconventional MariaDB password — is still available. By\ndefault it is disabled (“invalid” is not a valid\npassword hash), but one can set the password with a usual\nSET PASSWORD statement. And still retain the password-less\naccess via sudo.\n \nIf you install MariaDB locally (say from a tarball, you\nwould not want to use sudo to be able to login. This is why\nMariaDB creates a second all-powerful user with the same\nname as a system user that owns the data directory. In local\n(not system-wide) installations, this will be the user who\ninstalled MariaDB — they automatically get convenient\npassword-less root-like access, because they can access all\nthe data files anyway.\n \nEven if MariaDB is installed system-wide, you may not want\nto run your database maintenance scripts as system root —\nnow you can run them as system mysql user. And you will know\nthat they will never destroy your entire system, even if you\nmake a typo in a shell script.\n \nHowever, seasoned MariaDB DBAs who are used to the old ways\ndo need to makes some changes. See the examples below for\ncommon tasks. \n \nCookbook\n \nAfter installing MariaDB system-wide the first thing\nyou’ve got used to doing is logging in into the\nunprotected root account and protecting it, that is, setting\nthe root password:\n \n$ sudo dnf install MariaDB-server\n$ mysql -uroot\n...\nMariaDB> set password = password(\"XH4VmT3_jt\");\n \nThis is not only unnecessary now, it will simply not work\n— there is no unprotected root account. To login as root\nuse\n \n$ sudo dnf install MariaDB-server\n$ sudo mysql\n \nNote that it implies you are connecting via the unix socket,\nnot tcp. If you happen to have protocol=tcp in a system-wide\n/etc/my.cnf file, use sudo mysql --protocol=socket.\n \nAfter installing MariaDB locally you’ve also used to\nconnect to the unprotected root account using mysql -uroot.\nThis will not work either, simply use mysql without\nspecifying a username.\n \nIf you\'ve forgotten your root password, no problem — you\ncan still connect using sudo and change the password. And if\nyou\'ve also removed unix_socket authentication, to restore\naccess do as follows:\nrestart MariaDB with --skip-grant-tables\nlogin into the unprotected server\nrun FLUSH PRIVILEGES (note, before 10.4 this would’ve been\nthe last step, not anymore). This disables\n--skip-grant-tables and allows you to change the stored\nauthentication method.\nrun SET PASSWORD FOR root@localhost to change the root\npassword\n \nTo view inside privilege tables, the old mysql.user table\nstill exists. You can select from it as before, although you\ncannot update it anymore. It doesn’t show alternative\nauthentication plugins and this was one of the reasons for\nswitching to the mysql.global_priv table — complex\nauthentication rules did not fit into rigid structure of a\nrelational table. You can select from the new table, for\nexample: \n \nselect concat(user, \'@\', host, \' => \',\njson_detailed(priv)) from mysql.global_priv;\n \nReverting to the Previous Authentication Method for\nroot@localhost\n \nIf you don\'t want the root@localhost user account created\nby mysql_install_db to use unix_socket authentication by\ndefault, then there are a few ways to revert to the previous\nmysql_native_password authentication method for this user\naccount.\n \nConfiguring mysql_install_db to Revert to the Previous\nAuthentication Method\n \nOne way to revert to the previous mysql_native_password\nauthentication method for the root@localhost user account is\nto execute mysql_install_db with a special option. If\nmysql_install_db is executed while\n--auth-root-authentication-method=normal is specified, then\nit will create the default user accounts using the default\nbehavior of MariaDB 10.3 and before.\n \nThis means that the root@localhost user account will use\nmysql_native_password authentication by default. There are\nsome other differences as well. See mysql_install_db: User\nAccounts Created by Default for more information.\n \nFor example, the option can be set on the command-line while\nrunning mysql_install_db:\n \nmysql_install_db --user=mysql --datadir=/var/lib/mysql\n--auth-root-authentication-method=normal\n \nThe option can also be set in an option file in an option\ngroup supported by mysql_install_db. For example:\n \n[mysql_install_db]\nauth_root_authentication_method=normal\n \nIf the option is set in an option file and if\nmysql_install_db is executed, then mysql_install_db will\nread this option from the option file, and it will\nautomatically set this option.\n \nAltering the User Account to Revert to the Previous\nAuthentication Method\n \nIf you have already installed MariaDB, and if the\nroot@localhost user account is already using unix_socket\nauthentication, then you can revert to the old\nmysql_native_password authentication method for the user\naccount by executing the following:\n \nALTER USER root@localhost IDENTIFIED VIA\nmysql_native_password USING PASSWORD(\"verysecret\")\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/authentication-from-mariadb-104/','','https://mariadb.com/kb/en/library/authentication-from-mariadb-104/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (118,10,'CREATE USER','Syntax\n------ \nCREATE [OR REPLACE] USER [IF NOT EXISTS] \n user_specification [,user_specification ...] \n [REQUIRE {NONE | tls_option [[AND] tls_option ...] }]\n [WITH resource_option [resource_option ...] ]\n [password_option | lock_option] \n \nuser_specification:\n username [authentication_option]\n \nauthentication_option:\n IDENTIFIED BY \'password\' \n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR\nauthentication_rule ...]\n \nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS}\n\'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n \ntls_option:\n SSL \n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n \nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n \npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n \nlock_option:\n ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n \nDescription\n----------- \nThe CREATE USER statement creates new MariaDB accounts. To\nuse it, you must have the global CREATE USER privilege or\nthe INSERT privilege for the mysql database. For each\naccount, CREATE USER creates a new row in\nthe mysql.user table that has no privileges.\n \nIf any of the specified accounts, or any permissions for the\nspecified accounts, already exist, then the server returns\nERROR 1396 (HY000). If an error occurs, CREATE USER will\nstill create the accounts that do not result in an error.\nOnly one error is produced for all users which have not been\ncreated:\n \nERROR 1396 (HY000): \n Operation CREATE USER failed for \'u1\'@\'%\',\'u2\'@\'%\'\n \nCREATE USER, DROP USER, CREATE ROLE, and DROP ROLE all\nproduce the\nsame error code when they fail.\n \nSee Account Names below for details on how account names are\nspecified. \n \nOR REPLACE\n \nIf the optional OR REPLACE clause is used, it is basically a\nshortcut for:\n \nDROP USER IF EXISTS name;\n \nCREATE USER name ...;\n \nFor example:\n \nCREATE USER foo2@test IDENTIFIED BY \'password\';\n \nERROR 1396 (HY000): Operation CREATE USER failed for\n\'foo2\'@\'test\'\n \nCREATE OR REPLACE USER foo2@test IDENTIFIED BY \'password\';\n \nQuery OK, 0 rows affected (0.00 sec)\n \nIF NOT EXISTS\n \nWhen the IF NOT EXISTS clause is used, MariaDB will return a\nwarning instead of an error if the specified user already\nexists.\n \nFor example:\n \nCREATE USER foo2@test IDENTIFIED BY \'password\';\n \nERROR 1396 (HY000): Operation CREATE USER failed for\n\'foo2\'@\'test\'\n \nCREATE USER IF NOT EXISTS foo2@test IDENTIFIED BY\n\'password\';\n \nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+-------+------+----------------------------------------------------+\n| Level | Code | Message |\n+-------+------+----------------------------------------------------+\n| Note | 1973 | Can\'t create user \'foo2\'@\'test\';\n it already exists |\n+-------+------+----------------------------------------------------+\n1 row in set (0.00 sec\n \nAuthentication Options\n \nIDENTIFIED BY \'password\'\n \nThe optional IDENTIFIED BY clause can be used to provide an\naccount with a password. The password should be specified in\nplain text. It will be hashed by the PASSWORD function prior\nto being stored to the mysql.user table.\n \nFor example, if our password is mariadb, then we can create\nthe user with:\n \nCREATE USER foo2@test IDENTIFIED BY \'mariadb\';\n \nIf you do not specify a password with the IDENTIFIED BY\nclause, the user\nwill be able to connect without a password. A blank password\nis not a wildcard\nto match any password. The user must connect without\nproviding a password if no\npassword is set.\n \nThe only authentication plugins that this clause supports\nare mysql_native_password and mysql_old_password.\n \nIDENTIFIED BY PASSWORD \'password_hash\'\n \nThe optional IDENTIFIED BY PASSWORD clause can be used to\nprovide an account with a password that has already been\nhashed. The password should be specified as a hash that was\nprovided by the PASSWORD function. It will be stored to the\nmysql.user table as-is.\n \nFor example, if our password is mariadb, then we can find\nthe hash with:\n \nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\') |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n \nAnd then we can create a user with the hash:\n \nCREATE USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n \nIf you do not specify a password with the IDENTIFIED BY\nclause, the user\nwill be able to connect without a password. A blank password\nis not a wildcard\nto match any password. The user must connect without\nproviding a password if no\npassword is set.\n \nThe only authentication plugins that this clause supports\nare mysql_native_password and mysql_old_password.\n \nIDENTIFIED {VIA|WITH} authentication_plugin\n \nThe optional IDENTIFIED VIA authentication_plugin allows you\nto specify that the account should be authenticated by a\nspecific authentication plugin. The plugin name must be an\nactive authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to\ninstall it with INSTALL PLUGIN or INSTALL SONAME.\n \nFor example, this could be used with the PAM authentication\nplugin:\n \nCREATE USER foo2@test IDENTIFIED VIA pam;\n \nSome authentication plugins allow additional arguments to be\nspecified after a USING or AS keyword. For example, the PAM\nauthentication plugin accepts a service name:\n \nCREATE USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n \nThe exact meaning of the additional argument would depend on\nthe specific authentication plugin.\n \nThe USING or AS keyword can also be used to provide a\nplain-text password to a plugin if it\'s provided as an\nargument to the PASSWORD() function. This is only valid for\nauthentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication\nplugin supports this:\n \nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING\nPASSWORD(\'secret\');\n \nOne can specify many authentication plugins, they all works\nas alternatives ways of authenticating a user:\n \nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING\nPASSWORD(\'secret\') OR unix_socket;\n \nTLS Options\n \nBy default, MariaDB transmits data between the server and\nclients without encrypting it. This is generally acceptable\nwhen the server and client run on the same host or in\nnetworks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on\nseparate networks or they are in a high-risk network, the\nlack of encryption does introduce security concerns as a\nmalicious actor could potentially eavesdrop on the traffic\nas it is sent over the network between them.\n \nTo mitigate this concern, MariaDB allows you to encrypt data\nin transit between the server and clients using the\nTransport Layer Security (TLS) protocol. TLS was formerly\nknown as Secure Socket Layer (SSL), but strictly speaking\nthe SSL protocol is a predecessor to TLS and, that version\nof the protocol is now considered insecure. The\ndocumentation still uses the term SSL often and for\ncompatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB\nonly supports its secure successors.\n \nSee Secure Connections Overview for more information about\nhow to determine whether your MariaDB server has TLS\nsupport.\n \nYou can set certain TLS-related restrictions for specific\nuser accounts. For instance, you might use this with user\naccounts that require access to sensitive data while sending\nit across networks that you do not control. These\nrestrictions can be enabled for a user account with the\nCREATE USER, ALTER USER, or GRANT statements. The following\noptions are available:\n \nOption | Description | \n \nREQUIRE NONE | TLS is not required for this account, but can\nstill be used. | \n \nREQUIRE SSL | The account must use TLS, but no valid X509\ncertificate is required. This option cannot be combined with\nother TLS options. | \n \nREQUIRE X509 | The account must use TLS and must have a\nvalid X509 certificate. This option implies REQUIRE SSL.\nThis option cannot be combined with other TLS options. | \n \nREQUIRE ISSUER \'issuer\' | The account must use TLS and\nmust have a valid X509 certificate. Also, the Certificate\nAuthority must be the one specified via the string issuer.\nThis option implies REQUIRE X509. This option can be\ncombined with the SUBJECT, and CIPHER options in any order.\n| \n \nREQUIRE SUBJECT \'subject\' | The account must use TLS and\nmust have a valid X509 certificate. Also, the certificate\'s\nSubject must be the one specified via the string subject.\nThis option implies REQUIRE X509. This option can be\ncombined with the ISSUER, and CIPHER options in any order. |\n\n \nREQUIRE CIPHER \'cipher\' | The account must use TLS, but no\nvalid X509 certificate is required. Also, the encryption\nused for the connection must use one of the methods\nspecified in the string cipher. This option implies REQUIRE\nSSL. This option can be combined with the ISSUER, and\nSUBJECT options in any order. | \n \nThe REQUIRE keyword must be used only once for all specified\noptions, and the AND keyword can be used to separate\nindividual options, but it is not required.\n \nFor example, you can create a user account that requires\nthese TLS options with the following:\n \nCREATE USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom,\nInc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some\nCompany/CN=Peter Parker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'TLSv1.2\';\n \nIf any of these options are set for a specific user account,\nthen any client who tries to connect with that user account\nwill have to be configured to connect with TLS.\n \nSee Securing Connections for Client and Server for\ninformation on how to enable TLS on the client and server.\n \nResource Limit Options\n \nMariaDB 10.2.0 introduced a number of resource limit\noptions.\n \nIt is possible to set per-account limits for certain server\nresources. The following table shows the values that can be\nset per account:\n \nLimit Type | Decription | \n \nMAX_QUERIES_PER_HOUR | Number of statements that the account\ncan issue per hour (including updates) | \n \nMAX_UPDATES_PER_HOUR | Number of updates (not queries) that\nthe account can issue per hour | \n \nMAX_CONNECTIONS_PER_HOUR | Number of connections that the\naccount can start per hour | \n \nMAX_USER_CONNECTIONS | Number of simultaneous connections\nthat can be accepted from the same account; if it is 0,\nmax_connections will be used instead; if max_connections is\n0, there is no limit for this account\'s simultaneous\nconnections. | \n \nMAX_STATEMENT_TIME | Timeout, in seconds, for statements\nexecuted by the user. See also Aborting Statements that\nExceed a Certain Time to Execute. | \n \nIf any of these limits are set to 0, then there is no limit\nfor that resource for that user.\n \nHere is an example showing how to create a user with\nresource limits:\n \nCREATE USER \'someone\'@\'localhost\' WITH\n MAX_USER_CONNECTIONS 10\n MAX_QUERIES_PER_HOUR 200;\n \nThe resources are tracked per account, which means\n\'user\'@\'server\'; not per user name or per connection.\n \nThe count can be reset for all users using FLUSH\nUSER_RESOURCES, FLUSH PRIVILEGES or mysqladmin reload.\n \nPer account resource limits are stored in the user table, in\nthe mysql database. Columns used for resources limits are\nnamed max_questions, max_updates, max_connections (for\nMAX_CONNECTIONS_PER_HOUR), and max_user_connections (for\nMAX_USER_CONNECTIONS).\n \nAccount Names\n \nAccount names have both a user name component and a host\nname component, and are specified as\n\'user_name\'@\'host_name\'.\n \nThe user name and host name may be unquoted, quoted as\nstrings using double quotes (\") or\nsingle quotes (\'), or quoted as identifiers using backticks\n(`). You must use quotes\nwhen using special characters (such as a hyphen) or wildcard\ncharacters. If you quote, you \nmust quote the user name and host name separately (for\nexample \'user_name\'@\'host_name\').\n \nHost Name Component\n \nIf the host name is not provided, it is assumed to be \'%\'.\n \nHost names may contain the wildcard characters % and _. They\nare matched as if by\nthe LIKE clause. If you need to use a wildcard character\nliterally (for example, to\nmatch a domain name with an underscore), prefix the\ncharacter with a backslash. See LIKE\nfor more information on escaping wildcard characters.\n \nHost name matches are case-insensitive. Host names can match\neither domain names or IP\naddresses. Use \'localhost\' as the host name to allow only\nlocal client connections.\n \nYou can use a netmask to match a range of IP addresses using\n\'base_ip/netmask\' as the\nhost name. A user with an IP address ip_addr will be allowed\nto connect if the following\ncondition is true:\n \nip_addr & netmask = base_ip\n \nYou can only use netmasks that specify a multiple of 8 bits\nof the address to match. That is,\nonly the following netmasks are allowed:\n \n255.0.0.0\n255.255.0.0\n255.255.255.0\n255.255.255.255\n \nUsing 255.255.255.255 is equivalent to not using a netmask\nat all.\n \nUser Name Component\n \nUser names must match exactly, including case. A user name\nthat is empty is known as an anonymous account and is\nallowed to match a login attempt with any user name\ncomponent. These are described more in the next section.\n \nFor valid identifiers to use as user names, see Identifier\nNames.\n \nIt is possible for more than one account to match when a\nuser connects. MariaDB selects\nthe first matching account after sorting according to the\nfollowing criteria:\nAccounts with an exact host name are sorted before accounts\nusing a wildcard in the\nhost name. Host names using a netmask are considered to be\nexact for sorting.\nAccounts with a wildcard in the host name are sorted\naccording to the position of\nthe first wildcard character. Those with a wildcard\ncharacter later in the host name\nsort before those with a wildcard character earlier in the\nhost name.\nAccounts with a non-empty user name sort before accounts\nwith an empty user name.\nAccounts with an empty user name are sorted last. As\nmentioned previously, these are known as anonymous accounts.\nThese are described more in the next section.\n \nThe following table shows a list of example account as\nsorted by these criteria:\n \n+---------+-------------+\n| User | Host |\n+---------+-------------+\n| joffrey | 192.168.0.3 |\n| | 192.168.0.% |\n| joffrey | 192.168.% |\n| | 192.168.% |\n+---------+-------------+\n \nOnce connected, you only have the privileges granted to the\naccount that matched,\nnot all accounts that could have matched. For example,\nconsider the following\ncommands:\n \nCREATE USER \'joffrey\'@\'192.168.0.3\';\n \nCREATE USER \'joffrey\'@\'%\';\n \nGRANT SELECT ON test.t1 to \'joffrey\'@\'192.168.0.3\';\n \nGRANT SELECT ON test.t2 to \'joffrey\'@\'%\';\n \nIf you connect as joffrey from 192.168.0.3, you will have\nthe SELECT\nprivilege on the table test.t1, but not on the table\ntest.t2. If you connect as joffrey from any other IP\naddress, you will have the SELECT privilege on the table\ntest.t2, but not\non the table test.t1.\n \nBeginning with MariaDB 5.5.31, usernames can be up to 80\ncharacters long. From MariaDB 10.0 the system tables are all\nby default this length. However, in order to enable this\nfeature in MariaDB 5.5, the following schema changes must be\nmade:\n \nALTER TABLE mysql.user MODIFY User CHAR(80) BINARY NOT NULL\nDEFAULT \'\';\n \nALTER TABLE mysql.db MODIFY User CHAR(80) BINARY NOT NULL\nDEFAULT \'\';\n \nALTER TABLE mysql.tables_priv MODIFY User CHAR(80) BINARY\nNOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.columns_priv MODIFY User CHAR(80) BINARY\nNOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.procs_priv MODIFY User CHAR(80) BINARY NOT\nNULL DEFAULT \'\';\n \nALTER TABLE mysql.proc MODIFY definer CHAR(141) COLLATE\nutf8_bin NOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.event MODIFY definer CHAR(141) COLLATE\nutf8_bin NOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.proxies_priv MODIFY User CHAR(80) COLLATE\nutf8_bin NOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.proxies_priv MODIFY Proxied_user CHAR(80)\nCOLLATE utf8_bin NOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.proxies_priv MODIFY Grantor CHAR(141)\nCOLLATE utf8_bin NOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.servers MODIFY Username CHAR(80) NOT NULL\nDEFAULT \'\';\n \nALTER TABLE mysql.procs_priv MODIFY Grantor CHAR(141)\nCOLLATE utf8_bin NOT NULL DEFAULT \'\';\n \nALTER TABLE mysql.tables_priv MODIFY Grantor CHAR(141)\nCOLLATE utf8_bin NOT NULL DEFAULT \'\';\n \nFLUSH PRIVILEGES;\n \nAnonymous Accounts\n \nAnonymous accounts are accounts where the user name portion\nof the account name is empty. These accounts act as special\ncatch-all accounts. If a user attempts to log into the\nsystem from a host, and an anonymous account exists with a\nhost name portion that matches the user\'s host, then the\nuser will log in as the anonymous account if there is no\nmore specific account match for the user name that the user\nentered.\n \nFor example, here are some anonymous accounts:\n \nCREATE USER \'\'@\'localhost\';\n \nCREATE USER \'\'@\'192.168.0.3\';\n \nFixing a Legacy Default Anonymous Account\n \nOn some systems, the mysql.db table has some entries for the\n\'\'@\'%\' anonymous account by default. Unfortunately,\nthere is no matching entry in the mysql.user table, which\nmeans that this anonymous account doesn\'t exactly exist,\nbut it does have privileges--usually on the default test\ndatabase created by mysql_install_db. These account-less\nprivileges are a legacy that is leftover from a time when\nMySQL\'s privilege system was less advanced.\n \nThis situation means that you will run into errors if you\ntry to create a \'\'@\'%\' account. For example:\n \nCREATE USER \'\'@\'%\';\n \nERROR 1396 (HY000): Operation CREATE USER failed for\n\'\'@\'%\'\n \nThe fix is to DELETE the row in the mysql.db table and then\nexecute FLUSH PRIVILEGES:\n \nDELETE FROM mysql.db WHERE User=\'\' AND Host=\'%\';\n \nFLUSH PRIVILEGES;\n \nAnd then the account can be created:\n \nCREATE USER \'\'@\'%\';\n \nQuery OK, 0 rows affected (0.01 sec)\n \nSee MDEV-13486 for more information.\n \nPassword Expiry\n \nBesides automatic password expiry, as determined by\ndefault_password_lifetime, password expiry times can be set\non an individual user basis, overriding the global setting,\nfor example:\n \nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL\n120 DAY;\n \nSee User Password Expiry for more details.\n \nAccount Locking\n \nAccount locking permits privileged administrators to\nlock/unlock user accounts. No new client connections will be\npermitted if an account is locked (existing connections are\nnot affected). For example:\n \nCREATE USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n \nSee Account Locking','','https://mariadb.com/kb/en/library/create-user/');
update help_topic set description = CONCAT(description, ' for more details.\n \n\n\nURL: https://mariadb.com/kb/en/library/create-user/') WHERE help_topic_id = 118;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (119,10,'ALTER USER','The ALTER USER statement was introduced in MariaDB 10.2.0.\n \nSyntax\n------ \nALTER USER [IF EXISTS] \n user_specification [,user_specification] ...\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH resource_option [resource_option] ...]\n [password_option | lock_option] \n \nuser_specification:\n username [authentication_option]\n \nauthentication_option:\n IDENTIFIED BY \'password\' \n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_plugin\n | IDENTIFIED {VIA|WITH} authentication_plugin {USING|AS}\n\'authentication_string\'\n | IDENTIFIED {VIA|WITH} authentication_plugin {USING|AS}\nPASSWORD(\'password\')\n \ntls_option\n SSL \n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n \nresource_option\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n \npassword_option:\n PASSWORD EXPIRE\n | PASSWORD EXPIRE DEFAULT\n | PASSWORD EXPIRE NEVER\n | PASSWORD EXPIRE INTERVAL N DAY\n \nlock_option:\n ACCOUNT LOCK\n | ACCOUNT UNLOCK\n}\n \nDescription\n----------- \nThe ALTER USER statement modifies existing MariaDB accounts.\nTo use it, you must have the global CREATE USER privilege or\nthe UPDATE privilege for the mysql database. The global\nSUPER privilege is also required if the read_only system\nvariable is enabled.\n \nIf any of the specified user accounts do not yet exist, an\nerror results. If an error occurs, ALTER USER will still\nmodify the accounts that do not result in an error. Only one\nerror is produced for all users which have not been\nmodified.\n \nIF EXISTS\n \nWhen the IF EXISTS clause is used, MariaDB will return a\nwarning instead of an error for each specified user that\ndoes not exist.\n \nAccount Names\n \nFor ALTER USER statements, account names are specified as\nthe username argument in the same way as they are for CREATE\nUSER statements. See account names from the CREATE USER page\nfor details on how account names are specified.\n \nCURRENT_USER or CURRENT_USER() can also be used to alter the\naccount logged into the current session. For example, to\nchange the current user\'s password to mariadb:\n \nALTER USER CURRENT_USER() IDENTIFIED BY \'mariadb\';\n \nAuthentication Options\n \nIDENTIFIED BY \'password\'\n \nThe optional IDENTIFIED BY clause can be used to provide an\naccount with a password. The password should be specified in\nplain text. It will be hashed by the PASSWORD function prior\nto being stored to the mysql.user table.\n \nFor example, if our password is mariadb, then we can set the\naccount\'s password with:\n \nALTER USER foo2@test IDENTIFIED BY \'mariadb\';\n \nIf you do not specify a password with the IDENTIFIED BY\nclause, the user\nwill be able to connect without a password. A blank password\nis not a wildcard\nto match any password. The user must connect without\nproviding a password if no\npassword is set.\n \nThe only authentication plugins that this clause supports\nare mysql_native_password and mysql_old_password.\n \nIDENTIFIED BY PASSWORD \'password_hash\'\n \nThe optional IDENTIFIED BY PASSWORD clause can be used to\nprovide an account with a password that has already been\nhashed. The password should be specified as a hash that was\nprovided by the PASSWORD function. It will be stored to the\nmysql.user table as-is.\n \nFor example, if our password is mariadb, then we can find\nthe hash with:\n \nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\') |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n \nAnd then we can set an account\'s password with the hash:\n \nALTER USER foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n \nIf you do not specify a password with the IDENTIFIED BY\nclause, the user\nwill be able to connect without a password. A blank password\nis not a wildcard\nto match any password. The user must connect without\nproviding a password if no\npassword is set.\n \nThe only authentication plugins that this clause supports\nare mysql_native_password and mysql_old_password.\n \nIDENTIFIED {VIA|WITH} authentication_plugin\n \nThe optional IDENTIFIED VIA authentication_plugin allows you\nto specify that the account should be authenticated by a\nspecific authentication plugin. The plugin name must be an\nactive authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to\ninstall it with INSTALL PLUGIN or INSTALL SONAME.\n \nFor example, this could be used with the PAM authentication\nplugin:\n \nALTER USER foo2@test IDENTIFIED VIA pam;\n \nSome authentication plugins allow additional arguments to be\nspecified after a USING or AS keyword. For example, the PAM\nauthentication plugin accepts a service name:\n \nALTER USER foo2@test IDENTIFIED VIA pam USING \'mariadb\';\n \nThe exact meaning of the additional argument would depend on\nthe specific authentication plugin.\n \nIn MariaDB 10.4 and later, the USING or AS keyword can also\nbe used to provide a plain-text password to a plugin if\nit\'s provided as an argument to the PASSWORD() function.\nThis is only valid for authentication plugins that have\nimplemented a hook for the PASSWORD() function. For example,\nthe ed25519 authentication plugin supports this:\n \nALTER USER safe@\'%\' IDENTIFIED VIA ed25519 USING\nPASSWORD(\'secret\');\n \nTLS Options\n \nBy default, MariaDB transmits data between the server and\nclients without encrypting it. This is generally acceptable\nwhen the server and client run on the same host or in\nnetworks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on\nseparate networks or they are in a high-risk network, the\nlack of encryption does introduce security concerns as a\nmalicious actor could potentially eavesdrop on the traffic\nas it is sent over the network between them.\n \nTo mitigate this concern, MariaDB allows you to encrypt data\nin transit between the server and clients using the\nTransport Layer Security (TLS) protocol. TLS was formerly\nknown as Secure Socket Layer (SSL), but strictly speaking\nthe SSL protocol is a predecessor to TLS and, that version\nof the protocol is now considered insecure. The\ndocumentation still uses the term SSL often and for\ncompatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB\nonly supports its secure successors.\n \nSee Secure Connections Overview for more information about\nhow to determine whether your MariaDB server has TLS\nsupport.\n \nYou can set certain TLS-related restrictions for specific\nuser accounts. For instance, you might use this with user\naccounts that require access to sensitive data while sending\nit across networks that you do not control. These\nrestrictions can be enabled for a user account with the\nCREATE USER, ALTER USER, or GRANT statements. The following\noptions are available:\n \nOption | Description | \n \nREQUIRE NONE | TLS is not required for this account, but can\nstill be used. | \n \nREQUIRE SSL | The account must use TLS, but no valid X509\ncertificate is required. This option cannot be combined with\nother TLS options. | \n \nREQUIRE X509 | The account must use TLS and must have a\nvalid X509 certificate. This option implies REQUIRE SSL.\nThis option cannot be combined with other TLS options. | \n \nREQUIRE ISSUER \'issuer\' | The account must use TLS and\nmust have a valid X509 certificate. Also, the Certificate\nAuthority must be the one specified via the string issuer.\nThis option implies REQUIRE X509. This option can be\ncombined with the SUBJECT, and CIPHER options in any order.\n| \n \nREQUIRE SUBJECT \'subject\' | The account must use TLS and\nmust have a valid X509 certificate. Also, the certificate\'s\nSubject must be the one specified via the string subject.\nThis option implies REQUIRE X509. This option can be\ncombined with the ISSUER, and CIPHER options in any order. |\n\n \nREQUIRE CIPHER \'cipher\' | The account must use TLS, but no\nvalid X509 certificate is required. Also, the encryption\nused for the connection must use one of the methods\nspecified in the string cipher. This option implies REQUIRE\nSSL. This option can be combined with the ISSUER, and\nSUBJECT options in any order. | \n \nThe REQUIRE keyword must be used only once for all specified\noptions, and the AND keyword can be used to separate\nindividual options, but it is not required.\n \nFor example, you can alter a user account to require these\nTLS options with the following:\n \nALTER USER \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom,\nInc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some\nCompany/CN=Peter Parker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'TLSv1.2\';\n \nIf any of these options are set for a specific user account,\nthen any client who tries to connect with that user account\nwill have to be configured to connect with TLS.\n \nSee Securing Connections for Client and Server for\ninformation on how to enable TLS on the client and server.\n \nResource Limit Options\n \nMariaDB 10.2.0 introduced a number of resource limit\noptions.\n \nIt is possible to set per-account limits for certain server\nresources. The following table shows the values that can be\nset per account:\n \nLimit Type | Decription | \n \nMAX_QUERIES_PER_HOUR | Number of statements that the account\ncan issue per hour (including updates) | \n \nMAX_UPDATES_PER_HOUR | Number of updates (not queries) that\nthe account can issue per hour | \n \nMAX_CONNECTIONS_PER_HOUR | Number of connections that the\naccount can start per hour | \n \nMAX_USER_CONNECTIONS | Number of simultaneous connections\nthat can be accepted from the same account; if it is 0,\nmax_connections will be used instead; if max_connections is\n0, there is no limit for this account\'s simultaneous\nconnections. | \n \nMAX_STATEMENT_TIME | Timeout, in seconds, for statements\nexecuted by the user. See also Aborting Statements that\nExceed a Certain Time to Execute. | \n \nIf any of these limits are set to 0, then there is no limit\nfor that resource for that user.\n \nHere is an example showing how to set an account\'s resource\nlimits:\n \nALTER USER \'someone\'@\'localhost\' WITH\n MAX_USER_CONNECTIONS 10\n MAX_QUERIES_PER_HOUR 200;\n \nThe resources are tracked per account, which means\n\'user\'@\'server\'; not per user name or per connection.\n \nThe count can be reset for all users using FLUSH\nUSER_RESOURCES, FLUSH PRIVILEGES or mysqladmin reload.\n \nPer account resource limits are stored in the user table, in\nthe mysql database. Columns used for resources limits are\nnamed max_questions, max_updates, max_connections (for\nMAX_CONNECTIONS_PER_HOUR), and max_user_connections (for\nMAX_USER_CONNECTIONS).\n \nPassword Expiry\n \nBesides automatic password expiry, as determined by\ndefault_password_lifetime, password expiry times can be set\non an individual user basis, overriding the global setting,\nfor example:\n \nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL\n120 DAY;\n \nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n \nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n \nSee User Password Expiry for more details.\n \nAccount Locking\n \nAccount locking permits privileged administrators to\nlock/unlock user accounts. No new client connections will be\npermitted if an account is locked (existing connections are\nnot affected). For example:\n \nALTER USER \'marijn\'@\'localhost\' ACCOUNT LOCK;\n \nSee Account Locking for more details.\n \n\n\nURL: https://mariadb.com/kb/en/library/alter-user/','','https://mariadb.com/kb/en/library/alter-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (120,10,'DROP USER','Syntax\n------ \nDROP USER [IF EXISTS] user_name [, user_name] ...\n \nDescription\n----------- \nThe DROP USER statement removes one or more MariaDB\naccounts. It removes\nprivilege rows for the account from all grant tables. To use\nthis statement,\nyou must have the global CREATE USER privilege\nor the DELETE privilege for the mysql database.\nEach account is named using the same format as for the\nCREATE USER\nstatement; for example, \'jeffrey\'@\'localhost\'. If you\nspecify\nonly the user name part of the account name, a host name\npart of \'%\' is\nused. For additional information about specifying account\nnames, see\nCREATE USER.\n \nNote that, if you specify an account that is currently\nconnected, it will not\nbe deleted until the connection is closed. The connection\nwill not be\nautomatically closed.\n \nIf any of the specified user accounts do not exist, ERROR\n1396 (HY000)\nresults. If an error occurs, DROP USER will still drop the\naccounts that do\nnot result in an error. Only one error is produced for all\nusers which have not\nbeen dropped:\n \nERROR 1396 (HY000): Operation DROP USER failed for\n\'u1\'@\'%\',\'u2\'@\'%\'\n \nFailed CREATE or DROP operations, for both users and roles,\nproduce the\nsame error code.\n \nIF EXISTS\n \nThe IF EXISTS clause was added in MariaDB 10.1.3\n \nIf the IF EXISTS clause is used, MariaDB will return a note\ninstead of an error if the user does not exist.\n \nExamples\n-------- \nDROP USER bob;\n \nIF EXISTS:\n \nDROP USER bob;\n \nERROR 1396 (HY000): Operation DROP USER failed for\n\'bob\'@\'%\'\n \nDROP USER IF EXISTS bob;\n \nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+-------+------+---------------------------------------------+\n| Level | Code | Message |\n+-------+------+---------------------------------------------+\n| Note | 1974 | Can\'t drop user \'bob\'@\'%\'; it doesn\'t\nexist |\n+-------+------+---------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/drop-user/','','https://mariadb.com/kb/en/library/drop-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (121,10,'GRANT','Syntax\n------ \nGRANT\n priv_type [(column_list)]\n [, priv_type [(column_list)]] ...\n ON [object_type] priv_level\n TO user_specification [ user_options ...]\n \nuser_specification:\n username [authentication_option]\n \nauthentication_option:\n IDENTIFIED BY \'password\' \n | IDENTIFIED BY PASSWORD \'password_hash\'\n | IDENTIFIED {VIA|WITH} authentication_rule [OR\nauthentication_rule ...]\n \nauthentication_rule:\n authentication_plugin\n | authentication_plugin {USING|AS}\n\'authentication_string\'\n | authentication_plugin {USING|AS} PASSWORD(\'password\')\n \nGRANT PROXY ON username\n TO username [, username] ...\n [WITH GRANT OPTION]\n \nuser_options:\n [REQUIRE {NONE | tls_option [[AND] tls_option] ...}]\n [WITH with_option [with_option] ...]\n \nobject_type:\n TABLE\n | FUNCTION\n | PROCEDURE\n \npriv_level:\n *\n | *.*\n | db_name.*\n | db_name.tbl_name\n | tbl_name\n | db_name.routine_name\n \nwith_option:\n GRANT OPTION\n | resource_option\n \nresource_option:\n MAX_QUERIES_PER_HOUR count\n | MAX_UPDATES_PER_HOUR count\n | MAX_CONNECTIONS_PER_HOUR count\n | MAX_USER_CONNECTIONS count\n | MAX_STATEMENT_TIME time\n \ntls_option:\n SSL \n | X509\n | CIPHER \'cipher\'\n | ISSUER \'issuer\'\n | SUBJECT \'subject\'\n \nDescription\n----------- \nThe GRANT statement allows you to grant privileges or roles\nto accounts. To use GRANT, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are\ngranting.\n \nUse the REVOKE statement to revoke privileges granted with\nthe GRANT statement.\n \nUse the SHOW GRANTS statement to determine what privileges\nan account has.\n \nAccount Names\n \nFor GRANT statements, account names are specified as the\nusername argument in the same way as they are for CREATE\nUSER statements. See account names from the CREATE USER page\nfor details on how account names are specified.\n \nImplicit Account Creation\n \nThe GRANT statement also allows you to implicitly create\naccounts in some cases.\n \nIf the account does not yet exist, then GRANT can implicitly\ncreate it. To implicitly create an account with GRANT, a\nuser is required to have the same privileges that would be\nrequired to explicitly create the account with the CREATE\nUSER statement.\n \nIf the NO_AUTO_CREATE_USER SQL_MODE is set, then accounts\ncan only be created if authentication information is\nspecified, or with a CREATE USER statement. If no\nauthentication information is provided, GRANT will produce\nan error when the specified account does not exist, for\nexample:\n \nshow variables like \'%sql_mode%\' ;\n+---------------+--------------------------------------------+\n| Variable_name | Value |\n+---------------+--------------------------------------------+\n| sql_mode | NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION |\n+---------------+--------------------------------------------+\n \nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED BY \'\';\nERROR 1133 (28000): Can\'t find any matching row in the user\ntable\n \nGRANT USAGE ON *.* TO \'user123\'@\'%\' IDENTIFIED VIA PAM\nusing \'mariadb\' require ssl ;\nQuery OK, 0 rows affected (0.00 sec)\n \nselect host, user from mysql.user where user=\'user123\' ;\n \n+------+----------+\n| host | user |\n+------+----------+\n| % | user123 |\n+------+----------+\n \nPrivilege Levels\n \nPrivileges can be set globally, for an entire database, for\na table or routine,\nor for individual columns in a table. Certain privileges can\nonly be set at\ncertain levels.\nGlobal privileges are granted using *.* for\npriv_level. Global privileges include privileges to\nadminister the database\nand manage user accounts, as well as privileges for all\ntables, functions, and\nprocedures. Global privileges are stored in the mysql.user\ntable.\nDatabase privileges are granted using db_name.*\nfor priv_level, or using just * to use default database.\nDatabase\nprivileges include privileges to create tables and\nfunctions, as well as\nprivileges for all tables, functions, and procedures in the\ndatabase. Database privileges are stored in the mysql.db\ntable.\nTable privileges are granted using db_name.tbl_name\nfor priv_level, or using just tbl_name to specify a table in\nthe default\ndatabase. The TABLE keyword is optional. Table privileges\ninclude the\nability to select and change data in the table. Certain\ntable privileges can\nbe granted for individual columns.\nColumn privileges are granted by specifying a table for\npriv_level and providing a column list after the privilege\ntype. They allow\nyou to control exactly which columns in a table users can\nselect and change.\nFunction privileges are granted using FUNCTION\ndb_name.routine_name\nfor priv_level, or using just FUNCTION routine_name to\nspecify a function\nin the default database.\nProcedure privileges are granted using PROCEDURE\ndb_name.routine_name\nfor priv_level, or using just PROCEDURE routine_name to\nspecify a procedure\nin the default database.\n \nThe USAGE Privilege\n \nThe USAGE privilege grants no real privileges. The SHOW\nGRANTS\nstatement will show a global USAGE privilege for a\nnewly-created user. You\ncan use USAGE with the GRANT statement to change options\nlike GRANT OPTION\nand MAX_USER_CONNECTIONS without changing any account\nprivileges.\n \nThe ALL PRIVILEGES Privilege\n \nThe ALL PRIVILEGES privilege grants all available\nprivileges. Granting all\nprivileges only affects the given privilege level. For\nexample, granting all\nprivileges on a table does not grant any privileges on the\ndatabase or globally.\n \nUsing ALL PRIVILEGES does not grant the special GRANT OPTION\nprivilege.\n \nYou can use ALL instead of ALL PRIVILEGES.\n \nThe GRANT OPTION Privilege\n \nUse the WITH GRANT OPTION clause to give users the ability\nto grant privileges\nto other users at the given privilege level. Users with the\nGRANT OPTION privilege can\nonly grant privileges they have. They cannot grant\nprivileges at a higher privilege level than\nthey have the GRANT OPTION privilege.\n \nThe GRANT OPTION privilege cannot be set for individual\ncolumns.\nIf you use WITH GRANT OPTION when specifying column\nprivileges,\nthe GRANT OPTION privilege will be granted for the entire\ntable.\n \nUsing the WITH GRANT OPTION clause is equivalent to listing\nGRANT OPTION\nas a privilege.\n \nGlobal Privileges\n \nThe following table lists the privileges that can be granted\nglobally. You can\nalso grant all database, table, and function privileges\nglobally. When granted\nglobally, these privileges apply to all databases, tables,\nor functions,\nincluding those created later.\n \nTo set a global privilege, use *.* for priv_level.\n \nPrivilege | Description | \n \nCREATE USER | Create a user using the CREATE USER statement,\nor implicitly create a user with the GRANT statement. | \n \nFILE | Read and write files on the server, using statements\nlike LOAD DATA INFILE or functions like LOAD_FILE(). Also\nneeded to create CONNECT outward tables. MariaDB server must\nhave the permissions to access those files. | \n \nGRANT OPTION | Grant global privileges. You can only grant\nprivileges that you have. | \n \nPROCESS | Show information about the active processes, via\nSHOW PROCESSLIST or mysqladmin processlist. | \n \nRELOAD | Execute FLUSH statements or equivalent mysqladmin\ncommands. | \n \nREPLICATION CLIENT | Execute SHOW MASTER STATUS and SHOW\nSLAVE STATUS informative statements. | \n \nREPLICATION SLAVE | Accounts used by slave servers on the\nmaster need this privilege. This is needed to get the\nupdates made on the master. | \n \nSHOW DATABASES | List all databases using the SHOW DATABASES\nstatement. Without the SHOW DATABASES privilege, you can\nstill issue the SHOW DATABASES statement, but it will only\nlist databases containing tables on which you have\nprivileges. | \n \nSHUTDOWN | Shut down the server using SHUTDOWN or the\nmysqladmin shutdown command. | \n \nSUPER | Execute superuser statements: CHANGE MASTER TO, KILL\n(users who do not have this privilege can only KILL their\nown threads), PURGE LOGS, SET global system variables, or\nthe mysqladmin debug command. Also, this permission allows\nthe user to write data even if the read_only startup option\nis set, enable or disable logging, enable or disable\nreplication on slaves, specify a DEFINER for statements that\nsupport that clause, connect once after reaching the\nMAX_CONNECTIONS. If a statement has been specified for the\ninit-connect mysqld option, that command will not be\nexecuted when a user with SUPER privileges connects to the\nserver. | \n \nDatabase Privileges\n \nThe following table lists the privileges that can be granted\nat the database\nlevel. You can also grant all table and function privileges\nat the database\nlevel. Table and function privileges on a database apply to\nall tables or\nfunctions in that database, including those created later.\n \nTo set a privilege for a database, specify the database\nusing\ndb_name.* for priv_level, or just use *\nto specify the default database.\n \nPrivilege | Description | \n \nCREATE | Create a database using the CREATE DATABASE\nstatement, when the privilege is granted for a database. You\ncan grant the CREATE privilege on databases that do not yet\nexist. This also grants the CREATE privilege on all tables\nin the database. | \n \nCREATE ROUTINE | Create Stored Programs using the CREATE\nPROCEDURE and CREATE FUNCTION statements. | \n \nCREATE TEMPORARY TABLES | Create temporary tables with the\nCREATE TEMPORARY TABLE statement. This privilege enable\nwriting and dropping those temporary tables | \n \nDROP | Drop a database using the DROP DATABASE statement,\nwhen the privilege is granted for a database. This also\ngrants the DROP privilege on all tables in the database. | \n \nEVENT | Create, drop and alter EVENTs. Added in MySQL 5.1.6.\n| \n \nGRANT OPTION | Grant database privileges. You can only grant\nprivileges that you have. | \n \nLOCK TABLES | Acquire explicit locks using the LOCK TABLES\nstatement; you also need to have the SELECT privilege on a\ntable, in order to lock it. | \n \nTable Privileges\n \nPrivilege | Description | \n \nALTER | Change the structure of an existing table using the\nALTER TABLE statement. | \n \nCREATE | Create a table using the CREATE TABLE statement.\nYou can grant the CREATE privilege on tables that do not yet\nexist. | \n \nCREATE VIEW | Create a view using the CREATE_VIEW statement.\n| \n \nDELETE | Remove rows from a table using the DELETE\nstatement. | \n \nDELETE HISTORY | Remove historical rows from a table using\nthe DELETE HISTORY statement. Displays as DELETE VERSIONING\nROWS when running SHOW GRANTS (MDEV-17655). From MariaDB\n10.3.4. From MariaDB 10.3.5, if a user has the SUPER\nprivilege but not this privilege, running mysql_upgrade will\ngrant this privilege as well. | \n \nDROP | Drop a table using the DROP TABLE statement or a view\nusing the DROP VIEW statement. Also required to execute the\nTRUNCATE TABLE statement. | \n \nGRANT OPTION | Grant table privileges. You can only grant\nprivileges that you have. | \n \nINDEX | Create an index on a table using the CREATE INDEX\nstatement. Without the INDEX privilege, you can still create\nindexes when creating a table using the CREATE TABLE\nstatement if the you have the CREATE privilege, and you can\ncreate indexes using the ALTER TABLE statement if you have\nthe ALTER privilege. | \n \nINSERT | Add rows to a table using the INSERT statement. The\nINSERT privilege can also be set on individual columns; see\nColumn Privileges below for details. | \n \nREFERENCES | Unused. | \n \nSELECT | Read data from a table using the SELECT statement.\nThe SELECT privilege can also be set on individual columns;\nsee Column Privileges below for details. | \n \nSHOW VIEW | Show the CREATE VIEW statement to create a view\nusing the SHOW CREATE VIEW statement. | \n \nTRIGGER | Execute triggers associated to tables you update,\nexecute the CREATE TRIGGER and DROP TRIGGER statements. You\nwill still be able to see triggers. | \n \nUPDATE | Update existing rows in a table using the UPDATE\nstatement. UPDATE statements usually include a WHERE clause\nto update only certain rows. You must have SELECT privileges\non the table or the appropriate columns for the WHERE\nclause. The UPDATE privilege can also be set on individual\ncolumns; see Column Privileges below for details. | \n \nColumn Privileges\n \nSome table privileges can be set for individual columns of a\ntable. To use\ncolumn privileges, specify the table explicitly and provide\na list of column\nnames after the privilege type. For example, the following\nstatement would allow\nthe user to read the names and positions of employees, but\nnot other information\nfrom the same table, such as salaries.\n \nGRANT SELECT (name, position) on Employee to\n\'jeffrey\'@\'localhost\';\n \nPrivilege | Description | \n \nINSERT (column_list) | Add rows specifying values in columns\nusing the INSERT statement. If you only have column-level\nINSERT privileges, you must specify the columns you are\nsetting in the INSERT statement. All other columns will be\nset to their default values, or NULL. | \n \nREFERENCES (column_list) | Unused. | \n \nSELECT (column_list) | Read values in columns using the\nSELECT statement. You cannot access or query any columns for\nwhich you do not have SELECT privileges, including in WHERE,\nON, GROUP BY, and ORDER BY clauses. | \n \nUPDATE (column_list) | Update values in columns of existing\nrows using the UPDATE statement. UPDATE statements usually\ninclude a WHERE clause to update only certain rows. You must\nhave SELECT privileges on the table or the appropriate\ncolumns for the WHERE clause. | \n \nFunction Privileges\n \nPrivilege | Description | \n \nALTER ROUTINE | Change the characteristics of a stored\nfunction using the ALTER FUNCTION statement. | \n \nEXECUTE | Use a stored function. You need SELECT privileges\nfor any tables or columns accessed by the function. | \n \nGRANT OPTION | Grant function privileges. You can only grant\nprivileges that you have. | \n \nProcedure Privileges\n \nPrivilege | Description | \n \nALTER ROUTINE | Change the characteristics of a stored\nprocedure using the ALTER PROCEDURE statement. | \n \nEXECUTE | Execute a stored procedure using the CALL\nstatement. The privilege to call a procedure may allow you\nto perform actions you wouldn\'t otherwise be able to do,\nsuch as insert rows into a table. | \n \nGRANT OPTION | Grant procedure privileges. You can only\ngrant privileges that you have. | \n \nProxy Privileges\n \nPrivilege | Description | \n \nPROXY | Permits one user to be a proxy for another. | \n \nThe PROXY privilege allows one user to proxy as another\nuser, which means their privileges change to that of the\nproxy user, and the CURRENT_USER() function returns the user\nname of the proxy user.\n \nThe PROXY privilege only works with authentication plugins\nthat support it. The default mysql_native_password\nauthentication plugin does not support proxy users.\n \nThe pam authentication plugin is the only plugin included\nwith MariaDB that currently supports proxy users. The PROXY\nprivilege is commonly used with the pam authentication\nplugin to enable user and group mapping with PAM.\n \nFor example, to grant the PROXY privilege to an anonymous\naccount that authenticates with the pam authentication\nplugin, you could execute the following:\n \nCREATE USER \'dba\'@\'%\' IDENTIFIED BY \'strongpassword\';\n \nGRANT ALL PRIVILEGES ON *.* TO \'dba\'@\'%\' ;\n \nCREATE USER \'\'@\'%\' IDENTIFIED VIA pam USING \'mariadb\';\n \nGRANT PROXY ON \'dba\'@\'%\' TO \'\'@\'%\';\n \nA user account can only grant the PROXY privilege for a\nspecific user account if the granter also has the PROXY\nprivilege for that specific user account, and if that\nprivilege is defined WITH GRANT OPTION. For example, the\nfollowing example fails because the granter does not have\nthe PROXY privilege for that specific user account at all:\n \nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER() | CURRENT_USER() |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n \nSHOW GRANTS;\n \n+-----------------------------------------------------------------------------------------------------------------------+\n| Grants for alice@localhost |\n+-----------------------------------------------------------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\'\nIDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n+-----------------------------------------------------------------------------------------------------------------------+\n \nGRANT PROXY ON \'dba\'@\'localhost\' TO\n\'bob\'@\'localhost\';\n \nERROR 1698 (28000): Access denied for user\n\'alice\'@\'localhost\'\n \nAnd the following example fails because the granter does\nhave the PROXY privilege for that specific user account, but\nit is not defined WITH GRANT OPTION:\n \nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER() | CURRENT_USER() |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n \nSHOW GRANTS;\n \n+-----------------------------------------------------------------------------------------------------------------------+\n| Grants for alice@localhost |\n+-----------------------------------------------------------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\'\nIDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO\n\'alice\'@\'localhost\' |\n+-----------------------------------------------------------------------------------------------------------------------+\n \nMariaDB [(none)]> GRANT PROXY ON \'dba\'@\'localhost\' TO\n\'bob\'@\'localhost\';\n \nERROR 1698 (28000): Access denied for user\n\'alice\'@\'localhost\'\n \nBut the following example succeeds because the granter does\nhave the PROXY privilege for that specific user account, and\nit is defined WITH GRANT OPTION:\n \nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER() | CURRENT_USER() |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n \nSHOW GRANTS;\n \n+-----------------------------------------------------------------------------------------------------------------------------------------+\n| Grants for alice@localhost |\n+-----------------------------------------------------------------------------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\'\nIDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT\nOPTION |\n| GRANT PROXY ON \'dba\'@\'localhost\' TO\n\'alice\'@\'localhost\' WITH GRANT OPTION |\n+-----------------------------------------------------------------------------------------------------------------------------------------+\n \nGRANT PROXY ON \'dba\'@\'localhost\' TO\n\'bob\'@\'localhost\';\n \nQuery OK, 0 rows affected (0.004 sec)\n \nA user account can grant the PROXY privilege for any other\nuser account if the granter has the PROXY privilege for the\n\'\'@\'%\' anonymous user account, like this:\n \nGR','','https://mariadb.com/kb/en/library/grant/');
update help_topic set description = CONCAT(description, 'ANT PROXY ON \'\'@\'%\' TO \'dba\'@\'localhost\' WITH\nGRANT OPTION;\n \nFor example, the following example succeeds because the user\ncan grant the PROXY privilege for any other user account:\n \nSELECT USER(), CURRENT_USER();\n+-----------------+-----------------+\n| USER() | CURRENT_USER() |\n+-----------------+-----------------+\n| alice@localhost | alice@localhost |\n+-----------------+-----------------+\n \nSHOW GRANTS;\n \n+-----------------------------------------------------------------------------------------------------------------------------------------+\n| Grants for alice@localhost |\n+-----------------------------------------------------------------------------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'alice\'@\'localhost\'\nIDENTIFIED BY PASSWORD\n\'*2470C0C06DEE42FD1618BB99005ADCA2EC9D1E19\' WITH GRANT\nOPTION |\n| GRANT PROXY ON \'\'@\'%\' TO \'alice\'@\'localhost\' WITH\nGRANT OPTION |\n+-----------------------------------------------------------------------------------------------------------------------------------------+\n \nGRANT PROXY ON \'app1_dba\'@\'localhost\' TO\n\'bob\'@\'localhost\';\n \nQuery OK, 0 rows affected (0.004 sec)\n \nGRANT PROXY ON \'app2_dba\'@\'localhost\' TO\n\'carol\'@\'localhost\';\n \nQuery OK, 0 rows affected (0.004 sec)\n \nThe default root user accounts created by mysql_install_db\nhave this privilege. For example:\n \nGRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH\nGRANT OPTION;\n \nGRANT PROXY ON \'\'@\'%\' TO \'root\'@\'localhost\' WITH\nGRANT OPTION;\n \nThis allows the default root user accounts to grant the\nPROXY privilege for any other user account, and it also\nallows the default root user accounts to grant others the\nprivilege to do the same.\n \nAuthentication Options\n \nThe authentication options for the GRANT statement are the\nsame as those for the CREATE USER statement.\n \nIDENTIFIED BY \'password\'\n \nThe optional IDENTIFIED BY clause can be used to provide an\naccount with a password. The password should be specified in\nplain text. It will be hashed by the PASSWORD function prior\nto being stored to the mysql.user table.\n \nFor example, if our password is mariadb, then we can create\nthe user with:\n \nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY \'mariadb\';\n \nIf you do not specify a password with the IDENTIFIED BY\nclause, the user\nwill be able to connect without a password. A blank password\nis not a wildcard\nto match any password. The user must connect without\nproviding a password if no\npassword is set.\n \nIf the user account already exists and if you provide the\nIDENTIFIED BY clause, then the user\'s password will be\nchanged. You must have the privileges needed for the SET\nPASSWORD\nstatement to change a user\'s password with GRANT.\n \nThe only authentication plugins that this clause supports\nare mysql_native_password and mysql_old_password.\n \nIDENTIFIED BY PASSWORD \'password_hash\'\n \nThe optional IDENTIFIED BY PASSWORD clause can be used to\nprovide an account with a password that has already been\nhashed. The password should be specified as a hash that was\nprovided by the PASSWORD function. It will be stored to the\nmysql.user table as-is.\n \nFor example, if our password is mariadb, then we can find\nthe hash with:\n \nSELECT PASSWORD(\'mariadb\');\n+-------------------------------------------+\n| PASSWORD(\'mariadb\') |\n+-------------------------------------------+\n| *54958E764CE10E50764C2EECBB71D01F08549980 |\n+-------------------------------------------+\n1 row in set (0.00 sec)\n \nAnd then we can create a user with the hash:\n \nGRANT USAGE ON *.* TO foo2@test IDENTIFIED BY PASSWORD\n\'*54958E764CE10E50764C2EECBB71D01F08549980\';\n \nIf you do not specify a password with the IDENTIFIED BY\nclause, the user\nwill be able to connect without a password. A blank password\nis not a wildcard\nto match any password. The user must connect without\nproviding a password if no\npassword is set.\n \nIf the user account already exists and if you provide the\nIDENTIFIED BY clause, then the user\'s password will be\nchanged. You must have the privileges needed for the SET\nPASSWORD\nstatement to change a user\'s password with GRANT.\n \nThe only authentication plugins that this clause supports\nare mysql_native_password and mysql_old_password.\n \nIDENTIFIED {VIA|WITH} authentication_plugin\n \nThe optional IDENTIFIED VIA authentication_plugin allows you\nto specify that the account should be authenticated by a\nspecific authentication plugin. The plugin name must be an\nactive authentication plugin as per SHOW PLUGINS. If it\ndoesn\'t show up in that output, then you will need to\ninstall it with INSTALL PLUGIN or INSTALL SONAME.\n \nFor example, this could be used with the PAM authentication\nplugin:\n \nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam;\n \nSome authentication plugins allow additional arguments to be\nspecified after a USING or AS keyword. For example, the PAM\nauthentication plugin accepts a service name:\n \nGRANT USAGE ON *.* TO foo2@test IDENTIFIED VIA pam USING\n\'mariadb\';\n \nThe exact meaning of the additional argument would depend on\nthe specific authentication plugin.\n \nThe USING or AS keyword can also be used to provide a\nplain-text password to a plugin if it\'s provided as an\nargument to the PASSWORD() function. This is only valid for\nauthentication plugins that have implemented a hook for the\nPASSWORD() function. For example, the ed25519 authentication\nplugin supports this:\n \nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING\nPASSWORD(\'secret\');\n \nOne can specify many authentication plugins, they all works\nas alternatives ways of authenticating a user:\n \nCREATE USER safe@\'%\' IDENTIFIED VIA ed25519 USING\nPASSWORD(\'secret\') OR unix_socket;\n \nResource Limit Options\n \nMariaDB 10.2.0 introduced a number of resource limit\noptions.\n \nIt is possible to set per-account limits for certain server\nresources. The following table shows the values that can be\nset per account:\n \nLimit Type | Decription | \n \nMAX_QUERIES_PER_HOUR | Number of statements that the account\ncan issue per hour (including updates) | \n \nMAX_UPDATES_PER_HOUR | Number of updates (not queries) that\nthe account can issue per hour | \n \nMAX_CONNECTIONS_PER_HOUR | Number of connections that the\naccount can start per hour | \n \nMAX_USER_CONNECTIONS | Number of simultaneous connections\nthat can be accepted from the same account; if it is 0,\nmax_connections will be used instead; if max_connections is\n0, there is no limit for this account\'s simultaneous\nconnections. | \n \nMAX_STATEMENT_TIME | Timeout, in seconds, for statements\nexecuted by the user. See also Aborting Statements that\nExceed a Certain Time to Execute. | \n \nIf any of these limits are set to 0, then there is no limit\nfor that resource for that user.\n \nTo set resource limits for an account, if you do not want to\nchange that account\'s privileges, you can issue a GRANT\nstatement with the USAGE privilege, which has no meaning.\nThe statement can name some or all limit types, in any\norder.\n \nHere is an example showing how to set resource limits:\n \nGRANT USAGE ON *.* TO \'someone\'@\'localhost\' WITH\n MAX_USER_CONNECTIONS 0\n MAX_QUERIES_PER_HOUR 200;\n \nThe resources are tracked per account, which means\n\'user\'@\'server\'; not per user name or per connection.\n \nThe count can be reset for all users using FLUSH\nUSER_RESOURCES, FLUSH PRIVILEGES or mysqladmin reload.\n \nPer account resource limits are stored in the user table, in\nthe mysql database. Columns used for resources limits are\nnamed max_questions, max_updates, max_connections (for\nMAX_CONNECTIONS_PER_HOUR), and max_user_connections (for\nMAX_USER_CONNECTIONS).\n \nTLS Options\n \nBy default, MariaDB transmits data between the server and\nclients without encrypting it. This is generally acceptable\nwhen the server and client run on the same host or in\nnetworks where security is guaranteed through other means.\nHowever, in cases where the server and client exist on\nseparate networks or they are in a high-risk network, the\nlack of encryption does introduce security concerns as a\nmalicious actor could potentially eavesdrop on the traffic\nas it is sent over the network between them.\n \nTo mitigate this concern, MariaDB allows you to encrypt data\nin transit between the server and clients using the\nTransport Layer Security (TLS) protocol. TLS was formerly\nknown as Secure Socket Layer (SSL), but strictly speaking\nthe SSL protocol is a predecessor to TLS and, that version\nof the protocol is now considered insecure. The\ndocumentation still uses the term SSL often and for\ncompatibility reasons TLS-related server system and status\nvariables still use the prefix ssl_, but internally, MariaDB\nonly supports its secure successors.\n \nSee Secure Connections Overview for more information about\nhow to determine whether your MariaDB server has TLS\nsupport.\n \nYou can set certain TLS-related restrictions for specific\nuser accounts. For instance, you might use this with user\naccounts that require access to sensitive data while sending\nit across networks that you do not control. These\nrestrictions can be enabled for a user account with the\nCREATE USER, ALTER USER, or GRANT statements. The following\noptions are available:\n \nOption | Description | \n \nREQUIRE NONE | TLS is not required for this account, but can\nstill be used. | \n \nREQUIRE SSL | The account must use TLS, but no valid X509\ncertificate is required. This option cannot be combined with\nother TLS options. | \n \nREQUIRE X509 | The account must use TLS and must have a\nvalid X509 certificate. This option implies REQUIRE SSL.\nThis option cannot be combined with other TLS options. | \n \nREQUIRE ISSUER \'issuer\' | The account must use TLS and\nmust have a valid X509 certificate. Also, the Certificate\nAuthority must be the one specified via the string issuer.\nThis option implies REQUIRE X509. This option can be\ncombined with the SUBJECT, and CIPHER options in any order.\n| \n \nREQUIRE SUBJECT \'subject\' | The account must use TLS and\nmust have a valid X509 certificate. Also, the certificate\'s\nSubject must be the one specified via the string subject.\nThis option implies REQUIRE X509. This option can be\ncombined with the ISSUER, and CIPHER options in any order. |\n\n \nREQUIRE CIPHER \'cipher\' | The account must use TLS, but no\nvalid X509 certificate is required. Also, the encryption\nused for the connection must use one of the methods\nspecified in the string cipher. This option implies REQUIRE\nSSL. This option can be combined with the ISSUER, and\nSUBJECT options in any order. | \n \nThe REQUIRE keyword must be used only once for all specified\noptions, and the AND keyword can be used to separate\nindividual options, but it is not required.\n \nFor example, you can create a user account that requires\nthese TLS options with the following:\n \nGRANT USAGE ON *.* TO \'alice\'@\'%\'\n REQUIRE SUBJECT \'/CN=alice/O=My Dom,\nInc./C=US/ST=Oregon/L=Portland\'\n AND ISSUER \'/C=FI/ST=Somewhere/L=City/ O=Some\nCompany/CN=Peter Parker/emailAddress=p.parker@marvel.com\'\n AND CIPHER \'TLSv1.2\';\n \nIf any of these options are set for a specific user account,\nthen any client who tries to connect with that user account\nwill have to be configured to connect with TLS.\n \nSee Securing Connections for Client and Server for\ninformation on how to enable TLS on the client and server.\n \nRoles\n \nRoles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nGRANT role TO grantee [, grantee2 ... ]\n[ WITH ADMIN OPTION ]\n \nThe GRANT statement is also used to grant the use a role to\none or more users or other roles. In order to be able to\ngrant a role, the grantor doing so must have permission to\ndo so (see WITH ADMIN in the CREATE ROLE article).\n \nSpecifying the WITH ADMIN OPTION permits the grantee to in\nturn grant the role to another.\n \nFor example, the following commands show how to grant the\nsame role to a couple different users.\n \nGRANT journalist TO hulda;\n \nGRANT journalist TO berengar WITH ADMIN OPTION;\n \nIf a user has been granted a role, they do not automatically\nobtain all permissions associated with that role. These\npermissions are only in use when the user activates the role\nwith the SET ROLE statement.\n \nGrant Examples\n \nGranting Root-like Privileges\n \nYou can create a user that has privileges similar to the\ndefault root accounts by executing the following:\n \nCREATE USER \'alexander\'@\'localhost\';\n \nGRANT ALL PRIVILEGES ON *.* to \'alexander\'@\'localhost\'\nWITH GRANT OPTION;\n \n\n\nURL: https://mariadb.com/kb/en/library/grant/') WHERE help_topic_id = 121;
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (122,10,'User Password Expiry','User password expiry was introduced in MariaDB 10.4.3.\n \nPassword expiry permits administrators to expire user\npasswords, either manually or automatically. \n \nSystem Variables\n \nThere are two system variables which affect password expiry:\ndefault_password_lifetime, which determines the amount of\ntime between requiring the user to change their password. 0,\nthe default, means automatic password expiry is not active.\n \nThe second variable, disconnect_on_expired_password\ndetermines whether a client is permitted to connect if their\npassword has expired, or whether they are permitted to\nconnect in sandbox mode, able to perform a limited subset of\nqueries related to resetting the password, in particular SET\nPASSWORD and SET.\n \nSetting a Password Expiry Limit for a User\n \nBesides automatic password expiry, as determined by\ndefault_password_lifetime, password expiry times can be set\non an individual user basis, overriding the global using the\nCREATE USER or ALTER USER statements, for example:\n \nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL\n120 DAY;\n \nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL\n120 DAY;\n \nLimits can be disabled by use of the NEVER keyword, for\nexample:\n \nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n \nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE NEVER;\n \nA manually set limit can be restored the system default by\nuse of DEFAULT, for example:\n \nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n \nALTER USER \'monty\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n \nSHOW CREATE USER\n \nThe SHOW CREATE USER statement will display information\nabout the password expiry status of the user. Unlike MySQL,\nit will not display if the user is unlocked, or if the\npassword expiry is set to default.\n \nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL\n120 DAY;\n \nCREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE\nNEVER;\n \nCREATE USER \'amse\'@\'localhost\' PASSWORD EXPIRE DEFAULT;\n \nSHOW CREATE USER \'monty\'@\'localhost\';\n \n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE\nINTERVAL 120 DAY |\n+------------------------------------------------------------------+\n \nSHOW CREATE USER \'konstantin\'@\'localhost\';\n \n+------------------------------------------------------------+\n| CREATE USER for konstantin@localhost |\n+------------------------------------------------------------+\n| CREATE USER \'konstantin\'@\'localhost\' PASSWORD EXPIRE\nNEVER |\n+------------------------------------------------------------+\n \nSHOW CREATE USER \'amse\'@\'localhost\';\n \n+--------------------------------+\n| CREATE USER for amse@localhost |\n+--------------------------------+\n| CREATE USER \'amse\'@\'localhost\' |\n+--------------------------------+\n \n--connect-expired-password Client Option\n \nThe mysql client --connect-expired-password option notifies\nthe server that the client is prepared to handle expired\npassword sandbox mode (even if the --batch option was\nspecified).\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/user-password-expiry/','','https://mariadb.com/kb/en/library/user-password-expiry/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (123,10,'RENAME USER','Syntax\n------ \nRENAME USER old_user TO new_user\n [, old_user TO new_user] ...\n \nDescription\n----------- \nThe RENAME USER statement renames existing MariaDB accounts.\nTo use it,\nyou must have the global CREATE USER privilege\nor the UPDATE privilege for the mysql database.\nEach account is named using the same format as for the\nCREATE USER\nstatement; for example, \'jeffrey\'@\'localhost\'.\nIf you specify only the user name part of the account name,\na host\nname part of \'%\' is used.\n \nIf any of the old user accounts do not exist or any of the\nnew user accounts already\nexist, ERROR 1396 (HY000) results. If an error occurs,\nRENAME USER\nwill still rename the accounts that do not result in an\nerror.\n \nExamples\n-------- \nCREATE USER \'donald\', \'mickey\';\n \nRENAME USER \'donald\' TO \'duck\'@\'localhost\', \'mickey\'\nTO \'mouse\'@\'localhost\';\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/rename-user/','','https://mariadb.com/kb/en/library/rename-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (124,10,'REVOKE','Privileges\n \nSyntax\n------ \nREVOKE \n priv_type [(column_list)]\n [, priv_type [(column_list)]] ...\n ON [object_type] priv_level\n FROM user [, user] ...\n \nREVOKE ALL PRIVILEGES, GRANT OPTION\n FROM user [, user] ...\n \nDescription\n----------- \nThe REVOKE statement enables system administrators to revoke\nprivileges (or roles - see section below) from MariaDB\naccounts. Each account is named using the same format\nas for the GRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name\npart\nof the account name, a host name part of \'%\' is used. For\ndetails on the levels at which privileges exist, the\nallowable\npriv_type and priv_level values, and the\nsyntax for specifying users and passwords, see GRANT.\n \nTo use the first REVOKE syntax, you must have the\nGRANT OPTION privilege, and you must have the privileges\nthat\nyou are revoking.\n \nTo revoke all privileges, use the second syntax, which drops\nall\nglobal, database, table, column, and routine privileges for\nthe named\nuser or users:\n \nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n \nTo use this REVOKE syntax, you must have the global\nCREATE USER privilege or the\nUPDATE privilege for the mysql database. See\nGRANT.\n \nExamples\n-------- \nREVOKE SUPER ON *.* FROM \'alexander\'@\'localhost\';\n \nRoles\n \nRoles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nREVOKE role [, role ...]\n FROM grantee [, grantee2 ... ]\n \nDescription\n----------- \nREVOKE is also used to remove a role from a user or another\nrole that it\'s previously been assigned to. If a role has\npreviously been set as a default role, REVOKE does not\nremove the record of the default role from the mysql.user\ntable. If the role is subsequently granted again, it will\nagain be the user\'s default. Use SET DEFAULT ROLE NONE to\nexplicitly remove this.\n \nBefore MariaDB 10.1.13, the REVOKE role statement was not\npermitted in prepared statements.\n \nExample\n \nREVOKE journalist FROM hulda\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/revoke/','','https://mariadb.com/kb/en/library/revoke/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (125,10,'SET PASSWORD','Syntax\n------ \nSET PASSWORD [FOR user] =\n {\n PASSWORD(\'some password\')\n | OLD_PASSWORD(\'some password\')\n | \'encrypted password\'\n }\n \nDescription\n----------- \nThe SET PASSWORD statement assigns a password to an existing\nMariaDB user\naccount.\n \nIf the password is specified using the PASSWORD() or\nOLD_PASSWORD()\nfunction, the literal text of the password should be given.\nIf the\npassword is specified without using either function, the\npassword\nshould be the already-encrypted password value as returned\nby\nPASSWORD().\n \nOLD_PASSWORD() should only be used if your MariaDB/MySQL\nclients are very old (< 4.0.0).\n \nWith no FOR clause, this statement sets the password for the\ncurrent\nuser. Any client that has connected to the server using a\nnon-anonymous\naccount can change the password for that account.\n \nWith a FOR clause, this statement sets the password for a\nspecific\naccount on the current server host. Only clients that have\nthe UPDATE\nprivilege for the mysql database can do this. The user value\nshould be\ngiven in user_name@host_name format, where user_name and\nhost_name are\nexactly as they are listed in the User and Host columns of\nthe\nmysql.user table entry. \n \nThe argument to PASSWORD() and the password given to MariaDB\nclients can be of arbitrary length.\n \nAuthentication Plugin Support\n \nIn MariaDB 10.4 and later, SET PASSWORD (with or without\nPASSWORD()) works for accounts authenticated via any\nauthentication plugin that supports passwords stored in the\nmysql.global_priv table.\n \nThe ed25519, mysql_native_password, and mysql_old_password\nauthentication plugins store passwords in the\nmysql.global_priv table.\n \nIf you run SET PASSWORD on an account that authenticates\nwith one of these authentication plugins that stores\npasswords in the mysql.global_priv table, then the\nPASSWORD() function is evaluated by the specific\nauthentication plugin used by the account. The\nauthentication plugin hashes the password with a method that\nis compatible with that specific authentication plugin.\n \nThe unix_socket, named_pipe, gssapi, and pam authentication\nplugins do not store passwords in the mysql.global_priv\ntable. These authentication plugins rely on other methods to\nauthenticate the user.\n \nIf you attempt to run SET PASSWORD on an account that\nauthenticates with one of these authentication plugins that\ndoesn\'t store a password in the mysql.global_priv table,\nthen MariaDB Server will raise a warning like the following:\n \nSET PASSWORD is ignored for users authenticating via\nunix_socket plugin\n \nSee Authentication from MariaDB 10.4 for an overview of\nauthentication changes in MariaDB 10.4.\n \nMariaDB until 10.3\n \nIn MariaDB 10.3 and before, SET PASSWORD (with or without\nPASSWORD()) only works for accounts authenticated via\nmysql_native_password or mysql_old_password authentication\nplugins\n \nPasswordless User Accounts\n \nUser accounts do not always require passwords to login.\n \nThe unix_socket and named_pipe authentication plugins do not\nrequire a password to authenticate the user.\n \nThe gssapi and pam authentication plugins may or may not\nrequire a password to authenticate the user, depending on\nthe specific configuration.\n \nThe mysql_native_password and mysql_old_password\nauthentication plugins require passwords for authentication,\nbut the password can be blank. In that case, no password is\nrequired.\n \nIf you provide a password while attempting to log into the\nserver as an account that doesn\'t require a password, then\nMariaDB server will simply ignore the password.\n \nIn MariaDB 10.4 and later, a user account can be defined to\nuse multiple authentication plugins in a specific order of\npreference. This specific scenario may be more noticeable in\nthese versions, since an account could be associated with\nsome authentication plugins that require a password, and\nsome that do not.\n \nExample\n \nFor example, if you had an entry with User and\nHost column values of \'bob\' and \n\'%.loc.gov\', you would write the\nstatement like this:\n \nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' =\nPASSWORD(\'newpass\');\n \n\n\nURL: https://mariadb.com/kb/en/library/set-password/','','https://mariadb.com/kb/en/library/set-password/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (126,10,'Roles Overview','Roles were introduced in MariaDB 10.0.5.\n \nDescription\n----------- \nA role bundles a number of privileges together. It assists\nlarger organizations where, typically, a number of users\nwould have the same privileges, and, previously, the only\nway to change the privileges for a group of users was by\nchanging each user\'s privileges individually. \n \nAlternatively, multiple external users could have been\nassigned the same user, and there would have been no way to\nsee which actual user was responsible for which action.\n \nWith roles, managing this is easy. For example, there could\nbe a number of users assigned to a journalist role, with\nidentical privileges. Changing the privileges for all the\njournalists is a matter of simply changing the role\'s\nprivileges, while the individual user is still linked with\nany changes that take place.\n \nRoles are created with the CREATE ROLE statement, and\ndropped with the DROP ROLE statement. Roles are then\nassigned to a user with an extension to the GRANT statement,\nwhile privileges are assigned to a role in the regular way\nwith GRANT. Similarly, the REVOKE statement can be used to\nboth revoke a role from a user, or revoke a privilege from a\nrole.\n \nOnce a user has connected, he can obtain all privileges\nassociated with a role by setting a role with the SET ROLE\nstatement. The CURRENT_ROLE function returns the currently\nset role for the session, if any.\n \nOnly roles granted directly to a user can be set, roles\ngranted to other roles cannot. Instead the privileges\ngranted to a role, which is, in turn, granted to another\nrole (grantee), will be immediately available to any user\nwho sets this second grantee role.\n \nRoles were implemented as a GSoC 2013 project by Vicentiu\nCiorbaru. \n \nThe SET DEFAULT ROLE statement allows one to set a default\nrole for a user. A default role is automatically enabled\nwhen a user connects (an implicit SET ROLE statement is\nexecuted immediately after a connection is established).\n \nSystem Tables\n \nInformation about roles and who they\'ve been granted to can\nbe found in the Information Schema APPLICABLE_ROLES table as\nwell as the mysql.ROLES_MAPPING table.\n \nThe Information Schema ENABLED_ROLES table shows the enabled\nroles for the current session.\n \nExamples\n-------- \nCreating a role and granting a privilege:\n \nCREATE ROLE journalist;\n \nGRANT SHOW DATABASES ON *.* TO journalist;\n \nGRANT journalist to hulda;\n \nNote, that hulda has no SHOW DATABASES privilege, even\nthough she was granted the journalist role. She needs to set\nthe role first:\n \nSHOW DATABASES;\n \n+--------------------+\n| Database |\n+--------------------+\n| information_schema |\n+--------------------+\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL |\n+--------------+\n \nSET ROLE journalist;\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist |\n+--------------+\n \nSHOW DATABASES;\n \n+--------------------+\n| Database |\n+--------------------+\n| ... |\n| information_schema |\n| mysql |\n| performance_schema |\n| test |\n| ... |\n+--------------------+\n \nSET ROLE NONE;\n \nRoles can be granted to roles:\n \nCREATE ROLE writer;\n \nGRANT SELECT ON data.* TO writer;\n \nGRANT writer TO journalist;\n \nBut one does not need to set a role granted to a role. For\nexample, hulda will automatically get all writer privileges\nwhen she sets the journalist role:\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL |\n+--------------+\n \nSHOW TABLES FROM data;\n \nEmpty set (0.01 sec)\n \nSET ROLE journalist;\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| journalist |\n+--------------+\n \nSHOW TABLES FROM data;\n \n+------------------------------+\n| Tables_in_data |\n+------------------------------+\n| set1 |\n| ... |\n+------------------------------+\n \nRoles and Views (and Stored Routines)\n \nWhen a user sets a role, he, in a sense, has two identities\nwith two associated sets of privileges.\nBut a view (or a stored routine) can have only one definer.\nSo, when a view (or a stored routine) is created with the\nSQL SECURITY DEFINER, one can specify whether the definer\nshould be CURRENT_USER (and the view will have none of the\nprivileges of the user\'s role) or CURRENT_ROLE (in this\ncase, the view will use role\'s privileges, but none of the\nuser\'s privileges). As a result, sometimes one can create a\nview that is impossible to use.\n \nCREATE ROLE r1;\n \nGRANT ALL ON db1.* TO r1;\n \nGRANT r1 TO foo@localhost;\n \nGRANT ALL ON db.* TO foo@localhost;\n \nSELECT CURRENT_USER\n+---------------+\n| current_user |\n+---------------+\n| foo@localhost |\n+---------------+\n \nSET ROLE r1;\n \nCREATE TABLE db1.t1 (i int);\n \nCREATE VIEW db.v1 AS SELECT * FROM db1.t1;\n \nSHOW CREATE VIEW db.v1;\n \n+------+------------------------------------------------------------------------------------------------------------------------------------------+----------------------+----------------------+\n| View | Create View | character_set_client |\ncollation_connection |\n+------+------------------------------------------------------------------------------------------------------------------------------------------+----------------------+----------------------+\n| v1 | CREATE ALGORITHM=UNDEFINED DEFINER=`foo`@`localhost`\nSQL SECURITY DEFINER VIEW `db`.`v1` AS SELECT `db1`.`t1`.`i`\nAS `i` from `db1`.`t1` | utf8 | utf8_general_ci |\n+------+------------------------------------------------------------------------------------------------------------------------------------------+----------------------+----------------------+\n \nCREATE DEFINER=CURRENT_ROLE VIEW db.v2 AS SELECT * FROM\ndb1.t1;\n \nSHOW CREATE VIEW db.b2;\n \n+------+-----------------------------------------------------------------------------------------------------------------------------+----------------------+----------------------+\n| View | Create View | character_set_client |\ncollation_connection |\n+------+-----------------------------------------------------------------------------------------------------------------------------+----------------------+----------------------+\n| v2 | CREATE ALGORITHM=UNDEFINED DEFINER=`r1` SQL SECURITY\nDEFINER VIEW `db`.`v2` AS select `db1`.`t1`.`a` AS `a` from\n`db1`.`t1` | utf8 | utf8_general_ci |\n+------+-----------------------------------------------------------------------------------------------------------------------------+----------------------+----------------------+\n \nOther Resources\n \nRoles Review by Peter Gulutzan\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/roles_overview/','','https://mariadb.com/kb/en/library/roles_overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (127,10,'CREATE ROLE','Roles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nCREATE [OR REPLACE] ROLE [IF NOT EXISTS] role \n [WITH ADMIN \n {CURRENT_USER | CURRENT_ROLE | user | role}]\n \nDescription\n----------- \nThe CREATE ROLE statement creates one or more MariaDB roles.\nTo\nuse it, you must have the global CREATE USER\nprivilege or the INSERT privilege for the mysql\ndatabase. For each account, CREATE ROLE creates a new row in\nthe\nmysql.user table that has no privileges, and with the\ncorresponding is_role field set to Y. It also creates a\nrecord in the\nmysql.roles_mapping table.\n \nIf any of the specified roles already exist, ERROR 1396\n(HY000) results. If\nan error occurs, CREATE ROLE will still create the roles\nthat do not result\nin an error. The maximum length for a role is 128\ncharacters. Role names can be\nquoted, as explained in the Identifier names page. Only\none error is produced for all roles which have not been\ncreated:\n \nERROR 1396 (HY000): Operation CREATE ROLE failed for\n\'a\',\'b\',\'c\'\n \nFailed CREATE or DROP operations, for both users and roles,\nproduce the\nsame error code.\n \nPUBLIC and NONE are reserved, and cannot be used as role\nnames.\n \nBefore MariaDB 10.1.13, the CREATE ROLE statement was not\npermitted in prepared statements.\n \nFor valid identifiers to use as role names, see Identifier\nNames.\n \nWITH ADMIN\n \nThe optional WITH ADMIN clause determines whether the\ncurrent user, the\ncurrent role or another user or role has use of the newly\ncreated role. If the\nclause is omitted, WITH ADMIN CURRENT_USER is treated as the\ndefault, which\nmeans that the current user will be able to GRANT this role\nto\nusers.\n \nOR REPLACE\n \nThe OR REPLACE clause was added in MariaDB 10.1.3\n \nIf the optional OR REPLACE clause is used, it acts as a\nshortcut for:\n \nDROP ROLE IF EXISTS name;\n \nCREATE ROLE name ...;\n \nIF NOT EXISTS\n \nThe IF NOT EXISTS clause was added in MariaDB 10.1.3\n \nWhen the IF NOT EXISTS clause is used, MariaDB will return a\nwarning instead of an error if the specified role already\nexists. Cannot be used together with the OR REPLACE clause.\n \nExamples\n-------- \nCREATE ROLE journalist;\n \nCREATE ROLE developer WITH ADMIN lorinda;\n \nThe OR REPLACE and IF NOT EXISTS clauses:\n \nCREATE ROLE journalist;\nERROR 1396 (HY000): Operation CREATE ROLE failed for\n\'journalist\'\n \nCREATE OR REPLACE ROLE journalist;\nQuery OK, 0 rows affected (0.00 sec)\n \nCREATE ROLE IF NOT EXISTS journalist;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n+-------+------+---------------------------------------------------+\n| Level | Code | Message |\n+-------+------+---------------------------------------------------+\n| Note | 1975 | Can\'t create role \'journalist\'; it\nalready exists |\n+-------+------+---------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/create-role/','','https://mariadb.com/kb/en/library/create-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (128,10,'DROP ROLE','Roles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nDROP ROLE [IF EXISTS] role_name [,role_name ...]\n \nDescription\n----------- \nThe DROP ROLE statement removes one or more MariaDB roles.\nTo use this\nstatement, you must have the global CREATE USER privilege or\nthe DELETE privilege for the mysql database.\n \nDROP ROLE does not disable roles for connections which\nselected them with SET ROLE. If a role has previously been\nset as a default role, DROP ROLE does not remove the record\nof the default role from the mysql.user table. If the role\nis subsequently recreated and granted, it will again be the\nuser\'s default. Use SET DEFAULT ROLE NONE to explicitly\nremove this.\n \nIf any of the specified user accounts do not exist, ERROR\n1396 (HY000)\nresults. If an error occurs, DROP ROLE will still drop the\nroles that\ndo not result in an error. Only one error is produced for\nall roles which have not been dropped:\n \nERROR 1396 (HY000): Operation DROP ROLE failed for\n\'a\',\'b\',\'c\'\n \nFailed CREATE or DROP operations, for both users and roles,\nproduce the same error code.\n \nBefore MariaDB 10.1.13, the DROP ROLE statement was not\npermitted in prepared statements.\n \nIF EXISTS\n \nThe IF EXISTS clause was added in MariaDB 10.1.3\n \nIf the IF EXISTS clause is used, MariaDB will return a\nwarning instead of an error if the role does not exist.\n \nExamples\n-------- \nDROP ROLE journalist;\n \nThe same thing using the optional IF EXISTS clause:\n \nDROP ROLE journalist;\n \nERROR 1396 (HY000): Operation DROP ROLE failed for\n\'journalist\'\n \nDROP ROLE IF EXISTS journalist;\n \nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nNote (Code 1975): Can\'t drop role \'journalist\'; it\ndoesn\'t exist\n \n\n\nURL: https://mariadb.com/kb/en/library/drop-role/','','https://mariadb.com/kb/en/library/drop-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (129,10,'SET ROLE','Roles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nSET ROLE { role | NONE }\n \nDescription\n----------- \nThe SET ROLE statement enables a role, along with all of its\nassociated permissions, for the current session. To unset a\nrole, use NONE .\n \nIf a role that doesn\'t exist, or to which the user has not\nbeen assigned, is specified, an ERROR 1959 (OP000): Invalid\nrole specification error occurs.\n \nFrom MariaDB 10.1.1, an automatic SET ROLE is implicitly\nperformed when a user connects if that user has been\nassigned a default role. See SET DEFAULT ROLE.\n \nExample\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL |\n+--------------+\n \nSET ROLE staff;\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff |\n+--------------+\n \nSET ROLE NONE;\n \nQuery OK, 0 rows affected (0.00 sec)\n \nSELECT CURRENT_ROLE();\n+----------------+\n| CURRENT_ROLE() |\n+----------------+\n| NULL |\n+----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/set-role/','','https://mariadb.com/kb/en/library/set-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (130,10,'SET DEFAULT ROLE','Default roles were implemented in MariaDB 10.1.1.\n \nSyntax\n------ \nSET DEFAULT ROLE { role | NONE } [ FOR user@host ]\n \nDescription\n----------- \nThe SET DEFAULT ROLE statement sets a default role for a\nspecified (or current) user. A default role is automatically\nenabled when a user connects (an implicit SET ROLE statement\nis executed immediately after a connection is established).\n \nTo be able to set a role as a default, one needs the\nprivileges to enable this role (if you cannot do SET ROLE X,\nyou won\'t be able to do SET DEFAULT ROLE X). To set a\ndefault role for another user one needs to have write access\nto the mysql database.\n \nTo remove a user\'s default role, use SET DEFAULT ROLE NONE\n[ FOR user@host ]. The record of the default role is not\nremoved if the role is dropped or revoked, so if the role is\nsubsequently re-created or granted, it will again be the\nuser\'s default role.\n \nThe default role is stored in a new column in the mysql.user\ntable, and currently viewing this table is the only way to\nsee which role has been assigned to a user as the default. \n \nExamples\n-------- \nSetting a default role for the current user:\n \nSET DEFAULT ROLE journalist;\n \nRemoving a default role from the current user:\n \nSET DEFAULT ROLE NONE;\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/set-default-role/','','https://mariadb.com/kb/en/library/set-default-role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (131,11,'ST_X','Syntax\n------ \nST_X(p)\nX(p)\n \nDescription\n----------- \nReturns the X-coordinate value for the point p as a\ndouble-precision number.\n \nST_X() and X() are synonyms.\n \nExamples\n-------- \nSET @pt = \'Point(56.7 53.34)\';\n \nSELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n| 56.7 |\n+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_x/','','https://mariadb.com/kb/en/library/st_x/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (132,11,'ST_Y','Syntax\n------ \nST_Y(p)\nY(p)\n \nDescription\n----------- \nReturns the Y-coordinate value for the point p as a\ndouble-precision number.\n \nST_Y() and Y() are synonyms.\n \nExamples\n-------- \nSET @pt = \'Point(56.7 53.34)\';\n \nSELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n| 53.34 |\n+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_y/','','https://mariadb.com/kb/en/library/st_y/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (133,11,'X','A synonym for ST_X.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/point-properties-x/','','https://mariadb.com/kb/en/library/point-properties-x/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (134,11,'Y','A synonym for ST_Y.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/point-properties-y/','','https://mariadb.com/kb/en/library/point-properties-y/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (135,12,'AES_DECRYPT','Syntax\n------ \nAES_DECRYPT(crypt_str,key_str)\n \nDescription\n----------- \nThis function allows decryption of data using the official\nAES\n(Advanced Encryption Standard) algorithm. For more\ninformation, see\nthe description of AES_ENCRYPT().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/aes_decrypt/','','https://mariadb.com/kb/en/library/aes_decrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (136,12,'AES_ENCRYPT','Syntax\n------ \nAES_ENCRYPT(str,key_str)\n \nDescription\n----------- \nAES_ENCRYPT() and AES_DECRYPT() allow encryption and\ndecryption of\ndata using the official AES (Advanced Encryption Standard)\nalgorithm,\npreviously known as \"Rijndael.\" Encoding with a 128-bit\nkey length is\nused, but you can extend it up to 256 bits by modifying the\nsource. We\nchose 128 bits because it is much faster and it is secure\nenough for\nmost purposes.\n \nAES_ENCRYPT() encrypts a string str using the key key_str,\nand returns a binary string.\n \nAES_DECRYPT() decrypts the encrypted string and returns the\noriginal\nstring.\n \nThe input arguments may be any length. If either argument is\nNULL, the result of this function is also NULL.\n \nBecause AES is a block-level algorithm, padding is used to\nencode\nuneven length strings and so the result string length may be\ncalculated using this formula:\n \n16 x (trunc(string_length / 16) + 1)\n \nIf AES_DECRYPT() detects invalid data or incorrect padding,\nit returns\nNULL. However, it is possible for AES_DECRYPT() to return a\nnon-NULL\nvalue (possibly garbage) if the input data or the key is\ninvalid.\n \nExamples\n-------- \nINSERT INTO t VALUES\n(AES_ENCRYPT(\'text\',SHA2(\'password\',512)));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/aes_encrypt/','','https://mariadb.com/kb/en/library/aes_encrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (137,12,'COMPRESS','Syntax\n------ \nCOMPRESS(string_to_compress)\n \nDescription\n----------- \nCompresses a string and returns the result as a binary\nstring. This\nfunction requires MariaDB to have been compiled with a\ncompression\nlibrary such as zlib. Otherwise, the return value is always\nNULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n \nThe have_compress server system variable indicates whether a\ncompression library is present. \n \nExamples\n-------- \nSELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n+------------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',1000))) |\n+------------------------------------+\n| 21 |\n+------------------------------------+\n \nSELECT LENGTH(COMPRESS(\'\'));\n+----------------------+\n| LENGTH(COMPRESS(\'\')) |\n+----------------------+\n| 0 |\n+----------------------+\n \nSELECT LENGTH(COMPRESS(\'a\'));\n+-----------------------+\n| LENGTH(COMPRESS(\'a\')) |\n+-----------------------+\n| 13 |\n+-----------------------+\n \nSELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n+----------------------------------+\n| LENGTH(COMPRESS(REPEAT(\'a\',16))) |\n+----------------------------------+\n| 15 |\n+----------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/compress/','','https://mariadb.com/kb/en/library/compress/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (138,12,'DECODE','Syntax\n------ \nDECODE(crypt_str,pass_str)\n \nDescription\n----------- \nDecrypts the encrypted string crypt_str using pass_str as\nthe\npassword. crypt_str should be a string returned from\nENCODE(). The resulting string will be the original string\nonly if pass_str is the same.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/decode/','','https://mariadb.com/kb/en/library/decode/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (139,12,'DES_DECRYPT','Syntax\n------ \nDES_DECRYPT(crypt_str[,key_str])\n \nDescription\n----------- \nDecrypts a string encrypted with DES_ENCRYPT(). If an error\noccurs,\nthis function returns NULL.\n \nThis function works only if MariaDB has been configured with\nTLS\nsupport.\n \nIf no key_str argument is given, DES_DECRYPT() examines the\nfirst byte\nof the encrypted string to determine the DES key number that\nwas used\nto encrypt the original string, and then reads the key from\nthe DES\nkey file to decrypt the message. For this to work, the user\nmust have\nthe SUPER privilege. The key file can be specified with the\n--des-key-file server option.\n \nIf you pass this function a key_str argument, that string is\nused as\nthe key for decrypting the message.\n \nIf the crypt_str argument does not appear to be an encrypted\nstring,\nMariaDB returns the given crypt_str.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/des_decrypt/','','https://mariadb.com/kb/en/library/des_decrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (140,12,'DES_ENCRYPT','Syntax\n------ \nDES_ENCRYPT(str[,{key_num|key_str}])\n \nDescription\n----------- \nEncrypts the string with the given key using the Triple-DES\nalgorithm.\n \nThis function works only if MariaDB has been configured with\nTLS support.\n \nThe encryption key to use is chosen based on the second\nargument to\nDES_ENCRYPT(), if one was given. With no argument, the first\nkey from\nthe DES key file is used. With a key_num argument, the given\nkey \nnumber (0-9) from the DES key file is used. With a key_str\nargument,\nthe given key string is used to encrypt str. \n \nThe key file can be specified with the --des-key-file server\noption.\n \nThe return string is a binary string where the first\ncharacter is \nCHAR(128 | key_num). If an error occurs, DES_ENCRYPT()\nreturns NULL.\n \nThe 128 is added to make it easier to recognize an encrypted\nkey. If\nyou use a string key, key_num is 127.\n \nThe string length for the result is given by this formula:\n \nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n \nEach line in the DES key file has the following format:\n \nkey_num des_key_str\n \nEach key_num value must be a number in the range from 0 to\n9. Lines in\nthe file may be in any order. des_key_str is the string that\nis used\nto encrypt the message. There should be at least one space\nbetween the\nnumber and the key. The first key is the default key that is\nused if\nyou do not specify any key argument to DES_ENCRYPT().\n \nYou can tell MariaDB to read new key values from the key\nfile with the\nFLUSH DES_KEY_FILE statement. This requires the RELOAD\nprivilege.\n \nOne benefit of having a set of default keys is that it gives\napplications a way to check for the existence of encrypted\ncolumn\nvalues, without giving the end user the right to decrypt\nthose values.\n \nExamples\n-------- \nSELECT customer_address FROM customer_table \n WHERE crypted_credit_card =\nDES_ENCRYPT(\'credit_card_number\');\n \n\n\nURL: https://mariadb.com/kb/en/library/des_encrypt/','','https://mariadb.com/kb/en/library/des_encrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (141,12,'ENCODE','Syntax\n------ \nENCODE(str,pass_str)\n \nDescription\n----------- \nENCODE is not considered cryptographically secure, and\nshould not be used for password encryption.\n \nEncrypt str using pass_str as the password. To decrypt the\nresult, use\nDECODE().\n \nThe result is a binary string of the same length as str.\n \nThe strength of the encryption is based on how good the\nrandom generator is. \n \nIt is not recommended to rely on the encryption performed by\nthe ENCODE function. Using a salt value (changed when a\npassword is updated) will improve matters somewhat, but for\nstoring passwords, consider a more cryptographically secure\nfunction, such as SHA2().\n \nExamples\n-------- \nENCODE(\'not so secret text\',\nCONCAT(\'random_salt\',\'password\'))\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/encode/','','https://mariadb.com/kb/en/library/encode/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (142,12,'ENCRYPT','Syntax\n------ \nENCRYPT(str[,salt])\n \nDescription\n----------- \nEncrypts a string using the Unix crypt() system call,\nreturning an encrypted binary string. The salt argument\nshould be a string with at least two characters or the\nreturned result will be NULL. If no salt argument is given,\na random value of sufficient length is used.\n \nIt is not recommended to use ENCRYPT() with utf16, utf32 or\nucs2 multi-byte character sets because the crypt() system\ncall expects a string terminated with a zero byte.\n \nNote that the underlying crypt() system call may have some\nlimitations, such as ignoring all but the first eight\ncharacters.\n \nIf the have_crypt system variable is set to NO (because the\ncrypt() system call is not available), the ENCRYPT function\nwill always return NULL.\n \nExamples\n-------- \nSELECT ENCRYPT(\'encrypt me\');\n+-----------------------+\n| ENCRYPT(\'encrypt me\') |\n+-----------------------+\n| 4I5BsEx0lqTDk |\n+-----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/encrypt/','','https://mariadb.com/kb/en/library/encrypt/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (143,12,'MD5','Syntax\n------ \nMD5(str)\n \nDescription\n----------- \nCalculates an MD5 128-bit checksum for the string. \n \nThe return value is a 32-hex digit string, and as of MariaDB\n5.5, is a nonbinary string in the connection character set\nand collation, determined by the values of the\ncharacter_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n \nNULL is returned if the argument was NULL. \n \nExamples\n-------- \nSELECT MD5(\'testing\');\n+----------------------------------+\n| MD5(\'testing\') |\n+----------------------------------+\n| ae2b1fca515949e5d54fb22b8ed95575 |\n+----------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/md5/','','https://mariadb.com/kb/en/library/md5/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (144,12,'OLD_PASSWORD','Syntax\n------ \nOLD_PASSWORD(str)\n \nDescription\n----------- \nOLD_PASSWORD() was added to MySQL when the implementation of\n\nPASSWORD() was changed to improve security. OLD_PASSWORD()\nreturns the\nvalue of the old (pre-MySQL 4.1) implementation of\nPASSWORD() as a\nstring, and is intended to permit you to reset passwords for\nany\npre-4.1 clients that need to connect to a more recent MySQL\nserver version, or any version of MariaDB,\nwithout locking them out.\n \nAs of MariaDB 5.5, the return value is a nonbinary string in\nthe connection character set and collation, determined by\nthe values of the character_set_connection and\ncollation_connection system variables. Before 5.5, the\nreturn value was a binary string.\n \nThe return value is 16 bytes in length, or NULL if the\nargument was NULL.\n \n\n\nURL: https://mariadb.com/kb/en/library/old_password/','','https://mariadb.com/kb/en/library/old_password/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (145,12,'PASSWORD','Syntax\n------ \nPASSWORD(str)\n \nDescription\n----------- \nThe PASSWORD() function is used for hashing passwords for\nuse in authentication by the MariaDB server. It is not\nintended for use in other applications.\n \nCalculates and returns a hashed password string from the\nplaintext password str. Returns an empty string (>= MariaDB\n10.0.4) or NULL (\n\nURL: https://mariadb.com/kb/en/library/password/','','https://mariadb.com/kb/en/library/password/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (146,12,'SHA1','Syntax\n------ \nSHA1(str), SHA(str)\n \nDescription\n----------- \nCalculates an SHA-1 160-bit checksum for the string str, as\ndescribed in\nRFC 3174 (Secure Hash Algorithm).\n \nThe value is returned as a string of 40 hex digits, or NULL\nif the argument was NULL. As of MariaDB 5.5, the return\nvalue is a nonbinary string in the connection character set\nand collation, determined by the values of the\ncharacter_set_connection and collation_connection system\nvariables. Before 5.5, the return value was a binary string.\n \nExamples\n-------- \nSELECT SHA1(\'some boring text\');\n+------------------------------------------+\n| SHA1(\'some boring text\') |\n+------------------------------------------+\n| af969fc2085b1bb6d31e517d5c456def5cdd7093 |\n+------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/sha1/','','https://mariadb.com/kb/en/library/sha1/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (147,12,'SHA2','SHA2() was introduced in MariaDB 5.5\n \nSyntax\n------ \nSHA2(str,hash_len)\n \nDescription\n----------- \nGiven a string str, calculates an SHA-2 checksum, which is\nconsidered more cryptographically secure than its SHA-1\nequivalent. The SHA-2 family includes SHA-224, SHA-256,\nSHA-384, and SHA-512, and the hash_len must correspond to\none of these, i.e. 224, 256, 384 or 512. 0 is equivalent to\n256.\n \nThe return value is a nonbinary string in the connection\ncharacter set and collation, determined by the values of the\ncharacter_set_connection and collation_connection system\nvariables. \n \nNULL is returned if the hash length is not valid, or the\nstring str is NULL.\n \nSHA2 will only work if MariaDB was has been configured with\nTLS support. \n \nExamples\n-------- \nSELECT SHA2(\'Maria\',224);\n+----------------------------------------------------------+\n| SHA2(\'Maria\',224) |\n+----------------------------------------------------------+\n| 6cc67add32286412efcab9d0e1675a43a5c2ef3cec8879f81516ff83 |\n+----------------------------------------------------------+\n \nSELECT SHA2(\'Maria\',256);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',256) |\n+------------------------------------------------------------------+\n|\n9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16\n|\n+------------------------------------------------------------------+\n \nSELECT SHA2(\'Maria\',0);\n+------------------------------------------------------------------+\n| SHA2(\'Maria\',0) |\n+------------------------------------------------------------------+\n|\n9ff18ebe7449349f358e3af0b57cf7a032c1c6b2272cb2656ff85eb112232f16\n|\n+------------------------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/sha2/','','https://mariadb.com/kb/en/library/sha2/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (148,12,'UNCOMPRESS','Syntax\n------ \nUNCOMPRESS(string_to_uncompress)\n \nDescription\n----------- \nUncompresses a string compressed by the COMPRESS() function.\nIf the\nargument is not a compressed value, the result is NULL. This\nfunction\nrequires MariaDB to have been compiled with a compression\nlibrary such\nas zlib. Otherwise, the return value is always NULL. The\nhave_compress server system variable indicates whether a\ncompression library is present. \n \nExamples\n-------- \nSELECT UNCOMPRESS(COMPRESS(\'a string\'));\n+----------------------------------+\n| UNCOMPRESS(COMPRESS(\'a string\')) |\n+----------------------------------+\n| a string |\n+----------------------------------+\n \nSELECT UNCOMPRESS(\'a string\');\n+------------------------+\n| UNCOMPRESS(\'a string\') |\n+------------------------+\n| NULL |\n+------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/uncompress/','','https://mariadb.com/kb/en/library/uncompress/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (149,12,'UNCOMPRESSED_LENGTH','Syntax\n------ \nUNCOMPRESSED_LENGTH(compressed_string)\n \nDescription\n----------- \nReturns the length that the compressed string had before\nbeing\ncompressed with COMPRESS().\n \nUNCOMPRESSED_LENGTH() returns NULL or an incorrect result if\nthe string is not compressed.\n \nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or\nbigint(10), in all cases. From MariaDB 10.3.1, returns\nMYSQL_TYPE_LONG, or int(10), when the result would fit\nwithin 32-bits.\n \nExamples\n-------- \nSELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n+-----------------------------------------------+\n| UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30))) |\n+-----------------------------------------------+\n| 30 |\n+-----------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/uncompressed_length/','','https://mariadb.com/kb/en/library/uncompressed_length/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (150,13,'ENDPOINT','A synonym for ST_ENDPOINT.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/linestring-properties-endpoint/','','https://mariadb.com/kb/en/library/linestring-properties-endpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (151,13,'GLENGTH','Syntax\n------ \nGLength(ls)\n \nDescription\n----------- \nReturns as a double-precision number the length of the\nLineString value ls in its associated spatial reference.\n \nExamples\n-------- \nSET @ls = \'LineString(1 1,2 2,3 3)\';\n \nSELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n| 2.82842712474619 |\n+----------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/glength/','','https://mariadb.com/kb/en/library/glength/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (152,13,'NumPoints','A synonym for ST_NumPoints.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/linestring-properties-numpoints/','','https://mariadb.com/kb/en/library/linestring-properties-numpoints/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (153,13,'PointN','A synonym for ST_PointN.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/linestring-properties-pointn/','','https://mariadb.com/kb/en/library/linestring-properties-pointn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (154,13,'STARTPOINT','A synonym for ST_STARTPOINT.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/linestring-properties-startpoint/','','https://mariadb.com/kb/en/library/linestring-properties-startpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (155,13,'ST_ENDPOINT','Syntax\n------ \nST_EndPoint(ls)\nEndPoint(ls)\n \nDescription\n----------- \nReturns the Point that is the endpoint of the\nLineString value ls.\n \nST_EndPoint() and EndPoint() are synonyms.\n \nExamples\n-------- \nSET @ls = \'LineString(1 1,2 2,3 3)\';\n \nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3) |\n+-------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_endpoint/','','https://mariadb.com/kb/en/library/st_endpoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (156,13,'ST_NUMPOINTS','Syntax\n------ \nST_NumPoints(ls)\nNumPoints(ls)\n \nDescription\n----------- \nReturns the number of Point objects in the LineString\nvalue ls.\n \nST_NumPoints() and NumPoints() are synonyms.\n \nExamples\n-------- \nSET @ls = \'LineString(1 1,2 2,3 3)\';\n \nSELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n| 3 |\n+------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_numpoints/','','https://mariadb.com/kb/en/library/st_numpoints/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (157,13,'ST_POINTN','Syntax\n------ \nST_PointN(ls,N)\nPointN(ls,N)\n \nDescription\n----------- \nReturns the N-th Point in the LineString value ls.\nPoints are numbered beginning with 1.\n \nST_PointN() and PointN() are synonyms.\n \nExamples\n-------- \nSET @ls = \'LineString(1 1,2 2,3 3)\';\n \nSELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2) |\n+-------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_pointn/','','https://mariadb.com/kb/en/library/st_pointn/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (158,14,'GET_LOCK','Syntax\n------ \nGET_LOCK(str,timeout)\n \nDescription\n----------- \nTries to obtain a lock with a name given by the string str,\nusing a timeout of timeout seconds. Returns 1 if the lock\nwas obtained successfully, 0 if the attempt timed out (for\nexample, because another client has previously locked the\nname), or NULL if an error occurred (such as running out of\nmemory or the thread was killed with mysqladmin kill).\n \nA lock is released with RELEASE_LOCK(), when the connection\nterminates (either normally or abnormally), or before\nMariaDB 10.0.2, when the connection executes another\nGET_LOCK statement. From MariaDB 10.0.2, a connection can\nhold multiple locks at the same time, so a lock that is no\nlonger needed needs to be explicitly released.\n \nThe IS_FREE_LOCK function returns whether a specified lock a\nfree or not, and the IS_USED_LOCK whether the function is in\nuse or not.\n \nLocks obtained with GET_LOCK() do not interact with\ntransactions. That is, committing a transaction does not\nrelease any such locks obtained during the transaction.\n \nFrom MariaDB 10.0.2, it is also possible to recursively set\nthe same lock. If a lock with the same name is set n times,\nit needs to be released n times as well. \n \nstr is case insensitive for GET_LOCK() and related\nfunctions. If str is an empty string or NULL, GET_LOCK()\nreturns NULL and does nothing. From MariaDB 10.2.2, timeout\nsupports microseconds. Before then, it was rounded to the\nclosest integer.\n \nIf the metadata_lock_info plugin is installed, locks\nacquired with this function are visible in the Information\nSchema METADATA_LOCK_INFO table.\n \nThis function can be used to implement application locks or\nto simulate record locks. Names are locked on a server-wide\nbasis. If a name has been locked by one client, GET_LOCK()\nblocks any request by another client for a lock with the\nsame name. This allows clients that agree on a given lock\nname to use the name to perform cooperative advisory\nlocking. But be aware that it also allows a client that is\nnot among the set of cooperating clients to lock a name,\neither inadvertently or deliberately, and thus prevent any\nof the cooperating clients from locking that name. One way\nto reduce the likelihood of this is to use lock names that\nare database-specific or application-specific. For example,\nuse lock names of the form db_name.str or app_name.str.\n \nStatements using the GET_LOCK() function are not safe for\nreplication.\n \nThe patch to permit multiple locks was contributed by\nKonstantin \"Kostja\" Osipov (MDEV-3917).\n \nExamples\n-------- \nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT IS_FREE_LOCK(\'lock1\'), IS_USED_LOCK(\'lock1\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_USED_LOCK(\'lock1\') |\n+-----------------------+-----------------------+\n| 0 | 46 |\n+-----------------------+-----------------------+\n \nSELECT IS_FREE_LOCK(\'lock2\'), IS_USED_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock2\') | IS_USED_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n| 1 | NULL |\n+-----------------------+-----------------------+\n \nFrom MariaDB 10.0.2, multiple locks can be held:\n \nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n| 0 | 0 |\n+-----------------------+-----------------------+\n \nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n| 1 | 1 |\n+-----------------------+-----------------------+\n \nBefore MariaDB 10.0.2, a connection could only hold a single\nlock:\n \nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT IS_FREE_LOCK(\'lock1\'), IS_FREE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| IS_FREE_LOCK(\'lock1\') | IS_FREE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n| 1 | 0 |\n+-----------------------+-----------------------+\n \nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\');\n+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\n+-----------------------+-----------------------+\n| NULL | 1 |\n+-----------------------+-----------------------+\n \nFrom MariaDB 10.0.2, it is possible to hold the same lock\nrecursively. This example is viewed using the\nmetadata_lock_info plugin:\n \nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n \n+-----------+---------------------+---------------+-----------+--------------+------------+\n| THREAD_ID | LOCK_MODE | LOCK_DURATION | LOCK_TYPE |\nTABLE_SCHEMA | TABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n| 46 | MDL_SHARED_NO_WRITE | NULL | User lock | lock3 | |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n \nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n| 1 |\n+-----------------------+\n \nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n \n+-----------+---------------------+---------------+-----------+--------------+------------+\n| THREAD_ID | LOCK_MODE | LOCK_DURATION | LOCK_TYPE |\nTABLE_SCHEMA | TABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n| 46 | MDL_SHARED_NO_WRITE | NULL | User lock | lock3 | |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n \nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n| 1 |\n+-----------------------+\n \nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n \nEmpty set (0.000 sec)\n \nTimeout example: Connection 1:\n \nSELECT GET_LOCK(\'lock4\',10);\n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nConnection 2:\n \nSELECT GET_LOCK(\'lock4\',10);\n \nAfter 10 seconds...\n \n+----------------------+\n| GET_LOCK(\'lock4\',10) |\n+----------------------+\n| 0 |\n+----------------------+\n \nDeadlocks are automatically detected and resolved.\nConnection 1:\n \nSELECT GET_LOCK(\'lock5\',10); \n+----------------------+\n| GET_LOCK(\'lock5\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nConnection 2:\n \nSELECT GET_LOCK(\'lock6\',10);\n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nConnection 1:\n \nSELECT GET_LOCK(\'lock6\',10); \n+----------------------+\n| GET_LOCK(\'lock6\',10) |\n+----------------------+\n| 0 |\n+----------------------+\n \nConnection 2:\n \nSELECT GET_LOCK(\'lock5\',10);\nERROR 1213 (40001): Deadlock found when trying to get lock;\n try restarting transaction\n \n\n\nURL: https://mariadb.com/kb/en/library/get_lock/','','https://mariadb.com/kb/en/library/get_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (159,14,'INET6_ATON','INET6_ATON() has been available since MariaDB 10.0.12.\n \nSyntax\n------ \nINET6_ATON(expr)\n \nDescription\n----------- \nGiven an IPv6 or IPv4 network address as a string, returns a\nbinary string that represents the numeric value of the\naddress.\n \nNo trailing zone ID\'s or traling network masks are\npermitted. For IPv4 addresses, or IPv6 addresses with IPv4\naddress parts, no classful addresses or trailing port\nnumbers are permitted and octal numbers are not supported.\n \nThe returned binary string will be VARBINARY(16) or\nVARBINARY(4) for IPv6 and IPv4 addresses respectively.\n \nReturns NULL if the argument is not understood.\n \nExamples\n-------- \nSELECT HEX(INET6_ATON(\'10.0.1.1\'));\n+-----------------------------+\n| HEX(INET6_ATON(\'10.0.1.1\')) |\n+-----------------------------+\n| 0A000101 |\n+-----------------------------+\n \nSELECT HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\'));\n+----------------------------------------------+\n| HEX(INET6_ATON(\'48f3::d432:1431:ba23:846f\')) |\n+----------------------------------------------+\n| 48F3000000000000D4321431BA23846F |\n+----------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/inet6_aton/','','https://mariadb.com/kb/en/library/inet6_aton/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (160,14,'INET6_NTOA','INET6_NTOA() has been available from MariaDB 10.0.12.\n \nSyntax\n------ \nINET6_NTOA(expr)\n \nDescription\n----------- \nGiven an IPv6 or IPv4 network address as a numeric binary\nstring, returns the address as a nonbinary string in the\nconnection character set.\n \nThe return string is lowercase, and is platform independent,\nsince it does not use functions specific to the operating\nsystem. It has a maximum length of 39 characters.\n \nReturns NULL if the argument is not understood.\n \nExamples\n-------- \nSELECT INET6_NTOA(UNHEX(\'0A000101\'));\n+-------------------------------+\n| INET6_NTOA(UNHEX(\'0A000101\')) |\n+-------------------------------+\n| 10.0.1.1 |\n+-------------------------------+\n \nSELECT\nINET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\'));\n+-------------------------------------------------------+\n| INET6_NTOA(UNHEX(\'48F3000000000000D4321431BA23846F\')) |\n+-------------------------------------------------------+\n| 48f3::d432:1431:ba23:846f |\n+-------------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/inet6_ntoa/','','https://mariadb.com/kb/en/library/inet6_ntoa/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (161,14,'INET_ATON','Syntax\n------ \nINET_ATON(expr)\n \nDescription\n----------- \nGiven the dotted-quad representation of an IPv4 network\naddress as a string,\nreturns an integer that represents the numeric value of the\naddress.\nAddresses may be 4- or 8-byte addresses.\n \nReturns NULL if the argument is not understood.\n \nExamples\n-------- \nSELECT INET_ATON(\'192.168.1.1\');\n+--------------------------+\n| INET_ATON(\'192.168.1.1\') |\n+--------------------------+\n| 3232235777 |\n+--------------------------+\n \nThis is calculated as follows: 192 x 2563 + 168 x 256 2 + 1\nx 256 + 1\n \n\n\nURL: https://mariadb.com/kb/en/library/inet_aton/','','https://mariadb.com/kb/en/library/inet_aton/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (162,14,'INET_NTOA','Syntax\n------ \nINET_NTOA(expr)\n \nDescription\n----------- \nGiven a numeric IPv4 network address in network byte order\n(4 or 8 byte),\nreturns the dotted-quad representation of the address as a\nstring.\n \nExamples\n-------- \nSELECT INET_NTOA(3232235777);\n+-----------------------+\n| INET_NTOA(3232235777) |\n+-----------------------+\n| 192.168.1.1 |\n+-----------------------+\n \n192.168.1.1 corresponds to 3232235777 since 192 x 2563 + 168\nx 256 2 + 1 x 256 + 1 = 3232235777\n \n\n\nURL: https://mariadb.com/kb/en/library/inet_ntoa/','','https://mariadb.com/kb/en/library/inet_ntoa/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (163,14,'IS_FREE_LOCK','Syntax\n------ \nIS_FREE_LOCK(str)\n \nDescription\n----------- \nChecks whether the lock named str is free to use (that is,\nnot locked).\nReturns 1 if the lock is free (no one is using the lock),\n 0 if the lock is in use, and NULL if an\nerror occurs (such as an incorrect argument, like an empty\nstring or NULL). str is case insensitive.\n \nIf the metadata_lock_info plugin is installed, the\nInformation Schema metadata_lock_info table contains\ninformation about locks of this kind (as well as metadata\nlocks).\n \nStatements using the IS_FREE_LOCK() function are not safe\nfor replication.\n \n\n\nURL: https://mariadb.com/kb/en/library/is_free_lock/','','https://mariadb.com/kb/en/library/is_free_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (164,14,'IS_IPV4','IS_IPV4() has been available since MariaDB 10.0.12.\n \nSyntax\n------ \nIS_IPV4(expr)\n \nDescription\n----------- \nIf the expression is a valid IPv4 address, returns 1,\notherwise returns 0.\n \nIS_IPV4() is stricter than INET_ATON(), but as strict as\nINET6_ATON(), in determining the validity of an IPv4\naddress. This implies that if IS_IPV4 returns 1, the same\nexpression will always return a non-NULL result when passed\nto INET_ATON(), but that the reverse may not apply.\n \nExamples\n-------- \nSELECT IS_IPV4(\'1110.0.1.1\');\n+-----------------------+\n| IS_IPV4(\'1110.0.1.1\') |\n+-----------------------+\n| 0 |\n+-----------------------+\n \nSELECT IS_IPV4(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV4(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n| 0 |\n+--------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/is_ipv4/','','https://mariadb.com/kb/en/library/is_ipv4/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (165,14,'IS_IPV4_COMPAT','IS_IPV4_COMPAT() has been available since MariaDB 10.0.12.\n \nSyntax\n------ \nIS_IPV4_COMPAT(expr)\n \nDescription\n----------- \nReturns 1 if a given numeric binary string IPv6 address,\nsuch as returned by INET6_ATON(), is IPv4-compatible,\notherwise returns 0. \n \nExamples\n-------- \nSELECT IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_COMPAT(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n| 1 |\n+------------------------------------------+\n \nSELECT\nIS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'));\n+-----------------------------------------------------------+\n|\nIS_IPV4_COMPAT(INET6_ATON(\'::48f3::d432:1431:ba23:846f\'))\n|\n+-----------------------------------------------------------+\n| 0 |\n+-----------------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/is_ipv4_compat/','','https://mariadb.com/kb/en/library/is_ipv4_compat/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (166,14,'IS_IPV4_MAPPED','IS_IPV4_MAPPED() has been available since MariaDB 10.0.12.\n \nSyntax\n------ \nIS_IPV4_MAPPED(expr)\n \nDescription\n----------- \nReturns 1 if a given a numeric binary string IPv6 address,\nsuch as returned by INET6_ATON(), is a valid IPv4-mapped\naddress, otherwise returns 0.\n \nExamples\n-------- \nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\'));\n+------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::10.0.1.1\')) |\n+------------------------------------------+\n| 0 |\n+------------------------------------------+\n \nSELECT IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\'));\n+-----------------------------------------------+\n| IS_IPV4_MAPPED(INET6_ATON(\'::ffff:10.0.1.1\')) |\n+-----------------------------------------------+\n| 1 |\n+-----------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/is_ipv4_mapped/','','https://mariadb.com/kb/en/library/is_ipv4_mapped/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (167,14,'IS_IPV6','IS_IPV6() has been available since MariaDB 10.0.12.\n \nSyntax\n------ \nIS_IPV6(expr)\n \nDescription\n----------- \nReturns 1 if the expression is a valid IPv6 address\nspecified as a string, otherwise returns 0. Does not\nconsider IPv4 addresses to be valid IPv6 addresses.\n \nExamples\n-------- \n SELECT IS_IPV6(\'48f3::d432:1431:ba23:846f\');\n+--------------------------------------+\n| IS_IPV6(\'48f3::d432:1431:ba23:846f\') |\n+--------------------------------------+\n| 1 |\n+--------------------------------------+\n1 row in set (0.02 sec)\n \nSELECT IS_IPV6(\'10.0.1.1\');\n+---------------------+\n| IS_IPV6(\'10.0.1.1\') |\n+---------------------+\n| 0 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/is_ipv6/','','https://mariadb.com/kb/en/library/is_ipv6/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (168,14,'IS_USED_LOCK','Syntax\n------ \nIS_USED_LOCK(str)\n \nDescription\n----------- \nChecks whether the lock named str is in use (that is,\nlocked). If so,\nit returns the connection identifier of the client that\nholds the\nlock. Otherwise, it returns NULL. str is case insensitive.\n \nIf the metadata_lock_info plugin is installed, the\nInformation Schema metadata_lock_info table contains\ninformation about locks of this kind (as well as metadata\nlocks).\n \nStatements using the IS_USED_LOCK() function are not safe\nfor replication.\n \n\n\nURL: https://mariadb.com/kb/en/library/is_used_lock/','','https://mariadb.com/kb/en/library/is_used_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (169,14,'MASTER_GTID_WAIT','MASTER_GTID_WAIT() was included in MariaDB 10.0.9.\n \nSyntax\n------ \nMASTER_GTID_WAIT(gtid-list[, timeout)\n \nDescription\n----------- \nThis function takes a string containing a comma-separated\nlist of global transaction id\'s\n(similar to the value of, for example, gtid_binlog_pos). It\nwaits until the value of gtid_slave_pos has the same or\nhigher seq_no within all replication domains specified in\nthe gtid-list; in other words, it waits until the slave has\nreached the specified GTID position.\n \nAn optional second argument gives a timeout in seconds. If\nthe timeout\nexpires before the specified GTID position is reached, then\nthe function\nreturns -1. Passing NULL or a negative number for the\ntimeout means no timeout, and the function will wait\nindefinitely.\n \n If the wait completes without a timeout, 0 is returned.\nPassing NULL for the\n gtid-list makes the function return NULL immediately,\nwithout waiting.\n \nThe gtid-list may be the empty string, in which case\nMASTER_GTID_WAIT()\nreturns immediately. If the gtid-list contains fewer domains\nthan\ngtid_slave_pos, then only those domains are waited upon. If\ngtid-list\ncontains a domain that is not present in @@gtid_slave_pos,\nthen\nMASTER_GTID_WAIT() will wait until an event containing such\ndomain_id arrives\non the slave (or until timed out or killed).\n \nMASTER_GTID_WAIT() can be useful to ensure that a slave has\ncaught up to\na master. Simply take the value of gtid_binlog_pos on the\nmaster, and use it in a MASTER_GTID_WAIT() call on the\nslave; when the call completes, the slave\nwill have caught up with that master position.\n \nMASTER_GTID_WAIT() can also be used in client applications\ntogether with the\nlast_gtid session variable. This is useful in a\nread-scaleout replication setup, where the application\nwrites to a single master but divides the\nreads out to a number of slaves to distribute the load. In\nsuch a setup, there\nis a risk that an application could first do an update on\nthe master, and then\na bit later do a read on a slave, and if the slave is not\nfast enough, the\ndata read from the slave might not include the update just\nmade, possibly\nconfusing the application and/or the end-user. One way to\navoid this is to\nrequest the value of last_gtid on the master just after the\nupdate. Then\nbefore doing the read on the slave, do a MASTER_GTID_WAIT()\non the value\nobtained from the master; this will ensure that the read is\nnot performed\nuntil the slave has replicated sufficiently far for the\nupdate to have become\nvisible.\n \nNote that MASTER_GTID_WAIT() can be used even if the slave\nis configured not\nto use GTID for connections (CHANGE MASTER TO\nmaster_use_gtid=no). This is\nbecause from MariaDB 10, GTIDs are always logged on the\nmaster server, and\nalways recorded on the slave servers.\n \nDifferences to MASTER_POS_WAIT()\n \nMASTER_GTID_WAIT() is global; it waits for any master\nconnection to reach\n the specified GTID position. MASTER_POS_WAIT() works only\nagainst a\n specific connection. This also means that while\nMASTER_POS_WAIT() aborts if\n its master connection is terminated with STOP SLAVE or due\nto an error,\n MASTER_GTID_WAIT() continues to wait while slaves are\nstopped.\n \nMASTER_GTID_WAIT() can take its timeout as a floating-point\nvalue, so a\n timeout in fractional seconds is supported, eg.\nMASTER_GTID_WAIT(\"0-1-100\",\n 0.5). (The minimum wait is one microsecond, 0.000001\nseconds).\n \nMASTER_GTID_WAIT() allows one to specify a timeout of zero\nin order to do a\n non-blocking check to see if the slaves have progressed to\na specific GTID position\n (MASTER_POS_WAIT() takes a zero timeout as meaning an\ninfinite wait). To do\n an infinite MASTER_GTID_WAIT(), specify a negative timeout,\nor omit the\n timeout argument.\n \nMASTER_GTID_WAIT() does not return the number of events\nexecuted since the\n wait started, nor does it return NULL if a slave thread is\nstopped. It\n always returns either 0 for successful wait completed, or\n-1 for timeout\n reached (or NULL if the specified gtid-pos is NULL).\n \nSince MASTER_GTID_WAIT() looks only at the seq_no part of\nthe GTIDs, not the\nserver_id, care is needed if a slave becomes diverged from\nanother server so\nthat two different GTIDs with the same seq_no (in the same\ndomain) arrive at\nthe same server. This situation is in any case best avoided;\nsetting\ngtid_strict_mode is recommended, as this will prevent any\nsuch out-of-order sequence numbers from ever being\nreplicated on a slave.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/master_gtid_wait/','','https://mariadb.com/kb/en/library/master_gtid_wait/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (170,14,'MASTER_POS_WAIT','MASTER_POS_WAIT was introduced in MariaDB 10.0.9.\n \nSyntax\n------ \nMASTER_POS_WAIT(log_name,log_pos[,timeout,[\"connection_name\"]])\n \nDescription\n----------- \nThis function is useful in replication for controlling\nmaster/slave synchronization. It blocks until the slave has\nread and applied all updates up to the specified position\n(log_name,log_pos) in the master log. The return value is\nthe number of log events the slave had to wait for to\nadvance to the specified position. The function returns NULL\nif\nthe slave SQL thread is not started, the slave\'s master\ninformation is not\ninitialized, the arguments are incorrect, or an error\noccurs. It returns -1 if\nthe timeout has been exceeded. If the slave SQL thread stops\nwhile\n MASTER_POS_WAIT() is waiting, the function returns NULL. If\nthe slave is past the specified position, the function\nreturns immediately.\n \nIf a timeout value is specified, MASTER_POS_WAIT() stops\nwaiting when timeout seconds have elapsed. timeout must be\ngreater than 0; a\nzero or negative timeout means no timeout.\n \nThe connection_name is used when you are using\nmulti-source-replication. If you don\'t specify it, it\'s\nset to the value of the default_master_connection system\nvariable.\n \nStatements using the MASTER_POS_WAIT() function are not safe\nfor replication.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/master_pos_wait/','','https://mariadb.com/kb/en/library/master_pos_wait/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (171,14,'NAME_CONST','Syntax\n------ \nNAME_CONST(name,value)\n \nDescription\n----------- \nReturns the given value. When used to produce a result set\ncolumn,\n NAME_CONST() causes the column to have the given name. The\narguments should be constants.\n \nThis function is used internally when replicating stored\nprocedures. It makes little sense to use it explicitly in\nSQL statements, and it was not supposed to be used like\nthat.\n \nSELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n| 14 |\n+--------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/name_const/','','https://mariadb.com/kb/en/library/name_const/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (172,14,'RELEASE_LOCK','Syntax\n------ \nRELEASE_LOCK(str)\n \nDescription\n----------- \nReleases the lock named by the string str that was obtained\nwith GET_LOCK(). Returns 1 if the lock was released, 0 if\nthe lock was not established by this thread (in which case\nthe lock is not\nreleased), and NULL if the named lock did not exist. The\nlock does not exist if it was never obtained by a call to\nGET_LOCK() or if it has previously been released.\n \nMariaDB until 10.0.1\n \nBefore 10.0.2, GET_LOCK() released the existing lock, if\nany. Since 10.0.2 this does not happen, because multiple\nlocks are allowed.\n \nstr is case insensitive. If str is an empty string or NULL,\nRELEASE_LOCK() returns NULL and does nothing.\n \nStatements using the RELEASE_LOCK() function are not safe\nfor replication.\n \nThe DO statement is convenient to use with RELEASE_LOCK().\n \nExamples\n-------- \nConnection1:\n \nSELECT GET_LOCK(\'lock1\',10);\n+----------------------+\n| GET_LOCK(\'lock1\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nConnection 2:\n \nSELECT GET_LOCK(\'lock2\',10);\n+----------------------+\n| GET_LOCK(\'lock2\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nConnection 1:\n \nSELECT RELEASE_LOCK(\'lock1\'), RELEASE_LOCK(\'lock2\'),\nRELEASE_LOCK(\'lock3\');\n+-----------------------+-----------------------+-----------------------+\n| RELEASE_LOCK(\'lock1\') | RELEASE_LOCK(\'lock2\') |\nRELEASE_LOCK(\'lock3\') |\n+-----------------------+-----------------------+-----------------------+\n| 1 | 0 | NULL |\n+-----------------------+-----------------------+-----------------------+\n \nFrom MariaDB 10.0.2, it is possible to hold the same lock\nrecursively. This example is viewed using the\nmetadata_lock_info plugin:\n \nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT GET_LOCK(\'lock3\',10);\n+----------------------+\n| GET_LOCK(\'lock3\',10) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n \n+-----------+---------------------+---------------+-----------+--------------+------------+\n| THREAD_ID | LOCK_MODE | LOCK_DURATION | LOCK_TYPE |\nTABLE_SCHEMA | TABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n| 46 | MDL_SHARED_NO_WRITE | NULL | User lock | lock3 | |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n \nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n| 1 |\n+-----------------------+\n \nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n \n+-----------+---------------------+---------------+-----------+--------------+------------+\n| THREAD_ID | LOCK_MODE | LOCK_DURATION | LOCK_TYPE |\nTABLE_SCHEMA | TABLE_NAME |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n| 46 | MDL_SHARED_NO_WRITE | NULL | User lock | lock3 | |\n+-----------+---------------------+---------------+-----------+--------------+------------+\n \nSELECT RELEASE_LOCK(\'lock3\');\n+-----------------------+\n| RELEASE_LOCK(\'lock3\') |\n+-----------------------+\n| 1 |\n+-----------------------+\n \nSELECT * FROM INFORMATION_SCHEMA.METADATA_LOCK_INFO;\n \nEmpty set (0.000 sec)\n \n\n\nURL: https://mariadb.com/kb/en/library/release_lock/','','https://mariadb.com/kb/en/library/release_lock/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (173,14,'SLEEP','Syntax\n------ \nSLEEP(duration)\n \nDescription\n----------- \nSleeps (pauses) for the number of seconds given by the\nduration argument, then\nreturns 0. If SLEEP() is interrupted, it\nreturns 1. The duration may have a fractional part given in\nmicroseconds.\n \nStatements using the SLEEP() function are not safe for\nreplication.\n \nExample\n \nSELECT SLEEP(5.5);\n+------------+\n| SLEEP(5.5) |\n+------------+\n| 0 |\n+------------+\n1 row in set (5.50 sec)\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/sleep/','','https://mariadb.com/kb/en/library/sleep/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (174,14,'UUID','Syntax\n------ \nUUID()\n \nDescription\n----------- \nReturns a Universal Unique Identifier (UUID) generated\naccording to \"DCE 1.1:\nRemote Procedure Call\" (Appendix A) CAE (Common\nApplications Environment)\nSpecifications published by The Open Group in October\n1997 \n(Document Number C706).\n \nA UUID is designed as a number that is globally unique in\nspace and time. Two\ncalls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate\ncomputers that are\nnot connected to each other.\n \nA UUID is a 128-bit number represented by a utf8 string of\nfive\nhexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee\nformat:\nThe first three numbers are generated from a timestamp.\nThe fourth number preserves temporal uniqueness in case the\ntimestamp value\n loses monotonicity (for example, due to daylight saving\ntime).\nThe fifth number is an IEEE 802 node number that provides\nspatial uniqueness.\n A random number is substituted if the latter is not\navailable (for example,\n because the host computer has no Ethernet card, or we do\nnot know how to find\n the hardware address of an interface on your operating\nsystem). In this case,\n spatial uniqueness cannot be guaranteed. Nevertheless, a\ncollision should\n have very low probability.\n \nCurrently, the MAC address of an interface is taken into\naccount only on FreeBSD and Linux. On other operating\nsystems, MariaDB uses a randomly generated 48-bit number.\n \nStatements using the UUID() function are not safe for\nreplication.\n \nUUID() results are intended to be unique, but cannot always\nbe relied upon to unpredictable and unguessable, so should\nnot be relied upon for these purposes.\n \nExamples\n-------- \nSELECT UUID();\n+--------------------------------------+\n| UUID() |\n+--------------------------------------+\n| cd41294a-afb0-11df-bc9b-00241dd75637 |\n+--------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/uuid/','','https://mariadb.com/kb/en/library/uuid/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (175,14,'UUID_SHORT','Syntax\n------ \nUUID_SHORT()\n \nDescription\n----------- \nReturns a \"short\" universal identifier as a 64-bit\nunsigned integer (rather\nthan a string-form 128-bit identifier as returned by the\nUUID() function).\n \nThe value of UUID_SHORT() is guaranteed to be unique if the\nfollowing conditions hold:\nThe server_id of the current host is unique among your set\nof master and\n slave servers\nserver_id is between 0 and 255\nYou don\'t set back your system time for your server between\nmysqld restarts\nYou do not invoke UUID_SHORT() on average more than 16\n million times per second between mysqld restarts\n \nThe UUID_SHORT() return value is constructed this way:\n \n (server_id & 255) \n\nURL: https://mariadb.com/kb/en/library/uuid_short/','','https://mariadb.com/kb/en/library/uuid_short/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (176,14,'VALUES / VALUE','Syntax\n------ \nVALUE(col_name) \n \nMariaDB until 10.3.2\n \nVALUES(col_name) \n \nDescription\n----------- \nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can\nuse the VALUES(col_name) function in the UPDATE clause to\nrefer to column values from the INSERT portion of the\nstatement. In other words, VALUES(col_name) in the UPDATE\nclause refers to the value of col_name that would be\ninserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts.\n \nThe VALUES() function is meaningful only in INSERT ... ON\nDUPLICATE KEY UPDATE statements and returns NULL otherwise.\n \nIn MariaDB 10.3.3 this function was renamed to VALUE(),\nbecause it\'s incompatible with the standard Table Value\nConstructors syntax, implemented in MariaDB 10.3.3.\n \nThe VALUES() function can still be used even from MariaDB\n10.3.3, but only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements; it\'s a syntax error otherwise.\n \nExamples\n-------- \nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n ON DUPLICATE KEY UPDATE c=VALUE(a)+VALUE(b);\n \nMariaDB until 10.3.2\n \nINSERT INTO t (a,b,c) VALUES (1,2,3),(4,5,6)\n ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/values-value/','','https://mariadb.com/kb/en/library/values-value/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (177,15,'!','Syntax\n------ \nNOT, !\n \nDescription\n----------- \nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the\noperand\nis non-zero, and NOT NULL returns NULL.\n \nBy default, the ! operator has a higher precedence. If the\nHIGH_NOT_PRECEDENCE SQL_MODE flag is set, NOT and ! have the\nsame precedence.\n \nExamples\n-------- \nSELECT NOT 10;\n \n+--------+\n| NOT 10 |\n+--------+\n| 0 |\n+--------+\n \nSELECT NOT 0;\n \n+-------+\n| NOT 0 |\n+-------+\n| 1 |\n+-------+\n \nSELECT NOT NULL;\n \n+----------+\n| NOT NULL |\n+----------+\n| NULL |\n+----------+\n \nSELECT ! (1+1);\n+---------+\n| ! (1+1) |\n+---------+\n| 0 |\n+---------+\n \nSELECT ! 1+1;\n \n+-------+\n| ! 1+1 |\n+-------+\n| 1 |\n+-------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/not/','','https://mariadb.com/kb/en/library/not/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (178,15,'&amp;&amp;','Syntax\n------ \nAND, &&\n \nDescription\n----------- \nLogical AND. Evaluates to 1 if all operands are non-zero and\nnot NULL,\nto 0 if one or more operands are 0, otherwise NULL is\nreturned.\n \nFor this operator, short-circuit evaluation can be used.\n \nExamples\n-------- \nSELECT 1 && 1;\n \n+--------+\n| 1 && 1 |\n+--------+\n| 1 |\n+--------+\n \nSELECT 1 && 0;\n \n+--------+\n| 1 && 0 |\n+--------+\n| 0 |\n+--------+\n \nSELECT 1 && NULL;\n \n+-----------+\n| 1 && NULL |\n+-----------+\n| NULL |\n+-----------+\n \nSELECT 0 && NULL;\n \n+-----------+\n| 0 && NULL |\n+-----------+\n| 0 |\n+-----------+\n \nSELECT NULL && 0;\n \n+-----------+\n| NULL && 0 |\n+-----------+\n| 0 |\n+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/and/','','https://mariadb.com/kb/en/library/and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (179,15,'||','Syntax\n------ \nOR, ||\n \nDescription\n----------- \nLogical OR. When both operands are non-NULL, the result is 1\nif any\noperand is non-zero, and 0 otherwise. With a NULL operand,\nthe result\nis 1 if the other operand is non-zero, and NULL otherwise.\nIf both\noperands are NULL, the result is NULL.\n \nFor this operator, short-circuit evaluation can be used.\n \nNote that, if the PIPES_AS_CONCAT SQL_MODE is set, || is\nused as a string concatenation operator. This means that a\n|| b is the same as CONCAT(a,b). See CONCAT() for details.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, || ignores NULL.\n \nExamples\n-------- \nSELECT 1 || 1;\n \n+--------+\n| 1 || 1 |\n+--------+\n| 1 |\n+--------+\n \nSELECT 1 || 0;\n \n+--------+\n| 1 || 0 |\n+--------+\n| 1 |\n+--------+\n \nSELECT 0 || 0;\n \n+--------+\n| 0 || 0 |\n+--------+\n| 0 |\n+--------+\n \nSELECT 0 || NULL;\n \n+-----------+\n| 0 || NULL |\n+-----------+\n| NULL |\n+-----------+\n \nSELECT 1 || NULL;\n \n+-----------+\n| 1 || NULL |\n+-----------+\n| 1 |\n+-----------+\n \nIn Oracle mode, from MariaDB 10.3:\n \nSELECT 0 || NULL;\n \n+-----------+\n| 0 || NULL |\n+-----------+\n| 0 |\n+-----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/or/','','https://mariadb.com/kb/en/library/or/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (180,15,'XOR','Syntax\n------ \nXOR\n \nDescription\n----------- \nXOR stands for eXclusive OR. Returns NULL if either operand\nis NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is\nnon-zero,\notherwise 0 is returned.\n \nExamples\n-------- \nSELECT 1 XOR 1;\n \n+---------+\n| 1 XOR 1 |\n+---------+\n| 0 |\n+---------+\n \nSELECT 1 XOR 0;\n \n+---------+\n| 1 XOR 0 |\n+---------+\n| 1 |\n+---------+\n \nSELECT 1 XOR NULL;\n \n+------------+\n| 1 XOR NULL |\n+------------+\n| NULL |\n+------------+\n \nIn the following example, the right 1 XOR 1 is evaluated\nfirst, and returns 0. Then, 1 XOR 0 is evaluated, and 1 is\nreturned.\n \nSELECT 1 XOR 1 XOR 1;\n \n+---------------+\n| 1 XOR 1 XOR 1 |\n+---------------+\n| 1 |\n+---------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/xor/','','https://mariadb.com/kb/en/library/xor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (181,15,'Assignment Operator (=)','Syntax\n------ \nidentifier = expr\n \nDescription\n----------- \nThe equal sign is used as both an assignment operator in\ncertain contexts, and as a comparison operator. When used as\nassignment operator, the value on the right is assigned to\nthe variable (or column, in some contexts) on the left.\n \nSince its use can be ambiguous, unlike the := assignment\noperator, the = assignment operator cannot be used in all\ncontexts, and is only valid as part of a SET statement, or\nthe SET clause of an UPDATE statement\n \nThis operator works with both user-defined variables and\nlocal variables.\n \nExamples\n-------- \nUPDATE table_name SET x = 2 WHERE x > 100;\n \nSET @x = 1, @y := 2;\n \n\n \n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/assignment-operators-assignment-operator/','','https://mariadb.com/kb/en/library/assignment-operators-assignment-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (182,15,'Assignment Operator (:=)','Syntax\n------ \nvar_name := expr\n \nDescription\n----------- \nAssignment operator for assigning a value. The value on the\nright is assigned to the variable on left.\n \nUnlike the = operator, := can always be used to assign a\nvalue to a variable.\n \nThis operator works with both user-defined variables and\nlocal variables.\n \nWhen assigning the same value to several variables,\nLAST_VALUE() can be useful.\n \nExamples\n-------- \n SELECT @x := 10;\n \n+----------+\n| @x := 10 |\n+----------+\n| 10 |\n+----------+\n \nSELECT @x, @y := @x;\n \n+------+----------+\n| @x | @y := @x |\n+------+----------+\n| 10 | 10 |\n+------+----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/assignment-operator/','','https://mariadb.com/kb/en/library/assignment-operator/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (183,16,'Stored Aggregate Functions','The ability to create stored aggregate functions was added\nin MariaDB 10.3.3.\n \nAggregate functions are functions that are computed over a\nsequence of rows and return one result for the sequence of\nrows.\n \nCreating a custom aggregate function is done using the\nCREATE FUNCTION statement with two main differences:\nThe addition of the AGGREGATE keyword, so CREATE AGGREGATE\nFUNCTION\nThe FETCH GROUP NEXT ROW instruction inside the loop\nOracle PL/SQL compatibility using SQL/PL is provided\n \nStandard Syntax\n \nCREATE AGGREGATE FUNCTION function_name (parameters) RETURNS\nreturn_type\nBEGIN\n All types of declarations\n DECLARE CONTINUE HANDLER FOR NOT FOUND RETURN return_val;\n LOOP\n FETCH GROUP NEXT ROW; // fetches next row from table\n other instructions\n END LOOP;\nEND\n \nStored aggregate functions were a 2016 Google Summer of Code\nproject by Varun Gupta.\n \nUsing SQL/PL\n \nSET sql_mode=Oracle;\nDELIMITER //\n \nCREATE AGGREGATE FUNCTION function_name (parameters) RETURN\nreturn_type\n declarations\nBEGIN\n LOOP\n FETCH GROUP NEXT ROW; -- fetches next row from table\n -- other instructions\n \n END LOOP;\nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n RETURN return_val;\nEND //\n \nDELIMITER ;\n \nExamples\n-------- \nFirst a simplified example:\n \nCREATE TABLE marks(stud_id INT, grade_count INT);\n \nINSERT INTO marks VALUES (1,6), (2,4), (3,7), (4,5), (5,8);\n \nSELECT * FROM marks;\n \n+---------+-------------+\n| stud_id | grade_count |\n+---------+-------------+\n| 1 | 6 |\n| 2 | 4 |\n| 3 | 7 |\n| 4 | 5 |\n| 5 | 8 |\n+---------+-------------+\n \nDELIMITER //\nCREATE AGGREGATE FUNCTION IF NOT EXISTS aggregate_count(x\nINT) RETURNS INT\nBEGIN\n DECLARE count_students INT DEFAULT 0;\n \n DECLARE CONTINUE HANDLER FOR NOT FOUND\n RETURN count_students;\n \n LOOP\n FETCH GROUP NEXT ROW;\n \n IF x THEN\n SET count_students = count_students+1;\n \n END IF;\n \n END LOOP;\n \nEND //\nDELIMITER ;\n \nA non-trivial example that cannot easily be rewritten using\nexisting functions:\n \nDELIMITER //\nCREATE AGGREGATE FUNCTION medi_int(x INT) RETURNS DOUBLE\nBEGIN\n DECLARE CONTINUE HANDLER FOR NOT FOUND\n BEGIN\n DECLARE res DOUBLE;\n \n DECLARE cnt INT DEFAULT (SELECT COUNT(*) FROM tt);\n DECLARE lim INT DEFAULT (cnt-1) DIV 2;\n \n IF cnt % 2 = 0 THEN\n SET res = (SELECT AVG(a) FROM (SELECT a FROM tt ORDER BY a\nLIMIT lim,2) ttt);\n ELSE\n SET res = (SELECT a FROM tt ORDER BY a LIMIT lim,1);\n END IF;\n \n DROP TEMPORARY TABLE tt;\n \n RETURN res;\n \n END;\n \n CREATE TEMPORARY TABLE tt (a INT);\n LOOP\n FETCH GROUP NEXT ROW;\n \n INSERT INTO tt VALUES (x);\n END LOOP;\n \nEND //\nDELIMITER ;\n \nSQL/PL Example\n \nThis uses the same marks table as created above.\n \nSET sql_mode=Oracle;\n \nDELIMITER //\n \nCREATE AGGREGATE FUNCTION aggregate_count(x INT) RETURN INT\nAS count_students INT DEFAULT 0;\n \nBEGIN\n LOOP\n FETCH GROUP NEXT ROW;\n \n IF x THEN\n SET count_students := count_students+1;\n \n END IF;\n \n END LOOP;\n \nEXCEPTION\n WHEN NO_DATA_FOUND THEN\n RETURN count_students;\n \nEND aggregate_count //\nDELIMITER ;\n \nSELECT aggregate_count(stud_id) FROM marks;\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/stored-aggregate-functions/','','https://mariadb.com/kb/en/library/stored-aggregate-functions/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (184,16,'AVG','Syntax\n------ \nAVG([DISTINCT] expr)\n \nDescription\n----------- \nReturns the average value of expr. The DISTINCT option can\nbe used to return the average of the distinct values of\nexpr. NULL values are ignored. It is an aggregate function,\nand so can be used with the GROUP BY clause.\n \nAVG() returns NULL if there were no matching rows.\n \nFrom MariaDB 10.2.0, AVG() can be used as a window function.\n \nExamples\n-------- \nCREATE TABLE sales (sales_value INT);\n \nINSERT INTO sales VALUES(10),(20),(20),(40);\n \nSELECT AVG(sales_value) FROM sales;\n \n+------------------+\n| AVG(sales_value) |\n+------------------+\n| 22.5000 |\n+------------------+\n \nSELECT AVG(DISTINCT(sales_value)) FROM sales;\n \n+----------------------------+\n| AVG(DISTINCT(sales_value)) |\n+----------------------------+\n| 23.3333 |\n+----------------------------+\n \nCommonly, AVG() is used with a GROUP BY clause:\n \nCREATE TABLE student (name CHAR(10), test CHAR(10), score\nTINYINT); \n \nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n \nSELECT name, AVG(score) FROM student GROUP BY name;\n \n+---------+------------+\n| name | AVG(score) |\n+---------+------------+\n| Chun | 74.0000 |\n| Esben | 37.0000 |\n| Kaolin | 72.0000 |\n| Tatiana | 85.0000 |\n+---------+------------+\n \nBe careful to avoid this common mistake, not grouping\ncorrectly and returning mismatched data: \n \nSELECT name,test,AVG(score) FROM student;\n \n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL | 31 |\n+------+------+------------+\n \nAs a window function:\n \nCREATE TABLE student_test (name CHAR(10), test CHAR(10),\nscore TINYINT); \n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n \nSELECT name, test, score, AVG(score) OVER (PARTITION BY\ntest) \n AS average_by_test FROM student_test;\n \n+---------+--------+-------+-----------------+\n| name | test | score | average_by_test |\n+---------+--------+-------+-----------------+\n| Chun | SQL | 75 | 65.2500 |\n| Chun | Tuning | 73 | 68.7500 |\n| Esben | SQL | 43 | 65.2500 |\n| Esben | Tuning | 31 | 68.7500 |\n| Kaolin | SQL | 56 | 65.2500 |\n| Kaolin | Tuning | 88 | 68.7500 |\n| Tatiana | SQL | 87 | 65.2500 |\n| Tatiana | Tuning | 83 | 68.7500 |\n+---------+--------+-------+-----------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/avg/','','https://mariadb.com/kb/en/library/avg/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (185,16,'BIT_AND','Syntax\n------ \nBIT_AND(expr)\n \nDescription\n----------- \nReturns the bitwise AND of all bits in expr. The calculation\nis performed with 64-bit (BIGINT) precision. It is an\naggregate function, and so can be used with the GROUP BY\nclause.\n \nFrom MariaDB 10.2.0, BIT_AND() can be used as a window\nfunction.\n \nExamples\n-------- \nCREATE TABLE vals (x INT);\n \nINSERT INTO vals VALUES(111),(110),(100);\n \nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n \n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n| 100 | 111 | 101 |\n+------------+-----------+------------+\n \nAs an aggregate function:\n \nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n \nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n \nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n \n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a | 100 | 111 | 101 |\n| b | 0 | 11 | 10 |\n+----------+------------+-----------+------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/bit_and/','','https://mariadb.com/kb/en/library/bit_and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (186,16,'BIT_OR','Syntax\n------ \nBIT_OR(expr)\n \nDescription\n----------- \nReturns the bitwise OR of all bits in expr. The calculation\nis performed with 64-bit (BIGINT) precision. It is an\naggregate function, and so can be used with the GROUP BY\nclause.\n \nFrom MariaDB 10.2.0, BIT_OR can be used as a window\nfunction.\n \nExamples\n-------- \nCREATE TABLE vals (x INT);\n \nINSERT INTO vals VALUES(111),(110),(100);\n \nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n \n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n| 100 | 111 | 101 |\n+------------+-----------+------------+\n \nAs an aggregate function:\n \nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n \nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n \nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n \n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a | 100 | 111 | 101 |\n| b | 0 | 11 | 10 |\n+----------+------------+-----------+------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/bit_or/','','https://mariadb.com/kb/en/library/bit_or/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (187,16,'BIT_XOR','Syntax\n------ \nBIT_XOR(expr)\n \nDescription\n----------- \nReturns the bitwise XOR of all bits in expr. The calculation\nis performed with 64-bit (BIGINT) precision. It is an\naggregate function, and so can be used with the GROUP BY\nclause.\n \nFrom MariaDB 10.2.0, BIT_XOR() can be used as a window\nfunction.\n \nExamples\n-------- \nCREATE TABLE vals (x INT);\n \nINSERT INTO vals VALUES(111),(110),(100);\n \nSELECT BIT_AND(x), BIT_OR(x), BIT_XOR(x) FROM vals;\n \n+------------+-----------+------------+\n| BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+------------+-----------+------------+\n| 100 | 111 | 101 |\n+------------+-----------+------------+\n \nAs an aggregate function:\n \nCREATE TABLE vals2 (category VARCHAR(1), x INT);\n \nINSERT INTO vals2 VALUES\n (\'a\',111),(\'a\',110),(\'a\',100),\n (\'b\',\'000\'),(\'b\',001),(\'b\',011);\n \nSELECT category, BIT_AND(x), BIT_OR(x), BIT_XOR(x) \n FROM vals GROUP BY category;\n \n+----------+------------+-----------+------------+\n| category | BIT_AND(x) | BIT_OR(x) | BIT_XOR(x) |\n+----------+------------+-----------+------------+\n| a | 100 | 111 | 101 |\n| b | 0 | 11 | 10 |\n+----------+------------+-----------+------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/bit_xor/','','https://mariadb.com/kb/en/library/bit_xor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (188,16,'COUNT','Syntax\n------ \nCOUNT(expr)\n \nDescription\n----------- \nReturns a count of the number of non-NULL values of expr in\nthe rows retrieved by a SELECT statement. The result is a\nBIGINT value. It is an aggregate function, and so can be\nused with the GROUP BY clause.\n \nCOUNT(*) counts the total number of rows in a table.\n \nCOUNT() returns 0 if there were no matching rows.\n \nFrom MariaDB 10.2.0, COUNT() can be used as a window\nfunction.\n \nExamples\n-------- \nCREATE TABLE student (name CHAR(10), test CHAR(10), score\nTINYINT); \n \nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n \nSELECT COUNT(*) FROM student;\n \n+----------+\n| COUNT(*) |\n+----------+\n| 8 |\n+----------+\n \nCOUNT(DISTINCT) example:\n \nSELECT COUNT(DISTINCT (name)) FROM student;\n \n+------------------------+\n| COUNT(DISTINCT (name)) |\n+------------------------+\n| 4 |\n+------------------------+\n \nAs a window function\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, COUNT(score) OVER (PARTITION BY\nname) \n AS tests_written FROM student_test;\n \n+---------+--------+-------+---------------+\n| name | test | score | tests_written |\n+---------+--------+-------+---------------+\n| Chun | SQL | 75 | 2 |\n| Chun | Tuning | 73 | 2 |\n| Esben | SQL | 43 | 2 |\n| Esben | Tuning | 31 | 2 |\n| Kaolin | SQL | 56 | 2 |\n| Kaolin | Tuning | 88 | 2 |\n| Tatiana | SQL | 87 | 1 |\n+---------+--------+-------+---------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/count/','','https://mariadb.com/kb/en/library/count/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (189,16,'GROUP_CONCAT','Syntax\n------ \nGROUP_CONCAT(expr)\n \nDescription\n----------- \nThis function returns a string result with the concatenated\nnon-NULL\nvalues from a group. It returns NULL if there are no\nnon-NULL values.\n \nThe maximum returned length in bytes is determined by the\ngroup_concat_max_len server system variable, which defaults\nto 1M (>= MariaDB 10.2.4) or 1K (\n\nURL: https://mariadb.com/kb/en/library/group_concat/','','https://mariadb.com/kb/en/library/group_concat/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (190,16,'MAX','Syntax\n------ \nMAX([DISTINCT] expr)\n \nDescription\n----------- \nReturns the largest, or maximum, value of expr. MAX() can\nalso take a string\nargument in which case it returns the maximum string value.\nThe DISTINCT\nkeyword can be used to find the maximum of the distinct\nvalues of expr,\nhowever, this produces the same result as omitting DISTINCT.\n \nNote that SET and ENUM fields are currently compared by\ntheir string value rather than their relative position in\nthe set, so MAX() may produce a different highest result\nthan ORDER BY DESC.\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, MAX() can be used as a window function.\n \nMAX() returns NULL if there were no matching rows.\n \nExamples\n-------- \nCREATE TABLE student (name CHAR(10), test CHAR(10), score\nTINYINT); \n \nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n \nSELECT name, MAX(score) FROM student GROUP BY name;\n \n+---------+------------+\n| name | MAX(score) |\n+---------+------------+\n| Chun | 75 |\n| Esben | 43 |\n| Kaolin | 88 |\n| Tatiana | 87 |\n+---------+------------+\n \nMAX string:\n \nSELECT MAX(name) FROM student;\n \n+-----------+\n| MAX(name) |\n+-----------+\n| Tatiana |\n+-----------+\n \nBe careful to avoid this common mistake, not grouping\ncorrectly and returning mismatched data: \n \nSELECT name,test,MAX(SCORE) FROM student;\n \n+------+------+------------+\n| name | test | MAX(SCORE) |\n+------+------+------------+\n| Chun | SQL | 88 |\n+------+------+------------+\n \nDifference between ORDER BY DESC and MAX():\n \nCREATE TABLE student2(name CHAR(10),grade\nENUM(\'b\',\'c\',\'a\'));\n \nINSERT INTO student2\nVALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n \nSELECT MAX(grade) FROM student2;\n \n+------------+\n| MAX(grade) |\n+------------+\n| c |\n+------------+\n \nSELECT grade FROM student2 ORDER BY grade DESC LIMIT 1;\n \n+-------+\n| grade |\n+-------+\n| a |\n+-------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, MAX(score) \n OVER (PARTITION BY name) AS highest_score FROM\nstudent_test;\n \n+---------+--------+-------+---------------+\n| name | test | score | highest_score |\n+---------+--------+-------+---------------+\n| Chun | SQL | 75 | 75 |\n| Chun | Tuning | 73 | 75 |\n| Esben | SQL | 43 | 43 |\n| Esben | Tuning | 31 | 43 |\n| Kaolin | SQL | 56 | 88 |\n| Kaolin | Tuning | 88 | 88 |\n| Tatiana | SQL | 87 | 87 |\n+---------+--------+-------+---------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/max/','','https://mariadb.com/kb/en/library/max/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (191,16,'MIN','Syntax\n------ \nMIN([DISTINCT] expr)\n \nDescription\n----------- \nReturns the minimum value of expr. MIN() may take a string\nargument, in which case it returns the minimum string value.\nThe DISTINCT\nkeyword can be used to find the minimum of the distinct\nvalues of expr,\nhowever, this produces the same result as omitting DISTINCT.\n \nNote that SET and ENUM fields are currently compared by\ntheir string value rather than their relative position in\nthe set, so MIN() may produce a different lowest result than\nORDER BY ASC.\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, MIN() can be used as a window function.\n \nMIN() returns NULL if there were no matching rows.\n \nExamples\n-------- \nCREATE TABLE student (name CHAR(10), test CHAR(10), score\nTINYINT); \n \nINSERT INTO student VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87), (\'Tatiana\', \'Tuning\', 83);\n \nSELECT name, MIN(score) FROM student GROUP BY name;\n \n+---------+------------+\n| name | MIN(score) |\n+---------+------------+\n| Chun | 73 |\n| Esben | 31 |\n| Kaolin | 56 |\n| Tatiana | 83 |\n+---------+------------+\n \nMIN() with a string:\n \nSELECT MIN(name) FROM student;\n \n+-----------+\n| MIN(name) |\n+-----------+\n| Chun |\n+-----------+\n \nBe careful to avoid this common mistake, not grouping\ncorrectly and returning mismatched data: \n \nSELECT name,test,MIN(score) FROM student;\n \n+------+------+------------+\n| name | test | MIN(score) |\n+------+------+------------+\n| Chun | SQL | 31 |\n+------+------+------------+\n \nDifference between ORDER BY ASC and MIN():\n \nCREATE TABLE student2(name CHAR(10),grade\nENUM(\'b\',\'c\',\'a\'));\n \nINSERT INTO student2\nVALUES(\'Chun\',\'b\'),(\'Esben\',\'c\'),(\'Kaolin\',\'a\');\n \nSELECT MIN(grade) FROM student2;\n \n+------------+\n| MIN(grade) |\n+------------+\n| a |\n+------------+\n \nSELECT grade FROM student2 ORDER BY grade ASC LIMIT 1;\n \n+-------+\n| grade |\n+-------+\n| b |\n+-------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, MIN(score) \n OVER (PARTITION BY name) AS lowest_score FROM student_test;\n \n+---------+--------+-------+--------------+\n| name | test | score | lowest_score |\n+---------+--------+-------+--------------+\n| Chun | SQL | 75 | 73 |\n| Chun | Tuning | 73 | 73 |\n| Esben | SQL | 43 | 31 |\n| Esben | Tuning | 31 | 31 |\n| Kaolin | SQL | 56 | 56 |\n| Kaolin | Tuning | 88 | 56 |\n| Tatiana | SQL | 87 | 87 |\n+---------+--------+-------+--------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/min/','','https://mariadb.com/kb/en/library/min/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (192,16,'STD','Syntax\n------ \nSTD(expr)\n \nDescription\n----------- \nReturns the population standard deviation of expr. This is\nan extension\nto standard SQL. The standard SQL function STDDEV_POP() can\nbe used instead. \n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, STD() can be used as a window function.\n \nThis function returns NULL if there were no matching rows.\n \nExamples\n-------- \nAs an aggregate function:\n \nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n \nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n \nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n \n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a | 0.8165 | 1.0000 | 0.6667 |\n| b | 18.0400 | 20.1693 | 325.4400 |\n+----------+---------------+----------------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM\nstudent_test;\n \n+---------+--------+-------+----------------+\n| name | test | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun | SQL | 75 | 16.9466 |\n| Chun | Tuning | 73 | 24.1247 |\n| Esben | SQL | 43 | 16.9466 |\n| Esben | Tuning | 31 | 24.1247 |\n| Kaolin | SQL | 56 | 16.9466 |\n| Kaolin | Tuning | 88 | 24.1247 |\n| Tatiana | SQL | 87 | 16.9466 |\n+---------+--------+-------+----------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/std/','','https://mariadb.com/kb/en/library/std/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (193,16,'STDDEV','Syntax\n------ \nSTDDEV(expr)\n \nDescription\n----------- \nReturns the population standard deviation of expr. This\nfunction is\nprovided for compatibility with Oracle. The standard SQL\nfunction\nSTDDEV_POP() can be used instead.\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, STDDEV() can be used as a window\nfunction.\n \nThis function returns NULL if there were no matching rows.\n \nExamples\n-------- \nAs an aggregate function:\n \nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n \nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n \nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n \n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a | 0.8165 | 1.0000 | 0.6667 |\n| b | 18.0400 | 20.1693 | 325.4400 |\n+----------+---------------+----------------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM\nstudent_test;\n \n+---------+--------+-------+----------------+\n| name | test | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun | SQL | 75 | 16.9466 |\n| Chun | Tuning | 73 | 24.1247 |\n| Esben | SQL | 43 | 16.9466 |\n| Esben | Tuning | 31 | 24.1247 |\n| Kaolin | SQL | 56 | 16.9466 |\n| Kaolin | Tuning | 88 | 24.1247 |\n| Tatiana | SQL | 87 | 16.9466 |\n+---------+--------+-------+----------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/stddev/','','https://mariadb.com/kb/en/library/stddev/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (194,16,'STDDEV_POP','Syntax\n------ \nSTDDEV_POP(expr)\n \nDescription\n----------- \nReturns the population standard deviation of expr (the\nsquare root of\nVAR_POP()). You can also use STD() or\nSTDDEV(), which are equivalent but not standard SQL.\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, STDDEV_POP() can be used as a window\nfunction.\n \nSTDDEV_POP() returns NULL if there were no matching rows.\n \nExamples\n-------- \nAs an aggregate function:\n \nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n \nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n \nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n \n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a | 0.8165 | 1.0000 | 0.6667 |\n| b | 18.0400 | 20.1693 | 325.4400 |\n+----------+---------------+----------------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, STDDEV_POP(score) \n OVER (PARTITION BY test) AS stddev_results FROM\nstudent_test;\n \n+---------+--------+-------+----------------+\n| name | test | score | stddev_results |\n+---------+--------+-------+----------------+\n| Chun | SQL | 75 | 16.9466 |\n| Chun | Tuning | 73 | 24.1247 |\n| Esben | SQL | 43 | 16.9466 |\n| Esben | Tuning | 31 | 24.1247 |\n| Kaolin | SQL | 56 | 16.9466 |\n| Kaolin | Tuning | 88 | 24.1247 |\n| Tatiana | SQL | 87 | 16.9466 |\n+---------+--------+-------+----------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/stddev_pop/','','https://mariadb.com/kb/en/library/stddev_pop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (195,16,'STDDEV_SAMP','Syntax\n------ \nSTDDEV_SAMP(expr)\n \nDescription\n----------- \nReturns the sample standard deviation of expr (the square\nroot of VAR_SAMP()).\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, STDDEV_SAMP() can be used as a window\nfunction.\n \nSTDDEV_SAMP() returns NULL if there were no matching rows.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/stddev_samp/','','https://mariadb.com/kb/en/library/stddev_samp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (196,16,'SUM','Syntax\n------ \nSUM([DISTINCT] expr)\n \nDescription\n----------- \nReturns the sum of expr. If the return set has no rows,\nSUM() returns\nNULL. The DISTINCT keyword can be used to sum only the\ndistinct values\nof expr.\n \nFrom MariaDB 10.2.0, SUM() can be used as a window function,\nalthough not with the DISTINCT specifier.\n \nExamples\n-------- \nCREATE TABLE sales (sales_value INT);\nINSERT INTO sales VALUES(10),(20),(20),(40);\n \nSELECT SUM(sales_value) FROM sales;\n \n+------------------+\n| SUM(sales_value) |\n+------------------+\n| 90 |\n+------------------+\n \nSELECT SUM(DISTINCT(sales_value)) FROM sales;\n \n+----------------------------+\n| SUM(DISTINCT(sales_value)) |\n+----------------------------+\n| 70 |\n+----------------------------+\n \nCommonly, SUM is used with a GROUP BY clause:\n \nCREATE TABLE sales (name CHAR(10), month CHAR(10), units\nINT);\n \nINSERT INTO sales VALUES \n (\'Chun\', \'Jan\', 75), (\'Chun\', \'Feb\', 73),\n (\'Esben\', \'Jan\', 43), (\'Esben\', \'Feb\', 31),\n (\'Kaolin\', \'Jan\', 56), (\'Kaolin\', \'Feb\', 88),\n (\'Tatiana\', \'Jan\', 87), (\'Tatiana\', \'Feb\', 83);\n \nSELECT name, SUM(units) FROM sales GROUP BY name;\n \n+---------+------------+\n| name | SUM(units) |\n+---------+------------+\n| Chun | 148 |\n| Esben | 74 |\n| Kaolin | 144 |\n| Tatiana | 170 |\n+---------+------------+\n \nThe GROUP BY clause is required when using an aggregate\nfunction along with regular column data, otherwise the\nresult will be a mismatch, as in the following common type\nof mistake:\n \nSELECT name,SUM(units) FROM sales\n;\n+------+------------+\n| name | SUM(units) |\n+------+------------+\n| Chun | 536 |\n+------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, SUM(score) OVER (PARTITION BY\nname) AS total_score FROM student_test;\n \n+---------+--------+-------+-------------+\n| name | test | score | total_score |\n+---------+--------+-------+-------------+\n| Chun | SQL | 75 | 148 |\n| Chun | Tuning | 73 | 148 |\n| Esben | SQL | 43 | 74 |\n| Esben | Tuning | 31 | 74 |\n| Kaolin | SQL | 56 | 144 |\n| Kaolin | Tuning | 88 | 144 |\n| Tatiana | SQL | 87 | 87 |\n+---------+--------+-------+-------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/sum/','','https://mariadb.com/kb/en/library/sum/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (197,16,'VARIANCE','Syntax\n------ \nVARIANCE(expr) \n \nDescription\n----------- \nReturns the population standard variance of expr. This is an\nextension to\nstandard SQL. The standard SQL function VAR_POP() can be\nused\ninstead.\n \nVariance is calculated by\nworking out the mean for the set\nfor each number, subtracting the mean and squaring the\nresult\ncalculate the average of the resulting differences\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, VARIANCE() can be used as a window\nfunction.\n \nVARIANCE() returns NULL if there were no matching rows.\n \nExamples\n-------- \nCREATE TABLE v(i tinyint);\n \nINSERT INTO v VALUES(101),(99);\n \nSELECT VARIANCE(i) FROM v;\n \n+-------------+\n| VARIANCE(i) |\n+-------------+\n| 1.0000 |\n+-------------+\n \nINSERT INTO v VALUES(120),(80);\n \nSELECT VARIANCE(i) FROM v;\n \n+-------------+\n| VARIANCE(i) |\n+-------------+\n| 200.5000 |\n+-------------+\n \nAs an aggregate function:\n \nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n \nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n \nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n \n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a | 0.8165 | 1.0000 | 0.6667 |\n| b | 18.0400 | 20.1693 | 325.4400 |\n+----------+---------------+----------------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM\nstudent_test;\n \n+---------+--------+-------+------------------+\n| name | test | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun | SQL | 75 | 287.1875 |\n| Chun | Tuning | 73 | 582.0000 |\n| Esben | SQL | 43 | 287.1875 |\n| Esben | Tuning | 31 | 582.0000 |\n| Kaolin | SQL | 56 | 287.1875 |\n| Kaolin | Tuning | 88 | 582.0000 |\n| Tatiana | SQL | 87 | 287.1875 |\n+---------+--------+-------+------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/variance/','','https://mariadb.com/kb/en/library/variance/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (198,16,'VAR_POP','Syntax\n------ \nVAR_POP(expr)\n \nDescription\n----------- \nReturns the population standard variance of expr. It\nconsiders rows as\nthe whole population, not as a sample, so it has the number\nof rows as\nthe denominator. You can also use VARIANCE(), which is\nequivalent but\nis not standard SQL.\n \nVariance is calculated by\nworking out the mean for the set\nfor each number, subtracting the mean and squaring the\nresult\ncalculate the average of the resulting differences\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, VAR_POP() can be used as a window\nfunction.\n \nVAR_POP() returns NULL if there were no matching rows.\n \nExamples\n-------- \nCREATE TABLE v(i tinyint);\n \nINSERT INTO v VALUES(101),(99);\n \nSELECT VAR_POP(i) FROM v;\n \n+------------+\n| VAR_POP(i) |\n+------------+\n| 1.0000 |\n+------------+\n \nINSERT INTO v VALUES(120),(80);\n \nSELECT VAR_POP(i) FROM v;\n \n+------------+\n| VAR_POP(i) |\n+------------+\n| 200.5000 |\n+------------+\n \nAs an aggregate function:\n \nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n \nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n \nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n \n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a | 0.8165 | 1.0000 | 0.6667 |\n| b | 18.0400 | 20.1693 | 325.4400 |\n+----------+---------------+----------------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, VAR_POP(score) \n OVER (PARTITION BY test) AS variance_results FROM\nstudent_test;\n \n+---------+--------+-------+------------------+\n| name | test | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun | SQL | 75 | 287.1875 |\n| Chun | Tuning | 73 | 582.0000 |\n| Esben | SQL | 43 | 287.1875 |\n| Esben | Tuning | 31 | 582.0000 |\n| Kaolin | SQL | 56 | 287.1875 |\n| Kaolin | Tuning | 88 | 582.0000 |\n| Tatiana | SQL | 87 | 287.1875 |\n+---------+--------+-------+------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/var_pop/','','https://mariadb.com/kb/en/library/var_pop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (199,16,'VAR_SAMP','Syntax\n------ \nVAR_SAMP(expr)\n \nDescription\n----------- \nReturns the sample variance of expr. That is, the\ndenominator is the number of rows minus one.\n \nIt is an aggregate function, and so can be used with the\nGROUP BY clause.\n \nFrom MariaDB 10.2.2, VAR_SAMP() can be used as a window\nfunction.\n \nVAR_SAMP() returns NULL if there were no matching rows.\n \nExamples\n-------- \nAs an aggregate function:\n \nCREATE OR REPLACE TABLE stats (category VARCHAR(2), x INT);\n \nINSERT INTO stats VALUES \n (\'a\',1),(\'a\',2),(\'a\',3),\n (\'b\',11),(\'b\',12),(\'b\',20),(\'b\',30),(\'b\',60);\n \nSELECT category, STDDEV_POP(x), STDDEV_SAMP(x), VAR_POP(x) \n FROM stats GROUP BY category;\n \n+----------+---------------+----------------+------------+\n| category | STDDEV_POP(x) | STDDEV_SAMP(x) | VAR_POP(x) |\n+----------+---------------+----------------+------------+\n| a | 0.8165 | 1.0000 | 0.6667 |\n| b | 18.0400 | 20.1693 | 325.4400 |\n+----------+---------------+----------------+------------+\n \nAs a window function:\n \nCREATE OR REPLACE TABLE student_test (name CHAR(10), test\nCHAR(10), score TINYINT);\n \nINSERT INTO student_test VALUES \n (\'Chun\', \'SQL\', 75), (\'Chun\', \'Tuning\', 73), \n (\'Esben\', \'SQL\', 43), (\'Esben\', \'Tuning\', 31), \n (\'Kaolin\', \'SQL\', 56), (\'Kaolin\', \'Tuning\', 88), \n (\'Tatiana\', \'SQL\', 87);\n \nSELECT name, test, score, VAR_SAMP(score) \n OVER (PARTITION BY test) AS variance_results FROM\nstudent_test;\n \n+---------+--------+-------+------------------+\n| name | test | score | variance_results |\n+---------+--------+-------+------------------+\n| Chun | SQL | 75 | 382.9167 |\n| Chun | Tuning | 73 | 873.0000 |\n| Esben | SQL | 43 | 382.9167 |\n| Esben | Tuning | 31 | 873.0000 |\n| Kaolin | SQL | 56 | 382.9167 |\n| Kaolin | Tuning | 88 | 873.0000 |\n| Tatiana | SQL | 87 | 382.9167 |\n+---------+--------+-------+------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/var_samp/','','https://mariadb.com/kb/en/library/var_samp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (200,17,'BENCHMARK','Syntax\n------ \nBENCHMARK(count,expr)\n \nDescription\n----------- \nThe BENCHMARK() function executes the expression expr\nrepeatedly count\ntimes. It may be used to time how quickly MariaDB processes\nthe\nexpression. The result value is always 0. The intended use\nis from\nwithin the mysql client, which reports query execution\ntimes.\n \nExamples\n-------- \nSELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n| 0 |\n+----------------------------------------------+\n1 row in set (0.21 sec)\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/benchmark/','','https://mariadb.com/kb/en/library/benchmark/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (201,17,'BINLOG_GTID_POS','From version 10.0.2, MariaDB supports global transaction IDs\nfor replication.\n \nSyntax\n------ \nBINLOG_GTID_POS(binlog_filename,binlog_offset)\n \nDescription\n----------- \nThe BINLOG_GTID_POS() function takes as input an old-style\nbinary log position in the form of a file name and a file\noffset. It looks up the position in the current binlog, and\nreturns a string representation of the corresponding GTID\nposition. If the position is not found in the current\nbinlog, NULL is returned.\n \nExamples\n-------- \nSELECT BINLOG_GTID_POS(\"master-bin.000001\", 600);\n \n\n\nURL: https://mariadb.com/kb/en/library/binlog_gtid_pos/','','https://mariadb.com/kb/en/library/binlog_gtid_pos/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (202,17,'CHARSET','Syntax\n------ \nCHARSET(str)\n \nDescription\n----------- \nReturns the character set of the string argument. If str is\nnot a string, it is considered as a binary string (so the\nfunction returns \'binary\'). This applies to NULL, too. The\nreturn value is a string in the utf8 character set.\n \nExamples\n-------- \nSELECT CHARSET(\'abc\');\n+----------------+\n| CHARSET(\'abc\') |\n+----------------+\n| latin1 |\n+----------------+\n \nSELECT CHARSET(CONVERT(\'abc\' USING utf8));\n+------------------------------------+\n| CHARSET(CONVERT(\'abc\' USING utf8)) |\n+------------------------------------+\n| utf8 |\n+------------------------------------+\n \nSELECT CHARSET(USER());\n+-----------------+\n| CHARSET(USER()) |\n+-----------------+\n| utf8 |\n+-----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/charset/','','https://mariadb.com/kb/en/library/charset/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (203,17,'COERCIBILITY','Syntax\n------ \nCOERCIBILITY(str)\n \nDescription\n----------- \nReturns the collation coercibility value of the string\nargument. Coercibility defines what will be converted to\nwhat in case of collation conflict, with an expression with\nhigher coercibility being converted to the collation of an\nexpression with lower coercibility.\n \nCoercibility | Description | Example | \n \n0 | Explicit | Value using a COLLATE clause | \n \n1 | No collation | Concatenated strings using different\ncollations | \n \n2 | Implicit | Column value | \n \n3 | Constant | USER() return value | \n \n4 | Coercible | Literal string | \n \n5 | Ignorable | NULL or derived from NULL | \n \nExamples\n-------- \nSELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n+-----------------------------------------------+\n| COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci) |\n+-----------------------------------------------+\n| 0 |\n+-----------------------------------------------+\n \nSELECT COERCIBILITY(USER());\n+----------------------+\n| COERCIBILITY(USER()) |\n+----------------------+\n| 3 |\n+----------------------+\n \nSELECT COERCIBILITY(\'abc\');\n+---------------------+\n| COERCIBILITY(\'abc\') |\n+---------------------+\n| 4 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/coercibility/','','https://mariadb.com/kb/en/library/coercibility/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (204,17,'COLLATION','Syntax\n------ \nCOLLATION(str)\n \nDescription\n----------- \nReturns the collation of the string argument. If str is not\na string, it is considered as a binary string (so the\nfunction returns \'binary\'). This applies to NULL, too. The\nreturn value is a string in the utf8 character set.\n \nSee Character Sets and Collations.\n \nExamples\n-------- \nSELECT COLLATION(\'abc\');\n+-------------------+\n| COLLATION(\'abc\') |\n+-------------------+\n| latin1_swedish_ci |\n+-------------------+\n \nSELECT COLLATION(_utf8\'abc\');\n+-----------------------+\n| COLLATION(_utf8\'abc\') |\n+-----------------------+\n| utf8_general_ci |\n+-----------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/collation/','','https://mariadb.com/kb/en/library/collation/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (205,17,'CONNECTION_ID','Syntax\n------ \nCONNECTION_ID()\n \nDescription\n----------- \nReturns the connection ID (thread ID) for the connection.\nEvery\nthread (including events) has an ID that is unique among the\nset of currently\nconnected clients.\n \nUntil MariaDB 10.3.1, returns MYSQL_TYPE_LONGLONG, or\nbigint(10), in all cases. From MariaDB 10.3.1, returns\nMYSQL_TYPE_LONG, or int(10), when the result would fit\nwithin 32-bits.\n \nExamples\n-------- \nSELECT CONNECTION_ID();\n+-----------------+\n| CONNECTION_ID() |\n+-----------------+\n| 3 |\n+-----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/connection_id/','','https://mariadb.com/kb/en/library/connection_id/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (206,17,'CURRENT_ROLE','Roles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nCURRENT_ROLE, CURRENT_ROLE()\n \nDescription\n----------- \nReturns the current role name. This determines your access\nprivileges. The return value is a string in the\nutf8 character set.\n \nIf there is no current role, NULL is returned.\n \nThe output of SELECT CURRENT_ROLE is equivalent to the\ncontents of the ENABLED_ROLES Information Schema table.\n \nUSER() returns the combination of user and host used to\nlogin. CURRENT_USER() returns the account used to determine\ncurrent connection\'s privileges.\n \nExamples\n-------- \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| NULL |\n+--------------+\n \nSET ROLE staff;\n \nSELECT CURRENT_ROLE;\n \n+--------------+\n| CURRENT_ROLE |\n+--------------+\n| staff |\n+--------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/current_role/','','https://mariadb.com/kb/en/library/current_role/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (207,17,'CURRENT_USER','Syntax\n------ \nCURRENT_USER, CURRENT_USER()\n \nDescription\n----------- \nReturns the user name and host name combination for the\nMariaDB account\nthat the server used to authenticate the current client.\nThis account\ndetermines your access privileges. The return value is a\nstring in the\nutf8 character set.\n \nThe value of CURRENT_USER() can differ from the value of\nUSER(). CURRENT_ROLE() returns the current active role.\n \nExamples\n-------- \nshell> mysql --user=\"anonymous\"\n \nMariaDB [(none)]> select user(),current_user();\n+---------------------+----------------+\n| user() | current_user() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost |\n+---------------------+----------------+\n \nWhen calling CURRENT_USER() in a stored procedure, it\nreturns the owner of the stored procedure, as defined with\nDEFINER.\n \n\n\nURL: https://mariadb.com/kb/en/library/current_user/','','https://mariadb.com/kb/en/library/current_user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (208,17,'DATABASE','Syntax\n------ \nDATABASE()\n \nDescription\n----------- \nReturns the default (current) database name as a string in\nthe utf8 character set. If there is no default database,\nDATABASE() returns NULL. Within a stored routine, the\ndefault database is the database that the routine is\nassociated with, which is not necessarily the same as the\ndatabase that is the default in the calling context.\n \nSCHEMA() is a synonym for DATABASE().\n \nTo select a default database, the USE statement can be run.\nAnother way to set the default database is specifying its\nname at mysql command line client startup.\n \nExamples\n-------- \nSELECT DATABASE();\n+------------+\n| DATABASE() |\n+------------+\n| NULL |\n+------------+\n \nUSE test;\n \nDatabase changed\n \nSELECT DATABASE();\n+------------+\n| DATABASE() |\n+------------+\n| test |\n+------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/database/','','https://mariadb.com/kb/en/library/database/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (209,17,'DECODE_HISTOGRAM','DECODE_HISTOGRAM() was introduced in MariaDB 10.0.2\n \nSyntax\n------ \nDECODE_HISTOGRAM(hist_type,histogram)\n \nNote: Before MariaDB 10.0.10 the arguments were reversed.\n \nDescription\n----------- \nReturns a string of comma separated numeric values\ncorresponding to a probability distribution represented by\nthe histogram of type hist_type (SINGLE_PREC_HB or\nDOUBLE_PREC_HB). The hist_type and histogram would be\ncommonly used from the mysql.column_stats table.\n \nSee Histogram Based Statistics for details.\n \nExamples\n-------- \nCREATE TABLE origin (\n i INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,\n v INT UNSIGNED NOT NULL\n);\n \nINSERT INTO origin(v) VALUES \n (1),(2),(3),(4),(5),(10),(20),\n (30),(40),(50),(60),(70),(80),\n (90),(100),(200),(400),(800);\n \nSET histogram_size=10,histogram_type=SINGLE_PREC_HB;\n \nANALYZE TABLE origin PERSISTENT FOR ALL;\n \n+-------------+---------+----------+-----------------------------------------+\n| Table | Op | Msg_type | Msg_text |\n+-------------+---------+----------+-----------------------------------------+\n| test.origin | analyze | status | Engine-independent\nstatistics collected |\n| test.origin | analyze | status | OK |\n+-------------+---------+----------+-----------------------------------------+\n \nSELECT db_name,table_name,column_name,hist_type,\n hex(histogram),decode_histogram(hist_type,histogram) \n FROM mysql.column_stats WHERE db_name=\'test\' and\ntable_name=\'origin\';\n \n+---------+------------+-------------+----------------+----------------------+-------------------------------------------------------------------+\n| db_name | table_name | column_name | hist_type |\nhex(histogram) | decode_histogram(hist_type,histogram) |\n+---------+------------+-------------+----------------+----------------------+-------------------------------------------------------------------+\n| test | origin | i | SINGLE_PREC_HB | 0F2D3C5A7887A5C3D2F0\n|\n0.059,0.118,0.059,0.118,0.118,0.059,0.118,0.118,0.059,0.118,0.059\n|\n| test | origin | v | SINGLE_PREC_HB | 000001060C0F161C1F7F\n|\n0.000,0.000,0.004,0.020,0.024,0.012,0.027,0.024,0.012,0.376,0.502\n|\n+---------+------------+-------------+----------------+----------------------+-------------------------------------------------------------------+\n \nSET histogram_size=20,histogram_type=DOUBLE_PREC_HB;\n \nANALYZE TABLE origin PERSISTENT FOR ALL;\n \n+-------------+---------+----------+-----------------------------------------+\n| Table | Op | Msg_type | Msg_text |\n+-------------+---------+----------+-----------------------------------------+\n| test.origin | analyze | status | Engine-independent\nstatistics collected |\n| test.origin | analyze | status | OK |\n+-------------+---------+----------+-----------------------------------------+\n \nSELECT db_name,table_name,column_name,\n hist_type,hex(histogram),decode_histogram(hist_type,histogram)\n\n FROM mysql.column_stats WHERE db_name=\'test\' and\ntable_name=\'origin\';\n \n+---------+------------+-------------+----------------+------------------------------------------+-----------------------------------------------------------------------------------------+\n| db_name | table_name | column_name | hist_type |\nhex(histogram) | decode_histogram(hist_type,histogram) |\n+---------+------------+-------------+----------------+------------------------------------------+-----------------------------------------------------------------------------------------+\n| test | origin | i | DOUBLE_PREC_HB |\n0F0F2D2D3C3C5A5A78788787A5A5C3C3D2D2F0F0 |\n0.05882,0.11765,0.05882,0.11765,0.11765,0.05882,0.11765,0.11765,0.05882,0.11765,0.05882\n|\n| test | origin | v | DOUBLE_PREC_HB |\n5200F600480116067E0CB30F1B16831CB81FD67F |\n0.00125,0.00250,0.00125,0.01877,0.02502,0.01253,0.02502,0.02502,0.01253,0.37546,0.50063\n|\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/decode_histogram/','','https://mariadb.com/kb/en/library/decode_histogram/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (210,17,'DEFAULT','Syntax\n------ \nDEFAULT(col_name)\n \nDescription\n----------- \nReturns the default value for a table column. If the column\nhas no default value, NULL is returned.\nFor integer columns using AUTO_INCREMENT, 0 is returned.\n \nWhen using DEFAULT as a value to set in an INSERT or UPDATE\nstatement, you can use the bare keyword DEFAULT without the\nparentheses and argument to\nrefer to the column in context. You can only use DEFAULT as\na bare keyword if you are using it\nalone without a surrounding expression or function.\n \nExamples\n-------- \nSelect only non-default values for a column:\n \nSELECT i FROM t WHERE i != DEFAULT(i);\n \nUpdate values to be one greater than the default value:\n \nUPDATE t SET i = DEFAULT(i)+1 WHERE i \n\nURL: https://mariadb.com/kb/en/library/default/','','https://mariadb.com/kb/en/library/default/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (211,17,'FOUND_ROWS','Syntax\n------ \nFOUND_ROWS()\n \nDescription\n----------- \nA SELECT statement may include a LIMIT clause to restrict\nthe number\nof rows the server returns to the client. In some cases, it\nis\ndesirable to know how many rows the statement would have\nreturned\nwithout the LIMIT, but without running the statement again.\nTo obtain\nthis row count, include a SQL_CALC_FOUND_ROWS option in the\nSELECT\nstatement, and then invoke FOUND_ROWS() afterwards.\n \nYou can also use FOUND_ROWS() to obtain the number of rows\nreturned by a SELECT which does not contain a LIMIT clause.\nIn this case you don\'t need to use the SQL_CALC_FOUND_ROWS\noption. This can be useful for example in a stored\nprocedure.\n \nAlso, this function works with some other statements which\nreturn a resultset, including SHOW, DESC and HELP. For\nDELETE ... RETURNING you should use ROW_COUNT(). It also\nworks as a prepared statement, or after executing a prepared\nstatement.\n \nStatements which don\'t return any results don\'t affect\nFOUND_ROWS() - the previous value will still be returned.\n \nWarning: When used after a CALL statement, this function\nreturns the number of rows selected by the last query in the\nprocedure, not by the whole procedure.\n \nStatements using the FOUND_ROWS() function are not safe for\nreplication.\n \nExamples\n-------- \nSHOW ENGINES;\n \n+--------------------+---------+----------------------------------------------------------------+--------------+------+------------+\n| Engine | Support | Comment | Transactions | XA |\nSavepoints |\n+--------------------+---------+----------------------------------------------------------------+--------------+------+------------+\n| InnoDB | DEFAULT | Supports transactions, row-level\nlocking, and foreign keys | YES | YES | YES |\n...\n| SPHINX | YES | Sphinx storage engine | NO | NO | NO |\n+--------------------+---------+----------------------------------------------------------------+--------------+------+------------+\n11 rows in set (0.01 sec)\n \nSELECT FOUND_ROWS();\n+--------------+\n| FOUND_ROWS() |\n+--------------+\n| 11 |\n+--------------+\n \nSELECT SQL_CALC_FOUND_ROWS * FROM tbl_name WHERE id > 100\nLIMIT 10;\n \nSELECT FOUND_ROWS();\n+--------------+\n| FOUND_ROWS() |\n+--------------+\n| 23 |\n+--------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/found_rows/','','https://mariadb.com/kb/en/library/found_rows/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (212,17,'LAST_INSERT_ID','Syntax\n------ \nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n \nDescription\n----------- \nLAST_INSERT_ID() (no arguments) returns\nthe first automatically generated value successfully\ninserted for an\nAUTO_INCREMENT column as a result of the most recently\nexecuted INSERT\nstatement. The value of LAST_INSERT_ID() remains unchanged\nif no rows\nare successfully inserted.\n \nIf one gives an argument to LAST_INSERT_ID(), then it will\nreturn the value of the expression and\nthe next call to LAST_INSERT_ID() will return the same\nvalue. The value will also be sent to the client\nand can be accessed by the mysql_insert_id function.\n \nFor example, after inserting a row that generates an\nAUTO_INCREMENT\nvalue, you can get the value like this:\n \nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n| 9 |\n+------------------+\n \nYou can also use LAST_INSERT_ID() to delete the last\ninserted row:\n \nDELETE FROM product WHERE id = LAST_INSERT_ID();\n \nIf no rows were successfully inserted, LAST_INSERT_ID()\nreturns 0.\n \nThe value of LAST_INSERT_ID() will be consistent across all\nversions\nif all rows in the INSERT or UPDATE statement were\nsuccessful.\n \nThe currently executing statement does not affect the value\nof\nLAST_INSERT_ID(). Suppose that you generate an\nAUTO_INCREMENT value\nwith one statement, and then refer to LAST_INSERT_ID() in a\nmultiple-row INSERT statement that inserts rows into a table\nwith its\nown AUTO_INCREMENT column. The value of LAST_INSERT_ID()\nwill remain\nstable in the second statement; its value for the second and\nlater\nrows is not affected by the earlier row insertions.\n(However, if you\nmix references to LAST_INSERT_ID() and LAST_INSERT_ID(expr),\nthe\neffect is undefined.)\n \nIf the previous statement returned an error, the value of\nLAST_INSERT_ID() is undefined. For transactional tables, if\nthe\nstatement is rolled back due to an error, the value of\nLAST_INSERT_ID() is left undefined. For manual ROLLBACK, the\nvalue of\nLAST_INSERT_ID() is not restored to that before the\ntransaction; it\nremains as it was at the point of the ROLLBACK.\n \nWithin the body of a stored routine (procedure or function)\nor a\ntrigger, the value of LAST_INSERT_ID() changes the same way\nas for\nstatements executed outside the body of these kinds of\nobjects. The\neffect of a stored routine or trigger upon the value of\nLAST_INSERT_ID() that is seen by following statements\ndepends on the\nkind of routine:\nIf a stored procedure executes statements that change the\nvalue of LAST_INSERT_ID(), the new value will be seen by\nstatements that follow the procedure call.\n \nFor stored functions and triggers that change the value, the\nvalue is restored when the function or trigger ends, so\nfollowing statements will not see a changed value.\n \nExamples\n-------- \nCREATE TABLE t (\n id INTEGER UNSIGNED AUTO_INCREMENT PRIMARY KEY, \n f VARCHAR(1)) \nENGINE = InnoDB;\n \nINSERT INTO t(f) VALUES(\'a\');\n \nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n| 1 |\n+------------------+\n \nINSERT INTO t(f) VALUES(\'b\');\n \nINSERT INTO t(f) VALUES(\'c\');\n \nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n| 3 |\n+------------------+\n \nINSERT INTO t(f) VALUES(\'d\'),(\'e\');\n \nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n| 4 |\n+------------------+\n \nSELECT * FROM t;\n \n+----+------+\n| id | f |\n+----+------+\n| 1 | a |\n| 2 | b |\n| 3 | c |\n| 4 | d |\n| 5 | e |\n+----+------+\n \nSELECT LAST_INSERT_ID(12);\n+--------------------+\n| LAST_INSERT_ID(12) |\n+--------------------+\n| 12 |\n+--------------------+\n \nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n| 12 |\n+------------------+\n \nINSERT INTO t(f) VALUES(\'f\');\n \nSELECT LAST_INSERT_ID();\n+------------------+\n| LAST_INSERT_ID() |\n+------------------+\n| 6 |\n+------------------+\n \nSELECT * FROM t;\n \n+----+------+\n| id | f |\n+----+------+\n| 1 | a |\n| 2 | b |\n| 3 | c |\n| 4 | d |\n| 5 | e |\n| 6 | f |\n+----+------+\n \nSELECT LAST_INSERT_ID(12);\n+--------------------+\n| LAST_INSERT_ID(12) |\n+--------------------+\n| 12 |\n+--------------------+\n \nINSERT INTO t(f) VALUES(\'g\');\n \nSELECT * FROM t;\n \n+----+------+\n| id | f |\n+----+------+\n| 1 | a |\n| 2 | b |\n| 3 | c |\n| 4 | d |\n| 5 | e |\n| 6 | f |\n| 7 | g |\n+----+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/last_insert_id/','','https://mariadb.com/kb/en/library/last_insert_id/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (213,17,'LAST_VALUE','Syntax\n------ \nLAST_VALUE(expr,[expr,...])\n \nLAST_VALUE(expr) OVER (\n [ PARTITION BY partition_expression ]\n [ ORDER BY order_list ]\n) \n \nDescription\n----------- \nLAST_VALUE() evaluates all expressions and returns the last.\n \nThis is useful together with setting user variables to a\nvalue with @var:=expr, for example when you want to get data\nof rows updated/deleted without having to do two queries\nagainst the table.\n \nSince MariaDB 10.2.2, LAST_VALUE can be used as a window\nfunction.\n \nReturns NULL if no last value exists.\n \nExamples\n-------- \nCREATE TABLE t1 (a int, b int);\nINSERT INTO t1 VALUES(1,10),(2,20);\nDELETE FROM t1 WHERE a=1 AND last_value(@a:=a,@b:=b,1);\nSELECT @a,@b;\n \n+------+------+\n| @a | @b |\n+------+------+\n| 1 | 10 |\n+------+------+\n \nAs a window function:\n \nCREATE TABLE t1 (\n pk int primary key,\n a int,\n b int,\n c char(10),\n d decimal(10, 3),\n e real\n);\n \nINSERT INTO t1 VALUES\n( 1, 0, 1, \'one\', 0.1, 0.001),\n( 2, 0, 2, \'two\', 0.2, 0.002),\n( 3, 0, 3, \'three\', 0.3, 0.003),\n( 4, 1, 2, \'three\', 0.4, 0.004),\n( 5, 1, 1, \'two\', 0.5, 0.005),\n( 6, 1, 1, \'one\', 0.6, 0.006),\n( 7, 2, NULL, \'n_one\', 0.5, 0.007),\n( 8, 2, 1, \'n_two\', NULL, 0.008),\n( 9, 2, 2, NULL, 0.7, 0.009),\n(10, 2, 0, \'n_four\', 0.8, 0.010),\n(11, 2, 10, NULL, 0.9, NULL);\n \nSELECT pk, FIRST_VALUE(pk) OVER (ORDER BY pk) AS first_asc,\n LAST_VALUE(pk) OVER (ORDER BY pk) AS last_asc,\n FIRST_VALUE(pk) OVER (ORDER BY pk DESC) AS first_desc,\n LAST_VALUE(pk) OVER (ORDER BY pk DESC) AS last_desc\nFROM t1\nORDER BY pk DESC;\n \n+----+-----------+----------+------------+-----------+\n| pk | first_asc | last_asc | first_desc | last_desc |\n+----+-----------+----------+------------+-----------+\n| 11 | 1 | 11 | 11 | 11 |\n| 10 | 1 | 10 | 11 | 10 |\n| 9 | 1 | 9 | 11 | 9 |\n| 8 | 1 | 8 | 11 | 8 |\n| 7 | 1 | 7 | 11 | 7 |\n| 6 | 1 | 6 | 11 | 6 |\n| 5 | 1 | 5 | 11 | 5 |\n| 4 | 1 | 4 | 11 | 4 |\n| 3 | 1 | 3 | 11 | 3 |\n| 2 | 1 | 2 | 11 | 2 |\n| 1 | 1 | 1 | 11 | 1 |\n+----+-----------+----------+------------+-----------+\n \nCREATE OR REPLACE TABLE t1 (i int);\nINSERT INTO t1 VALUES\n(1),(2),(3),(4),(5),(6),(7),(8),(9),(10);\n \nSELECT i,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN CURRENT ROW\nand 1 FOLLOWING) AS f_1f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN CURRENT ROW and\n1 FOLLOWING) AS l_1f,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 PRECEDING\nAND 1 FOLLOWING) AS f_1p1f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 PRECEDING AND\n1 FOLLOWING) AS f_1p1f,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 2 PRECEDING\nAND 1 PRECEDING) AS f_2p1p,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 2 PRECEDING AND\n1 PRECEDING) AS f_2p1p,\n FIRST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 FOLLOWING\nAND 2 FOLLOWING) AS f_1f2f,\n LAST_VALUE(i) OVER (ORDER BY i ROWS BETWEEN 1 FOLLOWING AND\n2 FOLLOWING) AS f_1f2f\nFROM t1;\n \n+------+------+------+--------+--------+--------+--------+--------+--------+\n| i | f_1f | l_1f | f_1p1f | f_1p1f | f_2p1p | f_2p1p |\nf_1f2f | f_1f2f |\n+------+------+------+--------+--------+--------+--------+--------+--------+\n| 1 | 1 | 2 | 1 | 2 | NULL | NULL | 2 | 3 |\n| 2 | 2 | 3 | 1 | 3 | 1 | 1 | 3 | 4 |\n| 3 | 3 | 4 | 2 | 4 | 1 | 2 | 4 | 5 |\n| 4 | 4 | 5 | 3 | 5 | 2 | 3 | 5 | 6 |\n| 5 | 5 | 6 | 4 | 6 | 3 | 4 | 6 | 7 |\n| 6 | 6 | 7 | 5 | 7 | 4 | 5 | 7 | 8 |\n| 7 | 7 | 8 | 6 | 8 | 5 | 6 | 8 | 9 |\n| 8 | 8 | 9 | 7 | 9 | 6 | 7 | 9 | 10 |\n| 9 | 9 | 10 | 8 | 10 | 7 | 8 | 10 | 10 |\n| 10 | 10 | 10 | 9 | 10 | 8 | 9 | NULL | NULL |\n+------+------+------+--------+--------+--------+--------+--------+--------+\n \n\n\nURL: https://mariadb.com/kb/en/library/last_value/','','https://mariadb.com/kb/en/library/last_value/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (214,17,'PROCEDURE ANALYSE','Syntax\n------ \nanalyse([max_elements[,max_memory]])\n \nDescription\n----------- \nThis procedure is defined in the sql/sql_analyse.cc file. It\nexamines\nthe result from a query and returns an analysis of the\nresults that\nsuggests optimal data types for each column. To obtain this\nanalysis,\nappend PROCEDURE ANALYSE to the end of a SELECT statement:\n \nSELECT ... FROM ... WHERE ... PROCEDURE\nANALYSE([max_elements,[max_memory]])\n \nFor example:\n \nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n \nThe results show some statistics for the values returned by\nthe query,\nand propose an optimal data type for the columns. This can\nbe helpful\nfor checking your existing tables, or after importing new\ndata. You\nmay need to try different settings for the arguments so that\nPROCEDURE\nANALYSE() does not suggest the ENUM data type when it is not\nappropriate.\n \nThe arguments are optional and are used as follows:\nmax_elements (default 256) is the maximum number of distinct\nvalues that analyse notices per column. This is used by\nanalyse to check whether the optimal data type should be of\ntype ENUM; if there are more than max_elements distinct\nvalues, then ENUM is not a suggested type.\nmax_memory (default 8192) is the maximum amount of memory\nthat analyse should allocate per column while trying to find\nall distinct values.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/procedure-analyse/','','https://mariadb.com/kb/en/library/procedure-analyse/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (215,17,'ROW_COUNT','Syntax\n------ \nROW_COUNT()\n \nDescription\n----------- \nROW_COUNT() returns the number of rows updated, inserted or\ndeleted\nby the preceding statement. This is the same as the row\ncount that the\nmysql client displays and the value from the\nmysql_affected_rows() C\nAPI function.\n \nGenerally:\nFor statements which return a result set (such as SELECT,\nSHOW, DESC or HELP), returns -1, even when the result set is\nempty. This is also true for administrative statements, such\nas OPTIMIZE.\nFor DML statements other than SELECT and for ALTER TABLE,\nreturns the number of affected rows.\nFor DDL statements (including TRUNCATE) and for other\nstatements which don\'t return any result set (such as USE,\nDO, SIGNAL or DEALLOCATE PREPARE), returns 0.\n \nFor UPDATE, affected rows is by default the number of rows\nthat were actually changed. If the CLIENT_FOUND_ROWS flag to\nmysql_real_connect() is specified when connecting to mysqld,\naffected rows is instead the number of rows matched by the\nWHERE clause. \n \nFor REPLACE, deleted rows are also counted. So, if REPLACE\ndeletes a row and adds a new row, ROW_COUNT() returns 2.\n \nFor INSERT ... ON DUPLICATE KEY, updated rows are counted\ntwice. So, if INSERT adds a new rows and modifies another\nrow, ROW_COUNT() returns 3.\n \nROW_COUNT() does not take into account rows that are not\ndirectly deleted/updated by the last statement. This means\nthat rows deleted by foreign keys or triggers are not\ncounted.\n \nWarning: You can use ROW_COUNT() with prepared statements,\nbut you need to call it after EXECUTE, not after DEALLOCATE\nPREPARE, because the row count for allocate prepare is\nalways 0.\n \nWarning: When used after a CALL statement, this function\nreturns the number of rows affected by the last statement in\nthe procedure, not by the whole procedure.\n \nWarning: After INSERT DELAYED, ROW_COUNT() returns the\nnumber of the rows you tried to insert, not the number of\nthe successful writes.\n \nThis information can also be found in the diagnostics area.\n \nStatements using the ROW_COUNT() function are not safe for\nreplication.\n \nExamples\n-------- \nCREATE TABLE t (A INT);\n \nINSERT INTO t VALUES(1),(2),(3);\n \nSELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n| 3 |\n+-------------+\n \nDELETE FROM t WHERE A IN(1,2);\n \nSELECT ROW_COUNT(); \n+-------------+\n| ROW_COUNT() |\n+-------------+\n| 2 |\n+-------------+\n \nExample with prepared statements:\n \nSET @q = \'INSERT INTO t VALUES(1),(2),(3);\';\n \nPREPARE stmt FROM @q;\n \nEXECUTE stmt;\n \nQuery OK, 3 rows affected (0.39 sec)\nRecords: 3 Duplicates: 0 Warnings: 0\n \nSELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n| 3 |\n+-------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/row_count/','','https://mariadb.com/kb/en/library/row_count/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (216,17,'SCHEMA','Syntax\n------ \nSCHEMA()\n \nDescription\n----------- \nThis function is a synonym for DATABASE().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/schema/','','https://mariadb.com/kb/en/library/schema/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (217,17,'SESSION_USER','Syntax\n------ \nSESSION_USER()\n \nDescription\n----------- \nSESSION_USER() is a synonym for USER().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/session_user/','','https://mariadb.com/kb/en/library/session_user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (218,17,'SYSTEM_USER','Syntax\n------ \nSYSTEM_USER()\n \nDescription\n----------- \nSYSTEM_USER() is a synonym for USER().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/system_user/','','https://mariadb.com/kb/en/library/system_user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (219,17,'USER','Syntax\n------ \nUSER()\n \nDescription\n----------- \nReturns the current MariaDB user name and host name, given\nwhen authenticating to MariaDB, as a string in the utf8\ncharacter set.\n \nNote that the value of USER() may differ from the value of\nCURRENT_USER(), which is the user used to authenticate the\ncurrent client. \nCURRENT_ROLE() returns the current active role.\n \nSYSTEM_USER() and SESSION_USER are synonyms for USER().\n \nStatements using the USER() function or one of its synonyms\nare not safe for statement level replication.\n \nExamples\n-------- \nshell> mysql --user=\"anonymous\"\n \nMariaDB [(none)]> select user(),current_user();\n+---------------------+----------------+\n| user() | current_user() |\n+---------------------+----------------+\n| anonymous@localhost | @localhost |\n+---------------------+----------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/user/','','https://mariadb.com/kb/en/library/user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (220,17,'VERSION','Syntax\n------ \nVERSION()\n \nDescription\n----------- \nReturns a string that indicates the MariaDB server version.\nThe string\nuses the utf8 character set.\n \nExamples\n-------- \nSELECT VERSION();\n+------------------------------+\n| VERSION() |\n+------------------------------+\n| 10.0.3-MariaDB-1~precise-log |\n+------------------------------+\n \nThe VERSION() string may have one or more of the following\nsuffixes:\n \nSuffix | Description | \n \n-embedded | The server is an embedded server (libmysqld). | \n \n-log | General logging, slow logging or binary (replication)\nlogging is enabled. | \n \n-debug | The server is compiled for debugging. | \n \n-valgrind |  The server is compiled to be instrumented with\nvalgrind. | \n \nChanging the Version String\n \nSome old legacy code may break because they are parsing the\nVERSION string and expecting a MySQL string or a simple\nversion\nstring like Joomla til API17, see MDEV-7780.\n \nIn MariaDB 10.2 one can fool these applications by setting\nthe version string from the command line or the my.cnf files\nwith --version=....\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/version/','','https://mariadb.com/kb/en/library/version/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (221,18,'!=','Syntax\n------ \n, !=\n \nDescription\n----------- \nNot equal operator. Evaluates both SQL expressions and\nreturns 1 if they are not equal and 0 if they are equal, or\nNULL if either expression is NULL. If the expressions return\ndifferent data types, (for instance, a number and a string),\nperforms type conversion.\n \nWhen used in row comparisons these two queries return the\nsame results:\n \nSELECT (t1.a, t1.b) != (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n \nSELECT (t1.a != t2.x) OR (t1.b != t2.y)\nFROM t1 INNER JOIN t2;\n \nExamples\n-------- \nSELECT \'.01\'  \'0.01\';\n \n+-----------------+\n| \'.01\'  \'0.01\' |\n+-----------------+\n| 1 |\n+-----------------+\n \nSELECT .01  \'0.01\';\n \n+---------------+\n| .01  \'0.01\' |\n+---------------+\n| 0 |\n+---------------+\n \nSELECT \'zapp\'  \'zappp\';\n \n+-------------------+\n| \'zapp\'  \'zappp\' |\n+-------------------+\n| 1 |\n+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/not-equal/','','https://mariadb.com/kb/en/library/not-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (222,18,'&lt;','Syntax\n------ \n\n\nURL: https://mariadb.com/kb/en/library/less-than/','','https://mariadb.com/kb/en/library/less-than/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (223,18,'&lt;=','Syntax\n------ \n\n\nURL: https://mariadb.com/kb/en/library/less-than-or-equal/','','https://mariadb.com/kb/en/library/less-than-or-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (224,18,'&lt;=&gt;','Syntax\n------ \n\n \nDescription\n----------- \nNULL-safe equal operator. It performs an equality comparison\nlike\nthe = operator, but returns 1 rather than NULL if both\noperands are\nNULL, and 0 rather than NULL if one operand is NULL.\n \na  b is equivalent to a = b OR (a IS NULL AND b IS NULL).\n \nWhen used in row comparisons these two queries return the\nsame results:\n \nSELECT (t1.a, t1.b)  (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n \nSELECT (t1.a  t2.x) AND (t1.b  t2.y)\nFROM t1 INNER JOIN t2;\n \nSee also NULL Values in MariaDB.\n \nExamples\n-------- \nSELECT 1  1, NULL  NULL, 1  NULL;\n \n+---------+---------------+------------+\n| 1  1 | NULL  NULL | 1  NULL |\n+---------+---------------+------------+\n| 1 | 1 | 0 |\n+---------+---------------+------------+\n \nSELECT 1 = 1, NULL = NULL, 1 = NULL;\n \n+-------+-------------+----------+\n| 1 = 1 | NULL = NULL | 1 = NULL |\n+-------+-------------+----------+\n| 1 | NULL | NULL |\n+-------+-------------+----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/null-safe-equal/','','https://mariadb.com/kb/en/library/null-safe-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (225,18,'=','Syntax\n------ \nleft_expr = right_expr\n \nDescription\n----------- \nEqual operator. Evaluates both SQL expressions and returns 1\nif they are equal, 0 if they are not equal, or NULL if\neither expression is NULL. If the expressions return\ndifferent data types (for example, a number and a string), a\ntype conversion is performed.\n \nWhen used in row comparisons these two queries are\nsynonymous and return the same results:\n \nSELECT (t1.a, t1.b) = (t2.x, t2.y) FROM t1 INNER JOIN t2;\n \nSELECT (t1.a = t2.x) AND (t1.b = t2.y) FROM t1 INNER JOIN\nt2;\n \nTo perform a NULL-safe comparison, use the  operator.\n \n= can also be used as an assignment operator.\n \nExamples\n-------- \nSELECT 1 = 0;\n \n+-------+\n| 1 = 0 |\n+-------+\n| 0 |\n+-------+\n \nSELECT \'0\' = 0;\n \n+---------+\n| \'0\' = 0 |\n+---------+\n| 1 |\n+---------+\n \nSELECT \'0.0\' = 0;\n \n+-----------+\n| \'0.0\' = 0 |\n+-----------+\n| 1 |\n+-----------+\n \nSELECT \'0.01\' = 0;\n \n+------------+\n| \'0.01\' = 0 |\n+------------+\n| 0 |\n+------------+\n \nSELECT \'.01\' = 0.01;\n \n+--------------+\n| \'.01\' = 0.01 |\n+--------------+\n| 1 |\n+--------------+\n \nSELECT (5 * 2) = CONCAT(\'1\', \'0\');\n+----------------------------+\n| (5 * 2) = CONCAT(\'1\', \'0\') |\n+----------------------------+\n| 1 |\n+----------------------------+\n \nSELECT 1 = NULL;\n \n+----------+\n| 1 = NULL |\n+----------+\n| NULL |\n+----------+\n \nSELECT NULL = NULL;\n \n+-------------+\n| NULL = NULL |\n+-------------+\n| NULL |\n+-------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/equal/','','https://mariadb.com/kb/en/library/equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (226,18,'&gt;','Syntax\n------ \n>\n \nDescription\n----------- \nGreater than operator. Evaluates both SQL expressions and\nreturns 1 if the left value is greater than the right value\nand 0 if it is not, or NULL if either expression is NULL. If\nthe expressions return different data types, (for instance,\na number and a string), performs type conversion.\n \nWhen used in row comparisons these two queries return the\nsame results:\n \nSELECT (t1.a, t1.b) > (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n \nSELECT (t1.a > t2.x) OR ((t1.a = t2.x) AND (t1.b > t2.y))\nFROM t1 INNER JOIN t2;\n \nExamples\n-------- \nSELECT 2 > 2;\n \n+-------+\n| 2 > 2 |\n+-------+\n| 0 |\n+-------+\n \nSELECT \'b\' > \'a\';\n \n+-----------+\n| \'b\' > \'a\' |\n+-----------+\n| 1 |\n+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/greater-than/','','https://mariadb.com/kb/en/library/greater-than/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (227,18,'&gt;=','Syntax\n------ \n>=\n \nDescription\n----------- \nGreater than or equal operator. Evaluates both SQL\nexpressions and returns 1 if the left value is greater than\nor equal to the right value and 0 if it is not, or NULL if\neither expression is NULL. If the expressions return\ndifferent data types, (for instance, a number and a string),\nperforms type conversion.\n \nWhen used in row comparisons these two queries return the\nsame results:\n \nSELECT (t1.a, t1.b) >= (t2.x, t2.y) \nFROM t1 INNER JOIN t2;\n \nSELECT (t1.a > t2.x) OR ((t1.a = t2.x) AND (t1.b >= t2.y))\nFROM t1 INNER JOIN t2;\n \nExamples\n-------- \nSELECT 2 >= 2;\n \n+--------+\n| 2 >= 2 |\n+--------+\n| 1 |\n+--------+\n \nSELECT \'A\' >= \'a\';\n \n+------------+\n| \'A\' >= \'a\' |\n+------------+\n| 1 |\n+------------+\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/greater-than-or-equal/','','https://mariadb.com/kb/en/library/greater-than-or-equal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (228,18,'BETWEEN AND','Syntax\n------ \nexpr BETWEEN min AND max\n \nDescription\n----------- \nIf expr is greater than or equal to min and expr is less\nthan or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is\nequivalent\nto the expression (min \n\nURL: https://mariadb.com/kb/en/library/between-and/','','https://mariadb.com/kb/en/library/between-and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (229,18,'COALESCE','Syntax\n------ \nCOALESCE(value,...)\n \nDescription\n----------- \nReturns the first non-NULL value in the list, or NULL if\nthere are no\nnon-NULL values. At least one parameter must be passed.\n \nSee also NULL Values in MariaDB.\n \nExamples\n-------- \nSELECT COALESCE(NULL,1);\n+------------------+\n| COALESCE(NULL,1) |\n+------------------+\n| 1 |\n+------------------+\n \nSELECT COALESCE(NULL,NULL,NULL);\n+--------------------------+\n| COALESCE(NULL,NULL,NULL) |\n+--------------------------+\n| NULL |\n+--------------------------+\n \nWhen two arguments are given, COALESCE() is the same as\nIFNULL():\n \nSET @a=NULL, @b=1;\n \nSELECT COALESCE(@a, @b), IFNULL(@a, @b);\n+------------------+----------------+\n| COALESCE(@a, @b) | IFNULL(@a, @b) |\n+------------------+----------------+\n| 1 | 1 |\n+------------------+----------------+\n \nHex type confusion:\n \nCREATE TABLE t1 (a INT, b VARCHAR(10));\nINSERT INTO t1 VALUES (0x31, 0x61),(COALESCE(0x31),\nCOALESCE(0x61));\n \nSELECT * FROM t1;\n \n+------+------+\n| a | b |\n+------+------+\n| 49 | a |\n| 1 | a |\n+------+------+\n \nThe reason for the differing results above is that when 0x31\nis inserted directly to the column, it\'s treated as a\nnumber (see Hexadecimal Literals), while when 0x31 is passed\nto COALESCE(), it\'s treated as a string, because:\nHEX values have a string data type by default.\nCOALESCE() has the same data type as the argument. \n \n\n\nURL: https://mariadb.com/kb/en/library/coalesce/','','https://mariadb.com/kb/en/library/coalesce/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (230,18,'GREATEST','Syntax\n------ \nGREATEST(value1,value2,...)\n \nDescription\n----------- \nWith two or more arguments, returns the largest\n(maximum-valued)\nargument. The arguments are compared using the same rules as\nfor\nLEAST().\n \nExamples\n-------- \nSELECT GREATEST(2,0);\n+---------------+\n| GREATEST(2,0) |\n+---------------+\n| 2 |\n+---------------+\n \nSELECT GREATEST(34.0,3.0,5.0,767.0);\n+------------------------------+\n| GREATEST(34.0,3.0,5.0,767.0) |\n+------------------------------+\n| 767.0 |\n+------------------------------+\n \nSELECT GREATEST(\'B\',\'A\',\'C\');\n+-----------------------+\n| GREATEST(\'B\',\'A\',\'C\') |\n+-----------------------+\n| C |\n+-----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/greatest/','','https://mariadb.com/kb/en/library/greatest/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (231,18,'IN','Syntax\n------ \nexpr IN (value,...)\n \nDescription\n----------- \nReturns 1 if expr is equal to any of the values in the IN\nlist, else\nreturns 0. If all values are constants, they are evaluated\naccording\nto the type of expr and sorted. The search for the item then\nis done\nusing a binary search. This means IN is very quick if the IN\nvalue\nlist consists entirely of constants. Otherwise, type\nconversion takes\nplace according to the rules described at Type Conversion,\nbut\napplied to all the arguments.\n \nIf expr is NULL, IN always returns NULL. If at least one of\nthe values in the list is NULL, and one of the comparisons\nis true, the result is 1. If at least one of the values in\nthe list is NULL and none of the comparisons is true, the\nresult is NULL.\n \nExamples\n-------- \nSELECT 2 IN (0,3,5,7);\n+----------------+\n| 2 IN (0,3,5,7) |\n+----------------+\n| 0 |\n+----------------+\n \nSELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n+----------------------------------+\n| \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\') |\n+----------------------------------+\n| 1 |\n+----------------------------------+ \n \nType conversion:\n \nSELECT 1 IN (\'1\', \'2\', \'3\');\n+----------------------+\n| 1 IN (\'1\', \'2\', \'3\') |\n+----------------------+\n| 1 |\n+----------------------+\n \nSELECT NULL IN (1, 2, 3);\n+-------------------+\n| NULL IN (1, 2, 3) |\n+-------------------+\n| NULL |\n+-------------------+\n \nMariaDB [(none)]> SELECT 1 IN (1, 2, NULL);\n+-------------------+\n| 1 IN (1, 2, NULL) |\n+-------------------+\n| 1 |\n+-------------------+\n \nMariaDB [(none)]> SELECT 5 IN (1, 2, NULL);\n+-------------------+\n| 5 IN (1, 2, NULL) |\n+-------------------+\n| NULL |\n+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/in/','','https://mariadb.com/kb/en/library/in/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (232,18,'INTERVAL','Syntax\n------ \nINTERVAL(N,N1,N2,N3,...)\n \nDescription\n----------- \nReturns the index of the last argument that is less than the\nfirst argument or is NULL. \n \nReturns 0 if N < N1, 1 if N < N2, 2 if N < N3 and so on or\n-1 if N is NULL. All\narguments are treated as integers. It is required that N1 <\nN2 < N3 \n\nURL: https://mariadb.com/kb/en/library/interval/','','https://mariadb.com/kb/en/library/interval/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (233,18,'IS','Syntax\n------ \nIS boolean_value\n \nDescription\n----------- \nTests a value against a boolean value, where boolean_value\ncan be\nTRUE, FALSE, or UNKNOWN.\n \nThere is an important difference between using IS TRUE or\ncomparing a value with TRUE using =. When using =, only 1\nequals to TRUE. But when using IS TRUE, all values which are\nlogically true (like a number > 1) return TRUE.\n \nExamples\n-------- \nSELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n+-----------+------------+-----------------+\n| 1 IS TRUE | 0 IS FALSE | NULL IS UNKNOWN |\n+-----------+------------+-----------------+\n| 1 | 1 | 1 |\n+-----------+------------+-----------------+\n \nDifference between = and IS TRUE:\n \nSELECT 2 = TRUE, 2 IS TRUE;\n+----------+-----------+\n| 2 = TRUE | 2 IS TRUE |\n+----------+-----------+\n| 0 | 1 |\n+----------+-----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/is/','','https://mariadb.com/kb/en/library/is/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (234,18,'IS NOT','Syntax\n------ \nIS NOT boolean_value\n \nDescription\n----------- \nTests a value against a boolean value, where boolean_value\ncan be\nTRUE, FALSE, or UNKNOWN. \n \nExamples\n-------- \nSELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT\nUNKNOWN;\n+------------------+------------------+---------------------+\n| 1 IS NOT UNKNOWN | 0 IS NOT UNKNOWN | NULL IS NOT UNKNOWN\n|\n+------------------+------------------+---------------------+\n| 1 | 1 | 0 |\n+------------------+------------------+---------------------+\n \nSELECT NULL IS NOT TRUE, NULL IS NOT FALSE;\n+------------------+-------------------+\n| NULL IS NOT TRUE | NULL IS NOT FALSE |\n+------------------+-------------------+\n| 1 | 1 |\n+------------------+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/is-not/','','https://mariadb.com/kb/en/library/is-not/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (235,18,'IS NOT NULL','Syntax\n------ \nIS NOT NULL\n \nDescription\n----------- \nTests whether a value is not NULL. See also NULL Values in\nMariaDB.\n \nExamples\n-------- \nSELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n+---------------+---------------+------------------+\n| 1 IS NOT NULL | 0 IS NOT NULL | NULL IS NOT NULL |\n+---------------+---------------+------------------+\n| 1 | 1 | 0 |\n+---------------+---------------+------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/is-not-null/','','https://mariadb.com/kb/en/library/is-not-null/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (236,18,'IS NULL','Syntax\n------ \nIS NULL\n \nDescription\n----------- \nTests whether a value is NULL. See also NULL Values in\nMariaDB.\n \nExamples\n-------- \nSELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n+-----------+-----------+--------------+\n| 1 IS NULL | 0 IS NULL | NULL IS NULL |\n+-----------+-----------+--------------+\n| 0 | 0 | 1 |\n+-----------+-----------+--------------+\n \nCompatibility\n \nSome ODBC applications use the syntax auto_increment_field\nIS NOT NULL to find the latest row that was inserted with an\nautogenerated key value. If your applications need this, you\ncan set the sql_auto_is_null variable to 1.\n \nSET @@sql_auto_is_null=1;\nCREATE TABLE t1 (auto_increment_column INT NOT NULL\nAUTO_INCREMENT PRIMARY KEY);\nINSERT INTO t1 VALUES (NULL);\nSELECT * FROM t1 WHERE auto_increment_column IS NULL;\n \n+-----------------------+\n| auto_increment_column |\n+-----------------------+\n| 1 |\n+-----------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/is-null/','','https://mariadb.com/kb/en/library/is-null/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (237,18,'ISNULL','Syntax\n------ \nISNULL(expr)\n \nDescription\n----------- \nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n \nSee also NULL Values in MariaDB.\n \nExamples\n-------- \nSELECT ISNULL(1+1);\n+-------------+\n| ISNULL(1+1) |\n+-------------+\n| 0 |\n+-------------+\n \nSELECT ISNULL(1/0);\n+-------------+\n| ISNULL(1/0) |\n+-------------+\n| 1 |\n+-------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/isnull/','','https://mariadb.com/kb/en/library/isnull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (238,18,'LEAST','Syntax\n------ \nLEAST(value1,value2,...)\n \nDescription\n----------- \nWith two or more arguments, returns the smallest\n(minimum-valued)\nargument. The arguments are compared using the following\nrules:\nIf the return value is used in an INTEGER context or all\narguments are integer-valued, they are compared as integers.\nIf the return value is used in a REAL context or all\narguments are real-valued, they are compared as reals.\nIf any argument is a case-sensitive string, the arguments\nare compared as case-sensitive strings.\nIn all other cases, the arguments are compared as\ncase-insensitive strings.\n \nLEAST() returns NULL if any argument is NULL.\n \nExamples\n-------- \nSELECT LEAST(2,0);\n+------------+\n| LEAST(2,0) |\n+------------+\n| 0 |\n+------------+\n \nSELECT LEAST(34.0,3.0,5.0,767.0);\n+---------------------------+\n| LEAST(34.0,3.0,5.0,767.0) |\n+---------------------------+\n| 3.0 |\n+---------------------------+\n \nSELECT LEAST(\'B\',\'A\',\'C\');\n+--------------------+\n| LEAST(\'B\',\'A\',\'C\') |\n+--------------------+\n| A |\n+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/least/','','https://mariadb.com/kb/en/library/least/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (239,18,'NOT BETWEEN','Syntax\n------ \nexpr NOT BETWEEN min AND max\n \nDescription\n----------- \nThis is the same as NOT (expr BETWEEN min AND max).\n \nNote that the meaning of the alternative form NOT expr\nBETWEEN min AND max is affected by the HIGH_NOT_PRECEDENCE\nSQL_MODE flag.\n \nExamples\n-------- \nSELECT 1 NOT BETWEEN 2 AND 3;\n+-----------------------+\n| 1 NOT BETWEEN 2 AND 3 |\n+-----------------------+\n| 1 |\n+-----------------------+\n \nSELECT \'b\' NOT BETWEEN \'a\' AND \'c\';\n+-----------------------------+\n| \'b\' NOT BETWEEN \'a\' AND \'c\' |\n+-----------------------------+\n| 0 |\n+-----------------------------+\n \nNULL:\n \nSELECT 1 NOT BETWEEN 1 AND NULL;\n+--------------------------+\n| 1 NOT BETWEEN 1 AND NULL |\n+--------------------------+\n| NULL |\n+--------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/not-between/','','https://mariadb.com/kb/en/library/not-between/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (240,18,'NOT IN','Syntax\n------ \nexpr NOT IN (value,...)\n \nDescription\n----------- \nThis is the same as NOT (expr IN (value,...)).\n \nExamples\n-------- \nSELECT 2 NOT IN (0,3,5,7);\n+--------------------+\n| 2 NOT IN (0,3,5,7) |\n+--------------------+\n| 1 |\n+--------------------+\n \nSELECT \'wefwf\' NOT IN (\'wee\',\'wefwf\',\'weg\');\n+--------------------------------------+\n| \'wefwf\' NOT IN (\'wee\',\'wefwf\',\'weg\') |\n+--------------------------------------+\n| 0 |\n+--------------------------------------+\n \nSELECT 1 NOT IN (\'1\', \'2\', \'3\');\n+--------------------------+\n| 1 NOT IN (\'1\', \'2\', \'3\') |\n+--------------------------+\n| 0 |\n+--------------------------+\n \nNULL:\n \nSELECT NULL NOT IN (1, 2, 3);\n+-----------------------+\n| NULL NOT IN (1, 2, 3) |\n+-----------------------+\n| NULL |\n+-----------------------+\n \nSELECT 1 NOT IN (1, 2, NULL);\n+-----------------------+\n| 1 NOT IN (1, 2, NULL) |\n+-----------------------+\n| 0 |\n+-----------------------+\n \nSELECT 5 NOT IN (1, 2, NULL);\n+-----------------------+\n| 5 NOT IN (1, 2, NULL) |\n+-----------------------+\n| NULL |\n+-----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/not-in/','','https://mariadb.com/kb/en/library/not-in/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (241,19,'Operator Precedence','The precedence is the order in which the SQL operators are\nevaluated.\n \nThe following list shows the SQL operator precedence.\nOperators that appear first in the list have a higher\nprecedence. Operators which are listed together have the\nsame precedence.\nINTERVAL\nBINARY, COLLATE\n!\n- (unary minus), [[bitwise-not|]] (unary bit inversion)\n|| (string concatenation)\n^\n*, /, DIV, %, MOD\n-, +\n \n&\n|\n= (comparison), , >=, >, \n\nURL: https://mariadb.com/kb/en/library/operator-precedence/','','https://mariadb.com/kb/en/library/operator-precedence/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (242,19,'&amp;','Syntax\n------ \n&\n \nDescription\n----------- \nBitwise AND. Converts the values to binary and compares\nbits. Only if both the corresponding bits are 1 is the\nresulting bit also 1.\n \nSee also bitwise OR.\n \nExamples\n-------- \nSELECT 2&1;\n+-----+\n| 2&1 |\n+-----+\n| 0 |\n+-----+\n \nSELECT 3&1;\n+-----+\n| 3&1 |\n+-----+\n| 1 |\n+-----+\n \nSELECT 29 & 15;\n+---------+\n| 29 & 15 |\n+---------+\n| 13 |\n+---------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/bitwise_and/','','https://mariadb.com/kb/en/library/bitwise_and/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (243,19,'&lt;&lt;','Syntax\n------ \nvalue1 \n\nURL: https://mariadb.com/kb/en/library/shift-left/','','https://mariadb.com/kb/en/library/shift-left/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (244,19,'&gt;&gt;','Syntax\n------ \nvalue1 >> value2\n \nDescription\n----------- \nConverts a longlong (BIGINT) number (value1) to binary and\nshifts value2 units to the right.\n \nExamples\n-------- \nSELECT 4 >> 2;\n+--------+\n| 4 >> 2 |\n+--------+\n| 1 |\n+--------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/shift-right/','','https://mariadb.com/kb/en/library/shift-right/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (245,19,'BIT_COUNT','Syntax\n------ \nBIT_COUNT(N)\n \nDescription\n----------- \nReturns the number of bits that are set in the argument N.\n \nExamples\n-------- \nSELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n+---------------+----------------------+\n| BIT_COUNT(29) | BIT_COUNT(b\'101010\') |\n+---------------+----------------------+\n| 4 | 3 |\n+---------------+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/bit_count/','','https://mariadb.com/kb/en/library/bit_count/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (246,19,'^','Syntax\n------ \n^\n \nDescription\n----------- \nBitwise XOR. Converts the values to binary and compares\nbits. If one (and only one) of the corresponding bits is 1\nis the resulting bit also 1.\n \nExamples\n-------- \nSELECT 1 ^ 1;\n+-------+\n| 1 ^ 1 |\n+-------+\n| 0 |\n+-------+\n \nSELECT 1 ^ 0;\n+-------+\n| 1 ^ 0 |\n+-------+\n| 1 |\n+-------+\n \nSELECT 11 ^ 3;\n+--------+\n| 11 ^ 3 |\n+--------+\n| 8 |\n+--------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/bitwise-xor/','','https://mariadb.com/kb/en/library/bitwise-xor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (247,19,'|','Syntax\n------ \n|\n \nDescription\n----------- \nBitwise OR. Converts the values to binary and compares bits.\nIf either of the corresponding bits has a value of 1, the\nresulting bit is also 1.\n \nSee also bitwise AND.\n \nExamples\n-------- \nSELECT 2|1;\n+-----+\n| 2|1 |\n+-----+\n| 3 |\n+-----+\n \nSELECT 29 | 15;\n+---------+\n| 29 | 15 |\n+---------+\n| 31 |\n+---------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/bitwise-or/','','https://mariadb.com/kb/en/library/bitwise-or/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (248,19,'~','Syntax\n------ \n~\n \nDescription\n----------- \nBitwise NOT. Converts the value to 4 bytes binary and\ninverts all bits.\n \nExamples\n-------- \nSELECT 3 & ~1;\n+--------+\n| 3 & ~1 |\n+--------+\n| 2 |\n+--------+\n \nSELECT 5 & ~1;\n+--------+\n| 5 & ~1 |\n+--------+\n| 4 |\n+--------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/bitwise-not/','','https://mariadb.com/kb/en/library/bitwise-not/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (249,19,'Parentheses','Parentheses are sometimes called precedence operators - this\nmeans that they can be used to change the other operator\'s\nprecedence in an expression. The expressions that are\nwritten between parentheses are computed before the\nexpressions that are written outside. Parentheses must\nalways contain an expression (that is, they cannot be\nempty), and can be nested.\n \nFor example, the following expressions could return\ndifferent results:\nNOT a OR b\nNOT (a OR b)\n \nIn the first case, NOT applies to a, so if a is FALSE or b\nis TRUE, the expression returns TRUE. In the second case,\nNOT applies to the result of a OR b, so if at least one of a\nor b is TRUE, the expression is TRUE.\n \nWhen the precedence of operators is not intuitive, you can\nuse parentheses to make it immediately clear for whoever\nreads the statement.\n \nThe precedence of the NOT operator can also be affected by\nthe HIGH_NOT_PRECEDENCE SQL_MODE flag.\n \nOther uses\n \nParentheses must always be used to enclose subqueries.\n \nParentheses can also be used in a JOIN statement between\nmultiple tables to determine which tables must be joined\nfirst.\n \nAlso, parentheses are used to enclose the list of parameters\nto be passed to built-in functions, user-defined functions\nand stored routines. However, when no parameter is passed to\na stored procedure, parentheses are optional. For builtin\nfunctions and user-defined functions, spaces are not allowed\nbetween the function name and the open parenthesis, unless\nthe IGNORE_SPACE SQL_MODE is set. For stored routines (and\nfor functions if IGNORE_SPACE is set) spaces are allowed\nbefore the open parenthesis, including tab characters and\nnew line characters.\n \nSyntax errors\n \nIf there are more open parentheses than closed parentheses,\nthe error usually looks like this:\n \nERROR 1064 (42000): You have an error in your SQL syntax;\ncheck the manual that\ncorresponds to your MariaDB server version for the right\nsyntax to use near \'\' a\nt line 1\n \nNote the empty string.\n \nIf there are more closed parentheses than open parentheses,\nthe error usually looks like this:\n \nERROR 1064 (42000): You have an error in your SQL syntax;\ncheck the manual that\ncorresponds to your MariaDB server version for the right\nsyntax to use near \')\'\nat line 1\n \nNote the quoted closed parenthesis.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/parentheses/','','https://mariadb.com/kb/en/library/parentheses/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (250,19,'TRUE FALSE','Description\n----------- \nThe constants TRUE and FALSE evaluate to 1 and 0,\nrespectively. The\nconstant names can be written in any lettercase.\n \nExamples\n-------- \nSELECT TRUE, true, FALSE, false;\n \n+------+------+-------+-------+\n| TRUE | TRUE | FALSE | FALSE |\n+------+------+-------+-------+\n| 1 | 1 | 0 | 0 |\n+------+------+-------+-------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/true-false/','','https://mariadb.com/kb/en/library/true-false/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (251,20,'ANALYZE TABLE','Syntax\n------ \nANALYZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE tbl_name\n[,tbl_name ...] \n [PERSISTENT FOR [ALL|COLUMNS ([col_name [,col_name ...]])] \n [INDEXES ([index_name [,index_name ...]])]] \n \nDescription\n----------- \nANALYZE TABLE analyzes and stores the key distribution for a\ntable (index statistics). During the analysis, the table is\nlocked with a read lock. This statement works with MyISAM,\nAria and InnoDB tables. For MyISAM tables, this statement is\nequivalent\nto using myisamchk --analyze.\n \nFor more information on how the analysis works within\nInnoDB, see\nInnoDB Limitations.\n \nMariaDB uses the stored key distribution to decide the order\nin which\ntables should be joined when you perform a join on something\nother than\na constant. In addition, key distributions can be used when\ndeciding\nwhich indexes to use for a specific table within a query.\n \nThis statement requires SELECT and INSERT privileges for the\ntable.\n \nBy default, ANALYZE TABLE statements are written to the\nbinary log and will be replicated. The NO_WRITE_TO_BINLOG\nkeyword (LOCAL is an alias) will ensure the statement is not\nwritten to the binary log. \n \nANALYZE TABLE is also supported for partitioned tables. You\ncan use ALTER TABLE ... ANALYZE PARTITION to analyze one or\nmore partitions.\n \nEngine-Independent Statistics\n \nMariaDB 10.0.1 extended ANALYZE TABLE to support\nengine-independent statistics.\n \nEngine-independent statistics are collected by doing full\ntable and full index scans, and collecting can be quite\nexpensive. \n \nANALYZE TABLE behavior depends on the value of the\nuse_stat_tables system variable.\n \nIf use_stat_tables is set to never (default in = MariaDB\n10.4.1), ANALYZE TABLE t will collect storage engine\nstatistics, and not engine-independent statistics.\n \nIf use_stat_tables is set to complementary or preferably,\nANALYZE TABLE t will collect engine-independent statistics. \n \nIn order to collect engine-independent statistics when\nuse_stat_tables is not set to one of the above two values\n(it is not by default), the extended form of ANALYZE TABLE,\nusing PERSISTENT FOR, must be used. This also allows one to\ncollect statistics only for particular columns or indexes.\nNote that engine-independent statistics are used by default\nfrom MariaDB 10.4 (use_stat_tables=preferably_for_queries),\nso you will probably want to use PERSISTENT FOR.\n \nIt is recommended to collect engine-independent statistics\non as-needed basis, so typically one will not have\nengine-independent statistics for all indexes/all columns. \n \nNote that statistics for blob and text columns are not\ncollected. If explicitly specified, a warning is returned.\n \n-- update all engine-independent statistics for all columns\nand indexes\nANALYZE TABLE tbl PERSISTENT FOR ALL;\n \n-- update specific columns and indexes:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS (col1,col2,...)\nINDEXES (idx1,idx2,...);\n \n-- empty lists are allowed:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS (col1,col2,...)\nINDEXES ();\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS () INDEXES\n(idx1,idx2,...);\n \n-- the following will only update mysql.table_stat fields:\nANALYZE TABLE tbl PERSISTENT FOR COLUMNS () INDEXES ();\n \n-- with use_stat_tables = COMPLEMENTARY, a simple ANALYZE\nTABLE \n-- collects engine-independent statistics for all columns\nand indexes.\nSET SESSION use_stat_tables=\'COMPLEMENTARY\';\n \nANALYZE TABLE tbl;\n \nThe PERSISTENT FOR is required to update the\nengine-independent statistics even if the table has the\noption STATS_PERSISTENT=1 (which refers to InnoDB Persistent\nStatistics).\n \nThe Aria storage engine supports progress reporting for the\nANALYZE TABLE statement.\n \n\n\nURL: https://mariadb.com/kb/en/library/analyze-table/','','https://mariadb.com/kb/en/library/analyze-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (252,20,'CHECK TABLE','Syntax\n------ \nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n \noption = {FOR UPGRADE | QUICK | FAST | MEDIUM | EXTENDED |\nCHANGED}\n \nDescription\n----------- \nCHECK TABLE checks a table or tables for errors. CHECK TABLE\nworks for\nArchive, Aria, CSV, InnoDB, and MyISAM tables. For Aria and\nMyISAM tables, the\nkey statistics are updated as well. For CSV, see also\nChecking and Repairing CSV Tables.\n \nAs an alternative, myisamchk is a commandline tool for\nchecking MyISAM tables when the tables are not being\naccessed.\n \nFor checking dynamic columns integrity, COLUMN_CHECK() can\nbe used.\n \nCHECK TABLE can also check views for problems, such as\ntables\nthat are referenced in the view definition that no longer\nexist.\n \nCHECK TABLE is also supported for partitioned tables. You\ncan\nuse ALTER TABLE ... CHECK PARTITION \nto check one or more partitions.\n \nThe meaning of the different options are as follows - note\nthat this can vary a bit between\nstorage engines:\n \nFOR UPGRADE | Do a very quick check if the storage format\nfor the table has changed so that one needs to do a REPAIR.\nThis is only needed when one upgrades between major versions\nof MariaDB or MySQL. This is usually done by running\nmysql_upgrade. | \n \nFAST | Only check tables that has not been closed properly\nor are marked as corrupt. Only supported by the MyISAM and\nAria engines. For other engines the table is checked\nnormally | \n \nCHANGED | Check only tables that has changed since last\nREPAIR / CHECK. Only supported by the MyISAM and Aria\nengines. For other engines the table is checked normally. | \n \nQUICK | Do a fast check. For MyISAM and Aria engine this\nmeans we skip checking the delete link chain which may take\nsome time. | \n \nMEDIUM | Scan also the data files. Checks integrity between\ndata and index files with checksums. In most cases this\nshould find all possible errors. | \n \nEXTENDED | Does a full check to verify every possible error.\nFor MyISAM and Aria we verify for each row that all it keys\nexists and points to the row. This may take a long time on\nbig tables! | \n \nFor most cases running CHECK TABLE without options or MEDIUM\nshould be\ngood enough.\n \nSince MariaDB 5.3, the Aria storage engine supports progress\nreporting for this statement.\n \nIf you want to know if two tables are identical, take a look\nat CHECKSUM TABLE.\n \nXtraDB/InnoDB\n \nIf CHECK TABLE finds an error in an InnoDB table, MariaDB\nmight shutdown to prevent the error propagation. In this\ncase, the problem will be reported in the error log.\nOtherwise, since MariaDB 5.5, the table or an index might be\nmarked as corrupted, to prevent use. This does not happen\nwith some minor problems, like a wrong number of entries in\na secondary index. Those problems are reported in the output\nof CHECK TABLE.\n \nEach tablespace contains a header with metadata. This header\nis not checked by this statement.\n \nDuring the execution of CHECK TABLE, other threads may be\nblocked.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/sql-commands-check-table/','','https://mariadb.com/kb/en/library/sql-commands-check-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (253,20,'CHECK VIEW','CHECK VIEW was introduced in MariaDB 10.0.18.\n \nSyntax\n------ \nCHECK VIEW view_name\n \nDescription\n----------- \nThe CHECK VIEW statement was introduced in MariaDB 10.0.18\nto assist with fixing MDEV-6916, an issue introduced in\nMariaDB 5.2 where the view algorithms were swapped. It\nchecks whether the view algorithm is correct. It is run as\npart of mysql_upgrade, and should not normally be required\nin regular use.\n \n\n\nURL: https://mariadb.com/kb/en/library/check-view/','','https://mariadb.com/kb/en/library/check-view/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (254,20,'CHECKSUM TABLE','Syntax\n------ \nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED\n]\n \nDescription\n----------- \nCHECKSUM TABLE reports a table checksum. This is very\nuseful if you want to know if two tables are the same (for\nexample on a master\nand slave).\n \nWith QUICK, the live table checksum is reported if it is\navailable, or NULL otherwise. This is very fast. A live\nchecksum is enabled by specifying the CHECKSUM=1 table\noption when you create the table; currently, this is\nsupported\nonly for Aria and MyISAM tables.\n \nWith EXTENDED, the entire table is read row by row and the\nchecksum is calculated. This can be very slow for large\ntables.\n \nIf neither QUICK nor EXTENDED is\nspecified, MariaDB returns a live checksum if the table\nstorage engine supports\nit and scans the table otherwise.\n \nCHECKSUM TABLE requires the SELECT privilege for the table.\n \nFor a nonexistent table, CHECKSUM TABLE returns\nNULL and generates a warning.\n \nThe table row format affects the checksum value. If the row\nformat changes, the checksum will change. This means that\nwhen a table created with a MariaDB/MySQL version is\nupgraded to another version, the checksum value will\nprobably change.\n \nTwo identical tables should always match to the same\nchecksum value; however, also for non-identical tables there\nis a very slight chance that they will return the same value\nas the hashing algorithm is not completely collision-free.\n \nDifferences Between MariaDB and MySQL\n \nCHECKSUM TABLE may give a different result as MariaDB\ndoesn\'t\nignore NULLs in the columns as MySQL 5.1 does (Later MySQL\nversions should calculate checksums the same way as\nMariaDB). You can get the\n\'old style\' checksum in MariaDB by starting mysqld with\nthe\n--old option. Note however that that the MyISAM and Aria\nstorage engines in MariaDB are using the new checksum\ninternally, so if you are\nusing --old, the CHECKSUM command will be\nslower as it needs to calculate the checksum row by row.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/checksum-table/','','https://mariadb.com/kb/en/library/checksum-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (255,20,'OPTIMIZE TABLE','Syntax\n------ \nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n tbl_name [, tbl_name] ...\n [WAIT n | NOWAIT]\n \nDescription\n----------- \nOPTIMIZE TABLE has two main functions. It can either be used\nto defragment tables, or to update the InnoDB fulltext\nindex.\n \nWAIT/NOWAIT\n \nSet the lock wait timeout. See WAIT and NOWAIT.\n \nDefragmenting\n \nOPTIMIZE TABLE works for InnoDB (before MariaDB 10.1.1, only\nif the innodb_file_per_table server system variable is set),\nAria, MyISAM and ARCHIVE tables, and should be used if you\nhave deleted a large part of a table or if you have made\nmany changes to a table with variable-length\nrows (tables that have VARCHAR, VARBINARY, BLOB, or TEXT\ncolumns). Deleted rows are maintained in a\nlinked list and subsequent INSERT operations reuse old row\npositions.\n \nThis statement requires SELECT and INSERT privileges for the\ntable.\n \nBy default, OPTIMIZE TABLE statements are written to the\nbinary log and will be replicated. The NO_WRITE_TO_BINLOG\nkeyword (LOCAL is an alias) will ensure the statement is not\nwritten to the binary log. \n \nOPTIMIZE TABLE is also supported for partitioned tables. You\ncan use \nALTER TABLE ... OPTIMIZE PARTITION \nto optimize one or more partitions.\n \nYou can use OPTIMIZE TABLE to reclaim the unused\nspace and to defragment the data file. With other storage\nengines, OPTIMIZE TABLE does nothing by default, and returns\nthis message: \" The storage engine for the table doesn\'t\nsupport optimize\". However, if the server has been started\nwith the --skip-new option, OPTIMIZE TABLE is linked to\nALTER TABLE, and recreates the table. This operation frees\nthe unused space and updates index statistics.\n \nSince MariaDB 5.3, the Aria storage engine supports progress\nreporting for this statement.\n \nIf a MyISAM table is fragmented, concurrent inserts will not\nbe performed until an OPTIMIZE TABLE statement is executed\non that table, unless the concurrent_insert server system\nvariable is set to ALWAYS.\n \nUpdating an InnoDB fulltext index\n \nWhen rows are added or deleted to an InnoDB fulltext index,\nthe index is not immediately re-organized, as this can be an\nexpensive operation. Change statistics are stored in a\nseparate location . The fulltext index is only fully\nre-organized when an OPTIMIZE TABLE statement is run.\n \nBy default, an OPTIMIZE TABLE will defragment a table. In\norder to use it to update fulltext index statistics, the\ninnodb_optimize_fulltext_only system variable must be set to\n1. This is intended to be a temporary setting, and should be\nreset to 0 once the fulltext index has been re-organized.\n \nSince fulltext re-organization can take a long time, the\ninnodb_ft_num_word_optimize variable limits the\nre-organization to a number of words (2000 by default). You\ncan run multiple OPTIMIZE statements to fully re-organize\nthe index.\n \nDefragmenting InnoDB tablespaces\n \nMariaDB 10.1.1 merged the Facebook/Kakao defragmentation\npatch \n \nMariaDB 10.1.1 merged the Facebook/Kakao defragmentation\npatch, allowing one to use OPTIMIZE TABLE to defragment\nInnoDB tablespaces. For this functionality to be enabled,\nthe innodb_defragment system variable must be enabled. No\nnew tables are created and there is no need to copy data\nfrom old tables to new tables. Instead, this feature loads n\npages (determined by innodb-defragment-n-pages) and tries to\nmove records so that pages would be full of records and then\nfrees pages that are fully empty after the operation. Note\nthat tablespace files (including ibdata1) will not shrink as\nthe result of defragmentation, but one will get better\nmemory utilization in the InnoDB buffer pool as there are\nfewer data pages in use.\n \nSee Defragmenting InnoDB Tablespaces for more details.\n \n\n\nURL: https://mariadb.com/kb/en/library/optimize-table/','','https://mariadb.com/kb/en/library/optimize-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (256,20,'REPAIR TABLE','Syntax\n------ \nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n tbl_name [, tbl_name] ...\n [QUICK] [EXTENDED] [USE_FRM]\n \nDescription\n----------- \nREPAIR TABLE repairs a possibly corrupted table. By default,\nit has the same effect as\n \nmyisamchk --recover tbl_name\n \nor\n \naria_chk --recover tbl_name\n \nSee aria_chk and myisamchk for more.\n \nREPAIR TABLE works for Archive, Aria, CSV and MyISAM tables.\nFor XtraDB/InnoDB, see recovery modes. For CSV, see also\nChecking and Repairing CSV Tables. For Archive, this\nstatement also improves compression. If the storage engine\ndoes not support this statement, a warning is issued.\n \nThis statement requires SELECT and INSERT privileges for the\ntable.\n \nBy default, REPAIR TABLE statements are written to the\nbinary log and will be replicated. The NO_WRITE_TO_BINLOG\nkeyword (LOCAL is an alias) will ensure the statement is not\nwritten to the binary log.\n \nWhen an index is recreated, the storage engine may use a\nconfigurable buffer in the process. Incrementing the buffer\nspeeds up the index creation. Aria and MyISAM allocate a\nbuffer whose size is defined by aria_sort_buffer_size or\nmyisam_sort_buffer_size, also used for ALTER TABLE.\n \nREPAIR TABLE is also supported for partitioned tables.\nHowever, the USE_FRM option cannot be used with this\nstatement\non a partitioned table.\n \n ALTER TABLE ... REPAIR PARTITION can be used\nto repair one or more partitions.\n \nThe Aria storage engine supports progress reporting for this\nstatement.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/repair-table/','','https://mariadb.com/kb/en/library/repair-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (257,20,'REPAIR VIEW','REPAIR VIEW was introduced in MariaDB 10.0.18 and MariaDB\n5.5.43.\n \nSyntax\n------ \nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] VIEW view_name[,\nview_name] ... [FROM MYSQL]\n \nDescription\n----------- \nThe REPAIR VIEW statement was introduced to assist with\nfixing MDEV-6916, an issue introduced in MariaDB 5.2 where\nthe view algorithms were swapped compared to their MySQL on\ndisk representation. It checks whether the view algorithm is\ncorrect. It is run as part of mysql_upgrade, and should not\nnormally be required in regular use.\n \nBy default it corrects the checksum and if necessary adds\nthe mariadb-version field. If the optional FROM MYSQL clause\nis used, and no mariadb-version field is present, the MERGE\nand TEMPTABLE algorithms are toggled.\n \nBy default, REPAIR VIEW statements are written to the binary\nlog and will be replicated. The NO_WRITE_TO_BINLOG keyword\n(LOCAL is an alias) will ensure the statement is not written\nto the binary log.\n \nNote that REPAIR VIEW in MariaDB 10.0.18 and MariaDB 5.5.43\ncould crash the server (see MDEV-8115). Upgrade to a later\nversion.\n \n\n\nURL: https://mariadb.com/kb/en/library/repair-view/','','https://mariadb.com/kb/en/library/repair-view/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (258,21,'CREATE FUNCTION UDF','Syntax\n------ \nCREATE [OR REPLACE] [AGGREGATE] FUNCTION [IF NOT EXISTS]\nfunction_name\n RETURNS {STRING|INTEGER|REAL|DECIMAL}\n SONAME shared_library_name\n \nDescription\n----------- \nA user-defined function (UDF) is a way to extend MariaDB\nwith a new function\nthat works like a native (built-in) MariaDB function such as\nABS() or\nCONCAT().\n \nfunction_name is the name that should be used in SQL\nstatements to invoke\nthe function. \n \nTo create a function, you must have the INSERT privilege for\nthe\nmysql database. This is necessary because CREATE FUNCTION\nadds a row to the\nmysql.func system table that records the function\'s name,\ntype, and shared library name. If you do not have this\ntable, you should run\nthe mysql_upgrade command to create it.\n \nUDFs need to be written in C, C++ or another language that\nuses C calling\nconventions, MariaDB needs to have been dynamically\ncompiled, and your\noperating system must support dynamic loading.\n \nFor an example, see sql/udf_example.cc in the source tree.\nFor a collection of existing UDFs see\nhttp://www.mysqludf.org/.\n \nStatements making use of user-defined functions are not\nsafe for replication.\n \nFor creating a stored function as opposed to a user-defined\nfunction, see\nCREATE FUNCTION.\n \nFor valid identifiers to use as function names, see\nIdentifier Names.\n \nRETURNS\n \nThe RETURNS clause indicates the type of the function\'s\nreturn value, and can be one of STRING, INTEGER, REAL or\nDECIMAL. DECIMAL functions currently return string values\nand should be written like STRING functions.\n \nshared_library_name\n \nshared_library_name is the basename of the shared object\nfile that contains\nthe code that implements the function. The file must be\nlocated in the plugin\ndirectory. This directory is given by the value of the\nplugin_dir system variable. Note that\nbefore MariaDB/MySQL 5.1, the shared object could be located\nin any directory\nthat was searched by your system\'s dynamic linker.\n \nAGGREGATE\n \nAggregate functions are summary functions such as SUM() and\nAVG().\n \nAggregate UDF functions can be used as window functions.\n \nOR REPLACE\n \nThe OR REPLACE clause was added in MariaDB 10.1.3\n \nIf the optional OR REPLACE clause is used, it acts as a\nshortcut for:\n \nDROP FUNCTION IF EXISTS function_name;\n \nCREATE FUNCTION name ...;\n \nIF NOT EXISTS\n \nThe IF NOT EXISTS clause was added in MariaDB 10.1.3\n \nWhen the IF NOT EXISTS clause is used, MariaDB will return a\nwarning instead of an error if the specified function\nalready exists. Cannot be used together with OR REPLACE.\n \nUpgrading a UDF\n \nTo upgrade the UDF\'s shared library, first run a\nDROP FUNCTION statement, then upgrade the shared library and\nfinally run the CREATE FUNCTION statement. If you upgrade\nwithout following\nthis process, you may crash the server.\n \nExamples\n-------- \nCREATE FUNCTION jsoncontains_path RETURNS integer SONAME\n\'ha_connect.so\';\n \nQuery OK, 0 rows affected (0.00 sec)\n \nOR REPLACE and IF NOT EXISTS:\n \nCREATE FUNCTION jsoncontains_path RETURNS integer SONAME\n\'ha_connect.so\';\n \nERROR 1125 (HY000): Function \'jsoncontains_path\' already\nexists\n \nCREATE OR REPLACE FUNCTION jsoncontains_path RETURNS integer\nSONAME \'ha_connect.so\';\n \nQuery OK, 0 rows affected (0.00 sec)\n \nCREATE FUNCTION IF NOT EXISTS jsoncontains_path RETURNS\ninteger SONAME \'ha_connect.so\';\n \nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+-------+------+---------------------------------------------+\n| Level | Code | Message |\n+-------+------+---------------------------------------------+\n| Note | 1125 | Function \'jsoncontains_path\' already\nexists |\n+-------+------+---------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/create-function-udf/','','https://mariadb.com/kb/en/library/create-function-udf/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (259,21,'DROP FUNCTION UDF','Syntax\n------ \nDROP FUNCTION [IF EXISTS] function_name\n \nDescription\n----------- \nThis statement drops the user-defined function (UDF) named\nfunction_name.\n \nTo drop a function, you must have the DELETE privilege for\nthe mysql database. This is because DROP FUNCTION removes\nthe row from the mysql.func system table that records the\nfunction\'s name, type and shared library name.\n \nFor dropping a stored function, see DROP FUNCTION.\n \nUpgrading a UDF\n \nTo upgrade the UDF\'s shared library, first run a DROP\nFUNCTION statement, then upgrade the shared library and\nfinally run the CREATE FUNCTION statement. If you upgrade\nwithout following this process, you may crash the server.\n \nExamples\n-------- \nDROP FUNCTION jsoncontains_path;\n \nIF EXISTS:\n \nDROP FUNCTION jsoncontains_path;\n \nERROR 1305 (42000): FUNCTION test.jsoncontains_path does not\nexist\n \nDROP FUNCTION IF EXISTS jsoncontains_path;\n \nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+-------+------+------------------------------------------------+\n| Level | Code | Message |\n+-------+------+------------------------------------------------+\n| Note | 1305 | FUNCTION test.jsoncontains_path does not\nexist |\n+-------+------+------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/drop-function-udf/','','https://mariadb.com/kb/en/library/drop-function-udf/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (260,21,'Creating User-Defined Functions','User-defined functions allow MariaDB to be extended with a\nnew function that works like a native (built-in) MariaDB\nfunction such as ABS() or CONCAT(). There are alternative\nways to add a new function: writing a native function (which\nrequires modifying and compiling the server source code), or\nwriting a stored function.\n \nStatements making use of user-defined functions are not safe\nfor replication.\n \nFunctions are written in C or C++, and to make use of them,\nthe operating system must support dynamic loading. \n \nEach new SQL function requires corresponding functions\nwritten in C/C++. In the list below, at least the main\nfunction - x() - and one other, are required. x should be\nreplaced by the name of the function you are creating.\n \nAll functions need to be thread-safe, so not global or\nstatic variables that change can be allocated. Memory is\nallocated in x_init()/ and freed in x_deinit(). \n \nSimple Functions\n \nx()\n \nRequired for all UDF\'s, this is where the results are\ncalculated.\n \nC/C++ type | SQL type | \n \nchar * | STRING | \n \nlong long | INTEGER | \n \ndouble | REAL | \n \nDECIMAL functions return string values, and so should be\nwritten accordingly. It is not possible to create ROW\nfunctions.\n \nx_init()\n \nInitialization function for x(). Can be used for the\nfollowing:\nCheck the number of arguments to X() (the SQL equivalent).\nVerify the argument types, or to force arguments to be of a\nparticular type after the function is called.\nSpecify whether the result can be NULL.\nSpecify the maximum result length.\nFor REAL functions, specify the maximum number of decimals\nfor the result.\nAllocate any required memory.\n To verify that the arguments are of a required type or,\nalternatively, to tell MySQL to coerce arguments to the\nrequired types when the main function is called.\n \nx_deinit()\n \nDe-initialization function for x(). Used to de-allocate\nmemory that was allocated in x_init().\n \nDescription\n----------- \nEach time the SQL function X() is called:\nMariaDB will first call the C/C++ initialization function,\nx_init(), assuming it exists. All setup will be performed,\nand if it returns an error, the SQL statement is aborted and\nno further functions are called.\nIf there is no x_init() function, or it has been called and\ndid not return an error, x() is then called once per row.\nAfter all rows have finished processing, x_deinit() is\ncalled, if present, to clean up by de-allocating any memory\nthat was allocated in x_init().\nSee User-defined Functions Calling Sequences for more\ndetails on the functions.\n \nAggregate Functions\n \nThe following functions are required for aggregate\nfunctions, such as AVG() and SUM(). \n \nx_clear()\n \nUsed to reset the current aggregate, but without inserting\nthe argument as the initial aggregate value for the new\ngroup.\n \nx_add()\n \nUsed to add the argument to the current aggregate. \n \nx_remove()\n \nStaring from MariaDB 10.4 it improves the support of window\nfunctions (so it is not obligatory to add it) and should\nremove the argument from the current aggregate.\n \nDescription\n----------- \nEach time the aggregate SQL function X() is called:\nMariaDB will first call the C/C++ initialization function,\nx_init(), assuming it exists. All setup will be performed,\nand if it returns an error, the SQL statement is aborted and\nno further functions are called.\nIf there is no x_init() function, or it has been called and\ndid not return an error, x() is then called once per row.\nAfter all rows have finished processing, x_deinit() is\ncalled, if present, to clean up by de-allocating any memory\nthat was allocated in x_init().\n \nMariaDB will first call the C/C++ initialization function,\nx_init(), assuming it exists. All setup will be performed,\nand if it returns an error, the SQL statement is aborted and\nno further functions are called.\nThe table is sorted according to the GROUP BY expression.\nx_clear() is called for the first row of each new group.\nx_add() is called once per row for each row in the same\ngroup.\nx() is called when the group changes, or after the last row,\nto get the aggregate result. \nThe latter three steps are repeated until all rows have been\nprocessed.\nAfter all rows have finished processing, x_deinit() is\ncalled, if present, to clean up by de-allocating any memory\nthat was allocated in x_init().\n \nExamples\n-------- \nFor an example, see sql/udf_example.cc in the source tree.\nFor a collection of existing UDFs see\nhttps://github.com/mysqludf.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/creating-user-defined-functions/','','https://mariadb.com/kb/en/library/creating-user-defined-functions/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (261,21,'User-Defined Functions Calling Sequences','The functions described in Creating User-defined Functions\nare expanded on this page. They are declared as follows:\n \nSimple Functions\n \nx()\n \nIf x() returns an integer, it is declared as follows:\n \nlong long x(UDF_INIT *initid, UDF_ARGS *args,\n char *is_null, char *error);\n \nIf x() returns a string (DECIMAL functions also return\nstring values), it is declared as follows:\n \nchar *x(UDF_INIT *initid, UDF_ARGS *args,\n char *result, unsigned long *length,\n char *is_null, char *error);\n \nIf x() returns a real, it is declared as follows:\n \ndouble x(UDF_INIT *initid, UDF_ARGS *args,\n char *is_null, char *error);\n \nx_init()\n \nmy_bool x_init(UDF_INIT *initid, UDF_ARGS *args, char\n*message);\n \nx_deinit()\n \nvoid x_deinit(UDF_INIT *initid);\n \nDescription\n----------- \ninitid is a parameter passed to all three functions that\npoints to a UDF_INIT structure, used for communicating\ninformation between the functions. Its structure members\nare:\nmy_bool maybe_null\nmaybe_null should be set to 1 if x_init can return a NULL\nvalue, Defaults to 1 if any arguments are declared\nmaybe_null.\n \nunsigned int decimals\nNumber of decimals after the decimal point. The default, if\nan explicit number of decimals is passed in the arguments to\nthe main function, is the maximum number of decimals, so if\n9.5, 9.55 and 9.555 are passed to the function, the default\nwould be three (based on 9.555, the maximum). If there are\nno explicit number of decimals, the default is set to 31, or\none more than the maximum for the DOUBLE, FLOAT and DECIMAL\ntypes. This default can be changed in the function to suit\nthe actual calculation.\n \nunsigned int max_length\nMaximum length of the result. For integers, the default is\n21. For strings, the length of the longest argument. For\nreals, the default is 13 plus the number of decimals\nindicated by initid->decimals. The length includes any signs\nor decimal points. Can also be set to 65KB or 16MB in order\nto return a BLOB. The memory remains unallocated, but this\nis used to decide on the data type to use if the data needs\nto be temporarily stored.\n \nchar *ptr\nA pointer for use as required by the function. Commonly,\ninitid->ptr is used to communicate allocated memory, with\nx_init() allocating the memory and assigning it to this\npointer, x() using it, and x_deinit() de-allocating it.\n \nmy_bool const_item\nShould be set to 1 in x_init() if x() always returns the\nsame value, otherwise 0.\n \n\nAggregate Functions\n \nx_clear()\n \nx_clear() is a required function for aggregate functions,\nand is declared as follows:\n \nvoid x_clear(UDF_INIT *initid, char *is_null, char *error);\n \nIt is called when the summary results need to be reset, that\nis at the beginning of each new group. but also to reset the\nvalues when there were no matching rows.\n \nis_null is set to point to CHAR(0) before calling x_clear().\n \nIn the case of an error, you can store the value to which\nthe error argument points (a single-byte variable, not a\nstring string buffer) in the variable.\n \nx_reset()\n \nx_reset() is declared as follows:\n \nvoid x_reset(UDF_INIT *initid, UDF_ARGS *args,\n char *is_null, char *error);\n \nIt is called on finding the first row in a new group. Should\nreset the summary variables, and then use UDF_ARGS as the\nfirst value in the group\'s internal summary value. The\nfunction is not required if the UDF interface uses\nx_clear().\n \nx_add()\n \nx_add() is declared as follows:\n \nvoid x_add(UDF_INIT *initid, UDF_ARGS *args,\n char *is_null, char *error);\n \nIt is called for all rows belonging to the same group, and\nshould be used to add the value in UDF_ARGS to the internal\nsummary variable.\n \nx_remove()\n \nx_remove() was added in MariaDB 10.4 and is declared as\nfollows (same as x_add()):\n \nvoid x_remove(UDF_INIT* initid, UDF_ARGS* args,\n char* is_null, char *error );\n \nIt adds more efficient support of aggregate UDFs as window\nfunctions. x_remove() should \"subtract\" the row (reverse\nx_add()). In MariaDB 10.4 aggregate UDFs will work as WINDOW\nfunctions without x_remove() but it will not be so\nefficient.\n \nIf x_remove() supported (defined) detected automatically.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/user-defined-functions-calling-sequences/','','https://mariadb.com/kb/en/library/user-defined-functions-calling-sequences/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (262,21,'User-Defined Functions Security','The MariaDB server imposes a number of limitations on\nuser-defined functions for security purposes.\nThe INSERT privilege for the mysql database is required to\nrun CREATE FUNCTION, as a record will be added to the\nmysql.func-table.\nThe DELETE privilege for the mysql database is required to\nrun DROP FUNCTION as the corresponding record will be\nremoved from the mysql.func-table.\nUDF object files can only be placed in the plugin directory,\nas specified by the value of the plugin_dir system variable.\nAt least one symbol, beyond the required x() - corresponding\nto an SQL function X()) - is required. These can be\nx_init(), x_deinit(), xxx_reset(), x_clear() and x_add()\nfunctions (see Creating User-defined Functions). The\nallow-suspicious-udfs mysqld option (by default unset)\nprovides a workaround, permitting only one symbol to be\nused. This is not recommended, as it opens the possibility\nof loading shared objects that are not legitimate\nuser-defined functions.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/user-defined-functions-security/','','https://mariadb.com/kb/en/library/user-defined-functions-security/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (263,21,'mysql.func Table','The mysql.func table stores information about user-defined\nfunctions (UDFs) created with the CREATE FUNCTION UDF\nstatement.\n \nIn MariaDB 10.4 and later, this table uses the Aria storage\nengine.\n \nMariaDB until 10.3\n \nIn MariaDB 10.3 and before, this table uses the MyISAM\nstorage engine.\n \nThe mysql.func table contains the following fields:\n \nField | Type | Null | Key | Default | Description | \n \nname | char(64) | NO | PRI |  | UDF name | \n \nret | tinyint(1) | NO |  | 0 |  | \n \ndl | char(128) | NO |  |  | Shared library name | \n \ntype | enum(\'function\',\'aggregate\') | NO |  | NULL |\nType, either function or aggregate. Aggregate functions are\nsummary functions such as SUM() and AVG(). | \n \nExample\n \nSELECT * FROM mysql.func;\n+------------------------------+-----+--------------+-----------+\n| name | ret | dl | type |\n+------------------------------+-----+--------------+-----------+\n| spider_direct_sql | 2 | ha_spider.so | function |\n| spider_bg_direct_sql | 2 | ha_spider.so | aggregate |\n| spider_ping_table | 2 | ha_spider.so | function |\n| spider_copy_tables | 2 | ha_spider.so | function |\n| spider_flush_table_mon_cache | 2 | ha_spider.so | function\n|\n+------------------------------+-----+--------------+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/mysqlfunc-table/','','https://mariadb.com/kb/en/library/mysqlfunc-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (264,22,'AUTO_INCREMENT','Description\n----------- \nThe AUTO_INCREMENT attribute can be used to generate a\nunique identity for new rows. When you insert a new record\nto the table, and the auto_increment field is NULL or\nDEFAULT, the value will automatically be incremented. This\nalso applies to 0, unless the NO_AUTO_VALUE_ON_ZERO SQL_MODE\nis enabled.\n \nAUTO_INCREMENT columns start from 1 by default. The\nautomatically generated value can never be lower than 0.\n \nEach table can have only one AUTO_INCREMENT column. It must\ndefined as a key (not necessarily the PRIMARY KEY or UNIQUE\nkey). In some storage engines (including the default\nInnoDB), if the key consists of multiple columns, the\nAUTO_INCREMENT column must be the first column. Storage\nengines that permit the column to be placed elsewhere are\nAria, MyISAM, MERGE, Spider, TokuDB, BLACKHOLE, FederatedX\nand Federated.\n \nCREATE TABLE animals (\n id MEDIUMINT NOT NULL AUTO_INCREMENT,\n name CHAR(30) NOT NULL,\n PRIMARY KEY (id)\n );\n \nINSERT INTO animals (name) VALUES\n (\'dog\'),(\'cat\'),(\'penguin\'),\n (\'fox\'),(\'whale\'),(\'ostrich\');\n \nSELECT * FROM animals;\n \n+----+---------+\n| id | name |\n+----+---------+\n| 1 | dog |\n| 2 | cat |\n| 3 | penguin |\n| 4 | fox |\n| 5 | whale |\n| 6 | ostrich |\n+----+---------+\n \nSERIAL is an alias for BIGINT UNSIGNED NOT NULL\nAUTO_INCREMENT UNIQUE.\n \nCREATE TABLE t (id SERIAL, c CHAR(1)) ENGINE=InnoDB;\n \nSHOW CREATE TABLE t \\G\n*************************** 1. row\n***************************\n Table: t\nCreate Table: CREATE TABLE `t` (\n `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,\n `c` char(1) DEFAULT NULL,\n UNIQUE KEY `id` (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n \nSetting or Changing the Auto_Increment Value\n \nYou can use an ALTER TABLE statement to assign a new value\nto the auto_increment table option, or set the insert_id\nserver system variable to change the next AUTO_INCREMENT\nvalue inserted by the current session.\n \nLAST_INSERT_ID() can be used to see the last AUTO_INCREMENT\nvalue inserted by the current session.\n \nALTER TABLE animals AUTO_INCREMENT=8;\n \nINSERT INTO animals (name) VALUES (\'aardvark\');\n \nSELECT * FROM animals;\n \n+----+-----------+\n| id | name |\n+----+-----------+\n| 1 | dog |\n| 2 | cat |\n| 3 | penguin |\n| 4 | fox |\n| 5 | whale |\n| 6 | ostrich |\n| 8 | aardvark |\n+----+-----------+\n \nSET insert_id=12;\n \nINSERT INTO animals (name) VALUES (\'gorilla\');\n \nSELECT * FROM animals;\n \n+----+-----------+\n| id | name |\n+----+-----------+\n| 1 | dog |\n| 2 | cat |\n| 3 | penguin |\n| 4 | fox |\n| 5 | whale |\n| 6 | ostrich |\n| 8 | aardvark |\n| 12 | gorilla |\n+----+-----------+\n \nInnoDB/XtraDB\n \nUntil MariaDB 10.2.3, InnoDB and XtraDB used an\nauto-increment counter that is stored in memory. When the\nserver restarts, the counter is re-initialized to the\nhighest value used in the table, which cancels the effects\nof any AUTO_INCREMENT = N option in the table statements.\n \nFrom MariaDB 10.2.4, this restriction has been lifted and\nAUTO_INCREMENT is persistent.\n \nSee also AUTO_INCREMENT Handling in XtraDB/InnoDB.\n \nSetting Explicit Values\n \nIt is possible to specify a value for an AUTO_INCREMENT\ncolumn. The value must not exist in the key.\n \nIf the new value is higher than the current maximum value,\nthe AUTO_INCREMENT value is updated, so the next value will\nbe higher. If the new value is lower than the current\nmaximum value, the AUTO_INCREMENT value remains unchanged.\n \nThe following example demonstrates these behaviours:\n \nCREATE TABLE t (id INTEGER UNSIGNED AUTO_INCREMENT PRIMARY\nKEY) ENGINE = InnoDB;\n \nINSERT INTO t VALUES (NULL);\nSELECT id FROM t;\n \n+----+\n| id |\n+----+\n| 1 |\n+----+\n \nINSERT INTO t VALUES (10); -- higher value\nSELECT id FROM t;\n \n+----+\n| id |\n+----+\n| 1 |\n| 10 |\n+----+\n \nINSERT INTO t VALUES (2); -- lower value\nINSERT INTO t VALUES (NULL); -- auto value\nSELECT id FROM t;\n \n+----+\n| id |\n+----+\n| 1 |\n| 2 |\n| 10 |\n| 11 |\n+----+\n \nThe ARCHIVE storage engine does not allow to insert a value\nthat is lower than the current maximum.\n \nMissing Values\n \nAn AUTO_INCREMENT column normally has missing values. This\nhappens because if a row is deleted, or an AUTO_INCREMENT\nvalue is explicitly updated, old values are never re-used.\nThe REPLACE statement also deletes a row, and its value is\nwasted. With InnoDB, values can be reserved by a\ntransaction; but if the transaction fails (for example,\nbecause of a ROLLBACK) the reserved value will be lost.\n \nThus AUTO_INCREMENT values can be used to sort results in a\nchronological order, but not to create a numeric sequence.\n \nReplication\n \nTo make master-master or Galera safe to use AUTO_INCREMENT\none should use the system variables \n auto_increment_increment and auto_increment_offset to\ngenerate unique values for each server.\n \nCHECK Constraints, DEFAULT Values and Virtual Columns\n \nFrom MariaDB 10.2.6 auto_increment columns are no longer\npermitted in CHECK constraints, DEFAULT value expressions\nand virtual columns. They were permitted in earlier\nversions, but did not work correctly. See MDEV-11117.\n \n\n\nURL: https://mariadb.com/kb/en/library/auto_increment/','','https://mariadb.com/kb/en/library/auto_increment/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (265,22,'BIGINT','Syntax\n------ \nBIGINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to\n18446744073709551615.\n \nIf a column has been set to ZEROFILL, all values will be\nprepended by zeros so that the BIGINT value contains a\nnumber of M digits.\n \nNote: If the ZEROFILL attribute has been specified, the\ncolumn will automatically become UNSIGNED.\n \nFor more details on the attributes, see Numeric Data Type\nOverview.\n \nSERIAL is an alias for:\n \nBIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE\n \nExamples\n-------- \nCREATE TABLE bigints (a BIGINT,b BIGINT UNSIGNED,c BIGINT\nZEROFILL);\n \nINSERT INTO bigints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.08 sec)\nWarning (Code 1264): Out of range value for column \'b\' at\nrow 1\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO bigints VALUES (-10,10,-10);Query OK, 1 row\naffected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO bigints VALUES (-10,10,10);\n \nINSERT INTO bigints VALUES\n(9223372036854775808,9223372036854775808,9223372036854775808);\nQuery OK, 1 row affected, 1 warning (0.07 sec)\nWarning (Code 1264): Out of range value for column \'a\' at\nrow 1\n \nINSERT INTO bigints VALUES\n(9223372036854775807,9223372036854775808,9223372036854775808);\n \nSELECT * FROM bigints;\n+---------------------+---------------------+----------------------+\n| a | b | c |\n+---------------------+---------------------+----------------------+\n| -10 | 0 | 00000000000000000000 |\n| -10 | 10 | 00000000000000000000 |\n| -10 | 10 | 00000000000000000010 |\n| 9223372036854775807 | 9223372036854775808 |\n09223372036854775808 |\n| 9223372036854775807 | 9223372036854775808 |\n09223372036854775808 |\n+---------------------+---------------------+----------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/bigint/','','https://mariadb.com/kb/en/library/bigint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (266,22,'BINARY','Syntax\n------ \nBINARY(M)\n \nDescription\n----------- \nThe BINARY type is similar to the CHAR type, but stores\nbinary\nbyte strings rather than non-binary character strings. M\nrepresents the\ncolumn length in bytes.\n \nIt contains no character set, and comparison and sorting are\nbased on the numeric value of the bytes.\n \nIf the maximum length is exceeded, and SQL strict mode is\nnot enabled , the extra characters will be dropped with a\nwarning. If strict mode is enabled, an error will occur.\n \nBINARY values are right-padded with 0x00 (the zero byte) to\nthe specified length when inserted. The padding is not\nremoved on select, so this needs to be taken into account\nwhen sorting and comparing, where all bytes are significant.\nThe zero byte, 0x00 is less than a space for comparison\npurposes.\n \nExamples\n-------- \nInserting too many characters, first with strict mode off,\nthen with it on:\n \nCREATE TABLE bins (a BINARY(10));\n \nINSERT INTO bins VALUES(\'12345678901\');\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n \nSELECT * FROM bins;\n \n+------------+\n| a |\n+------------+\n| 1234567890 |\n+------------+\n \nSET sql_mode=\'STRICT_ALL_TABLES\';\n \nINSERT INTO bins VALUES(\'12345678901\');\nERROR 1406 (22001): Data too long for column \'a\' at row 1\n \nSorting is performed with the byte value:\n \nTRUNCATE bins;\n \nINSERT INTO bins VALUES(\'A\'),(\'B\'),(\'a\'),(\'b\');\n \nSELECT * FROM bins ORDER BY a;\n \n+------+\n| a |\n+------+\n| A |\n| B |\n| a |\n| b |\n+------+\n \nUsing CAST to sort as a CHAR instead:\n \nSELECT * FROM bins ORDER BY CAST(a AS CHAR);\n+------+\n| a |\n+------+\n| a |\n| A |\n| b |\n| B |\n+------+\n \nThe field is a BINARY(10), so padding of two \'\\0\'s are\ninserted, causing comparisons that don\'t take this into\naccount to fail:\n \nTRUNCATE bins;\n \nINSERT INTO bins VALUES(\'12345678\');\n \nSELECT a = \'12345678\', a = \'12345678\\0\\0\' from bins;\n \n+----------------+--------------------+\n| a = \'12345678\' | a = \'12345678\\0\\0\' |\n+----------------+--------------------+\n| 0 | 1 |\n+----------------+--------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/binary/','','https://mariadb.com/kb/en/library/binary/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (267,22,'BIT','Syntax\n------ \nBIT[(M)]\n \nDescription\n----------- \nA bit-field type. M indicates the number of bits per value,\nfrom 1 to\n64. The default is 1 if M is omitted.\n \nBit values can be inserted with b\'value\' notation, where\nvalue is the bit value in 0\'s and 1\'s.\n \nBit fields are automatically zero-padded from the left to\nthe full length of the bit, so for example in a BIT(4)\nfield, \'10\' is equivalent to \'0010\'.\n \nBits are returned as binary, so to display them, either add\n0, or use a function such as HEX, OCT or BIN to convert\nthem.\n \nExamples\n-------- \nCREATE TEMPORARY TABLE b ( b1 BIT(8) );\nINSERT INTO b VALUES\n(b\'11111111\'),(b\'01010101\'),(b\'1111111111111\');\nQuery OK, 3 rows affected, 1 warning (0.10 sec)\nRecords: 3 Duplicates: 0 Warnings: 1\n \nSHOW WARNINGS;\n+---------+------+---------------------------------------------+\n| Level | Code | Message |\n+---------+------+---------------------------------------------+\n| Warning | 1264 | Out of range value for column \'b1\' at\nrow 3 |\n+---------+------+---------------------------------------------+\n \nSELECT b1+0, HEX(b1), OCT(b1), BIN(b1) FROM b;\n+------+---------+---------+----------+\n| b1+0 | HEX(b1) | OCT(b1) | BIN(b1) |\n+------+---------+---------+----------+\n| 255 | FF | 377 | 11111111 |\n| 85 | 55 | 125 | 1010101 |\n| 255 | FF | 377 | 11111111 |\n+------+---------+---------+----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/bit/','','https://mariadb.com/kb/en/library/bit/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (268,22,'BLOB','Syntax\n------ \nBLOB[(M)]\n \nDescription\n----------- \nA BLOB column with a maximum length of 65,535 (216 - 1)\nbytes. Each\nBLOB value is stored using a two-byte length prefix that\nindicates the\nnumber of bytes in the value.\n \nAn optional length M can be given for this type. If this is\ndone,\nMariaDB creates the column as the smallest BLOB type large\nenough to\nhold values M bytes long.\n \nBLOBS can also be used to store dynamic columns.\n \nBefore MariaDB 10.2.1, BLOB and TEXT columns could not be\nassigned a DEFAULT value. This restriction was lifted in\nMariaDB 10.2.1.\n \nIndexing\n \nIn MariaDB 10.4, it is possible to set a Unique index on a\ncolumn that uses the BLOB data type. In previous releases\nthis was not possible, as the index would only guarantee the\nuniqueness of a fixed number of characters.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for\nLONGBLOB.\n \n\n\nURL: https://mariadb.com/kb/en/library/blob/','','https://mariadb.com/kb/en/library/blob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (269,22,'BLOB and TEXT Data Types','Description\n----------- \nA BLOB is a binary large object that can hold a variable\namount of\ndata. The four BLOB types are \nTINYBLOB,\nBLOB, \nMEDIUMBLOB, and\nLONGBLOB.\n \nThese differ only in the maximum length of the values they\ncan hold. \n \nThe TEXT types are \nTINYTEXT,\nTEXT,\nMEDIUMTEXT, and\nLONGTEXT.\nJSON (alias for LONGTEXT)\n \nThese correspond to the four BLOB types and have the same\nmaximum lengths and storage requirements.\n \nStarting from MariaDB 10.2.1, BLOB and TEXT columns can have\na DEFAULT value.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/blob-and-text-data-types/','','https://mariadb.com/kb/en/library/blob-and-text-data-types/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (270,22,'BOOLEAN','Syntax\n------ \nBOOL, BOOLEAN\n \nDescription\n----------- \nThese types are synonyms for TINYINT(1). \nA value of zero is considered false. Non-zero values are\nconsidered true:\n \nmysql> SELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false |\n+------------------------+\n \nmysql> SELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true |\n+------------------------+\n \nmysql> SELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true |\n+------------------------+\n \nHowever, the values TRUE and FALSE are merely aliases for 1\nand 0,\nrespectively, as shown here:\n \nmysql> SELECT IF(0 = FALSE, \'true\', \'false\');\n \n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true |\n+--------------------------------+\n \nmysql> SELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true |\n+-------------------------------+\n \nmysql> SELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false |\n+-------------------------------+\n \nmysql> SELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false |\n+--------------------------------+\n \nUNKNOWN is an alias for NULL.\n \nThe last two statements display the results shown because 2\nis equal\nto neither 1 nor 0.\n \n\n\nURL: https://mariadb.com/kb/en/library/boolean/','','https://mariadb.com/kb/en/library/boolean/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (271,22,'CHAR','This article covers the CHAR data type. See CHAR Function\nfor the function.\n \nSyntax\n------ \n[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n \nDescription\n----------- \nA fixed-length string that is always right-padded with\nspaces to the specified\nlength when stored. M represents the column length in\ncharacters. The range\nof M is 0 to 255. If M is omitted, the length is 1.\n \nCHAR(0) columns can contain 2 values: an empty string or\nNULL. Such columns cannot be part of an index. The CONNECT\nstorage engine does not support CHAR(0).\n \nNote: Trailing spaces are removed when CHAR values are\nretrieved\nunless the PAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n \nBefore MariaDB 10.2, all collations were of type PADSPACE,\nmeaning that CHAR (as well as VARCHAR and TEXT) values are\ncompared without regard for trailing spaces. This does not\napply to the LIKE pattern-matching operator, which takes\ninto account trailing spaces.\n \nIf a unique index consists of a column where trailing pad\ncharacters are stripped or ignored, inserts into that column\nwhere values differ only by the number of trailing pad\ncharacters will result in a duplicate-key error.\n \nExamples\n-------- \nTrailing spaces:\n \nCREATE TABLE strtest (c CHAR(10));\nINSERT INTO strtest VALUES(\'Maria \');\n \nSELECT c=\'Maria\',c=\'Maria \' FROM strtest;\n \n+-----------+--------------+\n| c=\'Maria\' | c=\'Maria \' |\n+-----------+--------------+\n| 1 | 1 |\n+-----------+--------------+\n \nSELECT c LIKE \'Maria\',c LIKE \'Maria \' FROM strtest;\n \n+----------------+-------------------+\n| c LIKE \'Maria\' | c LIKE \'Maria \' |\n+----------------+-------------------+\n| 1 | 0 |\n+----------------+-------------------+\n \nNO PAD Collations\n \nNO PAD collations regard trailing spaces as normal\ncharacters. You can get a list of all NO PAD collations by\nquerying the Information Schema Collations table, for\nexample:\n \nSELECT collation_name FROM information_schema.collations \n WHERE collation_name LIKE \"%nopad%\";\n \n+------------------------------+\n| collation_name |\n+------------------------------+\n| big5_chinese_nopad_ci |\n| big5_nopad_bin |\n...\n \n\n\nURL: https://mariadb.com/kb/en/library/char/','','https://mariadb.com/kb/en/library/char/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (272,22,'CHAR BYTE','Description\n----------- \nThe CHAR BYTE data type is an alias for the \nBINARY data type. This is a\ncompatibility feature.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/char-byte/','','https://mariadb.com/kb/en/library/char-byte/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (273,22,'DATE','Syntax\n------ \nDATE\n \nDescription\n----------- \nA date. The supported range is \'1000-01-01\' to\n\'9999-12-31\'. MariaDB\ndisplays DATE values in \'YYYY-MM-DD\' format, but can be\nassigned dates in looser formats, including strings or\nnumbers, as long as they make sense. These include a short\nyear, YY-MM-DD, no delimiters, YYMMDD, or any other\nacceptable delimiter, for example YYYY/MM/DD. For details,\nsee date and time literals.\n \n\'0000-00-00\' is a permitted special value (zero-date),\nunless the NO_ZERO_DATE SQL_MODE is used. Also, individual\ncomponents of a date can be set to 0 (for example:\n\'2015-00-12\'), unless the NO_ZERO_IN_DATE SQL_MODE is\nused. In many cases, the result of en expression involving a\nzero-date, or a date with zero-parts, is NULL. If the\nALLOW_INVALID_DATES SQL_MODE is enabled, if the day part is\nin the range between 1 and 31, the date does not produce any\nerror, even for months that have less than 31 days.\n \nExamples\n-------- \nCREATE TABLE t1 (d DATE);\n \nINSERT INTO t1 VALUES (\"2010-01-12\"), (\"2011-2-28\"),\n(\'120314\'),(\'13*04*21\');\n \nSELECT * FROM t1;\n \n+------------+\n| d |\n+------------+\n| 2010-01-12 |\n| 2011-02-28 |\n| 2012-03-14 |\n| 2013-04-21 |\n+------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/date/','','https://mariadb.com/kb/en/library/date/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (274,22,'DATETIME','Syntax\n------ \nDATETIME [(microsecond precision)]\n \nDescription\n----------- \nA date and time combination. The supported range is\n\'1000-01-01 00:00:00.000000\' to \'9999-12-31\n23:59:59.999999\'.\nMariaDB displays DATETIME values in \'YYYY-MM-DD HH:MM:SS\'\nformat, but\nallows assignment of values to DATETIME columns using either\nstrings or\nnumbers. For details, see date and time literals.\n \nThe microsecond precision can be from 0-6. If not specified\n0 is used.\n \n\'0000-00-00\' is a permitted special value (zero-date),\nunless the NO_ZERO_DATE SQL_MODE is used. Also, individual\ncomponents of a date can be set to 0 (for example:\n\'2015-00-12\'), unless the NO_ZERO_IN_DATE SQL_MODE is\nused. In many cases, the result of en expression involving a\nzero-date, or a date with zero-parts, is NULL. If the\nALLOW_INVALID_DATES SQL_MODE is enabled, if the day part is\nin the range between 1 and 31, the date does not produce any\nerror, even for months that have less than 31 days.\n \nSince MariaDB 10.0.1, DATETIME columns also accept\nCURRENT_TIMESTAMP as the default value.\n \nMariaDB 10.1.2 introduced the --mysql56-temporal-format\noption, on by default, which allows MariaDB to store\nDATETMEs using the same low-level format MySQL 5.6 uses. For\nmore information, see Internal Format, below.\n \nFor storage requirements, see Data Type Storage\nRequirements.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, DATE with a time portion\nis a synonym for DATETIME.\n \nInternal Format\n \nIn MariaDB 10.1.2 a new temporal format was introduced from\nMySQL 5.6 that alters how the TIME, DATETIME and TIMESTAMP\ncolumns operate at lower levels. These changes allow these\ntemporal data types to have fractional parts and negative\nvalues. You can disable this feature using the\nmysql56_temporal_format system variable.\n \nTables that include TIMESTAMP values that were created on an\nolder version of MariaDB or that were created while the\nmysql56_temporal_format system variable was disabled\ncontinue to store data using the older data type format.\n \nIn order to update table columns from the older format to\nthe newer format, execute an ALTER TABLE... MODIFY COLUMN\nstatement that changes the column to the *same* data type.\nThis change may be needed if you want to export the table\'s\ntablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n \nFor instance, if you have a DATETIME column in your table: \n \nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n \n+-------------------------+-------+\n| Variable_name | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON |\n+-------------------------+-------+\n \nALTER TABLE example_table MODIFY ts_col DATETIME;\n \nWhen MariaDB executes the ALTER TABLE statement, it converts\nthe data from the older temporal format to the newer one. \n \nIn the event that you have several tables and columns using\ntemporal data types that you want to switch over to the new\nformat, make sure the system variable is enabled, then\nperform a dump and restore using mysqldump. The columns\nusing relevant temporal data types are restored using the\nnew temporal format.\n \nExamples\n-------- \nCREATE TABLE t1 (d DATETIME);\n \nINSERT INTO t1 VALUES (\"2011-03-11\"), (\"2012-04-19\n13:08:22\"),\n (\"2013-07-18 13:44:22.123456\");\n \nSELECT * FROM t1;\n \n+---------------------+\n| d |\n+---------------------+\n| 2011-03-11 00:00:00 |\n| 2012-04-19 13:08:22 |\n| 2013-07-18 13:44:22 |\n+---------------------+\n \nCREATE TABLE t2 (d DATETIME(6));\n \nINSERT INTO t2 VALUES (\"2011-03-11\"), (\"2012-04-19\n13:08:22\"),\n (\"2013-07-18 13:44:22.123456\");\n \nSELECT * FROM t2;\n \n+----------------------------+\n| d |\n+----------------------------+\n| 2011-03-11 00:00:00.000000 |\n| 2012-04-19 13:08:22.000000 |\n| 2013-07-18 13:44:22.123456 |\n+----------------------------++\n \nStrings used in datetime context are automatically converted\nto datetime(6). If you want to have a datetime without\nseconds, you should use CONVERT(..,datetime).\n \nSELECT CONVERT(\'2007-11-30 10:30:19\',datetime);\n+-----------------------------------------+\n| CONVERT(\'2007-11-30 10:30:19\',datetime) |\n+-----------------------------------------+\n| 2007-11-30 10:30:19 |\n+-----------------------------------------+\n \nSELECT CONVERT(\'2007-11-30 10:30:19\',datetime(6));\n+--------------------------------------------+\n| CONVERT(\'2007-11-30 10:30:19\',datetime(6)) |\n+--------------------------------------------+\n| 2007-11-30 10:30:19.000000 |\n+--------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/datetime/','','https://mariadb.com/kb/en/library/datetime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (275,22,'DECIMAL','Syntax\n------ \nDECIMAL[(M[,D])] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA packed \"exact\" fixed-point number. M is the total number\nof digits (the\nprecision) and D is the number of digits after the decimal\npoint (the\nscale). The decimal point and (for negative numbers) the\n\"-\" sign are not\ncounted in M. If D is 0, values have no decimal point or\nfractional\npart and on INSERT the value will be rounded to the nearest\nDECIMAL. The maximum number of digits (M) for DECIMAL is 65.\nThe maximum number of supported decimals (D) is 30 before\nMariadB 10.2.1 and 38 afterwards. If D is omitted, the\ndefault is 0. If M is omitted, the default is 10.\n \nUNSIGNED, if specified, disallows negative values.\n \nZEROFILL, if specified, pads the number with zeros, up to\nthe total number\nof digits specified by M.\n \nAll basic calculations (+, -, *, /) with DECIMAL columns are\ndone with\na precision of 65 digits.\n \nFor more details on the attributes, see Numeric Data Type\nOverview.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, NUMBER is a synonym.\n \nExamples\n-------- \nCREATE TABLE t1 (d DECIMAL UNSIGNED ZEROFILL);\n \nINSERT INTO t1 VALUES (1),(2),(3),(4.0),(5.2),(5.7);\nQuery OK, 6 rows affected, 2 warnings (0.16 sec)\nRecords: 6 Duplicates: 0 Warnings: 2\n \nNote (Code 1265): Data truncated for column \'d\' at row 5\nNote (Code 1265): Data truncated for column \'d\' at row 6\n \nSELECT * FROM t1;\n \n+------------+\n| d |\n+------------+\n| 0000000001 |\n| 0000000002 |\n| 0000000003 |\n| 0000000004 |\n| 0000000005 |\n| 0000000006 |\n+------------+\n \nINSERT INTO t1 VALUES (-7);\nERROR 1264 (22003): Out of range value for column \'d\' at\nrow 1\n \n\n\nURL: https://mariadb.com/kb/en/library/decimal/','','https://mariadb.com/kb/en/library/decimal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (276,22,'ENUM','Syntax\n------ \nENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name]\n[COLLATE collation_name]\n \nDescription\n----------- \nAn enumeration. A string object that can have only one\nvalue, chosen\nfrom the list of values \'value1\', \'value2\', ..., NULL or\nthe special \n\'\' error value. In theory, an ENUM column can have a\nmaximum of 65,535 distinct\nvalues; in practice, the real maximum depends on many\nfactors. ENUM values are represented internally as integers.\n \nTrailing spaces are automatically stripped from ENUM values\non table creation.\n \nENUMs require relatively little storage space compared to\nstrings, either one or two bytes depending on the number of\nenumeration values.\n \nNULL and empty values\n \nAn ENUM can also contain NULL and empty values. If the ENUM\ncolumn is declared to permit NULL values, NULL becomes a\nvalid value, as well as the default value (see below). If\nstrict SQL Mode is not enabled, and an invalid value is\ninserted into an ENUM, a special empty string, with an index\nvalue of zero (see Numeric index, below), is inserted, with\na warning. This may be confusing, because the empty string\nis also a possible value, and the only difference if that in\nthis case its index is not 0. Inserting will fail with an\nerror if strict mode is active.\n \nIf a DEFAULT clause is missing, the default value will be:\nNULL is the column is nullable;\notherwise, the first value in the enumaration.\n \nNumeric index\n \nENUM values are indexed numerically in the order they are\ndefined, and sorting will be performed in this numeric\norder. We suggest not using ENUM to store numerals, as there\nis little to no storage space benefit, and it is easy to\nconfuse the enum integer with the enum numeral value by\nleaving out the quotes.\n \nAn ENUM defined as ENUM(\'apple\',\'orange\',\'pear\') would\nhave the following index values:\n \nIndex | Value | \n \nNULL | NULL | \n \n0 | \'\' | \n \n1 | \'apple\' | \n \n2 | \'orange\' | \n \n3 | \'pear\' | \n \nExamples\n-------- \nCREATE TABLE fruits (\n id INT NOT NULL auto_increment PRIMARY KEY,\n fruit ENUM(\'apple\',\'orange\',\'pear\'),\n bushels INT);\n \nDESCRIBE fruits;\n \n+---------+-------------------------------+------+-----+---------+----------------+\n| Field | Type | Null | Key | Default | Extra |\n+---------+-------------------------------+------+-----+---------+----------------+\n| id | int(11) | NO | PRI | NULL | auto_increment |\n| fruit | enum(\'apple\',\'orange\',\'pear\') | YES | | NULL\n| |\n| bushels | int(11) | YES | | NULL | |\n+---------+-------------------------------+------+-----+---------+----------------+\n \nINSERT INTO fruits\n (fruit,bushels) VALUES\n (\'pear\',20),\n (\'apple\',100),\n (\'orange\',25);\n \nINSERT INTO fruits\n (fruit,bushels) VALUES\n (\'avocado\',10);\nERROR 1265 (01000): Data truncated for column \'fruit\' at\nrow 1\n \nSELECT * FROM fruits;\n \n+----+--------+---------+\n| id | fruit | bushels |\n+----+--------+---------+\n| 1 | pear | 20 |\n| 2 | apple | 100 |\n| 3 | orange | 25 |\n+----+--------+---------+\n \nSelecting by numeric index:\n \nSELECT * FROM fruits WHERE fruit=2;\n \n+----+--------+---------+\n| id | fruit | bushels |\n+----+--------+---------+\n| 3 | orange | 25 |\n+----+--------+---------+\n \nSorting is according to the index value:\n \nCREATE TABLE enums (a ENUM(\'2\',\'1\'));\n \nINSERT INTO enums VALUES (\'1\'),(\'2\');\n \nSELECT * FROM enums ORDER BY a ASC;\n \n+------+\n| a |\n+------+\n| 2 |\n| 1 |\n+------+\n \nIt\'s easy to get confused between returning the enum\ninteger with the stored value, so we don\'t suggest using\nENUM to store numerals. The first example returns the 1st\nindexed field (\'2\' has an index value of 1, as it\'s\ndefined first), while the second example returns the string\nvalue \'1\'.\n \nSELECT * FROM enums WHERE a=1;\n \n+------+\n| a |\n+------+\n| 2 |\n+------+\n \nSELECT * FROM enums WHERE a=\'1\';\n \n+------+\n| a |\n+------+\n| 1 |\n+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/enum/','','https://mariadb.com/kb/en/library/enum/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (277,22,'DOUBLE','Syntax\n------ \nDOUBLE[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\nDOUBLE PRECISION[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\nREAL[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA normal-size (double-precision) floating-point number (see\nFLOAT for a single-precision floating-point number).\n \nAllowable values are:\n-1.7976931348623157E+308 to -2.2250738585072014E-308\n0\n2.2250738585072014E-308 to 1.7976931348623157E+308\n \nThese are the theoretical limits, based on the IEEE\nstandard. The actual range\nmight be slightly smaller depending on your hardware or\noperating system.\n \nM is the total number of digits and D is the number of\ndigits\nfollowing the decimal point. If M and D are omitted, values\nare stored\nto the limits allowed by the hardware. A double-precision\nfloating-point number is accurate to approximately 15\ndecimal places.\n \nUNSIGNED, if specified, disallows negative values.\n \nZEROFILL, if specified, pads the number with zeros, up to\nthe total number\nof digits specified by M.\n \nREAL and DOUBLE PRECISION are synonyms, unless the\nREAL_AS_FLOAT SQL mode is enabled, in which case REAL is a\nsynonym for FLOAT rather than DOUBLE.\n \nSee Floating Point Accuracy for issues when using\nfloating-point numbers.\n \nFor more details on the attributes, see Numeric Data Type\nOverview.\n \nExamples\n-------- \nCREATE TABLE t1 (d DOUBLE(5,0) zerofill);\n \nINSERT INTO t1 VALUES (1),(2),(3),(4);\n \nSELECT * FROM t1;\n \n+-------+\n| d |\n+-------+\n| 00001 |\n| 00002 |\n| 00003 |\n| 00004 |\n+-------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/double/','','https://mariadb.com/kb/en/library/double/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (278,22,'FLOAT','Syntax\n------ \nFLOAT[(M,D)] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA small (single-precision) floating-point number (see DOUBLE\nfor a regular-size floating point number). Allowable values\nare:\n-3.402823466E+38 to -1.175494351E-38\n0\n1.175494351E-38 to 3.402823466E+38. \n \nThese are the theoretical limits, based on the IEEE \nstandard. The actual range might be slightly smaller\ndepending on your\nhardware or operating system.\n \nM is the total number of digits and D is the number of\ndigits\nfollowing the decimal point. If M and D are omitted, values\nare stored\nto the limits allowed by the hardware. A single-precision\nfloating-point number is accurate to approximately 7 decimal\nplaces.\n \nUNSIGNED, if specified, disallows negative values.\n \nUsing FLOAT might give you some unexpected problems because\nall\ncalculations in MariaDB are done with double precision. See\nFloating Point Accuracy.\n \nFor more details on the attributes, see Numeric Data Type\nOverview.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/float/','','https://mariadb.com/kb/en/library/float/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (279,22,'Geometry Types','Description\n----------- \nMariaDB provides a standard way of creating spatial columns\nfor geometry types,\nfor example, with CREATE TABLE or ALTER TABLE.\nCurrently, spatial columns are supported for MyISAM, InnoDB,\nNDB, and ARCHIVE\ntables. See also SPATIAL INDEX.\n \nThe basic geometry type is GEOMETRY. But the type can be\nmore specific. The following types are supported:\n \nGeometry Types | \n \nPOINT | \n \nLINESTRING | \n \nPOLYGON | \n \nMULTIPOINT | \n \nMULTILINESTRING | \n \nMULTIPOLYGON | \n \nGEOMETRYCOLLECTION | \n \nGEOMETRY | \n \nExamples\n-------- \nNote: For clarity, only one type is listed per table in the\nexamples below, but a table\nrow can contain multiple types. For example:\n \nCREATE TABLE object (shapeA POLYGON, shapeB LINESTRING);\n \nPOINT\n \nCREATE TABLE gis_point (g POINT);\nSHOW FIELDS FROM gis_point;\n \nINSERT INTO gis_point VALUES\n (PointFromText(\'POINT(10 10)\')),\n (PointFromText(\'POINT(20 10)\')),\n (PointFromText(\'POINT(20 20)\')),\n (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n \nLINESTRING\n \nCREATE TABLE gis_line (g LINESTRING);\nSHOW FIELDS FROM gis_line;\n \nINSERT INTO gis_line VALUES\n (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10\n10)\')),\n (LineStringFromWKB(AsWKB(LineString(Point(10, 10),\nPoint(40, 10)))));\n \nPOLYGON\n \nCREATE TABLE gis_polygon (g POLYGON);\nSHOW FIELDS FROM gis_polygon;\n \nINSERT INTO gis_polygon VALUES\n (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10\n10))\')),\n (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10\n10,20 10,20 20,10 20,10 10))\')),\n (PolyFromWKB(AsWKB(Polygon(LineString(Point(0, 0),\nPoint(30, 0), Point(30, 30), Point(0, 0))))));\n \nMULTIPOINT\n \nCREATE TABLE gis_multi_point (g MULTIPOINT);\nSHOW FIELDS FROM gis_multi_point;\n \nINSERT INTO gis_multi_point VALUES\n (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20\n20)\')),\n (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4,\n10)))));\n \nMULTILINESTRING\n \nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nSHOW FIELDS FROM gis_multi_line;\n \nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10\n0),(16 0,16 23,16 48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2),\nPoint(3, 5)), LineString(Point(2, 5), Point(5, 8), Point(21,\n7))))));\n \nMULTIPOLYGON\n \nCREATE TABLE gis_multi_polygon (g MULTIPOLYGON);\nSHOW FIELDS FROM gis_multi_polygon;\n \nINSERT INTO gis_multi_polygon VALUES\n (MultiPolygonFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84\n42,28 26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67\n13,59 13,59 18)))\')),\n (MPolyFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84 42,28\n26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67 13,59\n13,59 18)))\')),\n (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(LineString(Point(0,\n3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n \nGEOMETRYCOLLECTION\n \nCREATE TABLE gis_geometrycollection (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\n \nINSERT INTO gis_geometrycollection VALUES\n (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0),\nLINESTRING(0 0,10 10))\')),\n (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n (GeomFromText(\'GeometryCollection()\')),\n (GeomFromText(\'GeometryCollection EMPTY\'));\n \nGEOMETRY\n \nCREATE TABLE gis_geometry (g GEOMETRY);\nSHOW FIELDS FROM gis_geometry;\n \nINSERT into gis_geometry SELECT * FROM gis_point;\n \nINSERT into gis_geometry SELECT * FROM gis_line;\n \nINSERT into gis_geometry SELECT * FROM gis_polygon;\n \nINSERT into gis_geometry SELECT * FROM gis_multi_point;\n \nINSERT into gis_geometry SELECT * FROM gis_multi_line;\n \nINSERT into gis_geometry SELECT * FROM gis_multi_polygon;\n \nINSERT into gis_geometry SELECT * FROM\ngis_geometrycollection;\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/geometry-types/','','https://mariadb.com/kb/en/library/geometry-types/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (280,22,'JSON Data Type','The JSON alias was added in MariaDB 10.2.7. This was done to\nmake it possible to use JSON columns in statement based\nreplication from MySQL to MariaDB and to make it possible\nfor MariaDB to read mysqldumps from MySQL.\n \nJSON is an alias for LONGTEXT introduced for compatibility\nreasons with MySQL\'s JSON data type. MariaDB implements\nthis as a LONGTEXT rather, as the JSON data type contradicts\nthe SQL standard, and MariaDB\'s benchmarks indicate that\nperformance is at least equivalent.\n \nIn order to ensure that a a valid json document is inserted,\nthe JSON_VALID function can be used as a CHECK constraint.\nThis constraint is automatically included for types using\nthe JSON alias from MariaDB 10.4.3.\n \nExamples\n-------- \nCREATE TABLE t (j JSON);\n \nDESC t;\n+-------+----------+------+-----+---------+-------+\n| Field | Type | Null | Key | Default | Extra |\n+-------+----------+------+-----+---------+-------+\n| j | longtext | YES | | NULL | |\n+-------+----------+------+-----+---------+-------+\n \nWith validation:\n \nCREATE TABLE t2 (\n j JSON \n CHECK (JSON_VALID(j))\n);\n \nINSERT INTO t2 VALUES (\'invalid\');\nERROR 4025 (23000): CONSTRAINT `j` failed for `test`.`t2`\n \nINSERT INTO t2 VALUES (\'{\"id\": 1, \"name\":\n\"Monty\"}\');\nQuery OK, 1 row affected (0.13 sec)\n \nReplicating JSON Data Between MySQL and MariaDB\n \nThe JSON type in MySQL stores the JSON object in a compact\nform, not as LONGTEXT as in MariaDB.\nThis means that row based replication will not work for JSON\ntypes from MySQL to MariaDB.\n \nThere are a a few different ways to solve this:\nUse statement based replication.\nChange the JSON column to type TEXT in MySQL\n \nConverting a MySQL TABLE with JSON Fields to MariaDB\n \nMariaDB can\'t directly access MySQL JSON format.\n \nThere is a a few different ways to move the table to\nMariaDB:\nChange the JSON column to type TEXT in MySQL. After this\nMariaDB can directly use the table without any need for a\ndump and restore.\nUse mysqldump to copy the table.\n \nDifferences Between MySQL JSON Strings and MariaDB JSON\nStrings\n \nIn MySQL, JSON is an object and is compared according to\njson values. In MariaDB JSON strings are normal strings and\ncompared as strings. One exception is when using\nJSON_EXTRACT() in which case strings are unescaped before\ncomparison.\n \n\n\nURL: https://mariadb.com/kb/en/library/json-data-type/','','https://mariadb.com/kb/en/library/json-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (281,22,'LONGBLOB','Syntax\n------ \nLONGBLOB\n \nDescription\n----------- \nA BLOB column with a \nmaximum length of 4,294,967,295 bytes or 4GB (232 - 1). The\neffective maximum length of LONGBLOB columns depends on the\nconfigured maximum packet size in the client/server protocol\nand\navailable memory. Each LONGBLOB value is stored using a\nfour-byte\nlength prefix that indicates the number of bytes in the\nvalue.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, BLOB is a synonym for\nLONGBLOB.\n \n\n\nURL: https://mariadb.com/kb/en/library/longblob/','','https://mariadb.com/kb/en/library/longblob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (282,22,'LONGTEXT','Syntax\n------ \nLONGTEXT [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n \nDescription\n----------- \nA TEXT column with a maximum length of 4,294,967,295 or 4GB\n(232 - 1) characters. The effective maximum length is less\nif the value contains multi-byte characters. The effective\nmaximum length of LONGTEXT columns also depends on the\nconfigured maximum packet size in the client/server protocol\nand available memory. Each LONGTEXT value is stored using a\nfour-byte length prefix that indicates the number of bytes\nin the value.\n \nFrom MariaDB 10.2.7, JSON is an alias for LONGTEXT. See JSON\nData Type for details.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, CLOB is a synonym for\nLONGTEXT.\n \n\n\nURL: https://mariadb.com/kb/en/library/longtext/','','https://mariadb.com/kb/en/library/longtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (283,22,'MEDIUMBLOB','Syntax\n------ \nMEDIUMBLOB\n \nDescription\n----------- \nA BLOB column with a maximum\nlength of 16,777,215 (224 - 1) bytes.\nEach MEDIUMBLOB value is stored using a three-byte length\nprefix that\nindicates the number of bytes in the value. \n \n\n\nURL: https://mariadb.com/kb/en/library/mediumblob/','','https://mariadb.com/kb/en/library/mediumblob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (284,22,'MEDIUMINT','Syntax\n------ \nMEDIUMINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA medium-sized integer. The signed range is -8388608 to\n8388607. The\nunsigned range is 0 to 16777215.\n \nZEROFILL pads the integer with zeroes and assumes UNSIGNED\n(even if UNSIGNED is not specified).\n \nFor details on the attributes, see Numeric Data Type\nOverview.\n \nExamples\n-------- \nCREATE TABLE mediumints (a MEDIUMINT,b MEDIUMINT UNSIGNED,c\nMEDIUMINT ZEROFILL);\n \nDESCRIBE mediumints;\n+-------+--------------------------------+------+-----+---------+-------+\n| Field | Type | Null | Key | Default | Extra |\n+-------+--------------------------------+------+-----+---------+-------+\n| a | mediumint(9) | YES | | NULL | |\n| b | mediumint(8) unsigned | YES | | NULL | |\n| c | mediumint(8) unsigned zerofill | YES | | NULL | |\n+-------+--------------------------------+------+-----+---------+-------+\n \nINSERT INTO mediumints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.05 sec)\nWarning (Code 1264): Out of range value for column \'b\' at\nrow 1\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO mediumints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO mediumints VALUES (-10,10,10);\n \nINSERT INTO mediumints VALUES (8388608,8388608,8388608);\nQuery OK, 1 row affected, 1 warning (0.05 sec)\nWarning (Code 1264): Out of range value for column \'a\' at\nrow 1\n \nINSERT INTO mediumints VALUES (8388607,8388608,8388608);\n \nSELECT * FROM mediumints;\n+---------+---------+----------+\n| a | b | c |\n+---------+---------+----------+\n| -10 | 0 | 00000000 |\n| -10 | 0 | 00000000 |\n| -10 | 10 | 00000000 |\n| -10 | 10 | 00000010 |\n| 8388607 | 8388608 | 08388608 |\n| 8388607 | 8388608 | 08388608 |\n+---------+---------+----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/mediumint/','','https://mariadb.com/kb/en/library/mediumint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (285,22,'MEDIUMTEXT','Syntax\n------ \nMEDIUMTEXT [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n \nDescription\n----------- \nA TEXT column with a \nmaximum length of 16,777,215 (224 - 1)\ncharacters. The effective maximum length is less if the\nvalue\ncontains multi-byte characters. Each MEDIUMTEXT value is\nstored using\na three-byte length prefix that indicates the number of\nbytes in the\nvalue.\n \n\n\nURL: https://mariadb.com/kb/en/library/mediumtext/','','https://mariadb.com/kb/en/library/mediumtext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (286,22,'Numeric Data Type Overview','There are a number of numeric data types:\nTINYINT\nBOOLEAN - Synonym for TINYINT(1)\nSMALLINT\nMEDIUMINT\nINT, INTEGER\nBIGINT\nDECIMAL, DEC, NUMERIC, FIXED\nFLOAT\nDOUBLE, DOUBLE PRECISION, REAL\nBIT\n \nSee the specific articles for detailed information on each.\n \nSIGNED, UNSIGNED and ZEROFILL\n \nMost numeric types can be defined as SIGNED, UNSIGNED or\nZEROFILL, for example:\n \nTINYINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n \nIf SIGNED, or no attribute, is specified, a portion of the\nnumeric type will be reserved for the sign (plus or minus).\nFor example, a TINYINT SIGNED can range from -128 to 127. \n \nIf UNSIGNED is specified, no portion of the numeric type is\nreserved for the sign, so for integer types range can be\nlarger. For example, a TINYINT UNSIGNED can range from 0 to\n255. Floating point and fixed-point types also can be\nUNSIGNED, but this only prevents negative values from being\nstored and doesn\'t alter the range. \n \nIf ZEROFILL is specified, the column will be set to UNSIGNED\nand the spaces used by default to pad the field are replaced\nwith zeros. ZEROFILL is ignored in expressions or as part of\na UNION. ZEROFILL is a non-standard MySQL and MariaDB\nenhancement.\n \nNote that although the preferred syntax indicates that the\nattributes are exclusive, more than one attribute can be\nspecified.\n \nUntil MariaDB 10.2.7 (MDEV-8659), any combination of the\nattributes could be used in any order, with duplicates. In\nthis case:\nthe presence of ZEROFILL makes the column UNSIGNED ZEROFILL.\nthe presence of UNSIGNED makes the column UNSIGNED.\n \nFrom MariaDB 10.2.8, only the following combinations are\nsupported:\nSIGNED\nUNSIGNED\nZEROFILL\nUNSIGNED ZEROFILL\nZEROFILL UNSIGNED\n \nThe latter two should be replaced with simply ZEROFILL, but\nare still accepted by the parser.\n \nExamples\n-------- \nCREATE TABLE zf (\n i1 TINYINT SIGNED,\n i2 TINYINT UNSIGNED,\n i3 TINYINT ZEROFILL\n);\n \nINSERT INTO zf VALUES (2,2,2);\n \nSELECT * FROM zf;\n \n+------+------+------+\n| i1 | i2 | i3 |\n+------+------+------+\n| 2 | 2 | 002 |\n+------+------+------+\n \nRange\n \nWhen attempting to add a value that is out of the valid\nrange for the numeric type, MariaDB will react depending on\nthe strict SQL_MODE setting.\n \nIf strict_mode has been set (the default from MariaDB\n10.2.4), MariaDB will return an error.\n \nIf strict_mode has not been set (the default until MariaDB\n10.2.3), MariaDB will adjust the number to fit in the field,\nreturning a warning.\n \nExamples\n-------- \nWith strict_mode set:\n \nSHOW VARIABLES LIKE \'sql_mode\';\n \n+---------------+-------------------------------------------------------------------------------------------+\n| Variable_name | Value |\n+---------------+-------------------------------------------------------------------------------------------+\n| sql_mode |\nSTRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION\n|\n+---------------+-------------------------------------------------------------------------------------------+\n \nCREATE TABLE ranges (i1 TINYINT, i2 SMALLINT, i3 TINYINT\nUNSIGNED);\n \nINSERT INTO ranges VALUES (257,257,257);\nERROR 1264 (22003): Out of range value for column \'i1\' at\nrow 1\n \nSELECT * FROM ranges;\n \nEmpty set (0.10 sec)\n \nWith strict_mode unset:\n \nSHOW VARIABLES LIKE \'sql_mode%\';\n \n+---------------+-------+\n| Variable_name | Value |\n+---------------+-------+\n| sql_mode | |\n+---------------+-------+\n \nCREATE TABLE ranges (i1 TINYINT, i2 SMALLINT, i3 TINYINT\nUNSIGNED);\n \nINSERT INTO ranges VALUES (257,257,257);\nQuery OK, 1 row affected, 2 warnings (0.00 sec)\n \nSHOW WARNINGS;\n \n+---------+------+---------------------------------------------+\n| Level | Code | Message |\n+---------+------+---------------------------------------------+\n| Warning | 1264 | Out of range value for column \'i1\' at\nrow 1 |\n| Warning | 1264 | Out of range value for column \'i3\' at\nrow 1 |\n+---------+------+---------------------------------------------+\n2 rows in set (0.00 sec)\n \nSELECT * FROM ranges;\n \n+------+------+------+\n| i1 | i2 | i3 |\n+------+------+------+\n| 127 | 257 | 255 |\n+------+------+------+\n \nAuto_increment\n \nThe AUTO_INCREMENT attribute can be used to generate a\nunique identity for new rows. For more details, see\nauto_increment.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/numeric-data-type-overview/','','https://mariadb.com/kb/en/library/numeric-data-type-overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (287,22,'ROW','The ROW data type was introduced in MariaDB 10.3.0.\n \nSyntax\n------ \nROW (  [{,  }... ])\n \nDescription\n----------- \nROW is a data type for stored procedure variables.\n \nFeatures\n \nROW fields as normal variables\n \nROW fields (members) act as normal variables, and are able\nto appear in all\nquery parts where a stored procedure variable is allowed:\nAssignment is using the := operator and the SET command:\n \na.x:= 10;\n \na.x:= b.x;\n \nSET a.x= 10, a.y=20, a.z= b.z;\n \nPassing to functions and operators:\n \nSELECT f1(rec.a), rec.a\n\nURL: https://mariadb.com/kb/en/library/row/','','https://mariadb.com/kb/en/library/row/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (288,22,'SET Data Type','Syntax\n------ \nSET(\'value1\',\'value2\',...) [CHARACTER SET charset_name]\n[COLLATE collation_name]\n \nDescription\n----------- \nA set. A string object that can have zero or more values,\neach of\nwhich must be chosen from the list of values \'value1\',\n\'value2\', ... A\nSET column can have a maximum of 64 members. SET values are\nrepresented internally as integers.\n \n\n\nURL: https://mariadb.com/kb/en/library/set-data-type/','','https://mariadb.com/kb/en/library/set-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (289,22,'SMALLINT','Syntax\n------ \nSMALLINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA small integer. The signed range is -32768 to 32767. The\nunsigned range is 0 to 65535.\n \nIf a column has been set to ZEROFILL, all values will be\nprepended by zeros so that the SMALLINT value contains a\nnumber of M digits.\n \nNote: If the ZEROFILL attribute has been specified, the\ncolumn will automatically become UNSIGNED.\n \nFor more details on the attributes, see Numeric Data Type\nOverview.\n \nExamples\n-------- \nCREATE TABLE smallints (a SMALLINT,b SMALLINT UNSIGNED,c\nSMALLINT ZEROFILL);\n \nINSERT INTO smallints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.09 sec)\nWarning (Code 1264): Out of range value for column \'b\' at\nrow 1\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO smallints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.08 sec)\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO smallints VALUES (-10,10,10);\n \nINSERT INTO smallints VALUES (32768,32768,32768);\nQuery OK, 1 row affected, 1 warning (0.04 sec)\nWarning (Code 1264): Out of range value for column \'a\' at\nrow 1\n \nINSERT INTO smallints VALUES (32767,32768,32768);\n \nSELECT * FROM smallints;\n+-------+-------+-------+\n| a | b | c |\n+-------+-------+-------+\n| -10 | 0 | 00000 |\n| -10 | 10 | 00000 |\n| -10 | 10 | 00010 |\n| 32767 | 32768 | 32768 |\n| 32767 | 32768 | 32768 |\n+-------+-------+-------+\n \n\n\nURL: https://mariadb.com/kb/en/library/smallint/','','https://mariadb.com/kb/en/library/smallint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (290,22,'String Literals','Strings are sequences of characters and are enclosed with\nquotes.\n \nThe syntax is:\n \n[_charset_name]\'string\' [COLLATE collation_name]\n \nFor example:\n \n\'The MariaDB Foundation\'\n_utf8 \'Foundation\' COLLATE utf8_unicode_ci;\n \nStrings can either be enclosed in single quotes or in double\nquotes (the same character must be used to both open and\nclose the string).\n \nThe ANSI SQL-standard does not permit double quotes for\nenclosing strings, and although MariaDB does by default, if\nthe MariaDB server has enabled the ANSI_QUOTES_SQL SQL_MODE,\ndouble quotes will be treated as being used for identifiers\ninstead of strings.\n \nStrings that are next to each other are automatically\nconcatenated. For example:\n \n\'The \' \'MariaDB \' \'Foundation\'\n \nand\n \n\'The MariaDB Foundation\'\n \nare equivalent.\n \nThe \\ (backslash character) is used to escape characters.\nFor example:\n \n\'MariaDB\'s new features\'\n \nis not a valid string because of the single quote in the\nmiddle of the string, which is treated as if it closes the\nstring, but is actually meant as part of the string, an\napostrophe. The backslash character helps in situations like\nthis:\n \n\'MariaDB\\\'s new features\'\n \nis now a valid string, and if displayed, will appear without\nthe backslash.\n \nSELECT \'MariaDB\\\'s new features\';\n+------------------------+\n| MariaDB\'s new features |\n+------------------------+\n| MariaDB\'s new features |\n+------------------------+\n \nAnother way to escape the quoting character is repeating it\ntwice:\n \nSELECT \'I\'\'m here\', \"\"\"Double\"\"\";\n+----------+----------+\n| I\'m here | \"Double\" |\n+----------+----------+\n| I\'m here | \"Double\" |\n+----------+----------+\n \nEscape sequences\n \nThere are other escape sequences also. Here is a full list:\n \nEscape sequence | Character | \n \n\\0 | ASCII NUL (0x00). | \n \n\\\' | Single quote (“\'”). | \n \n\\\" | Double quote (“\"”). | \n \n\\b | Backspace. | \n \n\\n | Newline, or linefeed,. | \n \n\\r | Carriage return. | \n \n\\t | Tab. | \n \n\\Z | ASCII 26 (Control+Z). See note following the table. | \n \n\\\\ | Backslash (“\\”). | \n \n\\% | “%” character. See note following the table. | \n \n\\_ | A “_” character. See note following the table. | \n \nEscaping the % and _ characters can be necessary when using\nthe LIKE operator, which treats them as special characters.\n \nThe ASCII 26 character (\\Z) needs to be escaped when\nincluded in a batch file which needs to be executed in\nWindows. The reason is that ASCII 26, in Windows, is the end\nof file (EOF).\n \nBackslash (\\), if not used as an escape character, must\nalways be escaped. When followed by a character that is not\nin the above table, backslashes will simply be ignored.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/string-literals/','','https://mariadb.com/kb/en/library/string-literals/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (291,22,'TEXT','Syntax\n------ \nTEXT[(M)] [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n \nDescription\n----------- \nA TEXT column with a maximum length of 65,535 (216 - 1)\ncharacters. The effective maximum length is less if the\nvalue contains\nmulti-byte characters. Each TEXT value is stored using a\ntwo-byte length\nprefix that indicates the number of bytes in the value. If\nyou need a bigger storage, consider using MEDIUMTEXT\ninstead.\n \nAn optional length M can be given for this type. If this is\ndone, MariaDB\ncreates the column as the smallest TEXT type large enough to\nhold values\nM characters long.\n \nBefore MariaDB 10.2, all MariaDB collations were of type\nPADSPACE, meaning that TEXT (as well as VARCHAR and CHAR\nvalues) are compared without regard for trailing spaces.\nThis does not apply to the LIKE pattern-matching operator,\nwhich takes into account trailing spaces.\n \nBefore MariaDB 10.2.1, BLOB and TEXT columns could not be\nassigned a DEFAULT value. This restriction was lifted in\nMariaDB 10.2.1.\n \nExamples\n-------- \nTrailing spaces:\n \nCREATE TABLE strtest (d TEXT(10));\nINSERT INTO strtest VALUES(\'Maria \');\n \nSELECT d=\'Maria\',d=\'Maria \' FROM strtest;\n+-----------+--------------+\n| d=\'Maria\' | d=\'Maria \' |\n+-----------+--------------+\n| 1 | 1 |\n+-----------+--------------+\n \nSELECT d LIKE \'Maria\',d LIKE \'Maria \' FROM strtest;\n+----------------+-------------------+\n| d LIKE \'Maria\' | d LIKE \'Maria \' |\n+----------------+-------------------+\n| 0 | 1 |\n+----------------+-------------------+\n \nDifference between VARCHAR and TEXT\n \nVARCHAR columns can be fully indexed. TEXT columns can only\nbe indexed over a specified length.\nUsing TEXT or BLOB in a SELECT query that uses temporary\ntables for storing intermediate results will force the\ntemporary table to be disk based (using the Aria storage\nengine instead of the memory storage engine, which is a bit\nslower. This is not that bad as the Aria storage engine\ncaches the rows in memory. To get the benefit of this, one\nshould ensure that the aria_pagecache_buffer_size variable\nis big enough to hold most of the row and index data for\ntemporary tables.\n \nFor Storage Engine Developers\n \nInternally the full length of the VARCHAR column is\nallocated inside each TABLE objects record[] structure. As\nthere are three such buffers, each open table will allocate\n3 times max-length-to-store-varchar bytes of memory.\nTEXT and BLOB columns are stored with a pointer (4 or 8\nbytes) + a 1-4 bytes length. The TEXT data is only stored\nonce. This means that internally TEXT uses less memory for\neach open table but instead has the additional overhead that\neach TEXT object needs to be allocated and freed for each\nrow access (with some caching in between).\n \n\n\nURL: https://mariadb.com/kb/en/library/text/','','https://mariadb.com/kb/en/library/text/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (292,22,'TIME','Syntax\n------ \nTIME [()]\n \nDescription\n----------- \nA time. The range is \'-838:59:59.999999\' to\n\'838:59:59.999999\'. Microsecond precision can be from 0-6;\nif not specified 0 is used. Microseconds have been available\nsince MariaDB 5.3. \n \nMariaDB displays TIME values in \'HH:MM:SS.ssssss\' format,\nbut allows assignment of times in looser formats, including\n\'D HH:MM:SS\', \'HH:MM:SS\', \'HH:MM\', \'D HH:MM\', \'D\nHH\', \'SS\', or \'HHMMSS\', as well as permitting dropping\nof any leading zeros when a delimiter is provided, for\nexample \'3:9:10\'. For details, see date and time literals.\n \nMariaDB 10.1.2 introduced the --mysql56-temporal-format\noption, on by default, which allows MariaDB to store TIMEs\nusing the same low-level format MySQL 5.6 uses.\n \nInternal Format\n \nIn MariaDB 10.1.2 a new temporal format was introduced from\nMySQL 5.6 that alters how the TIME, DATETIME and TIMESTAMP\ncolumns operate at lower levels. These changes allow these\ntemporal data types to have fractional parts and negative\nvalues. You can disable this feature using the\nmysql56_temporal_format system variable.\n \nTables that include TIMESTAMP values that were created on an\nolder version of MariaDB or that were created while the\nmysql56_temporal_format system variable was disabled\ncontinue to store data using the older data type format.\n \nIn order to update table columns from the older format to\nthe newer format, execute an ALTER TABLE... MODIFY COLUMN\nstatement that changes the column to the *same* data type.\nThis change may be needed if you want to export the table\'s\ntablespace and import it onto a server that has\nmysql56_temporal_format=ON set (see MDEV-15225).\n \nFor instance, if you have a TIME column in your table: \n \nSHOW VARIABLES LIKE \'mysql56_temporal_format\';\n \n+-------------------------+-------+\n| Variable_name | Value |\n+-------------------------+-------+\n| mysql56_temporal_format | ON |\n+-------------------------+-------+\n \nALTER TABLE example_table MODIFY ts_col TIME;\n \nWhen MariaDB executes the ALTER TABLE statement, it converts\nthe data from the older temporal format to the newer one. \n \nIn the event that you have several tables and columns using\ntemporal data types that you want to switch over to the new\nformat, make sure the system variable is enabled, then\nperform a dump and restore using mysqldump. The columns\nusing relevant temporal data types are restored using the\nnew temporal format.\n \nExamples\n-------- \nINSERT INTO time VALUES (\'90:00:00\'), (\'800:00:00\'),\n(800), (22), (151413), (\'9:6:3\'), (\'12 09\');\n \nSELECT * FROM time;\n+-----------+\n| t |\n+-----------+\n| 90:00:00 |\n| 800:00:00 |\n| 00:08:00 |\n| 00:00:22 |\n| 15:14:13 |\n| 09:06:03 |\n| 297:00:00 |\n+-----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/time/','','https://mariadb.com/kb/en/library/time/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (293,22,'TIMESTAMP','Syntax\n------ \nTIMESTAMP [(\n\nURL: https://mariadb.com/kb/en/library/timestamp/','','https://mariadb.com/kb/en/library/timestamp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (294,22,'TINYBLOB','Syntax\n------ \nTINYBLOB\n \nDescription\n----------- \nA BLOB column with a maximum length of \n255 (28 - 1) bytes. Each\nTINYBLOB value is stored using a one-byte length prefix that\nindicates\nthe number of bytes in the value.\n \n\n\nURL: https://mariadb.com/kb/en/library/tinyblob/','','https://mariadb.com/kb/en/library/tinyblob/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (295,22,'TINYINT','Syntax\n------ \nTINYINT[(M)] [SIGNED | UNSIGNED | ZEROFILL]\n \nDescription\n----------- \nA very small integer. The signed range is -128 to 127. The\nunsigned range is 0 to 255. For details on the attributes,\nsee Numeric Data Type Overview.\n \nExamples\n-------- \nCREATE TABLE tinyints (a TINYINT,b TINYINT UNSIGNED,c\nTINYINT ZEROFILL);\nQuery OK, 0 rows affected (0.43 sec)\n \nINSERT INTO tinyints VALUES (-10,-10,-10);\nQuery OK, 1 row affected, 2 warnings (0.08 sec)\nWarning (Code 1264): Out of range value for column \'b\' at\nrow 1\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO tinyints VALUES (-10,10,-10);\nQuery OK, 1 row affected, 1 warning (0.11 sec)\nWarning (Code 1264): Out of range value for column \'c\' at\nrow 1\n \nINSERT INTO tinyints VALUES (-10,10,10);\n \nSELECT * FROM tinyints;\n+------+------+------+\n| a | b | c |\n+------+------+------+\n| -10 | 0 | 000 |\n| -10 | 10 | 000 |\n| -10 | 10 | 010 |\n+------+------+------+\n \nINSERT INTO tinyints VALUES (128,128,128);\nQuery OK, 1 row affected, 1 warning (0.19 sec)\nWarning (Code 1264): Out of range value for column \'a\' at\nrow 1\n \nINSERT INTO tinyints VALUES (127,128,128);\n \nSELECT * FROM tinyints;\n+------+------+------+\n| a | b | c |\n+------+------+------+\n| -10 | 0 | 000 |\n| -10 | 10 | 000 |\n| -10 | 10 | 010 |\n| 127 | 128 | 128 |\n| 127 | 128 | 128 |\n+------+------+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/tinyint/','','https://mariadb.com/kb/en/library/tinyint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (296,22,'TINYTEXT','Syntax\n------ \nTINYTEXT [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n \nDescription\n----------- \nA TEXT column with a maximum length of 255 (28 - 1)\ncharacters. The effective maximum length is less if the\nvalue contains multi-byte characters. Each TINYTEXT value is\nstored using a one-byte length prefix that indicates the\nnumber of bytes in the value.\n \n\n\nURL: https://mariadb.com/kb/en/library/tinytext/','','https://mariadb.com/kb/en/library/tinytext/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (297,22,'VARBINARY','Syntax\n------ \nVARBINARY(M)\n \nDescription\n----------- \nThe VARBINARY type is similar to the VARCHAR type, but\nstores binary byte strings rather than non-binary character\nstrings. M represents the maximum column length in bytes. \n \nIt contains no character set, and comparison and sorting are\nbased on the numeric value of the bytes.\n \nIf the maximum length is exceeded, and SQL strict mode is\nnot enabled , the extra characters will be dropped with a\nwarning. If strict mode is enabled, an error will occur.\n \nUnlike BINARY values, VARBINARYs are not right-padded when\ninserting.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, RAW is a synonym for\nVARBINARY.\n \nExamples\n-------- \nInserting too many characters, first with strict mode off,\nthen with it on:\n \nCREATE TABLE varbins (a VARBINARY(10));\n \nINSERT INTO varbins VALUES(\'12345678901\');\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n \nSELECT * FROM varbins;\n \n+------------+\n| a |\n+------------+\n| 1234567890 |\n+------------+\n \nSET sql_mode=\'STRICT_ALL_TABLES\';\n \nINSERT INTO varbins VALUES(\'12345678901\');\nERROR 1406 (22001): Data too long for column \'a\' at row 1\n \nSorting is performed with the byte value:\n \nTRUNCATE varbins;\n \nINSERT INTO varbins VALUES(\'A\'),(\'B\'),(\'a\'),(\'b\');\n \nSELECT * FROM varbins ORDER BY a;\n \n+------+\n| a |\n+------+\n| A |\n| B |\n| a |\n| b |\n+------+\n \nUsing CAST to sort as a CHAR instead:\n \nSELECT * FROM varbins ORDER BY CAST(a AS CHAR);\n+------+\n| a |\n+------+\n| a |\n| A |\n| b |\n| B |\n+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/varbinary/','','https://mariadb.com/kb/en/library/varbinary/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (298,22,'VARCHAR','Syntax\n------ \n[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n \nDescription\n----------- \nA variable-length string. M represents the maximum column\nlength in\ncharacters. The range of M is 0 to 65,532. The effective\nmaximum\nlength of a VARCHAR is subject to the maximum row size and\nthe character set used. For\nexample, utf8 characters can require up to three bytes per\ncharacter,\nso a VARCHAR column that uses the utf8 character set can be\ndeclared\nto be a maximum of 21,844 characters.\n \nMariaDB stores VARCHAR values as a one-byte or two-byte\nlength prefix\nplus data. The length prefix indicates the number of bytes\nin the\nvalue. A VARCHAR column uses one length byte if values\nrequire no more\nthan 255 bytes, two length bytes if values may require more\nthan 255\nbytes.\n \nNote: MariaDB 5.1 and later follow the standard SQL\nspecification, \nand do not remove trailing spaces from VARCHAR values.\n \nVARCHAR(0) columns can contain 2 values: an empty string or\nNULL. Such columns cannot be part of an index. The CONNECT\nstorage engine does not support VARCHAR(0).\n \nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR\nis the\nstandard SQL way to define that a VARCHAR column should use\nsome\npredefined character set. MariaDB uses utf8 as this\npredefined character set, as does MySQL 4.1 and up.\nNVARCHAR is shorthand for NATIONAL VARCHAR.\n \nBefore MariaDB 10.2, all MariaDB collations were of type\nPADSPACE, meaning that VARCHAR (as well as CHAR and TEXT\nvalues) are compared without regard for trailing spaces.\nThis does not apply to the LIKE pattern-matching operator,\nwhich takes into account trailing spaces. From MariaDB 10.2,\na number of NO PAD collations are available.\n \nIf a unique index consists of a column where trailing pad\ncharacters are stripped or ignored, inserts into that column\nwhere values differ only by the number of trailing pad\ncharacters will result in a duplicate-key error.\n \nExamples\n-------- \nThe following are equivalent:\n \nVARCHAR(30) CHARACTER SET utf8\nNATIONAL VARCHAR(30)\nNVARCHAR(30)\nNCHAR VARCHAR(30)\nNATIONAL CHARACTER VARYING(30)\nNATIONAL CHAR VARYING(30)\n \nTrailing spaces:\n \nCREATE TABLE strtest (v VARCHAR(10));\nINSERT INTO strtest VALUES(\'Maria \');\n \nSELECT v=\'Maria\',v=\'Maria \' FROM strtest;\n+-----------+--------------+\n| v=\'Maria\' | v=\'Maria \' |\n+-----------+--------------+\n| 1 | 1 |\n+-----------+--------------+\n \nSELECT v LIKE \'Maria\',v LIKE \'Maria \' FROM strtest;\n+----------------+-------------------+\n| v LIKE \'Maria\' | v LIKE \'Maria \' |\n+----------------+-------------------+\n| 0 | 1 |\n+----------------+-------------------+\n \nTruncation\n \nDepending on whether or not strict sql mode is set, you will\neither get a warning or an error if you try to insert a\nstring that is too long into a VARCHAR column. If the extra\ncharacters are spaces, the spaces that can\'t fit will be\nremoved and you will always get a warning, regardless of the\nsql mode setting.\n \nDifference Between VARCHAR and TEXT\n \nVARCHAR columns can be fully indexed. TEXT columns can only\nbe indexed over a specified length.\nUsing TEXT or BLOB in a SELECT query that uses temporary\ntables for storing intermediate results will force the\ntemporary table to be disk based (using the Aria storage\nengine instead of the memory storage engine, which is a bit\nslower. This is not that bad as the Aria storage engine\ncaches the rows in memory. To get the benefit of this, one\nshould ensure that the aria_pagecache_buffer_size variable\nis big enough to hold most of the row and index data for\ntemporary tables.\n \nOracle Mode\n \nIn Oracle mode from MariaDB 10.3, VARCHAR2 is a synonym.\n \nFor Storage Engine Developers\n \nInternally the full length of the VARCHAR column is\nallocated inside each TABLE objects record[] structure. As\nthere are three such buffers, each open table will allocate\n3 times max-length-to-store-varchar bytes of memory.\nTEXT and BLOB columns are stored with a pointer (4 or 8\nbytes) + a 1-4 bytes length. The TEXT data is only stored\nonce. This means that internally TEXT uses less memory for\neach open table but instead has the additional overhead that\neach TEXT object needs to be allocated and freed for each\nrow access (with some caching in between).\n \n\n\nURL: https://mariadb.com/kb/en/library/varchar/','','https://mariadb.com/kb/en/library/varchar/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (299,22,'YEAR Data Type','Syntax\n------ \nYEAR[(4)]\n \nDescription\n----------- \nA year in two-digit or four-digit format. The default is\nfour-digit format. Note that the two-digit format has been\ndeprecated since 5.5.27. \n \nIn four-digit format, the allowable values are 1901 to 2155,\nand 0000. In two-digit format, the allowable values are 70\nto 69,\nrepresenting years from 1970 to 2069. MariaDB displays YEAR\nvalues in\nYYYY format, but allows you to assign values to YEAR columns\nusing\neither strings or numbers.\n \nInserting numeric zero has a different result for YEAR(4)\nand YEAR(2). For YEAR(2), the value 00 reflects the year\n2000. For YEAR(4), the value 0000 reflects the year zero.\nThis only applies to numeric zero. String zero always\nreflects the year 2000.\n \nExamples\n-------- \nAccepting a string or a number:\n \nCREATE TABLE y(y YEAR);\n \nINSERT INTO y VALUES (1990),(\'2012\');\n \nSELECT * FROM y;\n+------+\n| y |\n+------+\n| 1990 |\n| 2012 |\n+------+\n \nOut of range:\n \nINSERT INTO y VALUES (1005),(\'3080\');\nQuery OK, 2 rows affected, 2 warnings (0.05 sec)\nRecords: 2 Duplicates: 0 Warnings: 2\n \nSHOW WARNINGS;\n+---------+------+--------------------------------------------+\n| Level | Code | Message |\n+---------+------+--------------------------------------------+\n| Warning | 1264 | Out of range value for column \'y\' at\nrow 1 |\n| Warning | 1264 | Out of range value for column \'y\' at\nrow 2 |\n+---------+------+--------------------------------------------+\n \nSELECT * FROM y;\n+------+\n| y |\n+------+\n| 1990 |\n| 2012 |\n| 0000 |\n| 0000 |\n+------+\n \nTruncating:\n \nINSERT INTO y VALUES (\'2013-12-12\');\nQuery OK, 1 row affected, 1 warning (0.05 sec)\n \nSHOW WARNINGS;\n+---------+------+----------------------------------------+\n| Level | Code | Message |\n+---------+------+----------------------------------------+\n| Warning | 1265 | Data truncated for column \'y\' at row 1\n|\n+---------+------+----------------------------------------+\n \nSELECT * FROM y;\n+------+\n| y |\n+------+\n| 1990 |\n| 2012 |\n| 0000 |\n| 0000 |\n| 2013 |\n+------+\n \nDifference between YEAR(2) and YEAR(4), and string and\nnumeric zero:\n \nCREATE TABLE y2(y YEAR(4), y2 YEAR(2));\nQuery OK, 0 rows affected, 1 warning (0.40 sec)\n \nNote (Code 1287): \'YEAR(2)\' is deprecated and will be\nremoved in a future release. Please use YEAR(4) instead\n \nINSERT INTO y2 VALUES(0,0),(\'0\',\'0\');\n \nSELECT YEAR(y),YEAR(y2) FROM y;\n+---------+----------+\n| YEAR(y) | YEAR(y2) |\n+---------+----------+\n| 0 | 2000 |\n| 2000 | 2000 |\n+---------+----------+\n \n\n\nURL: https://mariadb.com/kb/en/library/year-data-type/','','https://mariadb.com/kb/en/library/year-data-type/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (300,23,'BEGIN END','Syntax\n------ \n[begin_label:] BEGIN [NOT ATOMIC]\n [statement_list]\nEND [end_label]\n \nNOT ATOMIC is required when used outside of a stored\nprocedure. Inside stored procedures or within an anonymous\nblock, BEGIN alone starts a new anonymous block.\n \nDescription\n----------- \nBEGIN ... END syntax is used for writing compound\nstatements. A compound statement can contain multiple\nstatements, enclosed by the BEGIN and END keywords.\nstatement_list represents a list of one or more statements,\neach\nterminated by a semicolon (i.e., ;) statement delimiter.\nstatement_list is\noptional, which means that the empty compound statement\n(BEGIN END) is\nlegal.\n \nNote that END will perform a commit. If you are running in\nautocommit mode, every statement will be committed\nseparately. If you are not running in autocommit mode, you\nmust execute a COMMIT or ROLLBACK after END to get the\ndatabase up to date.\n \nUse of multiple statements requires that a client is able to\nsend statement strings containing the ; statement delimiter.\nThis is handled in the mysql command-line client with the\nDELIMITER command.\nChanging the ; end-of-statement delimiter (for example, to\n//) allows ; to be used in a program body.\n \nA compound statement within a stored program can be\nlabeled. end_label cannot be given unless begin_label also\nis present. If both are present, they must be the same.\n \nBEGIN ... END constructs can be nested. Each block can\ndefine its own variables, a CONDITION, a HANDLER and a\nCURSOR, which don\'t exist in the outer blocks. The most\nlocal declarations override the outer objects which use the\nsame name (see example below).\n \nThe declarations order is the following:\nDECLARE local variables;\nDECLARE CONDITIONs;\nDECLARE CURSORs;\nDECLARE HANDLERs;\n \nNote that DECLARE HANDLER contains another BEGIN ... END\nconstruct.\n \nHere is an example of a very simple, anonymous block:\n \nBEGIN NOT ATOMIC\nSET @a=1;\n \nCREATE TABLE test.t1(a INT);\nEND|\n \nBelow is an example of nested blocks in a stored procedure:\n \nCREATE PROCEDURE t( )\nBEGIN\n DECLARE x TINYINT UNSIGNED DEFAULT 1;\n \n BEGIN\n DECLARE x CHAR(2) DEFAULT \'02\';\n \n DECLARE y TINYINT UNSIGNED DEFAULT 10;\n \n SELECT x, y;\n \n END;\n \n SELECT x;\n \nEND;\n \nIn this example, a TINYINT variable, x is declared in the\noutter block. But in the inner block x is re-declared as a\nCHAR and an y variable is declared. The inner SELECT shows\nthe \"new\" value of x, and the value of y. But when x is\nselected in the outer block, the \"old\" value is returned.\nThe final SELECT doesn\'t try to read y, because it doesn\'t\nexist in that context.\n \n\n\nURL: https://mariadb.com/kb/en/library/begin-end/','','https://mariadb.com/kb/en/library/begin-end/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (301,23,'CASE Statement','Syntax\n------ \nCASE case_value\n WHEN when_value THEN statement_list\n [WHEN when_value THEN statement_list] ...\n [ELSE statement_list]\nEND CASE\n \nOr:\n \nCASE\n WHEN search_condition THEN statement_list\n [WHEN search_condition THEN statement_list] ...\n [ELSE statement_list] \nEND CASE\n \nDescription\n----------- \nThe CASE statement for stored programs implements a complex\nconditional\nconstruct. If a search_condition evaluates to true, the\ncorresponding SQL\nstatement list is executed. If no search condition matches,\nthe statement list\nin the ELSE clause is executed. Each statement_list consists\nof one or\nmore statements.\n \nIf no when_value or search_condition matches the value\ntested and the CASE\nstatement contains no ELSE clause, a Case not found for CASE\nstatement\nerror results.\n \nEach statement_list consists of one or more statements; an\nempty\nstatement_list is not allowed. To handle situations where no\nvalue is\nmatched by any WHEN clause, use an ELSE containing an\nempty BEGIN ... END block, as shown in this example:\n \nDELIMITER |\nCREATE PROCEDURE p()\nBEGIN\n DECLARE v INT DEFAULT 1;\n \n CASE v\n WHEN 2 THEN SELECT v;\n \n WHEN 3 THEN SELECT 0;\n \n ELSE BEGIN END;\n \n END CASE;\n \nEND;\n \n|\n \nThe indentation used here in the ELSE clause is for purposes\nof clarity only,\nand is not otherwise significant. See Delimiters in the\nmysql client for more on the use of the delimiter command.\n \nNote: The syntax of the CASE statement used inside stored\nprograms\ndiffers slightly from that of the SQL CASE expression\ndescribed in\nCASE OPERATOR.\nThe CASE statement cannot have an ELSE NULL clause, and it\nis\nterminated with END CASE instead of END.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/case-statement/','','https://mariadb.com/kb/en/library/case-statement/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (302,23,'CLOSE','Syntax\n------ \nCLOSE cursor_name\n \nDescription\n----------- \nThis statement closes a previously opened cursor. The cursor\nmust have been previously opened or else an error occurs.\n \nIf not closed explicitly, a cursor is closed at the end of\nthe\ncompound statement in which it was declared.\n \nSee Cursor Overview for an example.\n \n\n\nURL: https://mariadb.com/kb/en/library/close/','','https://mariadb.com/kb/en/library/close/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (303,23,'DECLARE CONDITION','Syntax\n------ \nDECLARE condition_name CONDITION FOR condition_value\n \ncondition_value:\n SQLSTATE [VALUE] sqlstate_value\n | mysql_error_code\n \nDescription\n----------- \nThe DECLARE ... CONDITION statement defines a named error\ncondition.\nIt specifies a condition that needs specific handling and\nassociates a\nname with that condition. Later, the name can be used in a\nDECLARE ... HANDLER, SIGNAL or RESIGNAL statement (as long\nas the statement is located in the same BEGIN ... END\nblock).\n \nConditions must be declared after local variables, but\nbefore CURSORs and HANDLERs.\n \nA condition_value for DECLARE ... CONDITION can be an\nSQLSTATE value (a\n5-character string literal) or a MySQL error code (a\nnumber). You should not\nuse SQLSTATE value \'00000\' or MySQL error code 0, because\nthose indicate sucess\nrather than an error condition. If you try, or if you\nspecify an invalid SQLSTATE value, an error like this is\nproduced:\n \nERROR 1407 (42000): Bad SQLSTATE: \'00000\'\n \nFor a list of SQLSTATE values and MariaDB error\ncodes, see MariaDB Error Codes.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/declare-condition/','','https://mariadb.com/kb/en/library/declare-condition/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (304,23,'DECLARE CURSOR','Syntax\n------ \n\n\nURL: https://mariadb.com/kb/en/library/declare-cursor/','','https://mariadb.com/kb/en/library/declare-cursor/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (305,23,'DECLARE HANDLER','Syntax\n------ \nDECLARE handler_type HANDLER\n FOR condition_value [, condition_value] ...\n statement\n \nhandler_type:\n CONTINUE\n | EXIT \n | UNDO\n \ncondition_value:\n SQLSTATE [VALUE] sqlstate_value\n | condition_name\n | SQLWARNING\n | NOT FOUND\n | SQLEXCEPTION\n | mariadb_error_code\n \nDescription\n----------- \nThe DECLARE ... HANDLER statement specifies handlers that\neach may\ndeal with one or more conditions. If one of these conditions\noccurs,\nthe specified statement is executed. statement can be a\nsimple\nstatement (for example, SET var_name = value), or it can be\na compound\nstatement written using BEGIN and END.\n \nHandlers must be declared after local variables, a CONDITION\nand a CURSOR.\n \nFor a CONTINUE handler, execution of the current program\ncontinues\nafter execution of the handler statement. For an EXIT\nhandler,\nexecution terminates for the BEGIN ... END compound\nstatement in which\nthe handler is declared. (This is true even if the condition\noccurs in\nan inner block.) The UNDO handler type statement is not\nsupported.\n \nIf a condition occurs for which no handler has been\ndeclared, the\ndefault action is EXIT.\n \nA condition_value for DECLARE ... HANDLER can be any of the\nfollowing\nvalues:\nAn SQLSTATE value (a 5-character string literal) or a\nMariaDB error\ncode (a number). You should not use SQLSTATE value \'00000\'\nor MariaDB\nerror code 0, because those indicate sucess rather than an\nerror\ncondition. For a list of SQLSTATE values and MariaDB error\ncodes, see\nMariaDB Error Codes.\nA condition name previously specified with DECLARE ...\nCONDITION. It must be in the same stored program. See\nDECLARE CONDITION.\nSQLWARNING is shorthand for the class of SQLSTATE values\nthat begin\nwith \'01\'.\nNOT FOUND is shorthand for the class of SQLSTATE values that\nbegin\nwith \'02\'. This is relevant only the context of cursors\nand is used to\ncontrol what happens when a cursor reaches the end of a data\nset. If\nno more rows are available, a No Data condition occurs with\nSQLSTATE\nvalue 02000. To detect this condition, you can set up a\nhandler for it\n(or for a NOT FOUND condition). An example is shown in\nCursor Overview. This condition also occurs for SELECT ...\nINTO var_list statements that retrieve no\nrows.\nSQLEXCEPTION is shorthand for the class of SQLSTATE values\nthat do\nnot begin with \'00\', \'01\', or \'02\'.\n \nWhen an error raises, in some cases it could be handled by\nmultiple HANDLERs. For example, there may be an handler for\n1050 error, a separate handler for the 42S01 SQLSTATE, and\nanother separate handler for the SQLEXCEPTION class: in\ntheory all occurrences of HANDLER may catch the 1050 error,\nbut MariaDB chooses the HANDLER with the highest precedence.\nHere are the precedence rules:\nHandlers which refer to an error code have the highest\nprecedence.\nHandlers which refer to a SQLSTATE come next.\nHandlers which refer to an error class have the lowest\nprecedence.\n \nIn some cases, a statement could produce multiple errors. If\nthis happens, in some cases multiple handlers could have the\nhighest precedence. In such cases, the choice of the handler\nis indeterminate.\n \nNote that if an error occurs within a CONTINUE HANDLER\nblock, it can be handled by another HANDLER. However, a\nHANDLER which is already in the stack (that is, it has been\ncalled to handle an error and its execution didn\'t finish\nyet) cannot handle new errors—this prevents endless loops.\nFor example, suppose that a stored procedure contains a\nCONTINUE HANDLER for SQLWARNING and another CONTINUE HANDLER\nfor NOT FOUND. At some point, a NOT FOUND error occurs, and\nthe execution enters the NOT FOUND HANDLER. But within that\nhandler, a warning occurs, and the execution enters the\nSQLWARNING HANDLER. If another NOT FOUND error occurs, it\ncannot be handled again by the NOT FOUND HANDLER, because\nits execution is not finished.\n \nWhen a DECLARE HANDLER block can handle more than one error\ncondition, it may be useful to know which errors occurred.\nTo do so, you can use the GET DIAGNOSTICS statement.\n \nAn error that is handled by a DECLARE HANDLER construct can\nbe issued again using the RESIGNAL statement.\n \nBelow is an example using DECLARE HANDLER:\n \nCREATE TABLE test.t (s1 INT, PRIMARY KEY (s1));\n \nDELIMITER //\n \nCREATE PROCEDURE handlerdemo ( )\n BEGIN\n DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 =\n1;\n \n SET @x = 1;\n \n INSERT INTO test.t VALUES (1);\n SET @x = 2;\n \n INSERT INTO test.t VALUES (1);\n SET @x = 3;\n \n END;\n \n //\n \nDELIMITER ;\n \nCALL handlerdemo( );\n \nSELECT @x;\n \n+------+\n| @x |\n+------+\n| 3 |\n+------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/declare-handler/','','https://mariadb.com/kb/en/library/declare-handler/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (306,23,'DECLARE Variable','Syntax\n------ \nDECLARE var_name [, var_name] ... [[ROW] TYPE OF]] type\n[DEFAULT value]\n \nDescription\n----------- \nThis statement is used to declare local variables within\nstored programs. To\nprovide a default value for the variable, include a DEFAULT\nclause. The\nvalue can be specified as an expression (even subqueries are\npermitted); it need not be a constant. If the\nDEFAULT clause is missing, the initial value is NULL.\n \nLocal variables are treated like stored routine parameters\nwith respect to data\ntype and overflow checking. See CREATE PROCEDURE.\n \nLocal variables must be declared before CONDITIONs, CURSORs\nand HANDLERs.\n \nLocal variable names are not case sensitive.\n \nThe scope of a local variable is within the BEGIN ... END\nblock where it is\ndeclared. The variable can be referred to in blocks nested\nwithin the declaring\nblock, except those blocks that declare a variable with the\nsame name.\n \nTYPE OF / ROW TYPE OF\n \nTYPE OF and ROW TYPE OF anchored data types for stored\nroutines were introduced in MariaDB 10.3.\n \nAnchored data types allow a data type to be defined based on\nanother object, such as a table row, rather than\nspecifically set in the declaration. If the anchor object\nchanges, so will the anchored data type. This can lead to\nroutines being easier to maintain, so that if the data type\nin the table is changed, it will automatically be changed in\nthe routine as well.\n \nVariables declared with ROW TYPE OF will have the same\nfeatures as implicit ROW variables. It is not possible to\nuse ROW TYPE OF variables in a LIMIT clause.\n \nThe real data type of TYPE OF and ROW TYPE OF table_name\nwill become known at the very beginning of the stored\nroutine call. ALTER TABLE or DROP TABLE statements performed\ninside the current routine on the tables that appear in\nanchors won\'t affect the data type of the anchored\nvariables, even if the variable is declared after an ALTER\nTABLE or DROP TABLE statement.\n \nThe real data type of a ROW TYPE OF cursor_name variable\nwill become known when execution enters into the block where\nthe variable is declared. Data type instantiation will\nhappen only once. In a cursor ROW TYPE OF variable that is\ndeclared inside a loop, its data type will become known on\nthe very first iteration and won\'t change on further loop\niterations.\n \nThe tables referenced in TYPE OF and ROW TYPE OF\ndeclarations will be checked for existence at the beginning\nof the stored routine call. CREATE PROCEDURE or CREATE\nFUNCTION will not check the referenced tables for existence.\n \nExamples\n-------- \nTYPE OF and ROW TYPE OF from MariaDB 10.3:\n \nDECLARE tmp TYPE OF t1.a;\n -- Get the data type from the column {{a}} in the table\n{{t1}}\n \nDECLARE rec1 ROW TYPE OF t1;\n -- Get the row data type from the table {{t1}}\n \nDECLARE rec2 ROW TYPE OF cur1;\n -- Get the row data type from the cursor {{cur1}}\n \n\n\nURL: https://mariadb.com/kb/en/library/declare-variable/','','https://mariadb.com/kb/en/library/declare-variable/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (307,23,'FETCH','Syntax\n------ \nFETCH cursor_name INTO var_name [, var_name] ...\n \nDescription\n----------- \nThis statement fetches the next row (if a row exists) using\nthe\nspecified open cursor, and advances the cursor pointer.\n \nvar_name can be a local variable, but not a user-defined\nvariable.\n \nIf no more rows are available, a No Data condition occurs\nwith\nSQLSTATE value 02000. To detect this condition, you can set\nup a\nhandler for it (or for a NOT FOUND condition).\n \nSee Cursor Overview for an example.\n \n\n\nURL: https://mariadb.com/kb/en/library/fetch/','','https://mariadb.com/kb/en/library/fetch/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (308,23,'FOR','FOR loops were introduced in MariaDB 10.3.\n \nSyntax\n------ \nInteger range FOR loop:\n \n[begin_label:]\nFOR var_name IN [ REVERSE ] lower_bound .. upper_bound\nDO statement_list\nEND FOR [ end_label ]\n \nExplicit cursor FOR loop\n \n[begin_label:]\nFOR record_name IN cursor_name [ (\ncursor_actual_parameter_list)]\nDO statement_list\nEND FOR [ end_label ]\n \nExplicit cursor FOR loop (Oracle mode)\n \n[begin_label:]\nFOR record_name IN cursor_name [ (\ncursor_actual_parameter_list)]\nLOOP\n statement_list\nEND LOOP [ end_label ]\n \nImplicit cursor FOR loop\n \n[begin_label:]\nFOR record_name IN ( select_statement )\nDO statement_list\nEND FOR [ end_label ]\n \nDescription\n----------- \nFOR loops allow code to be executed a fixed number of times.\n \nIn an integer range FOR loop, MariaDB will compare the lower\nbound and upper bound values, and assign the lower bound\nvalue to a counter. If REVERSE is not specified, and the\nupper bound value is greater than or equal to the counter,\nthe counter will be incremented and the statement will\ncontinue, after which the loop is entered again. If the\nupper bound value is greater than the counter, the loop will\nbe exited.\n \nIf REVERSE is specified, the counter is decremented, and the\nupper bound value needs to be less than or equal for the\nloop to continue.\n \nExamples\n-------- \nIntger range FOR loop:\n \nCREATE TABLE t1 (a INT);\n \nDELIMITER //\n \nFOR i IN 1..3\nDO\n INSERT INTO t1 VALUES (i);\nEND FOR;\n \n//\n \nDELIMITER ;\n \nSELECT * FROM t1;\n \n+------+\n| a |\n+------+\n| 1 |\n| 2 |\n| 3 |\n+------+\n \nREVERSE integer range FOR loop:\n \nCREATE OR REPLACE TABLE t1 (a INT);\n \nDELIMITER //\nFOR i IN REVERSE 12..4\n DO\n INSERT INTO t1 VALUES (i);\nEND FOR;\n \n//\nQuery OK, 9 rows affected (0.422 sec)\n \nDELIMITER ;\n \nSELECT * FROM t1;\n \n+------+\n| a |\n+------+\n| 12 |\n| 11 |\n| 10 |\n| 9 |\n| 8 |\n| 7 |\n| 6 |\n| 5 |\n| 4 |\n+------+\n \nExplicit cursor in Oracle mode:\n \nSET sql_mode=ORACLE;\n \nCREATE OR REPLACE TABLE t1 (a INT, b VARCHAR(32));\n \nINSERT INTO t1 VALUES (10,\'b0\');\nINSERT INTO t1 VALUES (11,\'b1\');\nINSERT INTO t1 VALUES (12,\'b2\');\n \nDELIMITER //\n \nCREATE OR REPLACE PROCEDURE p1(pa INT) AS \n CURSOR cur(va INT) IS\n SELECT a, b FROM t1 WHERE a=va;\n \nBEGIN\n FOR rec IN cur(pa)\n LOOP\n SELECT rec.a, rec.b;\n \n END LOOP;\n \nEND;\n \n//\n \nDELIMITER ;\n \nCALL p1(10);\n+-------+-------+\n| rec.a | rec.b |\n+-------+-------+\n| 10 | b0 |\n+-------+-------+\n \nCALL p1(11);\n+-------+-------+\n| rec.a | rec.b |\n+-------+-------+\n| 11 | b1 |\n+-------+-------+\n \nCALL p1(12);\n+-------+-------+\n| rec.a | rec.b |\n+-------+-------+\n| 12 | b2 |\n+-------+-------+\n \nCALL p1(13);\nQuery OK, 0 rows affected (0.000 sec)\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/for/','','https://mariadb.com/kb/en/library/for/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (309,23,'GOTO','The GOTO statement was introduced in MariaDB 10.3 for Oracle\ncompatibility.\n \nSyntax\n------ \nGOTO label\n \nDescription\n----------- \nThe GOTO statement causes the code to jump to the specified\nlabel, and continue operating from there. It is only\naccepted when in Oracle mode.\n \nExample\n \nSET sql_mode=ORACLE;\n \nDELIMITER //\n \nCREATE OR REPLACE PROCEDURE p1 AS\n \nBEGIN\n \n SELECT 1;\n \n GOTO label;\n \n SELECT 2;\n \n SELECT 3;\n \nEND;\n \n//\n \nDELIMITER \n \ncall p1();\n+---+\n| 1 |\n+---+\n| 1 |\n+---+\n1 row in set (0.000 sec)\n \n+---+\n| 3 |\n+---+\n| 3 |\n+---+\n1 row in set (0.000 sec)\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/goto/','','https://mariadb.com/kb/en/library/goto/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (310,23,'IF','Syntax\n------ \nIF search_condition THEN statement_list\n [ELSEIF search_condition THEN statement_list] ...\n [ELSE statement_list]\nEND IF;\n \nDescription\n----------- \nIF implements a basic conditional construct. If the\nsearch_condition\nevaluates to true, the corresponding SQL statement list is\nexecuted.\nIf no search_condition matches, the statement list in the\nELSE clause\nis executed. Each statement_list consists of one or more\nstatements.\n \n\n\nURL: https://mariadb.com/kb/en/library/if/','','https://mariadb.com/kb/en/library/if/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (311,23,'ITERATE','Syntax\n------ \nITERATE label\n \nITERATE can appear only within LOOP, REPEAT, and WHILE\nstatements.\nITERATE means \"do the loop again\", and uses the\nstatement\'s label to determine which statements to repeat.\nThe label must be in the same stored program, not in a\ncaller procedure.\n \nIf you try to use ITERATE with a non-existing label, or if\nthe label is associated to a construct which is not a loop,\nthe following error will be produced:\n \nERROR 1308 (42000): ITERATE with no matching label: \n \nBelow is an example of how ITERATE might be used:\n \nCREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n label1: LOOP\n SET p1 = p1 + 1;\n \n IF p1 \n\nURL: https://mariadb.com/kb/en/library/iterate/','','https://mariadb.com/kb/en/library/iterate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (312,23,'Labels','Syntax\n------ \nlabel: \n[label]\n \nLabels are MariaDB identifiers which can be used to identify\na BEGIN ... END construct or a loop. They have a maximum\nlength of 16 characters and can be quoted with backticks\n(i.e.., `).\n \nLabels have a start part and an end part. The start part\nmust precede the portion of code it refers to, must be\nfollowed by a colon (:) and can be on the same or different\nline. The end part is optional and adds nothing, but can\nmake the code more readable. If used, the end part must\nprecede the construct\'s delimiter (;). Constructs\nidentified by a label can be nested. Each construct can be\nidentified by only one label.\n \nLabels need not be unique in the stored program they belong\nto. However, a label for an inner loop cannot be identical\nto a label for an outer loop. In this case, the following\nerror would be produced:\n \nERROR 1309 (42000): Redefining label \n \nLEAVE and ITERATE statements can be used to exit or repeat a\nportion of code identified by a label. They must be in the\nsame Stored Routine, Trigger or Event which contains the\ntarget label.\n \nBelow is an example using a simple label that is used to\nexit a LOOP:\n \nCREATE PROCEDURE `test_sp`()\nBEGIN\n `my_label`:\n LOOP\n SELECT \'looping\';\n \n LEAVE `my_label`;\n \n END LOOP;\n \n SELECT \'out of loop\';\n \nEND;\n \nThe following label is used to exit a procedure, and has an\nend part:\n \nCREATE PROCEDURE `test_sp`()\n`my_label`:\nBEGIN\n IF @var = 1 THEN\n LEAVE `my_label`;\n \n END IF;\n \n DO something();\nEND `my_label`;\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/labels/','','https://mariadb.com/kb/en/library/labels/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (313,23,'LEAVE','Syntax\n------ \nLEAVE label\n \nThis statement is used to exit the flow control construct\nthat has the\ngiven label. The label must be in the same stored program,\nnot in a caller procedure. LEAVE can be used within BEGIN\n... END or loop constructs\n(LOOP, REPEAT, WHILE). In Stored Procedures, Triggers and\nEvents, LEAVE can refer to the outmost BEGIN ... END\nconstruct; in that case, the program exits the procedure. In\nStored Functions, RETURN can be used instead.\n \nNote that LEAVE cannot be used to exit a DECLARE HANDLER\nblock.\n \nIf you try to LEAVE a non-existing label, or if you try to\nLEAVE a HANDLER block, the following error will be produced:\n \nERROR 1308 (42000): LEAVE with no matching label: \n \nThe following example uses LEAVE to exit the procedure if a\ncondition is true:\n \nCREATE PROCEDURE proc(IN p TINYINT)\nCONTAINS SQL\n`whole_proc`:\nBEGIN\n SELECT 1;\n \n IF p \n\nURL: https://mariadb.com/kb/en/library/leave/','','https://mariadb.com/kb/en/library/leave/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (314,23,'LOOP','Syntax\n------ \n[begin_label:] LOOP\n statement_list\nEND LOOP [end_label]\n \nDescription\n----------- \nLOOP implements a simple loop construct, enabling repeated\nexecution\nof the statement list, which consists of one or more\nstatements, each\nterminated by a semicolon (i.e., ;) statement delimiter. The\nstatements\nwithin the loop are repeated until the loop is exited;\nusually this is\naccomplished with a LEAVE statement.\n \nA LOOP statement can be labeled. end_label cannot be given\nunless\nbegin_label also is present. If both are present, they must\nbe the\nsame.\n \nSee Delimiters in the mysql client for more on delimiter\nusage in the client.\n \n\n\nURL: https://mariadb.com/kb/en/library/loop/','','https://mariadb.com/kb/en/library/loop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (315,23,'OPEN','Syntax\n------ \n\n\nURL: https://mariadb.com/kb/en/library/open/','','https://mariadb.com/kb/en/library/open/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (316,23,'REPEAT LOOP','Syntax\n------ \n[begin_label:] REPEAT\n statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n \nThe statement list within a REPEAT statement is repeated\nuntil the\nsearch_condition is true. Thus, a REPEAT always enters the\nloop at\nleast once. statement_list consists of one or more\nstatements, each\nterminated by a semicolon (i.e., ;) statement delimiter.\n \nA REPEAT statement can be labeled. end_label cannot be given\nunless\nbegin_label also is present. If both are present, they must\nbe the\nsame.\n \nSee Delimiters in the mysql client for more on client\ndelimiter usage.\n \nDELIMITER //\n \nCREATE PROCEDURE dorepeat(p1 INT)\n BEGIN\n SET @x = 0;\n \n REPEAT SET @x = @x + 1;\n UNTIL @x > p1 END REPEAT;\n \n END\n//\n \nCALL dorepeat(1000)//\n \nSELECT @x//\n+------+\n| @x |\n+------+\n| 1001 |\n+------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/repeat-loop/','','https://mariadb.com/kb/en/library/repeat-loop/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (317,23,'RESIGNAL','SIGNAL and RESIGNAL were both introduced in MariaDB 5.5.\n \nSyntax\n------ \nRESIGNAL [error_condition]\n [SET error_property\n [, error_property] ...]\n \nerror_condition:\n SQLSTATE [VALUE] \'sqlstate_value\'\n | condition_name\n \nerror_property:\n error_property_name = \n \nerror_property_name:\n CLASS_ORIGIN\n | SUBCLASS_ORIGIN\n | MESSAGE_TEXT\n | MYSQL_ERRNO\n | CONSTRAINT_CATALOG\n | CONSTRAINT_SCHEMA\n | CONSTRAINT_NAME\n | CATALOG_NAME\n | SCHEMA_NAME\n | TABLE_NAME\n | COLUMN_NAME\n | CURSOR_NAME\n \nDescription\n----------- \nThe syntax of RESIGNAL and its semantics are very similar to\nSIGNAL. This statement can only be used within an error\nHANDLER. It produces an error, like SIGNAL. RESIGNAL clauses\nare the same as SIGNAL, except that they all are optional,\neven SQLSTATE. All the properties which are not specified in\nRESIGNAL, will be identical to the properties of the error\nthat was received by the error HANDLER. For a description of\nthe clauses, see diagnostics area.\n \nNote that RESIGNAL does not empty the diagnostics area: it\njust appends another error condition.\n \nRESIGNAL, without any clauses, produces an error which is\nidentical to the error that was received by HANDLER.\n \nIf used out of a HANDLER construct, RESIGNAL produces the\nfollowing error:\n \nERROR 1645 (0K000): RESIGNAL when handler not active\n \nIn MariaDB 5.5, if a HANDLER contained a CALL to another\nprocedure, that procedure could use RESIGNAL. Since MariaDB\n10.0, trying to do this raises the above error.\n \nFor a list of SQLSTATE values and MariaDB error codes, see\nMariaDB Error Codes.\n \nThe following procedure tries to query two tables which\ndon\'t exist, producing a 1146 error in both cases. Those\nerrors will trigger the HANDLER. The first time the error\nwill be ignored and the client will not receive it, but the\nsecond time, the error is re-signaled, so the client will\nreceive it.\n \nCREATE PROCEDURE test_error( )\nBEGIN\n DECLARE CONTINUE HANDLER\n FOR 1146\n BEGIN\n IF @hide_errors IS FALSE THEN\n RESIGNAL;\n \n END IF;\n \n END;\n \n SET @hide_errors = TRUE;\n \n SELECT \'Next error will be ignored\' AS msg;\n \n SELECT `c` FROM `temptab_one`;\n \n SELECT \'Next error won\'\'t be ignored\' AS msg;\n \n SET @hide_errors = FALSE;\n \n SELECT `c` FROM `temptab_two`;\n \nEND;\n \nCALL test_error( );\n \n+----------------------------+\n| msg |\n+----------------------------+\n| Next error will be ignored |\n+----------------------------+\n \n+-----------------------------+\n| msg |\n+-----------------------------+\n| Next error won\'t be ignored |\n+-----------------------------+\n \nERROR 1146 (42S02): Table \'test.temptab_two\' doesn\'t\nexist\n \nThe following procedure re-signals an error, modifying only\nthe error message to clarify the cause of the problem.\n \nCREATE PROCEDURE test_error()\nBEGIN\n DECLARE CONTINUE HANDLER\n FOR 1146\n BEGIN\n RESIGNAL SET\n MESSAGE_TEXT = \'`temptab` does not exist\';\n \n END;\n \n SELECT `c` FROM `temptab`;\n \nEND;\n \nCALL test_error( );\nERROR 1146 (42S02): `temptab` does not exist\n \nAs explained above, this works on MariaDB 5.5, but produces\na 1645 error since 10.0.\n \nCREATE PROCEDURE handle_error()\nBEGIN\n RESIGNAL;\n \nEND;\n \nCREATE PROCEDURE p()\nBEGIN\n DECLARE EXIT HANDLER FOR SQLEXCEPTION CALL p();\n SIGNAL SQLSTATE \'45000\';\n \nEND;\n \n\n\nURL: https://mariadb.com/kb/en/library/resignal/','','https://mariadb.com/kb/en/library/resignal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (318,23,'RETURN','Syntax\n------ \nRETURN expr \n \nThe RETURN statement terminates execution of a stored\nfunction and\nreturns the value expr to the function caller. There must be\nat least\none RETURN statement in a stored function. If the function\nhas multiple exit points, all exit points must have a\nRETURN.\n \nThis statement is not used in stored procedures, triggers,\nor events. LEAVE can be used instead.\n \nThe following example shows that RETURN can return the\nresult of a scalar subquery:\n \nCREATE FUNCTION users_count() RETURNS BOOL\n READS SQL DATA\nBEGIN\n RETURN (SELECT COUNT(DISTINCT User) FROM mysql.user);\nEND;\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/return/','','https://mariadb.com/kb/en/library/return/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (319,23,'SELECT INTO','Syntax\n------ \nSELECT col_name [, col_name] ...\n INTO var_name [, var_name] ...\n table_expr\n \nDescription\n----------- \nSELECT ... INTO enables selected columns to be stored\ndirectly\ninto variables. No resultset is produced. The query should\nreturn a single row. If the query\nreturns no rows, a warning with error code 1329 occurs (No\ndata), and\nthe variable values remain unchanged. If the query returns\nmultiple\nrows, error 1172 occurs (Result consisted of more than one\nrow). If it\nis possible that the statement may retrieve multiple rows,\nyou can use\nLIMIT 1 to limit the result set to a single row.\n \nThe INTO clause can also be specified at the end of the\nstatement.\n \nIn the context of such statements that occur as part of\nevents\nexecuted by the Event Scheduler, diagnostics messages (not\nonly\nerrors, but also warnings) are written to the error log,\nand, on\nWindows, to the application event log.\n \nThis statement can be used with both local variables and\nuser-defined variables.\n \nFor the complete syntax, see SELECT.\n \nAnother way to set a variable\'s value is the SET statement.\n \nSELECT ... INTO results are not stored in the query cache\neven if SQL_CACHE is specified.\n \nExamples\n-------- \nSELECT id, data INTO @x,@y \nFROM test.t1 LIMIT 1;\n \n\n\nURL: https://mariadb.com/kb/en/library/selectinto/','','https://mariadb.com/kb/en/library/selectinto/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (320,23,'SIGNAL','SIGNAL and RESIGNAL were both introduced in MariaDB 5.5.\n \nSyntax\n------ \nSIGNAL error_condition\n [SET error_property\n [, error_property] ...]\n \nerror_condition:\n SQLSTATE [VALUE] \'sqlstate_value\'\n | condition_name\n \nerror_property:\n error_property_name = \n \nerror_property_name:\n CLASS_ORIGIN\n | SUBCLASS_ORIGIN\n | MESSAGE_TEXT\n | MYSQL_ERRNO\n | CONSTRAINT_CATALOG\n | CONSTRAINT_SCHEMA\n | CONSTRAINT_NAME\n | CATALOG_NAME\n | SCHEMA_NAME\n | TABLE_NAME\n | COLUMN_NAME\n | CURSOR_NAME\n \nSIGNAL empties the diagnostics area and produces a custom\nerror. This statement can be used anywhere, but is generally\nuseful when used inside a stored program. When the error is\nproduced, it can be caught by a HANDLER. If not, the current\nstored program, or the current statement, will terminate\nwith the specified error.\n \nSometimes an error HANDLER just needs to SIGNAL the same\nerror it received, optionally with some changes. Usually the\nRESIGNAL statement is the most convenient way to do this.\n \nerror_condition can be an SQLSTATE value or a named error\ncondition defined via DECLARE CONDITION. SQLSTATE must be a\nconstant string consisting of five characters. These codes\nare standard to ODBC and ANSI SQL. For customized errors,\nthe recommended SQLSTATE is \'45000\'. For a list of\nSQLSTATE values used by MariaDB, see the MariaDB Error Codes\npage. The SQLSTATE can be read via the API method\nmysql_sqlstate( ). \n \nTo specify error properties user-defined variables and local\nvariables can be used, as well as character set conversions\n(but you can\'t set a collation).\n \nThe error properties, their type and their default values\nare explained in the diagnostics area page.\n \nErrors\n \nIf the SQLSTATE is not valid, the following error like this\nwill be produced:\n \nERROR 1407 (42000): Bad SQLSTATE: \'123456\'\n \nIf a property is specified more than once, an error like\nthis will be produced:\n \nERROR 1641 (42000): Duplicate condition information item\n\'MESSAGE_TEXT\'\n \nIf you specify a condition name which is not declared, an\nerror like this will be produced:\n \nERROR 1319 (42000): Undefined CONDITION: cond_name\n \nIf MYSQL_ERRNO is out of range, you will get an error like\nthis:\n \nERROR 1231 (42000): Variable \'MYSQL_ERRNO\' can\'t be set\nto the value of \'0\'\n \nExamples\n-------- \nHere\'s what happens if SIGNAL is used in the client to\ngenerate errors:\n \nSIGNAL SQLSTATE \'01000\';\n \nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+---------+------+------------------------------------------+\n| Level | Code | Message |\n+---------+------+------------------------------------------+\n| Warning | 1642 | Unhandled user-defined warning condition\n|\n+---------+------+------------------------------------------+\n1 row in set (0.06 sec)\n \nSIGNAL SQLSTATE \'02000\';\n \nERROR 1643 (02000): Unhandled user-defined not found\ncondition\n \nHow to specify MYSQL_ERRNO and MESSAGE_TEXT properties:\n \nSIGNAL SQLSTATE \'45000\' SET MYSQL_ERRNO=30001,\nMESSAGE_TEXT=\'H\nello, world!\';\n \nERROR 30001 (45000): Hello, world!\n \nThe following code shows how to use user variables, local\nvariables and character set conversion with SIGNAL:\n \nCREATE PROCEDURE test_error(x INT)\nBEGIN\n DECLARE errno SMALLINT UNSIGNED DEFAULT 31001;\n \n SET @errmsg = \'Hello, world!\';\n \n IF x = 1 THEN\n SIGNAL SQLSTATE \'45000\' SET\n MYSQL_ERRNO = errno,\n MESSAGE_TEXT = @errmsg;\n \n ELSE\n SIGNAL SQLSTATE \'45000\' SET\n MYSQL_ERRNO = errno,\n MESSAGE_TEXT = _utf8\'Hello, world!\';\n \n END IF;\n \nEND;\n \nHow to use named error conditions:\n \nCREATE PROCEDURE test_error(n INT)\nBEGIN\n DECLARE `too_big` CONDITION FOR SQLSTATE \'45000\';\n \n IF n > 10 THEN\n SIGNAL `too_big`;\n \n END IF;\n \nEND;\n \nIn this example, we\'ll define a HANDLER for an error code.\nWhen the error occurs, we SIGNAL a more informative error\nwhich makes sense for our procedure:\n \nCREATE PROCEDURE test_error()\nBEGIN\n DECLARE EXIT HANDLER\n FOR 1146\n BEGIN\n SIGNAL SQLSTATE \'45000\' SET\n MESSAGE_TEXT = \'Temporary tables not found; did you call\ninit() procedure?\';\n \n END;\n \n -- this will produce a 1146 error\n SELECT `c` FROM `temptab`;\n \nEND;\n \n\n\nURL: https://mariadb.com/kb/en/library/signal/','','https://mariadb.com/kb/en/library/signal/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (321,23,'WHILE','Syntax\n------ \n[begin_label:] WHILE search_condition DO\n statement_list\nEND WHILE [end_label]\n \nDescription\n----------- \nThe statement list within a WHILE statement is repeated as\nlong as the\nsearch_condition is true. statement_list consists of one or\nmore\nstatements. If the loop must be executed at least once,\nREPEAT ... LOOP can be used instead.\n \nA WHILE statement can be labeled. end_label cannot be given\nunless\nbegin_label also is present. If both are present, they must\nbe the\nsame.\n \nExamples\n-------- \nCREATE PROCEDURE dowhile()\nBEGIN\n DECLARE v1 INT DEFAULT 5;\n \n WHILE v1 > 0 DO\n ...\n SET v1 = v1 - 1;\n \n END WHILE;\n \nEND\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/while/','','https://mariadb.com/kb/en/library/while/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (322,24,'BUFFER','A synonym for ST_BUFFER.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/buffer/','','https://mariadb.com/kb/en/library/buffer/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (323,24,'CONVEXHULL','A synonym for ST_CONVEXHULL.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/convexhull/','','https://mariadb.com/kb/en/library/convexhull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (324,24,'GEOMETRYCOLLECTION','Syntax\n------ \nGeometryCollection(g1,g2,...)\n \nDescription\n----------- \nConstructs a WKB GeometryCollection. If any argument is not\na well-formed WKB representation of a geometry, the return\nvalue is NULL.\n \nExamples\n-------- \nCREATE TABLE gis_geometrycollection (g GEOMETRYCOLLECTION);\nSHOW FIELDS FROM gis_geometrycollection;\n \nINSERT INTO gis_geometrycollection VALUES\n (GeomCollFromText(\'GEOMETRYCOLLECTION(POINT(0 0),\nLINESTRING(0 0,10 10))\')),\n (GeometryFromWKB(AsWKB(GeometryCollection(Point(44, 6),\nLineString(Point(3, 6), Point(7, 9)))))),\n (GeomFromText(\'GeometryCollection()\')),\n (GeomFromText(\'GeometryCollection EMPTY\'));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/geometrycollection/','','https://mariadb.com/kb/en/library/geometrycollection/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (325,24,'LINESTRING','Syntax\n------ \nLineString(pt1,pt2,...)\n \nDescription\n----------- \nConstructs a WKB LineString value from a number of WKB Point\narguments. If any argument is not a WKB Point, the return\nvalue is\nNULL. If the number of Point arguments is less than two, the\nreturn value is NULL.\n \nExamples\n-------- \nSET @ls = \'LineString(1 1,2 2,3 3)\';\n \nSELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3) |\n+-------------------------------------+\n \nCREATE TABLE gis_line (g LINESTRING);\nINSERT INTO gis_line VALUES\n (LineFromText(\'LINESTRING(0 0,0 10,10 0)\')),\n (LineStringFromText(\'LINESTRING(10 10,20 10,20 20,10 20,10\n10)\')),\n (LineStringFromWKB(AsWKB(LineString(Point(10, 10),\nPoint(40, 10)))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/linestring/','','https://mariadb.com/kb/en/library/linestring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (326,24,'MULTILINESTRING','Syntax\n------ \nMultiLineString(ls1,ls2,...)\n \nDescription\n----------- \nConstructs a WKB MultiLineString value using WKB LineString\narguments. If any argument is not a WKB LineString, the\nreturn value is\nNULL.\n \nExample\n \nCREATE TABLE gis_multi_line (g MULTILINESTRING);\nINSERT INTO gis_multi_line VALUES\n (MultiLineStringFromText(\'MULTILINESTRING((10 48,10 21,10\n0),(16 0,16 23,16 48))\')),\n (MLineFromText(\'MULTILINESTRING((10 48,10 21,10 0))\')),\n (MLineFromWKB(AsWKB(MultiLineString(LineString(Point(1, 2),\nPoint(3, 5)), LineString(Point(2, 5),Point(5, 8),Point(21,\n7))))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/multilinestring/','','https://mariadb.com/kb/en/library/multilinestring/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (327,24,'MULTIPOINT','Syntax\n------ \nMultiPoint(pt1,pt2,...)\n \nDescription\n----------- \nConstructs a WKB MultiPoint value using WKB Point arguments.\nIf any argument is not a WKB Point, the return value is\nNULL.\n \nExamples\n-------- \nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9\n3, 8 4, 6 6, 6 9, 4 9, 1 5 )\');\n \nCREATE TABLE gis_multi_point (g MULTIPOINT);\nINSERT INTO gis_multi_point VALUES\n (MultiPointFromText(\'MULTIPOINT(0 0,10 10,10 20,20\n20)\')),\n (MPointFromText(\'MULTIPOINT(1 1,11 11,11 21,21 21)\')),\n (MPointFromWKB(AsWKB(MultiPoint(Point(3, 6), Point(4,\n10)))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/multipoint/','','https://mariadb.com/kb/en/library/multipoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (328,24,'MULTIPOLYGON','Syntax\n------ \nMultiPolygon(poly1,poly2,...)\n \nDescription\n----------- \nConstructs a WKB MultiPolygon value from a set of WKB\nPolygon arguments. If any argument is not a WKB Polygon, the\nreturn value is NULL.\n \nExample\n \nCREATE TABLE gis_multi_polygon (g MULTIPOLYGON);\nINSERT INTO gis_multi_polygon VALUES\n (MultiPolygonFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84\n42,28 26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67\n13,59 13,59 18)))\')),\n (MPolyFromText(\'MULTIPOLYGON(((28 26,28 0,84 0,84 42,28\n26),(52 18,66 23,73 9,48 6,52 18)),((59 18,67 18,67 13,59\n13,59 18)))\')),\n (MPolyFromWKB(AsWKB(MultiPolygon(Polygon(LineString(Point(0,\n3), Point(3, 3), Point(3, 0), Point(0, 3)))))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/multipolygon/','','https://mariadb.com/kb/en/library/multipolygon/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (329,24,'POINT','Syntax\n------ \nPoint(x,y)\n \nDescription\n----------- \nConstructs a WKB Point using the given coordinates.\n \nExamples\n-------- \nSET @g = ST_GEOMFROMTEXT(\'Point(1 1)\');\n \nCREATE TABLE gis_point (g POINT);\nINSERT INTO gis_point VALUES\n (PointFromText(\'POINT(10 10)\')),\n (PointFromText(\'POINT(20 10)\')),\n (PointFromText(\'POINT(20 20)\')),\n (PointFromWKB(AsWKB(PointFromText(\'POINT(10 20)\'))));\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/point/','','https://mariadb.com/kb/en/library/point/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (330,24,'PointOnSurface','A synonym for ST_PointOnSurface.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/pointonsurface/','','https://mariadb.com/kb/en/library/pointonsurface/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (331,24,'POLYGON','Syntax\n------ \nPolygon(ls1,ls2,...)\n \nDescription\n----------- \nConstructs a WKB Polygon value from a number of WKB\nLineString\narguments. If any argument does not represent the WKB of a\nLinearRing (that is,\nnot a closed and simple LineString) the return value is\nNULL.\n \nNote that according to the OpenGIS standard, a POLYGON\nshould have exactly one ExteriorRing and all other rings\nshould lie within that ExteriorRing and thus be the\nInteriorRings. Practically, however, some systems, including\nMariaDB\'s, permit polygons to have several\n\'ExteriorRings\'. In the case of there being multiple,\nnon-overlapping exterior rings ST_NUMINTERIORRINGS() will\nreturn 1.\n \nExamples\n-------- \nSET @g = ST_GEOMFROMTEXT(\'POLYGON((1 1,1 5,4 9,6 9,9 3,7\n2,1 1))\');\n \nCREATE TABLE gis_polygon (g POLYGON);\nINSERT INTO gis_polygon VALUES\n (PolygonFromText(\'POLYGON((10 10,20 10,20 20,10 20,10\n10))\')),\n (PolyFromText(\'POLYGON((0 0,50 0,50 50,0 50,0 0), (10\n10,20 10,20 20,10 20,10 10))\')),\n (PolyFromWKB(AsWKB(Polygon(LineString(Point(0, 0),\nPoint(30, 0), Point(30, 30), Point(0, 0))))));\n \nNon-overlapping \'polygon\':\n \nSELECT ST_NumInteriorRings(ST_PolyFromText(\'POLYGON((0 0,10\n0,10 10,0 10,0 0),\n (-1 -1,-5 -1,-5 -5,-1 -5,-1 -1))\')) AS NumInteriorRings;\n \n+------------------+\n| NumInteriorRings |\n+------------------+\n| 1 |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/polygon/','','https://mariadb.com/kb/en/library/polygon/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (332,24,'ST_BUFFER','Syntax\n------ \nST_BUFFER(g1,r)\nBUFFER(g1,r)\n \nDescription\n----------- \nReturns a geometry that represents all points whose distance\nfrom geometry g1 is less than or equal to distance, or\nradius, r.\n \nUses for this function could include creating for example a\nnew geometry representing a buffer zone around an island.\n \nBUFFER() is a synonym.\n \nExamples\n-------- \nDetermining whether a point is within a buffer zone:\n \nSET @g1 = ST_GEOMFROMTEXT(\'POLYGON((10 10, 10 20, 20 20, 20\n10, 10 10))\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'POINT(8 8)\');\n \nSELECT ST_WITHIN(@g2,ST_BUFFER(@g1,5));\n+---------------------------------+\n| ST_WITHIN(@g2,ST_BUFFER(@g1,5)) |\n+---------------------------------+\n| 1 |\n+---------------------------------+\n \nSELECT ST_WITHIN(@g2,ST_BUFFER(@g1,1));\n+---------------------------------+\n| ST_WITHIN(@g2,ST_BUFFER(@g1,1)) |\n+---------------------------------+\n| 0 |\n+---------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_buffer/','','https://mariadb.com/kb/en/library/st_buffer/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (333,24,'ST_CONVEXHULL','ST_ConvexHull() was introduced in MariaDB 10.1.2\n \nSyntax\n------ \nST_ConvexHull(g)\nConvexHull(g)\n \nDescription\n----------- \nGiven a geometry, returns a geometry that is the minimum\nconvex geometry enclosing all geometries within the set.\nReturns NULL if the geometry value is NULL or an empty\nvalue.\n \nST_ConvexHull() and ConvexHull() are synonyms.\n \nExamples\n-------- \nThe ConvexHull of a single point is simply the single point:\n \nSET @g = ST_GEOMFROMTEXT(\'Point(0 0)\');\n \nSELECT ST_ASTEXT(ST_CONVEXHULL(@g));\n+------------------------------+\n| ST_ASTEXT(ST_CONVEXHULL(@g)) |\n+------------------------------+\n| POINT(0 0) |\n+------------------------------+\n \nSET @g = ST_GEOMFROMTEXT(\'MultiPoint(0 0, 1 2, 2 3)\');\n \nSELECT ST_ASTEXT(ST_CONVEXHULL(@g));\n+------------------------------+\n| ST_ASTEXT(ST_CONVEXHULL(@g)) |\n+------------------------------+\n| POLYGON((0 0,1 2,2 3,0 0)) |\n+------------------------------+\n \nSET @g = ST_GEOMFROMTEXT(\'MultiPoint( 1 1, 2 2, 5 3, 7 2, 9\n3, 8 4, 6 6, 6 9, 4 9, 1 5 )\');\n \nSELECT ST_ASTEXT(ST_CONVEXHULL(@g));\n+----------------------------------------+\n| ST_ASTEXT(ST_CONVEXHULL(@g)) |\n+----------------------------------------+\n| POLYGON((1 1,1 5,4 9,6 9,9 3,7 2,1 1)) |\n+----------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_convexhull/','','https://mariadb.com/kb/en/library/st_convexhull/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (334,24,'ST_INTERSECTION','Syntax\n------ \nST_INTERSECTION(g1,g2)\n \nDescription\n----------- \nReturns a geometry that is the intersection, or shared\nportion, of geometry g1 and geometry g2.\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 1, 0 2)\');\n \nSELECT ASTEXT(ST_INTERSECTION(@g1,@g2));\n+----------------------------------+\n| ASTEXT(ST_INTERSECTION(@g1,@g2)) |\n+----------------------------------+\n| POINT(2 1) |\n+----------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_intersection/','','https://mariadb.com/kb/en/library/st_intersection/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (335,24,'ST_POINTONSURFACE','ST_POINTONSURFACE() was introduced in MariaDB 10.1.2\n \nSyntax\n------ \nST_PointOnSurface(g)\nPointOnSurface(g)\n \nDescription\n----------- \nGiven a geometry, returns a POINT guaranteed to intersect a\nsurface. However, see MDEV-7514.\n \nST_PointOnSurface() and PointOnSurface() are synonyms.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_pointonsurface/','','https://mariadb.com/kb/en/library/st_pointonsurface/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (336,24,'ST_SYMDIFFERENCE','Syntax\n------ \nST_SYMDIFFERENCE(g1,g2)\n \nDescription\n----------- \nReturns a geometry that represents the portions of geometry\ng1 and geometry g2 that don\'t intersect.\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'LINESTRING(10 20, 10 40)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(10 15, 10 25)\');\n \nSELECT ASTEXT(ST_SYMDIFFERENCE(@g1,@g2));\n+----------------------------------------------+\n| ASTEXT(ST_SYMDIFFERENCE(@g1,@g2)) |\n+----------------------------------------------+\n| MULTILINESTRING((10 15,10 20),(10 25,10 40)) |\n+----------------------------------------------+\n \nSET @g2 = ST_GeomFromText(\'LINESTRING(10 20, 10 41)\');\n \nSELECT ASTEXT(ST_SYMDIFFERENCE(@g1,@g2));\n+-----------------------------------+\n| ASTEXT(ST_SYMDIFFERENCE(@g1,@g2)) |\n+-----------------------------------+\n| LINESTRING(10 40,10 41) |\n+-----------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_symdifference/','','https://mariadb.com/kb/en/library/st_symdifference/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (337,24,'ST_UNION','Syntax\n------ \nST_UNION(g1,g2)\n \nDescription\n----------- \nReturns a geometry that is the union of the geometry g1 and\ngeometry g2.\n \nExamples\n-------- \nSET @g1 = GEOMFROMTEXT(\'POINT (0 2)\');\n \nSET @g2 = GEOMFROMTEXT(\'POINT (2 0)\');\n \nSELECT ASTEXT(ST_UNION(@g1,@g2));\n+---------------------------+\n| ASTEXT(ST_UNION(@g1,@g2)) |\n+---------------------------+\n| MULTIPOINT(2 0,0 2) |\n+---------------------------+\n \nSET @g1 = GEOMFROMTEXT(\'POLYGON((0 0,0 3,3 3,3 0,0 0))\');\n \nSET @g2 = GEOMFROMTEXT(\'POLYGON((2 2,4 2,4 4,2 4,2 2))\');\n \nSELECT ASTEXT(ST_UNION(@g1,@g2));\n+------------------------------------------------+\n| ASTEXT(ST_UNION(@g1,@g2)) |\n+------------------------------------------------+\n| POLYGON((0 0,0 3,2 3,2 4,4 4,4 2,3 2,3 0,0 0)) |\n+------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_union/','','https://mariadb.com/kb/en/library/st_union/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (338,26,'BINLOG','Syntax\n------ \nBINLOG \'str\'\n \nDescription\n----------- \nBINLOG is an internal-use statement. It is generated by the\nmysqlbinlog program as the printable representation of\ncertain events\nin binary log files. The \'str\' value is a base 64-encoded\nstring the that server decodes to determine the data change\nindicated by the\ncorresponding event. This statement requires the SUPER\nprivilege. It was added in MySQL 5.1.5.\n \n\n\nURL: https://mariadb.com/kb/en/library/binlog/','','https://mariadb.com/kb/en/library/binlog/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (339,26,'CACHE INDEX','Syntax\n------ \nCACHE INDEX \n tbl_index_list [, tbl_index_list] ...\n IN key_cache_name \n \ntbl_index_list:\n tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n \nDescription\n----------- \nThe CACHE INDEX statement assigns table indexes to a\nspecific key\ncache. It is used only for MyISAM tables.\n \nA default key cache exists and cannot be destroyed. To\ncreate more key caches, the key_buffer_size server system\nvariable.\n \nThe associations between tables indexes and key caches are\nlost on server restart. To recreate them automatically, it\nis necessary to configure caches in a configuration file and\ninclude some CACHE INDEX (and optionally LOAD INDEX)\nstatements in the init file.\n \nExamples\n-------- \nThe following statement assigns indexes from the tables t1,\nt2, and t3\nto the key cache named hot_cache:\n \nCACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table | Op | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status | OK |\n| test.t2 | assign_to_keycache | status | OK |\n| test.t3 | assign_to_keycache | status | OK |\n+---------+--------------------+----------+----------+\n \nImplementation (for MyISAM)\n \nNormally CACHE INDEX should not take a long time to execute.\nInternally it\'s implemented the following way:\nFind the right key cache (under\nLOCK_global_system_variables)\nOpen the table with a TL_READ_NO_INSERT lock.\nFlush the original key cache for the given file (under key\ncache lock)\nFlush the new key cache for the given file (safety)\nMove the file to the new key cache (under file share lock)\n \nThe only possible long operations are getting the locks for\nthe table and flushing the original key cache, if there were\nmany key blocks for the file in it.\n \nWe plan to also add CACHE INDEX for Aria tables if there is\na need for this.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/cache-index/','','https://mariadb.com/kb/en/library/cache-index/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (340,26,'FLUSH','Syntax\n------ \nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n flush_option [, flush_option] ...\n \nor when flushing tables:\n \nFLUSH [NO_WRITE_TO_BINLOG | LOCAL] TABLES [table_list]\n[table_flush_option]\n \nwhere table_list is a list of tables separated by , (comma).\n \nDescription\n----------- \nThe FLUSH statement clears or reloads various internal\ncaches used by\nMariaDB. To execute FLUSH, you must have the RELOAD\nprivilege. See GRANT.\n \nThe RESET statement is similar to FLUSH. See\nRESET.\n \nYou cannot issue a FLUSH statement from within a stored\nfunction or a trigger. Doing so within a stored procedure is\npermitted, as long as it is not called by a stored function\nor trigger. See Stored Routine Limitations, Stored Function\nLimitations and Trigger Limitations.\n \nIf a listed table is a view, an error like the following\nwill be produced:\n \nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n \nBy default, FLUSH statements are written to the binary log\nand will be replicated. The NO_WRITE_TO_BINLOG keyword\n(LOCAL is an alias) will ensure the statement is not written\nto the binary log. \n \nThe different flush options are:\n \nOption | Description | \n \nCHANGED_PAGE_BITMAPS | Internal command used for backup\npurposes. See the Information Schema CHANGED_PAGE_BITMAPS\nTable. | \n \nCLIENT_STATISTICS | Reset client statistics (see SHOW\nCLIENT_STATISTICS). | \n \nDES_KEY_FILE | Reloads the DES key file (Specified with the\n--des-key-file startup option). | \n \nHOSTS | Flush the hostname cache (used for converting ip to\nhost names and for unblocking blocked hosts. See\nmax_connect_errors) | \n \nINDEX_STATISTICS | Reset index statistics (see SHOW\nINDEX_STATISTICS). | \n \n[ERROR | ENGINE | GENERAL | SLOW | BINARY | RELAY] LOGS |\nClose and reopen the specified log type, or all log types if\nnone are specified. FLUSH RELAY LOGS [connection-name] can\nbe used to flush the relay logs for a specific connection.\nOnly one connection can be specified per FLUSH command. See\nMulti-source replication. FLUSH ENGINE LOGS will delete all\nunneeded Aria redo logs. | \n \nMASTER | Deprecated option, use RESET MASTER instead. | \n \nPRIVILEGES | Reload all privileges from the privilege tables\nin the mysql database. If the server is started with\n--skip-grant-table option, this will activate the privilege\ntables again. | \n \nQUERY CACHE | Defragment the query cache to better utilize\nits memory. If you want to reset the query cache, you can do\nit with RESET QUERY CACHE. | \n \nQUERY_RESPONSE_TIME | See the QUERY_RESPONSE_TIME plugin. | \n \nSLAVE | Deprecated option, use RESET SLAVE instead. | \n \nSSL | Used to dynamically reinitialize the server\'s TLS\ncontext by reloading the files defined by several TLS system\nvariables. See FLUSH SSL for more information. This command\nwas first added in MariaDB 10.4.1. | \n \nSTATUS | Resets all server status variables that can be\nreset to 0. Not all global status variables support this, so\nnot all global values are reset. See FLUSH STATUS for more\ninformation. | \n \nTABLE | Close tables given as options or all open tables if\nno table list was used. From MariaDB 10.4.1, using without\nany table list will only close tables not in use, and tables\nnot locked by the FLUSH TABLES connection. If there are no\nlocked tables, FLUSH TABLES will be instant and will not\ncause any waits, as it no longer waits for tables in use.\nWhen a table list is provided, from MariaDB 10.4.1, the\nserver will wait for the end of any transactions that are\nusing the tables. Previously, FLUSH TABLES only waited for\nthe statements to complete. | \n \nTABLES | Same as FLUSH TABLE. | \n \nTABLES ... FOR EXPORT | For InnoDB tables, flushes table\nchanges to disk to permit binary table copies while the\nserver is running. Introduced in MariaDB 10.0.8. See FLUSH\nTABLES ... FOR EXPORT for more. | \n \nTABLES WITH READ LOCK | Closes all open tables. New tables\nare only allowed to be opened with read locks until an\nUNLOCK TABLES is given. | \n \nTABLES WITH READ LOCK AND DISABLE CHECKPOINT | As TABLES\nWITH READ LOCK but also disable all checkpoint writes by\ntransactional table engines. This is useful when doing a\ndisk snapshot of all tables. | \n \nTABLE_STATISTICS | Reset table statistics (see SHOW\nTABLE_STATISTICS). | \n \nUSER_RESOURCES | Resets all per hour user resources. This\nenables clients that have exhausted their resources to\nconnect again. | \n \nUSER_STATISTICS | Reset user statistics (see SHOW\nUSER_STATISTICS). | \n \nYou can also use the mysqladmin client to flush things. Use\nmysqladmin --help to examine what flush commands it\nsupports.\n \nFLUSH STATUS\n \nServer status variables can be reset by executing the\nfollowing:\n \nFLUSH STATUS;\n \nGlobal Status Variables that Support FLUSH STATUS\n \nNot all global status variables support being reset by FLUSH\nSTATUS. Currently, the following status variables are reset\nby FLUSH STATUS:\nAborted_clients\nAborted_connects\nAria_pagecache_blocks_not_flushed\nAria_pagecache_blocks_unused\nAria_pagecache_blocks_used\nBinlog_cache_disk_use\nBinlog_cache_use\nBinlog_stmt_cache_disk_use\nBinlog_stmt_cache_use\nConnection_errors_accept\nConnection_errors_internal\nConnection_errors_max_connections\nConnection_errors_peer_address\nConnection_errors_select\nConnection_errors_tcpwrap\nCreated_tmp_files\nDelayed_errors\nDelayed_writes\nFeature_check_constraint\nFeature_delay_key_write\nMax_used_connections\nOpened_plugin_libraries\nPerformance_schema_accounts_lost\nPerformance_schema_cond_instances_lost\nPerformance_schema_digest_lost\nPerformance_schema_file_handles_lost\nPerformance_schema_file_instances_lost\nPerformance_schema_hosts_lost\nPerformance_schema_locker_lost\nPerformance_schema_mutex_instances_lost\nPerformance_schema_rwlock_instances_lost\nPerformance_schema_session_connect_attrs_lost\nPerformance_schema_socket_instances_lost\nPerformance_schema_stage_classes_lost\nPerformance_schema_statement_classes_lost\nPerformance_schema_table_handles_lost\nPerformance_schema_table_instances_lost\nPerformance_schema_thread_instances_lost\nPerformance_schema_users_lost\nQcache_hits\nQcache_inserts\nQcache_lowmem_prunes\nQcache_not_cached\nRpl_semi_sync_master_no_times\nRpl_semi_sync_master_no_tx\nRpl_semi_sync_master_timefunc_failures\nRpl_semi_sync_master_wait_pos_backtraverse\nRpl_semi_sync_master_yes_tx\nRpl_transactions_multi_engine\nServer_audit_writes_failed\nSlave_retried_transactions\nSlow_launch_threads\nSsl_accept_renegotiates\nSsl_accepts\nSsl_callback_cache_hits\nSsl_client_connects\nSsl_connect_renegotiates\nSsl_ctx_verify_depth\nSsl_ctx_verify_mode\nSsl_finished_accepts\nSsl_finished_connects\nSsl_session_cache_hits\nSsl_session_cache_misses\nSsl_session_cache_overflows\nSsl_session_cache_size\nSsl_session_cache_timeouts\nSsl_sessions_reused\nSsl_used_session_cache_entries\nSubquery_cache_hit\nSubquery_cache_miss\nTable_locks_immediate\nTable_locks_waited\nTc_log_max_pages_used\nTc_log_page_waits\nTransactions_gtid_foreign_engine\nTransactions_multi_engine\n \nFLUSH SSL\n \nThe FLUSH SSL command was first added in MariaDB 10.4.\n \nIn MariaDB 10.4 and later, the FLUSH SSL command can be used\nto dynamically reinitialize the server\'s TLS context. This\nis most useful if you need to replace a certificate that is\nabout to expire without restarting the server.\n \nThis operation is performed by reloading the files defined\nby the following TLS system variables:\nssl_cert\nssl_key\nssl_ca\nssl_capath\nssl_crl\nssl_crlpath\n \nThese TLS system variables are not dynamic, so their values\ncan not be changed without restarting the server.\n \nIf you want to dynamically reinitialize the server\'s TLS\ncontext, then you need to change the certificate and key\nfiles at the relevant paths defined by these TLS system\nvariables, without actually changing the values of the\nvariables. See MDEV-19341 for more information.\n \nReducing Memory Usage\n \nTo flush some of the global caches that take up memory, you\ncould execute the following command:\n \nFLUSH LOCAL HOSTS,\n QUERY CACHE, \n TABLE_STATISTICS, \n INDEX_STATISTICS, \n USER_STATISTICS;\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/flush/','','https://mariadb.com/kb/en/library/flush/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (341,26,'FLUSH QUERY CACHE','Description\n----------- \nYou can defragment the query cache to better utilize its\nmemory with\nthe FLUSH QUERY CACHE statement. The statement does not\nremove any queries from the cache.\n \nThe RESET QUERY CACHE statement removes all query results\nfrom the query cache.\nThe FLUSH TABLES statement also does this.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/flush-query-cache/','','https://mariadb.com/kb/en/library/flush-query-cache/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (342,26,'FLUSH TABLES FOR EXPORT','FLUSH TABLES ... FOR EXPORT was introduced in MariaDB\n10.0.8.\n \nSyntax\n------ \nFLUSH TABLES table_name [, table_name] FOR EXPORT\n \nDescription\n----------- \nFLUSH TABLES ... FOR EXPORT flushes changes to the specified\ntables to disk so that binary copies can be made while the\nserver is still running. This works for Archive, Aria, CSV,\nInnoDB, MyISAM, MERGE, and XtraDB tables.\n \nThe table is read locked until one has issued UNLOCK TABLES.\n \nIf a storage engine does not support FLUSH TABLES FOR\nEXPORT, a 1031 error (SQLSTATE \'HY000\') is produced.\n \nIf FLUSH TABLES ... FOR EXPORT is in effect in the session,\nthe following statements will produce an error if attempted:\nFLUSH TABLES WITH READ LOCK\nFLUSH TABLES ... WITH READ LOCK\nFLUSH TABLES ... FOR EXPORT\nAny statement trying to update any table\n \nIf any of the following statements is in effect in the\nsession, attempting  FLUSH TABLES ... FOR EXPORT will\nproduce an error.\nFLUSH TABLES ... WITH READ LOCK\nFLUSH TABLES ... FOR EXPORT\nLOCK TABLES ... READ\nLOCK TABLES ... WRITE\n \nFLUSH FOR EXPORT is not written to the binary log.\n \nThis statement requires the RELOAD and the LOCK TABLES\nprivileges.\n \nIf one of the specified tables cannot be locked, none of the\ntables will be locked.\n \nIf a table does not exist, an error like the following will\nbe produced:\n \nERROR 1146 (42S02): Table \'test.xxx\' doesn\'t exist\n \nIf a table is a view, an error like the following will be\nproduced:\n \nERROR 1347 (HY000): \'test.v\' is not BASE TABLE\n \nExample\n \nFLUSH TABLES test.t1 FOR EXPORT;\n# Copy files related to the table (see below)\nUNLOCK TABLES;\n \nFor a full description, please see copying MariaDB tables.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/flush-tables-for-export/','','https://mariadb.com/kb/en/library/flush-tables-for-export/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (343,26,'HELP Command','Syntax\n------ \nHELP search_string\n \nDescription\n----------- \nThe HELP command can be used in any MariaDB client, such as\nthe mysql command-line client, to get basic syntax help and\na short description for most commands and functions. \n \nIf you provide an argument to the HELP command, the mysql\nclient uses it as a search string to access server-side\nhelp. The proper operation of this command requires that the\nhelp tables in the mysql database be initialized with help\ntopic information.\n \nIf there is no match for the search string, the search\nfails. Use help contents to see a list of the help\ncategories:\n \nHELP contents\nYou asked for help about help category: \"Contents\"\nFor more information, type \'help \', where  is one of the\nfollowing\ncategories:\n \n Account Management\n Administration\n Compound Statements\n Data Definition\n Data Manipulation\n Data Types\n Functions\n Functions and Modifiers for Use with GROUP BY\n Geographic Features\n Language Structure\n Plugins\n Table Maintenance\n Transactions\n User-Defined Functions\n Utility\n \nIf a search string matches multiple items, MariaDB shows a\nlist of matching topics:\n \nHELP create\nMany help items for your request exist.\nTo make a more specific request, please type \'help \',\nwhere  is one of the following\ntopics:\n CREATE DATABASE\n CREATE EVENT\n CREATE FUNCTION\n CREATE FUNCTION UDF\n CREATE INDEX\n CREATE PROCEDURE\n CREATE SERVER\n CREATE TABLE\n CREATE TABLESPACE\n CREATE TRIGGER\n CREATE USER\n CREATE VIEW\n SHOW\n SHOW CREATE DATABASE\n SHOW CREATE EVENT\n SHOW CREATE FUNCTION\n SHOW CREATE PROCEDURE\n SHOW CREATE TABLE\n SPATIAL\n \nThen you can enter a topic as the search string to see the\nhelp entry for that topic.\n \nThe help is provided with the MariaDB server and makes use\nof four help tables found in the mysql database:\nhelp_relation, help_topic, help_category and help_keyword.\nThese tables are populated by the mysql_install_db or\nfill_help_table.sql scripts which currently contain data\ngenerated from an old version of MySQL.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/help-command/','','https://mariadb.com/kb/en/library/help-command/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (344,26,'KILL [CONNECTION | QUERY]','Syntax\n------ \nKILL [HARD | SOFT] [CONNECTION | QUERY [ID] ] [thread_id |\nUSER user_name | query_id]\n \nMariaDB 5.3.2\n \nThe options HARD | SOFT and USER username were introduced in\nMariaDB 5.3.2\n \nMariaDB 10.0.5\n \nKILL QUERY ID query_id, which permits killing a query by\nquery id rather than thread id, was introduced in MariaDB\n10.0.5.\n \nDescription\n----------- \nEach connection to mysqld runs in a separate thread. You can\nsee which threads\nare running with the SHOW PROCESSLIST statement and kill a\nthread with the KILL thread_id statement. \nKILL allows the optional CONNECTION or\nQUERY modifier:\nKILL CONNECTION is the same as KILL with no\n modifier: It terminates the connection associated with the\ngiven thread or query id.\nKILL QUERY terminates the statement that the connection\nthread_id is\n currently executing, but leaves the connection itself\nintact.\nKILL QUERY ID (introduced in MariaDB 10.0.5) terminates the\nquery by query_id, leaving the connection intact.\n \nIf a connection is terminated that has an active\ntransaction, the transaction will be rolled back. If only a\nquery is killed, the current transaction will stay active.\nSee also idle_transaction_timeout.\n \nIf you have the PROCESS privilege, you can see all threads.\nIf\nyou have the SUPER privilege, you can kill all threads and\nstatements. Otherwise, you can see and kill only your own\nthreads and\nstatements.\n \nKilling queries that repair or create indexes on MyISAM and\nAria tables may result in corrupted tables. Use the SOFT\noption to avoid this!\n \nThe HARD option (default) kills a command as soon as\npossible. If you use\nSOFT, then critical operations that may leave a table in an\ninconsistent state will not be interrupted. Such operations\ninclude REPAIR and INDEX creation for MyISAM and Aria tables\n(REPAIR TABLE, OPTIMIZE TABLE).\n \nKILL ... USER username will kill all connections/queries for\na\ngiven user. USER can be specified one of the following ways:\nusername (Kill without regard to hostname)\nusername@hostname\nCURRENT_USER or CURRENT_USER()\n \nIf you specify a thread id and that thread does not exist,\nyou get the following error:\n \nERROR 1094 (HY000): Unknown thread id: \n \nIf you specify a query id that doesn\'t exist, you get the\nfollowing error:\n \nERROR 1957 (HY000): Unknown query id: \n \nHowever, if you specify a user name, no error is issued for\nnon-connected (or even non-existing) users. To check if the\nconnection/query has been killed, you can use the\nROW_COUNT() function.\n \nA client whose connection is killed receives the following\nerror:\n \nERROR 1317 (70100): Query execution was interrupted\n \nTo obtain a list of existing sessions, use the SHOW\nPROCESSLIST statement or query the Information Schema\nPROCESSLIST table.\n \nNote: You cannot use KILL with the Embedded MySQL Server\nlibrary because the embedded server merely runs inside the\nthreads of the host\napplication. It does not create any connection threads of\nits own.\n \nNote: You can also use \nmysqladmin kill thread_id [,thread_id...]\nto kill connections. To get a list of running queries,\nuse mysqladmin processlist. See mysqladmin.\n \nPercona Toolkit contains a program, pt-kill that can be used\nto automatically kill connections that match certain\ncriteria. For example, it can be used to terminate idle\nconnections, or connections that have been busy for more\nthan 60 seconds.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/data-manipulation-kill-connection-query/','','https://mariadb.com/kb/en/library/data-manipulation-kill-connection-query/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (345,26,'LOAD INDEX','Syntax\n------ \nLOAD INDEX INTO CACHE\n tbl_index_list [, tbl_index_list] ...\n \ntbl_index_list:\n tbl_name\n [[INDEX|KEY] (index_name[, index_name] ...)]\n [IGNORE LEAVES]\n \nDescription\n----------- \nThe LOAD INDEX INTO CACHE statement preloads a table index\ninto the key\ncache to which it has been assigned by an explicit CACHE\nINDEX\nstatement, or into the default key cache otherwise. \nLOAD INDEX INTO CACHE is used only for MyISAM or Aria\ntables. Until MariaDB 5.3, it was not supported for tables\nhaving user-defined partitioning, but this limitation was\nremoved in MariaDB 5.5.\n \nThe IGNORE LEAVES modifier causes only blocks for the\nnonleaf nodes of\nthe index to be preloaded.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/load-index/','','https://mariadb.com/kb/en/library/load-index/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (346,26,'RESET','Syntax\n------ \nRESET reset_option [, reset_option] ...\n \nDescription\n----------- \nThe RESET statement is used to clear the state of various\nserver\noperations. You must have the RELOAD privilege to execute\nRESET.\n \nRESET acts as a stronger version of the FLUSH statement.\n \nThe different RESET options are:\n \nOption | Description | \n \nSLAVE [\"connection_name\"] [ALL] | Deletes all relay logs\nfrom the slave and reset the replication position in the\nmaster binary log. | \n \nMASTER | Deletes all old binary logs, makes the binary index\nfile (--log-bin-index) empty and creates a new binary log\nfile. This is useful when you want to reset the master to an\ninitial state. If you want to just delete old, not used\nbinary logs, you should use the PURGE BINARY LOGS command. |\n\n \nQUERY CACHE | Removes all queries from the query cache. See\nalso FLUSH QUERY CACHE. | \n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/reset/','','https://mariadb.com/kb/en/library/reset/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (347,26,'SET','Syntax\n------ \nSET variable_assignment [, variable_assignment] ...\n \nvariable_assignment:\n user_var_name = expr\n | [GLOBAL | SESSION] system_var_name = expr\n | [@@global. | @@session. | @@]system_var_name = expr\n \nOne can also set a user variable in any expression with this\nsyntax:\n \nuser_var_name:= expr\n \nDescription\n----------- \nThe SET statement assigns values to different types of\nvariables that affect the operation of the server or your\nclient. Older\nversions of MySQL employed SET OPTION, but this syntax was\ndeprecated in favor of SET without OPTION, and was removed\nin MariaDB 10.0.\n \nChanging a system variable by using the SET statement does\nnot make the change permanently. To do so, the change must\nbe made in a configuration file.\n \nFor setting variables on a per-query basis (from MariaDB\n10.1.2), see SET STATEMENT.\n \nSee SHOW VARIABLES for documentation on viewing server\nsystem variables.\n \nSee Server System Variables for a list of all the system\nvariables.\n \nGLOBAL / SESSION\n \nWhen setting a system variable, the scope can be specified\nas either GLOBAL or SESSION.\n \nA global variable change affects all new sessions. It does\nnot affect any currently open sessions, including the one\nthat made the change. \n \nA session variable change affects the current session only.\n \nIf the variable has a session value, not specifying either\nGLOBAL or SESSION will be the same as specifying SESSION. If\nthe variable only has a global value, not specifying GLOBAL\nor SESSION will apply to the change to the global value.\n \nDEFAULT\n \nSetting a global variable to DEFAULT will restore it to the\nserver default, and setting a session variable to DEFAULT\nwill restore it to the current global value.\n \nExamples\n-------- \ninnodb_sync_spin_loops is a global variable.\nskip_parallel_replication is a session variable.\nmax_error_count is both global and session.\n \nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE \n VARIABLE_NAME LIKE \'max_error_count\' OR \n VARIABLE_NAME LIKE \'skip_parallel_replication\' OR \n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n \n+---------------------------+---------------+--------------+\n| VARIABLE_NAME | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT | 64 | 64 |\n| SKIP_PARALLEL_REPLICATION | OFF | NULL |\n| INNODB_SYNC_SPIN_LOOPS | NULL | 30 |\n+---------------------------+---------------+--------------+\n \nSetting the session values:\n \nSET max_error_count=128;\nQuery OK, 0 rows affected (0.000 sec)\n \nSET skip_parallel_replication=ON;\nQuery OK, 0 rows affected (0.000 sec)\n \nSET innodb_sync_spin_loops=60;\n \nERROR 1229 (HY000): Variable \'innodb_sync_spin_loops\' is a\nGLOBAL variable \n and should be set with SET GLOBAL\n \nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE \n VARIABLE_NAME LIKE \'max_error_count\' OR \n VARIABLE_NAME LIKE \'skip_parallel_replication\' OR \n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n \n+---------------------------+---------------+--------------+\n| VARIABLE_NAME | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT | 128 | 64 |\n| SKIP_PARALLEL_REPLICATION | ON | NULL |\n| INNODB_SYNC_SPIN_LOOPS | NULL | 30 |\n+---------------------------+---------------+--------------+\n \nSetting the global values:\n \nSET GLOBAL max_error_count=256;\n \nSET GLOBAL skip_parallel_replication=ON;\n \nERROR 1228 (HY000): Variable \'skip_parallel_replication\'\nis a SESSION variable \n and can\'t be used with SET GLOBAL\n \nSET GLOBAL innodb_sync_spin_loops=120;\n \nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE \n VARIABLE_NAME LIKE \'max_error_count\' OR \n VARIABLE_NAME LIKE \'skip_parallel_replication\' OR \n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n \n+---------------------------+---------------+--------------+\n| VARIABLE_NAME | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT | 128 | 256 |\n| SKIP_PARALLEL_REPLICATION | ON | NULL |\n| INNODB_SYNC_SPIN_LOOPS | NULL | 120 |\n+---------------------------+---------------+--------------+\n \nSHOW VARIABLES will by default return the session value\nunless the variable is global only.\n \nSHOW VARIABLES LIKE \'max_error_count\';\n \n+-----------------+-------+\n| Variable_name | Value |\n+-----------------+-------+\n| max_error_count | 128 |\n+-----------------+-------+\n \nSHOW VARIABLES LIKE \'skip_parallel_replication\';\n \n+---------------------------+-------+\n| Variable_name | Value |\n+---------------------------+-------+\n| skip_parallel_replication | ON |\n+---------------------------+-------+\n \nSHOW VARIABLES LIKE \'innodb_sync_spin_loops\';\n \n+------------------------+-------+\n| Variable_name | Value |\n+------------------------+-------+\n| innodb_sync_spin_loops | 120 |\n+------------------------+-------+\n \nUsing the inplace syntax:\n \nSELECT (@a:=1);\n+---------+\n| (@a:=1) |\n+---------+\n| 1 |\n+---------+\n \nSELECT @a;\n \n+------+\n| @a |\n+------+\n| 1 |\n+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/set/','','https://mariadb.com/kb/en/library/set/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (348,26,'About SHOW','SHOW has many forms that provide information about\ndatabases, tables, columns, or status information about the\nserver. These include:\nSHOW AUTHORS\nSHOW CHARACTER SET [like_or_where]\nSHOW COLLATION [like_or_where]\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name]\n[like_or_where]\nSHOW CONTRIBUTORS\nSHOW CREATE DATABASE db_name\nSHOW CREATE EVENT event_name\nSHOW CREATE PACKAGE package_name\nSHOW CREATE PACKAGE BODY package_name\nSHOW CREATE PROCEDURE proc_name\nSHOW CREATE TABLE tbl_name\nSHOW CREATE TRIGGER trigger_name\nSHOW CREATE VIEW view_name\nSHOW DATABASES [like_or_where]\nSHOW ENGINE engine_name {STATUS | MUTEX}\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW [FULL] EVENTS\nSHOW FUNCTION CODE func_name\nSHOW FUNCTION STATUS [like_or_where]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW INNODB STATUS\nSHOW OPEN TABLES [FROM db_name] [like_or_where]\nSHOW PLUGINS\nSHOW PROCEDURE CODE proc_name\nSHOW PROCEDURE STATUS [like_or_where]\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW PROFILE [types] [FOR QUERY n] [OFFSET n] [LIMIT n]\nSHOW PROFILES\nSHOW [GLOBAL | SESSION] STATUS [like_or_where]\nSHOW TABLE STATUS [FROM db_name] [like_or_where]\nSHOW TABLES [FROM db_name] [like_or_where]\nSHOW TRIGGERS [FROM db_name] [like_or_where]\nSHOW [GLOBAL | SESSION] VARIABLES [like_or_where]\nSHOW WARNINGS [LIMIT [offset,] row_count]\n \nlike_or_where:\n LIKE \'pattern\'\n | WHERE expr\n \nIf the syntax for a given SHOW statement includes a\nLIKE \'pattern\' part, \'pattern\' is a\nstring that can contain the SQL \"%\" and\n\"_\" wildcard characters. The pattern is useful for\nrestricting statement output to matching values.\n \nSeveral SHOW statements also accept a\nWHERE clause that provides more flexibility in specifying\nwhich rows to display. See Extended Show.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/about-show/','','https://mariadb.com/kb/en/library/about-show/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (349,26,'SHOW AUTHORS','Syntax\n------ \nSHOW AUTHORS\n \nDescription\n----------- \nThe SHOW AUTHORS statement displays information about the\npeople who work on MariaDB. For each author, it displays\nName, Location, and\nComment values. All columns are encoded as latin1.\n \nIn MariaDB 5.5 this is in somewhat random order.\n \nIn MariaDB 10.0.5 and later you have:\nFirst the active people in MariaDB are listed.\nThen the active people in MySQL.\nLast the people that has contributed to MariaDB/MySQL in the\npast.\n \nThe order is somewhat related to importance of the\ncontribution given to the MariaDB project, but this is not\n100% accurate. There is still room for improvements and\ndebate...\n \nExample\n \nSHOW AUTHORS;\n+--------------------------------+---------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------+\n| Name | Location | Comment |\n+--------------------------------+---------------------------------------+-----------------------------------------------------------------------------------------------------------------------------------------+\n| Michael (Monty) Widenius | Tusby, Finland | Lead developer\nand main author |\n| Sergei Golubchik | Kerpen, Germany | Architect, Full-text\nsearch, precision math, plugin framework, merges etc |\n| Igor Babaev | Bellevue, USA | Optimizer, keycache, core\nwork |\n| Sergey Petrunia | St. Petersburg, Russia | Optimizer |\n| Oleksandr Byelkin | Lugansk, Ukraine | Query Cache (4.0),\nSubqueries (4.1), Views (5.0) |\n| Timour Katchaounov | Sofia , Bulgaria | Optimizer |\n| Kristian Nielsen | Copenhagen, Denmark | Replication,\nAsync client prototocol, General buildbot stuff |\n| Alexander (Bar) Barkov | Izhevsk, Russia | Unicode and\ncharacter sets |\n| Alexey Botchkov (Holyfoot) | Izhevsk, Russia | GIS\nextensions, embedded server, precision math |\n| Daniel Bartholomew | Raleigh, USA | MariaDB documentation\n|\n| Colin Charles | Selangor, Malesia | MariaDB documentation,\ntalks at a LOT of conferences |\n| Sergey Vojtovich | Izhevsk, Russia | initial\nimplementation of plugin architecture, maintained native\nstorage engines (MyISAM, MEMORY, ARCHIVE, etc), rewrite of\ntable cache |\n| Vladislav Vaintroub | Mannheim, Germany | MariaDB Java\nconnector, new thread pool, Windows optimizations |\n| Elena Stepanova | Sankt Petersburg, Russia | QA, test\ncases |\n| Georg Richter | Heidelberg, Germany | New LGPL C\nconnector, PHP connector |\n| Jan Lindström | Ylämylly, Finland | Working on InnoDB |\n| Lixun Peng | Hangzhou, China | Multi Source replication |\n| Percona | CA, USA | XtraDB, microslow patches, extensions\nto slow log \n...\n \nSee Also\n \nSHOW CONTRIBUTORS. This list all members and sponsors of the\nMariaDB Foundation and other sponsors.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-authors/','','https://mariadb.com/kb/en/library/show-authors/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (350,26,'SHOW BINARY LOGS','Syntax\n------ \nSHOW BINARY LOGS\nSHOW MASTER LOGS\n \nDescription\n----------- \nLists the binary log files on the server. This statement is\nused as part of the\nprocedure described in \nPURGE BINARY LOGS, that shows how to\ndetermine which logs can be purged.\n \nExamples\n-------- \nSHOW BINARY LOGS;\n+--------------------+-----------+\n| Log_name | File_size |\n+--------------------+-----------+\n| mariadb-bin.000001 | 19039 |\n| mariadb-bin.000002 | 717389 |\n| mariadb-bin.000003 | 300 |\n| mariadb-bin.000004 | 333 |\n| mariadb-bin.000005 | 899 |\n| mariadb-bin.000006 | 125 |\n| mariadb-bin.000007 | 18907 |\n| mariadb-bin.000008 | 19530 |\n| mariadb-bin.000009 | 151 |\n| mariadb-bin.000010 | 151 |\n| mariadb-bin.000011 | 125 |\n| mariadb-bin.000012 | 151 |\n| mariadb-bin.000013 | 151 |\n| mariadb-bin.000014 | 125 |\n| mariadb-bin.000015 | 151 |\n| mariadb-bin.000016 | 314 |\n+--------------------+-----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-binary-logs/','','https://mariadb.com/kb/en/library/show-binary-logs/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (351,26,'SHOW BINLOG EVENTS','Syntax\n------ \nSHOW BINLOG EVENTS\n [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n \nDescription\n----------- \nShows the events in the binary log. If you do not specify\n\'log_name\',\nthe first binary log is displayed.\n \nExample\n \nSHOW BINLOG EVENTS IN \'mysql_sandbox10019-bin.000002\';\n+-------------------------------+-----+-------------------+-----------+-------------+------------------------------------------------+\n| Log_name | Pos | Event_type | Server_id | End_log_pos |\nInfo |\n+-------------------------------+-----+-------------------+-----------+-------------+------------------------------------------------+\n| mysql_sandbox10019-bin.000002 | 4 | Format_desc | 1 | 248\n| Server ver: 10.0.19-MariaDB-log, Binlog ver: 4 |\n| mysql_sandbox10019-bin.000002 | 248 | Gtid_list | 1 | 273\n| [] |\n| mysql_sandbox10019-bin.000002 | 273 | Binlog_checkpoint |\n1 | 325 | mysql_sandbox10019-bin.000002 |\n| mysql_sandbox10019-bin.000002 | 325 | Gtid | 1 | 363 |\nGTID 0-1-1 |\n| mysql_sandbox10019-bin.000002 | 363 | Query | 1 | 446 |\nCREATE DATABASE blog |\n| mysql_sandbox10019-bin.000002 | 446 | Gtid | 1 | 484 |\nGTID 0-1-2 |\n| mysql_sandbox10019-bin.000002 | 484 | Query | 1 | 571 |\nuse `blog`; CREATE TABLE bb (id INT) |\n+-------------------------------+-----+-------------------+-----------+-------------+------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-binlog-events/','','https://mariadb.com/kb/en/library/show-binlog-events/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (352,26,'SHOW CHARACTER SET','Syntax\n------ \nSHOW CHARACTER SET\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nThe SHOW CHARACTER SET statement shows all available\ncharacter sets. The LIKE clause, if present on its own,\nindicates which character\nset names to match. The WHERE and LIKE clauses can be given\nto select rows using more general conditions, as discussed\nin Extended SHOW.\n \nThe same information can be queried from the\ninformation_schema.CHARACTER_SETS table.\n \nSee Setting Character Sets and Collations for details on\nspecifying the character set at the server, database, table\nand column levels.\n \nExamples\n-------- \nSHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1 | cp1252 West European | latin1_swedish_ci | 1 |\n| latin2 | ISO 8859-2 Central European | latin2_general_ci |\n1 |\n| latin5 | ISO 8859-9 Turkish | latin5_turkish_ci | 1 |\n| latin7 | ISO 8859-13 Baltic | latin7_general_ci | 1 |\n+---------+-----------------------------+-------------------+--------+\n \nSHOW CHARACTER SET WHERE Maxlen LIKE \'2\';\n+---------+---------------------------+-------------------+--------+\n| Charset | Description | Default collation | Maxlen |\n+---------+---------------------------+-------------------+--------+\n| big5 | Big5 Traditional Chinese | big5_chinese_ci | 2 |\n| sjis | Shift-JIS Japanese | sjis_japanese_ci | 2 |\n| euckr | EUC-KR Korean | euckr_korean_ci | 2 |\n| gb2312 | GB2312 Simplified Chinese | gb2312_chinese_ci | 2\n|\n| gbk | GBK Simplified Chinese | gbk_chinese_ci | 2 |\n| ucs2 | UCS-2 Unicode | ucs2_general_ci | 2 |\n| cp932 | SJIS for Windows Japanese | cp932_japanese_ci | 2\n|\n+---------+---------------------------+-------------------+--------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-character-set/','','https://mariadb.com/kb/en/library/show-character-set/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (353,26,'SHOW CLIENT_STATISTICS','MariaDB 5.2 introduced the User Statistics feature.\n \nSyntax\n------ \nSHOW CLIENT_STATISTICS\n \nDescription\n----------- \nThe SHOW CLIENT_STATISTICS statement was introduced in\nMariaDB 5.2 as part of the User Statistics feature. It was\nremoved as a separate statement in MariaDB 10.1.1, but\neffectively replaced by the generic SHOW\ninformation_schema_table statement. The\ninformation_schema.CLIENT_STATISTICS table holds statistics\nabout client connections.\n \nThe userstat system variable must be set to 1 to activate\nthis feature. See the User Statistics and\ninformation_schema.CLIENT_STATISTICS articles for more\ninformation.\n \nExample\n \nFrom MariaDB 10.0:\n \nSHOW CLIENT_STATISTICS\\G\n*************************** 1. row\n***************************\n Client: localhost\n Total_connections: 35\nConcurrent_connections: 0\n Connected_time: 708\n Busy_time: 2.5557979999999985\n Cpu_time: 0.04123740000000002\n Bytes_received: 3883\n Bytes_sent: 21595\n Binlog_bytes_written: 0\n Rows_read: 18\n Rows_sent: 115\n Rows_deleted: 0\n Rows_inserted: 0\n Rows_updated: 0\n Select_commands: 70\n Update_commands: 0\n Other_commands: 0\n Commit_transactions: 1\n Rollback_transactions: 0\n Denied_connections: 0\n Lost_connections: 0\n Access_denied: 0\n Empty_queries: 35\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/show-client-statistics/','','https://mariadb.com/kb/en/library/show-client-statistics/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (354,26,'SHOW COLLATION','Syntax\n------ \nSHOW COLLATION\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nThe output from SHOW COLLATION includes all available\ncollations. The LIKE clause, if present on its own,\nindicates which collation names to match. The WHERE and LIKE\nclauses can be given to select rows using more general\nconditions, as discussed in Extended SHOW.\n \nThe same information can be queried from the\ninformation_schema.COLLATIONS table.\n \nSee Setting Character Sets and Collations for details on\nspecifying the collation at the server, database, table and\ncolumn levels.\n \nExamples\n-------- \nSHOW COLLATION LIKE \'latin1%\';\n+-------------------+---------+----+---------+----------+---------+\n| Collation | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1 | 5 | | Yes | 1 |\n| latin1_swedish_ci | latin1 | 8 | Yes | Yes | 1 |\n| latin1_danish_ci | latin1 | 15 | | Yes | 1 |\n| latin1_german2_ci | latin1 | 31 | | Yes | 2 |\n| latin1_bin | latin1 | 47 | | Yes | 1 |\n| latin1_general_ci | latin1 | 48 | | Yes | 1 |\n| latin1_general_cs | latin1 | 49 | | Yes | 1 |\n| latin1_spanish_ci | latin1 | 94 | | Yes | 1 |\n+-------------------+---------+----+---------+----------+---------+\n \nSHOW COLLATION WHERE Sortlen LIKE \'8\' AND Charset LIKE\n\'utf8\';\n+--------------------+---------+-----+---------+----------+---------+\n| Collation | Charset | Id | Default | Compiled | Sortlen |\n+--------------------+---------+-----+---------+----------+---------+\n| utf8_unicode_ci | utf8 | 192 | | Yes | 8 |\n| utf8_icelandic_ci | utf8 | 193 | | Yes | 8 |\n| utf8_latvian_ci | utf8 | 194 | | Yes | 8 |\n| utf8_romanian_ci | utf8 | 195 | | Yes | 8 |\n| utf8_slovenian_ci | utf8 | 196 | | Yes | 8 |\n| utf8_polish_ci | utf8 | 197 | | Yes | 8 |\n| utf8_estonian_ci | utf8 | 198 | | Yes | 8 |\n| utf8_spanish_ci | utf8 | 199 | | Yes | 8 |\n| utf8_swedish_ci | utf8 | 200 | | Yes | 8 |\n| utf8_turkish_ci | utf8 | 201 | | Yes | 8 |\n| utf8_czech_ci | utf8 | 202 | | Yes | 8 |\n| utf8_danish_ci | utf8 | 203 | | Yes | 8 |\n| utf8_lithuanian_ci | utf8 | 204 | | Yes | 8 |\n| utf8_slovak_ci | utf8 | 205 | | Yes | 8 |\n| utf8_spanish2_ci | utf8 | 206 | | Yes | 8 |\n| utf8_roman_ci | utf8 | 207 | | Yes | 8 |\n| utf8_persian_ci | utf8 | 208 | | Yes | 8 |\n| utf8_esperanto_ci | utf8 | 209 | | Yes | 8 |\n| utf8_hungarian_ci | utf8 | 210 | | Yes | 8 |\n| utf8_sinhala_ci | utf8 | 211 | | Yes | 8 |\n| utf8_croatian_ci | utf8 | 213 | | Yes | 8 |\n+--------------------+---------+-----+---------+----------+---------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-collation/','','https://mariadb.com/kb/en/library/show-collation/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (355,26,'SHOW COLUMNS','Syntax\n------ \nSHOW [FULL] {COLUMNS | FIELDS} FROM tbl_name [FROM db_name]\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nSHOW COLUMNS displays information about the columns in a\ngiven table. It also works for views. The LIKE clause, if\npresent on its own, indicates which column names to match.\nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nIf the data types differ from what you expect them to be\nbased on a\nCREATE TABLE statement, note that MariaDB sometimes changes\ndata types when you create or alter a table. The conditions\nunder which this\noccurs are described in the Silent Column Changes article.\n \nThe FULL keyword causes the output to include the column\ncollation and comments, as well as the privileges you have\nfor each column.\n \nYou can use db_name.tbl_name as an alternative to the\ntbl_name FROM db_name syntax. In other words, these two\nstatements are equivalent:\n \nSHOW COLUMNS FROM mytable FROM mydb;\nSHOW COLUMNS FROM mydb.mytable;\n \nSHOW COLUMNS displays the following values for each table\ncolumn:\n \nField indicates the column name.\n \nType indicates the column data type.\n \nCollation indicates the collation for non-binary string\ncolumns, or\nNULL for other columns. This value is displayed only if you\nuse the\nFULL keyword.\n \nThe Null field contains YES if NULL values can be stored in\nthe column,\nNO if not.\n \nThe Key field indicates whether the column is indexed:\nIf Key is empty, the column either is not indexed or is\nindexed only as a\n secondary column in a multiple-column, non-unique index.\nIf Key is PRI, the column is a PRIMARY KEY or\n is one of the columns in a multiple-column PRIMARY KEY.\nIf Key is UNI, the column is the first column of a\nunique-valued\n index that cannot contain NULL values.\nIf Key is MUL, multiple occurrences of a given value are\nallowed\n within the column. The column is the first column of a\nnon-unique index or a\n unique-valued index that can contain NULL values.\n \nIf more than one of the Key values applies to a given column\nof a\ntable, Key displays the one with the highest priority, in\nthe order\nPRI, UNI, MUL.\n \nA UNIQUE index may be displayed as PRI if\nit cannot contain NULL values and there is no\nPRIMARY KEY in the table. A UNIQUE index\nmay display as MUL if several columns form a composite\nUNIQUE index; although the combination of the columns is\nunique, each column can still hold multiple occurrences of a\ngiven value.\n \nThe Default field indicates the default value that is\nassigned to the\ncolumn.\n \nThe Extra field contains any additional information that is\navailable about a given column.\n \nValue | Description | \n \nAUTO_INCREMENT | The column was created with the\nAUTO_INCREMENT keyword. | \n \nPERSISTENT | The column was created with the PERSISTENT\nkeyword. (New in 5.3) | \n \nVIRTUAL | The column was created with the VIRTUAL keyword.\n(New in 5.3) | \n \non update CURRENT_TIMESTAMP | The column is a TIMESTAMP\ncolumn that is automatically updated on INSERT and UPDATE. |\n\n \nPrivileges indicates the privileges you have for the column.\nThis\nvalue is displayed only if you use the FULL keyword.\n \nComment indicates any comment the column has. This value is\ndisplayed\nonly if you use the FULL keyword.\n \nSHOW FIELDS is a synonym for\nSHOW COLUMNS. Also DESCRIBE and EXPLAIN can be used as\nshortcuts.\n \nYou can also list a table\'s columns with: \n \nmysqlshow db_name tbl_name\n \nSee the mysqlshow command for more details.\n \nThe DESCRIBE statement provides information similar to SHOW\nCOLUMNS. The information_schema.COLUMNS table provides\nsimilar, but more complete, information.\n \nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX\nstatements also provide information about tables.\n \nExamples\n-------- \nSHOW COLUMNS FROM city;\n+------------+----------+------+-----+---------+----------------+\n| Field | Type | Null | Key | Default | Extra |\n+------------+----------+------+-----+---------+----------------+\n| Id | int(11) | NO | PRI | NULL | auto_increment |\n| Name | char(35) | NO | | | |\n| Country | char(3) | NO | UNI | | |\n| District | char(20) | YES | MUL | | |\n| Population | int(11) | NO | | 0 | |\n+------------+----------+------+-----+---------+----------------+\n \nSHOW COLUMNS FROM employees WHERE Type LIKE \'Varchar%\';\n+---------------+-------------+------+-----+---------+-------+\n| Field | Type | Null | Key | Default | Extra |\n+---------------+-------------+------+-----+---------+-------+\n| first_name | varchar(30) | NO | MUL | NULL | |\n| last_name | varchar(40) | NO | | NULL | |\n| position | varchar(25) | NO | | NULL | |\n| home_address | varchar(50) | NO | | NULL | |\n| home_phone | varchar(12) | NO | | NULL | |\n| employee_code | varchar(25) | NO | UNI | NULL | |\n+---------------+-------------+------+-----+---------+-------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-columns/','','https://mariadb.com/kb/en/library/show-columns/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (356,26,'SHOW CONTRIBUTORS','Syntax\n------ \nSHOW CONTRIBUTORS\n \nDescription\n----------- \nThe SHOW CONTRIBUTORS statement displays information about\nthe companies and people who financially contribute to\nMariaDB. For each contributor, it displays Name, Location,\nand Comment values. All columns are encoded as latin1.\n \nIn MariaDB 5.5 this is in somewhat random order, and the\nfeature was deprecated.\n \nIn MariaDB 10.0.5 it was un-deprecated, and since then\ndisplays all members and sponsors of the MariaDB Foundation\nas well as other financial contributors.\n \nExample\n \nSHOW CONTRIBUTORS;\n+---------------------+-------------------------------+-------------------------------------------------------------+\n| Name | Location | Comment |\n+---------------------+-------------------------------+-------------------------------------------------------------+\n| Booking.com | https://www.booking.com | Founding member,\nPlatinum Sponsor of the MariaDB Foundation |\n| Alibaba Cloud | https://www.alibabacloud.com/ | Platinum\nSponsor of the MariaDB Foundation |\n| Tencent Cloud | https://cloud.tencent.com | Platinum\nSponsor of the MariaDB Foundation |\n| Microsoft | https://microsoft.com/ | Platinum Sponsor of\nthe MariaDB Foundation |\n| MariaDB Corporation | https://mariadb.com | Founding\nmember, Platinum Sponsor of the MariaDB Foundation |\n| Visma | https://visma.com | Gold Sponsor of the MariaDB\nFoundation |\n| DBS | https://dbs.com | Gold Sponsor of the MariaDB\nFoundation |\n| IBM | https://www.ibm.com | Gold Sponsor of the MariaDB\nFoundation |\n| Tencent Games | http://game.qq.com/ | Gold Sponsor of the\nMariaDB Foundation |\n| Nexedi | https://www.nexedi.com | Silver Sponsor of the\nMariaDB Foundation |\n| Acronis | https://www.acronis.com | Silver Sponsor of the\nMariaDB Foundation |\n| Verkkokauppa.com | https://www.verkkokauppa.com | Bronze\nSponsor of the MariaDB Foundation |\n| Virtuozzo | https://virtuozzo.com | Bronze Sponsor of the\nMariaDB Foundation |\n| Tencent Game DBA | http://tencentdba.com/about | Bronze\nSponsor of the MariaDB Foundation |\n| Tencent TDSQL | http://tdsql.org | Bronze Sponsor of the\nMariaDB Foundation |\n| Percona | https://www.percona.com/ | Bronze Sponsor of the\nMariaDB Foundation |\n| Google | USA | Sponsoring encryption, parallel replication\nand GTID |\n| Facebook | USA | Sponsoring non-blocking API, LIMIT ROWS\nEXAMINED etc |\n| Ronald Bradford | Brisbane, Australia | EFF contribution\nfor UC2006 Auction |\n| Sheeri Kritzer | Boston, Mass. USA | EFF contribution for\nUC2006 Auction |\n| Mark Shuttleworth | London, UK. | EFF contribution for\nUC2006 Auction |\n+---------------------+-------------------------------+-------------------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-contributors/','','https://mariadb.com/kb/en/library/show-contributors/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (357,26,'SHOW CREATE DATABASE','Syntax\n------ \nSHOW CREATE {DATABASE | SCHEMA} db_name\n \nDescription\n----------- \nShows the CREATE DATABASE statement that\ncreates the given database. SHOW CREATE SCHEMA is a synonym\nfor SHOW CREATE DATABASE. SHOW CREATE DATABASE quotes\ndatabase names according to the value of the\nsql_quote_show_create server system variable.\n \nExamples\n-------- \nSHOW CREATE DATABASE test;\n+----------+-----------------------------------------------------------------+\n| Database | Create Database |\n+----------+-----------------------------------------------------------------+\n| test | CREATE DATABASE `test` /*!40100 DEFAULT CHARACTER\nSET latin1 */ |\n+----------+-----------------------------------------------------------------+\n \nSHOW CREATE SCHEMA test;\n+----------+-----------------------------------------------------------------+\n| Database | Create Database |\n+----------+-----------------------------------------------------------------+\n| test | CREATE DATABASE `test` /*!40100 DEFAULT CHARACTER\nSET latin1 */ |\n+----------+-----------------------------------------------------------------+\n \nWith sql_quote_show_create off:\n \nSHOW CREATE DATABASE test;\n+----------+---------------------------------------------------------------+\n| Database | Create Database |\n+----------+---------------------------------------------------------------+\n| test | CREATE DATABASE test /*!40100 DEFAULT CHARACTER SET\nlatin1 */ |\n+----------+---------------------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-database/','','https://mariadb.com/kb/en/library/show-create-database/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (358,26,'SHOW CREATE EVENT','Syntax\n------ \nSHOW CREATE EVENT event_name\n \nDescription\n----------- \nThis statement displays the CREATE EVENT\nstatement needed to re-create a given event, as well as the\nSQL_MODE that was used when the trigger has been created and\nthe character set used by the connection.. To find out which\nevents are present, use SHOW EVENTS.\n \nThe output of this statement is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n \nThe information_schema.EVENTS table provides similar, but\nmore complete, information.\n \nExamples\n-------- \nSHOW CREATE EVENT test.e_daily\\G\n*************************** 1. row\n***************************\n Event: e_daily\n sql_mode: \n time_zone: SYSTEM\n Create Event: CREATE EVENT `e_daily`\n ON SCHEDULE EVERY 1 DAY\n STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n ON COMPLETION NOT PRESERVE\n ENABLE\n COMMENT \'Saves total number of sessions then\n clears the table each day\'\n DO BEGIN\n INSERT INTO site_activity.totals (time, total)\n SELECT CURRENT_TIMESTAMP, COUNT(*) \n FROM site_activity.sessions;\n DELETE FROM site_activity.sessions;\n END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-event/','','https://mariadb.com/kb/en/library/show-create-event/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (359,26,'SHOW CREATE FUNCTION','Syntax\n------ \nSHOW CREATE FUNCTION func_name\n \nDescription\n----------- \nThis statement is similar to \nSHOW CREATE PROCEDURE but for\nstored functions.\n \nThe output of this statement is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n \nExample\n \nMariaDB [test]> SHOW CREATE FUNCTION VatCents\\G\n*************************** 1. row\n***************************\n Function: VatCents\n sql_mode: \n Create Function: CREATE DEFINER=`root`@`localhost` FUNCTION\n`VatCents`(price DECIMAL(10,2)) RETURNS int(11)\n DETERMINISTIC\nBEGIN\n DECLARE x INT;\n SET x = price * 114;\n RETURN x;\nEND\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-function/','','https://mariadb.com/kb/en/library/show-create-function/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (360,26,'SHOW CREATE PACKAGE','Oracle-style packages were introduced in MariaDB 10.3.5.\n \nSyntax\n------ \nSHOW CREATE PACKAGE [ db_name . ] package_name\n \nDescription\n----------- \nThe SHOW CREATE PACKAGE statement can be used when Oracle\nSQL_MODE is set.\n \nShows the CREATE statement that creates the given package\nspecification.\n \nExamples\n-------- \nSHOW CREATE PACKAGE employee_tools\\G\n*************************** 1. row\n***************************\n Package: employee_tools\n sql_mode:\nPIPES_AS_CONCAT,ANSI_QUOTES,IGNORE_SPACE,ORACLE,NO_KEY_OPTIONS,NO_TABLE_OPTIONS,NO_FIELD_OPTIONS,NO_AUTO_CREATE_USER\n Create Package: CREATE DEFINER=\"root\"@\"localhost\"\nPACKAGE \"employee_tools\" AS\n FUNCTION getSalary(eid INT) RETURN DECIMAL(10,2);\n PROCEDURE raiseSalary(eid INT, amount DECIMAL(10,2));\n PROCEDURE raiseSalaryStd(eid INT);\n PROCEDURE hire(ename TEXT, esalary DECIMAL(10,2));\nEND\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-package/','','https://mariadb.com/kb/en/library/show-create-package/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (361,26,'SHOW CREATE PACKAGE BODY','Oracle-style packages were introduced in MariaDB 10.3.5.\n \nSyntax\n------ \nSHOW CREATE PACKAGE BODY [ db_name . ] package_name\n \nDescription\n----------- \nThe SHOW CREATE PACKAGE BODY statement can be used when\nOracle SQL_MODE is set.\n \nShows the CREATE statement that creates the given package\nbody (i.e. the implementation).\n \nExamples\n-------- \nSHOW CREATE PACKAGE BODY employee_tools\\G\n*************************** 1. row\n***************************\n Package body: employee_tools\n sql_mode:\nPIPES_AS_CONCAT,ANSI_QUOTES,IGNORE_SPACE,ORACLE,NO_KEY_OPTIONS,NO_TABLE_OPTIONS,NO_FIELD_OPTIONS,NO_AUTO_CREATE_USER\n Create Package Body: CREATE DEFINER=\"root\"@\"localhost\"\nPACKAGE BODY \"employee_tools\" AS\n \n stdRaiseAmount DECIMAL(10,2):=500;\n \n PROCEDURE log (eid INT, ecmnt TEXT) AS\n BEGIN\n INSERT INTO employee_log (id, cmnt) VALUES (eid, ecmnt);\n END;\n \n PROCEDURE hire(ename TEXT, esalary DECIMAL(10,2)) AS\n eid INT;\n BEGIN\n INSERT INTO employee (name, salary) VALUES (ename,\nesalary);\n eid:= last_insert_id();\n log(eid, \'hire \' || ename);\n END;\n \n FUNCTION getSalary(eid INT) RETURN DECIMAL(10,2) AS\n nSalary DECIMAL(10,2);\n BEGIN\n SELECT salary INTO nSalary FROM employee WHERE id=eid;\n log(eid, \'getSalary id=\' || eid || \' salary=\' ||\nnSalary);\n RETURN nSalary;\n END;\n \n PROCEDURE raiseSalary(eid INT, amount DECIMAL(10,2)) AS\n BEGIN\n UPDATE employee SET salary=salary+amount WHERE id=eid;\n log(eid, \'raiseSalary id=\' || eid || \' amount=\' ||\namount);\n END;\n \n PROCEDURE raiseSalaryStd(eid INT) AS\n BEGIN\n raiseSalary(eid, stdRaiseAmount);\n log(eid, \'raiseSalaryStd id=\' || eid);\n END;\n \nBEGIN \n log(0, \'Session \' || connection_id() || \' \' ||\ncurrent_user || \' started\');\nEND\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/show-create-package-body/','','https://mariadb.com/kb/en/library/show-create-package-body/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (362,26,'SHOW CREATE PROCEDURE','Syntax\n------ \nSHOW CREATE PROCEDURE proc_name\n \nDescription\n----------- \nThis statement is a MariaDB extension. It returns the exact\nstring that\ncan be used to re-create the named stored procedure, as well\nas the SQL_MODE that was used when the trigger has been\ncreated and the character set used by the connection.. A\nsimilar\nstatement, SHOW CREATE FUNCTION,\ndisplays information about stored functions.\n \nBoth statements require that you are the owner of the\nroutine or have the SELECT privilege on the mysql.proc\ntable. When neither is true, the statements display NULL for\nthe Create Procedure or Create Function field.\n \nWarning Users with SELECT privileges on mysql.proc or USAGE\nprivileges on *.* can view the text of routines, even when\nthey do not have privileges for the function or procedure\nitself.\n \nThe output of these statements is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n \nExamples\n-------- \nHere\'s a comparison of the SHOW CREATE PROCEDURE and SHOW\nCREATE FUNCTION statements.\n \nSHOW CREATE PROCEDURE test.simpleproc\\G\n*************************** 1. row\n***************************\n Procedure: simpleproc\n sql_mode: \n Create Procedure: CREATE PROCEDURE `simpleproc`(OUT param1\nINT)\n BEGIN\n SELECT COUNT(*) INTO param1 FROM t;\n END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n \nSHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row\n***************************\n Function: hello\n sql_mode:\n Create Function: CREATE FUNCTION `hello`(s CHAR(20))\n RETURNS CHAR(50)\n RETURN CONCAT(\'Hello, \',s,\'!\')\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n \nWhen the user issuing the statement does not have privileges\non the routine, attempting to CALL the procedure raises\nError 1370.\n \nCALL test.prc1();\nError 1370 (42000): execute command denieed to user\n\'test_user\'@\'localhost\' for routine \'test\'.\'prc1\'\n \nIf the user neither has privilege to the routine nor the\nSELECT privilege on mysql.proc table, it raises Error 1305,\ninforming them that the procedure does not exist.\n \nSHOW CREATE TABLES test.prc1\\G\nError 1305 (42000): PROCEDURE prc1 does not exist\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/show-create-procedure/','','https://mariadb.com/kb/en/library/show-create-procedure/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (363,26,'SHOW CREATE SEQUENCE','Sequences were introduced in MariaDB 10.3.\n \nSyntax\n------ \nSHOW CREATE SEQUENCE sequence_name;\n \nDescription\n----------- \nShows the CREATE SEQUENCE statement that created the given\nsequence. The statement requires the SELECT privilege for\nthe table.\n \nExample\n \nCREATE SEQUENCE s1 START WITH 50;\n \nSHOW CREATE SEQUENCE s1\\G;\n \n*************************** 1. row\n***************************\n Table: t1\nCreate Table: CREATE SEQUENCE `s1` start with 50 minvalue 1\nmaxvalue 9223372036854775806\nincrement by 1 cache 1000 nocycle ENGINE=Aria\n \nNotes\n \nIf you want to see the underlying table structure used for\nthe SEQUENCE\nyou can use SHOW CREATE TABLE on the SEQUENCE. You can also\nuse SELECT to read the current recorded state of the\nSEQUENCE:\n \nCREATE SEQUENCE t1;\n \nSHOW CREATE TABLE s1\\G\n*************************** 1. row\n***************************\n Table: s1\nCreate Table: CREATE TABLE `s1` (\n `next_value` bigint(21) NOT NULL COMMENT \'next not cached\nvalue\',\n `min_value` bigint(21) NOT NULL COMMENT \'min value\',\n `max_value` bigint(21) NOT NULL COMMENT \'max value\',\n `start` bigint(21) NOT NULL COMMENT \'start value\',\n `increment` bigint(21) NOT NULL COMMENT \'increment\nvalue\',\n `cache` bigint(21) NOT NULL COMMENT \'cache size\',\n `cycle` tinyint(1) unsigned NOT NULL COMMENT \'cycle\nstate\',\n `round` bigint(21) NOT NULL COMMENT \'How many cycles has\nbeen done\'\n) ENGINE=Aria SEQUENCE=1\n \nSELECT * FROM s1;\n \n+------------+-----------+---------------------+-------+-----------+-------+-------+-------+\n| next_value | min_value | max_value | start | increment |\ncache | cycle | round |\n+------------+-----------+---------------------+-------+-----------+-------+-------+-------+\n| 1 | 1 | 9223372036854775806 | 1 | 1 | 1000 | 0 | 0 |\n+------------+-----------+---------------------+-------+-----------+-------+-------+-------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-sequence/','','https://mariadb.com/kb/en/library/show-create-sequence/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (364,26,'SHOW CREATE TABLE','Syntax\n------ \nSHOW CREATE TABLE tbl_name\n \nDescription\n----------- \nShows the CREATE TABLE statement that created the given\ntable. The statement requires the SELECT privilege for the\ntable. This statement also works with views and SEQUENCE.\n \nSHOW CREATE TABLE quotes table and\ncolumn names according to the value of the\nsql_quote_show_create server system variable.\n \nMariaDB and MySQL-specific table options, column options,\nand index options are not included in the output of this\nstatement if the NO_TABLE_OPTIONS, NO_FIELD_OPTIONS and\nNO_KEY_OPTIONS SQL_MODE flags are used.\n \nInvalid table options, column options and index options are\nnormally commented out (note, that it is possible to create\na table with invalid options, by altering a table of a\ndifferent engine, where these options were valid). To have\nthem uncommented, enable IGNORE_BAD_TABLE_OPTIONS SQL_MODE.\nRemember that replaying a CREATE TABLE statement with\nuncommented invalid options will fail with an error, unless\nIGNORE_BAD_TABLE_OPTIONS SQL_MODE is in effect.\n \nNote that SHOW CREATE TABLE is not meant to provide metadata\nabout a table. It provides information about how the table\nwas declared, but the real table structure could differ a\nbit. For example, if an index has been declared as HASH, the\nCREATE TABLE statement returned by SHOW CREATE TABLE will\ndeclare that index as HASH; however, it is possible that the\nindex is in fact a BTREE, because the storage engine does\nnot support HASH.\n \nMariaDB 10.2.1 permits TEXT and BLOB data types to be\nassigned a DEFAULT value. As a result, from MariaDB 10.2.1,\nSHOW CREATE TABLE will append a DEFAULT NULL to nullable\nTEXT or BLOB fields if no specific default is provided. \n \nFrom MariaDB 10.2.2, numbers are no longer quoted in the\nDEFAULT clause in SHOW CREATE statement. Previously, MariaDB\nquoted numbers. \n \nExamples\n-------- \nSHOW CREATE TABLE t\\G\n*************************** 1. row\n***************************\n Table: t\nCreate Table: CREATE TABLE `t` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `s` char(60) DEFAULT NULL,\n PRIMARY KEY (`id`)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n \nWith sql_quote_show_create off:\n \nSHOW CREATE TABLE t\\G\n*************************** 1. row\n***************************\n Table: t\nCreate Table: CREATE TABLE t (\n id int(11) NOT NULL AUTO_INCREMENT,\n s char(60) DEFAULT NULL,\n PRIMARY KEY (id)\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n \nUnquoted numeric DEFAULTs, from MariaDB 10.2.2:\n \nCREATE TABLE td (link TINYINT DEFAULT 1);\n \nSHOW CREATE TABLE td\\G\n*************************** 1. row\n***************************\n Table: td\nCreate Table: CREATE TABLE `td` (\n `link` tinyint(4) DEFAULT 1\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n \nQuoted numeric DEFAULTs, until MariaDB 10.2.1:\n \nCREATE TABLE td (link TINYINT DEFAULT 1);\n \nSHOW CREATE TABLE td\\G\n*************************** 1. row\n***************************\n Table: td\nCreate Table: CREATE TABLE `td` (\n `link` tinyint(4) DEFAULT \'1\'\n) ENGINE=InnoDB DEFAULT CHARSET=latin1\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-table/','','https://mariadb.com/kb/en/library/show-create-table/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (365,26,'SHOW CREATE TRIGGER','Syntax\n------ \nSHOW CREATE TRIGGER trigger_name\n \nDescription\n----------- \nThis statement shows a CREATE TRIGGER\nstatement that creates the given trigger, as well as the\nSQL_MODE that was used when the trigger has been created and\nthe character set used by the connection.\n \nThe output of this statement is unreliably affected by the\nsql_quote_show_create server system variable - see\nhttp://bugs.mysql.com/bug.php?id=12719\n \nExamples\n-------- \nSHOW CREATE TRIGGER example\\G\n*************************** 1. row\n***************************\n Trigger: example\n sql_mode:\nONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,STRICT_ALL_TABLES\n,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_\nENGINE_SUBSTITUTION\nSQL Original Statement: CREATE DEFINER=`root`@`localhost`\nTRIGGER example BEFORE\n INSERT ON t FOR EACH ROW\nBEGIN\n SET NEW.c = NEW.c * 2;\nEND\n character_set_client: cp850\n collation_connection: cp850_general_ci\n Database Collation: utf8_general_ci\n Created: 2016-09-29 13:53:34.35\n \nThe Created column was added in MySQL 5.7 and MariaDB 10.2.3\nas part of introducing multiple trigger events per action.\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-trigger/','','https://mariadb.com/kb/en/library/show-create-trigger/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (366,26,'SHOW CREATE USER','SHOW CREATE USER was introduced in MariaDB 10.2.0\n \nSyntax\n------ \nSHOW CREATE USER user_name\n \nDescription\n----------- \nShows the CREATE USER statement that created the given\nuser. The statement requires the SELECT privilege for the\nmysql database, except for the current user.\n \nExamples\n-------- \nCREATE USER foo4@test require cipher \'text\' \n issuer \'foo_issuer\' subject \'foo_subject\';\n \nSHOW CREATE USER foo4@test\\G\n*************************** 1. row\n***************************\nCREATE USER \'foo4\'@\'test\' \n REQUIRE ISSUER \'foo_issuer\' \n SUBJECT \'foo_subject\' \n CIPHER \'text\'\n \nUser Password Expiry:\n \nCREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE INTERVAL\n120 DAY;\n \nSHOW CREATE USER \'monty\'@\'localhost\';\n \n+------------------------------------------------------------------+\n| CREATE USER for monty@localhost |\n+------------------------------------------------------------------+\n| CREATE USER \'monty\'@\'localhost\' PASSWORD EXPIRE\nINTERVAL 120 DAY |\n+------------------------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-create-user/','','https://mariadb.com/kb/en/library/show-create-user/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (367,26,'SHOW CREATE VIEW','Syntax\n------ \nSHOW CREATE VIEW view_name\n \nDescription\n----------- \nThis statement shows a CREATE VIEW statement that creates\nthe given view, as well as the character set used by the\nconnection when the view was created. This statement\nalso works with views.\n \nSHOW CREATE VIEW quotes table, column and stored function\nnames according to the value of the sql_quote_show_create\nserver system variable.\n \nExamples\n-------- \nSHOW CREATE VIEW example\\G\n*************************** 1. row\n***************************\n View: example\n Create View: CREATE ALGORITHM=UNDEFINED\nDEFINER=`root`@`localhost` SQL\nSECURITY DEFINER VIEW `example` AS (select `t`.`id` AS\n`id`,`t`.`s` AS `s` from\n`t`)\ncharacter_set_client: cp850\ncollation_connection: cp850_general_ci\n \nWith sql_quote_show_create off:\n \nSHOW CREATE VIEW example\\G\n*************************** 1. row\n***************************\n View: example\n Create View: CREATE ALGORITHM=UNDEFINED\nDEFINER=root@localhost SQL SECU\nRITY DEFINER VIEW example AS (select t.id AS id,t.s AS s\nfrom t)\ncharacter_set_client: cp850\ncollation_connection: cp850_general_ci\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-create-view/','','https://mariadb.com/kb/en/library/show-create-view/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (368,26,'SHOW DATABASES','Syntax\n------ \nSHOW {DATABASES | SCHEMAS}\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nSHOW DATABASES lists the databases on the MariaDB server\nhost.\nSHOW SCHEMAS is a synonym for \nSHOW DATABASES. The LIKE clause, if\npresent on its own, indicates which database names to match.\nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nYou see only those databases for which you have some kind of\nprivilege, unless you have the global \nSHOW DATABASES privilege. You\ncan also get this list using the mysqlshow command.\n \nIf the server was started with the --skip-show-database\noption, you cannot use this statement at all unless you have\nthe\nSHOW DATABASES privilege.\n \nExample\n \nSHOW DATABASES;\n+--------------------+\n| Database |\n+--------------------+\n| information_schema |\n| mysql |\n| performance_schema |\n| test |\n+--------------------+\n \nSHOW DATABASES LIKE \'m%\';\n+---------------+\n| Database (m%) |\n+---------------+\n| mysql |\n+---------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-databases/','','https://mariadb.com/kb/en/library/show-databases/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (369,26,'SHOW ENGINE','Syntax\n------ \nSHOW ENGINE engine_name {STATUS | MUTEX}\n \nDescription\n----------- \nSHOW ENGINE displays operational information about a storage\nengine. The following statements currently are supported:\n \nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\n \nIf the Sphinx Storage Engine is installed, the following is\nalso supported:\n \nSHOW ENGINE SPHINX STATUS\n \nSee SHOW ENGINE SPHINX STATUS.\n \nOlder (and now removed) synonyms were SHOW INNODB STATUS\nfor SHOW ENGINE INNODB STATUS and \nSHOW MUTEX STATUS for \nSHOW ENGINE INNODB MUTEX.\n \nSHOW ENGINE BDB LOGS formerly displayed status information\nabout BDB log files. It was deprecated in MySQL 5.1.12 and\nremoved in MariaDB and MySQL 5.5, so now produces an error.\n \nSHOW ENGINE INNODB STATUS\n \nSHOW ENGINE INNODB STATUS displays extensive information\nfrom the standard InnoDB Monitor about the state of the\nInnoDB storage engine.\nSee SHOW ENGINE INNODB STATUS for more.\n \nSHOW ENGINE INNODB MUTEX\n \nSHOW ENGINE INNODB MUTEX displays InnoDB mutex statistics.\n \nThe statement displays the following output fields:\nType: Always InnoDB.\nName: The source file where the mutex is implemented, and\nthe line number\n in the file where the mutex is created. The line number is\ndependent on the MariaDB version.\nStatus: This field displays the following values if\nUNIV_DEBUG was defined at compilation time (for example, in\ninclude/univ.h in the InnoDB part of the source tree). Only\nthe os_waits value is displayed if UNIV_DEBUG was not\ndefined. Without UNIV_DEBUG, the information on which the\noutput is based is insufficient to distinguish regular\nmutexes and mutexes that protect\n rw-locks (which allow multiple readers or a single writer).\nConsequently, the\n output may appear to contain multiple rows for the same\nmutex.\ncount indicates how many times the mutex was requested.\nspin_waits indicates how many times the spinlock had to run.\nspin_rounds indicates the number of spinlock rounds.\n(spin_rounds divided by\n spin_waits provides the average round count.)\nos_waits indicates the number of operating system waits.\nThis occurs when\n the spinlock did not work (the mutex was not locked during\nthe spinlock and\n it was necessary to yield to the operating system and\nwait).\nos_yields indicates the number of times a the thread trying\nto lock a mutex\n gave up its timeslice and yielded to the operating system\n(on the\n presumption that allowing other threads to run will free\nthe mutex so that\n it can be locked).\nos_wait_times indicates the amount of time (in ms) spent in\noperating system\n waits, if the timed_mutexes system variable is 1 (ON). If\ntimed_mutexes is 0\n (OFF), timing is disabled, so os_wait_times is 0.\ntimed_mutexes is off by\n default.\n \nInformation from this statement can be used to diagnose\nsystem problems. For\nexample, large values of spin_waits and spin_rounds may\nindicate scalability\nproblems.\n \nThe information_schema.INNODB_MUTEXES table provides similar\ninformation.\n \nSHOW ENGINE PERFORMANCE_SCHEMA STATUS\n \nThis statement shows how much memory is used for\nperformance_schema tables and internal buffers.\n \nThe output contains the following fields:\nType: Always performance_schema.\nName: The name of a table, the name of an internal buffer,\nor the performance_schema word, followed by a dot and an\nattribute. Internal buffers names are enclosed by\nparenthesis. performance_schema means that the attribute\nrefers to the whole database (it is a total). \nStatus: The value for the attribute.\n \nThe following attributes are shown, in this order, for all\ntables:\nrow_size: The memory used for an individual record. This\nvalue will never change.\nrow_count: The number of rows in the table or buffer. For\nsome tables, this value depends on a server system variable.\nmemory: For tables and performance_schema, this is the\nresult of row_size * row_count.\n \nFor internal buffers, the attributes are:\ncount\nsize\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-engine/','','https://mariadb.com/kb/en/library/show-engine/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (370,26,'SHOW ENGINE INNODB STATUS','SHOW ENGINE INNODB STATUS is a specific form of the SHOW\nENGINE statement that displays the InnoDB Monitor output,\nwhich is extensive InnoDB information which can be useful in\ndiagnosing problems.\n \nThe following sections are displayed\nStatus: Shows the timestamp, monitor name and the number of\nseconds, or the elapsed time between the current time and\nthe time the InnoDB Monitor output was last displayed. The\nper-second averages are based upon this time.\nBACKGROUND THREAD: srv_master_thread lines show work\nperformed by the main background thread.\nSEMAPHORES: Threads waiting for a semaphore and stats on how\nthe number of times threads have needed a spin or a wait on\na mutex or rw-lock semaphore. If this number of threads is\nlarge, there may be I/O or contention issues. Reducing the\nsize of the innodb_thread_concurrency system variable may\nhelp if contention is related to thread scheduling. Spin\nrounds per wait shows the number of spinlock rounds per OS\nwait for a mutex. \nLATEST FOREIGN KEY ERROR: Only shown if there has been a\nforeign key constraint error, it displays the failed\nstatement and information about the constraint and the\nrelated tables.\nLATEST DETECTED DEADLOCK: Only shown if there has been a\ndeadlock, it displays the transactions involved in the\ndeadlock and the statements being executed, held and\nrequired locked and the transaction rolled back to.\nTRANSACTIONS: The output of this section can help identify\nlock contention, as well as reasons for the deadlocks.\nFILE I/O: InnoDB thread information as well as pending I/O\noperations and I/O performance statistics.\nINSERT BUFFER AND ADAPTIVE HASH INDEX: InnoDB insert buffer\nand adaptive hash index status information, including the\nnumber of each type of operation performed, and adaptive\nhash index performance.\nLOG: InnoDB log information, including current log sequence\nnumber, how far the log has been flushed to disk, the\nposition at which InnoDB last took a checkpoint, pending\nwrites and write performance statistics.\nBUFFER POOL AND MEMORY: Information on buffer pool pages\nread and written, which allows you to see the number of data\nfile I/O operations performed by your queries. See InnoDB\nBuffer Pool for more. Similar information is also available\nfrom the INFORMATION_SCHEMA.INNODB_BUFFER_POOL_STATS table.\nROW OPERATIONS:Information about the main thread, including\nthe number and performance rate for each type of row\noperation. \n \nIf the innodb_status_output_locks system variable is set to\n1, extended lock information will be displayed.\n \nExample output:\n \n=====================================\n2016-09-12 04:42:15 7f226145fb00 INNODB MONITOR OUTPUT\n=====================================\nPer second averages calculated from the last 29 seconds\n-----------------\nBACKGROUND THREAD\n-----------------\nsrv_master_thread loops: 0 srv_active, 0 srv_shutdown, 527\nsrv_idle\nsrv_master_thread log flush and writes: 527\n----------\nSEMAPHORES\n----------\nOS WAIT ARRAY INFO: reservation count 4\nOS WAIT ARRAY INFO: signal count 4\nMutex spin waits 2, rounds 60, OS waits 2\nRW-shared spins 2, rounds 60, OS waits 2\nRW-excl spins 0, rounds 0, OS waits 0\nSpin rounds per wait: 30.00 mutex, 30.00 RW-shared, 0.00\nRW-excl\n------------\nTRANSACTIONS\n------------\nTrx id counter 2308\nPurge done for trx\'s n:o < 0 undo n:o < 0 state: running\nbut idle\nHistory list length 0\nLIST OF TRANSACTIONS FOR EACH SESSION:\n---TRANSACTION 0, not started\nMySQL thread id 3, OS thread handle 0x7f226145fb00, query id\n4 localhost root init\nSHOW ENGINE INNODB STATUS\n--------\nFILE I/O\n--------\nI/O thread 0 state: waiting for completed aio requests\n(insert buffer thread)\nI/O thread 1 state: waiting for completed aio requests (log\nthread)\nI/O thread 2 state: waiting for completed aio requests (read\nthread)\nI/O thread 3 state: waiting for completed aio requests (read\nthread)\nI/O thread 4 state: waiting for completed aio requests (read\nthread)\nI/O thread 5 state: waiting for completed aio requests (read\nthread)\nI/O thread 6 state: waiting for completed aio requests\n(write thread)\nI/O thread 7 state: waiting for completed aio requests\n(write thread)\nI/O thread 8 state: waiting for completed aio requests\n(write thread)\nI/O thread 9 state: waiting for completed aio requests\n(write thread)\nPending normal aio reads: 0 [0, 0, 0, 0] , aio writes: 0 [0,\n0, 0, 0] ,\n ibuf aio reads: 0, log i/o\'s: 0, sync i/o\'s: 0\nPending flushes (fsync) log: 0; buffer pool: 0\n172 OS file reads, 5 OS file writes, 5 OS fsyncs\n0.00 reads/s, 0 avg bytes/read, 0.00 writes/s, 0.00 fsyncs/s\n-------------------------------------\nINSERT BUFFER AND ADAPTIVE HASH INDEX\n-------------------------------------\nIbuf: size 1, free list len 0, seg size 2, 0 merges\nmerged operations:\n insert 0, delete mark 0, delete 0\ndiscarded operations:\n insert 0, delete mark 0, delete 0\n0.00 hash searches/s, 0.00 non-hash searches/s\n---\nLOG\n---\nLog sequence number 1616829\nLog flushed up to 1616829\nPages flushed up to 1616829\nLast checkpoint at 1616829\nMax checkpoint age 80826164\nCheckpoint age target 78300347\nModified age 0\nCheckpoint age 0\n0 pending log writes, 0 pending chkp writes\n8 log i/o\'s done, 0.00 log i/o\'s/second\n----------------------\nBUFFER POOL AND MEMORY\n----------------------\nTotal memory allocated 140771328; in additional pool\nallocated 0\nTotal memory allocated by read views 88\nInternal hash tables (constant factor + variable factor)\n Adaptive hash index 2217568 (2213368 + 4200)\n Page hash 139112 (buffer pool 0 only)\n Dictionary cache 630703 (554768 + 75935)\n File system 817648 (812272 + 5376)\n Lock system 333232 (332872 + 360)\n Recovery system 0 (0 + 0)\nDictionary memory allocated 75935\nBuffer pool size 8191\nBuffer pool size, bytes 134201344\nFree buffers 8037\nDatabase pages 154\nOld database pages 0\nModified db pages 0\nPercent of dirty pages(LRU & free pages): 0.000\nMax dirty pages percent: 75.000\nPending reads 0\nPending writes: LRU 0, flush list 0, single page 0\nPages made young 0, not young 0\n0.00 youngs/s, 0.00 non-youngs/s\nPages read 154, created 0, written 1\n0.00 reads/s, 0.00 creates/s, 0.00 writes/s\nNo buffer pool page gets since the last printout\nPages read ahead 0.00/s, evicted without access 0.00/s,\nRandom read ahead 0.00/s\nLRU len: 154, unzip_LRU len: 0\nI/O sum[0]:cur[0], unzip sum[0]:cur[0]\n--------------\nROW OPERATIONS\n--------------\n0 queries inside InnoDB, 0 queries in queue\n0 read views open inside InnoDB\n0 RW transactions active inside InnoDB\n0 RO transactions active inside InnoDB\n0 out of 1000 descriptors used\nMain thread process no. 3337, id 139784957703936, state:\nsleeping\nNumber of rows inserted 0, updated 0, deleted 0, read 0\n0.00 inserts/s, 0.00 updates/s, 0.00 deletes/s, 0.00 reads/s\nNumber of system rows inserted 0, updated 0, deleted 0, read\n0\n0.00 inserts/s, 0.00 updates/s, 0.00 deletes/s, 0.00 reads/s\n----------------------------\nEND OF INNODB MONITOR OUTPUT\n============================\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/show-engine-innodb-status/','','https://mariadb.com/kb/en/library/show-engine-innodb-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (371,26,'SHOW ENGINES','Syntax\n------ \nSHOW [STORAGE] ENGINES\n \nDescription\n----------- \nSHOW ENGINES displays status information about the server\'s\nstorage engines. This is particularly useful for checking\nwhether a storage\nengine is supported, or to see what the default engine is. \nSHOW TABLE TYPES is a deprecated synonym.\n \nThe information_schema.ENGINES table provides the same\ninformation.\n \nSince storage engines are plugins, different information\nabout them is also shown in the information_schema.PLUGINS\ntable and by the SHOW PLUGINS statement.\n \nNote that both MySQL\'s InnoDB and Percona\'s XtraDB\nreplacement are labeled as InnoDB. However, if XtraDB is in\nuse, it will be specified in the COMMENT field. See XtraDB\nand InnoDB. The same applies to FederatedX.\n \nThe output consists of the following columns:\nEngine indicates the engine\'s name.\nSupport indicates whether the engine is installed, and\nwhether it is the default engine for the current session.\nComment is a brief description.\nTransactions, XA and Savepoints indicate whether\ntransactions, XA transactions and transaction savepoints are\nsupported by the engine.\n \nExamples\n-------- \nSHOW ENGINES\\G\n*************************** 1. row\n***************************\n Engine: InnoDB\n Support: DEFAULT\n Comment: Supports transactions, row-level locking, and\nforeign keys\nTransactions: YES\n XA: YES\n Savepoints: YES\n*************************** 2. row\n***************************\n Engine: CSV\n Support: YES\n Comment: CSV storage engine\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 3. row\n***************************\n Engine: MyISAM\n Support: YES\n Comment: MyISAM storage engine\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 4. row\n***************************\n Engine: BLACKHOLE\n Support: YES\n Comment: /dev/null storage engine (anything you write to it\ndisappears)\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 5. row\n***************************\n Engine: FEDERATED\n Support: YES\n Comment: FederatedX pluggable storage engine\nTransactions: YES\n XA: NO\n Savepoints: YES\n*************************** 6. row\n***************************\n Engine: MRG_MyISAM\n Support: YES\n Comment: Collection of identical MyISAM tables\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 7. row\n***************************\n Engine: ARCHIVE\n Support: YES\n Comment: Archive storage engine\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 8. row\n***************************\n Engine: MEMORY\n Support: YES\n Comment: Hash based, stored in memory, useful for temporary\ntables\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 9. row\n***************************\n Engine: PERFORMANCE_SCHEMA\n Support: YES\n Comment: Performance Schema\nTransactions: NO\n XA: NO\n Savepoints: NO\n*************************** 10. row\n***************************\n Engine: Aria\n Support: YES\n Comment: Crash-safe tables with MyISAM heritage\nTransactions: NO\n XA: NO\n Savepoints: NO\n10 rows in set (0.00 sec)\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-engines/','','https://mariadb.com/kb/en/library/show-engines/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (372,26,'SHOW ERRORS','Syntax\n------ \nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW ERRORS [LIMIT row_count OFFSET offset]\nSHOW COUNT(*) ERRORS\n \nDescription\n----------- \nThis statement is similar to SHOW WARNINGS, except that\ninstead of\ndisplaying errors, warnings, and notes, it displays only\nerrors.\n \nThe LIMIT clause has the same syntax as for the\nSELECT statement.\n \nThe SHOW COUNT(*) ERRORS statement displays the number of\nerrors. You can also retrieve this number from the\nerror_count variable.\n \nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n \nThe value of error_count might be greater than the number of\nmessages displayed by SHOW WARNINGS if the max_error_count\nsystem variable is set so low that not all messages are\nstored.\n \nFor a list of MariaDB error codes, see MariaDB Error Codes.\n \nExamples\n-------- \nSELECT f();\nERROR 1305 (42000): FUNCTION f does not exist\n \nSHOW COUNT(*) ERRORS;\n \n+-----------------------+\n| @@session.error_count |\n+-----------------------+\n| 1 |\n+-----------------------+\n \nSHOW ERRORS;\n \n+-------+------+---------------------------+\n| Level | Code | Message |\n+-------+------+---------------------------+\n| Error | 1305 | FUNCTION f does not exist |\n+-------+------+---------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-errors/','','https://mariadb.com/kb/en/library/show-errors/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (373,26,'SHOW EVENTS','Syntax\n------ \nSHOW EVENTS [{FROM | IN} schema_name]\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nShows information about Event Manager events (created with\nCREATE EVENT). Requires the EVENT privilege. Without any\narguments, SHOW EVENTS lists all of the events in the\ncurrent schema:\n \nSELECT CURRENT_USER(), SCHEMA();\n+----------------+----------+\n| CURRENT_USER() | SCHEMA() |\n+----------------+----------+\n| jon@ghidora | myschema |\n+----------------+----------+\n \nSHOW EVENTS\\G\n*************************** 1. row\n***************************\n Db: myschema\n Name: e_daily\n Definer: jon@ghidora\n Time zone: SYSTEM\n Type: RECURRING\n Execute at: NULL\n Interval value: 10\n Interval field: SECOND\n Starts: 2006-02-09 10:41:23\n Ends: NULL\n Status: ENABLED\n Originator: 0\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n \nTo see the event action, use SHOW CREATE EVENT instead, or\nlook at the information_schema.EVENTS table.\n \nTo see events for a specific schema, use the FROM clause.\nFor example, to see events for the test schema, use the\nfollowing statement:\n \nSHOW EVENTS FROM test;\n \nThe LIKE clause, if present, indicates which event names to\nmatch. The WHERE clause can be given to select rows using\nmore general conditions, as discussed in Extended Show.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-events/','','https://mariadb.com/kb/en/library/show-events/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (374,26,'SHOW EXPLAIN','The SHOW EXPLAIN command is a new feature in MariaDB 10.0.0.\n \nCommand description\n \nThe SHOW EXPLAIN command allows one to get an EXPLAIN (that\nis, a\ndescription of a query plan) of a query running in a certain\nthread.\n \nThe syntax is:\n \nSHOW EXPLAIN FOR ;\n \nwhich will produce an EXPLAIN output for the query that\nthread number thread_id is running. The thread id can be\nobtained with SHOW PROCESSLIST.\n \nSHOW EXPLAIN FOR 1;\n \n+------+-------------+-------+-------+---------------+------+---------+------+---------+-------------+\n| id | select_type | table | type | possible_keys | key |\nkey_len | ref | rows | Extra |\n+------+-------------+-------+-------+---------------+------+---------+------+---------+-------------+\n| 1 | SIMPLE | tbl | index | NULL | a | 5 | NULL | 1000107 |\nUsing index |\n+------+-------------+-------+-------+---------------+------+---------+------+---------+-------------+\n1 row in set, 1 warning (0.00 sec)\n \nThe output is always accompanied with a warning which shows\nthe query the\ntarget thread is running (this shows what the EXPLAIN is\nfor):\n \nSHOW WARNINGS;\n \n+-------+------+------------------------+\n| Level | Code | Message |\n+-------+------+------------------------+\n| Note | 1003 | select sum(a) from tbl |\n+-------+------+------------------------+\n1 row in set (0.00 sec)\n \nPossible errors\n \nThe output can be only produced if the target thread is\ncurrently running a\nquery, which has a ready query plan. If this is not the\ncase, the output will\nbe:\n \nSHOW EXPLAIN FOR 2;\n \nERROR 1932 (HY000): Target is not running an EXPLAINable\ncommand\n \nYou will get this error when:\nthe target thread is not running a command for which one can\nrun EXPLAIN\nthe target thread is running a command for which one can run\nEXPLAIN, but\nthere is no query plan yet (for example, tables are open and\nlocks are\n acquired before the query plan is produced)\n \n\nDifferences between SHOW EXPLAIN and EXPLAIN outputs\n \nBackground\n \nIn MySQL, EXPLAIN execution takes a slightly different route\nfrom the way\nthe real query (typically the SELECT) is optimized. This is\nunfortunate,\nand has caused a number of bugs in EXPLAIN. (For example,\nsee\nMDEV-326, MDEV-410, and\nlp:1013343.\nlp:992942 is not directly\nabout EXPLAIN, but it also would not have existed if MySQL\ndidn\'t try to delete\nparts of a query plan in the middle of the query) \n \nSHOW EXPLAIN examines a running SELECT, and hence its output\nmay be\nslightly different from what EXPLAIN SELECT would produce.\nWe did our best\nto make sure that either the difference is negligible, or\nSHOW EXPLAIN\'s\noutput is closer to reality than EXPLAIN\'s output.\n \nList of recorded differences\n \nSHOW EXPLAIN may have Extra=\'no matching row in const\ntable\', where EXPLAIN would produce Extra=\'Impossible\nWHERE ...\'\nFor queries with subqueries, SHOW EXPLAIN may print\nselect_type==PRIMARY where regular EXPLAIN used to print\nselect_type==SIMPLE, or vice versa.\n \nRequired permissions\n \nRunning SHOW EXPLAIN requires the same permissions as\nrunning SHOW PROCESSLIST would.\n \n\n\nURL: https://mariadb.com/kb/en/library/show-explain/','','https://mariadb.com/kb/en/library/show-explain/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (375,26,'SHOW FUNCTION CODE','Syntax\n------ \nSHOW FUNCTION CODE func_name\n \nDescription\n----------- \nSHOW FUNCTION CODE shows a representation of the internal\nimplementation of the stored function.\n \nIt is similar to SHOW PROCEDURE CODE but for stored\nfunctions.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-function-code/','','https://mariadb.com/kb/en/library/show-function-code/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (376,26,'SHOW FUNCTION STATUS','Syntax\n------ \nSHOW FUNCTION STATUS\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nThis statement is similar to \nSHOW PROCEDURE STATUS but for\nstored functions.\n \nThe LIKE clause, if present on its own, indicates which\nfunction names to match. \n \nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nThe information_schema.ROUTINES table contains more detailed\ninformation.\n \nExamples\n-------- \nShowing all stored functions:\n \nSHOW FUNCTION STATUS\\G\n*************************** 1. row\n***************************\n Db: test\n Name: VatCents\n Type: FUNCTION\n Definer: root@localhost\n Modified: 2013-06-01 12:40:31\n Created: 2013-06-01 12:40:31\n Security_type: DEFINER\n Comment: \ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \nStored functions whose name starts with \'V\': \n \nSHOW FUNCTION STATUS LIKE \'V%\' \\G\n*************************** 1. row\n***************************\n Db: test\n Name: VatCents\n Type: FUNCTION\n Definer: root@localhost\n Modified: 2013-06-01 12:40:31\n Created: 2013-06-01 12:40:31\n Security_type: DEFINER\n Comment: \ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \nStored functions with a security type of \'DEFINER\':\n \nSHOW FUNCTION STATUS WHERE Security_type LIKE \'DEFINER\'\n\\G\n*************************** 1. row\n***************************\n Db: test\n Name: VatCents\n Type: FUNCTION\n Definer: root@localhost\n Modified: 2013-06-01 12:40:31\n Created: 2013-06-01 12:40:31\n Security_type: DEFINER\n Comment: \ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-function-status/','','https://mariadb.com/kb/en/library/show-function-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (377,26,'SHOW GRANTS','Users\n \nSyntax\n------ \nSHOW GRANTS [FOR user]\n \nDescription\n----------- \nThis statement lists the GRANT statement or\nstatements that must be issued to duplicate the privileges\nthat are granted to\na MariaDB user account. The account is named using the same\nformat as for the\nGRANT statement; for example,\n\'jeffrey\'@\'localhost\'. If you specify only the user name\npart\nof the account name, a host name part of \'%\' is used. For\nadditional information about specifying account names, see\nGRANT.\n \nSHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH\nGRANT OPTION |\n+---------------------------------------------------------------------+\n \nTo list the privileges granted to the account that you are\nusing to\nconnect to the server, you can use any of the following\nstatements:\n \nSHOW GRANTS;\n \nSHOW GRANTS FOR CURRENT_USER;\n \nSHOW GRANTS FOR CURRENT_USER();\n \nIf SHOW GRANTS FOR CURRENT_USER (or any\nof the equivalent syntaxes) is used in DEFINER context (such\nas within a stored procedure that is defined with \n SQL SECURITY DEFINER), the grants displayed are those of\nthe\ndefiner and not the invoker.\n \nNote that the DELETE HISTORY privilege, introduced in\nMariaDB 10.3.4, is displayed as DELETE VERSIONING ROWS when\nrunning SHOW GRANTS (MDEV-17655).\n \nRoles\n \nRoles were introduced in MariaDB 10.0.5.\n \nSyntax\n------ \nSHOW GRANTS [FOR role]\n \nDescription\n----------- \nFrom MariaDB 10.0.5, SHOW GRANTS can also be used to view\nthe privileges granted to a role.\n \nExample\n \nSHOW GRANTS FOR journalist;\n+------------------------------------------+\n| Grants for journalist |\n+------------------------------------------+\n| GRANT USAGE ON *.* TO \'journalist\' |\n| GRANT DELETE ON `test`.* TO \'journalist\' |\n+------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-grants/','','https://mariadb.com/kb/en/library/show-grants/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (378,26,'SHOW INDEX','Syntax\n------ \nSHOW {INDEX | INDEXES | KEYS} \n FROM tbl_name [FROM db_name]\n [WHERE expr]\n \nDescription\n----------- \nSHOW INDEX returns table index information. The format\nresembles that of the SQLStatistics call in ODBC.\n \nYou can use db_name.tbl_name as an alternative to the\n tbl_name FROM db_name syntax. These two statements are\n equivalent:\n \nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n \nSHOW KEYS and SHOW INDEXES are synonyms for SHOW INDEX.\n \nYou can also list a table\'s indexes with the following\ncommand: \n \nmysqlshow -k db_name tbl_name\n \nSee mysqlshow for more details.\n \nThe information_schema.STATISTICS table stores similar\ninformation.\n \nThe following fields are returned by SHOW INDEX.\n \nField | Description | \n \nTable | Table name | \n \nNon_unique | 1 if the index permits duplicate values, 0 if\nvalues must be unique. | \n \nKey_name | Index name. The primary key is always named\nPRIMARY. | \n \nSeq_in_index | The column\'s sequence in the index,\nbeginning with 1. | \n \nColumn_name | Column name. | \n \nCollation | Either A, if the column is sorted in ascending\norder in the index, or NULL if it\'s not sorted. | \n \nCardinality | Estimated number of unique values in the\nindex. The cardinality statistics are calculated at various\ntimes, and can help the optimizer make improved decisions. |\n\n \nSub_part | NULL if the entire column is included in the\nindex, or the number of included characters if not. | \n \nPacked | NULL if the index is not packed, otherwise how the\nindex is packed. | \n \nNull | NULL if NULL values are permitted in the column, an\nempty string if NULL\'s are not permitted. | \n \nIndex_type | The index type, which can be BTREE, FULLTEXT,\nHASH or RTREE. See Storage Engine Index Types. | \n \nComment | Other information, such as whether the index is\ndisabled. | \n \nIndex_comment | Contents of the COMMENT attribute when the\nindex was created. | \n \nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nExamples\n-------- \nCREATE TABLE IF NOT EXISTS `employees_example` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `first_name` varchar(30) NOT NULL,\n `last_name` varchar(40) NOT NULL,\n `position` varchar(25) NOT NULL,\n `home_address` varchar(50) NOT NULL,\n `home_phone` varchar(12) NOT NULL,\n `employee_code` varchar(25) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE KEY `employee_code` (`employee_code`),\n KEY `first_name` (`first_name`,`last_name`)\n) ENGINE=Aria;\n \nINSERT INTO `employees_example` (`first_name`, `last_name`,\n`position`, `home_address`, `home_phone`, `employee_code`)\n VALUES\n (\'Mustapha\', \'Mond\', \'Chief Executive Officer\', \'692\nPromiscuous Plaza\', \'326-555-3492\', \'MM1\'),\n (\'Henry\', \'Foster\', \'Store Manager\', \'314 Savage\nCircle\', \'326-555-3847\', \'HF1\'),\n (\'Bernard\', \'Marx\', \'Cashier\', \'1240 Ambient\nAvenue\', \'326-555-8456\', \'BM1\'),\n (\'Lenina\', \'Crowne\', \'Cashier\', \'281 Bumblepuppy\nBoulevard\', \'328-555-2349\', \'LC1\'),\n (\'Fanny\', \'Crowne\', \'Restocker\', \'1023 Bokanovsky\nLane\', \'326-555-6329\', \'FC1\'),\n (\'Helmholtz\', \'Watson\', \'Janitor\', \'944 Soma\nCourt\', \'329-555-2478\', \'HW1\');\n \nSHOW INDEXES FROM employees_example;\n \n+-------------------+------------+---------------+--------------+---------------+-----------+-------------+----------+--------+------+------------+---------+---------------+\n| Table | Non_unique | Key_name | Seq_in_index | Column_name\n| Collation | Cardinality | Sub_part | Packed | Null |\nIndex_type | Comment | Index_comment |\n+-------------------+------------+---------------+--------------+---------------+-----------+-------------+----------+--------+------+------------+---------+---------------+\n| employees_example | 0 | PRIMARY | 1 | id | A | 7 | NULL |\nNULL | | BTREE | | |\n| employees_example | 0 | employee_code | 1 | employee_code\n| A | 7 | NULL | NULL | | BTREE | | |\n| employees_example | 1 | first_name | 1 | first_name | A |\nNULL | NULL | NULL | | BTREE | | |\n| employees_example | 1 | first_name | 2 | last_name | A |\nNULL | NULL | NULL | | BTREE | | |\n+-------------------+------------+---------------+--------------+---------------+-----------+-------------+----------+--------+------+------------+---------+---------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-index/','','https://mariadb.com/kb/en/library/show-index/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (379,26,'SHOW LOCALES','SHOW LOCALES was introduced as part of the Information\nSchema plugin extension in MariaDB 10.1.1.\n \nSHOW LOCALES is used to return locales information as part\nof the Locales plugin. While the information_schema.LOCALES\ntable has 8 columns, the SHOW LOCALES statement will only\ndisplay 4 of them:\n \nExample\n \nSHOW LOCALES;\n+-----+-------+-------------------------------------+------------------------+\n| Id | Name | Description | Error_Message_Language |\n+-----+-------+-------------------------------------+------------------------+\n| 0 | en_US | English - United States | english |\n| 1 | en_GB | English - United Kingdom | english |\n| 2 | ja_JP | Japanese - Japan | japanese |\n| 3 | sv_SE | Swedish - Sweden | swedish |\n...\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-locales/','','https://mariadb.com/kb/en/library/show-locales/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (380,26,'SHOW MASTER STATUS','Syntax\n------ \nSHOW MASTER STATUS\n \nDescription\n----------- \nProvides status information about the binary log files of\nthe master.\n \nThis statement requires the SUPER or the REPLICATION_CLIENT\nprivilege.\n \nTo see information about the current GTIDs in the binary\nlog, use the\ngtid_binlog_pos variable.\n \nExample\n \nSHOW MASTER STATUS;\n+--------------------+----------+--------------+------------------+\n| File | Position | Binlog_Do_DB | Binlog_Ignore_DB |\n+--------------------+----------+--------------+------------------+\n| mariadb-bin.000016 | 475 | | |\n+--------------------+----------+--------------+------------------+\nSELECT @@global.gtid_binlog_pos;\n+--------------------------+\n| @@global.gtid_binlog_pos |\n+--------------------------+\n| 0-1-2 |\n+--------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-master-status/','','https://mariadb.com/kb/en/library/show-master-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (381,26,'SHOW OPEN TABLES','Syntax\n------ \nSHOW OPEN TABLES [FROM db_name]\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \n SHOW OPEN TABLES lists the non-TEMPORARY\ntables that are currently open in the table cache. See\nhttp://dev.mysql.com/doc/refman/5.1/en/table-cache.html.\n \nThe FROM and LIKE clauses may be used.\n \nThe FROM\nclause, if present, restricts the tables shown to those\npresent in the\ndb_name database. \n \nThe LIKE clause, if\npresent on its own, indicates which table names to match.\nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nThe following information is returned:\n \nColumn | Description | \n \nDatabase | Database name. | \n \nName | Table name. | \n \nIn_use | Number of table instances being used. | \n \nName_locked | 1 if the table is name-locked, e.g. if it is\nbeing dropped or renamed, otherwise 0. | \n \nBefore MariaDB 5.5, each use of, for example, LOCK TABLE ...\nWRITE would increment In_use for that table. With the\nimplementation of the metadata locking improvements in\nMariaDB 5.5, LOCK TABLE... WRITE acquires a strong MDL lock,\nand concurrent connections will wait on this MDL lock, so\nany subsequent LOCK TABLE... WRITE will not increment\nIn_use.\n \nExample\n \nSHOW OPEN TABLES;\n \n+----------+---------------------------+--------+-------------+\n| Database | Table | In_use | Name_locked |\n+----------+---------------------------+--------+-------------+\n...\n| test | xjson | 0 | 0 |\n| test | jauthor | 0 | 0 |\n| test | locks | 1 | 0 |\n...\n+----------+---------------------------+--------+-------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-open-tables/','','https://mariadb.com/kb/en/library/show-open-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (382,26,'SHOW PACKAGE BODY STATUS','Oracle-style packages were introduced in MariaDB 10.3.5.\n \nSyntax\n------ \nSHOW PACKAGE BODY STATUS\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nThe SHOW PACKAGE BODY STATUS statement returns\ncharacteristics of stored package bodies (implementations),\nsuch as the database, name, type, creator, creation and\nmodification dates, and character set information. A similar\nstatement, SHOW PACKAGE STATUS, displays information about\nstored package specifications.\n \nThe LIKE clause, if present, indicates which package names\nto match. The WHERE and LIKE clauses can be given to select\nrows using more general conditions, as discussed in Extended\nSHOW.\n \nThe ROUTINES table in the INFORMATION_SCHEMA database\ncontains more detailed information.\n \nExamples\n-------- \nSHOW PACKAGE BODY STATUS LIKE \'pkg1\'\\G\n*************************** 1. row\n***************************\n Db: test\n Name: pkg1\n Type: PACKAGE BODY\n Definer: root@localhost\n Modified: 2018-02-27 14:44:14\n Created: 2018-02-27 14:44:14\n Security_type: DEFINER\n Comment: This is my first package body\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/show-package-body-status/','','https://mariadb.com/kb/en/library/show-package-body-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (383,26,'SHOW PACKAGE STATUS','Oracle-style packages were introduced in MariaDB 10.3.5.\n \nSyntax\n------ \nSHOW PACKAGE STATUS\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nThe SHOW PACKAGE STATUS statement returns characteristics of\nstored package specifications, such as the database, name,\ntype, creator, creation and modification dates, and\ncharacter set information. A similar statement, SHOW PACKAGE\nBODY STATUS, displays information about stored package\nbodies (i.e. implementations).\n \nThe LIKE clause, if present, indicates which package names\nto match. The WHERE and LIKE clauses can be given to select\nrows using more general conditions, as discussed in Extended\nSHOW.\n \nThe ROUTINES table in the INFORMATION_SCHEMA database\ncontains more detailed information.\n \nExamples\n-------- \nSHOW PACKAGE STATUS LIKE \'pkg1\'\\G\n*************************** 1. row\n***************************\n Db: test\n Name: pkg1\n Type: PACKAGE\n Definer: root@localhost\n Modified: 2018-02-27 14:38:15\n Created: 2018-02-27 14:38:15\n Security_type: DEFINER\n Comment: This is my first package\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL: https://mariadb.com/kb/en/library/show-package-status/','','https://mariadb.com/kb/en/library/show-package-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (384,26,'SHOW PLUGINS','Syntax\n------ \nSHOW PLUGINS;\n \nDescription\n----------- \n SHOW PLUGINS displays information about installed plugins.\nThe Library column indicates the plugin library - if it is\nNULL, the plugin is built-in and cannot be uninstalled.\n \nThe PLUGINS table in the information_schema database\ncontains more detailed information.\n \nFor specific information about storage engines (a particular\ntype of plugin), see the information_schema.ENGINES table\nand the SHOW ENGINES statement.\n \nExamples\n-------- \nSHOW PLUGINS;\n+----------------------------+----------+--------------------+-------------+---------+\n| Name | Status | Type | Library | License |\n+----------------------------+----------+--------------------+-------------+---------+\n| binlog | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| mysql_native_password | ACTIVE | AUTHENTICATION | NULL |\nGPL |\n| mysql_old_password | ACTIVE | AUTHENTICATION | NULL | GPL\n|\n| MRG_MyISAM | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| MyISAM | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| CSV | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| MEMORY | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| FEDERATED | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| PERFORMANCE_SCHEMA | ACTIVE | STORAGE ENGINE | NULL | GPL\n|\n| Aria | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| InnoDB | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| INNODB_TRX | ACTIVE | INFORMATION SCHEMA | NULL | GPL |\n...\n| INNODB_SYS_FOREIGN | ACTIVE | INFORMATION SCHEMA | NULL |\nGPL |\n| INNODB_SYS_FOREIGN_COLS | ACTIVE | INFORMATION SCHEMA |\nNULL | GPL |\n| SPHINX | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| ARCHIVE | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| BLACKHOLE | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| FEEDBACK | DISABLED | INFORMATION SCHEMA | NULL | GPL |\n| partition | ACTIVE | STORAGE ENGINE | NULL | GPL |\n| pam | ACTIVE | AUTHENTICATION | auth_pam.so | GPL |\n+----------------------------+----------+--------------------+-------------+---------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-plugins/','','https://mariadb.com/kb/en/library/show-plugins/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (385,26,'SHOW PLUGINS SONAME','MariaDB 10.0.2\n \nSHOW PLUGINS SONAME was introduced in MariaDB 10.0.2\n \nSyntax\n------ \nSHOW PLUGINS SONAME { library | LIKE \'pattern\' | WHERE\nexpr };\n \nDescription\n----------- \nSHOW PLUGINS SONAME displays information about compiled-in\nand all server plugins in the plugin_dir directory,\nincluding plugins that haven\'t been installed.\n \nExamples\n-------- \nSHOW PLUGINS SONAME \'ha_example.so\';\n+----------+---------------+----------------+---------------+---------+\n| Name | Status | Type | Library | License |\n+----------+---------------+----------------+---------------+---------+\n| EXAMPLE | NOT INSTALLED | STORAGE ENGINE | ha_example.so |\nGPL |\n| UNUSABLE | NOT INSTALLED | DAEMON | ha_example.so | GPL |\n+----------+---------------+----------------+---------------+---------+\n \nThere is also a corresponding information_schema table,\ncalled ALL_PLUGINS, which contains more complete\ninformation.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-plugins-soname/','','https://mariadb.com/kb/en/library/show-plugins-soname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (386,26,'SHOW PRIVILEGES','Syntax\n------ \nSHOW PRIVILEGES\n \nDescription\n----------- \n SHOW PRIVILEGES shows the list of system privileges that\nthe MariaDB server supports. The exact list of privileges\ndepends on the version of your server.\n \nExamples\n-------- \nSHOW PRIVILEGES;\n+-------------------------+---------------------------------------+-------------------------------------------------------+\n| Privilege | Context | Comment |\n+-------------------------+---------------------------------------+-------------------------------------------------------+\n| Alter | Tables | To alter the table |\n| Alter routine | Functions,Procedures | To alter or drop\nstored functions/procedures |\n| Create | Databases,Tables,Indexes | To create new\ndatabases and tables |\n| Create routine | Databases | To use CREATE\nFUNCTION/PROCEDURE |\n| Create temporary tables | Databases | To use CREATE\nTEMPORARY TABLE |\n| Create view | Tables | To create new views |\n| Create user | Server Admin | To create new users |\n| Delete | Tables | To delete existing rows |\n| Drop | Databases,Tables | To drop databases, tables, and\nviews |\n| Event | Server Admin | To create, alter, drop and execute\nevents |\n| Execute | Functions,Procedures | To execute stored\nroutines |\n| File | File access on server | To read and write files on\nthe server |\n| Grant option | Databases,Tables,Functions,Procedures | To\ngive to other users those privileges you possess |\n| Index | Tables | To create or drop indexes |\n| Insert | Tables | To insert data into tables |\n| Lock tables | Databases | To use LOCK TABLES (together\nwith SELECT privilege) |\n| Process | Server Admin | To view the plain text of\ncurrently executing queries |\n| Proxy | Server Admin | To make proxy user possible |\n| References | Databases,Tables | To have references on\ntables |\n| Reload | Server Admin | To reload or refresh tables, logs\nand privileges |\n| Replication client | Server Admin | To ask where the slave\nor master servers are |\n| Replication slave | Server Admin | To read binary log\nevents from the master |\n| Select | Tables | To retrieve rows from table |\n| Show databases | Server Admin | To see all databases with\nSHOW DATABASES |\n| Show view | Tables | To see views with SHOW CREATE VIEW |\n| Shutdown | Server Admin | To shut down the server |\n| Super | Server Admin | To use KILL thread, SET GLOBAL,\nCHANGE MASTER, etc. |\n| Trigger | Tables | To use triggers |\n| Create tablespace | Server Admin | To create/alter/drop\ntablespaces |\n| Update | Tables | To update existing rows |\n| Usage | Server Admin | No privileges - allow connect only\n|\n+-------------------------+---------------------------------------+-------------------------------------------------------+\n31 rows in set (0.07 sec)\n \n\n\nURL: https://mariadb.com/kb/en/library/show-privileges/','','https://mariadb.com/kb/en/library/show-privileges/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (387,26,'SHOW PROCEDURE CODE','Syntax\n------ \nSHOW PROCEDURE CODE proc_name\n \nDescription\n----------- \nThis statement is a MariaDB extension that is available only\nfor servers that\nhave been built with debugging support. It displays a\nrepresentation of the\ninternal implementation of the named stored procedure. A\nsimilar statement,\n SHOW FUNCTION CODE, displays\ninformation about stored functions.\n \nBoth statements require that you be the owner of the routine\nor have\n SELECT access to the mysql.proc table.\n \nIf the named routine is available, each statement produces a\nresult\nset. Each row in the result set corresponds to one\n\"instruction\" in\nthe routine. The first column is Pos, which is an ordinal\nnumber\nbeginning with 0. The second column is Instruction, which\ncontains an\nSQL statement (usually changed from the original source), or\na\ndirective which has meaning only to the stored-routine\nhandler.\n \nExamples\n-------- \nDELIMITER //\n \nCREATE PROCEDURE p1 ()\n BEGIN\n DECLARE fanta INT DEFAULT 55;\n DROP TABLE t2;\n LOOP\n INSERT INTO t3 VALUES (fanta);\n END LOOP;\n END//\nQuery OK, 0 rows affected (0.00 sec)\n \nSHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction |\n+-----+----------------------------------------+\n| 0 | set fanta@0 55 |\n| 1 | stmt 9 \"DROP TABLE t2\" |\n| 2 | stmt 5 \"INSERT INTO t3 VALUES (fanta)\" |\n| 3 | jump 2 |\n+-----+----------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-procedure-code/','','https://mariadb.com/kb/en/library/show-procedure-code/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (388,26,'SHOW PROCEDURE STATUS','Syntax\n------ \nSHOW PROCEDURE STATUS\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nThis statement is a MariaDB extension. It returns\ncharacteristics of a stored\nprocedure, such as the database, name, type, creator,\ncreation and modification\ndates, and character set information. A similar statement, \n SHOW FUNCTION STATUS, displays\ninformation about stored functions.\n \nThe LIKE clause, if present, indicates which procedure or\nfunction names to match. The WHERE and LIKE clauses can be\ngiven to select rows using more general conditions, as\ndiscussed in Extended SHOW.\n \nThe ROUTINES table in the INFORMATION_SCHEMA database\ncontains more detailed information.\n \nExamples\n-------- \nSHOW PROCEDURE STATUS LIKE \'p1\'\\G\n*************************** 1. row\n***************************\n Db: test\n Name: p1\n Type: PROCEDURE\n Definer: root@localhost\n Modified: 2010-08-23 13:23:03\n Created: 2010-08-23 13:23:03\n Security_type: DEFINER\n Comment: \ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n Database Collation: latin1_swedish_ci\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/show-procedure-status/','','https://mariadb.com/kb/en/library/show-procedure-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (389,26,'SHOW PROCESSLIST','Syntax\n------ \nSHOW [FULL] PROCESSLIST\n \nDescription\n----------- \n SHOW PROCESSLIST shows you which threads are running. You\ncan also get this information from the\ninformation_schema.PROCESSLIST table or the mysqladmin\nprocesslist command. If you have the \nPROCESS privilege, you can see all threads.\nOtherwise, you can see only your own threads (that is,\nthreads associated with\nthe MariaDB account that you are using). If you do not use\nthe\nFULL keyword, only the first 100 characters of each\nstatement are shown in the Info field.\n \nThe columns shown in SHOW PROCESSLIST\n are:\n \nName | Description | Introduced | \n \nID | The client\'s process ID. |  | \n \nUSER | The username associated with the process. |  | \n \nHOST | The host the client is connected to. |  | \n \nDB | The default database of the process (NULL if no\ndefault). |  | \n \nCOMMAND | The command type. See Thread Command Values. |  | \n \nTIME | The amount of time, in seconds, the process has been\nin its current state. For a slave SQL thread before MariaDB\n10.1, this is the time in seconds between the last\nreplicated event\'s timestamp and the slave machine\'s real\ntime. |  | \n \nSTATE | See Thread States. |  | \n \nINFO | The statement being executed. |  | \n \nPROGRESS | The total progress of the process (0-100%) (see\nProgress Reporting). | MariaDB 5.3 | \n \nSee TIME_MS column in information_schema.PROCESSLIST for\ndifferences in the TIME column between MariaDB and MySQL.\n \nThe information_schema.PROCESSLIST table contains the\nfollowing additional columns:\n \nName | Description | Introduced | \n \nTIME_MS | The amount of time, in milliseconds, the process\nhas been in its current state. | MariaDB 5.1 | \n \nSTAGE | The stage the process is currently in. |\nMariaDB 5.3 | \n \nMAX_STAGE | The maximum number of stages. | MariaDB 5.3 | \n \nPROGRESS | The progress of the process within the current\nstage (0-100%). | MariaDB 5.3 | \n \nMEMORY_USED | The amount of memory used by the process. |\nMariaDB 10.0.1 | \n \nEXAMINED_ROWS | The number of rows the process has examined.\n| MariaDB 10.0.1 | \n \nQUERY_ID | Query ID. | MariaDB 10.0.5 | \n \nNote that the PROGRESS field from the information schema,\nand the PROGRESS field from SHOW PROCESSLIST display\ndifferent results. SHOW PROCESSLIST shows the total\nprogress, while the information schema shows the progress\nfor the current stage only.\n \nThreads can be killed using their thread_id, or, since\nMariaDB 10.0.5, their query_id, with the KILL statement.\n \nSince queries on this table are locking, if the\nperformance_schema is enabled, you may want to query the\nTHREADS table instead.\n \nExamples\n-------- \nFrom MariaDB 5.1.x\n \nSHOW FULL PROCESSLIST;\n+---------+-------+-----------+------+---------+------+-------+-----------------------+\n| Id | User | Host | db | Command | Time | State | Info |\n+---------+-------+-----------+------+---------+------+-------+-----------------------+\n| 1988880 | dbart | localhost | NULL | Query | 0 | NULL |\nSHOW FULL PROCESSLIST |\n+---------+-------+-----------+------+---------+------+-------+-----------------------+\n \nSELECT * FROM information_schema.processlist;\n+---------+-------+-----------+------+---------+------+-----------+----------------------------------------------+---------+\n| ID | USER | HOST | DB | COMMAND | TIME | STATE | INFO |\nTIME_MS |\n+---------+-------+-----------+------+---------+------+-----------+----------------------------------------------+---------+\n| 1988880 | dbart | localhost | NULL | Query | 0 | executing\n| SELECT * FROM information_schema.processlist | 0.444 |\n+---------+-------+-----------+------+---------+------+-----------+----------------------------------------------+---------+\n \nFrom MariaDB 5.5.x\n \nSHOW FULL PROCESSLIST;\n+-----+------+-----------+------+---------+------+-------+-----------------------+----------+\n| Id | User | Host | db | Command | Time | State | Info |\nProgress |\n+-----+------+-----------+------+---------+------+-------+-----------------------+----------+\n| 126 | root | localhost | NULL | Query | 0 | NULL | SHOW\nFULL PROCESSLIST | 0.000 |\n+-----+------+-----------+------+---------+------+-------+-----------------------+----------+\n \nSELECT * FROM information_schema.processlist;\n+-----+--------+-----------+------+---------+------+-----------+----------------------------------------------+---------+-------+-----------+----------+\n| ID | USER | HOST | DB | COMMAND | TIME | STATE | INFO |\nTIME_MS | STAGE | MAX_STAGE | PROGRESS |\n+-----+--------+-----------+------+---------+------+-----------+----------------------------------------------+---------+-------+-----------+----------+\n| 126 | root | localhost | NULL | Query | 0 | executing |\nSELECT * FROM information_schema.processlist | 344.718 | 0 |\n0 | 0.000 |\n+-----+--------+-----------+------+---------+------+-----------+----------------------------------------------+---------+-------+-----------+----------+\n \nFrom MariaDB 10.0.x\n \nSHOW PROCESSLIST;\n+----+-----------------+-----------+------+---------+------+------------------------+------------------+----------+\n| Id | User | Host | db | Command | Time | State | Info |\nProgress |\n+----+-----------------+-----------+------+---------+------+------------------------+------------------+----------+\n| 2 | event_scheduler | localhost | NULL | Daemon | 2693 |\nWaiting on empty queue | NULL | 0.000 |\n| 4 | root | localhost | NULL | Query | 0 | Table lock |\nSHOW PROCESSLIST | 0.000 |\n+----+-----------------+-----------+------+---------+------+------------------------+------------------+----------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-processlist/','','https://mariadb.com/kb/en/library/show-processlist/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (390,26,'SHOW PROFILE','Syntax\n------ \nSHOW PROFILE [type [, type] ... ]\n [FOR QUERY n]\n [LIMIT row_count [OFFSET offset]]\n \ntype:\n ALL\n | BLOCK IO\n | CONTEXT SWITCHES\n | CPU\n | IPC\n | MEMORY\n | PAGE FAULTS\n | SOURCE\n | SWAPS\n \nDescription\n----------- \nThe SHOW PROFILE and \nSHOW PROFILES statements display profiling\ninformation that indicates resource usage for statements\nexecuted during the\ncourse of the current session.\n \nProfiling is controlled by the profiling session variable,\nwhich has a default value of 0 (OFF). Profiling is enabled\nby setting profiling to 1 or ON:\n \nSET profiling = 1;\n \nSHOW PROFILES displays a list of the most recent statements\nsent to the master. The size of the list is controlled by\nthe\nprofiling_history_size session variable, which has a default\nvalue of 15. The maximum value is 100. Setting the value to\n0 has the practical effect of disabling profiling.\n \nAll statements are profiled except SHOW PROFILES and \nSHOW PROFILE, so you will find neither of those statements\nin the profile list. Malformed statements are profiled. For\nexample, \n SHOW PROFILING is an illegal statement, and a syntax error\noccurs if you try to execute it, but it will show up in the\nprofiling list.\n \n SHOW PROFILE displays detailed information about a single\nstatement. Without the FOR QUERY n clause, the output\npertains to the most recently executed statement. If \n FOR QUERY n is included,\n SHOW PROFILE displays information for statement n. The\nvalues of n correspond to\nthe Query_ID values displayed by SHOW PROFILES.\n \nThe LIMIT row_count clause may be given to limit the\noutput to row_count rows. If LIMIT is given, \n OFFSET offset may be added to begin the output offset\nrows into the full set of rows.\n \nBy default, SHOW PROFILE displays Status and Duration\ncolumns. The Status values are like the State values\ndisplayed by \nSHOW PROCESSLIST,\nalthough there might be some minor differences in\ninterpretation for\nthe two statements for some status values (see\nhttp://dev.mysql.com/doc/refman/5.6/en/thread-information.html).\n \nOptional type values may be specified to display specific\nadditional\ntypes of information:\nALL displays all information\nBLOCK IO displays counts for block input and output\noperations\nCONTEXT SWITCHES displays counts for voluntary and\ninvoluntary context switches\nCPU displays user and system CPU usage times\nIPC displays counts for messages sent and received\nMEMORY is not currently implemented\nPAGE FAULTS displays counts for major and minor page faults\nSOURCE displays the names of functions from the source code,\ntogether with the name and line number of the file in which\nthe function occurs\nSWAPS displays swap counts\n \nProfiling is enabled per session. When a session ends, its\nprofiling information is lost.\n \nThe information_schema.PROFILING table contains similar\ninformation.\n \nExamples\n-------- \nSELECT @@profiling;\n+-------------+\n| @@profiling |\n+-------------+\n| 0 |\n+-------------+\n \nSET profiling = 1;\n \nUSE test;\n \nDROP TABLE IF EXISTS t1;\n \nCREATE TABLE T1 (id INT);\n \nSHOW PROFILES;\n+----------+------------+--------------------------+\n| Query_ID | Duration | Query |\n+----------+------------+--------------------------+\n| 1 | 0.00009200 | SELECT DATABASE() |\n| 2 | 0.00023800 | show databases |\n| 3 | 0.00018900 | show tables |\n| 4 | 0.00014700 | DROP TABLE IF EXISTS t1 |\n| 5 | 0.24476900 | CREATE TABLE T1 (id INT) |\n+----------+------------+--------------------------+\n \nSHOW PROFILE;\n+----------------------+----------+\n| Status | Duration |\n+----------------------+----------+\n| starting | 0.000042 |\n| checking permissions | 0.000044 |\n| creating table | 0.244645 |\n| After create | 0.000013 |\n| query end | 0.000003 |\n| freeing items | 0.000016 |\n| logging slow query | 0.000003 |\n| cleaning up | 0.000003 |\n+----------------------+----------+\n \nSHOW PROFILE FOR QUERY 4;\n+--------------------+----------+\n| Status | Duration |\n+--------------------+----------+\n| starting | 0.000126 |\n| query end | 0.000004 |\n| freeing items | 0.000012 |\n| logging slow query | 0.000003 |\n| cleaning up | 0.000002 |\n+--------------------+----------+\n \nSHOW PROFILE CPU FOR QUERY 5;\n+----------------------+----------+----------+------------+\n| Status | Duration | CPU_user | CPU_system |\n+----------------------+----------+----------+------------+\n| starting | 0.000042 | 0.000000 | 0.000000 |\n| checking permissions | 0.000044 | 0.000000 | 0.000000 |\n| creating table | 0.244645 | 0.000000 | 0.000000 |\n| After create | 0.000013 | 0.000000 | 0.000000 |\n| query end | 0.000003 | 0.000000 | 0.000000 |\n| freeing items | 0.000016 | 0.000000 | 0.000000 |\n| logging slow query | 0.000003 | 0.000000 | 0.000000 |\n| cleaning up | 0.000003 | 0.000000 | 0.000000 |\n+----------------------+----------+----------+------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-profile/','','https://mariadb.com/kb/en/library/show-profile/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (391,26,'SHOW PROFILES','Syntax\n------ \nSHOW PROFILES\n \nDescription\n----------- \nThe SHOW PROFILES statement displays profiling information\nthat indicates resource usage for statements executed during\nthe course of the\ncurrent session. It is used together with \nSHOW PROFILE.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-profiles/','','https://mariadb.com/kb/en/library/show-profiles/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (392,26,'SHOW QUERY_RESPONSE_TIME','SHOW QUERY_RESPONSE_TIME was introduced in MariaDB 10.1.1.\n \nStarting with MariaDB 10.1.1, which introduced the\nInformation Schema plugin extension, it is possible to use\nSHOW QUERY_RESPONSE_TIME as an alternative for retrieving\ninformation from the QUERY_RESPONSE_TIME plugin.\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/show-query_response_time/','','https://mariadb.com/kb/en/library/show-query_response_time/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (393,26,'SHOW RELAYLOG EVENTS','Syntax\n------ \nSHOW RELAYLOG [\'connection_name\'] EVENTS\n [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n \nDescription\n----------- \nOn replication slaves this command shows the events in the\nrelay log. If \'log_name\' is not specified, the first relay\nlog is shown.\n \nSyntax for the LIMIT clause is the same as for SELECT ...\nLIMIT.\n \nUsing the LIMIT clause is highly recommended because the\nSHOW RELAYLOG EVENTS command returns the complete contents\nof the relay log, which can be quite large.\n \nThis command does not return events related to setting user\nand system variables. If you need those, use mysqlbinlog.\n \nOn the replication master, this command does nothing.\n \nconnection_name\n \nconnection_name was added as part of multi-source\nreplication added in MariaDB 10.0.1\n \nIf there is only one nameless master, or the default master\n(as specified by the default_master_connection system\nvariable) is intended, connection_name can be omitted. If\nprovided, the SHOW RELAYLOG statement will apply to the\nspecified master. connection_name is case-insensitive.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-relaylog-events/','','https://mariadb.com/kb/en/library/show-relaylog-events/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (394,26,'SHOW SLAVE HOSTS','Syntax\n------ \nSHOW SLAVE HOSTS\n \nDescription\n----------- \nThis command is run on the master and displays a list of\nreplication slaves that are currently registered with it.\nOnly slaves started with the --report-host=host_name option\nare visible in this list.\n \nThe list is displayed on any server (not just the master\nserver). The output\nlooks like this:\n \nSHOW SLAVE HOSTS;\n+------------+-----------+------+-----------+\n| Server_id | Host | Port | Master_id |\n+------------+-----------+------+-----------+\n| 192168010 | iconnect2 | 3306 | 192168011 |\n| 1921680101 | athena | 3306 | 192168011 |\n+------------+-----------+------+-----------+\nServer_id: The unique server ID of the slave server, as\nconfigured in the server\'s option file, or on the command\nline with --server-id=value.\nHost: The host name of the slave server, as configured in\nthe server\'s option file, or on the command line with\n--report-host=host_name. Note that this can differ from the\nmachine name as configured in the operating system.\nPort: The port the slave server is listening on.\nMaster_id: The unique server ID of the master server that\nthe slave server is replicating from.\n \nSome MariaDB and MySQL versions report another variable,\nrpl_recovery_rank. This\nvariable was never used, and was eventually removed in\nMariaDB 10.1.2 and MySQL 5.6.\n \n\n\nURL: https://mariadb.com/kb/en/library/show-slave-hosts/','','https://mariadb.com/kb/en/library/show-slave-hosts/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (395,26,'SHOW SLAVE STATUS','Syntax\n------ \nSHOW SLAVE [\"connection_name\"] STATUS\n \nor\n \nSHOW ALL SLAVES STATUS\n \nDescription\n----------- \nThis statement is to be run on a slave and provides status\ninformation on essential parameters of the replication slave\nthreads.\n \nThis statement requires the SUPER or the REPLICATION_CLIENT\nprivilege.\n \nMulti-source\n \nMariaDB 10.0 introduced the FULL and \"connection_name\"\noptions to\nallow you to connect to many masters at the same time.\n \nALL SLAVES gives you a list of all connections to the\nmaster.\n \nThe rows will be sorted according to Connection_name.\n \nIf you specify a connection_name, you only get the\ninformation about that\nconnection. If connection_name is not used, then the name\nset by default_master_connection is used. If the connection\nname doesn\'t exist you will get an error:\nThere is no master connection for \'xxx\'.\n \nColumn descriptions\n \nName | Description | Added | \n \nConnection_name | Name of the master connection. Returned\nwith SHOW ALL SLAVES STATUS only. | MariaDB 10.0 | \n \nSlave_SQL_State | State of SQL thread. Returned with SHOW\nALL SLAVES STATUS only. See Slave SQL Thread States. |\nMariaDB 10.0 | \n \nSlave_IO_State | State of I/O thread. See Slave I/O Thread\nStates. | MariaDB 10.0 | \n \nMaster_host | Master host that the slave is connected to. | \n| \n \nMaster_user | Account user name being used to connect to the\nmaster. |  | \n \nMaster_port | The port being used to connect to the master.\n|  | \n \nConnect_Retry | Time in seconds between retries to connect.\nThe default is 60. The CHANGE MASTER TO statement can set\nthis. The master-retry-count option determines the maximum\nnumber of reconnection attempts. |  | \n \nMaster_Log_File | Name of the master binary log file that\nthe I/O thread is currently reading from. |  | \n \nRead_Master_Log_Pos | Position up to which the I/O thread\nhas read in the current master binary log file. |  | \n \nRelay_Log_File | Name of the relay log file that the SQL\nthread is currently processing. |  | \n \nRelay_Log_Pos | Position up to which the SQL thread has\nfinished processing in the current relay log file. |  | \n \nRelay_Master_Log_File | Name of the master binary log file\nthat contains the most recent event executed by the SQL\nthread. |  | \n \nSlave_IO_Running | Whether the slave I/O thread is running\nand connected (Yes), running but not connected to a master\n(Connecting) or not running (No). |  | \n \nSlave_SQL_Running | Whether or not the SQL thread is\nrunning. |  | \n \nReplicate_Do_DB | Databases specified for replicating with\nthe replicate_do_db option. |  | \n \nReplicate_Ignore_DB | Databases specified for ignoring with\nthe replicate_ignore_db option. |  | \n \nReplicate_Do_Table | Tables specified for replicating with\nthe replicate_do_table option. |  | \n \nReplicate_Ignore_Table | Tables specified for ignoring with\nthe replicate_ignore_table option. |  | \n \nReplicate_Wild_Do_Table | Tables specified for replicating\nwith the replicate_wild_do_table option. |  | \n \nReplicate_Wild_Ignore_Table | Tables specified for ignoring\nwith the replicate_wild_ignore_table option. |  | \n \nLast_Errno | Alias for Last_SQL_Errno (see below) |  | \n \nLast Error | Alias for Last_SQL_Error (see below) |  | \n \nSkip_Counter | Number of events that a slave skips from the\nmaster, as recorded in the sql_slave_skip_counter system\nvariable. |  | \n \nExec_Master_Log_Pos | Position up to which the SQL thread\nhas processed in the current master binary log file. Can be\nused to start a new slave from a current slave with the\nCHANGE MASTER TO ... MASTER_LOG_POS option. |  | \n \nRelay_Log_Space | Total size of all relay log files\ncombined. |  | \n \nUntil_Condition |  |  | \n \nUntil_Log_File | The MASTER_LOG_FILE value of the START\nSLAVE UNTIL condition. |  | \n \nUntil_Log_Pos | The MASTER_LOG_POS value of the START SLAVE\nUNTIL condition. |  | \n \nMaster_SSL_Allowed | Whether an SSL connection is permitted\n(Yes), not permitted (No) or permitted but without the slave\nhaving SSL support enabled (Ignored) |  | \n \nMaster_SSL_CA_File | The MASTER_SSL_CA option of the CHANGE\nMASTER TO statement. |  | \n \nMaster_SSL_CA_Path | The MASTER_SSL_CAPATH option of the\nCHANGE MASTER TO statement. |  | \n \nMaster_SSL_Cert | The MASTER_SSL_CERT option of the CHANGE\nMASTER TO statement. |  | \n \nMaster_SSL_Cipher | The MASTER_SSL_CIPHER option of the\nCHANGE MASTER TO statement. |  | \n \nMaster_SSL_Key | The MASTER_SSL_KEY option of the CHANGE\nMASTER TO statement. |  | \n \nSeconds_Behind_Master | Difference between the timestamp\nlogged on the master for the event that the slave is\ncurrently processing, and the current timestamp on the\nslave. Zero if the slave is not currently processing an\nevent. From MariaDB 10.0.23 and MariaDB 10.1.9, with\nparallel replication, seconds_behind_master is updated only\nafter transactions commit. |  | \n \nMaster_SSL_Verify_Server_Cert | The\nMASTER_SSL_VERIFY_SERVER_CERT option of the CHANGE MASTER TO\nstatement. |  | \n \nLast_IO_Errno | Error code of the most recent error that\ncaused the I/O thread to stop (also recorded in the slave\'s\nerror log). 0 means no error. RESET SLAVE or RESET MASTER\nwill reset this value. |  | \n \nLast_IO_Error | Error message of the most recent error that\ncaused the I/O thread to stop (also recorded in the slave\'s\nerror log). An empty string means no error. RESET SLAVE or\nRESET MASTER will reset this value. |  | \n \nLast_SQL_Errno | Error code of the most recent error that\ncaused the SQL thread to stop (also recorded in the slave\'s\nerror log). 0 means no error. RESET SLAVE or RESET MASTER\nwill reset this value. |  | \n \nLast_SQL_Error | Error message of the most recent error that\ncaused the SQL thread to stop (also recorded in the slave\'s\nerror log). An empty string means no error. RESET SLAVE or\nRESET MASTER will reset this value. |  | \n \nReplicate_Ignore_Server_Ids | List of server_ids that are\ncurrently being ignored for replication purposes, or an\nempty string for none, as specified in the IGNORE_SERVER_IDS\noption of the CHANGE MASTER TO statement. |  | \n \nMaster_Server_Id | The master\'s server_id value. |  | \n \nMaster_SSL_Crl | The MASTER_SSL_CRL option of the CHANGE\nMASTER TO statement. | MariaDB 10.0 | \n \nMaster_SSL_Crlpath | The MASTER_SSL_CRLPATH option of the\nCHANGE MASTER TO statement. | MariaDB 10.0 | \n \nUsing_Gtid | Whether or not global transaction ID\'s are\nbeing used for replication (can be No, Slave_Pos, or\nCurrent_Pos). | MariaDB 10.0.2 | \n \nGtid_IO_Pos | Current global transaction ID value. | MariaDB\n10.0.2 | \n \nRetried_transactions | Number of retried transactions for\nthis connection. Returned with SHOW ALL SLAVES STATUS only.\n| MariaDB 10.0 | \n \nMax_relay_log_size | Max relay log size for this connection.\nReturned with SHOW ALL SLAVES STATUS only. | MariaDB 10.0 | \n \nExecuted_log_entries | How many log entries the slave has\nexecuted. Returned with SHOW ALL SLAVES STATUS only. |\nMariaDB 10.0 | \n \nSlave_received_heartbeats | How many heartbeats we have got\nfrom the master. Returned with SHOW ALL SLAVES STATUS only.\n| MariaDB 10.0 | \n \nSlave_heartbeat_period | How often to request a heartbeat\npacket from the master (in seconds). Returned with SHOW ALL\nSLAVES STATUS only. | MariaDB 10.0 | \n \nGtid_Slave_Pos | GTID of the last event group replicated on\na slave server, for each replication domain, as stored in\nthe gtid_slave_pos system variable. Returned with SHOW ALL\nSLAVES STATUS only. | MariaDB 10.0 | \n \nSQL_Delay | Value specified by MASTER_DELAY in CHANGE MASTER\n(or 0 if none). | MariaDB 10.2.3 | \n \nSQL_Remaining_Delay | When the slave is delaying the\nexecution of an event due to MASTER_DELAY, this is the\nnumber of seconds of delay remaining before the event will\nbe applied. Otherwise, the value is NULL. | MariaDB 10.2.3 |\n\n \nSlave_SQL_Running_State | The state of the SQL driver\nthreads, same as in SHOW PROCESSLIST. When the slave is\ndelaying the execution of an event due to MASTER_DELAY, this\nfield displays: \"Waiting until MASTER_DELAY seconds after\nmaster executed event\". | MariaDB 10.2.3 | \n \nExamples\n-------- \nIf you issue this statement using the mysql client,\nyou can use a \\G statement terminator rather than a\nsemicolon to\nobtain a more readable vertical layout.\n \nSHOW SLAVE STATUS\\G\n*************************** 1. row\n***************************\n Slave_IO_State: Waiting for master to send event\n Master_Host: db01.example.com\n Master_User: replicant\n Master_Port: 3306\n Connect_Retry: 60\n Master_Log_File: mariadb-bin.000010\n Read_Master_Log_Pos: 548\n Relay_Log_File: relay-bin.000004\n Relay_Log_Pos: 837\n Relay_Master_Log_File: mariadb-bin.000010\n Slave_IO_Running: Yes\n Slave_SQL_Running: Yes\n Replicate_Do_DB: \n Replicate_Ignore_DB: \n Replicate_Do_Table: \n Replicate_Ignore_Table: \n Replicate_Wild_Do_Table: \n Replicate_Wild_Ignore_Table: \n Last_Errno: 0\n Last_Error: \n Skip_Counter: 0\n Exec_Master_Log_Pos: 548\n Relay_Log_Space: 1497\n Until_Condition: None\n Until_Log_File: \n Until_Log_Pos: 0\n Master_SSL_Allowed: No\n Master_SSL_CA_File: \n Master_SSL_CA_Path: \n Master_SSL_Cert: \n Master_SSL_Cipher: \n Master_SSL_Key: \n Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n Last_IO_Errno: 0\n Last_IO_Error: \n Last_SQL_Errno: 0\n Last_SQL_Error: \n Replicate_Ignore_Server_Ids: \n Master_Server_Id: 101\n Master_SSL_Crl: \n Master_SSL_Crlpath: \n Using_Gtid: No\n Gtid_IO_Pos: \n \nMariaDB [(none)]> SHOW ALL SLAVES STATUS\\G\n*************************** 1. row\n***************************\n Connection_name: \n Slave_SQL_State: Slave has read all relay log; waiting for\nthe slave I/O thread to update it\n Slave_IO_State: Waiting for master to send event\n Master_Host: db01.example.com\n Master_User: replicant\n Master_Port: 3306\n Connect_Retry: 60\n Master_Log_File: mariadb-bin.000010\n Read_Master_Log_Pos: 3608\n Relay_Log_File: relay-bin.000004\n Relay_Log_Pos: 3897\n Relay_Master_Log_File: mariadb-bin.000010\n Slave_IO_Running: Yes\n Slave_SQL_Running: Yes\n Replicate_Do_DB: \n Replicate_Ignore_DB: \n Replicate_Do_Table: \n Replicate_Ignore_Table: \n Replicate_Wild_Do_Table: \n Replicate_Wild_Ignore_Table: \n Last_Errno: 0\n Last_Error: \n Skip_Counter: 0\n Exec_Master_Log_Pos: 3608\n Relay_Log_Space: 4557\n Until_Condition: None\n Until_Log_File: \n Until_Log_Pos: 0\n Master_SSL_Allowed: No\n Master_SSL_CA_File: \n Master_SSL_CA_Path: \n Master_SSL_Cert: \n Master_SSL_Cipher: \n Master_SSL_Key: \n Seconds_Behind_Master: 0\nMaster_SSL_Verify_Server_Cert: No\n Last_IO_Errno: 0\n Last_IO_Error: \n Last_SQL_Errno: 0\n Last_SQL_Error: \n Replicate_Ignore_Server_Ids: \n Master_Server_Id: 101\n Master_SSL_Crl: \n Master_SSL_Crlpath: \n Using_Gtid: No\n Gtid_IO_Pos:\n Retried_transactions: 0\n Max_relay_log_size: 104857600\n Executed_log_entries: 40\n Slave_received_heartbeats: 11\n Slave_heartbeat_period: 1800.000\n Gtid_Slave_Pos: 0-101-2320\n \nYou can also access some of the variables directly from\nstatus variables:\n \nSET @@default_master_connection=\"test\" ;\nshow status like \"%slave%\"\n \nVariable_name Value\nCom_show_slave_hosts 0\nCom_show_slave_status 0\nCom_start_all_slaves 0\nCom_start_slave 0\nCom_stop_all_slaves 0\nCom_stop_slave 0\nRpl_semi_sync_slave_status OFF\nSlave_connections 0\nSlave_heartbeat_period 1800.000\nSlave_open_temp_tables 0\nSlave_received_heartbeats 0\nSlave_retried_transactions 0\nSlave_running OFF\nSlaves_connected 0\nSlaves_running 1\n \n\n\nURL: https://mariadb.com/kb/en/library/show-slave-status/','','https://mariadb.com/kb/en/library/show-slave-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (396,26,'SHOW STATUS','Syntax\n------ \nSHOW [GLOBAL | SESSION] STATUS\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nSHOW STATUS provides server status information. This\ninformation also can be obtained using the mysqladmin\nextended-status command, or by querying the Information\nSchema GLOBAL_STATUS and SESSION_STATUS tables.\nThe LIKE clause, if present, indicates which variable names\nto match. The WHERE clause can be given to select rows using\nmore general conditions.\n \nWith the GLOBAL modifier, SHOW STATUS\ndisplays the status values for all connections to MariaDB.\nWith\nSESSION, it displays the status values\nfor the current connection. If no modifier is present, the\ndefault is\n SESSION. LOCAL is a synonym for\n SESSION. If you see a lot of 0 values, the reason is\nprobably that you have used SHOW STATUS with a new\nconnection instead of SHOW GLOBAL STATUS.\n \nSome status variables have only a global value. For these,\nyou get the\nsame value for both GLOBAL and SESSION.\n \nSee Server Status Variables for a full list, scope and\ndescription of the variables that can be viewed with SHOW\nSTATUS.\n \nThe LIKE clause, if present on its own, indicates which\nvariable name to match.\n \nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nExamples\n-------- \nFull output from MariaDB 10.1.17:\n \nSHOW GLOBAL STATUS;\n \n+--------------------------------------------------------------+----------------------------------------+\n| Variable_name | Value |\n+--------------------------------------------------------------+----------------------------------------+\n| Aborted_clients | 0 |\n| Aborted_connects | 0 |\n| Access_denied_errors | 0 |\n| Acl_column_grants | 0 |\n| Acl_database_grants | 2 |\n| Acl_function_grants | 0 |\n| Acl_procedure_grants | 0 |\n| Acl_proxy_users | 2 |\n| Acl_role_grants | 0 |\n| Acl_roles | 0 |\n| Acl_table_grants | 0 |\n| Acl_users | 6 |\n| Aria_pagecache_blocks_not_flushed | 0 |\n| Aria_pagecache_blocks_unused | 15706 |\n| Aria_pagecache_blocks_used | 0 |\n| Aria_pagecache_read_requests | 0 |\n| Aria_pagecache_reads | 0 |\n| Aria_pagecache_write_requests | 0 |\n| Aria_pagecache_writes | 0 |\n| Aria_transaction_log_syncs | 0 |\n| Binlog_commits | 0 |\n| Binlog_group_commits | 0 |\n| Binlog_group_commit_trigger_count | 0 |\n| Binlog_group_commit_trigger_lock_wait | 0 |\n| Binlog_group_commit_trigger_timeout | 0 |\n| Binlog_snapshot_file | |\n| Binlog_snapshot_position | 0 |\n| Binlog_bytes_written | 0 |\n| Binlog_cache_disk_use | 0 |\n| Binlog_cache_use | 0 |\n| Binlog_stmt_cache_disk_use | 0 |\n| Binlog_stmt_cache_use | 0 |\n| Busy_time | 0.000000 |\n| Bytes_received | 432 |\n| Bytes_sent | 15183 |\n| Com_admin_commands | 1 |\n| Com_alter_db | 0 |\n| Com_alter_db_upgrade | 0 |\n| Com_alter_event | 0 |\n| Com_alter_function | 0 |\n| Com_alter_procedure | 0 |\n| Com_alter_server | 0 |\n| Com_alter_table | 0 |\n| Com_alter_tablespace | 0 |\n| Com_analyze | 0 |\n| Com_assign_to_keycache | 0 |\n| Com_begin | 0 |\n| Com_binlog | 0 |\n| Com_call_procedure | 0 |\n| Com_change_db | 0 |\n| Com_change_master | 0 |\n| Com_check | 0 |\n| Com_checksum | 0 |\n| Com_commit | 0 |\n| Com_compound_sql | 0 |\n| Com_create_db | 0 |\n| Com_create_event | 0 |\n| Com_create_function | 0 |\n| Com_create_index | 0 |\n| Com_create_procedure | 0 |\n| Com_create_role | 0 |\n| Com_create_server | 0 |\n| Com_create_table | 0 |\n| Com_create_temporary_table | 0 |\n| Com_create_trigger | 0 |\n| Com_create_udf | 0 |\n| Com_create_user | 0 |\n| Com_create_view | 0 |\n| Com_dealloc_sql | 0 |\n| Com_delete | 0 |\n| Com_delete_multi | 0 |\n| Com_do | 0 |\n| Com_drop_db | 0 |\n| Com_drop_event | 0 |\n| Com_drop_function | 0 |\n| Com_drop_index | 0 |\n| Com_drop_procedure | 0 |\n| Com_drop_role | 0 |\n| Com_drop_server | 0 |\n| Com_drop_table | 0 |\n| Com_drop_temporary_table | 0 |\n| Com_drop_trigger | 0 |\n| Com_drop_user | 0 |\n| Com_drop_view | 0 |\n| Com_empty_query | 0 |\n| Com_execute_sql | 0 |\n| Com_flush | 0 |\n| Com_get_diagnostics | 0 |\n| Com_grant | 0 |\n| Com_grant_role | 0 |\n| Com_ha_close | 0 |\n| Com_ha_open | 0 |\n| Com_ha_read | 0 |\n| Com_help | 0 |\n| Com_insert | 0 |\n| Com_insert_select | 0 |\n| Com_install_plugin | 0 |\n| Com_kill | 0 |\n| Com_load | 0 |\n| Com_lock_tables | 0 |\n| Com_optimize | 0 |\n| Com_preload_keys | 0 |\n| Com_prepare_sql | 0 |\n| Com_purge | 0 |\n| Com_purge_before_date | 0 |\n| Com_release_savepoint | 0 |\n| Com_rename_table | 0 |\n| Com_rename_user | 0 |\n| Com_repair | 0 |\n| Com_replace | 0 |\n| Com_replace_select | 0 |\n| Com_reset | 0 |\n| Com_resignal | 0 |\n| Com_revoke | 0 |\n| Com_revoke_all | 0 |\n| Com_revoke_role | 0 |\n| Com_rollback | 0 |\n| Com_rollback_to_savepoint | 0 |\n| Com_savepoint | 0 |\n| Com_select | 1 |\n| Com_set_option | 0 |\n| Com_show_authors | 0 |\n| Com_show_binlog_events | 0 |\n| Com_show_binlogs | 0 |\n| Com_show_charsets | 0 |\n| Com_show_collations | 0 |\n| Com_show_contributors | 0 |\n| Com_show_create_db | 0 |\n| Com_show_create_event | 0 |\n| Com_show_create_func | 0 |\n| Com_show_create_proc | 0 |\n| Com_show_create_table | 0 |\n| Com_show_create_trigger | 0 |\n| Com_show_databases | 0 |\n| Com_show_engine_logs | 0 |\n| Com_show_engine_mutex | 0 |\n| Com_show_engine_status | 0 |\n| Com_show_errors | 0 |\n| Com_show_events | 0 |\n| Com_show_explain | 0 |\n| Com_show_fields | 0 |\n| Com_show_function_status | 0 |\n| Com_show_generic | 0 |\n| Com_show_grants | 0 |\n| Com_show_keys | 0 |\n| Com_show_master_status | 0 |\n| Com_show_open_tables | 0 |\n| Com_show_plugins | 0 |\n| Com_show_privileges | 0 |\n| Com_show_procedure_status | 0 |\n| Com_show_processlist | 0 |\n| Com_show_profile | 0 |\n| Com_show_profiles | 0 |\n| Com_show_relaylog_events | 0 |\n| Com_show_slave_hosts | 0 |\n| Com_show_slave_status | 0 |\n| Com_show_status | 2 |\n| Com_show_storage_engines | 0 |\n| Com_show_table_status | 0 |\n| Com_show_tables | 0 |\n| Com_show_triggers | 0 |\n| Com_show_variables | 0 |\n| Com_show_warnings | 0 |\n| Com_shutdown | 0 |\n| Com_signal | 0 |\n| Com_start_all_slaves | 0 |\n| Com_start_slave | 0 |\n| Com_stmt_close | 0 |\n| Com_stmt_execute | 0 |\n| Com_stmt_fetch | 0 |\n| Com_stmt_prepare | 0 |\n| Com_stmt_reprepare | 0 |\n| Com_stmt_reset | 0 |\n| Com_stmt_send_long_data | 0 |\n| Com_stop_all_slaves | 0 |\n| Com_stop_slave | 0 |\n| Com_truncate | 0 |\n| Com_uninstall_plugin | 0 |\n| Com_unlock_tables | 0 |\n| Com_update | 0 |\n| Com_update_multi | 0 |\n| Com_xa_commit | 0 |\n| Com_xa_end | 0 |\n| Com_xa_prepare | 0 |\n| Com_xa_recover | 0 |\n| Com_xa_rollback | 0 |\n| Com_xa_start | 0 |\n| Compression | OFF |\n| Connection_errors_accept | 0 |\n| Connection_errors_internal | 0 |\n| Connection_errors_max_connections | 0 |\n| Connection_errors_peer_address | 0 |\n| Connection_errors_select | 0 |\n| Connection_errors_tcpwrap | 0 |\n| Connections | 4 |\n| Cpu_time | 0.000000 |\n| Created_tmp_disk_tables | 0 |\n| Created_tmp_files | 6 |\n| Created_tmp_tables | 2 |\n| Delayed_errors | 0 |\n| Delayed_insert_threads | 0 |\n| Delayed_writes | 0 |\n| Delete_scan | 0 |\n| Empty_queries | 0 |\n| Executed_events | 0 |\n| Executed_triggers | 0 |\n| Feature_delay_key_write | 0 |\n| Feature_dynamic_columns | 0 |\n| Feature_fulltext | 0 |\n| Feature_gis | 0 |\n| Feature_locale | 0 |\n| Feature_subquery | 0 |\n| Feature_timezone | 0 |\n| Feature_trigger | 0 |\n| Feature_xml | 0 |\n| Flush_commands | 1 |\n| Handler_commit | 1 |\n| Handler_delete | 0 |\n| Handler_discover | 0 |\n| Handler_external_lock | 0 |\n| Handler_icp_attempts | 0 |\n| Handler_icp_match | 0 |\n| Handler_mrr_init | 0 |\n| Handler_mrr_key_refills | 0 |\n| Handler_mrr_rowid_refills | 0 |\n| Handler_prepare | 0 |\n| Handler_read_first | 3 |\n| Handler_read_key | 0 |\n| Handler_read_last | 0 |\n| Handler_read_next | 0 |\n| Handler_read_prev | 0 |\n| Handler_read_retry | 0 |\n| Handler_read_rnd | 0 |\n| Handler_read_rnd_deleted | 0 |\n| Handler_read_rnd_next | 537 |\n| Handler_rollback | 0 |\n| Handler_savepoint | 0 |\n| Handler_savepoint_rollback | 0 |\n| Handler_tmp_update | 0 |\n| Handler_tmp_write | 516 |\n| Handler_update | 0 |\n| Handler_write | 0 |\n| Innodb_available_undo_logs | 128 |\n| Innodb_background_log_sync | 222 |\n| Innodb_buffer_pool_bytes_data | 2523136 |\n| Innodb_buffer_pool_bytes_dirty | 0 |\n| Innodb_buffer_pool_dump_status | Dumping buffer pool(s)\nnot yet started |\n| Innodb_buffer_pool_load_status | Loading buffer pool(s)\nnot yet started |\n| Innodb_buffer_pool_pages_data | 154 |\n| Innodb_buffer_pool_pages_dirty | 0 |\n| Innodb_buffer_pool_pages_flushed | 1 |\n| Innodb_buffer_pool_pages_free | 8037 |\n| Innodb_buffer_pool_pages_lru_flushed | 0 |\n| Innodb_buffer_pool_pages_made_not_young | 0 |\n| Innodb_buffer_pool_pages_made_young | 0 |\n| Innodb_buffer_pool_pages_misc | 0 |\n| Innodb_buffer_pool_pages_old | 0 |\n| Innodb_buffer_pool_pages_total | 8191 |\n| Innodb_buffer_pool_read_ahead | 0 |\n| Innodb_buffer_pool_read_ahead_evicted | 0 |\n| Innodb_buffer_pool_read_ahead_rnd | 0 |\n| Innodb_buffer_pool_read_requests | 558 |\n| Innodb_buffer_pool_reads | 155 |\n| Innodb_buffer_pool_wait_free | 0 |\n| Innodb_buffer_pool_write_requests | 1 |\n| Innodb_checkpoint_age | 0 |\n| Innodb_checkpoint_max_age | 80826164 |\n| Innodb_data_fsyncs | 5 |\n| Innodb_data_pending_fsyncs | 0 |\n| Innodb_data_pending_reads | 0 |\n| Innodb_data_pending_writes | 0 |\n| Innodb_data_read | 2609664 |\n| Innodb_data_reads | 172 |\n| Innodb_data_writes | 5 |\n| Innodb_data_written | 34304 |\n| Innodb_dblwr_pages_written | 1 |\n| Innodb_dblwr_writes | 1 |\n| Innodb_deadlocks | 0 |\n| Innodb_have_atomic_builtins | ON |\n| Innodb_history_list_length | 0 |\n| Innodb_ibuf_discarded_delete_marks | 0 |\n| Innodb_ibuf_discarded_deletes | 0 |\n| Innodb_ibuf_discarded_inserts | 0 |\n| Innodb_ibuf_free_list | 0 |\n| Innodb_ibuf_merged_delete_marks | 0 |\n| Innodb_ibuf_merged_deletes | 0 |\n| Innodb_ibuf_merged_inserts | 0 |\n| Innodb_ibuf_merges | 0 |\n| Innodb_ibuf_segment_size | 2 |\n| Innodb_ibuf_size | 1 |\n| Innodb_log_waits | 0 |\n| Innodb_log_write_requests | 0 |\n| Innodb_log_writes | 1 |\n| Innodb_lsn_current | 1616829 |\n| Innodb_lsn_flushed | 1616829 |\n| Innodb_lsn_last_checkpoint | 1616829 |\n| Innodb_master_thread_active_loops | 0 |\n| Innodb_master_thread_idle_loops | 222 |\n| Innodb_max_trx_id | 2308 |\n| Innodb_mem_adaptive_hash | 2217568 |\n| Innodb_mem_dictionary | 630703 |\n| Innodb_mem_total | 140771328 |\n| Innodb_mutex_os_waits | 1 |\n| Innodb_mutex_spin_rounds | 30 |\n| Innodb_mutex_spin_waits | 1 |\n| Innodb_oldest_view_low_limit_trx_id | 0 |\n| Innodb_os_log_fsyncs | 3 |\n| Innodb_os_log_pending_fsyncs | 0 |\n| Innodb_os_log_pending_writes | 0 |\n| Innodb_os_log_written | 512 |\n| Innodb_page_size | 16384 |\n| Innodb_pages_created | 0 |\n| Innodb_pages_read | 154 |\n| Innodb_pages_written | 1 |\n| Innodb_purge_trx_id | 0 |\n| Innodb_purge_undo_no | 0 |\n| Innodb_read_views_memory | 88 |\n| Innodb_row_lock_current_waits | 0 |\n| Innodb_row_lock_time | 0 |\n| Innodb_row_lock_time_avg | 0 |\n| Innodb_row_lock_time_max | 0 |\n| Innodb_row_lock_waits | 0 |\n| Innodb_rows_deleted | 0 |\n| Innodb_rows_inserted | 0 |\n| Innodb_rows_read | 0 |\n| Innodb_rows_updated | 0 |\n| Innodb_system_rows_deleted | 0 |\n| Innodb_system_rows_inserted | 0 |\n| Innodb_system_rows_read | 0 |\n| Innodb_system_rows_updated | 0 |\n| Innodb_s_lock_os_waits | 2 |\n| Innodb_s_lock_spin_rounds | 60 |\n| Innodb_s_lock_spin_waits | 2 |\n| Innodb_truncated_status_writes | 0 |\n| Innodb_x_lock_os_waits | 0 |\n| Innodb_x_lock_spin_rounds | 0 |\n| Innodb_x_lock_spin_waits | 0 |\n| Innodb_page_compression_saved | 0 |\n| Innodb_page_compression_trim_sect512 | 0 |\n| Innodb_page_compression_trim_sect1024 | 0 |\n| Innodb_page_compression_trim_sect2048 | 0 |\n| Innodb_page_compression_trim_sect4096 | 0 |\n| Innodb_page_compression_trim_sect8192 | 0 |\n| Innodb_page_compression_trim_sect16384 | 0 |\n| Innodb_page_compression_trim_sect32768 | 0 |\n| Innodb_num_index_pages_written | 0 |\n| Innodb_num_non_index_pages_written | 5 |\n| Innodb_num_pages_page_compressed | 0 |\n| Innodb_num_page_compressed_trim_op | 0 |\n| Innodb_num_page_compressed_trim_op_saved | 0 |\n| Innodb_num_pages_page_decompressed | 0 |\n| Innodb_num_pages_page_compression_error | 0 |\n| Innodb_num_pages_encrypted | 0 |\n| Innodb_num_pages_decrypted | 0 |\n| Innodb_have_lz4 | OFF |\n| Innodb_have_lzo | OFF |\n| Innodb_have_lzma | OFF |\n| Innodb_have_bzip2 | OFF |\n| Innodb_have_snappy | OFF |\n| Innodb_defragment_compression_failures | 0 |\n| Innodb_defragment_failures | 0 |\n| Innodb_defragment_count | 0 |\n| Innodb_onlineddl_rowlog_rows | 0 |\n| Innodb_onlineddl_rowlog_pct_used | 0 |\n| Innodb_onlineddl_pct_progress | 0 |\n| Innodb_secondary_index_triggered_cluster_reads | 0 |\n| Innodb_secondary_index_triggered_cluster_reads_avoided | 0\n|\n| Innodb_encryption_rotation_pages_read_from_cache | 0 |\n| Innodb_encryption_rotation_pages_read_from_disk | 0 |\n| Innodb_encryption_rotation_pages_modified | 0 |\n| Innodb_encryption_rotation_pages_flushed | 0 |\n| Innodb_encryption_rotation_estimated_iops | 0 |\n| Innodb_scrub_background_page_reorganizations | 0 |\n| Innodb_scrub_background_page_splits | 0 |\n| Innodb_scrub_background_page_split_failures_underflow | 0\n|\n|\nInnodb_scrub_background_page_split_failures_out_of_filespace\n| 0 |\n| Innodb_scrub_background_page_split_failures_missing_index\n| 0 |\n| Innodb_scrub_background_page_split_failures_unknown | 0 |\n| Key_blocks_not_flushed | 0 |\n| Key_blocks_unused | 107163 |\n| Key_blocks_used | 0 |\n| Key_blocks_warm | 0 |\n| Key_read_requests | 0 |\n| Key_reads | 0 |\n| Key_write_requests | 0 |\n| Key_writes | 0 |\n| Last_query_cost | 0.000000 |\n| Master_gtid_wait_count | 0 |\n| Master_gtid_wait_time | 0 |\n| Master_gtid_wait_timeouts | 0 |\n| Max_statement_time_exceeded | 0 |\n| Max_used_connections | 1 |\n| Memory_used | 273614696 |\n| Not_flushed_delayed_rows | 0 |\n| Open_files | 25 |\n| Open_streams | 0 |\n| Open_table_definitions | 18 |\n| Open_tables | 11 |\n| Opened_files | 77 |\n| Opened_plugin_libraries | 0 |\n| Opened_table_definitions | 18 |\n| Opened_tables | 18 |\n| Opened_views | 0 |\n| Performance_schema_accounts_lost | 0 |\n| Performance_schema_cond_classes_lost | 0 |\n| Performance_schema_cond_instances_lost | 0 |\n| Performance_schema_digest_lost | 0 |\n| Performance_schema_file_classes_lost | 0 |\n| Performance_schema_file_handles_lost | 0 |\n| Performance_schema_file_instances_lost | 0 |\n| Performance_schema_hosts_lost | 0 |\n| Performance_schema_locker_lost | 0 |\n| Performance_schema_mutex_classes_lost | 0 |\n| Performance_schema_mutex_instances_lost | 0 |\n| Performance_schema_rwlock_classes_lost | 0 |\n| Performance_schema_rwlock_instances_lost | 0 |\n| Performance_schema_session_connect_attrs_lost | 0 |\n| Performance_schema_socket_classes_lost | 0 |\n| Performance_schema_socket_instances_lost | 0 |\n| Performance_schema_stage_classes_lost | 0 |\n| Performance_schema_statement_classes_lost | 0 |\n| Performance_schema_table_handles_lost | 0 |\n| Performance_schema_table_instances_lost | 0 |\n| Performance_schema_thread_classes_lost | 0 |\n| Performance_schema_thread_instances_lost | 0 |\n| Performance_schema_users_lost | 0 |\n| Prepared_stmt_count | 0 |\n| Qcache_free_blocks | 1 |\n| Qcache_free_memory | 1031336 |\n| Qcache_hits | 0 |\n| Qcache_inserts | 0 |\n| Qcache_lowmem_prunes | 0 |\n| Qcache_not_cached | 0 |\n| Qcache_queries_in_cache | 0 |\n| Qcache_total_blocks | 1 |\n| Queries | 4 |\n| Questions | 4 |\n| Rows_read | 10 |\n| Rows_sent | 517 |\n| Rows_tmp_read | 516 |\n| Rpl_status | AUTH_MASTER |\n| Select_full_join | 0 |\n| Select_full_range_join | 0 |\n| Select_range | 0 |\n| Select_range_check | 0 |\n| Select_scan | 2 |\n| Slave_connections | 0 |\n| Slave_heartbeat_period | 0.000 |\n| Slave_open_temp_tables | 0 |\n| Slave_received_heartbeats | 0 |\n| Slave_retried_transactions | 0 |\n| Slave_running | OFF |\n| Slave_skipped_errors | 0 |\n| Slaves_connected | 0 |\n| Slaves_running | 0 |\n| Slow_launch_threads | 0 |\n| Slow_queries | 0 |\n| Sort_merge_passes | 0 |\n| Sort_priority_queue_sorts | 0 |\n| Sort_range | 0 |\n| Sort_rows | 0 |\n| Sort_scan | 0 |\n| Ssl_accept_renegotiates | 0 |\n| Ssl_accepts | 0 |\n| Ssl_callback_cache_hits | 0 |\n| Ssl_cipher | |\n| Ssl_cipher_list | |\n| Ssl_client_connects | 0 |\n| Ssl_connect_renegotiates | 0 |\n| Ssl_ctx_verify_depth | 0 |\n| Ssl_ctx_verify_mode | 0 |\n| Ssl_default_timeout | 0 |\n| Ssl_finished_accepts | 0 |\n| Ssl_finished_connects | 0 |\n| Ssl_server_not_after | |\n| Ssl_server_not_before | |\n| Ssl_session_cache_hits | 0 |\n| Ssl_session_cache_misses | 0 |\n| Ssl_session_cache_mode | NONE |\n| Ssl_session_cache_overflows | 0 |\n| Ssl_session_cache_size | 0 |\n| Ssl_session_cache_timeouts | 0 |\n| Ssl_sessions_reused | 0 |\n| Ssl_used_session_cache_entries | 0 |\n| Ssl_verify_depth | 0 |\n| Ssl_verify_mode | 0 |\n| Ssl_version | |\n| Subquery_cache_hit | 0 |\n| Subquery_cache_miss | 0 |\n| Syncs | 2 |\n| Table_locks_immediate | 21 |\n| Table_locks_waited | 0 |\n| Tc_log_max_pages_used | 0 |\n| Tc_log_page_size | 4096 |\n| Tc_log_page_waits | 0 |\n| Threadpool_idle_threads | 0 |\n| Threadpool_threads | 0 |\n| Threads_cached | 0 |\n| Threads_connected | 1 |\n| Threads_created | 2 |\n| Threads_running | 1 |\n| Update_scan | 0 |\n| Uptime | 223 |\n| Uptime_since_flush_status | 223 |\n| wsrep_cluster_conf_id | 18446744073709551615 |\n| wsrep_cluster_size | 0 |\n| wsrep_cluster_state_uuid | |\n| wsrep_cluster_status | Disconnected |\n| wsrep_connected | OFF |\n| wsrep_local_bf_aborts | 0 |\n| wsrep_local_index | 18446744073709551615 |\n| wsrep_provider_name | |\n| wsrep_provider_vendor | |\n| wsrep_provider_version | |\n| wsrep_ready | OFF |\n| wsrep_thread_count | 0 |\n+--------------------------------------------------------------+----------------------------------------+\n516 rows in set (0.00 sec)\n \nExample of filtered output:\n \nSHOW STATUS LIKE \'Key%\';\n \n+------------------------+--------+\n| Variable_name | Value |\n+------------------------+--------+\n| Key_blocks_not_flushed | 0 |\n| Key_blocks_unused | 107163 |\n| Key_blocks_used | 0 |\n| Key_blocks_warm | 0 |\n| Key_read_requests | 0 |\n| Key_reads | 0 |\n| Key_write_requests | 0 |\n| Key_writes | 0 |\n+------------------------+--------+\n8 rows in set (0.00 sec)\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-status/','','https://mariadb.com/kb/en/library/show-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (397,26,'SHOW TABLE STATUS','Syntax\n------ \nSHOW TABLE STATUS [{FROM | IN} db_name]\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \n SHOW TABLE STATUS works like \n SHOW TABLES, but provides more extensive information about\neach non-TEMPORARY table.\n \nThe LIKE clause, if present on its own, indicates which\ntable names to\nmatch. The WHERE and LIKE clauses can be given to select\nrows using more general conditions, as discussed in Extended\nSHOW.\n \nThe following information is returned:\n \nColumn | Description | \n \nName | Table name. | \n \nEngine | Table storage engine. | \n \nVersion | Version number from the table\'s .frm file. | \n \nRow_format | Row format (see InnoDB, Aria and MyISAM row\nformats). | \n \nRows | Number of rows in the table. Some engines, such as\nXtraDB and InnoDB may store an estimate. | \n \nAvg_row_length | Average row length in the table. | \n \nData_length | For InnoDB/XtraDB, the index size, in pages,\nmultiplied by the page size. For Aria and MyISAM, length of\nthe data file, in bytes. For MEMORY, the approximate\nallocated memory. | \n \nMax_data_length | Maximum length of the data file, ie the\ntotal number of bytes that could be stored in the table. Not\nused in XtraDB and InnoDB. | \n \nIndex_length | Length of the index file. | \n \nData_free | Bytes allocated but unused. For InnoDB tables in\na shared tablespace, the free space of the shared tablespace\nwith small safety margin. An estimate in the case of\npartitioned tables - see the PARTITIONS table. | \n \nAuto_increment | Next AUTO_INCREMENT value. | \n \nCreate_time | Time the table was created. | \n \nUpdate_time | Time the table was last updated. On Windows,\nthe timestamp is not updated on update, so MyISAM values\nwill be inaccurate. In InnoDB, if shared tablespaces are\nused, will be NULL, while buffering can also delay the\nupdate, so the value will differ from the actual time of the\nlast UPDATE, INSERT or DELETE. | \n \nCheck_time | Time the table was last checked. Not kept by\nall storage engines, in which case will be NULL. | \n \nCollation | Character set and collation. | \n \nChecksum | Live checksum value, if any. | \n \nCreate_options | Extra CREATE TABLE options. | \n \nComment | Table comment provided when MariaDB created the\ntable. | \n \nSimilar information can be found in the\ninformation_schema.TABLES table as well as by using\nmysqlshow:\n \nmysqlshow --status db_name\n \nExample\n \nshow table status\\G\n*************************** 1. row\n***************************\n Name: bus_routes\n Engine: InnoDB\n Version: 10\n Row_format: Dynamic\n Rows: 5\n Avg_row_length: 3276\n Data_length: 16384\nMax_data_length: 0\n Index_length: 0\n Data_free: 0\n Auto_increment: NULL\n Create_time: 2017-05-24 11:17:46\n Update_time: NULL\n Check_time: NULL\n Collation: latin1_swedish_ci\n Checksum: NULL\n Create_options: \n Comment:\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-table-status/','','https://mariadb.com/kb/en/library/show-table-status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (398,26,'SHOW TABLES','Syntax\n------ \nSHOW [FULL] TABLES [FROM db_name]\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nSHOW TABLES lists the non-TEMPORARY tables, sequences and\nviews in a given database. \n \nThe LIKE clause, if present on its own, indicates which\ntable names to match. The WHERE and LIKE clauses can be\ngiven to select rows using more general conditions, as\ndiscussed in Extended SHOW. For example, when searching for\ntables in the test database, the column name for use in the\nWHERE and LIKE clauses will be Tables_in_test\n \nThe FULL modifier is supported such that SHOW FULL TABLES\ndisplays a second output column. Values for the second\ncolumn. Table_type, are BASE TABLE for a table, VIEW for a\nview and SEQUENCE for a sequence.\n \nYou can also get this information using:\n \nmysqlshow db_name\n \nSee mysqlshow for more details.\n \nIf you have no privileges for a base table or view, it does\nnot show up in the output from SHOW TABLES or mysqlshow\ndb_name.\n \nThe information_schema.TABLES table, as well as the SHOW\nTABLE STATUS statement, provide extended information about\ntables.\n \nExamples\n-------- \nSHOW TABLES;\n+----------------------+\n| Tables_in_test |\n+----------------------+\n| animal_count |\n| animals |\n| are_the_mooses_loose |\n| aria_test2 |\n| t1 |\n| view1 |\n+----------------------+\n \nShowing the tables beginning with a only.\n \nSHOW TABLES WHERE Tables_in_test LIKE \'a%\';\n+----------------------+\n| Tables_in_test |\n+----------------------+\n| animal_count |\n| animals |\n| are_the_mooses_loose |\n| aria_test2 |\n+----------------------+\n \nShowing tables and table types:\n \nSHOW FULL TABLES;\n+----------------+------------+\n| Tables_in_test | Table_type |\n+----------------+------------+\n| s1 | SEQUENCE |\n| student | BASE TABLE |\n| v1 | VIEW |\n+----------------+------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/show-tables/','','https://mariadb.com/kb/en/library/show-tables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (399,26,'SHOW TABLE_STATISTICS','MariaDB 5.2 introduced the User Statistics feature.\n \nSyntax\n------ \nSHOW TABLE_STATISTICS\n \nDescription\n----------- \nThe SHOW TABLE_STATISTICS statement was introduced in\nMariaDB 5.2 as part of the User Statistics feature. It was\nremoved as a separate statement in MariaDB 10.1.1, but\neffectively replaced by the generic SHOW\ninformation_schema_table statement. The\ninformation_schema.TABLE_STATISTICS table shows statistics\non table usage\n \nThe userstat system variable must be set to 1 to activate\nthis feature. See the User Statistics and\ninformation_schema.TABLE_STATISTICS articles for more\ninformation.\n \nExample\n \nFrom MariaDB 10.0\n \nSHOW TABLE_STATISTICS\\G\n*************************** 1. row\n***************************\n Table_schema: mysql\n Table_name: proxies_priv\n Rows_read: 2\n Rows_changed: 0\nRows_changed_x_#indexes: 0\n*************************** 2. row\n***************************\n Table_schema: test\n Table_name: employees_example\n Rows_read: 7\n Rows_changed: 0\nRows_changed_x_#indexes: 0\n*************************** 3. row\n***************************\n Table_schema: mysql\n Table_name: user\n Rows_read: 16\n Rows_changed: 0\nRows_changed_x_#indexes: 0\n*************************** 4. row\n***************************\n Table_schema: mysql\n Table_name: db\n Rows_read: 2\n Rows_changed: 0\nRows_changed_x_#indexes: 0\n \n\n \n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/show-table-statistics/','','https://mariadb.com/kb/en/library/show-table-statistics/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (400,26,'SHOW TRIGGERS','Syntax\n------ \nSHOW TRIGGERS [FROM db_name]\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \n SHOW TRIGGERS lists the triggers currently defined for\ntables in a database (the default database unless a FROM\nclause is given). This statement requires the\nTRIGGER privilege (prior to MySQL\n5.1.22, it required the SUPER privilege). \n \nThe LIKE clause, if present on its own, indicates which\ntable names to\nmatch and causes the statement to display triggers for those\ntables. The WHERE and LIKE clauses can be given to select\nrows using more general conditions, as discussed in Extended\nSHOW.\n \nSimilar information is stored in the\ninformation_schema.TRIGGERS table.\n \nIf there are multiple triggers for the same action, then the\ntriggers are shown in action order.\n \nExamples\n-------- \nFor the trigger defined at Trigger Overview:\n \nSHOW triggers Like \'animals\' \\G\n*************************** 1. row\n***************************\n Trigger: the_mooses_are_loose\n Event: INSERT\n Table: animals\n Statement: BEGIN\n IF NEW.name = \'Moose\' THEN\n UPDATE animal_count SET animal_count.animals =\nanimal_count.animals+100;\n ELSE \n UPDATE animal_count SET animal_count.animals =\nanimal_count.animals+1;\n END IF;\nEND\n Timing: AFTER\n Created: 2016-09-29 13:53:34.35\n sql_mode: \n Definer: root@localhost\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \nListing all triggers associated with a certain table:\n \nSHOW TRIGGERS FROM test WHERE `Table` = \'user\' \\G\n*************************** 1. row\n***************************\n Trigger: user_ai\n Event: INSERT\n Table: user\n Statement: BEGIN END\n Timing: AFTER\n Created: 2016-09-29 13:53:34.35\n sql_mode: \n Definer: root@%\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\n \nSHOW triggers WHERE Event Like \'Insert\' \\G\n*************************** 1. row\n***************************\n Trigger: the_mooses_are_loose\n Event: INSERT\n Table: animals\n Statement: BEGIN\n IF NEW.name = \'Moose\' THEN\n UPDATE animal_count SET animal_count.animals =\nanimal_count.animals+100;\n ELSE \n UPDATE animal_count SET animal_count.animals =\nanimal_count.animals+1;\n END IF;\nEND\n Timing: AFTER\n Created: 2016-09-29 13:53:34.35\n sql_mode: \n Definer: root@localhost\ncharacter_set_client: utf8\ncollation_connection: utf8_general_ci\n Database Collation: latin1_swedish_ci\ncharacter_set_client is the session value of the\ncharacter_set_client system variable when the trigger was\ncreated. \ncollation_connection is the session value of the\ncollation_connection system variable when the trigger was\n created. \nDatabase Collation is the collation of the database \n with which the trigger is associated.\n \nThese columns were added in MariaDB/MySQL 5.1.21.\n \nOld triggers created before MySQL 5.7 and MariaDB 10.2.3 has\nNULL in the Created column.\n \n\n\nURL: https://mariadb.com/kb/en/library/show-triggers/','','https://mariadb.com/kb/en/library/show-triggers/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (401,26,'SHOW USER_STATISTICS','MariaDB 5.2 introduced the User Statistics feature.\n \nSyntax\n------ \nSHOW USER_STATISTICS\n \nDescription\n----------- \nThe SHOW USER_STATISTICS statement was introduced in MariaDB\n5.2 as part of the User Statistics feature. It was removed\nas a separate statement in MariaDB 10.1.1, but effectively\nreplaced by the generic SHOW information_schema_table\nstatement. The information_schema.USER_STATISTICS table\nholds statistics about user activity. You can use this table\nto find out such things as which user is causing the most\nload and which users are being abusive. You can also use\nthis table to measure how close to capacity the server may\nbe.\n \nThe userstat system variable must be set to 1 to activate\nthis feature. See the User Statistics and\ninformation_schema.USER_STATISTICS table for more\ninformation.\n \nExample\n \nFrom MariaDB 10.0:\n \nSHOW USER_STATISTICS\\G\n*************************** 1. row\n***************************\n User: root\n Total_connections: 1\nConcurrent_connections: 0\n Connected_time: 3297\n Busy_time: 0.14113400000000006\n Cpu_time: 0.017637000000000003\n Bytes_received: 969\n Bytes_sent: 22355\n Binlog_bytes_written: 0\n Rows_read: 10\n Rows_sent: 67\n Rows_deleted: 0\n Rows_inserted: 0\n Rows_updated: 0\n Select_commands: 7\n Update_commands: 0\n Other_commands: 0\n Commit_transactions: 1\n Rollback_transactions: 0\n Denied_connections: 0\n Lost_connections: 0\n Access_denied: 0\n Empty_queries: 7\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-user-statistics/','','https://mariadb.com/kb/en/library/show-user-statistics/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (402,26,'SHOW VARIABLES','Syntax\n------ \nSHOW [GLOBAL | SESSION] VARIABLES\n [LIKE \'pattern\' | WHERE expr]\n \nDescription\n----------- \nSHOW VARIABLES shows the values of MariaDB system variables.\nThis\ninformation also can be obtained using the mysqladmin\nvariables\ncommand. The LIKE clause, if present, indicates which\nvariable names\nto match. The WHERE clause can be given to select rows using\nmore\ngeneral conditions.\n \nWith the GLOBAL modifier, SHOW VARIABLES displays the values\nthat are\nused for new connections to MariaDB. With SESSION, it\ndisplays the\nvalues that are in effect for the current connection. If no\nmodifier\nis present, the default is SESSION. LOCAL is a synonym for\nSESSION.\nWith a LIKE clause, the statement displays only rows for\nthose\nvariables with names that match the pattern. To obtain the\nrow for a\nspecific variable, use a LIKE clause as shown:\n \nSHOW VARIABLES LIKE \'maria_group_commit\';\n \nSHOW SESSION VARIABLES LIKE \'maria_group_commit\';\n \nTo get a list of variables whose name match a pattern, use\nthe \"%\"\nwildcard character in a LIKE clause:\n \nSHOW VARIABLES LIKE \'%maria%\';\n \nSHOW GLOBAL VARIABLES LIKE \'%maria%\';\n \nWildcard characters can be used in any position within the\npattern to\nbe matched. Strictly speaking, because \"_\" is a wildcard\nthat matches\nany single character, you should escape it as \"\\_\" to\nmatch it\nliterally. In practice, this is rarely necessary.\n \nThe WHERE and LIKE clauses can be given to select rows using\nmore general conditions, as discussed in Extended SHOW.\n \nSee SET for information on setting server system variables.\n \nSee Server System Variables for a list of all the variables\nthat can be set.\n \nYou can also see the server variables by querying the\nInformation Schema GLOBAL_VARIABLES and SESSION_VARIABLES\ntables.\n \nExamples\n-------- \nSHOW VARIABLES LIKE \'aria%\';\n \n+------------------------------------------+---------------------+\n| Variable_name | Value |\n+------------------------------------------+---------------------+\n| aria_block_size | 8192 |\n| aria_checkpoint_interval | 30 |\n| aria_checkpoint_log_activity | 1048576 |\n| aria_force_start_after_recovery_failures | 0 |\n| aria_group_commit | none |\n| aria_group_commit_interval | 0 |\n| aria_log_file_size | 1073741824 |\n| aria_log_purge_type | immediate |\n| aria_max_sort_file_size | 9223372036853727232 |\n| aria_page_checksum | ON |\n| aria_pagecache_age_threshold | 300 |\n| aria_pagecache_buffer_size | 134217728 |\n| aria_pagecache_division_limit | 100 |\n| aria_recover | NORMAL |\n| aria_repair_threads | 1 |\n| aria_sort_buffer_size | 134217728 |\n| aria_stats_method | nulls_unequal |\n| aria_sync_log_dir | NEWFILE |\n| aria_used_for_temp_tables | ON |\n+------------------------------------------+---------------------+\n \nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'max_error_count\' OR\n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n \n+---------------------------+---------------+--------------+\n| VARIABLE_NAME | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT | 64 | 64 |\n| INNODB_SYNC_SPIN_LOOPS | NULL | 30 |\n+---------------------------+---------------+--------------+\n \nSET GLOBAL max_error_count=128;\n \nSELECT VARIABLE_NAME, SESSION_VALUE, GLOBAL_VALUE FROM\n INFORMATION_SCHEMA.SYSTEM_VARIABLES WHERE\n VARIABLE_NAME LIKE \'max_error_count\' OR\n VARIABLE_NAME LIKE \'innodb_sync_spin_loops\';\n \n+---------------------------+---------------+--------------+\n| VARIABLE_NAME | SESSION_VALUE | GLOBAL_VALUE |\n+---------------------------+---------------+--------------+\n| MAX_ERROR_COUNT | 64 | 128 |\n| INNODB_SYNC_SPIN_LOOPS | NULL | 30 |\n+---------------------------+---------------+--------------+\n \nSET GLOBAL max_error_count=128;\n \nSHOW VARIABLES LIKE \'max_error_count\';\n \n+-----------------+-------+\n| Variable_name | Value |\n+-----------------+-------+\n| max_error_count | 64 |\n+-----------------+-------+\n \nSHOW GLOBAL VARIABLES LIKE \'max_error_count\';\n \n+-----------------+-------+\n| Variable_name | Value |\n+-----------------+-------+\n| max_error_count | 128 |\n+-----------------+-------+\n \nBecause the following variable only has a global scope, the\nglobal value is returned even when specifying SESSION (in\nthis case by default):\n \nSHOW VARIABLES LIKE \'innodb_sync_spin_loops\';\n \n+------------------------+-------+\n| Variable_name | Value |\n+------------------------+-------+\n| innodb_sync_spin_loops | 30 |\n+------------------------+-------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-variables/','','https://mariadb.com/kb/en/library/show-variables/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (403,26,'SHOW WARNINGS','Syntax\n------ \nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW ERRORS [LIMIT row_count OFFSET offset]\nSHOW COUNT(*) WARNINGS\n \nDescription\n----------- \n SHOW WARNINGS shows the error, warning, and note messages\nthat resulted from the last statement that generated\nmessages in the\ncurrent session. It shows nothing if the last statement used\na table\nand generated no messages. (That is, a statement that uses a\ntable but\ngenerates no messages clears the message list.) Statements\nthat do not\nuse tables and do not generate messages have no effect on\nthe message\nlist.\n \nA note is different to a warning in that it only appears if\nthe sql_notes variable is set to 1 (the default), and is not\nconverted to an error if strict mode is enabled.\n \nA related statement, SHOW ERRORS, shows only the errors.\n \nThe SHOW COUNT(*) WARNINGS statement displays the total\nnumber of errors, warnings, and notes. You can also retrieve\nthis number from\nthe warning_count variable:\n \nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n \nThe value of warning_count might be greater than the number\nof messages displayed by SHOW WARNINGS if the\nmax_error_count system variable is set so low that not all\nmessages are stored.\n \nThe LIMIT clause has the same syntax as for the\n SELECT statement.\n \nSHOW WARNINGS can be used after EXPLAIN EXTENDED to see how\na query is internally rewritten by MariaDB.\n \nIf the sql_notes server variable is set to 1, Notes are\nincluded in the output of SHOW WARNINGS; if it is set to 0,\nthis statement will not show (or count) Notes.\n \nThe results of SHOW WARNINGS and SHOW COUNT(*) WARNINGS are\ndirectly sent to the client. If you need to access those\ninformation in a stored program, you can use the GET\nDIAGNOSTICS statement instead.\n \nFor a list of MariaDB error codes, see MariaDB Error Codes.\n \nThe mysql client also has a number of options related to\nwarnings. The \\W command will show warnings after every\nstatement, while \\w will disable this. Starting the client\nwith the --show-warnings option will show warnings after\nevery statement.\n \nMariaDB 10.3.1 implements a stored routine error stack\ntrace. SHOW WARNINGS can also be used to show more\ninformation. See the example below.\n \nExamples\n-------- \nSELECT 1/0;\n+------+\n| 1/0 |\n+------+\n| NULL |\n+------+\n \nSHOW COUNT(*) WARNINGS;\n+-------------------------+\n| @@session.warning_count |\n+-------------------------+\n| 1 |\n+-------------------------+\n \nSHOW WARNINGS;\n+---------+------+---------------+\n| Level | Code | Message |\n+---------+------+---------------+\n| Warning | 1365 | Division by 0 |\n+---------+------+---------------+\n \nStack Trace\n \nFrom MariaDB 10.3.1, displaying a stack trace:\n \nDELIMITER $$\nCREATE OR REPLACE PROCEDURE p1()\n BEGIN\n DECLARE c CURSOR FOR SELECT * FROM not_existing;\n OPEN c;\n CLOSE c;\n END;\n$$\nCREATE OR REPLACE PROCEDURE p2()\n BEGIN\n CALL p1;\n END;\n$$\nDELIMITER ;\nCALL p2;\nERROR 1146 (42S02): Table \'test.not_existing\' doesn\'t\nexist\n \nSHOW WARNINGS;\n+-------+------+-----------------------------------------+\n| Level | Code | Message |\n+-------+------+-----------------------------------------+\n| Error | 1146 | Table \'test.not_existing\' doesn\'t exist\n|\n| Note | 4091 | At line 6 in test.p1 |\n| Note | 4091 | At line 4 in test.p2 |\n+-------+------+-----------------------------------------+\n \nSHOW WARNINGS displays a stack trace, showing where the\nerror actually happened:\nLine 4 in test.p1 is the OPEN command which actually raised\nthe error\nLine 3 in test.p2 is the CALL statement, calling p1 from p2.\n \n\n\nURL: https://mariadb.com/kb/en/library/show-warnings/','','https://mariadb.com/kb/en/library/show-warnings/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (404,26,'SHOW WSREP_MEMBERSHIP','MariaDB 10.1.2\n \nSHOW WSREP_MEMBERSHIP was introduced with the WSREP_INFO\nplugin in MariaDB 10.1.2.\n \nSyntax\n------ \nSHOW WSREP_MEMBERSHIP\n \nDescription\n----------- \nThe SHOW WSREP_MEMBERSHIP statement returns Galera node\ncluster membership information. It returns the same\ninformation as found in the\ninformation_schema.WSREP_MEMBERSHIP table. Only users with\nthe SUPER privilege can access this information.\n \nExamples\n-------- \nSHOW WSREP_MEMBERSHIP;\n+-------+--------------------------------------+----------+-----------------+\n| Index | Uuid | Name | Address |\n+-------+--------------------------------------+----------+-----------------+\n| 0 | 19058073-8940-11e4-8570-16af7bf8fced | my_node1 |\n10.0.2.15:16001 |\n| 1 | 19f2b0e0-8942-11e4-9cb8-b39e8ee0b5dd | my_node3 |\n10.0.2.15:16003 |\n| 2 | d85e62db-8941-11e4-b1ef-4bc9980e476d | my_node2 |\n10.0.2.15:16002 |\n+-------+--------------------------------------+----------+-----------------+\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/show-wsrep_membership/','','https://mariadb.com/kb/en/library/show-wsrep_membership/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (405,26,'SHOW WSREP_STATUS','MariaDB 10.1.2\n \nSHOW WSREP_STATUS was introduced with the WSREP_INFO plugin\nin MariaDB 10.1.2.\n \nSyntax\n------ \nSHOW WSREP_STATUS\n \nDescription\n----------- \nThe SHOW WSREP_STATUS statement returns Galera node and\ncluster status information. It returns the same information\nas found in the information_schema.WSREP_STATUS table. Only\nusers with the SUPER privilege can access this information.\n \nExamples\n-------- \nSHOW WSREP_STATUS;\n+------------+-------------+----------------+--------------+\n| Node_Index | Node_Status | Cluster_Status | Cluster_Size |\n+------------+-------------+----------------+--------------+\n| 0 | Synced | Primary | 3 |\n+------------+-------------+----------------+--------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/show-wsrep_status/','','https://mariadb.com/kb/en/library/show-wsrep_status/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (406,27,'CALL','Syntax\n------ \nCALL sp_name([parameter[,...]])\nCALL sp_name[()]\n \nDescription\n----------- \nThe CALL statement invokes a stored procedure that was\ndefined previously with CREATE PROCEDURE. \n \nStored procedure names can be specified as\ndatabase_name.procedure_name. Procedure names and database\nnames can be quoted with backticks (). This is necessary if\nthey are reserved words, or contain special characters. See\nidentifier qualifiers for details.\n \nBefore MySQL 5.1.13, stored procedures that take no\narguments required parentheses. In current releases of\nMariaDB, CALL p() and CALL p are equivalent.\n \nIf parentheses are used, any number of spaces, tab\ncharacters and new line characters is allowed between the\nprocedure\'s name and the open parenthesis.\n \nCALL can pass back values to its caller using parameters\nthat are declared as OUT or INOUT\nparameters. If no value is assigned to an OUT parameter,\nNULL is assigned (and its former value is lost). To pass\nsuch values from another stored program you can use\nuser-defined variables, local variables or routine\'s\nparameters; in other contexts, you can only use user-defined\nvariables. \n \nCALL can also be executed as a prepared statement.\nPlaceholders can be used for IN parameters in all versions\nof MariaDB; for OUT and INOUT parameters, placeholders can\nbe used since MariaDB 5.5.\n \nWhen the procedure returns, a client program can also obtain\nthe\nnumber of rows affected for the final statement executed\nwithin the routine: At\nthe SQL level, call the ROW_COUNT() function; from the C\nAPI, call the mysql_affected_rows() function.\n \nIf the CLIENT_MULTI_RESULTS API flag is set, CALL can return\nany number of resultsets and the called stored procedure can\nexecute prepared statements. If it is not set, at most one\nresultset can be returned and prepared statements cannot be\nused within procedures.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/call/','','https://mariadb.com/kb/en/library/call/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (407,27,'Concurrent Inserts','The MyISAM storage engine supports concurrent inserts. This\nfeature allows SELECT statements to be executed during\nINSERT operations, reducing contention.\n \nWhether concurrent inserts can be used or not depends on the\nvalue of the concurrent_insert server system variable:\nNEVER (0) disables concurrent inserts.\nAUTO (1) allows concurrent inserts only when the target\ntable has no free blocks (no data in the middle of the table\nhas been deleted after the last OPTIMIZE TABLE). This is the\ndefault.\nALWAYS (2) always enables concurrent inserts.\n \nIf the binary log is used, CREATE TABLE ... SELECT and\nINSERT ... SELECT statements cannot use concurrent inserts.\nThese statements acquire a read lock on the table, so\nconcurrent inserts will need to wait. This way the log can\nbe safely used to restore data.\n \nConcurrent inserts is not used by slaves with the row based\nreplication (see binary log formats).\n \nIf an INSERT statement contain the HIGH_PRIORITY clause,\nconcurrent inserts cannot be used. INSERT ... DELAYED is\nusually unneeded if concurrent inserts are enabled.\n \nLOAD DATA INFILE uses concurrent inserts if the CONCURRENT\nkeyword is specified and concurrent_insert is not NEVER.\nThis makes the statement slower (even if no other sessions\naccess the table) but reduces contention.\n \nLOCK TABLES allows non-conflicting concurrent inserts if a\nREAD LOCAL lock is used. Concurrent inserts are not allowed\nif the LOCAL keyword is omitted.\n \nNotes\n \nThe decision to enable concurrent insert for a table is done\nwhen the table is opened. If you change the value of\nconcurrent_insert it will only affect new opened tables. If\nyou want it to work for also for tables in use or cached,\nyou should do FLUSH TABLES after setting the variable.\n \n\n\nURL: https://mariadb.com/kb/en/library/concurrent-inserts/','','https://mariadb.com/kb/en/library/concurrent-inserts/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (408,27,'DELETE','Syntax\n------ \nSingle-table syntax:\n \nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] \n FROM tbl_name [PARTITION (partition_list)]\n [WHERE where_condition]\n [ORDER BY ...]\n [LIMIT row_count]\n [RETURNING select_expr \n [, select_expr ...]]\n \nMultiple-table syntax:\n \nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n tbl_name[.*] [, tbl_name[.*]] ...\n FROM table_references\n [WHERE where_condition]\n \nOr:\n \nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n FROM tbl_name[.*] [, tbl_name[.*]] ...\n USING table_references\n [WHERE where_condition]\n \nTrimming history:\n \nDELETE HISTORY\n FROM tbl_name [PARTITION (partition_list)]\n [BEFORE SYSTEM_TIME [TIMESTAMP|TRANSACTION] expression]\n \nDescription\n----------- \nOption | Description | \n \nLOW_PRIORITY | Wait until all SELECT\'s are done before\nstarting the statement. Used with storage engines that uses\ntable locking (MyISAM, Aria etc). See HIGH_PRIORITY and\nLOW_PRIORITY clauses for details. | \n \nQUICK | Signal the storage engine that it should expect that\na lot of rows are deleted. The storage engine engine can do\nthings to speed up the DELETE like ignoring merging of data\nblocks until all rows are deleted from the block (instead of\nwhen a block is half full). This speeds up things at the\nexpanse of lost space in data blocks. At least MyISAM and\nAria support this feature. | \n \nIGNORE | Don\'t stop the query even if a not-critical error\noccurs (like data overflow). See How IGNORE works for a full\ndescription. | \n \nFor the single-table syntax, the DELETE statement deletes\nrows\nfrom tbl_name and returns a count of the number of deleted\nrows. This count can\nbe obtained by calling the ROW_COUNT() function. The\nWHERE clause, if given, specifies the conditions that\nidentify\nwhich rows to delete. With no WHERE clause, all rows are\ndeleted. If the ORDER BY clause is specified, the rows are\ndeleted in the order that is specified. The LIMIT clause\nplaces a limit on the number of rows that can be deleted.\n \nFor the multiple-table syntax, DELETE deletes from each\ntbl_name the rows that satisfy the conditions. In this case,\nORDER BY and LIMIT> cannot be used. A DELETE can also\nreference tables which are located in different databases;\nsee Identifier Qualifiers for the syntax.\n \nwhere_condition is an expression that evaluates to true for\neach row to be deleted. It is specified as described in\nSELECT.\n \nCurrently, you cannot delete from a table and select from\nthe same\ntable in a subquery.\n \nYou need the DELETE privilege on a table to delete rows from\nit. You need only the SELECT privilege for any columns that\nare only read, such as those named in the WHERE clause. See\nGRANT.\n \nThe PARTITION clause was introduced in MariaDB 10.0. See\nPartition Pruning and Selection for details.\n \nAs stated, a DELETE statement with no WHERE\nclause deletes all rows. A faster way to do this, when you\ndo not need to know\nthe number of deleted rows, is to use TRUNCATE TABLE.\nHowever,\nwithin a transaction or if you have a lock on the table, \nTRUNCATE TABLE cannot be used whereas DELETE\ncan. See TRUNCATE TABLE, and\nLOCK.\n \nFrom MariaDB 10.0.5, it is possible to return a resultset of\nthe deleted rows for a single table to the client by using\nthe syntax DELETE ... RETURNING select_expr [, select_expr2\n...]]\n \nAny of SQL expression that can be calculated from a single\nrow fields is allowed. Subqueries are allowed. The AS\nkeyword is allowed, so it is possible to use aliases.\n \nThe use of aggregate functions is not allowed. RETURNING\ncannot be used in multi-table DELETEs.\n \nSame Source and Target Table\n \nUntil MariaDB 10.3.1, deleting from a table with the same\nsource and target was not possible. From MariaDB 10.3.1,\nthis is now possible. For example:\n \nDELETE FROM t1 WHERE c1 IN (SELECT b.c1 FROM t1 b WHERE\nb.c2=0);\n \nOne can use DELETE HISTORY to delete historical information\nfrom System-versioned tables.\n \nExamples\n-------- \nHow to use the ORDER BY and LIMIT clauses:\n \nDELETE FROM page_hit ORDER BY timestamp LIMIT 1000000;\n \nHow to use the RETURNING clause:\n \nDELETE FROM t RETURNING f1;\n \n+------+\n| f1 |\n+------+\n| 5 |\n| 50 |\n| 500 |\n+------+ \n \nThe following statement joins two tables: one is only used\nto satisfy a WHERE condition, but no row is deleted from it;\nrows from the other table are deleted, instead.\n \nDELETE post FROM blog INNER JOIN post WHERE blog.id =\npost.blog_id;\n \nDeleting from the Same Source and Target\n \nCREATE TABLE t1 (c1 INT, c2 INT);\nDELETE FROM t1 WHERE c1 IN (SELECT b.c1 FROM t1 b WHERE\nb.c2=0);\n \nUntil MariaDB 10.3.1, this returned:\n \nERROR 1093 (HY000): Table \'t1\' is specified twice, both as\na target for \'DELETE\' \n and as a separate source for\n \nFrom MariaDB 10.3.1:\n \nQuery OK, 0 rows affected (0.00 sec)\n \n\n\nURL: https://mariadb.com/kb/en/library/delete/','','https://mariadb.com/kb/en/library/delete/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (409,27,'DO','Syntax\n------ \nDO expr [, expr] ...\n \nDescription\n----------- \n DO executes the expressions but does not return any\nresults. In most respects, DO is shorthand for\n SELECT expr, ..., but has the advantage that it is slightly\nfaster when you do not care about the result.\n \n DO is useful primarily with functions that have side\n effects, such as RELEASE_LOCK().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/do/','','https://mariadb.com/kb/en/library/do/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (410,27,'DUAL','Description\n----------- \nYou are allowed to specify DUAL as a dummy table name in\nsituations where no tables are referenced, such as the\nfollowing SELECT statement:\n \nSELECT 1 + 1 FROM DUAL;\n \n+-------+\n| 1 + 1 |\n+-------+\n| 2 |\n+-------+\n \n DUAL is purely for the convenience of people who require\n that all SELECT statements should have\n FROM and possibly other clauses. MariaDB ignores the\n clauses. MariaDB does not require FROM DUAL if no tables\n are referenced.\n \nFROM DUAL could be used when you only SELECT computed\nvalues, but require a WHERE clause, perhaps to test that a\nscript correctly handles empty resultsets:\n \nSELECT 1 FROM DUAL WHERE FALSE;\n \nEmpty set (0.00 sec)\n \n\n\nURL: https://mariadb.com/kb/en/library/dual/','','https://mariadb.com/kb/en/library/dual/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (411,27,'EXCEPT','EXCEPT was introduced in MariaDB 10.3.0.\n \nThe result of EXCEPT is all records of the left SELECT\nresult set except records which are in right SELECT result\nset, i.e. it is subtraction of two result sets.\n \nSyntax\n------ \nSELECT ...\n(INTERSECT | EXCEPT | UNION [ALL | DISTINCT]) SELECT ...\n[(INTERSECT | EXCEPT | UNION [ALL | DISTINCT]) SELECT ...]\n[ORDER BY [column [, column ...]]]\n[LIMIT {[offset,] row_count | row_count OFFSET offset}]\n \nPlease note:\nALL is not supported by EXCEPT (and it is difficult to make\nsense of ALL with EXCEPT).\nBrackets for explicit operation precedence are not\nsupported; use a subquery in the FROM clause as a\nworkaround).\n \nDescription\n----------- \nMariaDB has supported EXCEPT and INTERSECT in addition to\nUNION since MariaDB 10.3.\n \nAll behavior for naming columns, ORDER BY and LIMIT is the\nsame as for UNION.\n \nEXCEPT implicitly supposes a DISTINCT operation.\n \nThe result of EXCEPT is all records of the left SELECT\nresult except records which are in right SELECT result set,\ni.e. it is subtraction of two result sets.\n \nEXCEPT and UNION have the same operation precedence.\n \n\nParentheses\n \nFrom MariaDB 10.4.0, parentheses can be used to specify\nprecedence. Before this, a syntax error would be returned.\n \nExamples\n-------- \nShow customers which are not employees:\n \n(SELECT e_name AS name, email FROM customers)\nEXCEPT\n(SELECT c_name AS name, email FROM employees);\n \nDifference between UNION, EXCEPT and INTERSECT:\n \nCREATE TABLE seqs (i INT);\nINSERT INTO seqs VALUES (1),(2),(3),(4),(5),(6);\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 1 |\n| 2 |\n| 3 |\n| 4 |\n| 5 |\n| 6 |\n+------+\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 1 |\n| 2 |\n+------+\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 3 |\n+------+\n \nParentheses for specifying precedence, from MariaDB 10.4.0\n \nCREATE OR REPLACE TABLE t1 (a INT);\nCREATE OR REPLACE TABLE t2 (b INT);\nCREATE OR REPLACE TABLE t3 (c INT);\n \nINSERT INTO t1 VALUES (1),(2),(3),(4);\nINSERT INTO t2 VALUES (5),(6);\nINSERT INTO t3 VALUES (1),(6);\n \n((SELECT a FROM t1) UNION (SELECT b FROM t2)) EXCEPT (SELECT\nc FROM t3);\n+------+\n| a |\n+------+\n| 2 |\n| 3 |\n| 4 |\n| 5 |\n+------+\n \n(SELECT a FROM t1) UNION ((SELECT b FROM t2) EXCEPT (SELECT\nc FROM t3));\n+------+\n| a |\n+------+\n| 1 |\n| 2 |\n| 3 |\n| 4 |\n| 5 |\n+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/except/','','https://mariadb.com/kb/en/library/except/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (412,27,'FOR UPDATE','The FOR UPDATE clause of SELECT applies only when autocommit\nis set to 0 or the SELECT is enclosed in a transaction. A\nlock is acquired on the rows, and other transactions are\nprevented from writing the rows, acquire locks, and from\nreading them (unless their isolation level is READ\nUNCOMMITTED).\n \nIf autocommit is set to 1, the LOCK IN SHARE MODE and FOR\nUPDATE clauses have no effect.\n \nIf the isolation level is set to SERIALIZABLE, all plain\nSELECT statements are converted to SELECT ... LOCK IN SHARE\nMODE.\n \nExample\n \nSELECT * FROM trans WHERE period=2001 FOR UPDATE;\n \n\n\nURL: https://mariadb.com/kb/en/library/for-update/','','https://mariadb.com/kb/en/library/for-update/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (413,27,'GROUP BY','Use the GROUP BY clause in a SELECT statement to group rows\ntogether that have the same value in one or more column, or\nthe same computed value using expressions with any\nfunctions and operators except\ngrouping functions. When you\nuse a GROUP BY clause, you will get a single result row for\neach group of rows\nthat have the same value for the expression given in GROUP\nBY.\n \nWhen grouping rows, grouping values are compared as if by\nthe = operator.\nFor string values, the = operator ignores trailing\nwhitespace and may normalize\ncharacters and ignore case, depending on the collation in\nuse.\n \nYou can use any of the grouping functions in your select\nexpression. Their values will\nbe calculated based on all the rows that have been grouped\ntogether for each result\nrow. If you select a non-grouped column or a value computed\nfrom a non-grouped\ncolumn, it is undefined which row the returned value is\ntaken from. This is not permitted if the ONLY_FULL_GROUP_BY\nSQL_MODE is used.\n \nYou can use multiple expressions in the GROUP BY clause,\nseparated by commas.\nRows are grouped together if they match on each of the\nexpressions.\n \nYou can also use a single integer as the grouping\nexpression. If you use an integer n,\nthe results will be grouped by the nth column in the select\nexpression.\n \nThe WHERE clause is applied before the GROUP BY clause. It\nfilters non-aggregated\nrows before the rows are grouped together. To filter grouped\nrows based on aggregate values,\nuse the HAVING clause. The HAVING clause takes any\nexpression and evaluates it as\na boolean, just like the WHERE clause. You can use grouping\nfunctions in the HAVING\nclause. As with the select expression, if you reference\nnon-grouped columns in the HAVING\nclause, the behavior is undefined.\n \nBy default, if a GROUP BY clause is present, the rows in the\noutput will be sorted by the expressions used in the GROUP\nBY. You can also specify ASC or DESC (ascending, descending)\nafter those expressions, like in ORDER BY. The default is\nASC.\n \nIf you want the rows to be sorted by another field, you can\nadd an explicit ORDER BY. If you don\'t want the result to\nbe ordered, you can add ORDER BY NULL.\n \nWITH ROLLUP\n \nThe WITH ROLLUP modifer adds extra rows to the resultset\nthat represent super-aggregate summaries. For a full\ndescription with examples, see SELECT WITH ROLLUP.\n \nGROUP BY Examples\n \nConsider the following table that records how many times\neach user has played and won a game:\n \nCREATE TABLE plays (name VARCHAR(16), plays INT, wins INT);\nINSERT INTO plays VALUES \n (\"John\", 20, 5), \n (\"Robert\", 22, 8), \n (\"Wanda\", 32, 8), \n (\"Susan\", 17, 3);\n \nGet a list of win counts along with a count:\n \nSELECT wins, COUNT(*) FROM plays GROUP BY wins;\n \n+------+----------+\n| wins | COUNT(*) |\n+------+----------+\n| 3 | 1 |\n| 5 | 1 |\n| 8 | 2 |\n+------+----------+\n3 rows in set (0.00 sec)\n \nThe GROUP BY expression can be a computed value, and can\nrefer back to an identifer\nspecified with AS. Get a list of win averages along with a\ncount:\n \nSELECT (wins / plays) AS winavg, COUNT(*) FROM plays GROUP\nBY winavg;\n \n+--------+----------+\n| winavg | COUNT(*) |\n+--------+----------+\n| 0.1765 | 1 |\n| 0.2500 | 2 |\n| 0.3636 | 1 |\n+--------+----------+\n3 rows in set (0.00 sec)\n \nYou can use any grouping function\nin the select expression. For each win average as above, get\na list of the average play\ncount taken to get that average:\n \nSELECT (wins / plays) AS winavg, AVG(plays) FROM plays \n GROUP BY winavg;\n \n+--------+------------+\n| winavg | AVG(plays) |\n+--------+------------+\n| 0.1765 | 17.0000 |\n| 0.2500 | 26.0000 |\n| 0.3636 | 22.0000 |\n+--------+------------+\n3 rows in set (0.00 sec)\n \nYou can filter on aggregate information using the HAVING\nclause. The HAVING\nclause is applied after GROUP BY and allows you to filter on\naggregate data that is\nnot available to the WHERE clause. Restrict the above\nexample to results that involve\nan average number of plays over 20:\n \nSELECT (wins / plays) AS winavg, AVG(plays) FROM plays \n GROUP BY winavg HAVING AVG(plays) > 20;\n \n+--------+------------+\n| winavg | AVG(plays) |\n+--------+------------+\n| 0.2500 | 26.0000 |\n| 0.3636 | 22.0000 |\n+--------+------------+\n2 rows in set (0.00 sec)\n \nSee Also\n \nSELECT\nJoins and Subqueries\nLIMIT\nORDER BY\nCommon Table Expressions\nSELECT WITH ROLLUP\nSELECT INTO OUTFILE\nSELECT INTO DUMPFILE\nFOR UPDATE\nLOCK IN SHARE MODE\nOptimizer Hints\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/group-by/','','https://mariadb.com/kb/en/library/group-by/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (414,27,'HANDLER Commands','Syntax\n------ \nHANDLER tbl_name OPEN [ [AS] alias]\nHANDLER tbl_name READ index_name { = | >= | = | \n\nURL: https://mariadb.com/kb/en/library/handler-commands/','','https://mariadb.com/kb/en/library/handler-commands/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (415,27,'HIGH_PRIORITY and LOW_PRIORITY','The XtraDB/InnoDB storage engine uses row-level locking to\nensure data integrity. However some storage engines (such as\nMEMORY, MyISAM, Aria and MERGE) lock the whole table to\nprevent conflicts. These storage engines use two separate\nqueues to remember pending statements; one is for SELECTs\nand the other one is for write statements (INSERT, DELETE,\nUPDATE). By default, the latter has a higher priority.\n \nTo give write operations a lower priority, the\nlow_priority_updates server system variable can be set to\nON. The option is available on both the global and session\nlevels, and it can be set at startup or via the SET\nstatement.\n \nWhen too many table locks have been set by write statements,\nsome pending SELECTs are executed. The maximum number of\nwrite locks that can be acquired before this happens is\ndetermined by the max_write_lock_count server system\nvariable, which is dynamic.\n \nIf write statements have a higher priority (default), the\npriority of individual write statements (INSERT, REPLACE,\nUPDATE, DELETE) can be changed via the LOW_PRIORITY\nattribute, and the priority of a SELECT statement can be\nraised via the HIGH_PRIORITY attribute. Also, LOCK TABLES\nsupports a LOW_PRIORITY attribute for WRITE locks.\n \nIf read statements have a higher priority, the priority of\nan INSERT can be changed via the HIGH_PRIORITY attribute.\nHowever, the priority of other write statements cannot be\nraised individually.\n \nThe use of LOW_PRIORITY or HIGH_PRIORITY for an INSERT\nprevents Concurrent Inserts from being used.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/high_priority-and-low_priority/','','https://mariadb.com/kb/en/library/high_priority-and-low_priority/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (416,27,'IGNORE','The IGNORE option tells the server to ignore some common\nerrors.\n \nIGNORE can be used with the following statements:\nDELETE\nINSERT (see also INSERT IGNORE)\nLOAD DATA INFILE\nUPDATE\nALTER TABLE\nCREATE TABLE ... SELECT\nINSERT ... SELECT\n \nThe logic used:\nVariables out of ranges are replaced with the\nmaximum/minimum value.\n \nSQL_MODEs STRICT_TRANS_TABLES, STRICT_ALL_TABLES,\nNO_ZERO_IN_DATE, NO_ZERO_DATE are ignored.\n \nInserting NULL in a NOT NULL field will insert 0 ( in a\nnumerical\n field), 0000-00-00 ( in a date field) or an empty string (\nin a character\n field).\n \nRows that cause a duplicate key error or break a foreign key\nconstraint are\n not inserted, updated, or deleted.\n \nThe following errors are ignored:\n \nError number | Symbolic error name | Description | \n \n1022 | ER_DUP_KEY | Can\'t write; duplicate key in table\n\'%s\' | \n \n1048 | ER_BAD_NULL_ERROR | Column \'%s\' cannot be null | \n \n1062 | ER_DUP_ENTRY | Duplicate entry \'%s\' for key %d | \n \n1242 | ER_SUBQUERY_NO_1_ROW | Subquery returns more than 1\nrow | \n \n1264 | ER_WARN_DATA_OUT_OF_RANGE | Out of range value for\ncolumn \'%s\' at row %ld | \n \n1265 | WARN_DATA_TRUNCATED | Data truncated for column\n\'%s\' at row %ld | \n \n1292 | ER_TRUNCATED_WRONG_VALUE | Truncated incorrect %s\nvalue: \'%s\' | \n \n1366 | ER_TRUNCATED_WRONG_VALUE_FOR_FIELD | Incorrect\ninteger value | \n \n1369 | ER_VIEW_CHECK_FAILED | CHECK OPTION failed \'%s.%s\'\n| \n \n1451 | ER_ROW_IS_REFERENCED_2 | Cannot delete or update a\nparent row | \n \n1452 | ER_NO_REFERENCED_ROW_2 | Cannot add or update a child\nrow: a foreign key constraint fails (%s) | \n \n1526 | ER_NO_PARTITION_FOR_GIVEN_VALUE | Table has no\npartition for value %s | \n \n1586 | ER_DUP_ENTRY_WITH_KEY_NAME | Duplicate entry \'%s\'\nfor key \'%s\' | \n \n1591 | ER_NO_PARTITION_FOR_GIVEN_VALUE_SILENT | Table has no\npartition for some existing values | \n \n1748 | ER_ROW_DOES_NOT_MATCH_GIVEN_PARTITION_SET | Found a\nrow not matching the given partition set | \n \nIgnored errors normally generate a warning.\n \nA property of the IGNORE clause consists in causing\ntransactional engines and non-transactional engines (like\nXtraDB and Aria) to behave the same way. For example,\nnormally a multi-row insert which tries to violate a UNIQUE\ncontraint is completely rolled back on XtraDB/InnoDB, but\nmight be partially executed on Aria. With the IGNORE clause,\nthe statement will be partially executed in both engines.\n \nStarting from MariaDB 5.5.28 duplicate key errors also\ngenerate warnings. The OLD_MODE server variable can be used\nto prevent this.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/ignore/','','https://mariadb.com/kb/en/library/ignore/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (417,27,'INSERT','Syntax\n------ \nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n [ ON DUPLICATE KEY UPDATE\n col=expr\n [, col=expr] ... ]\n \nOr:\n \nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [PARTITION (partition_list)]\n SET col={expr | DEFAULT}, ...\n [ ON DUPLICATE KEY UPDATE\n col=expr\n [, col=expr] ... ]\n \nOr:\n \nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n SELECT ...\n [ ON DUPLICATE KEY UPDATE\n col=expr\n [, col=expr] ... ]\n \nThe INSERT statement is used to insert new rows into an\nexisting table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based\non explicitly specified values. The INSERT ... SELECT form\ninserts rows selected from another table or tables. INSERT\n... SELECT is discussed further in the INSERT ... SELECT\narticle.\n \nThe table name can be specified in the form db_name.tbl_name\nor, if a default database is selected, in the form tbl_name\n(see Identifier Qualifiers). This allows to use INSERT ...\nSELECT to copy rows between different databases.\n \nThe PARTITION clause was introduced in MariaDB 10.0. It can\nbe used in both the INSERT and the SELECT part. See\nPartition Pruning and Selection for details.\n \nThe columns list is optional. It specifies which values are\nexplicitly inserted, and in which order. If this clause is\nnot specified, all values must be explicitly specified, in\nthe same order they are listed in the table definition.\n \nThe list of value follow the VALUES or VALUE keyword (which\nare interchangeable, regardless how much values you want to\ninsert), and is wrapped by parenthesis. The values must be\nlisted in the same order as the columns list. It is possible\nto specify more than one list to insert more than one rows\nwith a single statement. If many rows are inserted, this is\na speed optimization.\n \nFor one-row statements, the SET clause may be more simple,\nbecause you don\'t need to remember the columns order. All\nvalues are specified in the form col = expr.\n \nValues can also be specified in the form of a SQL expression\nor subquery. However, the subquery cannot access the same\ntable that is named in the INTO clause.\n \nIf you use the LOW_PRIORITY keyword, execution of the INSERT\nis delayed until no other clients are reading from the\ntable. If you use the HIGH_PRIORITY keyword, the statement\nhas the same priority as SELECTs. This affects only storage\nengines that use only table-level locking (MyISAM, MEMORY,\nMERGE). However, if one of these keywords is specified,\nconcurrent inserts cannot be used. See HIGH_PRIORITY and\nLOW_PRIORITY clauses for details.\n \nINSERT DELAYED\n \nFor more details on the DELAYED option, see INSERT DELAYED.\n \nHIGH PRIORITY and LOW PRIORITY\n \nSee HIGH_PRIORITY and LOW_PRIORITY.\n \nDefaults and Duplicate Values\n \nSee INSERT - Default & Duplicate Values for details..\n \nINSERT IGNORE\n \nSee INSERT IGNORE.\n \nINSERT ON DUPLICATE KEY UPDATE\n \nSee INSERT ON DUPLICATE KEY UPDATE.\n \nExamples\n-------- \nSpecifying the column names:\n \nINSERT INTO person (first_name, last_name) VALUES (\'John\',\n\'Doe\');\n \nInserting more than 1 row at a time:\n \nINSERT INTO tbl_name VALUES (1, \"row 1\"), (2, \"row 2\");\n \nUsing the SET clause:\n \nINSERT INTO person SET first_name = \'John\', last_name =\n\'Doe\';\n \nSELECTing from another table:\n \nINSERT INTO contractor SELECT * FROM person WHERE status =\n\'c\';\n \nSee INSERT ON DUPLICATE KEY UPDATE and INSERT IGNORE for\nfurther examples.\n \n\n\nURL: https://mariadb.com/kb/en/library/insert/','','https://mariadb.com/kb/en/library/insert/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (418,27,'INSERT - Default &amp; Duplicate Values','Default Values\n \nIf the SQL_MODE contains STRICT_TRANS_TABLES and you are\ninserting into a transactional table (like InnoDB), or if\nthe SQL_MODE contains STRICT_ALL_TABLES, all NOT NULL\ncolumns which does not have a DEFAULT value (and is not\nAUTO_INCREMENT) must be explicitly referenced in INSERT\nstatements. If not, an error like this is produced:\n \nERROR 1364 (HY000): Field \'col\' doesn\'t have a default\nvalue\n \nIn all other cases, if a NOT NULL column without a DEFAULT\nvalue is not referenced, an empty value will be inserted\n(for example, 0 for INTEGER columns and \'\' for CHAR\ncolumns). See NULL Values in MariaDB:Inserting for examples.\n \nIf a NOT NULL column having a DEFAULT value is not\nreferenced, NULL will be inserted.\n \nIf a NULL column having a DEFAULT value is not referenced,\nits default value will be inserted. It is also possible to\nexplicitly assign the default value using the DEFAULT\nkeyword or the DEFAULT() function.\n \nIf the DEFAULT keyword is used but the column does not have\na DEFAULT value, an error like this is produced:\n \nERROR 1364 (HY000): Field \'col\' doesn\'t have a default\nvalue\n \nDuplicate Values\n \nBy default, if you try to insert a duplicate row and there\nis a UNIQUE index, INSERT stops and an error like this is\nproduced:\n \nERROR 1062 (23000): Duplicate entry \'dup_value\' for key\n\'col\'\n \nTo handle duplicates you can use the IGNORE clause, INSERT\nON DUPLICATE KEY UPDATE or the REPLACE statement. Note that\nthe IGNORE and DELAYED options are ignored when you use ON\nDUPLICATE KEY UPDATE.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/insert-default-duplicate-values/','','https://mariadb.com/kb/en/library/insert-default-duplicate-values/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (419,27,'INSERT DELAYED','Syntax\n------ \nINSERT DELAYED ...\n \nDescription\n----------- \nThe DELAYED option for the INSERT\nstatement is a MariaDB/MySQL extension to standard SQL that\nis very useful if you have\nclients that cannot or need not wait for the INSERT to\ncomplete. This is a common situation when you use MariaDB\nfor logging and you\nalso periodically run SELECT and UPDATE\nstatements that take a long time to complete.\n \nWhen a client uses INSERT DELAYED, it gets an okay from the\nserver at once, and the row is queued to be inserted when\nthe table is not in\nuse by any other thread.\n \nAnother major benefit of using INSERT DELAYED is that\ninserts from many clients are bundled together and written\nin one block. This\nis much faster than performing many separate inserts.\n \nNote that INSERT DELAYED is slower than a normal\n INSERT if the table is not otherwise in use. There is also\nthe additional overhead for the server to handle a separate\nthread for each\ntable for which there are delayed rows. This means that you\nshould use\nINSERT DELAYED only when you are really sure that you need\nit.\n \nThe queued rows are held only in memory until they are\ninserted into the table.\nThis means that if you terminate mysqld forcibly (for\nexample, with kill -9) or\nif mysqld dies unexpectedly, any queued rows that have not\nbeen written to disk\nare lost.\n \nThe number of concurrent INSERT DELAYED threads is limited\nby the max_delayed_threads server system variables. If it is\nset to 0, INSERT DELAYED is disabled. The session value can\nbe equal to the global value, or 0 to disable this statement\nfor the current session. If this limit has been reached, the\nDELAYED clause will be silently ignore for subsequent\nstatements (no error will be produced).\n \nThere are some constraints on the use of DELAYED:\nINSERT DELAYED works only with MyISAM, MEMORY, ARCHIVE,\n and BLACKHOLE tables. If you execute INSERT DELAYED with\nanother storage engine, you will get an error like this:\nERROR 1616 (HY000): DELAYED option not supported for table\n\'tab_name\'\nFor MyISAM tables, if there are no free blocks in the middle\nof the data\n file, concurrent SELECT and INSERT statements are\nsupported. Under these\n circumstances, you very seldom need to use INSERT DELAYED\n with MyISAM.\nINSERT DELAYED should be used only for\n INSERT statements that specify value lists. The server\n ignores DELAYED for INSERT ... SELECT\n or INSERT ... ON DUPLICATE KEY UPDATE statements.\nBecause the INSERT DELAYED statement returns immediately,\n before the rows are inserted, you cannot use\n LAST_INSERT_ID() to get the\n AUTO_INCREMENT value that the statement might generate.\nDELAYED rows are not visible to SELECT\n statements until they actually have been inserted.\nAfter INSERT DELAYED, ROW_COUNT() returns the number of the\nrows you tried to insert, not the number of the successful\nwrites.\nDELAYED is ignored on slave replication servers, so that \n INSERT DELAYED is treated as a normal\n INSERT on slaves. This is because\n DELAYED could cause the slave to have different data than\n the master. INSERT DELAYED statements are not safe for\nreplication.\nPending INSERT DELAYED statements are lost if a table is\n write locked and ALTER TABLE is used to modify the table\nstructure.\nINSERT DELAYED is not supported for views. If you try, you\nwill get an error like this: ERROR 1347 (HY000):\n\'view_name\' is not BASE TABLE\nINSERT DELAYED is not supported for partitioned tables.\nINSERT DELAYED is not supported within stored programs.\n \n\n\nURL: https://mariadb.com/kb/en/library/insert-delayed/','','https://mariadb.com/kb/en/library/insert-delayed/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (420,27,'INSERT IGNORE','Ignoring Errors\n \nNormally INSERT stops and rolls back when it encounters an\nerror.\n \nBy using the IGNORE keyword all errors are converted to\nwarnings, which will not stop inserts of additional rows.\n \nThe IGNORE and DELAYED options are ignored when you use ON\nDUPLICATE KEY UPDATE.\n \nIncompatibilities\n \nMariaDB until 5.5.28\nMySQL and MariaDB before 5.5.28 didn\'t give warnings for\nduplicate key errors when using IGNORE.\nYou can get the old behaviour if you set OLD_MODE to\nNO_DUP_KEY_WARNINGS_WITH_IGNORE\n \nExamples\n-------- \nCREATE TABLE t1 (x INT UNIQUE);\n \nINSERT INTO t1 VALUES(1),(2);\n \nINSERT INTO t1 VALUES(2),(3);\nERROR 1062 (23000): Duplicate entry \'2\' for key \'x\'\nSELECT * FROM t1;\n \n+------+\n| x |\n+------+\n| 1 |\n| 2 |\n+------+\n2 rows in set (0.00 sec)\n \nINSERT IGNORE INTO t1 VALUES(2),(3);\nQuery OK, 1 row affected, 1 warning (0.04 sec)\n \nSHOW WARNINGS;\n \n+---------+------+---------------------------------+\n| Level | Code | Message |\n+---------+------+---------------------------------+\n| Warning | 1062 | Duplicate entry \'2\' for key \'x\' |\n+---------+------+---------------------------------+\n \nSELECT * FROM t1;\n \n+------+\n| x |\n+------+\n| 1 |\n| 2 |\n| 3 |\n+------+\n \nSee INSERT ON DUPLICATE KEY UPDATE for further examples\nusing that syntax.\n \n\n\nURL: https://mariadb.com/kb/en/library/insert-ignore/','','https://mariadb.com/kb/en/library/insert-ignore/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (421,27,'INSERT ON DUPLICATE KEY UPDATE','Syntax\n------ \nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n [ ON DUPLICATE KEY UPDATE\n col=expr\n [, col=expr] ... ]\n \nOr:\n \nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [PARTITION (partition_list)]\n SET col={expr | DEFAULT}, ...\n [ ON DUPLICATE KEY UPDATE\n col=expr\n [, col=expr] ... ]\n \nOr:\n \nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n SELECT ...\n [ ON DUPLICATE KEY UPDATE\n col=expr\n [, col=expr] ... ]\n \nDescription\n----------- \nINSERT ... ON DUPLICATE KEY UPDATE is a MariaDB/MySQL\nextension to the INSERT statement that, if it finds a\nduplicate unique or primary key, will instead perform an\nUPDATE.\n \nThe row/s affected value is reported as 1 if a row is\ninserted, and 2 if a row is updated, unless the API\'s\nCLIENT_FOUND_ROWS flag is set.\n \nIf more than one unique index is matched, only the first is\nupdated. It is not recommended to use this statement on\ntables with more than one unique index.\n \nIf the table has an AUTO_INCREMENT primary key and the\nstatement inserts or updates a row, the LAST_INSERT_ID()\nfunction returns its AUTO_INCREMENT value.\n \nThe VALUES() function can only be used in a ON DUPLICATE KEY\nUPDATE clause and has no meaning in any other context. It\nreturns the column values from the INSERT portion of the\nstatement. This function is particularly useful for\nmulti-rows inserts.\n \nThe IGNORE and DELAYED options are ignored when you use ON\nDUPLICATE KEY UPDATE.\n \nThe PARTITION clause was introduced in MariaDB 10.0. See\nPartition Pruning and Selection for details.\n \nThis statement activates INSERT and UPDATE triggers. See\nTrigger Overview for details.\n \nSee also a similar statement, REPLACE.\n \nExamples\n-------- \nCREATE TABLE ins_duplicate (id INT PRIMARY KEY, animal\nVARCHAR(30));\nINSERT INTO ins_duplicate VALUES (1,\'Aardvark\'),\n(2,\'Cheetah\'), (3,\'Zebra\');\n \nIf there is no existing key, the statement runs as a regular\nINSERT:\n \nINSERT INTO ins_duplicate VALUES (4,\'Gorilla\') ON\nDUPLICATE KEY UPDATE animal=\'Gorilla\';\nQuery OK, 1 row affected (0.07 sec)\n \nSELECT * FROM ins_duplicate;\n+----+----------+\n| id | animal |\n+----+----------+\n| 1 | Aardvark |\n| 2 | Cheetah |\n| 3 | Zebra |\n| 4 | Gorilla |\n+----+----------+\n \nA regular INSERT with a primary key value of 1 will fail,\ndue to the existing key:\n \nINSERT INTO ins_duplicate VALUES (1,\'Antelope\');\nERROR 1062 (23000): Duplicate entry \'1\' for key\n\'PRIMARY\'\n \nHowever, we can use an INSERT ON DUPLICATE KEY UPDATE\ninstead:\n \nINSERT INTO ins_duplicate VALUES (1,\'Antelope\') ON\nDUPLICATE KEY UPDATE animal=\'Antelope\';\nQuery OK, 2 rows affected (0.09 sec)\n \nNote that there are two rows reported as affected, but this\nrefers only to the UPDATE.\n \nSELECT * FROM ins_duplicate;\n+----+----------+\n| id | animal |\n+----+----------+\n| 1 | Antelope |\n| 2 | Cheetah |\n| 3 | Zebra |\n| 4 | Gorilla |\n+----+----------+\n \nAdding a second unique column:\n \nALTER TABLE ins_duplicate ADD id2 INT;\nUPDATE ins_duplicate SET id2=id+10;\nALTER TABLE ins_duplicate ADD UNIQUE KEY(id2);\n \nWhere two rows match the unique keys match, only the first\nis updated. This can be unsafe and is not recommended unless\nyou are certain what you are doing. Note that the warning\nshown below appears in MariaDB 5.5 and before, but has been\nremoved in MariaDB 10.0, as MariaDB now assumes that the\nkeys are checked in order, as shown in SHOW CREATE TABLE.\n \nINSERT INTO ins_duplicate VALUES (2,\'Lion\',13) ON\nDUPLICATE KEY UPDATE animal=\'Lion\';\nQuery OK, 2 rows affected, 1 warning (0.06 sec)\n \nSHOW WARNINGS;\n+-------+------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| Level | Code | Message |\n+-------+------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n| Note | 1592 | Unsafe statement written to the binary log\nusing statement format since BINLOG_FORMAT = STATEMENT.\nINSERT... ON DUPLICATE KEY UPDATE on a table with more than\none UNIQUE KEY is unsafe |\n+-------+------+------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------+\n \nSELECT * FROM ins_duplicate;\n+----+----------+------+\n| id | animal | id2 |\n+----+----------+------+\n| 1 | Antelope | 11 |\n| 2 | Lion | 12 |\n| 3 | Zebra | 13 |\n| 4 | Gorilla | 14 |\n+----+----------+------+\n \nAlthough the third row with an id of 3 has an id2 of 13,\nwhich also matched, it was not updated.\n \nChanging id to an auto_increment field. If a new row is\nadded, the auto_increment is moved forward. If the row is\nupdated, it remains the same.\n \nALTER TABLE `ins_duplicate` CHANGE `id` `id` INT( 11 ) NOT\nNULL AUTO_INCREMENT;\nALTER TABLE ins_duplicate DROP id2;\nSELECT Auto_increment FROM INFORMATION_SCHEMA.TABLES WHERE\nTABLE_NAME=\'ins_duplicate\';\n+----------------+\n| Auto_increment |\n+----------------+\n| 5 |\n+----------------+\n \nINSERT INTO ins_duplicate VALUES (2,\'Leopard\') ON\nDUPLICATE KEY UPDATE animal=\'Leopard\';\nQuery OK, 2 rows affected (0.00 sec)\n \nSELECT Auto_increment FROM INFORMATION_SCHEMA.TABLES WHERE\nTABLE_NAME=\'ins_duplicate\';\n+----------------+\n| Auto_increment |\n+----------------+\n| 5 |\n+----------------+\n \nINSERT INTO ins_duplicate VALUES (5,\'Wild Dog\') ON\nDUPLICATE KEY UPDATE animal=\'Wild Dog\';\nQuery OK, 1 row affected (0.09 sec)\n \nSELECT * FROM ins_duplicate;\n+----+----------+\n| id | animal |\n+----+----------+\n| 1 | Antelope |\n| 2 | Leopard |\n| 3 | Zebra |\n| 4 | Gorilla |\n| 5 | Wild Dog |\n+----+----------+\n \nSELECT Auto_increment FROM INFORMATION_SCHEMA.TABLES WHERE\nTABLE_NAME=\'ins_duplicate\';\n+----------------+\n| Auto_increment |\n+----------------+\n| 6 |\n+----------------+\n \nRefering to column values from the INSERT portion of the\nstatement: \n \nINSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n \nSee the VALUES() function for more.\n \n\n\nURL:\nhttps://mariadb.com/kb/en/library/insert-on-duplicate-key-update/','','https://mariadb.com/kb/en/library/insert-on-duplicate-key-update/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (422,27,'INSERT SELECT','Syntax\n------ \nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n [INTO] tbl_name [(col_name,...)]\n SELECT ...\n [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n \nDescription\n----------- \nWith INSERT ... SELECT, you can quickly insert many rows\ninto a table from one or more other tables. For example:\n \nINSERT INTO tbl_temp2 (fld_id)\n SELECT tbl_temp1.fld_order_id\n FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n \ntbl_name can also be specified in the form db_name.tbl_name\n(see Identifier Qualifiers). This allows to copy rows\nbetween different databases.\n \nIf the new table has a primary key or UNIQUE indexes, you\ncan use IGNORE to handle duplicate key errors during the\nquery. The newer values will not be inserted if an identical\nvalue already exists.\n \nREPLACE can be used instead of INSERT to prevent duplicates\non UNIQUE indexes by deleting old values. In that case, ON\nDUPLICATE KEY UPDATE cannot be used.\n \nINSERT ... SELECT works for tables which already exist. To\ncreate a table for a given resultset, you can use CREATE\nTABLE ... SELECT.\n \n\n\nURL: https://mariadb.com/kb/en/library/insert-select/','','https://mariadb.com/kb/en/library/insert-select/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (423,27,'INTERSECT','INTERSECT was introduced in MariaDB 10.3.0.\n \nThe result of an intersect is the intersection of right and\nleft SELECT results, i.e. only records that are present in\nboth result sets will be included in the result of the\noperation.\n \nSyntax\n------ \nSELECT ...\n(INTERSECT | EXCEPT | UNION [ALL | DISTINCT]) SELECT ...\n[(INTERSECT | EXCEPT | UNION [ALL | DISTINCT]) SELECT ...]\n[ORDER BY [column [, column ...]]]\n[LIMIT {[offset,] row_count | row_count OFFSET offset}]\n \nPlease note:\nALL is not supported by INTERSECT (and it is difficult to\nmake sense of ALL with INTERSECT).\nBrackets for explicit operation precedence are not\nsupported; use a subquery in the FROM clause as a\nworkaround).\n \nDescription\n----------- \nMariaDB has supported INTERSECT (as well as EXCEPT) in\naddition to UNION since MariaDB 10.3.\n \nAll behavior for naming columns, ORDER BY and LIMIT is the\nsame as for UNION.\n \nINTERSECT implicitly supposes a DISTINCT operation.\n \nThe result of an intersect is the intersection of right and\nleft SELECT results, i.e. only records that are present in\nboth result sets will be included in the result of the\noperation.\n \nINTERSECT has higher precedence than UNION and EXCEPT. If\npossible it will be executed linearly but if not it will be\ntranslated to a subquery in the FROM clause:\n \n(select a,b from t1)\nunion\n(select c,d from t2)\nintersect\n(select e,f from t3)\nunion\n(select 4,4);\n \nwill be translated to:\n \n(select a,b from t1)\nunion\nselect c,d from\n ((select c,d from t2)\n intersect\n (select e,f from t3)) dummy_subselect\nunion\n(select 4,4)\n \n\n \nParentheses\n \nFrom MariaDB 10.4.0, parentheses can be used to specify\nprecedence. Before this, a syntax error would be returned.\n \nExamples\n-------- \nShow customers which are employees:\n \n(SELECT e_name AS name, email FROM employees)\nINTERSECT\n(SELECT c_name AS name, email FROM customers);\n \nDifference between UNION, EXCEPT and INTERSECT:\n \nCREATE TABLE seqs (i INT);\nINSERT INTO seqs VALUES (1),(2),(3),(4),(5),(6);\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 1 |\n| 2 |\n| 3 |\n| 4 |\n| 5 |\n| 6 |\n+------+\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 1 |\n| 2 |\n+------+\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 3 |\n+------+\n \nParentheses for specifying precedence, from MariaDB 10.4.0\n \nCREATE OR REPLACE TABLE t1 (a INT);\nCREATE OR REPLACE TABLE t2 (b INT);\nCREATE OR REPLACE TABLE t3 (c INT);\n \nINSERT INTO t1 VALUES (1),(2),(3),(4);\nINSERT INTO t2 VALUES (5),(6);\nINSERT INTO t3 VALUES (1),(6);\n \n((SELECT a FROM t1) UNION (SELECT b FROM t2)) INTERSECT\n(SELECT c FROM t3);\n+------+\n| a |\n+------+\n| 1 |\n| 6 |\n+------+\n \n(SELECT a FROM t1) UNION ((SELECT b FROM t2) INTERSECT\n(SELECT c FROM t3));\n+------+\n| a |\n+------+\n| 1 |\n| 2 |\n| 3 |\n| 4 |\n| 6 |\n+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/intersect/','','https://mariadb.com/kb/en/library/intersect/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (424,27,'JOIN Syntax','Description\n----------- \nMariaDB supports the following JOIN syntaxes for\nthe table_references part of SELECT statements and\nmultiple-table DELETE and UPDATE statements:\n \ntable_references:\n table_reference [, table_reference] ...\n \ntable_reference:\n table_factor\n | join_table\n \ntable_factor:\n tbl_name [PARTITION (partition_list)]\n [query_system_time_period_specification] [[AS] alias]\n[index_hint_list]\n | table_subquery [query_system_time_period_specification]\n[AS] alias\n | ( table_references )\n | { ON table_reference LEFT OUTER JOIN table_reference\n ON conditional_expr }\n \njoin_table:\n table_reference [INNER | CROSS] JOIN table_factor\n[join_condition]\n | table_reference STRAIGHT_JOIN table_factor\n | table_reference STRAIGHT_JOIN table_factor ON\nconditional_expr\n | table_reference {LEFT|RIGHT} [OUTER] JOIN table_reference\njoin_condition\n | table_reference NATURAL [{LEFT|RIGHT} [OUTER]] JOIN\ntable_factor\n \njoin_condition:\n ON conditional_expr\n | USING (column_list)\n \nquery_system_time_period_specification:\n FOR SYSTEM_TIME AS OF point_in_time\n | FOR SYSTEM_TIME BETWEEN point_in_time AND point_in_time\n | FOR SYSTEM_TIME FROM point_in_time TO point_in_time\n | FOR SYSTEM_TIME ALL\n \npoint_in_time:\n [TIMESTAMP] expression\n | TRANSACTION expression\n \nindex_hint_list:\n index_hint [, index_hint] ...\n \nindex_hint:\n USE {INDEX|KEY}\n [{FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n | IGNORE {INDEX|KEY}\n [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n | FORCE {INDEX|KEY}\n [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n \nindex_list:\n index_name [, index_name] ...\n \nA table reference is also known as a join expression.\n \nEach table can also be specified as db_name.tabl_name. This\nallows to write queries which involve multiple databases.\nSee Identifier Qualifiers for syntax details.\n \nThe syntax of table_factor is extended in comparison with\nthe\nSQL Standard. The latter accepts only table_reference, not a\nlist of them inside a pair of parentheses.\n \nThis is a conservative extension if we consider each comma\nin a list of\ntable_reference items as equivalent to an inner join. For\nexample:\n \nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n \nis equivalent to:\n \nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n \nIn MariaDB, CROSS JOIN is a syntactic equivalent to\nINNER JOIN (they can replace each other). In standard SQL,\nthey are not equivalent. INNER JOIN is used with an\nON clause, CROSS JOIN is used otherwise.\n \nIn general, parentheses can be ignored in join expressions\ncontaining only\ninner join operations. MariaDB also supports nested joins\n(see\nhttp://dev.mysql.com/doc/refman/5.1/en/nested-join-optimization.html).\n \nSee System-versioned tables for more information\nabout FOR SYSTEM_TIME syntax.\n \nIndex hints can be specified to affect how the MariaDB\noptimizer makes\nuse of indexes. For more information, see How to force query\nplans.\n \nExamples\n-------- \nSELECT left_tbl.*\n FROM left_tbl LEFT JOIN right_tbl ON left_tbl.id =\nright_tbl.id\n WHERE right_tbl.id IS NULL;\n \n\n \n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/join-syntax/','','https://mariadb.com/kb/en/library/join-syntax/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (425,27,'LIMIT','Description\n----------- \nUse the LIMIT clause to restrict the number of returned\nrows. When you use a single\ninteger n with LIMIT, the first n rows will be returned. Use\nthe ORDER BY\nclause to control which rows come first. You can also select\na number of rows after an offset\nusing either of the following:\n \nLIMIT offset, row_count\nLIMIT row_count OFFSET offset\n \nWhen you provide an offset m with a limit n, the first m\nrows will be ignored, and the\nfollowing n rows will be returned.\n \nExecuting an UPDATE with the LIMIT clause is not safe for\nreplication.\n \nSince MariaDB 10.0.11, LIMIT 0 has been an exception to this\nrule (see MDEV-6170).\n \nBeginning in MariaDB 5.5.21, there is a LIMIT ROWS EXAMINED\noptimization which provides the\nmeans to terminate the execution of SELECT statements which\nexamine too\nmany rows, and thus use too many resources. See LIMIT ROWS\nEXAMINED.\n \nMulti-Table Updates\n \nUntil MariaDB 10.3.1, it was not possible to use LIMIT (or\nORDER BY) in a multi-table UPDATE statement. This\nrestriction was lifted in MariaDB 10.3.2.\n \nGROUP_CONCAT\n \nStarting from MariaDB 10.3.3, it is possible to use LIMIT\nwith GROUP_CONCAT().\n \nExamples\n-------- \nCREATE TABLE members (name VARCHAR(20));\nINSERT INTO members\nVALUES(\'Jagdish\'),(\'Kenny\'),(\'Rokurou\'),(\'Immaculada\');\n \nSELECT * FROM members;\n \n+------------+\n| name |\n+------------+\n| Jagdish |\n| Kenny |\n| Rokurou |\n| Immaculada |\n+------------+\n \nSelect the first two names (no ordering specified):\n \nSELECT * FROM members LIMIT 2;\n \n+---------+\n| name |\n+---------+\n| Jagdish |\n| Kenny |\n+---------+\n \nAll the names in alphabetical order:\n \nSELECT * FROM members ORDER BY name;\n \n+------------+\n| name |\n+------------+\n| Immaculada |\n| Jagdish |\n| Kenny |\n| Rokurou |\n+------------+\n \nThe first two names, ordered alphabetically:\n \nSELECT * FROM members ORDER BY name LIMIT 2;\n \n+------------+\n| name |\n+------------+\n| Immaculada |\n| Jagdish |\n+------------+\n \nThe third name, ordered alphabetically (the first name would\nbe offset zero, so the third is offset two):\n \nSELECT * FROM members ORDER BY name LIMIT 2,1;\n \n+-------+\n| name |\n+-------+\n| Kenny |\n+-------+\n \nFrom MariaDB 10.3.2, LIMIT can be used in a multi-table\nupdate:\n \nCREATE TABLE warehouse (product_id INT, qty INT);\nINSERT INTO warehouse VALUES\n(1,100),(2,100),(3,100),(4,100);\n \nCREATE TABLE store (product_id INT, qty INT);\nINSERT INTO store VALUES (1,5),(2,5),(3,5),(4,5);\n \nUPDATE warehouse,store SET warehouse.qty = warehouse.qty-2,\nstore.qty = store.qty+2 \n WHERE (warehouse.product_id = store.product_id AND\nstore.product_id >= 1) \n ORDER BY store.product_id DESC LIMIT 2;\n \nSELECT * FROM warehouse;\n \n+------------+------+\n| product_id | qty |\n+------------+------+\n| 1 | 100 |\n| 2 | 100 |\n| 3 | 98 |\n| 4 | 98 |\n+------------+------+\n \nSELECT * FROM store;\n \n+------------+------+\n| product_id | qty |\n+------------+------+\n| 1 | 5 |\n| 2 | 5 |\n| 3 | 7 |\n| 4 | 7 |\n+------------+------+\n \nFrom MariaDB 10.3.3, LIMIT can be used with GROUP_CONCAT,\nso, for example, given the following table:\n \nCREATE TABLE d (dd DATE, cc INT);\n \nINSERT INTO d VALUES (\'2017-01-01\',1);\nINSERT INTO d VALUES (\'2017-01-02\',2);\nINSERT INTO d VALUES (\'2017-01-04\',3);\n \nthe following query:\n \nSELECT SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc)\nORDER BY cc DESC),\",\",1) FROM d;\n \n+----------------------------------------------------------------------------+\n| SUBSTRING_INDEX(GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER\nBY cc DESC),\",\",1) |\n+----------------------------------------------------------------------------+\n| 2017-01-04:3 |\n+----------------------------------------------------------------------------+\n \ncan be more simply rewritten as:\n \nSELECT GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC\nLIMIT 1) FROM d;\n \n+-------------------------------------------------------------+\n| GROUP_CONCAT(CONCAT_WS(\":\",dd,cc) ORDER BY cc DESC LIMIT\n1) |\n+-------------------------------------------------------------+\n| 2017-01-04:3 |\n+-------------------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/limit/','','https://mariadb.com/kb/en/library/limit/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (426,27,'LOAD DATA INFILE','Syntax\n------ \nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE\n\'file_name\'\n [REPLACE | IGNORE]\n INTO TABLE tbl_name\n [CHARACTER SET charset_name]\n [{FIELDS | COLUMNS}\n [TERMINATED BY \'string\']\n [[OPTIONALLY] ENCLOSED BY \'char\']\n [ESCAPED BY \'char\']\n ]\n [LINES\n [STARTING BY \'string\']\n [TERMINATED BY \'string\']\n ]\n [IGNORE number LINES]\n [(col_name_or_user_var,...)]\n [SET col_name = expr,...]\n \nDescription\n----------- \nReads rows from a text file into the designated table on the\ndatabase at a very high speed. The file name must be given\nas a literal string. \n \nFiles are written to disk using the SELECT INTO OUTFILE\nstatement. You can then read the files back into a table\nusing the LOAD DATA INFILE statement. The FIELDS and LINES\nclauses are the same in both statements. These clauses are\noptional, but if both are specified then the FIELDS clause\nmust precede LINES.\n \nIn releases after MariaDB 5.5, LOAD DATA INFILE is unsafe\nfor statement-based replication.\n \nExecuting this statement activates INSERT triggers.\n \nREPLACE and IGNORE\n \nIn cases where you load data from a file into a table that\nalready contains data and has a Primary Key, you may\nencounter issues where the statement attempts to insert a\nrow with a Primary Key that already exists. When this\nhappens, the statement fails with Error 1064, protecting the\ndata already on the table. In cases where you want MariaDB\nto overwrite duplicates, use the REPLACE keyword.\n \nThe REPLACE keyword works like the REPLACE statement. Here,\nthe statement attempts to load the data from the file. If\nthe row does not exist, it adds it to the table. If the row\ncontains an existing Primary Key, it replaces the table\ndata. That is, in the event of a conflict, it assumes the\nfile contains the desired row. \n \nThis operation can cause a degradation in load speed by a\nfactor of 20 or more if the part that has already been\nloaded is larger than the capacity of the InnoDB Buffer\nPool. This happens because it causes a lot of turnaround in\nthe Buffer Pool.\n \nUse the IGNORE keyword when you want to skip any rows that\ncontain a conflicting Primary Key. Here, the statement\nattempts to load the data from the file. If the row does not\nexist, it adds it to the table. If the row contains an\nexisting Primary Key, it ignores the addition request and\nmoves on to the next. That is, in the event of a conflict,\nit assumes the table contains the desired row.\n \nLOCAL\n \nWhen you issue this statement, the Server attempts to read\nfiles from the host file system. Using the LOCAL keyword,\nthe statement instead attempts to read files from the\nclient. This allows you to insert files from the client\'s\nlocal file system into the database.\n \nIn the event that you don\'t want the server to permit this\noperation, (such as for security reasons), you can disable\nsupport using local_infile. When this system variable is set\nto 0, MariaDB rejects LOAD DATA LOCAL INFILE statements,\nfailing with an error message.\n \nCharacter-sets\n \nWhen the statement opens the file, it attempts to read the\ncontents using the default character-set, as defined by the\ncharacter_set_database system variable. \n \nIn the cases where the file was written using a\ncharacter-set other than the default, you can specify the\ncharacter-set to use with the CHARACTER SET clause in the\nstatement. It ignores character-sets specified by the SET\nNAMES statement and by the character_set_client system\nvariable. Setting the CHARACTER SET clause to a value of\nbinary indicates \"no conversion.\"\n \nThe statement interprets all fields in the file as having\nthe same character-set, regardless of the column data type.\nTo properly interpret file contents, you must ensure that it\nwas written with the correct character-set. If you write a\ndata file with mysqldump -T or with the SELECT INTO OUTFILE\nstatement with the mysql client, be sure to use the\n--default-character-set option, so that the output is\nwritten with the desired character-set.\n \nWhen using mixed character sets, use the CHARACTER SET\nclause in both SELECT INTO OUTFILE and LOAD DATA INFILE to\nensure that MariaDB correctly interprets the escape\nsequences.\n \nThe character_set_filesystem system variable controls the\ninterpretation of the filename.\n \nIt is currently not possible to load data files that use the\nucs2 character set.\n \nPriority and Concurrency\n \nIn loading data from a file, there\'s a risk that the\nstatement will attempt insertions concurrent with reads from\nanother client, which can result in the read serving a\nresult-set that contains only part of the update from the\nLOAD DATA INFILE statement.\n \nUsing the LOW_PRIORITY keyword, MariaDB delays insertions\nuntil no other clients are reading from the table.\nAlternatively, you can use the CONCURRENT keyword to perform\nconcurrent insertion.\n \nThe LOW_PRIORITY and CONCURRENT keywords are mutually\nexclusive. They cannot be used in the same statement.\n \nProgress Reporting\n \nSince MariaDB 5.3, the LOAD DATA INFILE statement supports\nprogress reporting. You may find this useful when dealing\nwith long-running operations. Using another client you can\nissue a SHOW PROCESSLIST query to check the progress of the\ndata load.\n \nUsing mysqlimport\n \nMariaDB ships with a separate utility for loading data from\nfiles: mysqlimport. It operates by sending LOAD DATA INFILE\nstatements to the server.\n \nUsing mysqlimport you can compress the file using the\n--compress option, to get better performance over slow\nnetworks, providing both the client and server support the\ncompressed protocol. Use the --local option to load from the\nlocal file system.\n \nIndexing\n \nIn cases where the storage engine supports ALTER TABLE...\nDISABLE KEYS statements, the LOAD DATA INFILE statement\nautomatically disables indexes during the execution.\n \n\n\nURL: https://mariadb.com/kb/en/library/load-data-infile/','','https://mariadb.com/kb/en/library/load-data-infile/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (427,27,'LOAD XML','Syntax\n------ \nLOAD XML [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE\n\'file_name\'\n [REPLACE | IGNORE]\n INTO TABLE [db_name.]tbl_name\n [CHARACTER SET charset_name]\n [ROWS IDENTIFIED BY \'\']\n [IGNORE number {LINES | ROWS}]\n [(column_or_user_var,...)]\n [SET col_name = expr,...]\n \nDescription\n----------- \nThe LOAD XML statement reads data from an XML file into a\ntable. The\nfile_name must be given as a literal string. The tagname in\nthe\noptional ROWS IDENTIFIED BY clause must also be given as a\nliteral\nstring, and must be surrounded by angle brackets (< and >).\n \nLOAD XML acts as the complement of running the mysql client\nin XML\noutput mode (that is, starting the client with the --xml\noption). To\nwrite data from a table to an XML file, use a command such\nas the\nfollowing one from the system shell:\n \nshell> mysql --xml -e \'SELECT * FROM mytable\' > file.xml\n \nTo read the file back into a table, use LOAD XML INFILE. By\ndefault,\nthe  element is considered to be the equivalent of a\ndatabase\ntable row; this can be changed using the ROWS IDENTIFIED BY\nclause.\n \nThis statement supports three different XML formats:\nColumn names as attributes and column values as attribute\nvalues:\n \nColumn names as tags and column values as the content of\nthese tags:\n \n value1\n value2\n \nColumn names are the name attributes of  tags, and values\nare\n the contents of these tags:\n \n value1\n value2\n \n This is the format used by other tools, such as mysqldump.\n \nAll 3 formats can be used in the same XML file; the import\nroutine\nautomatically detects the format for each row and interprets\nit\ncorrectly. Tags are matched based on the tag or attribute\nname and the\ncolumn name.\n \nThe following clauses work essentially the same way for LOAD\nXML as\nthey do for LOAD DATA:\nLOW_PRIORITY or CONCURRENT\nLOCAL\nREPLACE or IGNORE\nCHARACTER SET\n(column_or_user_var,...)\nSET\n \nSee LOAD DATA for more information about these clauses.\n \nThe IGNORE number LINES or IGNORE number ROWS clause causes\nthe first\nnumber rows in the XML file to be skipped. It is analogous\nto the LOAD\nDATA statement\'s IGNORE ... LINES clause.\n \nIf the LOW_PRIORITY keyword is used, insertions are delayed\nuntil no other clients are reading from the table. The\nCONCURRENT keyword allowes the use of concurrent inserts.\nThese clauses cannot be specified together.\n \nThis statement activates INSERT triggers.\n \n\n\nURL: https://mariadb.com/kb/en/library/load-xml/','','https://mariadb.com/kb/en/library/load-xml/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (428,27,'LOCK IN SHARE MODE','When LOCK IN SHARE MODE is specified in a SELECT statement,\nMariaDB will wait until all transactions that have modified\nthe rows are committed. Then, a write lock is acquired. All\ntransactions can read the rows, but if they want to modify\nthem, they have to wait until your transaction is committed.\n \nInnoDB/XtraDB supports row-level locking. selected rows can\nbe locked using LOCK IN SHARE MODE or FOR UPDATE. In both\ncases, a lock is acquired on the rows read by the query, and\nit will be released when the current transaction is\ncommitted.\n \nIf autocommit is set to 1, the LOCK IN SHARE MODE and FOR\nUPDATE clauses have no effect.\n \n\n\nURL: https://mariadb.com/kb/en/library/lock-in-share-mode/','','https://mariadb.com/kb/en/library/lock-in-share-mode/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (429,27,'Non-Recursive Common Table Expressions Overview','Common Table Expressions (CTEs) are a standard SQL feature,\nand are essentially temporary named result sets. There are\ntwo kinds of CTEs: Non-Recursive, which this article covers;\nand Recursive.\n \nCommon table expressions were introduced in MariaDB 10.2.1.\n \nNon-Recursive CTEs\n \nThe WITH keyword signifies a CTE. It is given a name,\nfollowed by a body (the main query) as follows:\n \nCTEs are similar to derived tables. For example\n \nWITH engineers AS \n ( SELECT * FROM employees\n WHERE dept = \'Engineering\' )\n \nSELECT * FROM engineers\nWHERE ...\n \nSELECT * FROM\n ( SELECT * FROM employees\n WHERE dept = \'Engineering\' ) AS engineers\nWHERE\n...\n \nA non-recursive CTE is basically a query-local VIEW. There\nare several advantages and caveats to them. The syntax is\nmore readable than nested FROM (SELECT ...).\nA CTE can refer to another and it can be referenced from\nmultiple places.\n \nA CTE referencing Another CTE\n \nUsing this format makes for a more readable SQL than a\nnested FROM(SELECT ...) clause. Below is an example of this:\n \nWITH engineers AS (\nSELECT * FROM employees\nWHERE dept IN(\'Development\',\'Support\') ),\neu_engineers AS ( SELECT * FROM engineers WHERE country\nIN(\'NL\',...) )\nSELECT\n...\nFROM eu_engineers;\n \nMultiple Uses of a CTE\n \nThis can be an \'anti-self join\', for example:\n \nWITH engineers AS (\nSELECT * FROM employees\nWHERE dept IN(\'Development\',\'Support\') )\n \nSELECT * FROM engineers E1\nWHERE NOT EXISTS\n (SELECT 1 FROM engineers E2\n WHERE E2.country=E1.country\n AND E2.name  E1.name );\n \nOr, for year-over-year comparisons, for example:\n \nWITH sales_product_year AS (\nSELECT product, YEAR(ship_date) AS year,\nSUM(price) AS total_amt\nFROM item_sales\nGROUP BY product, year )\n \nSELECT *\nFROM sales_product_year CUR,\nsales_product_year PREV,\nWHERE CUR.product=PREV.product \nAND CUR.year=PREV.year + 1 \nAND CUR.total_amt > PREV.total_amt\n \nAnother use is to compare individuals against their group.\nBelow is an example of how this might be executed:\n \nWITH sales_product_year AS (\nSELECT product,\nYEAR(ship_date) AS year,\nSUM(price) AS total_amt\nFROM item_sales\nGROUP BY product, year\n)\n \nSELECT * \nFROM sales_product_year S1\nWHERE\ntotal_amt > \n (SELECT 0.1 * SUM(total_amt)\n FROM sales_product_year S2\n WHERE S2.year = S1.year)\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/non-recursive-common-table-expressions-overview/','','https://mariadb.com/kb/en/library/non-recursive-common-table-expressions-overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (430,27,'ORDER BY','Description\n----------- \nUse the ORDER BY clause to order a resultset, such as that\nare returned from a SELECT\nstatement. You can specify just a column or use any\nexpression with functions. If you are\nusing the GROUP BY clause, you can use grouping functions in\nORDER BY.\nOrdering is done after grouping.\n \nYou can use multiple ordering expressions, separated by\ncommas. Rows will be sorted by\nthe first expression, then by the second expression if they\nhave the same value for the\nfirst, and so on.\n \nYou can use the keywords ASC and DESC after each ordering\nexpression to\nforce that ordering to be ascending or descending,\nrespectively. Ordering is ascending\nby default.\n \nYou can also use a single integer as the ordering\nexpression. If you use an integer n,\nthe results will be ordered by the nth column in the select\nexpression.\n \nWhen string values are compared, they are compared as if by\nthe STRCMP\nfunction. STRCMP ignores trailing whitespace and may\nnormalize\ncharacters and ignore case, depending on the collation in\nuse.\n \nStarting from MariaDB 5.5.35 duplicated entries in the ORDER\nBY clause are removed. MySQL 5.6 also removes duplicated\nfields.\n \nORDER BY can also be used to order the activities of a\nDELETE or UPDATE statement (usually with the LIMIT clause). \n \nUntil MariaDB 10.3.1, it was not possible to use ORDER BY\n(or LIMIT) in a multi-table UPDATE statement. This\nrestriction was lifted in MariaDB 10.3.2.\n \nExamples\n-------- \nCREATE TABLE seq (i INT, x VARCHAR(1));\nINSERT INTO seq VALUES (1,\'a\'), (2,\'b\'), (3,\'b\'),\n(4,\'f\'), (5,\'e\');\n \nSELECT * FROM seq ORDER BY i;\n \n+------+------+\n| i | x |\n+------+------+\n| 1 | a |\n| 2 | b |\n| 3 | b |\n| 4 | f |\n| 5 | e |\n+------+------+\n \nSELECT * FROM seq ORDER BY i DESC;\n \n+------+------+\n| i | x |\n+------+------+\n| 5 | e |\n| 4 | f |\n| 3 | b |\n| 2 | b |\n| 1 | a |\n+------+------+\n \nSELECT * FROM seq ORDER BY x,i;\n \n+------+------+\n| i | x |\n+------+------+\n| 1 | a |\n| 2 | b |\n| 3 | b |\n| 5 | e |\n| 4 | f |\n+------+------+\n \nORDER BY in an UPDATE statement, in conjunction with LIMIT:\n \nUPDATE seq SET x=\'z\' WHERE x=\'b\' ORDER BY i DESC LIMIT\n1;\n \nSELECT * FROM seq;\n \n+------+------+\n| i | x |\n+------+------+\n| 1 | a |\n| 2 | b |\n| 3 | z |\n| 4 | f |\n| 5 | e |\n+------+------+\n \nFrom MariaDB 10.3.2, ORDER BY can be used in a multi-table\nupdate:\n \nCREATE TABLE warehouse (product_id INT, qty INT);\nINSERT INTO warehouse VALUES\n(1,100),(2,100),(3,100),(4,100);\n \nCREATE TABLE store (product_id INT, qty INT);\nINSERT INTO store VALUES (1,5),(2,5),(3,5),(4,5);\n \nUPDATE warehouse,store SET warehouse.qty = warehouse.qty-2,\nstore.qty = store.qty+2 \n WHERE (warehouse.product_id = store.product_id AND\nstore.product_id >= 1) \n ORDER BY store.product_id DESC LIMIT 2;\n \nSELECT * FROM warehouse;\n \n+------------+------+\n| product_id | qty |\n+------------+------+\n| 1 | 100 |\n| 2 | 100 |\n| 3 | 98 |\n| 4 | 98 |\n+------------+------+\n \nSELECT * FROM store;\n \n+------------+------+\n| product_id | qty |\n+------------+------+\n| 1 | 5 |\n| 2 | 5 |\n| 3 | 7 |\n| 4 | 7 |\n+------------+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/order-by/','','https://mariadb.com/kb/en/library/order-by/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (431,27,'PROCEDURE','The PROCEDURE clause of SELECT passes the whole result set\nto a Procedure which will process it. These Procedures are\nnot Stored Procedures, and can only be written in the C\nlanguage, so it is necessary to recompile the server.\n \nCurrently, the only available procedure is ANALYSE, which\nexamines the resultset and suggests the optimal datatypes\nfor each column. It is defined in the sql/sql_analyse.cc\nfile, and can be used as an example to create more\nProcedures.\n \nThis clause cannot be used in a view\'s definition.\n \n\n\nURL: https://mariadb.com/kb/en/library/procedure/','','https://mariadb.com/kb/en/library/procedure/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (432,27,'Recursive Common Table Expressions Overview','Recursive Common Table Expressions have been supported since\nMariaDB 10.2.2.\n \nCommon Table Expressions (CTEs) are a standard SQL feature,\nand are essentially temporary named result sets. CTEs first\nappeared in the SQL standard in 1999, and the first\nimplementations began appearing in 2007.\n \nThere are two kinds of CTEs:\nNon-recursive\nRecursive, which this article covers.\n \nSQL is generally poor at recursive structures.\n \nCTEs permit a query to reference itself. A recursive CTE\nwill repeatedly execute subsets of the data until it obtains\nthe complete result set. This makes it particularly useful\nfor handing hierarchical or tree-structured data.\n \nSyntax example\n \nWITH RECURSIVE signifies a recursive CTE. It is given a\nname, followed by a body (the main query) as follows:\n \n\nComputation\n \nGiven the following structure:\n \nFirst execute the anchor part of the query:\n \nNext, execute the recursive part of the query:\n \n\n \n\nSummary so far\n \nwith recursive R as (\n select anchor_data\n union [all]\n select recursive_part\n from R, ...\n)\nselect ...\nCompute anchor_data\nCompute recursive_part to get the new data\nif (new data is non-empty) goto 2;\n \nCAST to avoid truncating data\n \nAs currently implemented by MariaDB and by the SQL Standard,\ndata may be truncated if not correctly cast. It is necessary\nto CAST the column to the correct width if the CTE\'s\nrecursive part produces wider values for a column than the\nCTE\'s nonrecursive part. Some other DBMS give an error in\nthis situation, and MariaDB\'s behavior may change in future\n- see MDEV-12325. See the examples below.\n \nExamples\n-------- \nTransitive closure - determining bus destinations\n \nSample data:\n \nCREATE TABLE bus_routes (origin varchar(50), dst\nvarchar(50));\nINSERT INTO bus_routes VALUES \n (\'New York\', \'Boston\'), \n (\'Boston\', \'New York\'), \n (\'New York\', \'Washington\'), \n (\'Washington\', \'Boston\'), \n (\'Washington\', \'Raleigh\');\n \nNow, we want to return the bus destinations with New York as\nthe origin:\n \nWITH RECURSIVE bus_dst as ( \n SELECT origin as dst FROM bus_routes WHERE origin=\'New\nYork\' \n UNION\n SELECT bus_routes.dst FROM bus_routes, bus_dst WHERE\nbus_dst.dst= bus_routes.origin \n) \nSELECT * FROM bus_dst;\n \n+------------+\n| dst |\n+------------+\n| New York |\n| Boston |\n| Washington |\n| Raleigh |\n+------------+\n \nThe above example is computed as follows:\n \nFirst, the anchor data is calculated:\nStarting from New York\nBoston and Washington are added\n \nNext, the recursive part:\nStarting from Boston and then Washington\nRaleigh is added\nUNION excludes nodes that are already present.\n \nComputing paths - determining bus routes\n \nThis time, we are trying to get bus routes such as “New\nYork -> Washington -> Raleigh”.\n \nUsing the same sample data as the previous example:\n \nWITH RECURSIVE paths (cur_path, cur_dest) AS (\n SELECT origin, origin FROM bus_routes WHERE origin=\'New\nYork\' \n UNION\n SELECT CONCAT(paths.cur_path, \',\', bus_routes.dst),\nbus_routes.dst \n FROM paths, bus_routes \n WHERE paths.cur_dest = bus_routes.origin AND \n LOCATE(bus_routes.dst, paths.cur_path)=0 \n) \nSELECT * FROM paths;\n \n+-----------------------------+------------+\n| cur_path | cur_dest |\n+-----------------------------+------------+\n| New York | New York |\n| New York,Boston | Boston |\n| New York,Washington | Washington |\n| New York,Washington,Boston | Boston |\n| New York,Washington,Raleigh | Raleigh |\n+-----------------------------+------------+\n \nCAST to avoid data truncation\n \nIn the following example, data is truncated because the\nresults are not specifically cast to a wide enough type:\n \nWITH RECURSIVE tbl AS (\n SELECT NULL AS col\n UNION\n SELECT \"THIS NEVER SHOWS UP\" AS col FROM tbl\n)\n+------+\n| col |\n+------+\n| NULL |\n| |\n+------+\n \nExplicitly use CAST to overcome this:\n \nWITH RECURSIVE tbl AS (\n SELECT CAST(NULL AS CHAR(50)) AS col\n UNION SELECT \"THIS NEVER SHOWS UP\" AS col FROM tbl\n) \nSELECT * FROM tbl;\n \n+---------------------+\n| col |\n+---------------------+\n| NULL |\n| THIS NEVER SHOWS UP |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/recursive-common-table-expressions-overview/','','https://mariadb.com/kb/en/library/recursive-common-table-expressions-overview/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (433,27,'REPLACE','Syntax\n------ \nREPLACE [LOW_PRIORITY | DELAYED]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n \nOr:\n \nREPLACE [LOW_PRIORITY | DELAYED]\n [INTO] tbl_name [PARTITION (partition_list)]\n SET col={expr | DEFAULT}, ...\n \nOr:\n \nREPLACE [LOW_PRIORITY | DELAYED]\n [INTO] tbl_name [PARTITION (partition_list)] [(col,...)]\n SELECT ...\n \nDescription\n----------- \n REPLACE works exactly like\n INSERT, except that if an old row in the table\n has the same value as a new row for a PRIMARY KEY or a\n UNIQUE index, the old row is deleted before the new row is\n inserted. If the table has more than one UNIQUE keys, it is\npossible that the new row conflicts with more than one row.\nIn this case, all conflicting rows will be deleted.\n \nThe table name can be specified in the form db_name.tbl_name\nor, if a default database is selected, in the form tbl_name\n(see Identifier Qualifiers). This allows to use REPLACE ...\nSELECT to copy rows between different databases.\n \nBasically it works like this:\n \nBEGIN;\nSELECT 1 FROM t1 WHERE key=# FOR UPDATE;\nIF found-row\n DELETE FROM t1 WHERE key=# ;\n INSERT INTO t1 VALUES (...);\nENDIF\nEND;\n \nThe above can be replaced with:\n \nREPLACE INTO t1 VALUES (...)\n \n REPLACE is a MariaDB/MySQL extension to the SQL standard.\nIt\n either inserts, or deletes and inserts. For other\nMariaDB/MySQL extensions to\n standard SQL --- that also handle duplicate values --- see\nIGNORE and INSERT ON DUPLICATE KEY UPDATE.\n \nNote that unless the table has a PRIMARY KEY or\n UNIQUE index, using a REPLACE statement\nmakes no sense. It becomes equivalent to INSERT, because\nthere is no index to be used to determine whether a new row\nduplicates another.\n \nValues for all columns are taken from the values specified\nin the\n REPLACE statement. Any missing columns are set to their\ndefault values, just as happens for INSERT. You cannot refer\nto values from the current row and use them in the new row.\nIf you use an\nassignment such as \'SET col = col + 1\', the\nreference to the column name on the right hand side is\ntreated as\n DEFAULT(col), so the assignment is equivalent to\n \'SET col = DEFAULT(col) + 1\'.\n \nTo use REPLACE, you must have both the\n INSERT and DELETE privileges\nfor the table.\n \nThere are some gotchas you should be aware of, before using\nREPLACE:\nIf there is an AUTO_INCREMENT field, a new value will be\ngenerated.\nIf there are foreign keys, ON DELETE action will be\nactivated by REPLACE.\nTriggers on DELETE and INSERT will be activated by REPLACE.\n \nTo avoid some of these behaviors, you can use INSERT ... ON\nDUPLICATE KEY UPDATE.\n \nThe PARTITION clause was introduced in MariaDB 10.0. See\nPartition Pruning and Selection for details.\n \nThis statement activates INSERT and DELETE triggers. See\nTrigger Overview for details.\n \n\n\nURL: https://mariadb.com/kb/en/library/replace/','','https://mariadb.com/kb/en/library/replace/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (434,27,'SELECT','Syntax\n------ \nSELECT\n [ALL | DISTINCT | DISTINCTROW]\n [HIGH_PRIORITY]\n [STRAIGHT_JOIN]\n [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n select_expr [, select_expr ...]\n [ FROM table_references\n [WHERE where_condition]\n [GROUP BY {col_name | expr | position} [ASC | DESC], ...\n[WITH ROLLUP]]\n [HAVING where_condition]\n [ORDER BY {col_name | expr | position} [ASC | DESC], ...]\n [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n [PROCEDURE procedure_name(argument_list)]\n [INTO OUTFILE \'file_name\' [CHARACTER SET charset_name]\n[export_options]\n \nINTO DUMPFILE \'file_name\' | INTO var_name [, var_name] ] |\n\n \n [[FOR UPDATE | LOCK IN SHARE MODE] [WAIT n | NOWAIT] ] ]\n \nexport_options:\n [{FIELDS | COLUMNS}\n [TERMINATED BY \'string\']\n [[OPTIONALLY] ENCLOSED BY \'char\']\n [ESCAPED BY \'char\']\n ]\n [LINES\n [STARTING BY \'string\']\n [TERMINATED BY \'string\']\n ]\n \nDescription\n----------- \nSELECT is used to retrieve rows selected from one or more\ntables, and can include UNION statements and subqueries.\nEach select_expr expression indicates a column or data that\nyou want to retrieve. You\nmust have at least one select expression. See Select\nExpressions below.\n \nThe FROM clause indicates the table or tables from which to\nretrieve rows.\nUse either a single table name or a JOIN expression. See\nJOIN\nfor details. If no table is involved, FROM DUAL can be\nspecified.\n \nThe PARTITION clause was introduced in MariaDB 10.0. See\nPartition Pruning and Selection for details.\nEach table can also be specified as db_name.tabl_name. Each\ncolumn can also be specified as tbl_name.col_name or even\ndb_name.tbl_name.col_name. This allows to write queries\nwhich involve multiple databases. See Identifier Qualifiers\nfor syntax details.\n \nThe WHERE clause, if given, indicates the condition or\n conditions that rows must satisfy to be selected.\n where_condition is an expression that evaluates to true for\n each row to be selected. The statement selects all rows if\nthere is no WHERE\n clause.\nIn the WHERE clause, you can use any of the functions and\n operators that MariaDB supports, except for aggregate\n(summary) functions. See Functions and Operators and\nFunctions and Modifiers for use with GROUP BY (aggregate).\n \nUse the ORDER BY clause to order the results.\n \nUse the LIMIT clause allows you to restrict the results to\nonly\na certain number of rows, optionally with an offset.\n \nUse the GROUP BY and HAVING clauses to group\nrows together when they have columns or computed values in\ncommon.\n \nSELECT can also be used to retrieve rows computed without\nreference to\nany table.\n \nSelect Expressions\n \nA SELECT statement must contain one or more select\nexpressions, separated\nby commas. Each select expression can be one of the\nfollowing:\nThe name of a column.\nAny expression using functions and operators.\n* to select all columns from all tables in the FROM clause.\ntbl_name.* to select all columns from just the table\ntbl_name.\n \nWhen specifying a column, you can either use just the column\nname or qualify the column\nname with the name of the table using tbl_name.col_name. The\nqualified form is\nuseful if you are joining multiple tables in the FROM\nclause. If you do not qualify the\ncolumn names when selecting from multiple tables, MariaDB\nwill try to find the column in\neach table. It is an error if that column name exists in\nmultiple tables.\n \nYou can quote column names using backticks. If you are\nqualifying column names\nwith table names, quote each part separately as\n`tbl_name`.`col_name`.\n \nIf you use any grouping functions\nin any of the select expressions, all rows in your results\nwill be implicitly grouped, as if\nyou had used GROUP BY NULL.\n \nDISTINCT\n \nA query may produce some identical rows. By default, all\nrows are retrieved, even when their values are the same. To\nexplicitly specify that you want to retrieve identical rows,\nuse the ALL option. If you want duplicates to be removed\nfrom the resultset, use the DISTINCT option. DISTINCTROW is\na synonym for DISTINCT. See also COUNT DISTINCT and SELECT\nUNIQUE in Oracle mode.\n \nINTO\n \nThe INTO clause is used to specify that the query results\nshould be written to a file or variable.\nSELECT INTO OUTFILE - formatting and writing the result to\nan external file.\nSELECT INTO DUMPFILE - binary-safe writing of the\nunformatted results to an external file.\nSELECT INTO Variable - selecting and setting variables.\n \nThe reverse of SELECT INTO OUTFILE is LOAD DATA.\n \nWAIT/NOWAIT\n \nSet the lock wait timeout. See WAIT and NOWAIT.\n \n\nmax_statement_time clause\n \nBy using max_statement_time in conjunction with SET\nSTATEMENT, it is possible to limit the execution time of\nindividual queries. For example:\n \nSET STATEMENT max_statement_time=100 FOR \n SELECT field1 FROM table_name ORDER BY field1;\n \n\n\nURL: https://mariadb.com/kb/en/library/select/','','https://mariadb.com/kb/en/library/select/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (435,27,'SELECT INTO DUMPFILE','Syntax\n------ \nSELECT ... INTO DUMPFILE \'file_path\'\n \nDescription\n----------- \nSELECT ... INTO DUMPFILE is a SELECT clause which writes the\nresultset into a single unformatted row, without any\nseparators, in a file. The results will not be returned to\nthe client.\n \nfile_path can be an absolute path, or a relative path\nstarting from the data directory. It can only be specified\nas a string literal, not as a variable. However, the\nstatement can be dynamically composed and executed as a\nprepared statement to work around this limitation.\n \nThis statement is binary-safe and so is particularly useful\nfor writing BLOB values to file. It can be used, for\nexample, to copy an image or an audio document from the\ndatabase to a file. SELECT ... INTO FILE can be used to save\na text file.\n \nThe file must not exist. It cannot be overwritten. A user\nneeds the FILE privilege to run this statement. Also,\nMariaDB needs permission to write files in the specified\nlocation. If the secure_file_priv system variable is set to\na non-empty directory name, the file can only be written to\nthat directory.\n \nSince MariaDB 5.1, the character_set_filesystem system\nvariable has controlled interpretation of file names that\nare given as literal strings.\n \nExample\n \nSELECT _utf8\'Hello world!\' INTO DUMPFILE \'/tmp/world\';\n \nSELECT LOAD_FILE(\'/tmp/world\') AS world;\n \n+--------------+\n| world |\n+--------------+\n| Hello world! |\n+--------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/select-into-dumpfile/','','https://mariadb.com/kb/en/library/select-into-dumpfile/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (436,27,'SELECT INTO OUTFILE','Syntax\n------ \nSELECT ... INTO OUTFILE \'file_name\'\n [CHARACTER SET charset_name]\n [export_options]\n \nexport_options:\n [{FIELDS | COLUMNS}\n [TERMINATED BY \'string\']\n [[OPTIONALLY] ENCLOSED BY \'char\']\n [ESCAPED BY \'char\']\n ]\n [LINES\n [STARTING BY \'string\']\n [TERMINATED BY \'string\']\n ]\n \nDescription\n----------- \nSELECT INTO OUTFILE writes the resulting rows to a file, and\nallows the use of column and row terminators to specify a\nparticular output format. The default is to terminate fields\nwith tabs (\\t) and lines with newlines (\\n).\n \nThe file must not exist. It cannot be overwritten. A user\nneeds the FILE privilege to run this statement. Also,\nMariaDB needs permission to write files in the specified\nlocation. If the secure_file_priv system variable is set to\na non-empty directory name, the file can only be written to\nthat directory.\n \nThe LOAD DATA INFILE statement complements SELECT INTO\nOUTFILE.\n \nCharacter-sets\n \nThe CHARACTER SET clause specifies the character set in\nwhich the results are to be written. Without the clause, no\nconversion takes place (the binary character set). In this\ncase, if there are multiple character sets, the output will\ncontain these too, and may not easily be able to be\nreloaded.\n \nIn cases where you have two servers using different\ncharacter-sets, using SELECT INTO OUTFILE to transfer data\nfrom one to the other can have unexpected results. To ensure\nthat MariaDB correctly interprets the escape sequences, use\nthe CHARACTER SET clause on both the SELECT INTO OUTFILE\nstatement and the subsequent LOAD DATA INFILE statement.\n \nExample\n \nThe following example produces a file in the CSV format:\n \nSELECT customer_id, firstname, surname INTO OUTFILE\n\'/exportdata/customers.txt\'\n FIELDS TERMINATED BY \',\' OPTIONALLY ENCLOSED BY \'\"\'\n LINES TERMINATED BY \'\\n\'\n FROM customers;\n \n\n\nURL: https://mariadb.com/kb/en/library/select-into-outfile/','','https://mariadb.com/kb/en/library/select-into-outfile/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (437,27,'SELECT WITH ROLLUP','Syntax\n------ \nSee SELECT for the full syntax.\n \nDescription\n----------- \nThe WITH ROLLUP modifier adds extra rows to the resultset\nthat represent super-aggregate summaries. The\nsuper-aggregated column is represented by a NULL value.\nMultiple aggregates over different columns will be added if\nthere are multiple GROUP BY columns.\n \nThe LIMIT clause can be used at the same time, and is\napplied after the WITH ROLLUP rows have been added.\n \nWITH ROLLUP cannot be used with ORDER BY. Some sorting is\nstill possible by using ASC or DESC clauses with the GROUP\nBY column, although the super-aggregate rows will always be\nadded last.\n \nExamples\n-------- \nThese examples use the following sample table\n \nCREATE TABLE booksales ( \n country VARCHAR(35), genre\nENUM(\'fiction\',\'non-fiction\'), year YEAR, sales INT);\n \nINSERT INTO booksales VALUES\n (\'Senegal\',\'fiction\',2014,12234),\n(\'Senegal\',\'fiction\',2015,15647),\n (\'Senegal\',\'non-fiction\',2014,64980),\n(\'Senegal\',\'non-fiction\',2015,78901),\n (\'Paraguay\',\'fiction\',2014,87970),\n(\'Paraguay\',\'fiction\',2015,76940),\n (\'Paraguay\',\'non-fiction\',2014,8760),\n(\'Paraguay\',\'non-fiction\',2015,9030);\n \nThe addition of the WITH ROLLUP modifier in this example\nadds an extra row that aggregates both years:\n \nSELECT year, SUM(sales) FROM booksales GROUP BY year;\n \n+------+------------+\n| year | SUM(sales) |\n+------+------------+\n| 2014 | 173944 |\n| 2015 | 180518 |\n+------+------------+\n2 rows in set (0.08 sec)\n \nSELECT year, SUM(sales) FROM booksales GROUP BY year WITH\nROLLUP;\n \n+------+------------+\n| year | SUM(sales) |\n+------+------------+\n| 2014 | 173944 |\n| 2015 | 180518 |\n| NULL | 354462 |\n+------+------------+\n \nIn the following example, each time the genre, the year or\nthe country change, another super-aggregate row is added:\n \nSELECT country, year, genre, SUM(sales) \n FROM booksales GROUP BY country, year, genre;\n \n+----------+------+-------------+------------+\n| country | year | genre | SUM(sales) |\n+----------+------+-------------+------------+\n| Paraguay | 2014 | fiction | 87970 |\n| Paraguay | 2014 | non-fiction | 8760 |\n| Paraguay | 2015 | fiction | 76940 |\n| Paraguay | 2015 | non-fiction | 9030 |\n| Senegal | 2014 | fiction | 12234 |\n| Senegal | 2014 | non-fiction | 64980 |\n| Senegal | 2015 | fiction | 15647 |\n| Senegal | 2015 | non-fiction | 78901 |\n+----------+------+-------------+------------+\n \nSELECT country, year, genre, SUM(sales) \n FROM booksales GROUP BY country, year, genre WITH ROLLUP;\n \n+----------+------+-------------+------------+\n| country | year | genre | SUM(sales) |\n+----------+------+-------------+------------+\n| Paraguay | 2014 | fiction | 87970 |\n| Paraguay | 2014 | non-fiction | 8760 |\n| Paraguay | 2014 | NULL | 96730 |\n| Paraguay | 2015 | fiction | 76940 |\n| Paraguay | 2015 | non-fiction | 9030 |\n| Paraguay | 2015 | NULL | 85970 |\n| Paraguay | NULL | NULL | 182700 |\n| Senegal | 2014 | fiction | 12234 |\n| Senegal | 2014 | non-fiction | 64980 |\n| Senegal | 2014 | NULL | 77214 |\n| Senegal | 2015 | fiction | 15647 |\n| Senegal | 2015 | non-fiction | 78901 |\n| Senegal | 2015 | NULL | 94548 |\n| Senegal | NULL | NULL | 171762 |\n| NULL | NULL | NULL | 354462 |\n+----------+------+-------------+------------+\n \nThe LIMIT clause, applied after WITH ROLLUP:\n \nSELECT country, year, genre, SUM(sales) \n FROM booksales GROUP BY country, year, genre WITH ROLLUP\nLIMIT 4;\n \n+----------+------+-------------+------------+\n| country | year | genre | SUM(sales) |\n+----------+------+-------------+------------+\n| Paraguay | 2014 | fiction | 87970 |\n| Paraguay | 2014 | non-fiction | 8760 |\n| Paraguay | 2014 | NULL | 96730 |\n| Paraguay | 2015 | fiction | 76940 |\n+----------+------+-------------+------------+\n \nSorting by year descending:\n \nSELECT country, year, genre, SUM(sales) \n FROM booksales GROUP BY country, year DESC, genre WITH\nROLLUP;\n \n+----------+------+-------------+------------+\n| country | year | genre | SUM(sales) |\n+----------+------+-------------+------------+\n| Paraguay | 2015 | fiction | 76940 |\n| Paraguay | 2015 | non-fiction | 9030 |\n| Paraguay | 2015 | NULL | 85970 |\n| Paraguay | 2014 | fiction | 87970 |\n| Paraguay | 2014 | non-fiction | 8760 |\n| Paraguay | 2014 | NULL | 96730 |\n| Paraguay | NULL | NULL | 182700 |\n| Senegal | 2015 | fiction | 15647 |\n| Senegal | 2015 | non-fiction | 78901 |\n| Senegal | 2015 | NULL | 94548 |\n| Senegal | 2014 | fiction | 12234 |\n| Senegal | 2014 | non-fiction | 64980 |\n| Senegal | 2014 | NULL | 77214 |\n| Senegal | NULL | NULL | 171762 |\n| NULL | NULL | NULL | 354462 |\n+----------+------+-------------+------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/select-with-rollup/','','https://mariadb.com/kb/en/library/select-with-rollup/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (438,27,'UNION','UNION is used to combine the results from multiple SELECT\nstatements into a single result set.\n \nSyntax\n------ \nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n[ORDER BY [column [, column ...]]]\n[LIMIT {[offset,] row_count | row_count OFFSET offset}]\n \nDescription\n----------- \nUNION is used to combine the results from multiple SELECT\nstatements into a single result set.\n \nThe column names from the first SELECT statement are used as\nthe column names for the results returned. Selected columns\nlisted in corresponding positions of each SELECT statement\nshould have the same data type. (For example, the first\ncolumn selected by the first statement should have the same\ntype as the first column selected by the other statements.)\n \nIf they don\'t, the type and length of the columns in the\nresult take into account the values returned by all of the\nSELECTs, so there is no need for explicit casting. Note that\ncurrently this is not the case for recursive CTEs - see\nMDEV-12325.\n \nTable names can be specified as db_name.tbl_name. This\npermits writing UNIONs which involve multiple databases. See\nIdentifier Qualifiers for syntax details.\n \nUNION queries cannot be used with aggregate functions.\n \nALL/DISTINCT\n \nThe ALL keyword causes duplicate rows to be preserved. The\nDISTINCT keyword (the default if the keyword is omitted)\ncauses duplicate rows to be removed by the results.\n \nUNION ALL and UNION DISTINCT can both be present in a query.\nIn this case, UNION DISTINCT will override any UNION ALLs to\nits left.\n \nUntil MariaDB 10.1.1, all UNION ALL statements required the\nserver to create a temporary table. Since MariaDB 10.1.1,\nthe server can in most cases execute UNION ALL without\ncreating a temporary table, improving performance (see\nMDEV-334).\n \nORDER BY and LIMIT\n \nIndividual SELECTs can contain their own ORDER BY and LIMIT\nclauses. In this case, the individual queries need to be\nwrapped between parentheses. However, this does not affect\nthe order of the UNION, so they only are useful to limit the\nrecord read by one SELECT.\n \nThe UNION can have global ORDER BY and LIMIT clauses, which\naffect the whole resultset. If the columns retrieved by\nindividual SELECT statements have an alias (AS), the ORDER\nBY must use that alias, not the real column names.\n \nHIGH_PRIORITY\n \nSpecifying a query as HIGH_PRIORITY will not work inside a\nUNION. If applied to the first SELECT, it will be ignored.\nApplying to a later SELECT results in a syntax error:\n \nERROR 1234 (42000): Incorrect usage/placement of\n\'HIGH_PRIORITY\'\n \nSELECT ... INTO ...\n \nIndividual SELECTs cannot be written INTO DUMPFILE or INTO\nOUTFILE. If the last SELECT statement specifies INTO\nDUMPFILE or INTO OUTFILE, the entire result of the UNION\nwill be written. Placing the clause after any other SELECT\nwill result in a syntax error.\n \nIf the result is a single row, SELECT ... INTO @var_name can\nalso be used.\n \n\nParentheses\n \nFrom MariaDB 10.4.0, parentheses can be used to specify\nprecedence. Before this, a syntax error would be returned.\n \nExamples\n-------- \nUNION between tables having different column names:\n \n(SELECT e_name AS name, email FROM employees)\nUNION\n(SELECT c_name AS name, email FROM customers);\n \nSpecifying the UNION\'s global order and limiting total\nrows:\n \n(SELECT name, email FROM employees)\nUNION\n(SELECT name, email FROM customers)\nORDER BY name LIMIT 10;\n \nAdding a constant row:\n \n(SELECT \'John Doe\' AS name, \'john.doe@example.net\' AS\nemail)\nUNION\n(SELECT name, email FROM customers);\n \nDiffering types:\n \nSELECT CAST(\'x\' AS CHAR(1)) UNION SELECT REPEAT(\'y\',4);\n+----------------------+\n| CAST(\'x\' AS CHAR(1)) |\n+----------------------+\n| x |\n| yyyy |\n+----------------------+\n \nReturning the results in order of each individual SELECT by\nuse of a sort column:\n \n(SELECT 1 AS sort_column, e_name AS name, email FROM\nemployees)\nUNION\n(SELECT 2, c_name AS name, email FROM customers) ORDER BY\nsort_column;\n \nDifference between UNION, EXCEPT and INTERSECT:\n \nCREATE TABLE seqs (i INT);\nINSERT INTO seqs VALUES (1),(2),(3),(4),(5),(6);\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 1 |\n| 2 |\n| 3 |\n| 4 |\n| 5 |\n| 6 |\n+------+\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 1 |\n| 2 |\n+------+\n \nSELECT i FROM seqs WHERE i =3;\n \n+------+\n| i |\n+------+\n| 3 |\n+------+\n \nParentheses for specifying precedence, from MariaDB 10.4.0\n \nCREATE OR REPLACE TABLE t1 (a INT);\nCREATE OR REPLACE TABLE t2 (b INT);\nCREATE OR REPLACE TABLE t3 (c INT);\n \nINSERT INTO t1 VALUES (1),(2),(3),(4);\nINSERT INTO t2 VALUES (5),(6);\nINSERT INTO t3 VALUES (1),(6);\n \n((SELECT a FROM t1) UNION (SELECT b FROM t2)) INTERSECT\n(SELECT c FROM t3);\n+------+\n| a |\n+------+\n| 1 |\n| 6 |\n+------+\n \n(SELECT a FROM t1) UNION ((SELECT b FROM t2) INTERSECT\n(SELECT c FROM t3));\n+------+\n| a |\n+------+\n| 1 |\n| 2 |\n| 3 |\n| 4 |\n| 6 |\n+------+\n \n\n\nURL: https://mariadb.com/kb/en/library/union/','','https://mariadb.com/kb/en/library/union/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (439,27,'UPDATE','Syntax\n------ \nSingle-table syntax:\n \nUPDATE [LOW_PRIORITY] [IGNORE] table_reference \n [PARTITION (partition_list)]\n SET col1={expr1|DEFAULT} [,col2={expr2|DEFAULT}] ...\n [WHERE where_condition]\n [ORDER BY ...]\n [LIMIT row_count]\n \nMultiple-table syntax:\n \nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n SET col1={expr1|DEFAULT} [, col2={expr2|DEFAULT}] ...\n [WHERE where_condition]\n \nDescription\n----------- \nFor the single-table syntax, the UPDATE statement updates\ncolumns of existing rows in the named table with new values.\nThe\nSET clause indicates which columns to modify and the values\nthey should be given. Each value can be given as an\nexpression, or the keyword\nDEFAULT to set a column explicitly to its default value. The\nWHERE clause, if given, specifies the conditions that\nidentify\nwhich rows to update. With no WHERE clause, all rows are\nupdated. If the ORDER BY clause is specified, the rows are\nupdated in the order that is specified. The LIMIT clause\nplaces a limit on the number of rows that can be updated.\n \nThe PARTITION clause was introduced in MariaDB 10.0. See\nPartition Pruning and Selection for details.\n \nUntil MariaDB 10.3.2, for the multiple-table syntax, UPDATE\nupdates rows in each\ntable named in table_references that satisfy the conditions.\nIn this case,\nORDER BY and LIMIT cannot be used. This restriction was\nlifted in MariaDB 10.3.2 and both clauses can be used with\nmultiple-table updates. An UPDATE can also reference tables\nwhich are located in different databases; see Identifier\nQualifiers for the syntax.\n \nwhere_condition is an expression that evaluates to true for\neach row to be updated.\n \ntable_references and where_condition are as\nspecified as described in SELECT.\n \nAssignments are evaluated in left-to-right order, unless the\nSIMULTANEOUS_ASSIGNMENT sql_mode (available from MariaDB\n10.3.5) is set, in which case the UPDATE statement evaluates\nall assignments simultaneously. \n \nYou need the UPDATE privilege only for columns referenced in\nan UPDATE that are actually updated. You need only the\nSELECT privilege for any columns that are read but\nnot modified. See GRANT.\n \nThe UPDATE statement supports the following modifiers:\nIf you use the LOW_PRIORITY keyword, execution of\n the UPDATE is delayed until no other clients are reading\nfrom\n the table. This affects only storage engines that use only\ntable-level\n locking (MyISAM, MEMORY, MERGE). See HIGH_PRIORITY and\nLOW_PRIORITY clauses for details.\nIf you use the IGNORE keyword, the update statement does \n not abort even if errors occur during the update. Rows for\nwhich\n duplicate-key conflicts occur are not updated. Rows for\nwhich columns are\n updated to values that would cause data conversion errors\nare updated to the\n closest valid values instead.\n \nUPDATE Statements With the Same Source and Target\n \nFrom MariaDB 10.3.2, UPDATE statements may have the same\nsource and target.\n \nFor example, given the following table:\n \nDROP TABLE t1;\n \nCREATE TABLE t1 (c1 INT, c2 INT);\nINSERT INTO t1 VALUES (10,10), (20,20);\n \nUntil MariaDB 10.3.1, the following UPDATE statement would\nnot work:\n \nUPDATE t1 SET c1=c1+1 WHERE c2=(SELECT MAX(c2) FROM t1);\nERROR 1093 (HY000): Table \'t1\' is specified twice, \n both as a target for \'UPDATE\' and as a separate source\nfor data\n \nFrom MariaDB 10.3.2, the statement executes successfully:\n \nUPDATE t1 SET c1=c1+1 WHERE c2=(SELECT MAX(c2) FROM t1);\n \nSELECT * FROM t1;\n \n+------+------+\n| c1 | c2 |\n+------+------+\n| 10 | 10 |\n| 21 | 20 |\n+------+------+\n \nExample\n \nSingle-table syntax:\n \nUPDATE table_name SET column1 = value1, column2 = value2\nWHERE id=100;\n \nMultiple-table syntax:\n \nUPDATE tab1, tab2 SET tab1.column1 = value1, tab1.column2 =\nvalue2 WHERE tab1.id = tab2.id;\n \n\n\nURL: https://mariadb.com/kb/en/library/update/','','https://mariadb.com/kb/en/library/update/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (440,27,'WITH','The WITH keyword signifies a Common Table Expression (CTE).\nIt allows you to refer to a subquery expression many times\nin a query, as if having a temporary table that only exists\nfor the duration of a query.\n \nThere are two kinds of CTEs:\nNon-Recursive\nRecursive\n \nCommon Table Expression WITH was introduced in MariaDB\n10.2.1.\n \nRecursive WITH has been supported since MariaDB 10.2.2.\n \nSyntax\n------ \nWITH [RECURSIVE] table_reference as (SELECT ...)\n SELECT ...\n \nYou can use table_reference as any normal table in the\nexternal SELECT part. You can also use WITH in sub queries.\nWITH can also be used with EXPLAIN and SELECT.\n \nBelow is an example with the WITH at the top level:\n \nWITH t AS (SELECT a FROM t1 WHERE b >= \'c\') \n SELECT * FROM t2, t WHERE t2.c = t.a;\n \nThe example below uses WITH in a subquery:\n \nSELECT t1.a, t1.b FROM t1, t2\n WHERE t1.a > t2.c \n AND t2.c IN(WITH t AS (SELECT * FROM t1 WHERE t1.a \n\nURL: https://mariadb.com/kb/en/library/with/','','https://mariadb.com/kb/en/library/with/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (441,28,'DESCRIBE','Syntax\n------ \n{DESCRIBE | DESC} tbl_name [col_name | wild]\n \nDescription\n----------- \nDESCRIBE provides information about the columns in a table.\nIt is a shortcut for SHOW COLUMNS FROM.\nThese statements also display information for views.\n \ncol_name can be a column name, or a string containing the\nSQL \"%\" and \"_\" wildcard characters to\nobtain output only for the columns with names matching the\nstring. There is no\nneed to enclose the string within quotes unless it contains\nspaces or other\nspecial characters.\n \nDESCRIBE city;\n \n+------------+----------+------+-----+---------+----------------+\n| Field | Type | Null | Key | Default | Extra |\n+------------+----------+------+-----+---------+----------------+\n| Id | int(11) | NO | PRI | NULL | auto_increment |\n| Name | char(35) | YES | | NULL | |\n| Country | char(3) | NO | UNI | | |\n| District | char(20) | YES | MUL | | |\n| Population | int(11) | YES | | NULL | |\n+------------+----------+------+-----+---------+----------------+\n \nThe description for SHOW COLUMNS provides\nmore information about the output columns.\n \n\n\nURL: https://mariadb.com/kb/en/library/describe/','','https://mariadb.com/kb/en/library/describe/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (442,28,'EXPLAIN','Syntax\n------ \nEXPLAIN tbl_name\n \nOr\n \nEXPLAIN [EXTENDED | PARTITIONS] \n {SELECT select_options | UPDATE update_options | DELETE\ndelete_options}\n \nDescription\n----------- \nThe EXPLAIN statement can be used either as a synonym for\nDESCRIBE or as a way to obtain information about how MariaDB\nexecutes a SELECT (as well as UPDATE and DELETE since\nMariaDB 10.0.5) statement:\n\'EXPLAIN tbl_name\' is synonymous with \n \'DESCRIBE tbl_name\' or \n \'SHOW COLUMNS FROM tbl_name\'.\nWhen you precede a SELECT statement (or, since MariaDB\n10.0.5, an UPDATE or a DELETE as well) with the keyword \n EXPLAIN, MariaDB displays information from the optimizer\n about the query execution plan. That is, MariaDB explains\nhow it would\n process the SELECT, UPDATE or DELETE, including information\nabout how tables\n are joined and in which order. EXPLAIN EXTENDED can be\n used to provide additional information.\nEXPLAIN PARTITIONS has been available since MySQL 5.1.5. It\nis useful only when examining queries involving partitioned\ntables. For details, see Partition pruning and selection.\nANALYZE statement, which performs the query as well as\nproducing EXPLAIN output, and provides actual as well as\nestimated statistics, has been available from MariaDB\n10.1.0.\nSince MariaDB 10.0.5, it has been possible to have EXPLAIN\noutput printed in the slow query log. See EXPLAIN in the\nSlow Query Log for details.\n \nSince MariaDB 10.0, SHOW EXPLAIN shows the output of a\nrunning statement. In some cases, its output can be closer\nto reality than EXPLAIN.\n \nSince MariaDB 10.1, the ANALYZE statement runs a statement\nand returns information about its execution plan. It also\nshows additional columns, to check how much the optimizer\'s\nestimation about filtering and found rows are close to\nreality.\n \nThere is an online EXPLAIN Analyzer that you can use to\nshare EXPLAIN and EXPLAIN EXTENDED output with others.\n \nEXPLAIN can acquire metadata locks in the same way that\nSELECT does, as it needs to know table metadata and,\nsometimes, data as well.\n \nThe columns in EXPLAIN ... SELECT\n \nColumn name | Description | \n \nid | Sequence number that shows in which order tables are\njoined. | \n \nselect_type | What kind of SELECT the table comes from. | \n \ntable | Alias name of table. Materialized temporary tables\nfor sub queries are named  | \n \ntype | How rows are found from the table (join type). | \n \npossible_keys | keys in table that could be used to find\nrows in the table | \n \nkey | The name of the key that is used to retrieve rows.\nNULL is no key was used. | \n \nkey_len | How many bytes of the key that was used (shows if\nwe are using only parts of the multi-column key). | \n \nref | The reference that is used to as the key value. | \n \nrows | An estimate of how many rows we will find in the\ntable for each key lookup. | \n \nExtra | Extra information about this join. | \n \nHere are descriptions of the values for some of the more\ncomplex columns in EXPLAIN ... SELECT:\n \n\"select_type\" column\n \nThe select_type column can have the following values:\n \nValue | Description | \n \nDEPENDENT SUBQUERY | The SUBQUERY is DEPENDENT. | \n \nDEPENDENT UNION | The UNION is DEPENDENT. | \n \nDERIVED | The SELECT is DERIVED from the PRIMARY. | \n \nMATERIALIZED | The SUBQUERY is MATERIALIZED. | \n \nPRIMARY | The SELECT is a PRIMARY one. | \n \nSIMPLE | The SELECT is a SIMPLE one. | \n \nSUBQUERY | The SELECT is a SUBQUERY of the PRIMARY. | \n \nUNCACHEABLE SUBQUERY | The SUBQUERY is UNCACHEABLE. | \n \nUNCACHEABLE UNION | The UNION is UNCACHEABLE. | \n \nUNION | The SELECT is a UNION of the PRIMARY. | \n \nUNION RESULT | The result of the UNION. | \n \n\"Type\" column\n \nThis column contains information on how the table is\naccessed.\n \nValue | Description | \n \nALL | A full table scan is done for the table (all rows are\nread). This is bad if the table is large and the table is\njoined against a previous table! This happens when the\noptimizer could not find any usable index to access rows. | \n \nconst | There is only one possibly matching row in the\ntable. The row is read before the optimization phase and all\ncolumns in the table are treated as constants. | \n \neq_ref | A unique index is used to find the rows. This is\nthe best possible plan to find the row. | \n \nfulltext | A fulltext index is used to access the rows. | \n \nindex_merge | A \'range\' access is done for for several\nindex and the found rows are merged. The key column shows\nwhich keys are used. | \n \nindex_subquery | This is similar as ref, but used for sub\nqueries that are transformed to key lookups. | \n \nindex | A full scan over the used index. Better than ALL but\nstill bad if index is large and the table is joined against\na previous table. | \n \nrange | The table will be accessed with a key over one or\nmore value ranges. | \n \nref_or_null | Like \'ref\' but in addition another search\nfor the \'null\' value is done if the first value was not\nfound. This happens usually with sub queries. | \n \nref | A non unique index or prefix of an unique index is\nused to find the rows. Good if the prefix doesn\'t match\nmany rows. | \n \nsystem | The table has 0 or 1 rows. | \n \nunique_subquery | This is similar as eq_ref, but used for\nsub queries that are transformed to key lookups | \n \n\"Extra\" column\n \nThis column consists of one or more of the following values,\nseparated by \';\'\n \n Note that some of these values are detected after the\noptimization phase.\n \nThe optimization phase can do the following changes to the\nWHERE clause:\nAdd the expressions from the ON and USING clauses to the\nWHERE\n clause.\nConstant propagation: If there is column=constant, replace\nall column\n instances with this constant.\nReplace all columns from \'const\' tables with their values.\nRemove the used key columns from the WHERE (as this will be\ntested as\n part of the key lookup).\nRemove impossible constant sub expressions.\n For example WHERE \'(a=1 and a=2) OR b=1\' becomes \'b=1\'.\nReplace columns with other columns that has identical\nvalues:\n Example: WHERE a=b and a=c may be treated\n as \'WHERE a=b and a=c and b=c\'.\nAdd extra conditions to detect impossible row conditions\nearlier. This\n happens mainly with OUTER JOIN where we in some cases add\ndetection\n of NULL values in the WHERE (Part of \'Not exists\'\noptimization).\n This can cause an unexpected \'Using where\' in the Extra\ncolumn.\nFor each table level we remove expressions that have already\nbeen tested when\n we read the previous row. Example: When joining tables t1\nwith t2\n using the following WHERE \'t1.a=1 and t1.a=t2.b\', we\ndon\'t have to\n test \'t1.a=1\' when checking rows in t2 as we already know\nthat this\n expression is true. \n \nValue | Description | \n \nconst row not found | The table was a system table (a table\nwith should exactly one row), but no row was found. | \n \nDistinct | If distinct optimization (remove duplicates) was\nused. This is marked only for the last table in the SELECT.\n| \n \nFull scan on NULL key | The table is a part of the sub query\nand if the value that is used to match the sub query will be\nNULL, we will do a full table scan. | \n \nImpossible HAVING | The used HAVING clause is always false\nso the SELECT will return no rows. | \n \nImpossible WHERE noticed after reading const tables. | The\nused WHERE clause is always false so the SELECT will return\nno rows. This case was detected after we had read all\n\'const\' tables and used the column values as constant in\nthe WHERE clause. For example: WHERE const_column=5 and\nconst_column had a value of 4. | \n \nImpossible WHERE | The used WHERE clause is always false so\nthe SELECT will return no rows. For example: WHERE 1=2 | \n \nNo matching min/max row | During early optimization of\nMIN()/MAX() values it was detected that no row could match\nthe WHERE clause. The MIN()/MAX() function will return NULL.\n| \n \nno matching row in const table | The table was a const table\n(a table with only one possible matching row), but no row\nwas found. | \n \nNo tables used | The SELECT was a sub query that did not use\nany tables. For example a there was no FROM clause or a FROM\nDUAL clause. | \n \nNot exists | Stop searching after more row if we find one\nsingle matching row. This optimization is used with LEFT\nJOIN where one is explicitly searching for rows that\ndoesn\'t exists in the LEFT JOIN TABLE. Example: SELECT *\nFROM t1 LEFT JOIN t2 on (...) WHERE t2.not_null_column IS\nNULL. As t2.not_null_column can only be NULL if there was no\nmatching row for on condition, we can stop searching if we\nfind a single matching row. | \n \nOpen_frm_only | For information_schema tables. Only the frm\n(table definition file was opened) was opened for each\nmatching row. | \n \nOpen_full_table | For information_schema tables. A full\ntable open for each matching row is done to retrieve the\nrequested information. (Slow) | \n \nOpen_trigger_only | For information_schema tables. Only the\ntrigger file definition was opened for each matching row. | \n \nRange checked for each record (index map: ...) | This only\nhappens when there was no good default index to use but\nthere may some index that could be used when we can treat\nall columns from previous table as constants. For each row\ncombination the optimizer will decide which index to use (if\nany) to fetch a row from this table. This is not fast, but\nfaster than a full table scan that is the only other choice.\nThe index map is a bitmask that shows which index are\nconsidered for each row condition. | \n \nScanned 0/1/all databases | For information_schema tables.\nShows how many times we had to do a directory scan. | \n \nSelect tables optimized away | All tables in the join was\noptimized away. This happens when we are only using\nCOUNT(*), MIN() and MAX() functions in the SELECT and we\nwhere able to replace all of these with constants. | \n \nSkip_open_table | For information_schema tables. The queried\ntable didn\'t need to be opened. | \n \nunique row not found | The table was detected to be a const\ntable (a table with only one possible matching row) during\nthe early optimization phase, but no row was found. | \n \nUsing filesort | Filesort is needed to resolve the query.\nThis means an extra phase where we first collect all columns\nto sort, sort them with a disk based merge sort and then use\nthe sorted set to retrieve the rows in sorted order. If the\ncolumn set is small, we store all the columns in the sort\nfile to not have to go to the database to retrieve them\nagain. | \n \nUsing index | Only the index is used to retrieve the needed\ninformation from the table. There is no need to perform an\nextra seek to retrieve the actual record. | \n \nUsing index condition | Like \'Using where\' but the where\ncondition is pushed down to the table engine for internal\noptimization at the index level. | \n \nUsing index condition(BKA) | Like \'Using index condition\'\nbut in addition we use batch key access to retrieve rows. | \n \nUsing index for group-by | The index is being used to\nresolve a GROUP BY or DISTINCT query. The rows are not read.\nThis is very efficient if the table has a lot of identical\nindex entries as duplicates are quickly jumped over. | \n \nUsing intersect(...) | For index_merge joins. Shows which\nindex are part of the intersect. | \n \nUsing join buffer | We store previous row combinations in a\nrow buffer to be able to match each row against all of the\nrows combinations in the join buffer at one go. | \n \nUsing sort_union(...) | For index_merge joins. Shows which\nindex are part of the union. | \n \nUsing temporary | A temporary table is created to hold the\nresult. This typically happens if you are using GROUP BY,\nDISTINCT or ORDER BY. | \n \nUsing where | A WHERE expression (in additional to the\npossible key lookup) is used to check if the row should be\naccepted. If you don\'t have \'Using where\' together with a\njoin type of ALL, you are probably doing something wrong! | \n \nUsing where with pushed condition | Like \'Using where\' but\nthe where condition is pushed down to the table engine for\ninternal optimization at the row level. | \n \nUsing buffer | The UPDATE statement will first buffer the\nrows, and then run the updates, rather than do updates on\nthe fly. See Using Buffer UPDATE Algorithm for a detailed\nexplanation. | \n \nEXPLAIN EXTENDED\n \nThe EXTENDED keyword adds another column, filtered, to the\noutput. This is a percentage estimate of the table rows that\nwill be filtered by the condition.\n \nAn EXPLAIN EXTENDED will always throw a warning, as it adds\nextra Message information to a subsequent SHOW WARNINGS\nstatement. This includes what the SELECT query would look\nlike after optimizing and rewriting rules are applied and\nhow the optimizer qualifies columns and tables.\n \nExamples\n-------- \nAs synonym for DESCRIBE or SHOW COLUMNS FROM:\n \nDESCRIBE city;\n \n+------------+----------+------+-----+---------+----------------+\n| Field | Type | Null | Key | Default | Extra |\n+------------+----------+------+-----+---------+----------------+\n| Id | int(11) | NO | PRI | NULL | auto_increment |\n| Name | char(35) | YES | | NULL | |\n| Country | char(3) | NO | UNI | | |\n| District | char(20) | YES | MUL | | |\n| Population | int(11) | YES | | NULL | |\n+------------+----------+------+-----+---------+----------------+\n \nA simple set of examples to see how EXPLAIN can identify\npoor index usage:\n \nCREATE TABLE IF NOT EXISTS `employees_example` (\n `id` int(11) NOT NULL AUTO_INCREMENT,\n `first_name` varchar(30) NOT NULL,\n `last_name` varchar(40) NOT NULL,\n `position` varchar(25) NOT NULL,\n `home_address` varchar(50) NOT NULL,\n `home_phone` varchar(12) NOT NULL,\n `employee_code` varchar(25) NOT NULL,\n PRIMARY KEY (`id`),\n UNIQUE KEY `employee_code` (`employee_code`),\n KEY `first_name` (`first_name`,`last_name`)\n) ENGINE=Aria;\n \nINSERT INTO `employees_example` (`first_name`, `last_name`,\n`position`, `home_address`, `home_phone`, `employee_code`)\n VALUES\n (\'Mustapha\', \'Mond\', \'Chief Executive Officer\', \'692\nPromiscuous Plaza\', \'326-555-3492\', \'MM1\'),\n (\'Henry\', \'Foster\', \'Store Manager\', \'314 Savage\nCircle\', \'326-555-3847\', \'HF1\'),\n (\'Bernard\', \'Marx\', \'Cashier\', \'1240 Ambient\nAvenue\', \'326-555-8456\', \'BM1\'),\n (\'Lenina\', \'Crowne\', \'Cashier\', \'281 Bumblepuppy\nBoulevard\', \'328-555-2349\', \'LC1\'),\n (\'Fanny\', \'Crowne\', \'Restocker\', \'1023 Bokanovsky\nLane\', \'326-555-6329\', \'FC1\'),\n (\'Helmholtz\', \'Watson\', \'Janitor\', \'944 Soma\nCourt\', \'329-555-2478\', \'HW1\');\n \nSHOW INDEXES FROM employees_example;\n \n+-------------------+------------+---------------+--------------+---------------+-----------+-------------+----------+--------+------+------------+---------+---------------+\n| Table | Non_unique | Key_name | Seq_in_index | Column_name\n| Collation | Cardinality | Sub_part | Packed | Null |\nIndex_type | Comment | Index_comment |\n+-------------------+------------+---------------+--------------+---------------+-----------+-------------+----------+--------+------+------------+---------+---------------+\n| employees_example | 0 | PRIMARY | 1 | id | A | 7 | NULL |\nNULL | | BTREE | | |\n| employees_example | 0 | employee_code | 1 | employee_code\n| A | 7 | NULL | NULL | | BTREE | | |\n| employees_example | 1 | first_name | 1 | first_name | A |\nNULL | NULL | NULL | | BTREE | | |\n| employees_example | 1 | first_name | 2 | last_name | A |\nNULL | NULL | NULL | | BTREE | | |\n+-------------------+------------+---------------+--------------+---------------+-----------+-------------+----------+--------+------+------------+---------+---------------+\n \nSELECT on a primary key:\n \nEXPLAIN SELECT * FROM employees_example WHERE id=1;\n \n+------+-------------+-------------------+-------+---------------+---------+---------+-------+------+-------+\n| id | select_type | table | type | possible_keys | key |\nkey_len | ref | rows | Extra |\n+------+-------------+-------------------+-------+---------------+---------+---------+-------+------+-------+\n| 1 | SIMPLE | employees_example | const | PRIMARY | PRIMARY\n| 4 | const | 1 | |\n+------+-------------+-------------------+-------+---------------+---------+---------+-------+------+-------+\n \nThe type is const, which means that only one possible result\ncould be returned. \nNow, returning the same record but searching by their phone\nnumber:\n \nEXPLAIN SELECT * FROM employees_example WHERE\nhome_phone=\'326-555-3492\';\n \n+------+-------------+-------------------+------+---------------+------+---------+------+------+-------------+\n| id | select_type | table | type | possible_keys | key |\nkey_len | ref | rows | Extra |\n+------+-------------+-------------------+------+---------------+------+---------+------+------+-------------+\n| 1 | SIMPLE | employees_example | ALL | NULL | NULL | NULL\n| NULL | 6 | Using where |\n+------+-------------+-------------------+------+---------------+------+---------+------+------+-------------+\n \nHere, the type is All, which means no index could be used.\nLooking at the rows count, a full table scan (all six rows)\nhad to be performed in order to retrieve the record. If\nit\'s a requirement to search by phone number, an index will\nhave to be created.\n \nSHOW EXPLAIN example:\n \nSHOW EXPLAIN FOR 1;\n \n+------+-------------+-------+-------+---------------+------+---------+------+---------+-------------+\n| id | select_type | table | type | possible_keys | key |\nkey_len | ref | rows | Extra |\n+------+-------------+-------+-------+---------------+------+---------+------+---------+-------------+\n| 1 | SIMPLE | tbl | index | NULL | a | 5 | NULL | 1000107 |\nUsing index |\n+------+-------------+-------+-------+---------------+------+---------+------+---------+-------------+\n1 row in set, 1 warning (0.00 sec)\n \nExample of ref_or_null optimization\n \nSELECT * FROM table_name\n WHERE key_column=expr OR key_column IS NULL;\n \nref_or_null is something that often happens when you use\nsubqueries with NOT IN as then one has to do an extra check\nfor NULL values if the first value didn\'t have a matching\nrow. \n \n\n\nURL: https://mariadb.com/kb/en/library/explain/','','https://mariadb.com/kb/en/library/explain/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (443,28,'EXPLAIN ANALYZE','The syntax for the EXPLAIN ANALYZE feature was changed to\nANALYZE statement, available since MariaDB 10.1.0. See\nANALYZE statement. \n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/explain-analyze/','','https://mariadb.com/kb/en/library/explain-analyze/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (444,28,'ANALYZE FORMAT=JSON','ANALYZE FORMAT=JSON is a mix of the EXPLAIN FORMAT=JSON and\nANALYZE statement features. ANALYZE FORMAT=JSON $statement\nwill execute $statement, and then print the output of\nEXPLAIN FORMAT=JSON, amended with the data from query\nexecution.\n \nBasic Execution Data\n \nYou can get the following also from tabular ANALYZE\nstatement form:\nr_rows is provided for any node that reads rows. It shows\nhow many rows were read, on average \nr_filtered is provided whenever there is a condition that is\nchecked. It shows the percentage of rows left after checking\nthe condition.\n \nAdvanced Execution Data\n \nThe most important data that is not available in tabula\nANALYZE statement are:\nr_loops field. This shows how many times the node was\nexecuted. Most query plan elements have this field.\nr_total_time_ms field. It shows how much time in total was\nspent executing this node. If the node has subnodes, their\nexecution time is included.\nr_buffer_size field. Query plan nodes that make use of\nbuffers report the size of buffer that was was used.\n \nData About Individual Query Plan Nodes\n \nfilesort node reports whether sorting was done with LIMIT n\nparameter, and how many rows were in the sort result. \nblock-nl-join node has r_loops field, which allows to tell\nwhether Using join buffer was efficient \nrange-checked-for-each-record reports counters that show the\nresult of the check. \nexpression-cache is used for subqueries, and it reports how\nmany times the cache was used, and what cache hit ratio was.\nunion_result node has r_rows so one can see how many rows\nwere produced after UNION operation\nand so forth\n \nUse Cases\n \nSee Examples of ANALYZE FORMAT=JSON.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/analyze-format-json/','','https://mariadb.com/kb/en/library/analyze-format-json/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (445,28,'ANALYZE FORMAT=JSON Examples','Example #1\n \nCustomers who have ordered more than 1M goods.\n \nANALYZE FORMAT=JSON\nSELECT CONT(*)\nFROM customer\nWHERE\n (SELECT SUM(o_totalprice) FROM orders WHERE\no_custkey=c_custkey) > 1000*1000;\n \nThe query takes 40 seconds over cold cache\n \nEXPLAIN: {\n \"query_block\": {\n \"select_id\": 1,\n \"r_loops\": 1,\n \"r_total_time_ms\": 39872,\n \"table\": {\n \"table_name\": \"customer\",\n \"access_type\": \"index\",\n \"key\": \"i_c_nationkey\",\n \"key_length\": \"5\",\n \"used_key_parts\": [\"c_nationkey\"],\n \"r_loops\": 1,\n \"rows\": 150303,\n \"r_rows\": 150000,\n \"r_total_time_ms\": 270.3,\n \"filtered\": 100,\n \"r_filtered\": 60.691,\n \"attached_condition\": \"((subquery#2) > ((1000 *\n1000)))\",\n \"using_index\": true\n },\n \"subqueries\": [\n {\n \"query_block\": {\n \"select_id\": 2,\n \"r_loops\": 150000,\n \"r_total_time_ms\": 39531,\n \"table\": {\n \"table_name\": \"orders\",\n \"access_type\": \"ref\",\n \"possible_keys\": [\"i_o_custkey\"],\n \"key\": \"i_o_custkey\",\n \"key_length\": \"5\",\n \"used_key_parts\": [\"o_custkey\"],\n \"ref\": [\"dbt3sf1.customer.c_custkey\"],\n \"r_loops\": 150000,\n \"rows\": 7,\n \"r_rows\": 10,\n \"r_total_time_ms\": 39208,\n \"filtered\": 100,\n \"r_filtered\": 100\n }\n }\n }\n ]\n }\n}\nANALYZE shows that 39.2 seconds were spent in the subquery,\nwhich was executed 150K times (for every row of outer\ntable).\n \n\n \n \n \n \n \n \n \n\nURL:\nhttps://mariadb.com/kb/en/library/analyze-formatjson-examples/','','https://mariadb.com/kb/en/library/analyze-formatjson-examples/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (446,30,'CONTAINS','Syntax\n------ \nContains(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether a geometry g1 completely\ncontains geometry g2. CONTAINS() is based on the original\nMySQL implementation and uses object bounding rectangles,\nwhile ST_CONTAINS() uses object shapes. \n \nThis tests the opposite relationship to Within().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/contains/','','https://mariadb.com/kb/en/library/contains/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (447,30,'CROSSES','Syntax\n------ \nCrosses(g1,g2)\n \nDescription\n----------- \nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is\na Polygon or a MultiPolygon, or if g2 is a\nPoint or a MultiPoint. Otherwise, returns 0.\n \nThe term spatially crosses denotes a spatial relation\nbetween two\ngiven geometries that has the following properties:\nThe two geometries intersect\nTheir intersection results in a geometry that has a\ndimension that is one\n less than the maximum dimension of the two given geometries\nTheir intersection is not equal to either of the two given\ngeometries\n \nCROSSES() is based on the original MySQL implementation, and\nuses object bounding rectangles, while ST_CROSSES() uses\nobject shapes.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/crosses/','','https://mariadb.com/kb/en/library/crosses/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (448,30,'DISJOINT','Syntax\n------ \nDisjoint(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether g1 is spatially disjoint\nfrom\n(does not intersect) g2.\n \nDISJOINT() tests the opposite relationship to INTERSECTS().\n \nDISJOINT() is based on the original MySQL implementation and\nuses object bounding rectangles, while ST_DISJOINT() uses\nobject shapes.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/disjoint/','','https://mariadb.com/kb/en/library/disjoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (449,30,'EQUALS','Syntax\n------ \nEquals(g1,g2)\n \nFrom MariaDB 10.2.3:\n \nMBREQUALS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether g1 is spatially equal to\ng2.\n \nEQUALS() is based on the original MySQL implementation and\nuses object bounding rectangles, while ST_EQUALS() uses\nobject shapes.\n \nFrom MariaDB 10.2.3, MBREQUALS is a synonym for Equals.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/equals/','','https://mariadb.com/kb/en/library/equals/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (450,30,'INTERSECTS','Syntax\n------ \nINTERSECTS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 spatially\nintersects geometry g2.\n \nINTERSECTS() is based on the original MySQL implementation\nand uses object bounding rectangles, while ST_INTERSECTS()\nuses object shapes.\n \nINTERSECTS() tests the opposite relationship to DISJOINT().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/intersects/','','https://mariadb.com/kb/en/library/intersects/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (451,30,'OVERLAPS','Syntax\n------ \nOVERLAPS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether g1 spatially overlaps g2.\nThe term spatially overlaps is used if two geometries\nintersect and their\nintersection results in a geometry of the same dimension but\nnot equal to\neither of the given geometries.\n \nOVERLAPS() is based on the original MySQL implementation and\nuses object bounding rectangles, while ST_OVERLAPS() uses\nobject shapes.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/overlaps/','','https://mariadb.com/kb/en/library/overlaps/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (452,30,'ST_CONTAINS','Syntax\n------ \nST_CONTAINS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether a geometry g1 completely\ncontains geometry g2.\n \nST_CONTAINS() uses object shapes, while CONTAINS(), based on\nthe original MySQL implementation, uses object bounding\nrectangles.\n \nST_CONTAINS tests the opposite relationship to ST_WITHIN().\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'POLYGON((175 150, 20 40, 50 60,\n125 100, 175 150))\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'POINT(174 149)\');\n \nSELECT ST_CONTAINS(@g1,@g2);\n+----------------------+\n| ST_CONTAINS(@g1,@g2) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSET @g2 = ST_GEOMFROMTEXT(\'POINT(175 151)\');\n \nSELECT ST_CONTAINS(@g1,@g2);\n+----------------------+\n| ST_CONTAINS(@g1,@g2) |\n+----------------------+\n| 0 |\n+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-contains/','','https://mariadb.com/kb/en/library/st-contains/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (453,30,'ST_CROSSES','Syntax\n------ \nST_CROSSES(g1,g2)\n \nDescription\n----------- \nReturns 1 if geometry g1 spatially crosses geometry g2.\nReturns NULL if g1 is a Polygon or a MultiPolygon, or if g2\nis a\nPoint or a MultiPoint. Otherwise, returns 0.\n \nThe term spatially crosses denotes a spatial relation\nbetween two\ngiven geometries that has the following properties:\nThe two geometries intersect\nTheir intersection results in a geometry that has a\ndimension that is one\n less than the maximum dimension of the two given geometries\nTheir intersection is not equal to either of the two given\ngeometries\n \nST_CROSSES() uses object shapes, while CROSSES(), based on\nthe original MySQL implementation, uses object bounding\nrectangles.\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'LINESTRING(174 149, 176 151)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'POLYGON((175 150, 20 40, 50 60,\n125 100, 175 150))\');\n \nSELECT ST_CROSSES(@g1,@g2);\n+---------------------+\n| ST_CROSSES(@g1,@g2) |\n+---------------------+\n| 1 |\n+---------------------+\n \nSET @g1 = ST_GEOMFROMTEXT(\'LINESTRING(176 149, 176 151)\');\n \nSELECT ST_CROSSES(@g1,@g2);\n+---------------------+\n| ST_CROSSES(@g1,@g2) |\n+---------------------+\n| 0 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-crosses/','','https://mariadb.com/kb/en/library/st-crosses/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (454,30,'ST_DIFFERENCE','Syntax\n------ \nST_DIFFERENCE(g1,g2)\n \nDescription\n----------- \nReturns a geometry representing the point set difference of\nthe given geometry values.\n \nExample\n \nSET @g1 = POINT(10,10), @g2 = POINT(20,20);\n \nSELECT ST_AsText(ST_Difference(@g1, @g2));\n+------------------------------------+\n| ST_AsText(ST_Difference(@g1, @g2)) |\n+------------------------------------+\n| POINT(10 10) |\n+------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_difference/','','https://mariadb.com/kb/en/library/st_difference/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (455,30,'ST_DISJOINT','Syntax\n------ \nST_DISJOINT(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 is spatially\ndisjoint from\n(does not intersect with) geometry g2.\n \nST_DISJOINT() uses object shapes, while DISJOINT(), based on\nthe original MySQL implementation, uses object bounding\nrectangles.\n \nST_DISJOINT() tests the opposite relationship to\nST_INTERSECTS().\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(0 0)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 0, 0 2)\');\n \nSELECT ST_DISJOINT(@g1,@g2);\n+----------------------+\n| ST_DISJOINT(@g1,@g2) |\n+----------------------+\n| 1 |\n+----------------------+\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(0 0, 0 2)\');\n \nSELECT ST_DISJOINT(@g1,@g2);\n+----------------------+\n| ST_DISJOINT(@g1,@g2) |\n+----------------------+\n| 0 |\n+----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_disjoint/','','https://mariadb.com/kb/en/library/st_disjoint/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (456,30,'ST_DISTANCE','ST_DISTANCE() was introduced in MariaDB 5.3.3.\n \nSyntax\n------ \nST_DISTANCE(g1,g2)\n \nDescription\n----------- \nReturns the distance between two geometries, or null if not\ngiven valid inputs.\n \nExample\n \nSELECT ST_Distance(POINT(1,2),POINT(2,2));\n+------------------------------------+\n| ST_Distance(POINT(1,2),POINT(2,2)) |\n+------------------------------------+\n| 1 |\n+------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_distance/','','https://mariadb.com/kb/en/library/st_distance/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (457,30,'ST_EQUALS','Syntax\n------ \nST_EQUALS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 is spatially\nequal to geometry g2.\n \nST_EQUALS() uses object shapes, while EQUALS(), based on the\noriginal MySQL implementation, uses object bounding\nrectangles.\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'LINESTRING(174 149, 176 151)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(176 151, 174 149)\');\n \nSELECT ST_EQUALS(@g1,@g2);\n+--------------------+\n| ST_EQUALS(@g1,@g2) |\n+--------------------+\n| 1 |\n+--------------------+\n \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(0 2)\');\n \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 0)\');\n \nSELECT ST_EQUALS(@g1,@g2);\n+--------------------+\n| ST_EQUALS(@g1,@g2) |\n+--------------------+\n| 0 |\n+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-equals/','','https://mariadb.com/kb/en/library/st-equals/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (458,30,'ST_INTERSECTS','Syntax\n------ \nST_INTERSECTS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 spatially\nintersects geometry g2.\n \nST_INTERSECTS() uses object shapes, while INTERSECTS(),\nbased on the original MySQL implementation, uses object\nbounding rectangles.\n \nST_INTERSECTS() tests the opposite relationship to\nST_DISJOINT().\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(0 0)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(0 0, 0 2)\');\n \nSELECT ST_INTERSECTS(@g1,@g2);\n+------------------------+\n| ST_INTERSECTS(@g1,@g2) |\n+------------------------+\n| 1 |\n+------------------------+\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 0, 0 2)\');\n \nSELECT ST_INTERSECTS(@g1,@g2);\n+------------------------+\n| ST_INTERSECTS(@g1,@g2) |\n+------------------------+\n| 0 |\n+------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-intersects/','','https://mariadb.com/kb/en/library/st-intersects/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (459,30,'ST_LENGTH','Syntax\n------ \nST_LENGTH(ls)\n \nDescription\n----------- \nReturns as a double-precision number the length of the\nLineString value ls in its associated spatial reference.\n \nExamples\n-------- \nSET @ls = \'LineString(1 1,2 2,3 3)\';\n \nSELECT ST_LENGTH(ST_GeomFromText(@ls));\n+---------------------------------+\n| ST_LENGTH(ST_GeomFromText(@ls)) |\n+---------------------------------+\n| 2.82842712474619 |\n+---------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st_length/','','https://mariadb.com/kb/en/library/st_length/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (460,30,'ST_OVERLAPS','Syntax\n------ \nST_OVERLAPS(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 spatially\noverlaps geometry g2.\n \nThe term spatially overlaps is used if two geometries\nintersect and their\nintersection results in a geometry of the same dimension but\nnot equal to\neither of the given geometries.\n \nST_OVERLAPS() uses object shapes, while OVERLAPS(), based on\nthe original MySQL implementation, uses object bounding\nrectangles.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-overlaps/','','https://mariadb.com/kb/en/library/st-overlaps/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (461,30,'ST_TOUCHES','Syntax\n------ \nST_TOUCHES(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 spatially\ntouches geometry g2. Two geometries spatially touch if the\ninteriors of the geometries do not intersect,\nbut the boundary of one of the geometries intersects either\nthe boundary or the\ninterior of the other.\n \nST_TOUCHES() uses object shapes, while TOUCHES(), based on\nthe original MySQL implementation, uses object bounding\nrectangles.\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 0)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'LINESTRING(2 0, 0 2)\');\n \nSELECT ST_TOUCHES(@g1,@g2);\n+---------------------+\n| ST_TOUCHES(@g1,@g2) |\n+---------------------+\n| 1 |\n+---------------------+\n \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(2 1)\');\n \nSELECT ST_TOUCHES(@g1,@g2);\n+---------------------+\n| ST_TOUCHES(@g1,@g2) |\n+---------------------+\n| 0 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-touches/','','https://mariadb.com/kb/en/library/st-touches/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (462,30,'ST_WITHIN','Syntax\n------ \nST_WITHIN(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether geometry g1 is spatially\nwithin geometry g2.\n \nThis tests the opposite relationship as ST_CONTAINS().\n \nST_WITHIN() uses object shapes, while WITHIN(), based on the\noriginal MySQL implementation, uses object bounding\nrectangles.\n \nExamples\n-------- \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(174 149)\');\n \nSET @g2 = ST_GEOMFROMTEXT(\'POLYGON((175 150, 20 40, 50 60,\n125 100, 175 150))\');\n \nSELECT ST_WITHIN(@g1,@g2);\n+--------------------+\n| ST_WITHIN(@g1,@g2) |\n+--------------------+\n| 1 |\n+--------------------+\n \nSET @g1 = ST_GEOMFROMTEXT(\'POINT(176 151)\');\n \nSELECT ST_WITHIN(@g1,@g2);\n+--------------------+\n| ST_WITHIN(@g1,@g2) |\n+--------------------+\n| 0 |\n+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/st-within/','','https://mariadb.com/kb/en/library/st-within/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (463,30,'TOUCHES','Syntax\n------ \nTouches(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether g1 spatially touches g2.\nTwo\ngeometries spatially touch if the interiors of the\ngeometries do not intersect,\nbut the boundary of one of the geometries intersects either\nthe boundary or the\ninterior of the other.\n \nTOUCHES() is based on the original MySQL implementation and\nuses object bounding rectangles, while ST_TOUCHES() uses\nobject shapes.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/touches/','','https://mariadb.com/kb/en/library/touches/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (464,30,'WITHIN','Syntax\n------ \nWithin(g1,g2)\n \nDescription\n----------- \nReturns 1 or 0 to indicate whether g1 is spatially within\ng2.\nThis tests the opposite relationship as Contains().\n \nWITHIN() is based on the original MySQL implementation, and\nuses object bounding rectangles, while ST_WITHIN() uses\nobject shapes.\n \nExamples\n-------- \nSET @g1 = GEOMFROMTEXT(\'POINT(174 149)\');\nSET @g2 = GEOMFROMTEXT(\'POINT(176 151)\');\nSET @g3 = GEOMFROMTEXT(\'POLYGON((175 150, 20 40, 50 60, 125\n100, 175 150))\');\n \nSELECT within(@g1,@g3);\n+-----------------+\n| within(@g1,@g3) |\n+-----------------+\n| 1 |\n+-----------------+\n \nSELECT within(@g2,@g3);\n+-----------------+\n| within(@g2,@g3) |\n+-----------------+\n| 0 |\n+-----------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/within/','','https://mariadb.com/kb/en/library/within/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (465,31,'ADDDATE','Syntax\n------ \nADDDATE(date,INTERVAL expr unit), ADDDATE(expr,days)\n \nDescription\n----------- \nWhen invoked with the INTERVAL form of the second argument,\nADDDATE()\nis a synonym for DATE_ADD(). The related function\nSUBDATE() is a synonym for DATE_SUB(). For\ninformation on the INTERVAL unit argument, see the\ndiscussion for\nDATE_ADD().\n \nWhen invoked with the days form of the second argument,\nMariaDB treats it as an\ninteger number of days to be added to expr.\n \nExamples\n-------- \nSELECT DATE_ADD(\'2008-01-02\', INTERVAL 31 DAY);\n+-----------------------------------------+\n| DATE_ADD(\'2008-01-02\', INTERVAL 31 DAY) |\n+-----------------------------------------+\n| 2008-02-02 |\n+-----------------------------------------+\n \nSELECT ADDDATE(\'2008-01-02\', INTERVAL 31 DAY);\n+----------------------------------------+\n| ADDDATE(\'2008-01-02\', INTERVAL 31 DAY) |\n+----------------------------------------+\n| 2008-02-02 |\n+----------------------------------------+\n \nSELECT ADDDATE(\'2008-01-02\', 31);\n+---------------------------+\n| ADDDATE(\'2008-01-02\', 31) |\n+---------------------------+\n| 2008-02-02 |\n+---------------------------+\n \nCREATE TABLE t1 (d DATETIME);\nINSERT INTO t1 VALUES\n (\"2007-01-30 21:31:07\"),\n (\"1983-10-15 06:42:51\"),\n (\"2011-04-21 12:34:56\"),\n (\"2011-10-30 06:31:41\"),\n (\"2011-01-30 14:03:25\"),\n (\"2004-10-07 11:19:34\");\n \nSELECT d, ADDDATE(d, 10) from t1;\n \n+---------------------+---------------------+\n| d | ADDDATE(d, 10) |\n+---------------------+---------------------+\n| 2007-01-30 21:31:07 | 2007-02-09 21:31:07 |\n| 1983-10-15 06:42:51 | 1983-10-25 06:42:51 |\n| 2011-04-21 12:34:56 | 2011-05-01 12:34:56 |\n| 2011-10-30 06:31:41 | 2011-11-09 06:31:41 |\n| 2011-01-30 14:03:25 | 2011-02-09 14:03:25 |\n| 2004-10-07 11:19:34 | 2004-10-17 11:19:34 |\n+---------------------+---------------------+\n \nSELECT d, ADDDATE(d, INTERVAL 10 HOUR) from t1;\n \n+---------------------+------------------------------+\n| d | ADDDATE(d, INTERVAL 10 HOUR) |\n+---------------------+------------------------------+\n| 2007-01-30 21:31:07 | 2007-01-31 07:31:07 |\n| 1983-10-15 06:42:51 | 1983-10-15 16:42:51 |\n| 2011-04-21 12:34:56 | 2011-04-21 22:34:56 |\n| 2011-10-30 06:31:41 | 2011-10-30 16:31:41 |\n| 2011-01-30 14:03:25 | 2011-01-31 00:03:25 |\n| 2004-10-07 11:19:34 | 2004-10-07 21:19:34 |\n+---------------------+------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/adddate/','','https://mariadb.com/kb/en/library/adddate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (466,31,'ADDTIME','Syntax\n------ \nADDTIME(expr1,expr2)\n \nDescription\n----------- \nADDTIME() adds expr2 to expr1 and returns the result. expr1\nis a time\nor datetime expression, and expr2 is a time expression.\n \nExamples\n-------- \nSELECT ADDTIME(\'2007-12-31 23:59:59.999999\', \'1\n1:1:1.000002\');\n+---------------------------------------------------------+\n| ADDTIME(\'2007-12-31 23:59:59.999999\', \'1\n1:1:1.000002\') |\n+---------------------------------------------------------+\n| 2008-01-02 01:01:01.000001 |\n+---------------------------------------------------------+\n \nSELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n+-----------------------------------------------+\n| ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\') |\n+-----------------------------------------------+\n| 03:00:01.999997 |\n+-----------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/addtime/','','https://mariadb.com/kb/en/library/addtime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (467,31,'CONVERT_TZ','Syntax\n------ \nCONVERT_TZ(dt,from_tz,to_tz)\n \nDescription\n----------- \nCONVERT_TZ() converts a datetime value dt from the time zone\ngiven by from_tz to the time zone given by to_tz and returns\nthe resulting value.\n \nIn order to use named time zones, such as GMT, MET or\nAfrica/Johannesburg, the time_zone tables must be loaded\n(see mysql_tzinfo_to_sql).\n \nNo conversion will take place if the value falls outside of\nthe supported TIMESTAMP range (\'1970-01-01 00:00:01\' to\n\'2038-01-19 05:14:07\' UTC) when converted from from_tz to\nUTC.\n \nThis function returns NULL if the arguments are invalid (or\nnamed time zones have not been loaded).\n \nSee time zones for more information.\n \nExamples\n-------- \nSELECT CONVERT_TZ(\'2016-01-01\n12:00:00\',\'+00:00\',\'+10:00\');\n+-----------------------------------------------------+\n| CONVERT_TZ(\'2016-01-01 12:00:00\',\'+00:00\',\'+10:00\')\n|\n+-----------------------------------------------------+\n| 2016-01-01 22:00:00 |\n+-----------------------------------------------------+\n \nUsing named time zones (with the time zone tables loaded):\n \nSELECT CONVERT_TZ(\'2016-01-01\n12:00:00\',\'GMT\',\'Africa/Johannesburg\');\n+---------------------------------------------------------------+\n| CONVERT_TZ(\'2016-01-01\n12:00:00\',\'GMT\',\'Africa/Johannesburg\') |\n+---------------------------------------------------------------+\n| 2016-01-01 14:00:00 |\n+---------------------------------------------------------------+\n \nThe value is out of the TIMESTAMP range, so no conversion\ntakes place:\n \nSELECT CONVERT_TZ(\'1969-12-31\n22:00:00\',\'+00:00\',\'+10:00\');\n+-----------------------------------------------------+\n| CONVERT_TZ(\'1969-12-31 22:00:00\',\'+00:00\',\'+10:00\')\n|\n+-----------------------------------------------------+\n| 1969-12-31 22:00:00 |\n+-----------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/convert_tz/','','https://mariadb.com/kb/en/library/convert_tz/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (468,31,'CURDATE','Syntax\n------ \nCURDATE()\n \nDescription\n----------- \nReturns the current date as a value in \'YYYY-MM-DD\' or\nYYYYMMDD\nformat, depending on whether the function is used in a\nstring or\nnumeric context.\n \nExamples\n-------- \nSELECT CURDATE();\n+------------+\n| CURDATE() |\n+------------+\n| 2019-03-05 |\n+------------+\n \nIn a numeric context (note this is not performing date\ncalculations):\n \nSELECT CURDATE() +0;\n \n+--------------+\n| CURDATE() +0 |\n+--------------+\n| 20190305 |\n+--------------+\n \nData calculation:\n \nSELECT CURDATE() - INTERVAL 5 DAY;\n \n+----------------------------+\n| CURDATE() - INTERVAL 5 DAY |\n+----------------------------+\n| 2019-02-28 |\n+----------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/curdate/','','https://mariadb.com/kb/en/library/curdate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (469,31,'CURRENT_DATE','Syntax\n------ \nCURRENT_DATE, CURRENT_DATE()\n \nDescription\n----------- \nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/current_date/','','https://mariadb.com/kb/en/library/current_date/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (470,31,'CURRENT_TIME','Syntax\n------ \nCURRENT_TIME\nCURRENT_TIME([precision])\n \nDescription\n----------- \nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n \n\n\nURL: https://mariadb.com/kb/en/library/current_time/','','https://mariadb.com/kb/en/library/current_time/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (471,31,'CURRENT_TIMESTAMP','Syntax\n------ \nCURRENT_TIMESTAMP\nCURRENT_TIMESTAMP([precision])\n \nDescription\n----------- \nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for\nNOW().\n \n\n\nURL: https://mariadb.com/kb/en/library/current_timestamp/','','https://mariadb.com/kb/en/library/current_timestamp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (472,31,'CURTIME','Syntax\n------ \nCURTIME([precision])\n \nDescription\n----------- \nReturns the current time as a value in \'HH:MM:SS\' or\nHHMMSS.uuuuuu format, depending on whether the function is\nused in a string or numeric context. The value is expressed\nin the current time zone.\n \nThe optional precision determines the microsecond precision.\nSee Microseconds in MariaDB.\n \nExamples\n-------- \nSELECT CURTIME();\n+-----------+\n| CURTIME() |\n+-----------+\n| 12:45:39 |\n+-----------+\n \nSELECT CURTIME() + 0;\n \n+---------------+\n| CURTIME() + 0 |\n+---------------+\n| 124545.000000 |\n+---------------+\n \nWith precision:\n \nSELECT CURTIME(2);\n+-------------+\n| CURTIME(2) |\n+-------------+\n| 09:49:08.09 |\n+-------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/curtime/','','https://mariadb.com/kb/en/library/curtime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (473,31,'DATE FUNCTION','Syntax\n------ \nDATE(expr)\n \nDescription\n----------- \nExtracts the date part of the date or datetime expression\nexpr.\n \nExamples\n-------- \nSELECT DATE(\'2013-07-18 12:21:32\');\n+-----------------------------+\n| DATE(\'2013-07-18 12:21:32\') |\n+-----------------------------+\n| 2013-07-18 |\n+-----------------------------+\n \nError Handling\n \nUntil MariaDB 5.5.32, some versions of MariaDB returned\n0000-00-00 when passed an invalid date. From 5.5.32, NULL is\nreturned.\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/date-function/','','https://mariadb.com/kb/en/library/date-function/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (474,31,'DATEDIFF','Syntax\n------ \nDATEDIFF(expr1,expr2)\n \nDescription\n----------- \nDATEDIFF() returns (expr1 – expr2) expressed\nas a value in days from one date to the other. expr1 and\nexpr2 are date\nor date-and-time expressions. Only the date parts of the\nvalues are used in the\ncalculation.\n \nExamples\n-------- \nSELECT DATEDIFF(\'2007-12-31 23:59:59\',\'2007-12-30\');\n+----------------------------------------------+\n| DATEDIFF(\'2007-12-31 23:59:59\',\'2007-12-30\') |\n+----------------------------------------------+\n| 1 |\n+----------------------------------------------+\n \nSELECT DATEDIFF(\'2010-11-30 23:59:59\',\'2010-12-31\');\n+----------------------------------------------+\n| DATEDIFF(\'2010-11-30 23:59:59\',\'2010-12-31\') |\n+----------------------------------------------+\n| -31 |\n+----------------------------------------------+\n \nCREATE TABLE t1 (d DATETIME);\nINSERT INTO t1 VALUES\n (\"2007-01-30 21:31:07\"),\n (\"1983-10-15 06:42:51\"),\n (\"2011-04-21 12:34:56\"),\n (\"2011-10-30 06:31:41\"),\n (\"2011-01-30 14:03:25\"),\n (\"2004-10-07 11:19:34\");\n \nSELECT NOW();\n+---------------------+\n| NOW() |\n+---------------------+\n| 2011-05-23 10:56:05 |\n+---------------------+\n \nSELECT d, DATEDIFF(NOW(),d) FROM t1;\n \n+---------------------+-------------------+\n| d | DATEDIFF(NOW(),d) |\n+---------------------+-------------------+\n| 2007-01-30 21:31:07 | 1574 |\n| 1983-10-15 06:42:51 | 10082 |\n| 2011-04-21 12:34:56 | 32 |\n| 2011-10-30 06:31:41 | -160 |\n| 2011-01-30 14:03:25 | 113 |\n| 2004-10-07 11:19:34 | 2419 |\n+---------------------+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/datediff/','','https://mariadb.com/kb/en/library/datediff/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (475,31,'DATE_ADD','Syntax\n------ \nDATE_ADD(date,INTERVAL expr unit)\n \nDescription\n----------- \nPerforms date arithmetic. The date argument specifies the\nstarting date or datetime value. expr is an expression\nspecifying the\ninterval value to be added or subtracted from the starting\ndate. expr is a\nstring; it may start with a \"-\" for negative intervals.\nunit is a\nkeyword indicating the units in which the expression should\nbe interpreted. See Date and Time Units for a complete list\nof permitted units. \n \nSee also DATE_SUB().\n \nExamples\n-------- \nSELECT \'2008-12-31 23:59:59\' + INTERVAL 1 SECOND;\n \n+-------------------------------------------+\n| \'2008-12-31 23:59:59\' + INTERVAL 1 SECOND |\n+-------------------------------------------+\n| 2009-01-01 00:00:00 |\n+-------------------------------------------+\n \nSELECT INTERVAL 1 DAY + \'2008-12-31\';\n \n+-------------------------------+\n| INTERVAL 1 DAY + \'2008-12-31\' |\n+-------------------------------+\n| 2009-01-01 |\n+-------------------------------+\n \nSELECT \'2005-01-01\' - INTERVAL 1 SECOND;\n \n+----------------------------------+\n| \'2005-01-01\' - INTERVAL 1 SECOND |\n+----------------------------------+\n| 2004-12-31 23:59:59 |\n+----------------------------------+\n \nSELECT DATE_ADD(\'2000-12-31 23:59:59\', INTERVAL 1 SECOND);\n+----------------------------------------------------+\n| DATE_ADD(\'2000-12-31 23:59:59\', INTERVAL 1 SECOND) |\n+----------------------------------------------------+\n| 2001-01-01 00:00:00 |\n+----------------------------------------------------+\n \nSELECT DATE_ADD(\'2010-12-31 23:59:59\', INTERVAL 1 DAY);\n+-------------------------------------------------+\n| DATE_ADD(\'2010-12-31 23:59:59\', INTERVAL 1 DAY) |\n+-------------------------------------------------+\n| 2011-01-01 23:59:59 |\n+-------------------------------------------------+\n \nSELECT DATE_ADD(\'2100-12-31 23:59:59\', INTERVAL \'1:1\'\nMINUTE_SECOND);\n+---------------------------------------------------------------+\n| DATE_ADD(\'2100-12-31 23:59:59\', INTERVAL \'1:1\'\nMINUTE_SECOND) |\n+---------------------------------------------------------------+\n| 2101-01-01 00:01:00 |\n+---------------------------------------------------------------+\n \nSELECT DATE_ADD(\'1900-01-01 00:00:00\', INTERVAL \'-1 10\'\nDAY_HOUR);\n+------------------------------------------------------------+\n| DATE_ADD(\'1900-01-01 00:00:00\', INTERVAL \'-1 10\'\nDAY_HOUR) |\n+------------------------------------------------------------+\n| 1899-12-30 14:00:00 |\n+------------------------------------------------------------+\n \nSELECT DATE_ADD(\'1992-12-31 23:59:59.000002\', INTERVAL\n\'1.999999\' SECOND_MICROSECOND);\n+--------------------------------------------------------------------------------+\n| DATE_ADD(\'1992-12-31 23:59:59.000002\', INTERVAL\n\'1.999999\' SECOND_MICROSECOND) |\n+--------------------------------------------------------------------------------+\n| 1993-01-01 00:00:01.000001 |\n+--------------------------------------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/date_add/','','https://mariadb.com/kb/en/library/date_add/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (476,31,'DATE_FORMAT','Syntax\n------ \nDATE_FORMAT(date, format[, locale])\n \nDescription\n----------- \nFormats the date value according to the format string. \n \nThe language used for the names is controlled by the value\nof the lc_time_names system variable. See server locale for\nmore on the supported locales.\n \nThe options that can be used by DATE_FORMAT(), as well as\nits inverse STR_TO_DATE() and the FROM_UNIXTIME() function,\nare:\n \nOption | Description | \n \n%a | Short weekday name in current locale (Variable\nlc_time_names). | \n \n%b | Short form month name in current locale. For locale\nen_US this is one of:\nJan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov or Dec. | \n \n%c | Month with 1 or 2 digits. | \n \n%D | Day with English suffix \'th\', \'nd\', \'st\' or\n\'rd\'\'. (1st, 2nd, 3rd...). | \n \n%d | Day with 2 digits. | \n \n%e | Day with 1 or 2 digits. | \n \n%f | Sub seconds 6 digits. | \n \n%H | Hour with 2 digits between 00-23. | \n \n%h | Hour with 2 digits between 01-12. | \n \n%I | Hour with 2 digits between 01-12. | \n \n%i | Minute with 2 digits. | \n \n%j | Day of the year (001-366) | \n \n%k | Hour with 1 digits between 0-23. | \n \n%l | Hour with 1 digits between 1-12. | \n \n%M | Full month name in current locale (Variable\nlc_time_names). | \n \n%m | Month with 2 digits. | \n \n%p | AM/PM according to current locale (Variable\nlc_time_names). | \n \n%r | Time in 12 hour format, followed by AM/PM. Short for\n\'%I:%i:%S %p\'. | \n \n%S | Seconds with 2 digits. | \n \n%s | Seconds with 2 digits. | \n \n%T | Time in 24 hour format. Short for \'%H:%i:%S\'. | \n \n%U | Week number (00-53), when first day of the week is\nSunday. | \n \n%u | Week number (00-53), when first day of the week is\nMonday. | \n \n%V | Week number (01-53), when first day of the week is\nSunday. Used with %X. | \n \n%v | Week number (01-53), when first day of the week is\nMonday. Used with %x. | \n \n%W | Full weekday name in current locale (Variable\nlc_time_names). | \n \n%w | Day of the week. 0 = Sunday, 6 = Saturday. | \n \n%X | Year with 4 digits when first day of the week is\nSunday. Used with %V. | \n \n%x | Year with 4 digits when first day of the week is\nMonday. Used with %v. | \n \n%Y | Year with 4 digits. | \n \n%y | Year with 2 digits. | \n \n%# | For str_to_date(), skip all numbers. | \n \n%. | For str_to_date(), skip all punctation characters. | \n \n%@ | For str_to_date(), skip all alpha characters. | \n \n%% | A literal % character. | \n \nTo get a date in one of the standard formats, GET_FORMAT()\ncan be used.\n \nExamples\n-------- \nSELECT DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\');\n+------------------------------------------------+\n| DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\') |\n+------------------------------------------------+\n| Sunday October 2009 |\n+------------------------------------------------+\n \nSELECT DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\');\n+------------------------------------------------+\n| DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\') |\n+------------------------------------------------+\n| 22:23:00 |\n+------------------------------------------------+\n \nSELECT DATE_FORMAT(\'1900-10-04 22:23:00\', \'%D %y %a %d %m\n%b %j\');\n+------------------------------------------------------------+\n| DATE_FORMAT(\'1900-10-04 22:23:00\', \'%D %y %a %d %m %b\n%j\') |\n+------------------------------------------------------------+\n| 4th 00 Thu 04 10 Oct 277 |\n+------------------------------------------------------------+\n \nSELECT DATE_FORMAT(\'1997-10-04 22:23:00\', \'%H %k %I %r %T\n%S %w\');\n+------------------------------------------------------------+\n| DATE_FORMAT(\'1997-10-04 22:23:00\', \'%H %k %I %r %T %S\n%w\') |\n+------------------------------------------------------------+\n| 22 22 10 10:23:00 PM 22:23:00 00 6 |\n+------------------------------------------------------------+\n \nSELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n+------------------------------------+\n| DATE_FORMAT(\'1999-01-01\', \'%X %V\') |\n+------------------------------------+\n| 1998 52 |\n+------------------------------------+\n \nSELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n+---------------------------------+\n| DATE_FORMAT(\'2006-06-00\', \'%d\') |\n+---------------------------------+\n| 00 |\n+---------------------------------+\n \nOptionally, the locale can be explicitly specified as the\nthird DATE_FORMAT() argument. Doing so makes the function\nindependent from the session settings, and the three\nargument version of DATE_FORMAT() can be used in virtual\nindexed and persistent generated-columns:\n \nSELECT DATE_FORMAT(\'2006-01-01\', \'%W\', \'el_GR\');\n+------------------------------------------+\n| DATE_FORMAT(\'2006-01-01\', \'%W\', \'el_GR\') |\n+------------------------------------------+\n| Κυριακή |\n+------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/date_format/','','https://mariadb.com/kb/en/library/date_format/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (477,31,'DATE_SUB','Syntax\n------ \nDATE_SUB(date,INTERVAL expr unit)\n \nDescription\n----------- \nPerforms date arithmetic. The date argument specifies the\nstarting date or datetime value. expr is an expression\nspecifying the\ninterval value to be added or subtracted from the starting\ndate. expr is a\nstring; it may start with a \"-\" for negative intervals.\nunit is a\nkeyword indicating the units in which the expression should\nbe interpreted. See Date and Time Units for a complete list\nof permitted units. \n \nSee also DATE_ADD().\n \nExamples\n-------- \nSELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n+-----------------------------------------+\n| DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY) |\n+-----------------------------------------+\n| 1997-12-02 |\n+-----------------------------------------+\n \nSELECT DATE_SUB(\'2005-01-01 00:00:00\', INTERVAL \'1\n1:1:1\' DAY_SECOND);\n+----------------------------------------------------------------+\n| DATE_SUB(\'2005-01-01 00:00:00\', INTERVAL \'1 1:1:1\'\nDAY_SECOND) |\n+----------------------------------------------------------------+\n| 2004-12-30 22:58:59 |\n+----------------------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/date_sub/','','https://mariadb.com/kb/en/library/date_sub/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (478,31,'DAY','Syntax\n------ \nDAY(date)\n \nDescription\n----------- \nDAY() is a synonym for DAYOFMONTH().\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/day/','','https://mariadb.com/kb/en/library/day/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (479,31,'DAYNAME','Syntax\n------ \nDAYNAME(date)\n \nDescription\n----------- \nReturns the name of the weekday for date. The language used\nfor the name is controlled by the value\nof the lc_time_names system variable. See server locale for\nmore on the supported locales.\n \nExamples\n-------- \nSELECT DAYNAME(\'2007-02-03\');\n+-----------------------+\n| DAYNAME(\'2007-02-03\') |\n+-----------------------+\n| Saturday |\n+-----------------------+\n \nCREATE TABLE t1 (d DATETIME);\nINSERT INTO t1 VALUES\n (\"2007-01-30 21:31:07\"),\n (\"1983-10-15 06:42:51\"),\n (\"2011-04-21 12:34:56\"),\n (\"2011-10-30 06:31:41\"),\n (\"2011-01-30 14:03:25\"),\n (\"2004-10-07 11:19:34\");\n \nSELECT d, DAYNAME(d) FROM t1;\n \n+---------------------+------------+\n| d | DAYNAME(d) |\n+---------------------+------------+\n| 2007-01-30 21:31:07 | Tuesday |\n| 1983-10-15 06:42:51 | Saturday |\n| 2011-04-21 12:34:56 | Thursday |\n| 2011-10-30 06:31:41 | Sunday |\n| 2011-01-30 14:03:25 | Sunday |\n| 2004-10-07 11:19:34 | Thursday |\n+---------------------+------------+\n \nChanging the locale:\n \nSET lc_time_names = \'fr_CA\';\n \nSELECT DAYNAME(\'2013-04-01\');\n+-----------------------+\n| DAYNAME(\'2013-04-01\') |\n+-----------------------+\n| lundi |\n+-----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/dayname/','','https://mariadb.com/kb/en/library/dayname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (480,31,'DAYOFMONTH','Syntax\n------ \nDAYOFMONTH(date)\n \nDescription\n----------- \nReturns the day of the month for date, in the range 1 to 31,\nor 0\nfor dates such as \'0000-00-00\' or \'2008-00-00\' which\nhave a zero day\npart.\n \nDAY() is a synonym.\n \nExamples\n-------- \nSELECT DAYOFMONTH(\'2007-02-03\');\n+--------------------------+\n| DAYOFMONTH(\'2007-02-03\') |\n+--------------------------+\n| 3 |\n+--------------------------+\n \nCREATE TABLE t1 (d DATETIME);\nINSERT INTO t1 VALUES\n (\"2007-01-30 21:31:07\"),\n (\"1983-10-15 06:42:51\"),\n (\"2011-04-21 12:34:56\"),\n (\"2011-10-30 06:31:41\"),\n (\"2011-01-30 14:03:25\"),\n (\"2004-10-07 11:19:34\");\n \nSELECT d FROM t1 where DAYOFMONTH(d) = 30;\n \n+---------------------+\n| d |\n+---------------------+\n| 2007-01-30 21:31:07 |\n| 2011-10-30 06:31:41 |\n| 2011-01-30 14:03:25 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/dayofmonth/','','https://mariadb.com/kb/en/library/dayofmonth/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (481,31,'DAYOFWEEK','Syntax\n------ \nDAYOFWEEK(date)\n \nDescription\n----------- \nReturns the day of the week index for the date (1 = Sunday,\n2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC\nstandard.\n \nThis contrasts with WEEKDAY() which follows a different\nindex numbering\n(0 = Monday, 1 = Tuesday, ... 6 = Sunday).\n \nExamples\n-------- \nSELECT DAYOFWEEK(\'2007-02-03\');\n+-------------------------+\n| DAYOFWEEK(\'2007-02-03\') |\n+-------------------------+\n| 7 |\n+-------------------------+\n \nCREATE TABLE t1 (d DATETIME);\nINSERT INTO t1 VALUES\n (\"2007-01-30 21:31:07\"),\n (\"1983-10-15 06:42:51\"),\n (\"2011-04-21 12:34:56\"),\n (\"2011-10-30 06:31:41\"),\n (\"2011-01-30 14:03:25\"),\n (\"2004-10-07 11:19:34\");\n \nSELECT d, DAYNAME(d), DAYOFWEEK(d), WEEKDAY(d) from t1;\n \n+---------------------+------------+--------------+------------+\n| d | DAYNAME(d) | DAYOFWEEK(d) | WEEKDAY(d) |\n+---------------------+------------+--------------+------------+\n| 2007-01-30 21:31:07 | Tuesday | 3 | 1 |\n| 1983-10-15 06:42:51 | Saturday | 7 | 5 |\n| 2011-04-21 12:34:56 | Thursday | 5 | 3 |\n| 2011-10-30 06:31:41 | Sunday | 1 | 6 |\n| 2011-01-30 14:03:25 | Sunday | 1 | 6 |\n| 2004-10-07 11:19:34 | Thursday | 5 | 3 |\n+---------------------+------------+--------------+------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/dayofweek/','','https://mariadb.com/kb/en/library/dayofweek/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (482,31,'DAYOFYEAR','Syntax\n------ \nDAYOFYEAR(date)\n \nDescription\n----------- \nReturns the day of the year for date, in the range 1 to 366.\n \nExamples\n-------- \nSELECT DAYOFYEAR(\'2018-02-16\');\n+-------------------------+\n| DAYOFYEAR(\'2018-02-16\') |\n+-------------------------+\n| 47 |\n+-------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/dayofyear/','','https://mariadb.com/kb/en/library/dayofyear/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (483,31,'EXTRACT','Syntax\n------ \nEXTRACT(unit FROM date)\n \nDescription\n----------- \nThe EXTRACT() function extracts the required unit from the\ndate. See Date and Time Units for a complete list of\npermitted units.\n \nIn MariaDB 10.0.7 and MariaDB 5.5.35, EXTRACT (HOUR FROM\n...) was changed to return a value from 0 to 23, adhering to\nthe SQL standard. Until MariaDB 10.0.6 and MariaDB 5.5.34,\nand in all versions of MySQL at least as of MySQL 5.7, it\ncould return a value > 23. HOUR() is not a standard\nfunction, so continues to adhere to the old behaviour\ninherited from MySQL.\n \nExamples\n-------- \nSELECT EXTRACT(YEAR FROM \'2009-07-02\');\n+---------------------------------+\n| EXTRACT(YEAR FROM \'2009-07-02\') |\n+---------------------------------+\n| 2009 |\n+---------------------------------+\n \nSELECT EXTRACT(YEAR_MONTH FROM \'2009-07-02 01:02:03\');\n+------------------------------------------------+\n| EXTRACT(YEAR_MONTH FROM \'2009-07-02 01:02:03\') |\n+------------------------------------------------+\n| 200907 |\n+------------------------------------------------+\n \nSELECT EXTRACT(DAY_MINUTE FROM \'2009-07-02 01:02:03\');\n+------------------------------------------------+\n| EXTRACT(DAY_MINUTE FROM \'2009-07-02 01:02:03\') |\n+------------------------------------------------+\n| 20102 |\n+------------------------------------------------+\n \nSELECT EXTRACT(MICROSECOND FROM \'2003-01-02\n10:30:00.000123\');\n+--------------------------------------------------------+\n| EXTRACT(MICROSECOND FROM \'2003-01-02 10:30:00.000123\') |\n+--------------------------------------------------------+\n| 123 |\n+--------------------------------------------------------+\n \nFrom MariaDB 10.0.7 and MariaDB 5.5.35, EXTRACT (HOUR\nFROM...) returns a value from 0 to 23, as per the SQL\nstandard. HOUR is not a standard function, so continues to\nadhere to the old behaviour inherited from MySQL.\n \nSELECT EXTRACT(HOUR FROM \'26:30:00\'), HOUR(\'26:30:00\');\n+-------------------------------+------------------+\n| EXTRACT(HOUR FROM \'26:30:00\') | HOUR(\'26:30:00\') |\n+-------------------------------+------------------+\n| 2 | 26 |\n+-------------------------------+------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/extract/','','https://mariadb.com/kb/en/library/extract/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (484,31,'FROM_DAYS','Syntax\n------ \nFROM_DAYS(N)\n \nDescription\n----------- \nGiven a day number N, returns a DATE value. The day count is\nbased on the number of days from the start of the standard\ncalendar (0000-00-00). \n \nThe function is not designed for use with dates before the\nadvent of the Gregorian calendar in October 1582. Results\nwill not be reliable since it doesn\'t account for the lost\ndays when the calendar changed from the Julian calendar.\n \nThis is the converse of the TO_DAYS() function.\n \nExamples\n-------- \nSELECT FROM_DAYS(730669);\n+-------------------+\n| FROM_DAYS(730669) |\n+-------------------+\n| 2000-07-03 |\n+-------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/from_days/','','https://mariadb.com/kb/en/library/from_days/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (485,31,'FROM_UNIXTIME','Syntax\n------ \nFROM_UNIXTIME(unix_timestamp),\nFROM_UNIXTIME(unix_timestamp,format)\n \nDescription\n----------- \nReturns a representation of the unix_timestamp argument as a\nvalue in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS.uuuuuu format,\ndepending on\nwhether the function is used in a string or numeric context.\nThe value\nis expressed in the current time zone. unix_timestamp is an\ninternal\ntimestamp value such as is produced by the UNIX_TIMESTAMP()\nfunction.\n \nIf format is given, the result is formatted according to the\nformat\nstring, which is used the same way as listed in the entry\nfor the\nDATE_FORMAT() function.\n \nTimestamps in MariaDB have a maximum value of 2147483647,\nequivalent to 2038-01-19 05:14:07. This is due to the\nunderlying 32-bit limitation. Using the function on a\ntimestamp beyond this will result in NULL being returned.\nUse DATETIME as a storage type if you require dates beyond\nthis.\n \nThe options that can be used by FROM_UNIXTIME(), as well as\nDATE_FORMAT() and STR_TO_DATE(), are:\n \nOption | Description | \n \n%a | Short weekday name in current locale (Variable\nlc_time_names). | \n \n%b | Short form month name in current locale. For locale\nen_US this is one of:\nJan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov or Dec. | \n \n%c | Month with 1 or 2 digits. | \n \n%D | Day with English suffix \'th\', \'nd\', \'st\' or\n\'rd\'\'. (1st, 2nd, 3rd...). | \n \n%d | Day with 2 digits. | \n \n%e | Day with 1 or 2 digits. | \n \n%f | Sub seconds 6 digits. | \n \n%H | Hour with 2 digits between 00-23. | \n \n%h | Hour with 2 digits between 01-12. | \n \n%I | Hour with 2 digits between 01-12. | \n \n%i | Minute with 2 digits. | \n \n%j | Day of the year (001-366) | \n \n%k | Hour with 1 digits between 0-23. | \n \n%l | Hour with 1 digits between 1-12. | \n \n%M | Full month name in current locale (Variable\nlc_time_names). | \n \n%m | Month with 2 digits. | \n \n%p | AM/PM according to current locale (Variable\nlc_time_names). | \n \n%r | Time in 12 hour format, followed by AM/PM. Short for\n\'%I:%i:%S %p\'. | \n \n%S | Seconds with 2 digits. | \n \n%s | Seconds with 2 digits. | \n \n%T | Time in 24 hour format. Short for \'%H:%i:%S\'. | \n \n%U | Week number (00-53), when first day of the week is\nSunday. | \n \n%u | Week number (00-53), when first day of the week is\nMonday. | \n \n%V | Week number (01-53), when first day of the week is\nSunday. Used with %X. | \n \n%v | Week number (01-53), when first day of the week is\nMonday. Used with %x. | \n \n%W | Full weekday name in current locale (Variable\nlc_time_names). | \n \n%w | Day of the week. 0 = Sunday, 1 = Saturday. | \n \n%X | Year with 4 digits when first day of the week is\nSunday. Used with %V. | \n \n%x | Year with 4 digits when first day of the week is\nSunday. Used with %v. | \n \n%Y | Year with 4 digits. | \n \n%y | Year with 2 digits. | \n \n%# | For str_to_date(), skip all numbers. | \n \n%. | For str_to_date(), skip all punctation characters. | \n \n%@ | For str_to_date(), skip all alpha characters. | \n \n%% | A literal % character. | \n \nPerformance Considerations\n \nIf your session time zone is set to SYSTEM (the default),\nFROM_UNIXTIME() will call the OS function to convert the\ndata using the system time zone. At least on Linux, the\ncorresponding function (localtime_r) uses a global mutex\ninside glibc that can cause contention under high concurrent\nload.\n \nSet your time zone to a named time zone to avoid this issue.\nSee mysql time zone tables for details on how to do this.\n \nExamples\n-------- \nSELECT FROM_UNIXTIME(1196440219);\n+---------------------------+\n| FROM_UNIXTIME(1196440219) |\n+---------------------------+\n| 2007-11-30 11:30:19 |\n+---------------------------+\n \nSELECT FROM_UNIXTIME(1196440219) + 0;\n \n+-------------------------------+\n| FROM_UNIXTIME(1196440219) + 0 |\n+-------------------------------+\n| 20071130113019.000000 |\n+-------------------------------+\n \nSELECT FROM_UNIXTIME(UNIX_TIMESTAMP(), \'%Y %D %M %h:%i:%s\n%x\');\n+---------------------------------------------------------+\n| FROM_UNIXTIME(UNIX_TIMESTAMP(), \'%Y %D %M %h:%i:%s %x\')\n|\n+---------------------------------------------------------+\n| 2010 27th March 01:03:47 2010 |\n+---------------------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/from_unixtime/','','https://mariadb.com/kb/en/library/from_unixtime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (486,31,'GET_FORMAT','Syntax\n------ \nGET_FORMAT({DATE|DATETIME|TIME},\n{\'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\'})\n \nDescription\n----------- \nReturns a format string. This function is useful in\ncombination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n \nPossible result formats are:\n \nFunction Call | Result Format | \n \nGET_FORMAT(DATE,\'EUR\') | \'%d.%m.%Y\' | \n \nGET_FORMAT(DATE,\'USA\') | \'%m.%d.%Y\' | \n \nGET_FORMAT(DATE,\'JIS\') | \'%Y-%m-%d\' | \n \nGET_FORMAT(DATE,\'ISO\') | \'%Y-%m-%d\' | \n \nGET_FORMAT(DATE,\'INTERNAL\') | \'%Y%m%d\' | \n \nGET_FORMAT(DATETIME,\'EUR\') | \'%Y-%m-%d %H.%i.%s\' | \n \nGET_FORMAT(DATETIME,\'USA\') | \'%Y-%m-%d %H.%i.%s\' | \n \nGET_FORMAT(DATETIME,\'JIS\') | \'%Y-%m-%d %H:%i:%s\' | \n \nGET_FORMAT(DATETIME,\'ISO\') | \'%Y-%m-%d %H:%i:%s\' | \n \nGET_FORMAT(DATETIME,\'INTERNAL\') | \'%Y%m%d%H%i%s\' | \n \nGET_FORMAT(TIME,\'EUR\') | \'%H.%i.%s\' | \n \nGET_FORMAT(TIME,\'USA\') | \'%h:%i:%s %p\' | \n \nGET_FORMAT(TIME,\'JIS\') | \'%H:%i:%s\' | \n \nGET_FORMAT(TIME,\'ISO\') | \'%H:%i:%s\' | \n \nGET_FORMAT(TIME,\'INTERNAL\') | \'%H%i%s\' | \n \nExamples\n-------- \nObtaining the string matching to the standard European date\nformat:\n \nSELECT GET_FORMAT(DATE, \'EUR\');\n+-------------------------+\n| GET_FORMAT(DATE, \'EUR\') |\n+-------------------------+\n| %d.%m.%Y |\n+-------------------------+\n \nUsing the same string to format a date:\n \nSELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n+--------------------------------------------------+\n| DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\')) |\n+--------------------------------------------------+\n| 03.10.2003 |\n+--------------------------------------------------+\n \nSELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n+--------------------------------------------------+\n| STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\')) |\n+--------------------------------------------------+\n| 2003-10-31 |\n+--------------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/get_format/','','https://mariadb.com/kb/en/library/get_format/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (487,31,'HOUR','Syntax\n------ \nHOUR(time)\n \nDescription\n----------- \nReturns the hour for time. The range of the return value is\n0 to 23\nfor time-of-day values. However, the range of TIME values\nactually is\nmuch larger, so HOUR can return values greater than 23.\n \nThe return value is always positive, even if a negative TIME\nvalue is provided.\n \nExamples\n-------- \nSELECT HOUR(\'10:05:03\');\n+------------------+\n| HOUR(\'10:05:03\') |\n+------------------+\n| 10 |\n+------------------+\n \nSELECT HOUR(\'272:59:59\');\n+-------------------+\n| HOUR(\'272:59:59\') |\n+-------------------+\n| 272 |\n+-------------------+\n \nDifference between EXTRACT (HOUR FROM ...) (>= MariaDB\n10.0.7 and MariaDB 5.5.35) and HOUR:\n \nSELECT EXTRACT(HOUR FROM \'26:30:00\'), HOUR(\'26:30:00\');\n+-------------------------------+------------------+\n| EXTRACT(HOUR FROM \'26:30:00\') | HOUR(\'26:30:00\') |\n+-------------------------------+------------------+\n| 2 | 26 |\n+-------------------------------+------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/hour/','','https://mariadb.com/kb/en/library/hour/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (488,31,'LAST_DAY','Syntax\n------ \nLAST_DAY(date)\n \nDescription\n----------- \nTakes a date or datetime value and returns the corresponding\nvalue for\nthe last day of the month. Returns NULL if the argument is\ninvalid.\n \nExamples\n-------- \nSELECT LAST_DAY(\'2003-02-05\');\n+------------------------+\n| LAST_DAY(\'2003-02-05\') |\n+------------------------+\n| 2003-02-28 |\n+------------------------+\n \nSELECT LAST_DAY(\'2004-02-05\');\n+------------------------+\n| LAST_DAY(\'2004-02-05\') |\n+------------------------+\n| 2004-02-29 |\n+------------------------+\n \nSELECT LAST_DAY(\'2004-01-01 01:01:01\');\n+---------------------------------+\n| LAST_DAY(\'2004-01-01 01:01:01\') |\n+---------------------------------+\n| 2004-01-31 |\n+---------------------------------+\n \nSELECT LAST_DAY(\'2003-03-32\');\n+------------------------+\n| LAST_DAY(\'2003-03-32\') |\n+------------------------+\n| NULL |\n+------------------------+\n1 row in set, 1 warning (0.00 sec)\n \nWarning (Code 1292): Incorrect datetime value:\n\'2003-03-32\'\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/last_day/','','https://mariadb.com/kb/en/library/last_day/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (489,31,'LOCALTIME','Syntax\n------ \nLOCALTIME\nLOCALTIME([precision])\n \nDescription\n----------- \nLOCALTIME and LOCALTIME() are synonyms for NOW().\n \n\n\nURL: https://mariadb.com/kb/en/library/localtime/','','https://mariadb.com/kb/en/library/localtime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (490,31,'LOCALTIMESTAMP','Syntax\n------ \nLOCALTIMESTAMP\nLOCALTIMESTAMP([precision])\n \nDescription\n----------- \nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n \n\n\nURL: https://mariadb.com/kb/en/library/localtimestamp/','','https://mariadb.com/kb/en/library/localtimestamp/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (491,31,'MAKEDATE','Syntax\n------ \nMAKEDATE(year,dayofyear)\n \nDescription\n----------- \nReturns a date, given year and day-of-year values. dayofyear\nmust be\ngreater than 0 or the result is NULL.\n \nExamples\n-------- \nSELECT MAKEDATE(2011,31), MAKEDATE(2011,32);\n+-------------------+-------------------+\n| MAKEDATE(2011,31) | MAKEDATE(2011,32) |\n+-------------------+-------------------+\n| 2011-01-31 | 2011-02-01 |\n+-------------------+-------------------+\n \nSELECT MAKEDATE(2011,365), MAKEDATE(2014,365);\n+--------------------+--------------------+\n| MAKEDATE(2011,365) | MAKEDATE(2014,365) |\n+--------------------+--------------------+\n| 2011-12-31 | 2014-12-31 |\n+--------------------+--------------------+\n \nSELECT MAKEDATE(2011,0);\n+------------------+\n| MAKEDATE(2011,0) |\n+------------------+\n| NULL |\n+------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/makedate/','','https://mariadb.com/kb/en/library/makedate/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (492,31,'MAKETIME','Syntax\n------ \nMAKETIME(hour,minute,second)\n \nDescription\n----------- \nReturns a time value calculated from the hour, minute, and\nsecond arguments.\n \nIf minute or second are out of the range 0 to 60, NULL is\nreturned. The hour can be in the range -838 to 838, outside\nof which the value is truncated with a warning.\n \nExamples\n-------- \nSELECT MAKETIME(13,57,33);\n+--------------------+\n| MAKETIME(13,57,33) |\n+--------------------+\n| 13:57:33 |\n+--------------------+\n \nSELECT MAKETIME(-13,57,33);\n+---------------------+\n| MAKETIME(-13,57,33) |\n+---------------------+\n| -13:57:33 |\n+---------------------+\n \nSELECT MAKETIME(13,67,33);\n+--------------------+\n| MAKETIME(13,67,33) |\n+--------------------+\n| NULL |\n+--------------------+\n \nSELECT MAKETIME(-1000,57,33);\n+-----------------------+\n| MAKETIME(-1000,57,33) |\n+-----------------------+\n| -838:59:59 |\n+-----------------------+\n1 row in set, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+---------+------+-----------------------------------------------+\n| Level | Code | Message |\n+---------+------+-----------------------------------------------+\n| Warning | 1292 | Truncated incorrect time value:\n\'-1000:57:33\' |\n+---------+------+-----------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/maketime/','','https://mariadb.com/kb/en/library/maketime/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (493,31,'MICROSECOND','Syntax\n------ \nMICROSECOND(expr)\n \nDescription\n----------- \nReturns the microseconds from the time or datetime\nexpression expr as a number in the range from 0 to 999999.\n \nIf expr is a time with no microseconds, zero is returned,\nwhile if expr is a date with no time, zero with a warning is\nreturned.\n \nExamples\n-------- \nSELECT MICROSECOND(\'12:00:00.123456\');\n+--------------------------------+\n| MICROSECOND(\'12:00:00.123456\') |\n+--------------------------------+\n| 123456 |\n+--------------------------------+\n \nSELECT MICROSECOND(\'2009-12-31 23:59:59.000010\');\n+-------------------------------------------+\n| MICROSECOND(\'2009-12-31 23:59:59.000010\') |\n+-------------------------------------------+\n| 10 |\n+-------------------------------------------+\n \nSELECT MICROSECOND(\'2013-08-07 12:13:14\');\n+------------------------------------+\n| MICROSECOND(\'2013-08-07 12:13:14\') |\n+------------------------------------+\n| 0 |\n+------------------------------------+\n \nSELECT MICROSECOND(\'2013-08-07\');\n+---------------------------+\n| MICROSECOND(\'2013-08-07\') |\n+---------------------------+\n| 0 |\n+---------------------------+\n1 row in set, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+---------+------+----------------------------------------------+\n| Level | Code | Message |\n+---------+------+----------------------------------------------+\n| Warning | 1292 | Truncated incorrect time value:\n\'2013-08-07\' |\n+---------+------+----------------------------------------------+\n \n\n\nURL: https://mariadb.com/kb/en/library/microsecond/','','https://mariadb.com/kb/en/library/microsecond/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (494,31,'MINUTE','Syntax\n------ \nMINUTE(time)\n \nDescription\n----------- \nReturns the minute for time, in the range 0 to 59. \n \nExamples\n-------- \nSELECT MINUTE(\'2013-08-03 11:04:03\');\n+-------------------------------+\n| MINUTE(\'2013-08-03 11:04:03\') |\n+-------------------------------+\n| 4 |\n+-------------------------------+\n \n SELECT MINUTE (\'23:12:50\');\n+---------------------+\n| MINUTE (\'23:12:50\') |\n+---------------------+\n| 12 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/minute/','','https://mariadb.com/kb/en/library/minute/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (495,31,'MONTH','Syntax\n------ \nMONTH(date)\n \nDescription\n----------- \nReturns the month for date in the range 1 to 12 for January\nto\nDecember, or 0 for dates such as \'0000-00-00\' or\n\'2008-00-00\' that\nhave a zero month part.\n \nExamples\n-------- \nSELECT MONTH(\'2019-01-03\');\n+---------------------+\n| MONTH(\'2019-01-03\') |\n+---------------------+\n| 1 |\n+---------------------+\n \nSELECT MONTH(\'2019-00-03\');\n+---------------------+\n| MONTH(\'2019-00-03\') |\n+---------------------+\n| 0 |\n+---------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/month/','','https://mariadb.com/kb/en/library/month/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (496,31,'MONTHNAME','Syntax\n------ \nMONTHNAME(date)\n \nDescription\n----------- \nReturns the full name of the month for date. The language\nused for the name is controlled by the value of the\nlc_time_names system variable. See server locale for more on\nthe supported locales.\n \nExamples\n-------- \nSELECT MONTHNAME(\'2019-02-03\');\n+-------------------------+\n| MONTHNAME(\'2019-02-03\') |\n+-------------------------+\n| February |\n+-------------------------+\n \nChanging the locale:\n \nSET lc_time_names = \'fr_CA\';\n \nSELECT MONTHNAME(\'2019-05-21\');\n+-------------------------+\n| MONTHNAME(\'2019-05-21\') |\n+-------------------------+\n| mai |\n+-------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/monthname/','','https://mariadb.com/kb/en/library/monthname/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (497,31,'NOW','Syntax\n------ \nNOW([precision])\nCURRENT_TIMESTAMP\nCURRENT_TIMESTAMP([precision])\nLOCALTIME, LOCALTIME([precision])\nLOCALTIMESTAMP\nLOCALTIMESTAMP([precision])\n \nDescription\n----------- \nReturns the current date and time as a value in \'YYYY-MM-DD\nHH:MM:SS\'\nor YYYYMMDDHHMMSS.uuuuuu format, depending on whether the\nfunction is\nused in a string or numeric context. The value is expressed\nin the\ncurrent time zone.\n \nThe optional precision determines the microsecond precision.\nSee Microseconds in MariaDB.\n \nNOW() (or its synonyms) can be used as the default value for\nTIMESTAMP columns as well as, since MariaDB 10.0.1, DATETIME\ncolumns. Before MariaDB 10.0.1, it was only possible for a\nsingle TIMESTAMP column per table to contain the\nCURRENT_TIMESTAMP as its default.\n \nWhen displayed in the INFORMATION_SCHEMA.COLUMNS table, a\ndefault CURRENT TIMESTAMP is displayed as CURRENT_TIMESTAMP\nup until MariaDB 10.2.2, and as current_timestamp() from\nMariaDB 10.2.3, due to to MariaDB 10.2 accepting expressions\nin the DEFAULT clause.\n \nExamples\n-------- \nSELECT NOW();\n+---------------------+\n| NOW() |\n+---------------------+\n| 2010-03-27 13:13:25 |\n+---------------------+\n \nSELECT NOW() + 0;\n \n+-----------------------+\n| NOW() + 0 |\n+-----------------------+\n| 20100327131329.000000 |\n+-----------------------+\n \nWith precision:\n \nSELECT CURRENT_TIMESTAMP(2);\n+------------------------+\n| CURRENT_TIMESTAMP(2) |\n+------------------------+\n| 2018-07-10 09:47:26.24 |\n+------------------------+\n \nUsed as a default TIMESTAMP:\n \nCREATE TABLE t (createdTS TIMESTAMP NOT NULL DEFAULT\nCURRENT_TIMESTAMP);\n \nFrom MariaDB 10.2.2:\n \nSELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE\nTABLE_SCHEMA=\'test\'\n AND COLUMN_NAME LIKE \'%ts%\'\\G\n*************************** 1. row\n***************************\n TABLE_CATALOG: def\n TABLE_SCHEMA: test\n TABLE_NAME: t\n COLUMN_NAME: ts\n ORDINAL_POSITION: 1\n COLUMN_DEFAULT: current_timestamp()\n...\n \n\n\nURL: https://mariadb.com/kb/en/library/now/','','https://mariadb.com/kb/en/library/now/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (498,31,'PERIOD_ADD','Syntax\n------ \nPERIOD_ADD(P,N)\n \nDescription\n----------- \nAdds N months to period P. P is in the format YYMM or\nYYYYMM, and is not a date value. If P contains a two-digit\nyear, values from 00 to 69 are converted to from 2000 to\n2069, while values from 70 are converted to 1970 upwards.\n \nReturns a value in the format YYYYMM.\n \nExamples\n-------- \nSELECT PERIOD_ADD(200801,2);\n+----------------------+\n| PERIOD_ADD(200801,2) |\n+----------------------+\n| 200803 |\n+----------------------+\n \nSELECT PERIOD_ADD(6910,2);\n+--------------------+\n| PERIOD_ADD(6910,2) |\n+--------------------+\n| 206912 |\n+--------------------+\n \nSELECT PERIOD_ADD(7010,2);\n+--------------------+\n| PERIOD_ADD(7010,2) |\n+--------------------+\n| 197012 |\n+--------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/period_add/','','https://mariadb.com/kb/en/library/period_add/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (499,31,'PERIOD_DIFF','Syntax\n------ \nPERIOD_DIFF(P1,P2)\n \nDescription\n----------- \nReturns the number of months between periods P1 and P2. P1\nand P2 \ncan be in the format YYMM or YYYYMM, and are not date\nvalues.\n \nIf P1 or P2 contains a two-digit year, values from 00 to 69\nare converted to from 2000 to 2069, while values from 70 are\nconverted to 1970 upwards.\n \nExamples\n-------- \nSELECT PERIOD_DIFF(200802,200703);\n+----------------------------+\n| PERIOD_DIFF(200802,200703) |\n+----------------------------+\n| 11 |\n+----------------------------+\n \nSELECT PERIOD_DIFF(6902,6803);\n+------------------------+\n| PERIOD_DIFF(6902,6803) |\n+------------------------+\n| 11 |\n+------------------------+\n \nSELECT PERIOD_DIFF(7002,6803);\n+------------------------+\n| PERIOD_DIFF(7002,6803) |\n+------------------------+\n| -1177 |\n+------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/period_diff/','','https://mariadb.com/kb/en/library/period_diff/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (500,31,'QUARTER','Syntax\n------ \nQUARTER(date)\n \nDescription\n----------- \nReturns the quarter of the year for date, in the range 1 to\n4. Returns 0 if month contains a zero value, or NULL if the\ngiven value is not otherwise a valid date (zero values are\naccepted).\n \nExamples\n-------- \nSELECT QUARTER(\'2008-04-01\');\n+-----------------------+\n| QUARTER(\'2008-04-01\') |\n+-----------------------+\n| 2 |\n+-----------------------+\n \nSELECT QUARTER(\'2019-00-01\');\n+-----------------------+\n| QUARTER(\'2019-00-01\') |\n+-----------------------+\n| 0 |\n+-----------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/quarter/','','https://mariadb.com/kb/en/library/quarter/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (501,31,'SECOND','Syntax\n------ \nSECOND(time)\n \nDescription\n----------- \nReturns the second for a given time (which can include\nmicroseconds), in the range 0 to 59, or NULL if not given a\nvalid time value.\n \nExamples\n-------- \nSELECT SECOND(\'10:05:03\');\n+--------------------+\n| SECOND(\'10:05:03\') |\n+--------------------+\n| 3 |\n+--------------------+\n \nSELECT SECOND(\'10:05:01.999999\');\n+---------------------------+\n| SECOND(\'10:05:01.999999\') |\n+---------------------------+\n| 1 |\n+---------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/second/','','https://mariadb.com/kb/en/library/second/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (502,31,'SEC_TO_TIME','Syntax\n------ \nSEC_TO_TIME(seconds)\n \nDescription\n----------- \nReturns the seconds argument, converted to hours, minutes,\nand\nseconds, as a TIME value. The range of the result is\nconstrained to\nthat of the TIME data type. A warning occurs if the argument\ncorresponds to a value outside that range.\n \nThe time will be returned in the format hh:mm:ss, or hhmmss\nif used in a numeric calculation.\n \nExamples\n-------- \nSELECT SEC_TO_TIME(12414);\n+--------------------+\n| SEC_TO_TIME(12414) |\n+--------------------+\n| 03:26:54 |\n+--------------------+\n \nSELECT SEC_TO_TIME(12414)+0;\n \n+----------------------+\n| SEC_TO_TIME(12414)+0 |\n+----------------------+\n| 32654 |\n+----------------------+\n \nSELECT SEC_TO_TIME(9999999);\n+----------------------+\n| SEC_TO_TIME(9999999) |\n+----------------------+\n| 838:59:59 |\n+----------------------+\n1 row in set, 1 warning (0.00 sec)\n \nSHOW WARNINGS;\n \n+---------+------+-------------------------------------------+\n| Level | Code | Message |\n+---------+------+-------------------------------------------+\n| Warning | 1292 | Truncated incorrect time value:\n\'9999999\' |\n+---------+------+-------------------------------------------+\n \n\n \n \n \n \n \n \n \n\nURL: https://mariadb.com/kb/en/library/sec_to_time/','','https://mariadb.com/kb/en/library/sec_to_time/');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (503,31,'STR_TO_DATE','Syntax\n------ \nSTR_TO_DATE(str,format)\n \nDescription\n----------- \nThis is the inverse of the DATE_FORMAT() function. It takes\na string str and a format string format. STR_TO_DATE()\nreturns a\nDATETIME value if the format string contains both date and\ntime parts, or a\nDATE or TIME value if the string contains only date or time\nparts.\n \nThe date, time, or datetime values contained in str should\nbe given in the format indicated by format. If str contains\nan illegal date, time, or datetime value, STR_TO_DATE()\nreturns NULL. An illegal value also produces a warning.\n \nThe options that can be used by STR_TO_DATE(), as well as\nits inverse DATE_FORMAT() and the FROM_UNIXTIME() function,\nare:\n \nOption | Description | \n \n%a | Short weekday name in current locale (Variable\nlc_time_names). | \n \n%b | Short form month name in current locale. For locale\nen_US this is one of:\nJan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov or Dec. | \n \n%c | Month with 1 or 2 digits. | \n \n%D | Day with English suffix \'th\', \'nd\', \'st\' or\n\'rd\'\'. (1st, 2nd, 3rd...). | \n \n%d | Day with 2 digits. | \n \n%e | Day with 1 or 2 digits. | \n \n%f | Sub seconds 6 digits. | \n \n%H | Hour with 2 digits between 00-23. | \n \n%h | Hour with 2 digits between 01-12. | \n \n%I | Hour with 2 digits between 01-12. | \n \n%i | Minute with 2 digits. | \n \n%j | Day of the year (001-366) | \n \n%k | Hour with 1 digits between 0-23. | \n \n%l | Hour with 1 digits between 1-12. | \n \n%M | Full month name in current